/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.s7.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class AlarmMessageObjectAckType implements Message {

  // Constant values.
  public static final Short VARIABLESPEC = 0x12;
  public static final Short LENGTH = 0x08;

  // Properties.
  protected final SyntaxIdType syntaxId;
  protected final short numberOfValues;
  protected final long eventId;
  protected final State ackStateGoing;
  protected final State ackStateComing;

  public AlarmMessageObjectAckType(
      SyntaxIdType syntaxId,
      short numberOfValues,
      long eventId,
      State ackStateGoing,
      State ackStateComing) {
    super();
    this.syntaxId = syntaxId;
    this.numberOfValues = numberOfValues;
    this.eventId = eventId;
    this.ackStateGoing = ackStateGoing;
    this.ackStateComing = ackStateComing;
  }

  public SyntaxIdType getSyntaxId() {
    return syntaxId;
  }

  public short getNumberOfValues() {
    return numberOfValues;
  }

  public long getEventId() {
    return eventId;
  }

  public State getAckStateGoing() {
    return ackStateGoing;
  }

  public State getAckStateComing() {
    return ackStateComing;
  }

  public short getVariableSpec() {
    return VARIABLESPEC;
  }

  public short getLength() {
    return LENGTH;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("AlarmMessageObjectAckType");

    // Const Field (variableSpec)
    writeConstField("variableSpec", VARIABLESPEC, writeUnsignedShort(writeBuffer, 8));

    // Const Field (length)
    writeConstField("length", LENGTH, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (syntaxId)
    writeSimpleEnumField(
        "syntaxId",
        "SyntaxIdType",
        syntaxId,
        writeEnum(SyntaxIdType::getValue, SyntaxIdType::name, writeUnsignedShort(writeBuffer, 8)));

    // Simple Field (numberOfValues)
    writeSimpleField("numberOfValues", numberOfValues, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (eventId)
    writeSimpleField("eventId", eventId, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (ackStateGoing)
    writeSimpleField("ackStateGoing", ackStateGoing, writeComplex(writeBuffer));

    // Simple Field (ackStateComing)
    writeSimpleField("ackStateComing", ackStateComing, writeComplex(writeBuffer));

    writeBuffer.popContext("AlarmMessageObjectAckType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    AlarmMessageObjectAckType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Const Field (variableSpec)
    lengthInBits += 8;

    // Const Field (length)
    lengthInBits += 8;

    // Simple field (syntaxId)
    lengthInBits += 8;

    // Simple field (numberOfValues)
    lengthInBits += 8;

    // Simple field (eventId)
    lengthInBits += 32;

    // Simple field (ackStateGoing)
    lengthInBits += ackStateGoing.getLengthInBits();

    // Simple field (ackStateComing)
    lengthInBits += ackStateComing.getLengthInBits();

    return lengthInBits;
  }

  public static AlarmMessageObjectAckType staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("AlarmMessageObjectAckType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short variableSpec =
        readConstField(
            "variableSpec",
            readUnsignedShort(readBuffer, 8),
            AlarmMessageObjectAckType.VARIABLESPEC);

    short length =
        readConstField(
            "length", readUnsignedShort(readBuffer, 8), AlarmMessageObjectAckType.LENGTH);

    SyntaxIdType syntaxId =
        readEnumField(
            "syntaxId",
            "SyntaxIdType",
            readEnum(SyntaxIdType::enumForValue, readUnsignedShort(readBuffer, 8)));

    short numberOfValues = readSimpleField("numberOfValues", readUnsignedShort(readBuffer, 8));

    long eventId = readSimpleField("eventId", readUnsignedLong(readBuffer, 32));

    State ackStateGoing =
        readSimpleField(
            "ackStateGoing", readComplex(() -> State.staticParse(readBuffer), readBuffer));

    State ackStateComing =
        readSimpleField(
            "ackStateComing", readComplex(() -> State.staticParse(readBuffer), readBuffer));

    readBuffer.closeContext("AlarmMessageObjectAckType");
    // Create the instance
    AlarmMessageObjectAckType _alarmMessageObjectAckType;
    _alarmMessageObjectAckType =
        new AlarmMessageObjectAckType(
            syntaxId, numberOfValues, eventId, ackStateGoing, ackStateComing);
    return _alarmMessageObjectAckType;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof AlarmMessageObjectAckType)) {
      return false;
    }
    AlarmMessageObjectAckType that = (AlarmMessageObjectAckType) o;
    return (getSyntaxId() == that.getSyntaxId())
        && (getNumberOfValues() == that.getNumberOfValues())
        && (getEventId() == that.getEventId())
        && (getAckStateGoing() == that.getAckStateGoing())
        && (getAckStateComing() == that.getAckStateComing())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        getSyntaxId(), getNumberOfValues(), getEventId(), getAckStateGoing(), getAckStateComing());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
