/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

[type MediaTransportControlData
    //TODO: golang doesn't like checking for null so we use that static call to check that the enum is known
    [validation 'STATIC_CALL("knowsMediaTransportControlCommandTypeContainer", readBuffer)' "no command type could be found" shouldFail=false]
    [simple  MediaTransportControlCommandTypeContainer  commandTypeContainer                                   ]
    [virtual MediaTransportControlCommandType           commandType          'commandTypeContainer.commandType']
    [simple  byte                                       mediaLinkGroup                                         ]
    [typeSwitch commandType
        ['STOP'             *Stop
        ]
        ['PLAY'             *Play
        ]
        ['PAUSE_RESUME'     *PauseResume
            [simple  byte   operation                       ]
            [virtual bit    isPause   'operation == 0x00'   ]
            [virtual bit    isResume  'operation > 0xFE'    ]
        ]
        ['SELECT_CATEGORY'  *SetCategory
            [simple  uint 8 categoryNumber                  ]
        ]
        ['SELECT_SELECTION'  *SetSelection
            [simple  byte   selectionHi                     ]
            [simple  byte   selectionLo                     ]
        ]
        ['SELECT_TRACK'     *SetTrack
            [simple  byte   trackMSB                        ]
            [simple  byte   trackMMSB                       ]
            [simple  byte   trackMLSB                       ]
            [simple  byte   trackLSB                        ]
        ]
        ['SHUFFLE_ON_OFF'   *ShuffleOnOff
            [simple  byte   state                           ]
            [virtual bit    isOff     'state == 0x00'       ]
            [virtual bit    isOn      'state > 0xFE'        ]
        ]
        ['REPEAT_ON_OFF'    *RepeatOnOff
            [simple  byte   repeatType                            ]
            [virtual bit    isOff     'repeatType == 0x00'        ]
            [virtual bit    isRepeatCurrent     'repeatType > 0x00 && repeatType <= 0xFE'   ]
            [virtual bit    isRepeatTracks      'repeatType >= 0xFE'                        ]
        ]
        ['NEXT_PREVIOUS_CATEGORY'   *NextPreviousCategory
            [simple  byte   operation                       ]
            [virtual bit    isSetThePreviousCategory    'operation == 0x00'     ]
            [virtual bit    isSetTheNextCategory        'operation != 0x00'     ]
        ]
        ['NEXT_PREVIOUS_SELECTION'  *NextPreviousSelection
            [simple  byte   operation                       ]
            [virtual bit    isSetThePreviousSelection   'operation == 0x00'     ]
            [virtual bit    isSetTheNextSelection       'operation != 0x00'     ]
        ]
        ['NEXT_PREVIOUS_TRACK'      *NextPreviousTrack
            [simple  byte   operation                       ]
            [virtual bit    isSetThePreviousTrack       'operation == 0x00'     ]
            [virtual bit    isSetTheNextTrack           'operation != 0x00'     ]
        ]
        ['FAST_FORWARD'             *FastForward
            [simple  byte   operation                       ]
            [virtual bit    isCeaseFastForward          'operation == 0x00'     ]
            [virtual bit    is2x                        'operation == 0x02'     ]
            [virtual bit    is4x                        'operation == 0x04'     ]
            [virtual bit    is8x                        'operation == 0x06'     ]
            [virtual bit    is16x                       'operation == 0x08'     ]
            [virtual bit    is32x                       'operation == 0x0A'     ]
            [virtual bit    is64x                       'operation == 0x0C'     ]
            [virtual bit    isReserved                  '!isCeaseFastForward && !is2x && !is4x && !is8x && !is16x && !is32x && !is64x'     ]
        ]
        ['REWIND'                   *Rewind
            [simple  byte   operation                       ]
            [virtual bit    isCeaseRewind               'operation == 0x00'     ]
            [virtual bit    is2x                        'operation == 0x02'     ]
            [virtual bit    is4x                        'operation == 0x04'     ]
            [virtual bit    is8x                        'operation == 0x06'     ]
            [virtual bit    is16x                       'operation == 0x08'     ]
            [virtual bit    is32x                       'operation == 0x0A'     ]
            [virtual bit    is64x                       'operation == 0x0C'     ]
            [virtual bit    isReserved                  '!isCeaseRewind && !is2x && !is4x && !is8x && !is16x && !is32x && !is64x'     ]
        ]
        ['SOURCE_POWER_CONTROL'     *SourcePowerControl
            [simple  byte   state                                           ]
            [virtual bit    isShouldPowerOn             'state == 0x00'     ]
            [virtual bit    isShouldPowerOff            'state != 0x00'     ]
        ]
        ['TOTAL_TRACKS'     *TotalTracks
            [simple  byte   totalTracksMSB      ]
            [simple  byte   totalTracksMMSB     ]
            [simple  byte   totalTracksMLSB     ]
            [simple  byte   totalTracksLSB      ]
        ]
        ['STATUS_REQUEST'   *StatusRequest
        ]
        ['ENUMERATE_CATEGORIES_SELECTIONS_TRACKS' *EnumerateCategoriesSelectionTracks
            [simple  byte   enumerateType                                  ]
            [virtual bit    isListCategories    'enumerateType == 0x00'    ]
            [virtual bit    isListSelections    'enumerateType == 0x01'    ]
            [virtual bit    isListTracks        'enumerateType == 0x02'    ]
            [virtual bit    isReserved          '!isListCategories && !isListSelections && !isListTracks'      ]
            [simple  uint 8 start                                       ]
        ]
        ['ENUMERATION_SIZE' *EnumerationsSize
            [simple  byte   sizeType                                    ]
            [virtual bit    isListCategories    'sizeType == 0x00'      ]
            [virtual bit    isListSelections    'sizeType == 0x01'      ]
            [virtual bit    isListTracks        'sizeType == 0x02'      ]
            [virtual bit    isReserved          '!isListCategories && !isListSelections && !isListTracks'      ]
            [simple  uint 8 start                                       ]
            [simple  uint 8 size                                        ]
        ]
        ['TRACK_NAME'       *TrackName(MediaTransportControlCommandTypeContainer commandTypeContainer)
             [simple vstring '(commandTypeContainer.numBytes-1)*8' trackName                                    ]
        ]
        ['SELECTION_NAME'   *SelectionName(MediaTransportControlCommandTypeContainer commandTypeContainer)
             [simple vstring '(commandTypeContainer.numBytes-1)*8' selectionName                                ]
        ]
        ['CATEGORY_NAME'    *CategoryName(MediaTransportControlCommandTypeContainer commandTypeContainer)
             [simple vstring '(commandTypeContainer.numBytes-1)*8' categoryName                                 ]
        ]
    ]
]

[enum uint 8 MediaTransportControlCommandTypeContainer(MediaTransportControlCommandType commandType, uint 5 numBytes)
    ['0x01' MediaTransportControlCommandStop                                ['STOP',                                    '1']]
    ['0x79' MediaTransportControlCommandPlay                                ['PLAY',                                    '1']]
    ['0x0A' MediaTransportControlCommandPauseResume                         ['PAUSE_RESUME',                            '2']]
    ['0x12' MediaTransportControlCommandSelectCategory                      ['SELECT_CATEGORY',                         '2']]
    ['0x1B' MediaTransportControlCommandSelectSelection                     ['SELECT_SELECTION',                        '3']]
    ['0x25' MediaTransportControlCommandSelectTrack                         ['SELECT_TRACK',                            '5']]
    ['0x2A' MediaTransportControlCommandShuffleOnOff                        ['SHUFFLE_ON_OFF',                          '2']]
    ['0x32' MediaTransportControlCommandRepeatOnOff                         ['REPEAT_ON_OFF',                           '2']]
    ['0x3A' MediaTransportControlCommandNextPreviousCategory                ['NEXT_PREVIOUS_CATEGORY',                  '2']]
    ['0x42' MediaTransportControlCommandNextPreviousSelection               ['NEXT_PREVIOUS_SELECTION',                 '2']]
    ['0x4A' MediaTransportControlCommandNextPreviousTrack                   ['NEXT_PREVIOUS_TRACK',                     '2']]
    ['0x52' MediaTransportControlCommandFastForward                         ['FAST_FORWARD',                            '2']]
    ['0x5A' MediaTransportControlCommandRewind                              ['REWIND',                                  '2']]
    ['0x62' MediaTransportControlCommandSourcePowerControl                  ['SOURCE_POWER_CONTROL',                    '2']]
    ['0x6D' MediaTransportControlCommandTotalTracks                         ['TOTAL_TRACKS',                            '5']]
    ['0x71' MediaTransportControlCommandStatusRequest                       ['STATUS_REQUEST',                          '1']]
    ['0x73' MediaTransportControlCommandEnumerateCategoriesSelectionsTracks ['ENUMERATE_CATEGORIES_SELECTIONS_TRACKS',  '3']]
    ['0x74' MediaTransportControlCommandEnumerationSize                     ['ENUMERATION_SIZE',                        '4']]
    ['0x80' MediaTransportControlCommandTrackName_0Bytes                    ['TRACK_NAME',                              '0']]
    ['0x81' MediaTransportControlCommandTrackName_1Bytes                    ['TRACK_NAME',                              '1']]
    ['0x82' MediaTransportControlCommandTrackName_2Bytes                    ['TRACK_NAME',                              '2']]
    ['0x83' MediaTransportControlCommandTrackName_3Bytes                    ['TRACK_NAME',                              '3']]
    ['0x84' MediaTransportControlCommandTrackName_4Bytes                    ['TRACK_NAME',                              '4']]
    ['0x85' MediaTransportControlCommandTrackName_5Bytes                    ['TRACK_NAME',                              '5']]
    ['0x86' MediaTransportControlCommandTrackName_6Bytes                    ['TRACK_NAME',                              '6']]
    ['0x87' MediaTransportControlCommandTrackName_7Bytes                    ['TRACK_NAME',                              '7']]
    ['0x88' MediaTransportControlCommandTrackName_8Bytes                    ['TRACK_NAME',                              '8']]
    ['0x89' MediaTransportControlCommandTrackName_9Bytes                    ['TRACK_NAME',                              '9']]
    ['0x8A' MediaTransportControlCommandTrackName_10Bytes                   ['TRACK_NAME',                             '10']]
    ['0x8B' MediaTransportControlCommandTrackName_11Bytes                   ['TRACK_NAME',                             '11']]
    ['0x8C' MediaTransportControlCommandTrackName_12Bytes                   ['TRACK_NAME',                             '12']]
    ['0x8D' MediaTransportControlCommandTrackName_13Bytes                   ['TRACK_NAME',                             '13']]
    ['0x8E' MediaTransportControlCommandTrackName_14Bytes                   ['TRACK_NAME',                             '14']]
    ['0x8F' MediaTransportControlCommandTrackName_15Bytes                   ['TRACK_NAME',                             '15']]
    ['0x90' MediaTransportControlCommandTrackName_16Bytes                   ['TRACK_NAME',                             '16']]
    ['0x91' MediaTransportControlCommandTrackName_17Bytes                   ['TRACK_NAME',                             '17']]
    ['0x92' MediaTransportControlCommandTrackName_18Bytes                   ['TRACK_NAME',                             '18']]
    ['0x93' MediaTransportControlCommandTrackName_19Bytes                   ['TRACK_NAME',                             '19']]
    ['0x94' MediaTransportControlCommandTrackName_20Bytes                   ['TRACK_NAME',                             '20']]
    ['0x95' MediaTransportControlCommandTrackName_21Bytes                   ['TRACK_NAME',                             '21']]
    ['0x96' MediaTransportControlCommandTrackName_22Bytes                   ['TRACK_NAME',                             '22']]
    ['0x97' MediaTransportControlCommandTrackName_23Bytes                   ['TRACK_NAME',                             '23']]
    ['0x98' MediaTransportControlCommandTrackName_24Bytes                   ['TRACK_NAME',                             '24']]
    ['0x99' MediaTransportControlCommandTrackName_25Bytes                   ['TRACK_NAME',                             '25']]
    ['0x9A' MediaTransportControlCommandTrackName_26Bytes                   ['TRACK_NAME',                             '26']]
    ['0x9B' MediaTransportControlCommandTrackName_27Bytes                   ['TRACK_NAME',                             '27']]
    ['0x9C' MediaTransportControlCommandTrackName_28Bytes                   ['TRACK_NAME',                             '28']]
    ['0x9D' MediaTransportControlCommandTrackName_29Bytes                   ['TRACK_NAME',                             '29']]
    ['0x9E' MediaTransportControlCommandTrackName_30Bytes                   ['TRACK_NAME',                             '30']]
    ['0x9F' MediaTransportControlCommandTrackName_31Bytes                   ['TRACK_NAME',                             '31']]
    ['0xA0' MediaTransportControlCommandSelectionName_0Bytes                ['SELECTION_NAME',                          '0']]
    ['0xA1' MediaTransportControlCommandSelectionName_1Bytes                ['SELECTION_NAME',                          '1']]
    ['0xA2' MediaTransportControlCommandSelectionName_2Bytes                ['SELECTION_NAME',                          '2']]
    ['0xA3' MediaTransportControlCommandSelectionName_3Bytes                ['SELECTION_NAME',                          '3']]
    ['0xA4' MediaTransportControlCommandSelectionName_4Bytes                ['SELECTION_NAME',                          '4']]
    ['0xA5' MediaTransportControlCommandSelectionName_5Bytes                ['SELECTION_NAME',                          '5']]
    ['0xA6' MediaTransportControlCommandSelectionName_6Bytes                ['SELECTION_NAME',                          '6']]
    ['0xA7' MediaTransportControlCommandSelectionName_7Bytes                ['SELECTION_NAME',                          '7']]
    ['0xA8' MediaTransportControlCommandSelectionName_8Bytes                ['SELECTION_NAME',                          '8']]
    ['0xA9' MediaTransportControlCommandSelectionName_9Bytes                ['SELECTION_NAME',                          '9']]
    ['0xAA' MediaTransportControlCommandSelectionName_10Bytes               ['SELECTION_NAME',                         '10']]
    ['0xAB' MediaTransportControlCommandSelectionName_11Bytes               ['SELECTION_NAME',                         '11']]
    ['0xAC' MediaTransportControlCommandSelectionName_12Bytes               ['SELECTION_NAME',                         '12']]
    ['0xAD' MediaTransportControlCommandSelectionName_13Bytes               ['SELECTION_NAME',                         '13']]
    ['0xAE' MediaTransportControlCommandSelectionName_14Bytes               ['SELECTION_NAME',                         '14']]
    ['0xAF' MediaTransportControlCommandSelectionName_15Bytes               ['SELECTION_NAME',                         '15']]
    ['0xB0' MediaTransportControlCommandSelectionName_16Bytes               ['SELECTION_NAME',                         '16']]
    ['0xB1' MediaTransportControlCommandSelectionName_17Bytes               ['SELECTION_NAME',                         '17']]
    ['0xB2' MediaTransportControlCommandSelectionName_18Bytes               ['SELECTION_NAME',                         '18']]
    ['0xB3' MediaTransportControlCommandSelectionName_19Bytes               ['SELECTION_NAME',                         '19']]
    ['0xB4' MediaTransportControlCommandSelectionName_20Bytes               ['SELECTION_NAME',                         '20']]
    ['0xB5' MediaTransportControlCommandSelectionName_21Bytes               ['SELECTION_NAME',                         '21']]
    ['0xB6' MediaTransportControlCommandSelectionName_22Bytes               ['SELECTION_NAME',                         '22']]
    ['0xB7' MediaTransportControlCommandSelectionName_23Bytes               ['SELECTION_NAME',                         '23']]
    ['0xB8' MediaTransportControlCommandSelectionName_24Bytes               ['SELECTION_NAME',                         '24']]
    ['0xB9' MediaTransportControlCommandSelectionName_25Bytes               ['SELECTION_NAME',                         '25']]
    ['0xBA' MediaTransportControlCommandSelectionName_26Bytes               ['SELECTION_NAME',                         '26']]
    ['0xBB' MediaTransportControlCommandSelectionName_27Bytes               ['SELECTION_NAME',                         '27']]
    ['0xBC' MediaTransportControlCommandSelectionName_28Bytes               ['SELECTION_NAME',                         '28']]
    ['0xBD' MediaTransportControlCommandSelectionName_29Bytes               ['SELECTION_NAME',                         '29']]
    ['0xBE' MediaTransportControlCommandSelectionName_30Bytes               ['SELECTION_NAME',                         '30']]
    ['0xBF' MediaTransportControlCommandSelectionName_31Bytes               ['SELECTION_NAME',                         '31']]
    ['0xC0' MediaTransportControlCommandCategoryName_0Bytes                 ['CATEGORY_NAME',                           '0']]
    ['0xC1' MediaTransportControlCommandCategoryName_1Bytes                 ['CATEGORY_NAME',                           '1']]
    ['0xC2' MediaTransportControlCommandCategoryName_2Bytes                 ['CATEGORY_NAME',                           '2']]
    ['0xC3' MediaTransportControlCommandCategoryName_3Bytes                 ['CATEGORY_NAME',                           '3']]
    ['0xC4' MediaTransportControlCommandCategoryName_4Bytes                 ['CATEGORY_NAME',                           '4']]
    ['0xC5' MediaTransportControlCommandCategoryName_5Bytes                 ['CATEGORY_NAME',                           '5']]
    ['0xC6' MediaTransportControlCommandCategoryName_6Bytes                 ['CATEGORY_NAME',                           '6']]
    ['0xC7' MediaTransportControlCommandCategoryName_7Bytes                 ['CATEGORY_NAME',                           '7']]
    ['0xC8' MediaTransportControlCommandCategoryName_8Bytes                 ['CATEGORY_NAME',                           '8']]
    ['0xC9' MediaTransportControlCommandCategoryName_9Bytes                 ['CATEGORY_NAME',                           '9']]
    ['0xCA' MediaTransportControlCommandCategoryName_10Bytes                ['CATEGORY_NAME',                          '10']]
    ['0xCB' MediaTransportControlCommandCategoryName_11Bytes                ['CATEGORY_NAME',                          '11']]
    ['0xCC' MediaTransportControlCommandCategoryName_12Bytes                ['CATEGORY_NAME',                          '12']]
    ['0xCD' MediaTransportControlCommandCategoryName_13Bytes                ['CATEGORY_NAME',                          '13']]
    ['0xCE' MediaTransportControlCommandCategoryName_14Bytes                ['CATEGORY_NAME',                          '14']]
    ['0xCF' MediaTransportControlCommandCategoryName_15Bytes                ['CATEGORY_NAME',                          '15']]
    ['0xD0' MediaTransportControlCommandCategoryName_16Bytes                ['CATEGORY_NAME',                          '16']]
    ['0xD1' MediaTransportControlCommandCategoryName_17Bytes                ['CATEGORY_NAME',                          '17']]
    ['0xD2' MediaTransportControlCommandCategoryName_18Bytes                ['CATEGORY_NAME',                          '18']]
    ['0xD3' MediaTransportControlCommandCategoryName_19Bytes                ['CATEGORY_NAME',                          '19']]
    ['0xD4' MediaTransportControlCommandCategoryName_20Bytes                ['CATEGORY_NAME',                          '20']]
    ['0xD5' MediaTransportControlCommandCategoryName_21Bytes                ['CATEGORY_NAME',                          '21']]
    ['0xD6' MediaTransportControlCommandCategoryName_22Bytes                ['CATEGORY_NAME',                          '22']]
    ['0xD7' MediaTransportControlCommandCategoryName_23Bytes                ['CATEGORY_NAME',                          '23']]
    ['0xD8' MediaTransportControlCommandCategoryName_24Bytes                ['CATEGORY_NAME',                          '24']]
    ['0xD9' MediaTransportControlCommandCategoryName_25Bytes                ['CATEGORY_NAME',                          '25']]
    ['0xDA' MediaTransportControlCommandCategoryName_26Bytes                ['CATEGORY_NAME',                          '26']]
    ['0xDB' MediaTransportControlCommandCategoryName_27Bytes                ['CATEGORY_NAME',                          '27']]
    ['0xDC' MediaTransportControlCommandCategoryName_28Bytes                ['CATEGORY_NAME',                          '28']]
    ['0xDD' MediaTransportControlCommandCategoryName_29Bytes                ['CATEGORY_NAME',                          '29']]
    ['0xDE' MediaTransportControlCommandCategoryName_30Bytes                ['CATEGORY_NAME',                          '30']]
    ['0xDF' MediaTransportControlCommandCategoryName_31Bytes                ['CATEGORY_NAME',                          '31']]
]

[enum uint 4 MediaTransportControlCommandType(uint 8 numberOfArguments)
    ['0x00' STOP                                    ['0']]
    ['0x01' PLAY                                    ['0']]
    ['0x02' PAUSE_RESUME                            ['1']]
    ['0x03' SELECT_CATEGORY                         ['1']]
    ['0x04' SELECT_SELECTION                        ['2']]
    ['0x05' SELECT_TRACK                            ['4']]
    ['0x06' SHUFFLE_ON_OFF                          ['1']]
    ['0x07' REPEAT_ON_OFF                           ['1']]
    ['0x08' NEXT_PREVIOUS_CATEGORY                  ['1']]
    ['0x09' NEXT_PREVIOUS_SELECTION                 ['1']]
    ['0x09' NEXT_PREVIOUS_TRACK                     ['1']]
    ['0x09' FAST_FORWARD                            ['1']]
    ['0x09' REWIND                                  ['1']]
    ['0x09' SOURCE_POWER_CONTROL                    ['1']]
    ['0x09' TOTAL_TRACKS                            ['4']]
    ['0x09' STATUS_REQUEST                          ['0']]
    ['0x09' ENUMERATE_CATEGORIES_SELECTIONS_TRACKS  ['2']]
    ['0x0A' ENUMERATION_SIZE                        ['3']]
    ['0x0B' TRACK_NAME                              ['1']]
    ['0x0C' SELECTION_NAME                          ['1']]
    ['0x0D' CATEGORY_NAME                           ['1']]
]
