/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.math.BigInteger;
import java.time.format.DateTimeParseException;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ScalarMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.DatetimeHelper;

public final class AsDateStep<S>
extends ScalarMapStep<S, Date> {
    public AsDateStep(Traversal.Admin traversal) {
        super(traversal);
    }

    @Override
    protected Date map(Traverser.Admin<S> traverser) {
        Object object = traverser.get();
        if (object == null) {
            throw new IllegalArgumentException("Can't parse null as Date.");
        }
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long) {
            return new Date(((Number)object).longValue());
        }
        if (object instanceof BigInteger) {
            try {
                return new Date(((BigInteger)object).longValueExact());
            }
            catch (ArithmeticException ae) {
                throw new IllegalArgumentException("Can't parse " + object + " as Date.");
            }
        }
        if (object instanceof String) {
            try {
                return DatetimeHelper.parse((String)object);
            }
            catch (DateTimeParseException e) {
                throw new IllegalArgumentException("Can't parse " + object + " as Date.");
            }
        }
        throw new IllegalArgumentException("Can't parse " + object.getClass().getName() + " as Date.");
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return Collections.singleton(TraverserRequirement.OBJECT);
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, new Object[0]);
    }
}

