/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.util;

import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptException;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngine;
import org.apache.tinkerpop.gremlin.jsr223.SingleGremlinScriptEngineManager;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.DefaultTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalSourceFactory;

public final class ScriptTraversal<S, E>
extends DefaultTraversal<S, E> {
    private final String alias;
    private final TraversalSourceFactory factory;
    private final String script;
    private final String scriptEngine;
    private final Object[] bindings;

    public ScriptTraversal(TraversalSource traversalSource, String scriptEngine, String script, Object ... bindings) {
        this.alias = "g";
        this.graph = traversalSource.getGraph();
        this.factory = new TraversalSourceFactory<TraversalSource>(traversalSource);
        this.scriptEngine = scriptEngine;
        this.script = script;
        this.bindings = bindings;
        if (this.bindings.length % 2 != 0) {
            throw new IllegalArgumentException("The provided key/value bindings array length must be a multiple of two");
        }
    }

    @Override
    public void applyStrategies() throws IllegalStateException {
        try {
            assert (0 == this.getSteps().size());
            GremlinScriptEngine engine = SingleGremlinScriptEngineManager.get(this.scriptEngine);
            Bindings engineBindings = engine.createBindings();
            List<TraversalStrategy<?>> strategyList = this.getStrategies().toList();
            engineBindings.put(this.alias, (Object)this.factory.createTraversalSource(this.graph).withStrategies(strategyList.toArray(new TraversalStrategy[strategyList.size()])));
            engineBindings.put("graph", (Object)this.graph);
            for (int i = 0; i < this.bindings.length; i += 2) {
                engineBindings.put((String)this.bindings[i], this.bindings[i + 1]);
            }
            Traversal.Admin traversal = (Traversal.Admin)engine.eval(this.script, engineBindings);
            traversal.getSideEffects().mergeInto(this.sideEffects);
            traversal.getSteps().forEach(this::addStep);
            this.strategies = traversal.getStrategies();
            super.applyStrategies();
        }
        catch (ScriptException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

