/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.auth;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.openejb.server.auth.IPAddressPermission;

public class ExactIPAddressPermission
implements IPAddressPermission {
    private static final Pattern MASK_VALIDATOR = Pattern.compile("^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$");
    private final byte[] bytes;

    public static boolean canSupport(String mask) {
        Matcher matcher = MASK_VALIDATOR.matcher(mask);
        return matcher.matches();
    }

    public ExactIPAddressPermission(byte[] bytes) {
        this.bytes = bytes;
    }

    public ExactIPAddressPermission(String mask) {
        Matcher matcher = MASK_VALIDATOR.matcher(mask);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Mask " + mask + " does not match pattern " + MASK_VALIDATOR.pattern());
        }
        this.bytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            String group = matcher.group(i + 1);
            int value = Integer.parseInt(group);
            if (value < 0 || 255 < value) {
                throw new IllegalArgumentException("byte #" + i + " is not valid.");
            }
            this.bytes[i] = (byte)value;
        }
    }

    @Override
    public boolean implies(InetAddress address) {
        if (!(address instanceof Inet4Address)) {
            return false;
        }
        byte[] byteAddress = address.getAddress();
        for (int i = 0; i < 4; ++i) {
            if (byteAddress[i] == this.bytes[i]) continue;
            return false;
        }
        return true;
    }
}

