# System Input Plugin

The system plugin gathers general stats on system load, uptime,
and number of users logged in. It is basically equivalent
to the unix `uptime` command.

### Configuration:

```toml
# Read metrics about system load & uptime
[[inputs.system]]
  # no configuration
```

### Measurements & Fields:

- system
    - load1 (float)
    - load15 (float)
    - load5 (float)
    - n_users (integer)
    - n_cpus (integer)
    - uptime (integer, seconds)
    - uptime_format (string)

### Tags:

None

### Example Output:

```
$ telegraf --config ~/ws/telegraf.conf --input-filter system --test
* Plugin: system, Collection 1
* Plugin: inputs.system, Collection 1
> system,host=tyrion load1=3.72,load5=2.4,load15=2.1,n_users=3i,n_cpus=4i 1483964144000000000
> system,host=tyrion uptime=1249632i,uptime_format="14 days, 11:07" 1483964144000000000
```
