/****************************************************************************
**
** Copyright (C) 2019 Klarälvdalens Datakonsult AB, a KDAB Group company, info@kdab.com, author Giuseppe D'Angelo <giuseppe.dangelo@kdab.com>
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtGui module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// This file is auto-generated by gradientgen. DO NOT EDIT!

static QArrayDataPointerRef<QGradientStop> qt_preset_gradient_stops(QGradient::Preset preset)
{
    Q_ASSERT(preset < QGradient::NumPresets);
    switch (preset) {
    case QGradient::WarmFlame:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(255, 154, 158, 255)), QGradientStop(0.99, QColor(250, 208, 196, 255)), QGradientStop(1, QColor(250, 208, 196, 255)));
    case QGradient::NightFade:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(161, 140, 209, 255)), QGradientStop(1, QColor(251, 194, 235, 255)));
    case QGradient::SpringWarmth:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(250, 208, 196, 255)), QGradientStop(0.01, QColor(250, 208, 196, 255)), QGradientStop(1, QColor(255, 209, 255, 255)));
    case QGradient::JuicyPeach:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(255, 236, 210, 255)), QGradientStop(1, QColor(252, 182, 159, 255)));
    case QGradient::YoungPassion:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(255, 129, 119, 255)), QGradientStop(0, QColor(255, 134, 122, 255)), QGradientStop(0.21, QColor(255, 140, 127, 255)), QGradientStop(0.52, QColor(249, 145, 133, 255)), QGradientStop(0.78, QColor(207, 85, 108, 255)), QGradientStop(1, QColor(177, 42, 91, 255)));
    case QGradient::LadyLips:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(255, 154, 158, 255)), QGradientStop(0.99, QColor(254, 207, 239, 255)), QGradientStop(1, QColor(254, 207, 239, 255)));
    case QGradient::SunnyMorning:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(246, 211, 101, 255)), QGradientStop(1, QColor(253, 160, 133, 255)));
    case QGradient::RainyAshville:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(251, 194, 235, 255)), QGradientStop(1, QColor(166, 193, 238, 255)));
    case QGradient::FrozenDreams:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(253, 203, 241, 255)), QGradientStop(0.01, QColor(253, 203, 241, 255)), QGradientStop(1, QColor(230, 222, 233, 255)));
    case QGradient::WinterNeva:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(161, 196, 253, 255)), QGradientStop(1, QColor(194, 233, 251, 255)));
    case QGradient::DustyGrass:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(212, 252, 121, 255)), QGradientStop(1, QColor(150, 230, 161, 255)));
    case QGradient::TemptingAzure:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(132, 250, 176, 255)), QGradientStop(1, QColor(143, 211, 244, 255)));
    case QGradient::HeavyRain:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(207, 217, 223, 255)), QGradientStop(1, QColor(226, 235, 240, 255)));
    case QGradient::AmyCrisp:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(166, 192, 254, 255)), QGradientStop(1, QColor(246, 128, 132, 255)));
    case QGradient::MeanFruit:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(252, 203, 144, 255)), QGradientStop(1, QColor(213, 126, 235, 255)));
    case QGradient::DeepBlue:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(224, 195, 252, 255)), QGradientStop(1, QColor(142, 197, 252, 255)));
    case QGradient::RipeMalinka:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(240, 147, 251, 255)), QGradientStop(1, QColor(245, 87, 108, 255)));
    case QGradient::CloudyKnoxville:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(253, 251, 251, 255)), QGradientStop(1, QColor(235, 237, 238, 255)));
    case QGradient::MalibuBeach:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(79, 172, 254, 255)), QGradientStop(1, QColor(0, 242, 254, 255)));
    case QGradient::NewLife:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(67, 233, 123, 255)), QGradientStop(1, QColor(56, 249, 215, 255)));
    case QGradient::TrueSunset:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(250, 112, 154, 255)), QGradientStop(1, QColor(254, 225, 64, 255)));
    case QGradient::MorpheusDen:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(48, 207, 208, 255)), QGradientStop(1, QColor(51, 8, 103, 255)));
    case QGradient::RareWind:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(168, 237, 234, 255)), QGradientStop(1, QColor(254, 214, 227, 255)));
    case QGradient::NearMoon:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(94, 231, 223, 255)), QGradientStop(1, QColor(180, 144, 202, 255)));
    case QGradient::WildApple:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(210, 153, 194, 255)), QGradientStop(1, QColor(254, 249, 215, 255)));
    case QGradient::SaintPetersburg:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(245, 247, 250, 255)), QGradientStop(1, QColor(195, 207, 226, 255)));
    case QGradient::PlumPlate:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(102, 126, 234, 255)), QGradientStop(1, QColor(118, 75, 162, 255)));
    case QGradient::EverlastingSky:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(253, 252, 251, 255)), QGradientStop(1, QColor(226, 209, 195, 255)));
    case QGradient::HappyFisher:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(137, 247, 254, 255)), QGradientStop(1, QColor(102, 166, 255, 255)));
    case QGradient::Blessing:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(253, 219, 146, 255)), QGradientStop(1, QColor(209, 253, 255, 255)));
    case QGradient::SharpeyeEagle:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(152, 144, 227, 255)), QGradientStop(1, QColor(177, 244, 207, 255)));
    case QGradient::LadogaBottom:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(235, 192, 253, 255)), QGradientStop(1, QColor(217, 222, 216, 255)));
    case QGradient::LemonGate:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(150, 251, 196, 255)), QGradientStop(1, QColor(249, 245, 134, 255)));
    case QGradient::ItmeoBranding:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(42, 245, 152, 255)), QGradientStop(1, QColor(0, 158, 253, 255)));
    case QGradient::ZeusMiracle:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(205, 156, 242, 255)), QGradientStop(1, QColor(246, 243, 255, 255)));
    case QGradient::OldHat:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(228, 175, 203, 255)), QGradientStop(0, QColor(184, 203, 184, 255)), QGradientStop(0, QColor(184, 203, 184, 255)), QGradientStop(0.3, QColor(226, 197, 139, 255)), QGradientStop(0.64, QColor(194, 206, 156, 255)), QGradientStop(1, QColor(126, 219, 220, 255)));
    case QGradient::StarWine:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(184, 203, 184, 255)), QGradientStop(0, QColor(184, 203, 184, 255)), QGradientStop(0, QColor(180, 101, 218, 255)), QGradientStop(0.33, QColor(207, 108, 201, 255)), QGradientStop(0.66, QColor(238, 96, 156, 255)), QGradientStop(1, QColor(238, 96, 156, 255)));
    case QGradient::HappyAcid:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(55, 236, 186, 255)), QGradientStop(1, QColor(114, 175, 211, 255)));
    case QGradient::AwesomePine:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(235, 187, 167, 255)), QGradientStop(1, QColor(207, 199, 248, 255)));
    case QGradient::NewYork:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(255, 241, 235, 255)), QGradientStop(1, QColor(172, 224, 249, 255)));
    case QGradient::ShyRainbow:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(238, 162, 162, 255)), QGradientStop(0.19, QColor(187, 193, 191, 255)), QGradientStop(0.42, QColor(87, 198, 225, 255)), QGradientStop(0.79, QColor(180, 159, 218, 255)), QGradientStop(1, QColor(122, 197, 216, 255)));
    case QGradient::MixedHopes:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(196, 113, 245, 255)), QGradientStop(1, QColor(250, 113, 205, 255)));
    case QGradient::FlyHigh:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(72, 198, 239, 255)), QGradientStop(1, QColor(111, 134, 214, 255)));
    case QGradient::StrongBliss:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(247, 140, 160, 255)), QGradientStop(0.19, QColor(249, 116, 143, 255)), QGradientStop(0.6, QColor(253, 134, 140, 255)), QGradientStop(1, QColor(254, 154, 139, 255)));
    case QGradient::FreshMilk:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(254, 173, 166, 255)), QGradientStop(1, QColor(245, 239, 239, 255)));
    case QGradient::SnowAgain:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(230, 233, 240, 255)), QGradientStop(1, QColor(238, 241, 245, 255)));
    case QGradient::FebruaryInk:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(172, 203, 238, 255)), QGradientStop(1, QColor(231, 240, 253, 255)));
    case QGradient::KindSteel:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(233, 222, 250, 255)), QGradientStop(1, QColor(251, 252, 219, 255)));
    case QGradient::SoftGrass:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(193, 223, 196, 255)), QGradientStop(1, QColor(222, 236, 221, 255)));
    case QGradient::GrownEarly:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(11, 163, 96, 255)), QGradientStop(1, QColor(60, 186, 146, 255)));
    case QGradient::SharpBlues:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(0, 198, 251, 255)), QGradientStop(1, QColor(0, 91, 234, 255)));
    case QGradient::ShadyWater:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(116, 235, 213, 255)), QGradientStop(1, QColor(159, 172, 230, 255)));
    case QGradient::DirtyBeauty:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(106, 133, 182, 255)), QGradientStop(1, QColor(186, 200, 224, 255)));
    case QGradient::GreatWhale:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(163, 189, 237, 255)), QGradientStop(1, QColor(105, 145, 199, 255)));
    case QGradient::TeenNotebook:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(151, 149, 240, 255)), QGradientStop(1, QColor(251, 200, 212, 255)));
    case QGradient::PoliteRumors:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(167, 166, 203, 255)), QGradientStop(0.52, QColor(137, 137, 186, 255)), QGradientStop(1, QColor(137, 137, 186, 255)));
    case QGradient::SweetPeriod:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(63, 81, 177, 255)), QGradientStop(0.13, QColor(90, 85, 174, 255)), QGradientStop(0.25, QColor(123, 95, 172, 255)), QGradientStop(0.38, QColor(143, 106, 174, 255)), QGradientStop(0.5, QColor(168, 106, 164, 255)), QGradientStop(0.62, QColor(204, 107, 142, 255)), QGradientStop(0.75, QColor(241, 130, 113, 255)), QGradientStop(0.87, QColor(243, 164, 105, 255)), QGradientStop(1, QColor(247, 201, 120, 255)));
    case QGradient::WideMatrix:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(252, 197, 228, 255)), QGradientStop(0.15, QColor(253, 163, 75, 255)), QGradientStop(0.35, QColor(255, 120, 130, 255)), QGradientStop(0.52, QColor(200, 105, 158, 255)), QGradientStop(0.71, QColor(112, 70, 170, 255)), QGradientStop(0.87, QColor(12, 29, 184, 255)), QGradientStop(1, QColor(2, 15, 117, 255)));
    case QGradient::SoftCherish:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(219, 220, 215, 255)), QGradientStop(0.24, QColor(221, 220, 215, 255)), QGradientStop(0.3, QColor(226, 201, 204, 255)), QGradientStop(0.46, QColor(231, 98, 125, 255)), QGradientStop(0.59, QColor(184, 35, 90, 255)), QGradientStop(0.71, QColor(128, 19, 87, 255)), QGradientStop(0.84, QColor(61, 22, 53, 255)), QGradientStop(1, QColor(28, 26, 39, 255)));
    case QGradient::RedSalvation:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(244, 59, 71, 255)), QGradientStop(1, QColor(69, 58, 148, 255)));
    case QGradient::BurningSpring:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(79, 181, 118, 255)), QGradientStop(0.3, QColor(68, 196, 137, 255)), QGradientStop(0.46, QColor(40, 169, 174, 255)), QGradientStop(0.59, QColor(40, 162, 183, 255)), QGradientStop(0.71, QColor(76, 119, 136, 255)), QGradientStop(0.86, QColor(108, 79, 99, 255)), QGradientStop(1, QColor(67, 44, 57, 255)));
    case QGradient::NightParty:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(2, 80, 197, 255)), QGradientStop(1, QColor(212, 63, 141, 255)));
    case QGradient::SkyGlider:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(136, 211, 206, 255)), QGradientStop(1, QColor(110, 69, 226, 255)));
    case QGradient::HeavenPeach:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(217, 175, 217, 255)), QGradientStop(1, QColor(151, 217, 225, 255)));
    case QGradient::PurpleDivision:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(112, 40, 228, 255)), QGradientStop(1, QColor(229, 178, 202, 255)));
    case QGradient::AquaSplash:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(19, 84, 122, 255)), QGradientStop(1, QColor(128, 208, 199, 255)));
    case QGradient::SpikyNaga:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(80, 82, 133, 255)), QGradientStop(0.12, QColor(88, 94, 146, 255)), QGradientStop(0.25, QColor(101, 104, 159, 255)), QGradientStop(0.37, QColor(116, 116, 176, 255)), QGradientStop(0.5, QColor(126, 126, 187, 255)), QGradientStop(0.62, QColor(131, 137, 199, 255)), QGradientStop(0.75, QColor(151, 149, 212, 255)), QGradientStop(0.87, QColor(162, 161, 220, 255)), QGradientStop(1, QColor(181, 174, 228, 255)));
    case QGradient::LoveKiss:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(255, 8, 68, 255)), QGradientStop(1, QColor(255, 177, 153, 255)));
    case QGradient::CleanMirror:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(147, 165, 207, 255)), QGradientStop(1, QColor(228, 239, 233, 255)));
    case QGradient::PremiumDark:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(67, 67, 67, 255)), QGradientStop(1, QColor(0, 0, 0, 255)));
    case QGradient::ColdEvening:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(12, 52, 131, 255)), QGradientStop(1, QColor(162, 182, 223, 255)), QGradientStop(1, QColor(107, 140, 206, 255)), QGradientStop(1, QColor(162, 182, 223, 255)));
    case QGradient::CochitiLake:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(147, 165, 207, 255)), QGradientStop(1, QColor(228, 239, 233, 255)));
    case QGradient::SummerGames:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(146, 254, 157, 255)), QGradientStop(1, QColor(0, 201, 255, 255)));
    case QGradient::PassionateBed:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(255, 117, 140, 255)), QGradientStop(1, QColor(255, 126, 179, 255)));
    case QGradient::MountainRock:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(134, 143, 150, 255)), QGradientStop(1, QColor(89, 97, 100, 255)));
    case QGradient::DesertHump:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(199, 144, 129, 255)), QGradientStop(1, QColor(223, 165, 121, 255)));
    case QGradient::JungleDay:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(139, 170, 170, 255)), QGradientStop(1, QColor(174, 139, 156, 255)));
    case QGradient::PhoenixStart:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(248, 54, 0, 255)), QGradientStop(1, QColor(249, 212, 35, 255)));
    case QGradient::OctoberSilence:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(183, 33, 255, 255)), QGradientStop(1, QColor(33, 212, 253, 255)));
    case QGradient::FarawayRiver:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(110, 69, 226, 255)), QGradientStop(1, QColor(136, 211, 206, 255)));
    case QGradient::AlchemistLab:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(213, 88, 200, 255)), QGradientStop(1, QColor(36, 210, 146, 255)));
    case QGradient::OverSun:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(171, 236, 214, 255)), QGradientStop(1, QColor(251, 237, 150, 255)));
    case QGradient::PremiumWhite:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(213, 212, 208, 255)), QGradientStop(0.01, QColor(213, 212, 208, 255)), QGradientStop(0.31, QColor(238, 238, 236, 255)), QGradientStop(0.75, QColor(239, 238, 236, 255)), QGradientStop(1, QColor(233, 233, 231, 255)));
    case QGradient::MarsParty:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(95, 114, 189, 255)), QGradientStop(1, QColor(155, 35, 234, 255)));
    case QGradient::EternalConstance:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(9, 32, 63, 255)), QGradientStop(1, QColor(83, 120, 149, 255)));
    case QGradient::JapanBlush:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(221, 214, 243, 255)), QGradientStop(1, QColor(250, 172, 168, 255)), QGradientStop(1, QColor(250, 172, 168, 255)));
    case QGradient::SmilingRain:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(220, 176, 237, 255)), QGradientStop(1, QColor(153, 201, 156, 255)));
    case QGradient::CloudyApple:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(243, 231, 233, 255)), QGradientStop(0.99, QColor(227, 238, 255, 255)), QGradientStop(1, QColor(227, 238, 255, 255)));
    case QGradient::BigMango:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(199, 29, 111, 255)), QGradientStop(1, QColor(208, 150, 147, 255)));
    case QGradient::HealthyWater:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(150, 222, 218, 255)), QGradientStop(1, QColor(80, 201, 195, 255)));
    case QGradient::AmourAmour:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(247, 112, 98, 255)), QGradientStop(1, QColor(254, 81, 150, 255)));
    case QGradient::RiskyConcrete:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(196, 197, 199, 255)), QGradientStop(0.52, QColor(220, 221, 223, 255)), QGradientStop(1, QColor(235, 235, 235, 255)));
    case QGradient::StrongStick:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(168, 202, 186, 255)), QGradientStop(1, QColor(93, 65, 87, 255)));
    case QGradient::ViciousStance:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(41, 50, 60, 255)), QGradientStop(1, QColor(72, 85, 99, 255)));
    case QGradient::PaloAlto:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(22, 160, 133, 255)), QGradientStop(1, QColor(244, 208, 63, 255)));
    case QGradient::HappyMemories:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(255, 88, 88, 255)), QGradientStop(1, QColor(240, 152, 25, 255)));
    case QGradient::MidnightBloom:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(43, 88, 118, 255)), QGradientStop(1, QColor(78, 67, 118, 255)));
    case QGradient::Crystalline:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(0, 205, 172, 255)), QGradientStop(1, QColor(141, 218, 213, 255)));
    case QGradient::PartyBliss:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(68, 129, 235, 255)), QGradientStop(1, QColor(4, 190, 254, 255)));
    case QGradient::ConfidentCloud:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(218, 212, 236, 255)), QGradientStop(0.01, QColor(218, 212, 236, 255)), QGradientStop(1, QColor(243, 231, 233, 255)));
    case QGradient::LeCocktail:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(135, 77, 162, 255)), QGradientStop(1, QColor(196, 58, 48, 255)));
    case QGradient::RiverCity:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(68, 129, 235, 255)), QGradientStop(1, QColor(4, 190, 254, 255)));
    case QGradient::FrozenBerry:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(232, 25, 139, 255)), QGradientStop(1, QColor(199, 234, 253, 255)));
    case QGradient::ChildCare:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(247, 148, 164, 255)), QGradientStop(1, QColor(253, 214, 189, 255)));
    case QGradient::FlyingLemon:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(100, 179, 244, 255)), QGradientStop(1, QColor(194, 229, 156, 255)));
    case QGradient::NewRetrowave:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(59, 65, 197, 255)), QGradientStop(0.49, QColor(169, 129, 187, 255)), QGradientStop(1, QColor(255, 200, 169, 255)));
    case QGradient::HiddenJaguar:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(15, 216, 80, 255)), QGradientStop(1, QColor(249, 240, 71, 255)));
    case QGradient::AboveTheSky:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(211, 211, 211, 255)), QGradientStop(0.01, QColor(211, 211, 211, 255)), QGradientStop(0.26, QColor(224, 224, 224, 255)), QGradientStop(0.48, QColor(239, 239, 239, 255)), QGradientStop(0.75, QColor(217, 217, 217, 255)), QGradientStop(1, QColor(188, 188, 188, 255)));
    case QGradient::Nega:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(238, 156, 167, 255)), QGradientStop(1, QColor(255, 221, 225, 255)));
    case QGradient::DenseWater:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(58, 181, 176, 255)), QGradientStop(0.31, QColor(61, 153, 190, 255)), QGradientStop(1, QColor(86, 49, 122, 255)));
    case QGradient::Seashore:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(32, 156, 255, 255)), QGradientStop(1, QColor(104, 224, 207, 255)));
    case QGradient::MarbleWall:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(189, 194, 232, 255)), QGradientStop(0.01, QColor(189, 194, 232, 255)), QGradientStop(1, QColor(230, 222, 233, 255)));
    case QGradient::CheerfulCaramel:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(230, 185, 128, 255)), QGradientStop(1, QColor(234, 205, 163, 255)));
    case QGradient::NightSky:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(30, 60, 114, 255)), QGradientStop(0.01, QColor(30, 60, 114, 255)), QGradientStop(1, QColor(42, 82, 152, 255)));
    case QGradient::MagicLake:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(213, 222, 231, 255)), QGradientStop(0, QColor(255, 175, 189, 255)), QGradientStop(1, QColor(201, 255, 191, 255)));
    case QGradient::YoungGrass:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(155, 225, 93, 255)), QGradientStop(1, QColor(0, 227, 174, 255)));
    case QGradient::ColorfulPeach:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(237, 110, 160, 255)), QGradientStop(1, QColor(236, 140, 105, 255)));
    case QGradient::GentleCare:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(255, 195, 160, 255)), QGradientStop(1, QColor(255, 175, 189, 255)));
    case QGradient::PlumBath:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(204, 32, 142, 255)), QGradientStop(1, QColor(103, 19, 210, 255)));
    case QGradient::HappyUnicorn:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(179, 255, 171, 255)), QGradientStop(1, QColor(18, 255, 247, 255)));
    case QGradient::AfricanField:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(101, 189, 96, 255)), QGradientStop(0.25, QColor(90, 193, 168, 255)), QGradientStop(0.5, QColor(62, 198, 237, 255)), QGradientStop(0.75, QColor(183, 221, 183, 255)), QGradientStop(1, QColor(254, 243, 129, 255)));
    case QGradient::SolidStone:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(36, 57, 73, 255)), QGradientStop(1, QColor(81, 127, 164, 255)));
    case QGradient::OrangeJuice:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(252, 96, 118, 255)), QGradientStop(1, QColor(255, 154, 68, 255)));
    case QGradient::GlassWater:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(223, 233, 243, 255)), QGradientStop(1, QColor(255, 255, 255, 255)));
    case QGradient::NorthMiracle:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(0, 219, 222, 255)), QGradientStop(1, QColor(252, 0, 255, 255)));
    case QGradient::FruitBlend:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(249, 212, 35, 255)), QGradientStop(1, QColor(255, 78, 80, 255)));
    case QGradient::MillenniumPine:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(80, 204, 127, 255)), QGradientStop(1, QColor(245, 209, 0, 255)));
    case QGradient::HighFlight:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(10, 207, 254, 255)), QGradientStop(1, QColor(73, 90, 255, 255)));
    case QGradient::MoleHall:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(97, 97, 97, 255)), QGradientStop(1, QColor(155, 197, 195, 255)));
    case QGradient::SpaceShift:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(61, 51, 147, 255)), QGradientStop(0.37, QColor(43, 118, 185, 255)), QGradientStop(0.65, QColor(44, 172, 209, 255)), QGradientStop(1, QColor(53, 235, 147, 255)));
    case QGradient::ForestInei:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(223, 137, 181, 255)), QGradientStop(1, QColor(191, 217, 254, 255)));
    case QGradient::RoyalGarden:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(237, 110, 160, 255)), QGradientStop(1, QColor(236, 140, 105, 255)));
    case QGradient::RichMetal:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(215, 210, 204, 255)), QGradientStop(1, QColor(48, 67, 82, 255)));
    case QGradient::JuicyCake:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(225, 79, 173, 255)), QGradientStop(1, QColor(249, 212, 35, 255)));
    case QGradient::SmartIndigo:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(178, 36, 239, 255)), QGradientStop(1, QColor(117, 121, 255, 255)));
    case QGradient::SandStrike:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(193, 193, 97, 255)), QGradientStop(0, QColor(193, 193, 97, 255)), QGradientStop(1, QColor(212, 212, 177, 255)));
    case QGradient::NorseBeauty:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(236, 119, 171, 255)), QGradientStop(1, QColor(120, 115, 245, 255)));
    case QGradient::AquaGuidance:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(0, 122, 223, 255)), QGradientStop(1, QColor(0, 236, 188, 255)));
    case QGradient::SunVeggie:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(32, 226, 215, 255)), QGradientStop(1, QColor(249, 254, 165, 255)));
    case QGradient::SeaLord:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(44, 216, 213, 255)), QGradientStop(0.56, QColor(197, 193, 255, 255)), QGradientStop(1, QColor(255, 186, 195, 255)));
    case QGradient::BlackSea:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(44, 216, 213, 255)), QGradientStop(0.48, QColor(107, 141, 214, 255)), QGradientStop(1, QColor(142, 55, 215, 255)));
    case QGradient::GrassShampoo:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(223, 255, 205, 255)), QGradientStop(0.48, QColor(144, 249, 196, 255)), QGradientStop(1, QColor(57, 243, 187, 255)));
    case QGradient::LandingAircraft:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(93, 159, 255, 255)), QGradientStop(0.48, QColor(184, 220, 255, 255)), QGradientStop(1, QColor(107, 187, 255, 255)));
    case QGradient::WitchDance:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(168, 191, 255, 255)), QGradientStop(1, QColor(136, 77, 128, 255)));
    case QGradient::SleeplessNight:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(82, 113, 196, 255)), QGradientStop(0.48, QColor(177, 159, 255, 255)), QGradientStop(1, QColor(236, 161, 254, 255)));
    case QGradient::AngelCare:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(255, 226, 159, 255)), QGradientStop(0.48, QColor(255, 169, 159, 255)), QGradientStop(1, QColor(255, 113, 154, 255)));
    case QGradient::CrystalRiver:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(34, 225, 255, 255)), QGradientStop(0.48, QColor(29, 143, 225, 255)), QGradientStop(1, QColor(98, 94, 177, 255)));
    case QGradient::SoftLipstick:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(182, 206, 232, 255)), QGradientStop(1, QColor(245, 120, 220, 255)));
    case QGradient::SaltMountain:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(255, 254, 255, 255)), QGradientStop(1, QColor(215, 255, 254, 255)));
    case QGradient::PerfectWhite:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(227, 253, 245, 255)), QGradientStop(1, QColor(255, 230, 250, 255)));
    case QGradient::FreshOasis:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(125, 226, 252, 255)), QGradientStop(1, QColor(185, 182, 229, 255)));
    case QGradient::StrictNovember:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(203, 186, 204, 255)), QGradientStop(1, QColor(37, 128, 179, 255)));
    case QGradient::MorningSalad:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(183, 248, 219, 255)), QGradientStop(1, QColor(80, 167, 194, 255)));
    case QGradient::DeepRelief:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(112, 133, 182, 255)), QGradientStop(0.5, QColor(135, 167, 217, 255)), QGradientStop(1, QColor(222, 243, 248, 255)));
    case QGradient::SeaStrike:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(119, 255, 210, 255)), QGradientStop(0.48, QColor(98, 151, 219, 255)), QGradientStop(1, QColor(30, 236, 255, 255)));
    case QGradient::NightCall:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(172, 50, 228, 255)), QGradientStop(0.48, QColor(121, 24, 242, 255)), QGradientStop(1, QColor(72, 1, 255, 255)));
    case QGradient::SupremeSky:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(212, 255, 236, 255)), QGradientStop(0.48, QColor(87, 242, 204, 255)), QGradientStop(1, QColor(69, 150, 251, 255)));
    case QGradient::LightBlue:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(158, 251, 211, 255)), QGradientStop(0.48, QColor(87, 233, 242, 255)), QGradientStop(1, QColor(69, 212, 251, 255)));
    case QGradient::MindCrawl:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(71, 59, 123, 255)), QGradientStop(0.51, QColor(53, 132, 167, 255)), QGradientStop(1, QColor(48, 210, 190, 255)));
    case QGradient::LilyMeadow:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(101, 55, 155, 255)), QGradientStop(0.53, QColor(136, 106, 234, 255)), QGradientStop(1, QColor(100, 87, 198, 255)));
    case QGradient::SugarLollipop:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(164, 69, 178, 255)), QGradientStop(0.52, QColor(212, 24, 114, 255)), QGradientStop(1, QColor(255, 0, 102, 255)));
    case QGradient::SweetDessert:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(119, 66, 178, 255)), QGradientStop(0.52, QColor(241, 128, 255, 255)), QGradientStop(1, QColor(253, 139, 217, 255)));
    case QGradient::MagicRay:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(255, 60, 172, 255)), QGradientStop(0.52, QColor(86, 43, 124, 255)), QGradientStop(1, QColor(43, 134, 197, 255)));
    case QGradient::TeenParty:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(255, 5, 124, 255)), QGradientStop(0.5, QColor(141, 11, 147, 255)), QGradientStop(1, QColor(50, 21, 117, 255)));
    case QGradient::FrozenHeat:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(255, 5, 124, 255)), QGradientStop(0.48, QColor(124, 100, 213, 255)), QGradientStop(1, QColor(76, 195, 255, 255)));
    case QGradient::GagarinView:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(105, 234, 203, 255)), QGradientStop(0.48, QColor(234, 204, 248, 255)), QGradientStop(1, QColor(102, 84, 241, 255)));
    case QGradient::FabledSunset:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(35, 21, 87, 255)), QGradientStop(0.29, QColor(68, 16, 122, 255)), QGradientStop(0.67, QColor(255, 19, 97, 255)), QGradientStop(1, QColor(255, 248, 0, 255)));
    case QGradient::PerfectBlue:
        return Q_ARRAY_LITERAL(QGradientStop, QGradientStop(0, QColor(61, 78, 129, 255)), QGradientStop(0.48, QColor(87, 83, 201, 255)), QGradientStop(1, QColor(110, 127, 243, 255)));
    case QGradient::NumPresets:
        Q_UNREACHABLE();
    }
    Q_UNREACHABLE();
    return {};
}

static Q_CONSTEXPR QGradient::QGradientData qt_preset_gradient_data[] = {
    { { 0, 1, 1, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0, 0.5, 1, 0.5 } },
    { { 0, 0.5, 1, 0.5 } },
    { { 0.5, 1, 0.5, 0 } },
    { { -0.0915064, 0.158494, 1.09151, 0.841506 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { -0.0915064, 0.158494, 1.09151, 0.841506 } },
    { { -0.0915064, 0.158494, 1.09151, 0.841506 } },
    { { -0.0915064, 0.158494, 1.09151, 0.841506 } },
    { { 0.5, 1, 0.5, 0 } },
    { { -0.0915064, 0.158494, 1.09151, 0.841506 } },
    { { -0.0915064, 0.158494, 1.09151, 0.841506 } },
    { { -0.0915064, 0.158494, 1.09151, 0.841506 } },
    { { -0.0915064, 0.158494, 1.09151, 0.841506 } },
    { { -0.0915064, 0.158494, 1.09151, 0.841506 } },
    { { 0, 0.5, 1, 0.5 } },
    { { 0, 0.5, 1, 0.5 } },
    { { 0, 0.5, 1, 0.5 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0, 0, 1, 1 } },
    { { 0, 0, 0, 0 } },
    { { 0, 0, 1, 1 } },
    { { 0, 0, 1, 1 } },
    { { -0.0915064, 0.158494, 1.09151, 0.841506 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 0, 0.5, 1 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0, 0.5, 1, 0.5 } },
    { { 0, 0.5, 1, 0.5 } },
    { { 0, 0, 0, 0 } },
    { { 0, 0, 0, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0, 0.5, 1, 0.5 } },
    { { 0, 0, 0, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0, 0.5, 1, 0.5 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.719186, 1.10221, 0.280814, -0.102208 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0, 0.5, 1, 0.5 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.341506, 1.09151, 0.658494, -0.0915064 } },
    { { 0, 0, 0, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0, 0, 0, 0 } },
    { { 0, 1, 1, 0 } },
    { { 0, 0.5, 1, 0.5 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0, 1, 1, 0 } },
    { { 0, 0.5, 1, 0.5 } },
    { { 0, 0.5, 1, 0.5 } },
    { { 0, 0.5, 1, 0.5 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0, 1, 1, 0 } },
    { { 0, 0.5, 1, 0.5 } },
    { { 0.719186, 1.10221, 0.280814, -0.102208 } },
    { { 0.719186, 1.10221, 0.280814, -0.102208 } },
    { { 0.719186, 1.10221, 0.280814, -0.102208 } },
    { { -0.0915064, 0.841506, 1.09151, 0.158494 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.719186, 1.10221, 0.280814, -0.102208 } },
    { { 0.719186, 1.10221, 0.280814, -0.102208 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { -0.0915064, 0.841506, 1.09151, 0.158494 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0, 0.5, 1, 0.5 } },
    { { -0.0915064, 0.841506, 1.09151, 0.158494 } },
    { { 1.09151, 0.841506, -0.0915064, 0.158494 } },
    { { 1.09151, 0.841506, -0.0915064, 0.158494 } },
    { { 0.719186, 1.10221, 0.280814, -0.102208 } },
    { { 0.719186, 1.10221, 0.280814, -0.102208 } },
    { { 0, 0, 0, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0, 1, 1, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0, 0, 0, 0 } },
    { { 0.719186, 1.10221, 0.280814, -0.102208 } },
    { { -0.0915064, 0.841506, 1.09151, 0.158494 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0, 1, 1, 0 } },
    { { 0, 0.5, 1, 0.5 } },
    { { 0, 0, 0, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0, 0.5, 1, 0.5 } },
    { { 0, 0.5, 1, 0.5 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0, 0, 0, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0, 0.5, 1, 0.5 } },
    { { 0.719186, 1.10221, 0.280814, -0.102208 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0, 0, 0, 0 } },
    { { 0, 0.5, 1, 0.5 } },
    { { 0, 0.5, 1, 0.5 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0, 0.5, 1, 0.5 } },
    { { 0.719186, 1.10221, 0.280814, -0.102208 } },
    { { 0, 0, 0, 0 } },
    { { -0.0915064, 0.841506, 1.09151, 0.158494 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0, 0.5, 1, 0.5 } },
    { { 0, 0.5, 1, 0.5 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0, 0.5, 1, 0.5 } },
    { { 0, 0.5, 1, 0.5 } },
    { { 0.5, 1, 0.5, 0 } },
    { { 0, 0, 1, 1 } },
    { { 0, 0, 1, 1 } },
    { { 0, 0, 1, 1 } },
    { { 0, 0, 1, 1 } },
    { { 0, 0, 1, 1 } },
    { { 0, 0, 1, 1 } },
    { { 0, 0, 1, 1 } },
    { { 0, 0, 1, 1 } },
    { { 0, 0, 1, 1 } },
    { { 0, 0, 1, 1 } },
    { { 0, 0, 1, 1 } },
    { { 0, 0, 1, 1 } },
    { { 0, 0, 1, 1 } },
    { { 0, 0, 1, 1 } },
    { { 0, 0, 1, 1 } },
    { { 0, 0, 1, 1 } },
    { { 0, 0, 1, 1 } },
    { { 0, 0, 1, 1 } },
    { { 0, 0, 1, 1 } },
    { { 0, 0, 1, 1 } },
    { { 0, 0, 1, 1 } },
    { { 0, 0, 1, 1 } },
    { { 0, 0, 1, 1 } },
    { { 0, 0, 1, 1 } },
    { { 0, 0, 1, 1 } },
    { { 0, 0, 1, 1 } },
    { { 0, 0, 1, 1 } },
    { { 0, 0, 1, 1 } },
    { { 0, 0, 1, 1 } },
    { { 0, 0, 1, 1 } },
};

static void *qt_preset_gradient_dummy()
{
    union {void *p; uint i;};
    p = 0;
    i |= uint(QGradient::ObjectMode);
    return p;
}
