// Copyright (C) 2023 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR BSD-3-Clause

pragma Singleton

import QtQml

QtObject {
    property list<Room> data: [
        Room {
            name: qsTr("Living Room")
            floor: qsTr("First floor")
            iconName: "living_room.svg"
            mode: "Auto"
            active: true
            temp: 24
            thermostatTemp: 21
            humidity: 32
            energy: 12
            humidityStats: [
                60,
                55,
                50,
                40,
                45,
                35,
                30,
                50,
                60,
                50,
                55,
                60,
            ]
            energyStats: [
                1200,
                1400,
                1000,
                900,
                800,
                500,
                600,
                550,
                1200,
                1400,
                1600,
                1000,
            ]
            tempStats: [
                21.2,
                21.5,
                21.0,
                20.8,
                20.5,
                20.5,
                20.0,
                20.8,
                21.2,
                21.5,
                21.9,
                22.0,
                22.2,
                22.3,
                22.5,
                22.5,
                22.8,
                23.0,
                22.0,
                22.2,
                22.3,
                22.5,
                22.5,
                22.8,
                23.0,
                21.0,
                21.2,
                21.3,
                21.5,
                22.5,
                22.8,
                22.0,
                21.0,
                21.2,
                21.3,
                21.5,
                22.5,
                22.8,
                22.0,
                19.0,
                18.7,
                17.5,
                20.5,
                21.8,
                22.0,
                21.0,
                20.5,
                21.8,
                22.0,
                23.0,
                22.0,
                23.0,
                23.0,
            ]
        },
        Room {
            name: qsTr("Master")
            floor: qsTr("First floor")
            iconName: "bedroom.svg"
            mode: "Auto"
            active: true
            temp: 14
            thermostatTemp: 22
            humidity: 40
            energy: 10
            humidityStats: [
                45,
                42,
                40,
                38,
                35,
                33,
                30,
                36,
                44,
                40,
                41,
                45,
            ]
            energyStats: [
                800,
                1000,
                1000,
                900,
                600,
                300,
                300,
                450,
                600,
                1200,
                1300,
                1600,
            ]
            tempStats: [
                21.5,
                21.1,
                20.7,
                20.3,
                20.0,
                19.2,
                18.6,
                19.5,
                20.7,
                21.4,
                22.0,
                22.3,
                22.5,
                22.7,
                23.0,
                23.2,
                23.3,
                23.1,
                22.4,
                22.0,
                22.2,
                22.5,
                22.6,
                22.4,
                22.1,
                20.9,
                21.0,
                21.1,
                21.5,
                22.6,
                22.9,
                22.2,
                21.5,
                21.0,
                21.3,
                21.6,
                22.1,
                22.7,
                21.5,
                18.8,
                18.0,
                17.3,
                20.2,
                21.3,
                21.7,
                21.0,
                20.1,
                21.5,
                22.2,
                22.7,
                21.9,
                22.8,
                23.0,
            ]
        },
        Room {
            name: qsTr("Kitchen")
            floor: qsTr("First floor")
            iconName: "kitchen.svg"
            mode: "Auto"
            active: false
            temp: 24
            thermostatTemp: 25
            humidity: 48
            energy: 11
            humidityStats: [
                60,
                58,
                56,
                54,
                52,
                50,
                48,
                55,
                60,
                58,
                57,
                59,
            ]
            energyStats: [
                1700,
                1600,
                1600,
                1400,
                1800,
                1900,
                1300,
                1000,
                900,
                1200,
                1300,
                1400,
            ]
            tempStats: [
                20.9,
                20.6,
                20.4,
                19.8,
                19.5,
                19.0,
                18.7,
                19.8,
                20.4,
                21.1,
                21.5,
                22.0,
                22.2,
                22.4,
                22.7,
                23.1,
                23.4,
                23.2,
                21.9,
                21.5,
                21.8,
                22.0,
                22.3,
                22.5,
                22.6,
                21.3,
                21.0,
                21.4,
                21.6,
                22.3,
                22.6,
                21.6,
                20.8,
                20.5,
                21.0,
                21.3,
                22.0,
                22.6,
                21.2,
                19.1,
                18.6,
                17.8,
                20.1,
                21.4,
                21.6,
                20.9,
                20.2,
                21.7,
                22.3,
                22.9,
                22.1,
                23.0,
                23.2,
            ]
        },
        Room {
            name: qsTr("Kid Room")
            floor: qsTr("First floor")
            iconName: "kid_room.svg"
            mode: "Auto"
            active: false
            temp: 14
            thermostatTemp: 22
            humidity: 36
            energy: 15
            humidityStats: [
                50,
                48,
                45,
                42,
                40,
                38,
                36,
                44,
                49,
                47,
                46,
                50,
            ]
            energyStats: [
                1000,
                1000,
                1100,
                920,
                840,
                800,
                1000,
                1100,
                1000,
                600,
                590,
                720,
            ]
            tempStats: [
                21.0,
                20.8,
                20.5,
                20.1,
                19.3,
                18.9,
                18.2,
                19.3,
                20.1,
                20.9,
                21.4,
                21.7,
                21.9,
                22.2,
                22.6,
                22.9,
                23.1,
                23.0,
                21.8,
                21.6,
                21.9,
                22.1,
                22.2,
                22.0,
                21.8,
                20.7,
                20.9,
                21.2,
                21.3,
                22.1,
                22.4,
                21.7,
                20.5,
                20.1,
                20.9,
                21.1,
                21.8,
                22.3,
                21.0,
                18.5,
                18.0,
                17.5,
                20.0,
                21.2,
                21.5,
                20.8,
                19.9,
                21.2,
                21.8,
                22.6,
                21.7,
                22.7,
                22.9,
            ]
        },
        Room {
            name: qsTr("Kid Room2")
            floor: qsTr("First floor")
            iconName: "kid_room.svg"
            mode: "Auto"
            active: false
            temp: 22
            thermostatTemp: 19
            humidity: 41
            energy: 12
            humidityStats: [
                55,
                53,
                51,
                50,
                49,
                47,
                46,
                52,
                54,
                53,
                51,
                56,
            ]
            energyStats: [
                900,
                800,
                1000,
                900,
                900,
                1000,
                1100,
                1200,
                1300,
                800,
                700,
                720,
            ]
            tempStats: [
                21.6,
                21.4,
                21.2,
                20.7,
                20.0,
                19.6,
                18.9,
                20.0,
                20.6,
                21.3,
                21.9,
                22.3,
                22.5,
                22.8,
                23.0,
                23.3,
                23.5,
                23.2,
                22.1,
                21.8,
                22.0,
                22.3,
                22.5,
                22.3,
                22.0,
                20.5,
                20.8,
                21.0,
                21.2,
                22.0,
                22.3,
                21.3,
                20.2,
                20.0,
                21.0,
                21.2,
                21.9,
                22.5,
                21.3,
                19.2,
                18.4,
                17.2,
                19.8,
                21.0,
                21.4,
                20.6,
                19.8,
                21.1,
                21.9,
                22.5,
                21.8,
                22.8,
                23.1,
            ]
        },
        Room {
            name: qsTr("Bedroom")
            floor: qsTr("First floor")
            iconName: "bedroom.svg"
            mode: "Auto"
            active: true
            temp: 21
            thermostatTemp: 20
            humidity: 57
            energy: 13
            humidityStats: [
                35,
                38,
                42,
                45,
                48,
                52,
                55,
                58,
                60,
                59,
                57,
                56,
            ]
            energyStats: [
                400,
                500,
                400,
                400,
                450,
                500,
                600,
                550,
                700,
                720,
                780,
                750,
            ]
            tempStats: [
                20.7,
                20.5,
                20.0,
                19.5,
                18.7,
                18.0,
                17.5,
                18.9,
                19.8,
                20.5,
                21.0,
                21.6,
                21.9,
                22.1,
                22.4,
                22.6,
                22.9,
                22.7,
                21.4,
                21.0,
                21.2,
                21.6,
                21.9,
                21.7,
                21.3,
                20.2,
                20.5,
                20.8,
                21.1,
                21.9,
                22.1,
                21.2,
                20.3,
                20.0,
                20.7,
                20.9,
                21.6,
                22.2,
                20.8,
                18.3,
                17.9,
                17.4,
                19.7,
                20.8,
                21.2,
                20.4,
                19.6,
                20.9,
                21.6,
                22.2,
                21.4,
                22.3,
                22.6,
            ]
        }
    ]
}
