// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/autofill_assistant/browser/actions/stop_action.h"

#include <memory>
#include <utility>

#include "base/callback.h"
#include "components/autofill_assistant/browser/actions/action_delegate.h"

namespace autofill_assistant {

StopAction::StopAction(ActionDelegate* delegate, const ActionProto& proto)
    : Action(delegate, proto) {
  DCHECK(proto_.has_stop());
}

StopAction::~StopAction() {}

void StopAction::InternalProcessAction(ProcessActionCallback callback) {
  if (proto_.stop().close_cct()) {
    delegate_->Close();
  } else {
    delegate_->Shutdown(proto_.stop().show_feedback_chip());
  }
  UpdateProcessedAction(ACTION_APPLIED);
  std::move(callback).Run(std::move(processed_action_proto_));
}

}  // namespace autofill_assistant
