// Copyright (C) 2015 André Bargull. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
es6id: 19.2.3.3
description: >
  Function.prototype.call.name is "call".
info: |
  Function.prototype.call (thisArg , ...args)

  17 ECMAScript Standard Built-in Objects:
    Every built-in Function object, including constructors, that is not
    identified as an anonymous function has a name property whose value
    is a String.

    Unless otherwise specified, the name property of a built-in Function
    object, if it exists, has the attributes { [[Writable]]: false,
    [[Enumerable]]: false, [[Configurable]]: true }.
includes: [propertyHelper.js]
---*/

assert.sameValue(Function.prototype.call.name, "call");

verifyNotEnumerable(Function.prototype.call, "name");
verifyNotWritable(Function.prototype.call, "name");
verifyConfigurable(Function.prototype.call, "name");
