/**************************************************************************
**
** This file is part of Qt Creator
**
** Copyright (c) 2011 Nokia Corporation and/or its subsidiary(-ies).
**
** Contact: Nokia Corporation (qt-info@nokia.com)
**
**
** GNU Lesser General Public License Usage
**
** This file may be used under the terms of the GNU Lesser General Public
** License version 2.1 as published by the Free Software Foundation and
** appearing in the file LICENSE.LGPL included in the packaging of this file.
** Please review the following information to ensure the GNU Lesser General
** Public License version 2.1 requirements will be met:
** http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** Other Usage
**
** Alternatively, this file may be used in accordance with the terms and
** conditions contained in a signed written agreement between you and Nokia.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**************************************************************************/

#include "SymbolNameVisitor.h"
#include <Symbols.h>
#include <Names.h>

using namespace CPlusPlus;

SymbolNameVisitor::SymbolNameVisitor()
    : _symbol(0)
{
}

void SymbolNameVisitor::accept(Symbol *symbol)
{
    if (symbol) {
        if (Scope *scope = symbol->enclosingScope())
            accept(scope);

        if (! symbol->isTemplate()) {
            if (const Name *name = symbol->name()) {
                std::swap(_symbol, symbol);
                accept(name);
                std::swap(_symbol, symbol);
            }
        }
    }
}
