/***************************************************************************
**
** Copyright (C) 2015 Jochen Becher
** Contact: http://www.qt.io/licensing
**
** This file is part of Qt Creator.
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company.  For licensing terms and
** conditions see http://www.qt.io/terms-conditions.  For further information
** use the contact form at http://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 or version 3 as published by the Free
** Software Foundation and appearing in the file LICENSE.LGPLv21 and
** LICENSE.LGPLv3 included in the packaging of this file.  Please review the
** following information to ensure the GNU Lesser General Public License
** requirements will be met: https://www.gnu.org/licenses/lgpl.html and
** http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, The Qt Company gives you certain additional
** rights.  These rights are described in The Qt Company LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
****************************************************************************/

#ifndef QMT_SELECTION_H
#define QMT_SELECTION_H

#include "qmt/infrastructure/uid.h"

#include <QList>


namespace qmt {

class QMT_EXPORT Selection
{
public:
    class Index {
    public:

        Index(const Uid &element_key, const Uid &owner_key)
            : _element_key(element_key),
              _owner_key(owner_key)
        {
        }

        Uid getElementKey() const { return _element_key; }

        Uid getOwnerKey() const { return _owner_key; }

    private:

        Uid _element_key;

        Uid _owner_key;
    };

protected:

    Selection();

public:

    ~Selection();

public:

    bool isEmpty() const { return _indices.isEmpty(); }

    QList<Index> getIndices() const { return _indices; }

    void setIndices(const QList<Index> &indices);

public:

    void clear();

    void append(const Index &index);

    void append(const Uid &element_key, const Uid &owner_key);

private:

    QList<Index> _indices;
};

}


#endif // QMT_SELECTION_H
