/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt Creator.
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
****************************************************************************/

//
//  W A R N I N G
//  -------------
//
// Main parts of this file are generated by "cplusplus-keywordgen".
// Use the tool to update new keywords/identifiers:
//
//  1. Update the input file cppdoxygen.kwgen with new keywords/identifiers.
//  2. Run the tool with the input file:
//       $ INPUT_FILE=${QTC_SOURCE}/src/plugins/cpptools/cppdoxygen.kwgen
//       $ OUTPUT_FILE=/tmp/new.cpp
//       $ TOOL=${QTC_BUILD}/bin/cplusplus-keywordgen
//       $ cat $INPUT_FILE | $TOOL > $OUTPUT_FILE
//  3. Copy over the classify* functions from $OUTPUT_FILE to this file,
//     update the doxy_token_spell array in this file and the enums in the
//     header.
//

#include "cppdoxygen.h"

#include <QString>

using namespace CppTools;

/*
  TODO:
    ~
    @
    $
    \
    #
    f[
    f]
    f$
*/

static const char *doxy_token_spell[] = {
    "identifier",

    "a",
    "abstract",
    "addindex",
    "addtogroup",
    "anchor",
    "annotatedlist",
    "arg",
    "attention",
    "author",
    "authors",
    "b",
    "badcode",
    "basename",
    "bold",
    "brief",
    "bug",
    "c",
    "callergraph",
    "callgraph",
    "caption",
    "category",
    "chapter",
    "cite",
    "class",
    "code",
    "codeline",
    "compat",
    "cond",
    "contentspage",
    "copybrief",
    "copydetails",
    "copydoc",
    "copyright",
    "corelib",
    "date",
    "def",
    "default",
    "defgroup",
    "deprecated",
    "details",
    "diafile",
    "dir",
    "div",
    "docbookonly",
    "dontinclude",
    "dot",
    "dotfile",
    "dots",
    "e",
    "else",
    "elseif",
    "em",
    "endabstract",
    "endchapter",
    "endcode",
    "endcond",
    "enddocbookonly",
    "enddot",
    "endfootnote",
    "endhtmlonly",
    "endif",
    "endinternal",
    "endlatexonly",
    "endlegalese",
    "endlink",
    "endlist",
    "endmanonly",
    "endmsc",
    "endomit",
    "endparblock",
    "endpart",
    "endquotation",
    "endraw",
    "endrtfonly",
    "endsecreflist",
    "endsection1",
    "endsection2",
    "endsection3",
    "endsection4",
    "endsidebar",
    "endtable",
    "enduml",
    "endverbatim",
    "endxmlonly",
    "enum",
    "example",
    "exception",
    "exceptions",
    "expire",
    "extends",
    "externalpage",
    "file",
    "fn",
    "footnote",
    "generatelist",
    "granularity",
    "group",
    "gui",
    "header",
    "headerfile",
    "hidecallergraph",
    "hidecallgraph",
    "hideinitializer",
    "htmlinclude",
    "htmlonly",
    "i",
    "idlexcept",
    "if",
    "ifnot",
    "image",
    "implements",
    "include",
    "includelineno",
    "index",
    "indexpage",
    "ingroup",
    "inheaderfile",
    "inherits",
    "inlineimage",
    "inmodule",
    "inpublicgroup",
    "inqmlmodule",
    "instantiates",
    "interface",
    "internal",
    "invariant",
    "keyword",
    "l",
    "latexinclude",
    "latexonly",
    "legalese",
    "li",
    "line",
    "link",
    "list",
    "macro",
    "mainclass",
    "mainpage",
    "manonly",
    "memberof",
    "meta",
    "module",
    "msc",
    "mscfile",
    "n",
    "name",
    "namespace",
    "network",
    "newcode",
    "nextpage",
    "noautolist",
    "nonreentrant",
    "nosubgrouping",
    "note",
    "o",
    "obsolete",
    "oldcode",
    "omit",
    "omitvalue",
    "only",
    "opengl",
    "overload",
    "p",
    "package",
    "page",
    "par",
    "paragraph",
    "param",
    "parblock",
    "part",
    "post",
    "pre",
    "preliminary",
    "previouspage",
    "printline",
    "printto",
    "printuntil",
    "private",
    "privatesection",
    "property",
    "protected",
    "protectedsection",
    "protocol",
    "public",
    "publicsection",
    "pure",
    "qmlabstract",
    "qmlattachedproperty",
    "qmlattachedsignal",
    "qmlbasictype",
    "qmlclass",
    "qmlmethod",
    "qmlmodule",
    "qmlproperty",
    "qmlsignal",
    "qmltype",
    "qt3support",
    "qtestlib",
    "quotation",
    "quotefile",
    "quotefromfile",
    "quotefunction",
    "raw",
    "reentrant",
    "ref",
    "refitem",
    "reimp",
    "related",
    "relatedalso",
    "relates",
    "relatesalso",
    "remark",
    "remarks",
    "result",
    "return",
    "returns",
    "retval",
    "row",
    "rtfonly",
    "sa",
    "secreflist",
    "section",
    "section1",
    "section2",
    "section3",
    "section4",
    "see",
    "service",
    "short",
    "showinitializer",
    "sidebar",
    "since",
    "skip",
    "skipline",
    "skipto",
    "skipuntil",
    "snippet",
    "span",
    "sql",
    "startpage",
    "startuml",
    "struct",
    "sub",
    "subpage",
    "subsection",
    "subsubsection",
    "subtitle",
    "sup",
    "svg",
    "table",
    "tableofcontents",
    "target",
    "test",
    "threadsafe",
    "throw",
    "throws",
    "title",
    "todo",
    "tparam",
    "tt",
    "typedef",
    "uicontrol",
    "uitools",
    "underline",
    "unicode",
    "union",
    "until",
    "value",
    "var",
    "variable",
    "verbatim",
    "verbinclude",
    "version",
    "vhdlflow",
    "warning",
    "weakgroup",
    "webkit",
    "xml",
    "xmlonly",
    "xrefitem",
};

const char *CppTools::doxygenTagSpell(int index)
{ return doxy_token_spell[index]; }

static inline int classify1(const QChar *s) {
  if (s[0].unicode() == 'a') {
    return T_DOXY_A;
  }
  else if (s[0].unicode() == 'b') {
    return T_DOXY_B;
  }
  else if (s[0].unicode() == 'c') {
    return T_DOXY_C;
  }
  else if (s[0].unicode() == 'e') {
    return T_DOXY_E;
  }
  else if (s[0].unicode() == 'i') {
    return T_DOXY_I;
  }
  else if (s[0].unicode() == 'l') {
    return T_DOXY_L;
  }
  else if (s[0].unicode() == 'n') {
    return T_DOXY_N;
  }
  else if (s[0].unicode() == 'o') {
    return T_DOXY_O;
  }
  else if (s[0].unicode() == 'p') {
    return T_DOXY_P;
  }
  return T_DOXY_IDENTIFIER;
}

static inline int classify2(const QChar *s) {
  if (s[0].unicode() == 'e') {
    if (s[1].unicode() == 'm') {
      return T_DOXY_EM;
    }
  }
  else if (s[0].unicode() == 'f') {
    if (s[1].unicode() == 'n') {
      return T_DOXY_FN;
    }
  }
  else if (s[0].unicode() == 'i') {
    if (s[1].unicode() == 'f') {
      return T_DOXY_IF;
    }
  }
  else if (s[0].unicode() == 'l') {
    if (s[1].unicode() == 'i') {
      return T_DOXY_LI;
    }
  }
  else if (s[0].unicode() == 's') {
    if (s[1].unicode() == 'a') {
      return T_DOXY_SA;
    }
  }
  else if (s[0].unicode() == 't') {
    if (s[1].unicode() == 't') {
      return T_DOXY_TT;
    }
  }
  return T_DOXY_IDENTIFIER;
}

static inline int classify3(const QChar *s) {
  if (s[0].unicode() == 'a') {
    if (s[1].unicode() == 'r') {
      if (s[2].unicode() == 'g') {
        return T_DOXY_ARG;
      }
    }
  }
  else if (s[0].unicode() == 'b') {
    if (s[1].unicode() == 'u') {
      if (s[2].unicode() == 'g') {
        return T_DOXY_BUG;
      }
    }
  }
  else if (s[0].unicode() == 'd') {
    if (s[1].unicode() == 'e') {
      if (s[2].unicode() == 'f') {
        return T_DOXY_DEF;
      }
    }
    else if (s[1].unicode() == 'i') {
      if (s[2].unicode() == 'r') {
        return T_DOXY_DIR;
      }
      else if (s[2].unicode() == 'v') {
        return T_DOXY_DIV;
      }
    }
    else if (s[1].unicode() == 'o') {
      if (s[2].unicode() == 't') {
        return T_DOXY_DOT;
      }
    }
  }
  else if (s[0].unicode() == 'g') {
    if (s[1].unicode() == 'u') {
      if (s[2].unicode() == 'i') {
        return T_DOXY_GUI;
      }
    }
  }
  else if (s[0].unicode() == 'm') {
    if (s[1].unicode() == 's') {
      if (s[2].unicode() == 'c') {
        return T_DOXY_MSC;
      }
    }
  }
  else if (s[0].unicode() == 'p') {
    if (s[1].unicode() == 'a') {
      if (s[2].unicode() == 'r') {
        return T_DOXY_PAR;
      }
    }
    else if (s[1].unicode() == 'r') {
      if (s[2].unicode() == 'e') {
        return T_DOXY_PRE;
      }
    }
  }
  else if (s[0].unicode() == 'r') {
    if (s[1].unicode() == 'a') {
      if (s[2].unicode() == 'w') {
        return T_DOXY_RAW;
      }
    }
    else if (s[1].unicode() == 'e') {
      if (s[2].unicode() == 'f') {
        return T_DOXY_REF;
      }
    }
    else if (s[1].unicode() == 'o') {
      if (s[2].unicode() == 'w') {
        return T_DOXY_ROW;
      }
    }
  }
  else if (s[0].unicode() == 's') {
    if (s[1].unicode() == 'e') {
      if (s[2].unicode() == 'e') {
        return T_DOXY_SEE;
      }
    }
    else if (s[1].unicode() == 'q') {
      if (s[2].unicode() == 'l') {
        return T_DOXY_SQL;
      }
    }
    else if (s[1].unicode() == 'u') {
      if (s[2].unicode() == 'b') {
        return T_DOXY_SUB;
      }
      else if (s[2].unicode() == 'p') {
        return T_DOXY_SUP;
      }
    }
    else if (s[1].unicode() == 'v') {
      if (s[2].unicode() == 'g') {
        return T_DOXY_SVG;
      }
    }
  }
  else if (s[0].unicode() == 'v') {
    if (s[1].unicode() == 'a') {
      if (s[2].unicode() == 'r') {
        return T_DOXY_VAR;
      }
    }
  }
  else if (s[0].unicode() == 'x') {
    if (s[1].unicode() == 'm') {
      if (s[2].unicode() == 'l') {
        return T_DOXY_XML;
      }
    }
  }
  return T_DOXY_IDENTIFIER;
}

static inline int classify4(const QChar *s) {
  if (s[0].unicode() == 'b') {
    if (s[1].unicode() == 'o') {
      if (s[2].unicode() == 'l') {
        if (s[3].unicode() == 'd') {
          return T_DOXY_BOLD;
        }
      }
    }
  }
  else if (s[0].unicode() == 'c') {
    if (s[1].unicode() == 'i') {
      if (s[2].unicode() == 't') {
        if (s[3].unicode() == 'e') {
          return T_DOXY_CITE;
        }
      }
    }
    else if (s[1].unicode() == 'o') {
      if (s[2].unicode() == 'd') {
        if (s[3].unicode() == 'e') {
          return T_DOXY_CODE;
        }
      }
      else if (s[2].unicode() == 'n') {
        if (s[3].unicode() == 'd') {
          return T_DOXY_COND;
        }
      }
    }
  }
  else if (s[0].unicode() == 'd') {
    if (s[1].unicode() == 'a') {
      if (s[2].unicode() == 't') {
        if (s[3].unicode() == 'e') {
          return T_DOXY_DATE;
        }
      }
    }
    else if (s[1].unicode() == 'o') {
      if (s[2].unicode() == 't') {
        if (s[3].unicode() == 's') {
          return T_DOXY_DOTS;
        }
      }
    }
  }
  else if (s[0].unicode() == 'e') {
    if (s[1].unicode() == 'l') {
      if (s[2].unicode() == 's') {
        if (s[3].unicode() == 'e') {
          return T_DOXY_ELSE;
        }
      }
    }
    else if (s[1].unicode() == 'n') {
      if (s[2].unicode() == 'u') {
        if (s[3].unicode() == 'm') {
          return T_DOXY_ENUM;
        }
      }
    }
  }
  else if (s[0].unicode() == 'f') {
    if (s[1].unicode() == 'i') {
      if (s[2].unicode() == 'l') {
        if (s[3].unicode() == 'e') {
          return T_DOXY_FILE;
        }
      }
    }
  }
  else if (s[0].unicode() == 'l') {
    if (s[1].unicode() == 'i') {
      if (s[2].unicode() == 'n') {
        if (s[3].unicode() == 'e') {
          return T_DOXY_LINE;
        }
        else if (s[3].unicode() == 'k') {
          return T_DOXY_LINK;
        }
      }
      else if (s[2].unicode() == 's') {
        if (s[3].unicode() == 't') {
          return T_DOXY_LIST;
        }
      }
    }
  }
  else if (s[0].unicode() == 'm') {
    if (s[1].unicode() == 'e') {
      if (s[2].unicode() == 't') {
        if (s[3].unicode() == 'a') {
          return T_DOXY_META;
        }
      }
    }
  }
  else if (s[0].unicode() == 'n') {
    if (s[1].unicode() == 'a') {
      if (s[2].unicode() == 'm') {
        if (s[3].unicode() == 'e') {
          return T_DOXY_NAME;
        }
      }
    }
    else if (s[1].unicode() == 'o') {
      if (s[2].unicode() == 't') {
        if (s[3].unicode() == 'e') {
          return T_DOXY_NOTE;
        }
      }
    }
  }
  else if (s[0].unicode() == 'o') {
    if (s[1].unicode() == 'm') {
      if (s[2].unicode() == 'i') {
        if (s[3].unicode() == 't') {
          return T_DOXY_OMIT;
        }
      }
    }
    else if (s[1].unicode() == 'n') {
      if (s[2].unicode() == 'l') {
        if (s[3].unicode() == 'y') {
          return T_DOXY_ONLY;
        }
      }
    }
  }
  else if (s[0].unicode() == 'p') {
    if (s[1].unicode() == 'a') {
      if (s[2].unicode() == 'g') {
        if (s[3].unicode() == 'e') {
          return T_DOXY_PAGE;
        }
      }
      else if (s[2].unicode() == 'r') {
        if (s[3].unicode() == 't') {
          return T_DOXY_PART;
        }
      }
    }
    else if (s[1].unicode() == 'o') {
      if (s[2].unicode() == 's') {
        if (s[3].unicode() == 't') {
          return T_DOXY_POST;
        }
      }
    }
    else if (s[1].unicode() == 'u') {
      if (s[2].unicode() == 'r') {
        if (s[3].unicode() == 'e') {
          return T_DOXY_PURE;
        }
      }
    }
  }
  else if (s[0].unicode() == 's') {
    if (s[1].unicode() == 'k') {
      if (s[2].unicode() == 'i') {
        if (s[3].unicode() == 'p') {
          return T_DOXY_SKIP;
        }
      }
    }
    else if (s[1].unicode() == 'p') {
      if (s[2].unicode() == 'a') {
        if (s[3].unicode() == 'n') {
          return T_DOXY_SPAN;
        }
      }
    }
  }
  else if (s[0].unicode() == 't') {
    if (s[1].unicode() == 'e') {
      if (s[2].unicode() == 's') {
        if (s[3].unicode() == 't') {
          return T_DOXY_TEST;
        }
      }
    }
    else if (s[1].unicode() == 'o') {
      if (s[2].unicode() == 'd') {
        if (s[3].unicode() == 'o') {
          return T_DOXY_TODO;
        }
      }
    }
  }
  return T_DOXY_IDENTIFIER;
}

static inline int classify5(const QChar *s) {
  if (s[0].unicode() == 'b') {
    if (s[1].unicode() == 'r') {
      if (s[2].unicode() == 'i') {
        if (s[3].unicode() == 'e') {
          if (s[4].unicode() == 'f') {
            return T_DOXY_BRIEF;
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'c') {
    if (s[1].unicode() == 'l') {
      if (s[2].unicode() == 'a') {
        if (s[3].unicode() == 's') {
          if (s[4].unicode() == 's') {
            return T_DOXY_CLASS;
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'e') {
    if (s[1].unicode() == 'n') {
      if (s[2].unicode() == 'd') {
        if (s[3].unicode() == 'i') {
          if (s[4].unicode() == 'f') {
            return T_DOXY_ENDIF;
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'g') {
    if (s[1].unicode() == 'r') {
      if (s[2].unicode() == 'o') {
        if (s[3].unicode() == 'u') {
          if (s[4].unicode() == 'p') {
            return T_DOXY_GROUP;
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'i') {
    if (s[1].unicode() == 'f') {
      if (s[2].unicode() == 'n') {
        if (s[3].unicode() == 'o') {
          if (s[4].unicode() == 't') {
            return T_DOXY_IFNOT;
          }
        }
      }
    }
    else if (s[1].unicode() == 'm') {
      if (s[2].unicode() == 'a') {
        if (s[3].unicode() == 'g') {
          if (s[4].unicode() == 'e') {
            return T_DOXY_IMAGE;
          }
        }
      }
    }
    else if (s[1].unicode() == 'n') {
      if (s[2].unicode() == 'd') {
        if (s[3].unicode() == 'e') {
          if (s[4].unicode() == 'x') {
            return T_DOXY_INDEX;
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'm') {
    if (s[1].unicode() == 'a') {
      if (s[2].unicode() == 'c') {
        if (s[3].unicode() == 'r') {
          if (s[4].unicode() == 'o') {
            return T_DOXY_MACRO;
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'p') {
    if (s[1].unicode() == 'a') {
      if (s[2].unicode() == 'r') {
        if (s[3].unicode() == 'a') {
          if (s[4].unicode() == 'm') {
            return T_DOXY_PARAM;
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'r') {
    if (s[1].unicode() == 'e') {
      if (s[2].unicode() == 'i') {
        if (s[3].unicode() == 'm') {
          if (s[4].unicode() == 'p') {
            return T_DOXY_REIMP;
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 's') {
    if (s[1].unicode() == 'h') {
      if (s[2].unicode() == 'o') {
        if (s[3].unicode() == 'r') {
          if (s[4].unicode() == 't') {
            return T_DOXY_SHORT;
          }
        }
      }
    }
    else if (s[1].unicode() == 'i') {
      if (s[2].unicode() == 'n') {
        if (s[3].unicode() == 'c') {
          if (s[4].unicode() == 'e') {
            return T_DOXY_SINCE;
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 't') {
    if (s[1].unicode() == 'a') {
      if (s[2].unicode() == 'b') {
        if (s[3].unicode() == 'l') {
          if (s[4].unicode() == 'e') {
            return T_DOXY_TABLE;
          }
        }
      }
    }
    else if (s[1].unicode() == 'h') {
      if (s[2].unicode() == 'r') {
        if (s[3].unicode() == 'o') {
          if (s[4].unicode() == 'w') {
            return T_DOXY_THROW;
          }
        }
      }
    }
    else if (s[1].unicode() == 'i') {
      if (s[2].unicode() == 't') {
        if (s[3].unicode() == 'l') {
          if (s[4].unicode() == 'e') {
            return T_DOXY_TITLE;
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'u') {
    if (s[1].unicode() == 'n') {
      if (s[2].unicode() == 'i') {
        if (s[3].unicode() == 'o') {
          if (s[4].unicode() == 'n') {
            return T_DOXY_UNION;
          }
        }
      }
      else if (s[2].unicode() == 't') {
        if (s[3].unicode() == 'i') {
          if (s[4].unicode() == 'l') {
            return T_DOXY_UNTIL;
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'v') {
    if (s[1].unicode() == 'a') {
      if (s[2].unicode() == 'l') {
        if (s[3].unicode() == 'u') {
          if (s[4].unicode() == 'e') {
            return T_DOXY_VALUE;
          }
        }
      }
    }
  }
  return T_DOXY_IDENTIFIER;
}

static inline int classify6(const QChar *s) {
  if (s[0].unicode() == 'a') {
    if (s[1].unicode() == 'n') {
      if (s[2].unicode() == 'c') {
        if (s[3].unicode() == 'h') {
          if (s[4].unicode() == 'o') {
            if (s[5].unicode() == 'r') {
              return T_DOXY_ANCHOR;
            }
          }
        }
      }
    }
    else if (s[1].unicode() == 'u') {
      if (s[2].unicode() == 't') {
        if (s[3].unicode() == 'h') {
          if (s[4].unicode() == 'o') {
            if (s[5].unicode() == 'r') {
              return T_DOXY_AUTHOR;
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'c') {
    if (s[1].unicode() == 'o') {
      if (s[2].unicode() == 'm') {
        if (s[3].unicode() == 'p') {
          if (s[4].unicode() == 'a') {
            if (s[5].unicode() == 't') {
              return T_DOXY_COMPAT;
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'e') {
    if (s[1].unicode() == 'l') {
      if (s[2].unicode() == 's') {
        if (s[3].unicode() == 'e') {
          if (s[4].unicode() == 'i') {
            if (s[5].unicode() == 'f') {
              return T_DOXY_ELSEIF;
            }
          }
        }
      }
    }
    else if (s[1].unicode() == 'n') {
      if (s[2].unicode() == 'd') {
        if (s[3].unicode() == 'd') {
          if (s[4].unicode() == 'o') {
            if (s[5].unicode() == 't') {
              return T_DOXY_ENDDOT;
            }
          }
        }
        else if (s[3].unicode() == 'm') {
          if (s[4].unicode() == 's') {
            if (s[5].unicode() == 'c') {
              return T_DOXY_ENDMSC;
            }
          }
        }
        else if (s[3].unicode() == 'r') {
          if (s[4].unicode() == 'a') {
            if (s[5].unicode() == 'w') {
              return T_DOXY_ENDRAW;
            }
          }
        }
        else if (s[3].unicode() == 'u') {
          if (s[4].unicode() == 'm') {
            if (s[5].unicode() == 'l') {
              return T_DOXY_ENDUML;
            }
          }
        }
      }
    }
    else if (s[1].unicode() == 'x') {
      if (s[2].unicode() == 'p') {
        if (s[3].unicode() == 'i') {
          if (s[4].unicode() == 'r') {
            if (s[5].unicode() == 'e') {
              return T_DOXY_EXPIRE;
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'h') {
    if (s[1].unicode() == 'e') {
      if (s[2].unicode() == 'a') {
        if (s[3].unicode() == 'd') {
          if (s[4].unicode() == 'e') {
            if (s[5].unicode() == 'r') {
              return T_DOXY_HEADER;
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'm') {
    if (s[1].unicode() == 'o') {
      if (s[2].unicode() == 'd') {
        if (s[3].unicode() == 'u') {
          if (s[4].unicode() == 'l') {
            if (s[5].unicode() == 'e') {
              return T_DOXY_MODULE;
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'o') {
    if (s[1].unicode() == 'p') {
      if (s[2].unicode() == 'e') {
        if (s[3].unicode() == 'n') {
          if (s[4].unicode() == 'g') {
            if (s[5].unicode() == 'l') {
              return T_DOXY_OPENGL;
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'p') {
    if (s[1].unicode() == 'u') {
      if (s[2].unicode() == 'b') {
        if (s[3].unicode() == 'l') {
          if (s[4].unicode() == 'i') {
            if (s[5].unicode() == 'c') {
              return T_DOXY_PUBLIC;
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'r') {
    if (s[1].unicode() == 'e') {
      if (s[2].unicode() == 'm') {
        if (s[3].unicode() == 'a') {
          if (s[4].unicode() == 'r') {
            if (s[5].unicode() == 'k') {
              return T_DOXY_REMARK;
            }
          }
        }
      }
      else if (s[2].unicode() == 's') {
        if (s[3].unicode() == 'u') {
          if (s[4].unicode() == 'l') {
            if (s[5].unicode() == 't') {
              return T_DOXY_RESULT;
            }
          }
        }
      }
      else if (s[2].unicode() == 't') {
        if (s[3].unicode() == 'u') {
          if (s[4].unicode() == 'r') {
            if (s[5].unicode() == 'n') {
              return T_DOXY_RETURN;
            }
          }
        }
        else if (s[3].unicode() == 'v') {
          if (s[4].unicode() == 'a') {
            if (s[5].unicode() == 'l') {
              return T_DOXY_RETVAL;
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 's') {
    if (s[1].unicode() == 'k') {
      if (s[2].unicode() == 'i') {
        if (s[3].unicode() == 'p') {
          if (s[4].unicode() == 't') {
            if (s[5].unicode() == 'o') {
              return T_DOXY_SKIPTO;
            }
          }
        }
      }
    }
    else if (s[1].unicode() == 't') {
      if (s[2].unicode() == 'r') {
        if (s[3].unicode() == 'u') {
          if (s[4].unicode() == 'c') {
            if (s[5].unicode() == 't') {
              return T_DOXY_STRUCT;
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 't') {
    if (s[1].unicode() == 'a') {
      if (s[2].unicode() == 'r') {
        if (s[3].unicode() == 'g') {
          if (s[4].unicode() == 'e') {
            if (s[5].unicode() == 't') {
              return T_DOXY_TARGET;
            }
          }
        }
      }
    }
    else if (s[1].unicode() == 'h') {
      if (s[2].unicode() == 'r') {
        if (s[3].unicode() == 'o') {
          if (s[4].unicode() == 'w') {
            if (s[5].unicode() == 's') {
              return T_DOXY_THROWS;
            }
          }
        }
      }
    }
    else if (s[1].unicode() == 'p') {
      if (s[2].unicode() == 'a') {
        if (s[3].unicode() == 'r') {
          if (s[4].unicode() == 'a') {
            if (s[5].unicode() == 'm') {
              return T_DOXY_TPARAM;
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'w') {
    if (s[1].unicode() == 'e') {
      if (s[2].unicode() == 'b') {
        if (s[3].unicode() == 'k') {
          if (s[4].unicode() == 'i') {
            if (s[5].unicode() == 't') {
              return T_DOXY_WEBKIT;
            }
          }
        }
      }
    }
  }
  return T_DOXY_IDENTIFIER;
}

static inline int classify7(const QChar *s) {
  if (s[0].unicode() == 'a') {
    if (s[1].unicode() == 'u') {
      if (s[2].unicode() == 't') {
        if (s[3].unicode() == 'h') {
          if (s[4].unicode() == 'o') {
            if (s[5].unicode() == 'r') {
              if (s[6].unicode() == 's') {
                return T_DOXY_AUTHORS;
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'b') {
    if (s[1].unicode() == 'a') {
      if (s[2].unicode() == 'd') {
        if (s[3].unicode() == 'c') {
          if (s[4].unicode() == 'o') {
            if (s[5].unicode() == 'd') {
              if (s[6].unicode() == 'e') {
                return T_DOXY_BADCODE;
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'c') {
    if (s[1].unicode() == 'a') {
      if (s[2].unicode() == 'p') {
        if (s[3].unicode() == 't') {
          if (s[4].unicode() == 'i') {
            if (s[5].unicode() == 'o') {
              if (s[6].unicode() == 'n') {
                return T_DOXY_CAPTION;
              }
            }
          }
        }
      }
    }
    else if (s[1].unicode() == 'h') {
      if (s[2].unicode() == 'a') {
        if (s[3].unicode() == 'p') {
          if (s[4].unicode() == 't') {
            if (s[5].unicode() == 'e') {
              if (s[6].unicode() == 'r') {
                return T_DOXY_CHAPTER;
              }
            }
          }
        }
      }
    }
    else if (s[1].unicode() == 'o') {
      if (s[2].unicode() == 'p') {
        if (s[3].unicode() == 'y') {
          if (s[4].unicode() == 'd') {
            if (s[5].unicode() == 'o') {
              if (s[6].unicode() == 'c') {
                return T_DOXY_COPYDOC;
              }
            }
          }
        }
      }
      else if (s[2].unicode() == 'r') {
        if (s[3].unicode() == 'e') {
          if (s[4].unicode() == 'l') {
            if (s[5].unicode() == 'i') {
              if (s[6].unicode() == 'b') {
                return T_DOXY_CORELIB;
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'd') {
    if (s[1].unicode() == 'e') {
      if (s[2].unicode() == 'f') {
        if (s[3].unicode() == 'a') {
          if (s[4].unicode() == 'u') {
            if (s[5].unicode() == 'l') {
              if (s[6].unicode() == 't') {
                return T_DOXY_DEFAULT;
              }
            }
          }
        }
      }
      else if (s[2].unicode() == 't') {
        if (s[3].unicode() == 'a') {
          if (s[4].unicode() == 'i') {
            if (s[5].unicode() == 'l') {
              if (s[6].unicode() == 's') {
                return T_DOXY_DETAILS;
              }
            }
          }
        }
      }
    }
    else if (s[1].unicode() == 'i') {
      if (s[2].unicode() == 'a') {
        if (s[3].unicode() == 'f') {
          if (s[4].unicode() == 'i') {
            if (s[5].unicode() == 'l') {
              if (s[6].unicode() == 'e') {
                return T_DOXY_DIAFILE;
              }
            }
          }
        }
      }
    }
    else if (s[1].unicode() == 'o') {
      if (s[2].unicode() == 't') {
        if (s[3].unicode() == 'f') {
          if (s[4].unicode() == 'i') {
            if (s[5].unicode() == 'l') {
              if (s[6].unicode() == 'e') {
                return T_DOXY_DOTFILE;
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'e') {
    if (s[1].unicode() == 'n') {
      if (s[2].unicode() == 'd') {
        if (s[3].unicode() == 'c') {
          if (s[4].unicode() == 'o') {
            if (s[5].unicode() == 'd') {
              if (s[6].unicode() == 'e') {
                return T_DOXY_ENDCODE;
              }
            }
            else if (s[5].unicode() == 'n') {
              if (s[6].unicode() == 'd') {
                return T_DOXY_ENDCOND;
              }
            }
          }
        }
        else if (s[3].unicode() == 'l') {
          if (s[4].unicode() == 'i') {
            if (s[5].unicode() == 'n') {
              if (s[6].unicode() == 'k') {
                return T_DOXY_ENDLINK;
              }
            }
            else if (s[5].unicode() == 's') {
              if (s[6].unicode() == 't') {
                return T_DOXY_ENDLIST;
              }
            }
          }
        }
        else if (s[3].unicode() == 'o') {
          if (s[4].unicode() == 'm') {
            if (s[5].unicode() == 'i') {
              if (s[6].unicode() == 't') {
                return T_DOXY_ENDOMIT;
              }
            }
          }
        }
        else if (s[3].unicode() == 'p') {
          if (s[4].unicode() == 'a') {
            if (s[5].unicode() == 'r') {
              if (s[6].unicode() == 't') {
                return T_DOXY_ENDPART;
              }
            }
          }
        }
      }
    }
    else if (s[1].unicode() == 'x') {
      if (s[2].unicode() == 'a') {
        if (s[3].unicode() == 'm') {
          if (s[4].unicode() == 'p') {
            if (s[5].unicode() == 'l') {
              if (s[6].unicode() == 'e') {
                return T_DOXY_EXAMPLE;
              }
            }
          }
        }
      }
      else if (s[2].unicode() == 't') {
        if (s[3].unicode() == 'e') {
          if (s[4].unicode() == 'n') {
            if (s[5].unicode() == 'd') {
              if (s[6].unicode() == 's') {
                return T_DOXY_EXTENDS;
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'i') {
    if (s[1].unicode() == 'n') {
      if (s[2].unicode() == 'c') {
        if (s[3].unicode() == 'l') {
          if (s[4].unicode() == 'u') {
            if (s[5].unicode() == 'd') {
              if (s[6].unicode() == 'e') {
                return T_DOXY_INCLUDE;
              }
            }
          }
        }
      }
      else if (s[2].unicode() == 'g') {
        if (s[3].unicode() == 'r') {
          if (s[4].unicode() == 'o') {
            if (s[5].unicode() == 'u') {
              if (s[6].unicode() == 'p') {
                return T_DOXY_INGROUP;
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'k') {
    if (s[1].unicode() == 'e') {
      if (s[2].unicode() == 'y') {
        if (s[3].unicode() == 'w') {
          if (s[4].unicode() == 'o') {
            if (s[5].unicode() == 'r') {
              if (s[6].unicode() == 'd') {
                return T_DOXY_KEYWORD;
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'm') {
    if (s[1].unicode() == 'a') {
      if (s[2].unicode() == 'n') {
        if (s[3].unicode() == 'o') {
          if (s[4].unicode() == 'n') {
            if (s[5].unicode() == 'l') {
              if (s[6].unicode() == 'y') {
                return T_DOXY_MANONLY;
              }
            }
          }
        }
      }
    }
    else if (s[1].unicode() == 's') {
      if (s[2].unicode() == 'c') {
        if (s[3].unicode() == 'f') {
          if (s[4].unicode() == 'i') {
            if (s[5].unicode() == 'l') {
              if (s[6].unicode() == 'e') {
                return T_DOXY_MSCFILE;
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'n') {
    if (s[1].unicode() == 'e') {
      if (s[2].unicode() == 't') {
        if (s[3].unicode() == 'w') {
          if (s[4].unicode() == 'o') {
            if (s[5].unicode() == 'r') {
              if (s[6].unicode() == 'k') {
                return T_DOXY_NETWORK;
              }
            }
          }
        }
      }
      else if (s[2].unicode() == 'w') {
        if (s[3].unicode() == 'c') {
          if (s[4].unicode() == 'o') {
            if (s[5].unicode() == 'd') {
              if (s[6].unicode() == 'e') {
                return T_DOXY_NEWCODE;
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'o') {
    if (s[1].unicode() == 'l') {
      if (s[2].unicode() == 'd') {
        if (s[3].unicode() == 'c') {
          if (s[4].unicode() == 'o') {
            if (s[5].unicode() == 'd') {
              if (s[6].unicode() == 'e') {
                return T_DOXY_OLDCODE;
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'p') {
    if (s[1].unicode() == 'a') {
      if (s[2].unicode() == 'c') {
        if (s[3].unicode() == 'k') {
          if (s[4].unicode() == 'a') {
            if (s[5].unicode() == 'g') {
              if (s[6].unicode() == 'e') {
                return T_DOXY_PACKAGE;
              }
            }
          }
        }
      }
    }
    else if (s[1].unicode() == 'r') {
      if (s[2].unicode() == 'i') {
        if (s[3].unicode() == 'n') {
          if (s[4].unicode() == 't') {
            if (s[5].unicode() == 't') {
              if (s[6].unicode() == 'o') {
                return T_DOXY_PRINTTO;
              }
            }
          }
        }
        else if (s[3].unicode() == 'v') {
          if (s[4].unicode() == 'a') {
            if (s[5].unicode() == 't') {
              if (s[6].unicode() == 'e') {
                return T_DOXY_PRIVATE;
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'q') {
    if (s[1].unicode() == 'm') {
      if (s[2].unicode() == 'l') {
        if (s[3].unicode() == 't') {
          if (s[4].unicode() == 'y') {
            if (s[5].unicode() == 'p') {
              if (s[6].unicode() == 'e') {
                return T_DOXY_QMLTYPE;
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'r') {
    if (s[1].unicode() == 'e') {
      if (s[2].unicode() == 'f') {
        if (s[3].unicode() == 'i') {
          if (s[4].unicode() == 't') {
            if (s[5].unicode() == 'e') {
              if (s[6].unicode() == 'm') {
                return T_DOXY_REFITEM;
              }
            }
          }
        }
      }
      else if (s[2].unicode() == 'l') {
        if (s[3].unicode() == 'a') {
          if (s[4].unicode() == 't') {
            if (s[5].unicode() == 'e') {
              if (s[6].unicode() == 'd') {
                return T_DOXY_RELATED;
              }
              else if (s[6].unicode() == 's') {
                return T_DOXY_RELATES;
              }
            }
          }
        }
      }
      else if (s[2].unicode() == 'm') {
        if (s[3].unicode() == 'a') {
          if (s[4].unicode() == 'r') {
            if (s[5].unicode() == 'k') {
              if (s[6].unicode() == 's') {
                return T_DOXY_REMARKS;
              }
            }
          }
        }
      }
      else if (s[2].unicode() == 't') {
        if (s[3].unicode() == 'u') {
          if (s[4].unicode() == 'r') {
            if (s[5].unicode() == 'n') {
              if (s[6].unicode() == 's') {
                return T_DOXY_RETURNS;
              }
            }
          }
        }
      }
    }
    else if (s[1].unicode() == 't') {
      if (s[2].unicode() == 'f') {
        if (s[3].unicode() == 'o') {
          if (s[4].unicode() == 'n') {
            if (s[5].unicode() == 'l') {
              if (s[6].unicode() == 'y') {
                return T_DOXY_RTFONLY;
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 's') {
    if (s[1].unicode() == 'e') {
      if (s[2].unicode() == 'c') {
        if (s[3].unicode() == 't') {
          if (s[4].unicode() == 'i') {
            if (s[5].unicode() == 'o') {
              if (s[6].unicode() == 'n') {
                return T_DOXY_SECTION;
              }
            }
          }
        }
      }
      else if (s[2].unicode() == 'r') {
        if (s[3].unicode() == 'v') {
          if (s[4].unicode() == 'i') {
            if (s[5].unicode() == 'c') {
              if (s[6].unicode() == 'e') {
                return T_DOXY_SERVICE;
              }
            }
          }
        }
      }
    }
    else if (s[1].unicode() == 'i') {
      if (s[2].unicode() == 'd') {
        if (s[3].unicode() == 'e') {
          if (s[4].unicode() == 'b') {
            if (s[5].unicode() == 'a') {
              if (s[6].unicode() == 'r') {
                return T_DOXY_SIDEBAR;
              }
            }
          }
        }
      }
    }
    else if (s[1].unicode() == 'n') {
      if (s[2].unicode() == 'i') {
        if (s[3].unicode() == 'p') {
          if (s[4].unicode() == 'p') {
            if (s[5].unicode() == 'e') {
              if (s[6].unicode() == 't') {
                return T_DOXY_SNIPPET;
              }
            }
          }
        }
      }
    }
    else if (s[1].unicode() == 'u') {
      if (s[2].unicode() == 'b') {
        if (s[3].unicode() == 'p') {
          if (s[4].unicode() == 'a') {
            if (s[5].unicode() == 'g') {
              if (s[6].unicode() == 'e') {
                return T_DOXY_SUBPAGE;
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 't') {
    if (s[1].unicode() == 'y') {
      if (s[2].unicode() == 'p') {
        if (s[3].unicode() == 'e') {
          if (s[4].unicode() == 'd') {
            if (s[5].unicode() == 'e') {
              if (s[6].unicode() == 'f') {
                return T_DOXY_TYPEDEF;
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'u') {
    if (s[1].unicode() == 'i') {
      if (s[2].unicode() == 't') {
        if (s[3].unicode() == 'o') {
          if (s[4].unicode() == 'o') {
            if (s[5].unicode() == 'l') {
              if (s[6].unicode() == 's') {
                return T_DOXY_UITOOLS;
              }
            }
          }
        }
      }
    }
    else if (s[1].unicode() == 'n') {
      if (s[2].unicode() == 'i') {
        if (s[3].unicode() == 'c') {
          if (s[4].unicode() == 'o') {
            if (s[5].unicode() == 'd') {
              if (s[6].unicode() == 'e') {
                return T_DOXY_UNICODE;
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'v') {
    if (s[1].unicode() == 'e') {
      if (s[2].unicode() == 'r') {
        if (s[3].unicode() == 's') {
          if (s[4].unicode() == 'i') {
            if (s[5].unicode() == 'o') {
              if (s[6].unicode() == 'n') {
                return T_DOXY_VERSION;
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'w') {
    if (s[1].unicode() == 'a') {
      if (s[2].unicode() == 'r') {
        if (s[3].unicode() == 'n') {
          if (s[4].unicode() == 'i') {
            if (s[5].unicode() == 'n') {
              if (s[6].unicode() == 'g') {
                return T_DOXY_WARNING;
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'x') {
    if (s[1].unicode() == 'm') {
      if (s[2].unicode() == 'l') {
        if (s[3].unicode() == 'o') {
          if (s[4].unicode() == 'n') {
            if (s[5].unicode() == 'l') {
              if (s[6].unicode() == 'y') {
                return T_DOXY_XMLONLY;
              }
            }
          }
        }
      }
    }
  }
  return T_DOXY_IDENTIFIER;
}

static inline int classify8(const QChar *s) {
  if (s[0].unicode() == 'a') {
    if (s[1].unicode() == 'b') {
      if (s[2].unicode() == 's') {
        if (s[3].unicode() == 't') {
          if (s[4].unicode() == 'r') {
            if (s[5].unicode() == 'a') {
              if (s[6].unicode() == 'c') {
                if (s[7].unicode() == 't') {
                  return T_DOXY_ABSTRACT;
                }
              }
            }
          }
        }
      }
    }
    else if (s[1].unicode() == 'd') {
      if (s[2].unicode() == 'd') {
        if (s[3].unicode() == 'i') {
          if (s[4].unicode() == 'n') {
            if (s[5].unicode() == 'd') {
              if (s[6].unicode() == 'e') {
                if (s[7].unicode() == 'x') {
                  return T_DOXY_ADDINDEX;
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'b') {
    if (s[1].unicode() == 'a') {
      if (s[2].unicode() == 's') {
        if (s[3].unicode() == 'e') {
          if (s[4].unicode() == 'n') {
            if (s[5].unicode() == 'a') {
              if (s[6].unicode() == 'm') {
                if (s[7].unicode() == 'e') {
                  return T_DOXY_BASENAME;
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'c') {
    if (s[1].unicode() == 'a') {
      if (s[2].unicode() == 't') {
        if (s[3].unicode() == 'e') {
          if (s[4].unicode() == 'g') {
            if (s[5].unicode() == 'o') {
              if (s[6].unicode() == 'r') {
                if (s[7].unicode() == 'y') {
                  return T_DOXY_CATEGORY;
                }
              }
            }
          }
        }
      }
    }
    else if (s[1].unicode() == 'o') {
      if (s[2].unicode() == 'd') {
        if (s[3].unicode() == 'e') {
          if (s[4].unicode() == 'l') {
            if (s[5].unicode() == 'i') {
              if (s[6].unicode() == 'n') {
                if (s[7].unicode() == 'e') {
                  return T_DOXY_CODELINE;
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'd') {
    if (s[1].unicode() == 'e') {
      if (s[2].unicode() == 'f') {
        if (s[3].unicode() == 'g') {
          if (s[4].unicode() == 'r') {
            if (s[5].unicode() == 'o') {
              if (s[6].unicode() == 'u') {
                if (s[7].unicode() == 'p') {
                  return T_DOXY_DEFGROUP;
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'e') {
    if (s[1].unicode() == 'n') {
      if (s[2].unicode() == 'd') {
        if (s[3].unicode() == 't') {
          if (s[4].unicode() == 'a') {
            if (s[5].unicode() == 'b') {
              if (s[6].unicode() == 'l') {
                if (s[7].unicode() == 'e') {
                  return T_DOXY_ENDTABLE;
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'f') {
    if (s[1].unicode() == 'o') {
      if (s[2].unicode() == 'o') {
        if (s[3].unicode() == 't') {
          if (s[4].unicode() == 'n') {
            if (s[5].unicode() == 'o') {
              if (s[6].unicode() == 't') {
                if (s[7].unicode() == 'e') {
                  return T_DOXY_FOOTNOTE;
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'h') {
    if (s[1].unicode() == 't') {
      if (s[2].unicode() == 'm') {
        if (s[3].unicode() == 'l') {
          if (s[4].unicode() == 'o') {
            if (s[5].unicode() == 'n') {
              if (s[6].unicode() == 'l') {
                if (s[7].unicode() == 'y') {
                  return T_DOXY_HTMLONLY;
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'i') {
    if (s[1].unicode() == 'n') {
      if (s[2].unicode() == 'h') {
        if (s[3].unicode() == 'e') {
          if (s[4].unicode() == 'r') {
            if (s[5].unicode() == 'i') {
              if (s[6].unicode() == 't') {
                if (s[7].unicode() == 's') {
                  return T_DOXY_INHERITS;
                }
              }
            }
          }
        }
      }
      else if (s[2].unicode() == 'm') {
        if (s[3].unicode() == 'o') {
          if (s[4].unicode() == 'd') {
            if (s[5].unicode() == 'u') {
              if (s[6].unicode() == 'l') {
                if (s[7].unicode() == 'e') {
                  return T_DOXY_INMODULE;
                }
              }
            }
          }
        }
      }
      else if (s[2].unicode() == 't') {
        if (s[3].unicode() == 'e') {
          if (s[4].unicode() == 'r') {
            if (s[5].unicode() == 'n') {
              if (s[6].unicode() == 'a') {
                if (s[7].unicode() == 'l') {
                  return T_DOXY_INTERNAL;
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'l') {
    if (s[1].unicode() == 'e') {
      if (s[2].unicode() == 'g') {
        if (s[3].unicode() == 'a') {
          if (s[4].unicode() == 'l') {
            if (s[5].unicode() == 'e') {
              if (s[6].unicode() == 's') {
                if (s[7].unicode() == 'e') {
                  return T_DOXY_LEGALESE;
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'm') {
    if (s[1].unicode() == 'a') {
      if (s[2].unicode() == 'i') {
        if (s[3].unicode() == 'n') {
          if (s[4].unicode() == 'p') {
            if (s[5].unicode() == 'a') {
              if (s[6].unicode() == 'g') {
                if (s[7].unicode() == 'e') {
                  return T_DOXY_MAINPAGE;
                }
              }
            }
          }
        }
      }
    }
    else if (s[1].unicode() == 'e') {
      if (s[2].unicode() == 'm') {
        if (s[3].unicode() == 'b') {
          if (s[4].unicode() == 'e') {
            if (s[5].unicode() == 'r') {
              if (s[6].unicode() == 'o') {
                if (s[7].unicode() == 'f') {
                  return T_DOXY_MEMBEROF;
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'n') {
    if (s[1].unicode() == 'e') {
      if (s[2].unicode() == 'x') {
        if (s[3].unicode() == 't') {
          if (s[4].unicode() == 'p') {
            if (s[5].unicode() == 'a') {
              if (s[6].unicode() == 'g') {
                if (s[7].unicode() == 'e') {
                  return T_DOXY_NEXTPAGE;
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'o') {
    if (s[1].unicode() == 'b') {
      if (s[2].unicode() == 's') {
        if (s[3].unicode() == 'o') {
          if (s[4].unicode() == 'l') {
            if (s[5].unicode() == 'e') {
              if (s[6].unicode() == 't') {
                if (s[7].unicode() == 'e') {
                  return T_DOXY_OBSOLETE;
                }
              }
            }
          }
        }
      }
    }
    else if (s[1].unicode() == 'v') {
      if (s[2].unicode() == 'e') {
        if (s[3].unicode() == 'r') {
          if (s[4].unicode() == 'l') {
            if (s[5].unicode() == 'o') {
              if (s[6].unicode() == 'a') {
                if (s[7].unicode() == 'd') {
                  return T_DOXY_OVERLOAD;
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'p') {
    if (s[1].unicode() == 'a') {
      if (s[2].unicode() == 'r') {
        if (s[3].unicode() == 'b') {
          if (s[4].unicode() == 'l') {
            if (s[5].unicode() == 'o') {
              if (s[6].unicode() == 'c') {
                if (s[7].unicode() == 'k') {
                  return T_DOXY_PARBLOCK;
                }
              }
            }
          }
        }
      }
    }
    else if (s[1].unicode() == 'r') {
      if (s[2].unicode() == 'o') {
        if (s[3].unicode() == 'p') {
          if (s[4].unicode() == 'e') {
            if (s[5].unicode() == 'r') {
              if (s[6].unicode() == 't') {
                if (s[7].unicode() == 'y') {
                  return T_DOXY_PROPERTY;
                }
              }
            }
          }
        }
        else if (s[3].unicode() == 't') {
          if (s[4].unicode() == 'o') {
            if (s[5].unicode() == 'c') {
              if (s[6].unicode() == 'o') {
                if (s[7].unicode() == 'l') {
                  return T_DOXY_PROTOCOL;
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'q') {
    if (s[1].unicode() == 'm') {
      if (s[2].unicode() == 'l') {
        if (s[3].unicode() == 'c') {
          if (s[4].unicode() == 'l') {
            if (s[5].unicode() == 'a') {
              if (s[6].unicode() == 's') {
                if (s[7].unicode() == 's') {
                  return T_DOXY_QMLCLASS;
                }
              }
            }
          }
        }
      }
    }
    else if (s[1].unicode() == 't') {
      if (s[2].unicode() == 'e') {
        if (s[3].unicode() == 's') {
          if (s[4].unicode() == 't') {
            if (s[5].unicode() == 'l') {
              if (s[6].unicode() == 'i') {
                if (s[7].unicode() == 'b') {
                  return T_DOXY_QTESTLIB;
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 's') {
    if (s[1].unicode() == 'e') {
      if (s[2].unicode() == 'c') {
        if (s[3].unicode() == 't') {
          if (s[4].unicode() == 'i') {
            if (s[5].unicode() == 'o') {
              if (s[6].unicode() == 'n') {
                if (s[7].unicode() == '1') {
                  return T_DOXY_SECTION1;
                }
                else if (s[7].unicode() == '2') {
                  return T_DOXY_SECTION2;
                }
                else if (s[7].unicode() == '3') {
                  return T_DOXY_SECTION3;
                }
                else if (s[7].unicode() == '4') {
                  return T_DOXY_SECTION4;
                }
              }
            }
          }
        }
      }
    }
    else if (s[1].unicode() == 'k') {
      if (s[2].unicode() == 'i') {
        if (s[3].unicode() == 'p') {
          if (s[4].unicode() == 'l') {
            if (s[5].unicode() == 'i') {
              if (s[6].unicode() == 'n') {
                if (s[7].unicode() == 'e') {
                  return T_DOXY_SKIPLINE;
                }
              }
            }
          }
        }
      }
    }
    else if (s[1].unicode() == 't') {
      if (s[2].unicode() == 'a') {
        if (s[3].unicode() == 'r') {
          if (s[4].unicode() == 't') {
            if (s[5].unicode() == 'u') {
              if (s[6].unicode() == 'm') {
                if (s[7].unicode() == 'l') {
                  return T_DOXY_STARTUML;
                }
              }
            }
          }
        }
      }
    }
    else if (s[1].unicode() == 'u') {
      if (s[2].unicode() == 'b') {
        if (s[3].unicode() == 't') {
          if (s[4].unicode() == 'i') {
            if (s[5].unicode() == 't') {
              if (s[6].unicode() == 'l') {
                if (s[7].unicode() == 'e') {
                  return T_DOXY_SUBTITLE;
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'v') {
    if (s[1].unicode() == 'a') {
      if (s[2].unicode() == 'r') {
        if (s[3].unicode() == 'i') {
          if (s[4].unicode() == 'a') {
            if (s[5].unicode() == 'b') {
              if (s[6].unicode() == 'l') {
                if (s[7].unicode() == 'e') {
                  return T_DOXY_VARIABLE;
                }
              }
            }
          }
        }
      }
    }
    else if (s[1].unicode() == 'e') {
      if (s[2].unicode() == 'r') {
        if (s[3].unicode() == 'b') {
          if (s[4].unicode() == 'a') {
            if (s[5].unicode() == 't') {
              if (s[6].unicode() == 'i') {
                if (s[7].unicode() == 'm') {
                  return T_DOXY_VERBATIM;
                }
              }
            }
          }
        }
      }
    }
    else if (s[1].unicode() == 'h') {
      if (s[2].unicode() == 'd') {
        if (s[3].unicode() == 'l') {
          if (s[4].unicode() == 'f') {
            if (s[5].unicode() == 'l') {
              if (s[6].unicode() == 'o') {
                if (s[7].unicode() == 'w') {
                  return T_DOXY_VHDLFLOW;
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'x') {
    if (s[1].unicode() == 'r') {
      if (s[2].unicode() == 'e') {
        if (s[3].unicode() == 'f') {
          if (s[4].unicode() == 'i') {
            if (s[5].unicode() == 't') {
              if (s[6].unicode() == 'e') {
                if (s[7].unicode() == 'm') {
                  return T_DOXY_XREFITEM;
                }
              }
            }
          }
        }
      }
    }
  }
  return T_DOXY_IDENTIFIER;
}

static inline int classify9(const QChar *s) {
  if (s[0].unicode() == 'a') {
    if (s[1].unicode() == 't') {
      if (s[2].unicode() == 't') {
        if (s[3].unicode() == 'e') {
          if (s[4].unicode() == 'n') {
            if (s[5].unicode() == 't') {
              if (s[6].unicode() == 'i') {
                if (s[7].unicode() == 'o') {
                  if (s[8].unicode() == 'n') {
                    return T_DOXY_ATTENTION;
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'c') {
    if (s[1].unicode() == 'a') {
      if (s[2].unicode() == 'l') {
        if (s[3].unicode() == 'l') {
          if (s[4].unicode() == 'g') {
            if (s[5].unicode() == 'r') {
              if (s[6].unicode() == 'a') {
                if (s[7].unicode() == 'p') {
                  if (s[8].unicode() == 'h') {
                    return T_DOXY_CALLGRAPH;
                  }
                }
              }
            }
          }
        }
      }
    }
    else if (s[1].unicode() == 'o') {
      if (s[2].unicode() == 'p') {
        if (s[3].unicode() == 'y') {
          if (s[4].unicode() == 'b') {
            if (s[5].unicode() == 'r') {
              if (s[6].unicode() == 'i') {
                if (s[7].unicode() == 'e') {
                  if (s[8].unicode() == 'f') {
                    return T_DOXY_COPYBRIEF;
                  }
                }
              }
            }
          }
          else if (s[4].unicode() == 'r') {
            if (s[5].unicode() == 'i') {
              if (s[6].unicode() == 'g') {
                if (s[7].unicode() == 'h') {
                  if (s[8].unicode() == 't') {
                    return T_DOXY_COPYRIGHT;
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'e') {
    if (s[1].unicode() == 'x') {
      if (s[2].unicode() == 'c') {
        if (s[3].unicode() == 'e') {
          if (s[4].unicode() == 'p') {
            if (s[5].unicode() == 't') {
              if (s[6].unicode() == 'i') {
                if (s[7].unicode() == 'o') {
                  if (s[8].unicode() == 'n') {
                    return T_DOXY_EXCEPTION;
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'i') {
    if (s[1].unicode() == 'd') {
      if (s[2].unicode() == 'l') {
        if (s[3].unicode() == 'e') {
          if (s[4].unicode() == 'x') {
            if (s[5].unicode() == 'c') {
              if (s[6].unicode() == 'e') {
                if (s[7].unicode() == 'p') {
                  if (s[8].unicode() == 't') {
                    return T_DOXY_IDLEXCEPT;
                  }
                }
              }
            }
          }
        }
      }
    }
    else if (s[1].unicode() == 'n') {
      if (s[2].unicode() == 'd') {
        if (s[3].unicode() == 'e') {
          if (s[4].unicode() == 'x') {
            if (s[5].unicode() == 'p') {
              if (s[6].unicode() == 'a') {
                if (s[7].unicode() == 'g') {
                  if (s[8].unicode() == 'e') {
                    return T_DOXY_INDEXPAGE;
                  }
                }
              }
            }
          }
        }
      }
      else if (s[2].unicode() == 't') {
        if (s[3].unicode() == 'e') {
          if (s[4].unicode() == 'r') {
            if (s[5].unicode() == 'f') {
              if (s[6].unicode() == 'a') {
                if (s[7].unicode() == 'c') {
                  if (s[8].unicode() == 'e') {
                    return T_DOXY_INTERFACE;
                  }
                }
              }
            }
          }
        }
      }
      else if (s[2].unicode() == 'v') {
        if (s[3].unicode() == 'a') {
          if (s[4].unicode() == 'r') {
            if (s[5].unicode() == 'i') {
              if (s[6].unicode() == 'a') {
                if (s[7].unicode() == 'n') {
                  if (s[8].unicode() == 't') {
                    return T_DOXY_INVARIANT;
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'l') {
    if (s[1].unicode() == 'a') {
      if (s[2].unicode() == 't') {
        if (s[3].unicode() == 'e') {
          if (s[4].unicode() == 'x') {
            if (s[5].unicode() == 'o') {
              if (s[6].unicode() == 'n') {
                if (s[7].unicode() == 'l') {
                  if (s[8].unicode() == 'y') {
                    return T_DOXY_LATEXONLY;
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'm') {
    if (s[1].unicode() == 'a') {
      if (s[2].unicode() == 'i') {
        if (s[3].unicode() == 'n') {
          if (s[4].unicode() == 'c') {
            if (s[5].unicode() == 'l') {
              if (s[6].unicode() == 'a') {
                if (s[7].unicode() == 's') {
                  if (s[8].unicode() == 's') {
                    return T_DOXY_MAINCLASS;
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'n') {
    if (s[1].unicode() == 'a') {
      if (s[2].unicode() == 'm') {
        if (s[3].unicode() == 'e') {
          if (s[4].unicode() == 's') {
            if (s[5].unicode() == 'p') {
              if (s[6].unicode() == 'a') {
                if (s[7].unicode() == 'c') {
                  if (s[8].unicode() == 'e') {
                    return T_DOXY_NAMESPACE;
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'o') {
    if (s[1].unicode() == 'm') {
      if (s[2].unicode() == 'i') {
        if (s[3].unicode() == 't') {
          if (s[4].unicode() == 'v') {
            if (s[5].unicode() == 'a') {
              if (s[6].unicode() == 'l') {
                if (s[7].unicode() == 'u') {
                  if (s[8].unicode() == 'e') {
                    return T_DOXY_OMITVALUE;
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'p') {
    if (s[1].unicode() == 'a') {
      if (s[2].unicode() == 'r') {
        if (s[3].unicode() == 'a') {
          if (s[4].unicode() == 'g') {
            if (s[5].unicode() == 'r') {
              if (s[6].unicode() == 'a') {
                if (s[7].unicode() == 'p') {
                  if (s[8].unicode() == 'h') {
                    return T_DOXY_PARAGRAPH;
                  }
                }
              }
            }
          }
        }
      }
    }
    else if (s[1].unicode() == 'r') {
      if (s[2].unicode() == 'i') {
        if (s[3].unicode() == 'n') {
          if (s[4].unicode() == 't') {
            if (s[5].unicode() == 'l') {
              if (s[6].unicode() == 'i') {
                if (s[7].unicode() == 'n') {
                  if (s[8].unicode() == 'e') {
                    return T_DOXY_PRINTLINE;
                  }
                }
              }
            }
          }
        }
      }
      else if (s[2].unicode() == 'o') {
        if (s[3].unicode() == 't') {
          if (s[4].unicode() == 'e') {
            if (s[5].unicode() == 'c') {
              if (s[6].unicode() == 't') {
                if (s[7].unicode() == 'e') {
                  if (s[8].unicode() == 'd') {
                    return T_DOXY_PROTECTED;
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'q') {
    if (s[1].unicode() == 'm') {
      if (s[2].unicode() == 'l') {
        if (s[3].unicode() == 'm') {
          if (s[4].unicode() == 'e') {
            if (s[5].unicode() == 't') {
              if (s[6].unicode() == 'h') {
                if (s[7].unicode() == 'o') {
                  if (s[8].unicode() == 'd') {
                    return T_DOXY_QMLMETHOD;
                  }
                }
              }
            }
          }
          else if (s[4].unicode() == 'o') {
            if (s[5].unicode() == 'd') {
              if (s[6].unicode() == 'u') {
                if (s[7].unicode() == 'l') {
                  if (s[8].unicode() == 'e') {
                    return T_DOXY_QMLMODULE;
                  }
                }
              }
            }
          }
        }
        else if (s[3].unicode() == 's') {
          if (s[4].unicode() == 'i') {
            if (s[5].unicode() == 'g') {
              if (s[6].unicode() == 'n') {
                if (s[7].unicode() == 'a') {
                  if (s[8].unicode() == 'l') {
                    return T_DOXY_QMLSIGNAL;
                  }
                }
              }
            }
          }
        }
      }
    }
    else if (s[1].unicode() == 'u') {
      if (s[2].unicode() == 'o') {
        if (s[3].unicode() == 't') {
          if (s[4].unicode() == 'a') {
            if (s[5].unicode() == 't') {
              if (s[6].unicode() == 'i') {
                if (s[7].unicode() == 'o') {
                  if (s[8].unicode() == 'n') {
                    return T_DOXY_QUOTATION;
                  }
                }
              }
            }
          }
          else if (s[4].unicode() == 'e') {
            if (s[5].unicode() == 'f') {
              if (s[6].unicode() == 'i') {
                if (s[7].unicode() == 'l') {
                  if (s[8].unicode() == 'e') {
                    return T_DOXY_QUOTEFILE;
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'r') {
    if (s[1].unicode() == 'e') {
      if (s[2].unicode() == 'e') {
        if (s[3].unicode() == 'n') {
          if (s[4].unicode() == 't') {
            if (s[5].unicode() == 'r') {
              if (s[6].unicode() == 'a') {
                if (s[7].unicode() == 'n') {
                  if (s[8].unicode() == 't') {
                    return T_DOXY_REENTRANT;
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 's') {
    if (s[1].unicode() == 'k') {
      if (s[2].unicode() == 'i') {
        if (s[3].unicode() == 'p') {
          if (s[4].unicode() == 'u') {
            if (s[5].unicode() == 'n') {
              if (s[6].unicode() == 't') {
                if (s[7].unicode() == 'i') {
                  if (s[8].unicode() == 'l') {
                    return T_DOXY_SKIPUNTIL;
                  }
                }
              }
            }
          }
        }
      }
    }
    else if (s[1].unicode() == 't') {
      if (s[2].unicode() == 'a') {
        if (s[3].unicode() == 'r') {
          if (s[4].unicode() == 't') {
            if (s[5].unicode() == 'p') {
              if (s[6].unicode() == 'a') {
                if (s[7].unicode() == 'g') {
                  if (s[8].unicode() == 'e') {
                    return T_DOXY_STARTPAGE;
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'u') {
    if (s[1].unicode() == 'i') {
      if (s[2].unicode() == 'c') {
        if (s[3].unicode() == 'o') {
          if (s[4].unicode() == 'n') {
            if (s[5].unicode() == 't') {
              if (s[6].unicode() == 'r') {
                if (s[7].unicode() == 'o') {
                  if (s[8].unicode() == 'l') {
                    return T_DOXY_UICONTROL;
                  }
                }
              }
            }
          }
        }
      }
    }
    else if (s[1].unicode() == 'n') {
      if (s[2].unicode() == 'd') {
        if (s[3].unicode() == 'e') {
          if (s[4].unicode() == 'r') {
            if (s[5].unicode() == 'l') {
              if (s[6].unicode() == 'i') {
                if (s[7].unicode() == 'n') {
                  if (s[8].unicode() == 'e') {
                    return T_DOXY_UNDERLINE;
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'w') {
    if (s[1].unicode() == 'e') {
      if (s[2].unicode() == 'a') {
        if (s[3].unicode() == 'k') {
          if (s[4].unicode() == 'g') {
            if (s[5].unicode() == 'r') {
              if (s[6].unicode() == 'o') {
                if (s[7].unicode() == 'u') {
                  if (s[8].unicode() == 'p') {
                    return T_DOXY_WEAKGROUP;
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  return T_DOXY_IDENTIFIER;
}

static inline int classify10(const QChar *s) {
  if (s[0].unicode() == 'a') {
    if (s[1].unicode() == 'd') {
      if (s[2].unicode() == 'd') {
        if (s[3].unicode() == 't') {
          if (s[4].unicode() == 'o') {
            if (s[5].unicode() == 'g') {
              if (s[6].unicode() == 'r') {
                if (s[7].unicode() == 'o') {
                  if (s[8].unicode() == 'u') {
                    if (s[9].unicode() == 'p') {
                      return T_DOXY_ADDTOGROUP;
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'd') {
    if (s[1].unicode() == 'e') {
      if (s[2].unicode() == 'p') {
        if (s[3].unicode() == 'r') {
          if (s[4].unicode() == 'e') {
            if (s[5].unicode() == 'c') {
              if (s[6].unicode() == 'a') {
                if (s[7].unicode() == 't') {
                  if (s[8].unicode() == 'e') {
                    if (s[9].unicode() == 'd') {
                      return T_DOXY_DEPRECATED;
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'e') {
    if (s[1].unicode() == 'n') {
      if (s[2].unicode() == 'd') {
        if (s[3].unicode() == 'c') {
          if (s[4].unicode() == 'h') {
            if (s[5].unicode() == 'a') {
              if (s[6].unicode() == 'p') {
                if (s[7].unicode() == 't') {
                  if (s[8].unicode() == 'e') {
                    if (s[9].unicode() == 'r') {
                      return T_DOXY_ENDCHAPTER;
                    }
                  }
                }
              }
            }
          }
        }
        else if (s[3].unicode() == 'm') {
          if (s[4].unicode() == 'a') {
            if (s[5].unicode() == 'n') {
              if (s[6].unicode() == 'o') {
                if (s[7].unicode() == 'n') {
                  if (s[8].unicode() == 'l') {
                    if (s[9].unicode() == 'y') {
                      return T_DOXY_ENDMANONLY;
                    }
                  }
                }
              }
            }
          }
        }
        else if (s[3].unicode() == 'r') {
          if (s[4].unicode() == 't') {
            if (s[5].unicode() == 'f') {
              if (s[6].unicode() == 'o') {
                if (s[7].unicode() == 'n') {
                  if (s[8].unicode() == 'l') {
                    if (s[9].unicode() == 'y') {
                      return T_DOXY_ENDRTFONLY;
                    }
                  }
                }
              }
            }
          }
        }
        else if (s[3].unicode() == 's') {
          if (s[4].unicode() == 'i') {
            if (s[5].unicode() == 'd') {
              if (s[6].unicode() == 'e') {
                if (s[7].unicode() == 'b') {
                  if (s[8].unicode() == 'a') {
                    if (s[9].unicode() == 'r') {
                      return T_DOXY_ENDSIDEBAR;
                    }
                  }
                }
              }
            }
          }
        }
        else if (s[3].unicode() == 'x') {
          if (s[4].unicode() == 'm') {
            if (s[5].unicode() == 'l') {
              if (s[6].unicode() == 'o') {
                if (s[7].unicode() == 'n') {
                  if (s[8].unicode() == 'l') {
                    if (s[9].unicode() == 'y') {
                      return T_DOXY_ENDXMLONLY;
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
    else if (s[1].unicode() == 'x') {
      if (s[2].unicode() == 'c') {
        if (s[3].unicode() == 'e') {
          if (s[4].unicode() == 'p') {
            if (s[5].unicode() == 't') {
              if (s[6].unicode() == 'i') {
                if (s[7].unicode() == 'o') {
                  if (s[8].unicode() == 'n') {
                    if (s[9].unicode() == 's') {
                      return T_DOXY_EXCEPTIONS;
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'h') {
    if (s[1].unicode() == 'e') {
      if (s[2].unicode() == 'a') {
        if (s[3].unicode() == 'd') {
          if (s[4].unicode() == 'e') {
            if (s[5].unicode() == 'r') {
              if (s[6].unicode() == 'f') {
                if (s[7].unicode() == 'i') {
                  if (s[8].unicode() == 'l') {
                    if (s[9].unicode() == 'e') {
                      return T_DOXY_HEADERFILE;
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'i') {
    if (s[1].unicode() == 'm') {
      if (s[2].unicode() == 'p') {
        if (s[3].unicode() == 'l') {
          if (s[4].unicode() == 'e') {
            if (s[5].unicode() == 'm') {
              if (s[6].unicode() == 'e') {
                if (s[7].unicode() == 'n') {
                  if (s[8].unicode() == 't') {
                    if (s[9].unicode() == 's') {
                      return T_DOXY_IMPLEMENTS;
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'n') {
    if (s[1].unicode() == 'o') {
      if (s[2].unicode() == 'a') {
        if (s[3].unicode() == 'u') {
          if (s[4].unicode() == 't') {
            if (s[5].unicode() == 'o') {
              if (s[6].unicode() == 'l') {
                if (s[7].unicode() == 'i') {
                  if (s[8].unicode() == 's') {
                    if (s[9].unicode() == 't') {
                      return T_DOXY_NOAUTOLIST;
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'p') {
    if (s[1].unicode() == 'r') {
      if (s[2].unicode() == 'i') {
        if (s[3].unicode() == 'n') {
          if (s[4].unicode() == 't') {
            if (s[5].unicode() == 'u') {
              if (s[6].unicode() == 'n') {
                if (s[7].unicode() == 't') {
                  if (s[8].unicode() == 'i') {
                    if (s[9].unicode() == 'l') {
                      return T_DOXY_PRINTUNTIL;
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'q') {
    if (s[1].unicode() == 't') {
      if (s[2].unicode() == '3') {
        if (s[3].unicode() == 's') {
          if (s[4].unicode() == 'u') {
            if (s[5].unicode() == 'p') {
              if (s[6].unicode() == 'p') {
                if (s[7].unicode() == 'o') {
                  if (s[8].unicode() == 'r') {
                    if (s[9].unicode() == 't') {
                      return T_DOXY_QT3SUPPORT;
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 's') {
    if (s[1].unicode() == 'e') {
      if (s[2].unicode() == 'c') {
        if (s[3].unicode() == 'r') {
          if (s[4].unicode() == 'e') {
            if (s[5].unicode() == 'f') {
              if (s[6].unicode() == 'l') {
                if (s[7].unicode() == 'i') {
                  if (s[8].unicode() == 's') {
                    if (s[9].unicode() == 't') {
                      return T_DOXY_SECREFLIST;
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
    else if (s[1].unicode() == 'u') {
      if (s[2].unicode() == 'b') {
        if (s[3].unicode() == 's') {
          if (s[4].unicode() == 'e') {
            if (s[5].unicode() == 'c') {
              if (s[6].unicode() == 't') {
                if (s[7].unicode() == 'i') {
                  if (s[8].unicode() == 'o') {
                    if (s[9].unicode() == 'n') {
                      return T_DOXY_SUBSECTION;
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 't') {
    if (s[1].unicode() == 'h') {
      if (s[2].unicode() == 'r') {
        if (s[3].unicode() == 'e') {
          if (s[4].unicode() == 'a') {
            if (s[5].unicode() == 'd') {
              if (s[6].unicode() == 's') {
                if (s[7].unicode() == 'a') {
                  if (s[8].unicode() == 'f') {
                    if (s[9].unicode() == 'e') {
                      return T_DOXY_THREADSAFE;
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  return T_DOXY_IDENTIFIER;
}

static inline int classify11(const QChar *s) {
  if (s[0].unicode() == 'c') {
    if (s[1].unicode() == 'a') {
      if (s[2].unicode() == 'l') {
        if (s[3].unicode() == 'l') {
          if (s[4].unicode() == 'e') {
            if (s[5].unicode() == 'r') {
              if (s[6].unicode() == 'g') {
                if (s[7].unicode() == 'r') {
                  if (s[8].unicode() == 'a') {
                    if (s[9].unicode() == 'p') {
                      if (s[10].unicode() == 'h') {
                        return T_DOXY_CALLERGRAPH;
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
    else if (s[1].unicode() == 'o') {
      if (s[2].unicode() == 'p') {
        if (s[3].unicode() == 'y') {
          if (s[4].unicode() == 'd') {
            if (s[5].unicode() == 'e') {
              if (s[6].unicode() == 't') {
                if (s[7].unicode() == 'a') {
                  if (s[8].unicode() == 'i') {
                    if (s[9].unicode() == 'l') {
                      if (s[10].unicode() == 's') {
                        return T_DOXY_COPYDETAILS;
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'd') {
    if (s[1].unicode() == 'o') {
      if (s[2].unicode() == 'c') {
        if (s[3].unicode() == 'b') {
          if (s[4].unicode() == 'o') {
            if (s[5].unicode() == 'o') {
              if (s[6].unicode() == 'k') {
                if (s[7].unicode() == 'o') {
                  if (s[8].unicode() == 'n') {
                    if (s[9].unicode() == 'l') {
                      if (s[10].unicode() == 'y') {
                        return T_DOXY_DOCBOOKONLY;
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
      else if (s[2].unicode() == 'n') {
        if (s[3].unicode() == 't') {
          if (s[4].unicode() == 'i') {
            if (s[5].unicode() == 'n') {
              if (s[6].unicode() == 'c') {
                if (s[7].unicode() == 'l') {
                  if (s[8].unicode() == 'u') {
                    if (s[9].unicode() == 'd') {
                      if (s[10].unicode() == 'e') {
                        return T_DOXY_DONTINCLUDE;
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'e') {
    if (s[1].unicode() == 'n') {
      if (s[2].unicode() == 'd') {
        if (s[3].unicode() == 'a') {
          if (s[4].unicode() == 'b') {
            if (s[5].unicode() == 's') {
              if (s[6].unicode() == 't') {
                if (s[7].unicode() == 'r') {
                  if (s[8].unicode() == 'a') {
                    if (s[9].unicode() == 'c') {
                      if (s[10].unicode() == 't') {
                        return T_DOXY_ENDABSTRACT;
                      }
                    }
                  }
                }
              }
            }
          }
        }
        else if (s[3].unicode() == 'f') {
          if (s[4].unicode() == 'o') {
            if (s[5].unicode() == 'o') {
              if (s[6].unicode() == 't') {
                if (s[7].unicode() == 'n') {
                  if (s[8].unicode() == 'o') {
                    if (s[9].unicode() == 't') {
                      if (s[10].unicode() == 'e') {
                        return T_DOXY_ENDFOOTNOTE;
                      }
                    }
                  }
                }
              }
            }
          }
        }
        else if (s[3].unicode() == 'h') {
          if (s[4].unicode() == 't') {
            if (s[5].unicode() == 'm') {
              if (s[6].unicode() == 'l') {
                if (s[7].unicode() == 'o') {
                  if (s[8].unicode() == 'n') {
                    if (s[9].unicode() == 'l') {
                      if (s[10].unicode() == 'y') {
                        return T_DOXY_ENDHTMLONLY;
                      }
                    }
                  }
                }
              }
            }
          }
        }
        else if (s[3].unicode() == 'i') {
          if (s[4].unicode() == 'n') {
            if (s[5].unicode() == 't') {
              if (s[6].unicode() == 'e') {
                if (s[7].unicode() == 'r') {
                  if (s[8].unicode() == 'n') {
                    if (s[9].unicode() == 'a') {
                      if (s[10].unicode() == 'l') {
                        return T_DOXY_ENDINTERNAL;
                      }
                    }
                  }
                }
              }
            }
          }
        }
        else if (s[3].unicode() == 'l') {
          if (s[4].unicode() == 'e') {
            if (s[5].unicode() == 'g') {
              if (s[6].unicode() == 'a') {
                if (s[7].unicode() == 'l') {
                  if (s[8].unicode() == 'e') {
                    if (s[9].unicode() == 's') {
                      if (s[10].unicode() == 'e') {
                        return T_DOXY_ENDLEGALESE;
                      }
                    }
                  }
                }
              }
            }
          }
        }
        else if (s[3].unicode() == 'p') {
          if (s[4].unicode() == 'a') {
            if (s[5].unicode() == 'r') {
              if (s[6].unicode() == 'b') {
                if (s[7].unicode() == 'l') {
                  if (s[8].unicode() == 'o') {
                    if (s[9].unicode() == 'c') {
                      if (s[10].unicode() == 'k') {
                        return T_DOXY_ENDPARBLOCK;
                      }
                    }
                  }
                }
              }
            }
          }
        }
        else if (s[3].unicode() == 's') {
          if (s[4].unicode() == 'e') {
            if (s[5].unicode() == 'c') {
              if (s[6].unicode() == 't') {
                if (s[7].unicode() == 'i') {
                  if (s[8].unicode() == 'o') {
                    if (s[9].unicode() == 'n') {
                      if (s[10].unicode() == '1') {
                        return T_DOXY_ENDSECTION1;
                      }
                      else if (s[10].unicode() == '2') {
                        return T_DOXY_ENDSECTION2;
                      }
                      else if (s[10].unicode() == '3') {
                        return T_DOXY_ENDSECTION3;
                      }
                      else if (s[10].unicode() == '4') {
                        return T_DOXY_ENDSECTION4;
                      }
                    }
                  }
                }
              }
            }
          }
        }
        else if (s[3].unicode() == 'v') {
          if (s[4].unicode() == 'e') {
            if (s[5].unicode() == 'r') {
              if (s[6].unicode() == 'b') {
                if (s[7].unicode() == 'a') {
                  if (s[8].unicode() == 't') {
                    if (s[9].unicode() == 'i') {
                      if (s[10].unicode() == 'm') {
                        return T_DOXY_ENDVERBATIM;
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'g') {
    if (s[1].unicode() == 'r') {
      if (s[2].unicode() == 'a') {
        if (s[3].unicode() == 'n') {
          if (s[4].unicode() == 'u') {
            if (s[5].unicode() == 'l') {
              if (s[6].unicode() == 'a') {
                if (s[7].unicode() == 'r') {
                  if (s[8].unicode() == 'i') {
                    if (s[9].unicode() == 't') {
                      if (s[10].unicode() == 'y') {
                        return T_DOXY_GRANULARITY;
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'h') {
    if (s[1].unicode() == 't') {
      if (s[2].unicode() == 'm') {
        if (s[3].unicode() == 'l') {
          if (s[4].unicode() == 'i') {
            if (s[5].unicode() == 'n') {
              if (s[6].unicode() == 'c') {
                if (s[7].unicode() == 'l') {
                  if (s[8].unicode() == 'u') {
                    if (s[9].unicode() == 'd') {
                      if (s[10].unicode() == 'e') {
                        return T_DOXY_HTMLINCLUDE;
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'i') {
    if (s[1].unicode() == 'n') {
      if (s[2].unicode() == 'l') {
        if (s[3].unicode() == 'i') {
          if (s[4].unicode() == 'n') {
            if (s[5].unicode() == 'e') {
              if (s[6].unicode() == 'i') {
                if (s[7].unicode() == 'm') {
                  if (s[8].unicode() == 'a') {
                    if (s[9].unicode() == 'g') {
                      if (s[10].unicode() == 'e') {
                        return T_DOXY_INLINEIMAGE;
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
      else if (s[2].unicode() == 'q') {
        if (s[3].unicode() == 'm') {
          if (s[4].unicode() == 'l') {
            if (s[5].unicode() == 'm') {
              if (s[6].unicode() == 'o') {
                if (s[7].unicode() == 'd') {
                  if (s[8].unicode() == 'u') {
                    if (s[9].unicode() == 'l') {
                      if (s[10].unicode() == 'e') {
                        return T_DOXY_INQMLMODULE;
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'p') {
    if (s[1].unicode() == 'r') {
      if (s[2].unicode() == 'e') {
        if (s[3].unicode() == 'l') {
          if (s[4].unicode() == 'i') {
            if (s[5].unicode() == 'm') {
              if (s[6].unicode() == 'i') {
                if (s[7].unicode() == 'n') {
                  if (s[8].unicode() == 'a') {
                    if (s[9].unicode() == 'r') {
                      if (s[10].unicode() == 'y') {
                        return T_DOXY_PRELIMINARY;
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'q') {
    if (s[1].unicode() == 'm') {
      if (s[2].unicode() == 'l') {
        if (s[3].unicode() == 'a') {
          if (s[4].unicode() == 'b') {
            if (s[5].unicode() == 's') {
              if (s[6].unicode() == 't') {
                if (s[7].unicode() == 'r') {
                  if (s[8].unicode() == 'a') {
                    if (s[9].unicode() == 'c') {
                      if (s[10].unicode() == 't') {
                        return T_DOXY_QMLABSTRACT;
                      }
                    }
                  }
                }
              }
            }
          }
        }
        else if (s[3].unicode() == 'p') {
          if (s[4].unicode() == 'r') {
            if (s[5].unicode() == 'o') {
              if (s[6].unicode() == 'p') {
                if (s[7].unicode() == 'e') {
                  if (s[8].unicode() == 'r') {
                    if (s[9].unicode() == 't') {
                      if (s[10].unicode() == 'y') {
                        return T_DOXY_QMLPROPERTY;
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'r') {
    if (s[1].unicode() == 'e') {
      if (s[2].unicode() == 'l') {
        if (s[3].unicode() == 'a') {
          if (s[4].unicode() == 't') {
            if (s[5].unicode() == 'e') {
              if (s[6].unicode() == 'd') {
                if (s[7].unicode() == 'a') {
                  if (s[8].unicode() == 'l') {
                    if (s[9].unicode() == 's') {
                      if (s[10].unicode() == 'o') {
                        return T_DOXY_RELATEDALSO;
                      }
                    }
                  }
                }
              }
              else if (s[6].unicode() == 's') {
                if (s[7].unicode() == 'a') {
                  if (s[8].unicode() == 'l') {
                    if (s[9].unicode() == 's') {
                      if (s[10].unicode() == 'o') {
                        return T_DOXY_RELATESALSO;
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'v') {
    if (s[1].unicode() == 'e') {
      if (s[2].unicode() == 'r') {
        if (s[3].unicode() == 'b') {
          if (s[4].unicode() == 'i') {
            if (s[5].unicode() == 'n') {
              if (s[6].unicode() == 'c') {
                if (s[7].unicode() == 'l') {
                  if (s[8].unicode() == 'u') {
                    if (s[9].unicode() == 'd') {
                      if (s[10].unicode() == 'e') {
                        return T_DOXY_VERBINCLUDE;
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  return T_DOXY_IDENTIFIER;
}

static inline int classify12(const QChar *s) {
  if (s[0].unicode() == 'c') {
    if (s[1].unicode() == 'o') {
      if (s[2].unicode() == 'n') {
        if (s[3].unicode() == 't') {
          if (s[4].unicode() == 'e') {
            if (s[5].unicode() == 'n') {
              if (s[6].unicode() == 't') {
                if (s[7].unicode() == 's') {
                  if (s[8].unicode() == 'p') {
                    if (s[9].unicode() == 'a') {
                      if (s[10].unicode() == 'g') {
                        if (s[11].unicode() == 'e') {
                          return T_DOXY_CONTENTSPAGE;
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'e') {
    if (s[1].unicode() == 'n') {
      if (s[2].unicode() == 'd') {
        if (s[3].unicode() == 'l') {
          if (s[4].unicode() == 'a') {
            if (s[5].unicode() == 't') {
              if (s[6].unicode() == 'e') {
                if (s[7].unicode() == 'x') {
                  if (s[8].unicode() == 'o') {
                    if (s[9].unicode() == 'n') {
                      if (s[10].unicode() == 'l') {
                        if (s[11].unicode() == 'y') {
                          return T_DOXY_ENDLATEXONLY;
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
        else if (s[3].unicode() == 'q') {
          if (s[4].unicode() == 'u') {
            if (s[5].unicode() == 'o') {
              if (s[6].unicode() == 't') {
                if (s[7].unicode() == 'a') {
                  if (s[8].unicode() == 't') {
                    if (s[9].unicode() == 'i') {
                      if (s[10].unicode() == 'o') {
                        if (s[11].unicode() == 'n') {
                          return T_DOXY_ENDQUOTATION;
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
    else if (s[1].unicode() == 'x') {
      if (s[2].unicode() == 't') {
        if (s[3].unicode() == 'e') {
          if (s[4].unicode() == 'r') {
            if (s[5].unicode() == 'n') {
              if (s[6].unicode() == 'a') {
                if (s[7].unicode() == 'l') {
                  if (s[8].unicode() == 'p') {
                    if (s[9].unicode() == 'a') {
                      if (s[10].unicode() == 'g') {
                        if (s[11].unicode() == 'e') {
                          return T_DOXY_EXTERNALPAGE;
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'g') {
    if (s[1].unicode() == 'e') {
      if (s[2].unicode() == 'n') {
        if (s[3].unicode() == 'e') {
          if (s[4].unicode() == 'r') {
            if (s[5].unicode() == 'a') {
              if (s[6].unicode() == 't') {
                if (s[7].unicode() == 'e') {
                  if (s[8].unicode() == 'l') {
                    if (s[9].unicode() == 'i') {
                      if (s[10].unicode() == 's') {
                        if (s[11].unicode() == 't') {
                          return T_DOXY_GENERATELIST;
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'i') {
    if (s[1].unicode() == 'n') {
      if (s[2].unicode() == 'h') {
        if (s[3].unicode() == 'e') {
          if (s[4].unicode() == 'a') {
            if (s[5].unicode() == 'd') {
              if (s[6].unicode() == 'e') {
                if (s[7].unicode() == 'r') {
                  if (s[8].unicode() == 'f') {
                    if (s[9].unicode() == 'i') {
                      if (s[10].unicode() == 'l') {
                        if (s[11].unicode() == 'e') {
                          return T_DOXY_INHEADERFILE;
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
      else if (s[2].unicode() == 's') {
        if (s[3].unicode() == 't') {
          if (s[4].unicode() == 'a') {
            if (s[5].unicode() == 'n') {
              if (s[6].unicode() == 't') {
                if (s[7].unicode() == 'i') {
                  if (s[8].unicode() == 'a') {
                    if (s[9].unicode() == 't') {
                      if (s[10].unicode() == 'e') {
                        if (s[11].unicode() == 's') {
                          return T_DOXY_INSTANTIATES;
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'l') {
    if (s[1].unicode() == 'a') {
      if (s[2].unicode() == 't') {
        if (s[3].unicode() == 'e') {
          if (s[4].unicode() == 'x') {
            if (s[5].unicode() == 'i') {
              if (s[6].unicode() == 'n') {
                if (s[7].unicode() == 'c') {
                  if (s[8].unicode() == 'l') {
                    if (s[9].unicode() == 'u') {
                      if (s[10].unicode() == 'd') {
                        if (s[11].unicode() == 'e') {
                          return T_DOXY_LATEXINCLUDE;
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'n') {
    if (s[1].unicode() == 'o') {
      if (s[2].unicode() == 'n') {
        if (s[3].unicode() == 'r') {
          if (s[4].unicode() == 'e') {
            if (s[5].unicode() == 'e') {
              if (s[6].unicode() == 'n') {
                if (s[7].unicode() == 't') {
                  if (s[8].unicode() == 'r') {
                    if (s[9].unicode() == 'a') {
                      if (s[10].unicode() == 'n') {
                        if (s[11].unicode() == 't') {
                          return T_DOXY_NONREENTRANT;
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'p') {
    if (s[1].unicode() == 'r') {
      if (s[2].unicode() == 'e') {
        if (s[3].unicode() == 'v') {
          if (s[4].unicode() == 'i') {
            if (s[5].unicode() == 'o') {
              if (s[6].unicode() == 'u') {
                if (s[7].unicode() == 's') {
                  if (s[8].unicode() == 'p') {
                    if (s[9].unicode() == 'a') {
                      if (s[10].unicode() == 'g') {
                        if (s[11].unicode() == 'e') {
                          return T_DOXY_PREVIOUSPAGE;
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'q') {
    if (s[1].unicode() == 'm') {
      if (s[2].unicode() == 'l') {
        if (s[3].unicode() == 'b') {
          if (s[4].unicode() == 'a') {
            if (s[5].unicode() == 's') {
              if (s[6].unicode() == 'i') {
                if (s[7].unicode() == 'c') {
                  if (s[8].unicode() == 't') {
                    if (s[9].unicode() == 'y') {
                      if (s[10].unicode() == 'p') {
                        if (s[11].unicode() == 'e') {
                          return T_DOXY_QMLBASICTYPE;
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  return T_DOXY_IDENTIFIER;
}

static inline int classify13(const QChar *s) {
  if (s[0].unicode() == 'a') {
    if (s[1].unicode() == 'n') {
      if (s[2].unicode() == 'n') {
        if (s[3].unicode() == 'o') {
          if (s[4].unicode() == 't') {
            if (s[5].unicode() == 'a') {
              if (s[6].unicode() == 't') {
                if (s[7].unicode() == 'e') {
                  if (s[8].unicode() == 'd') {
                    if (s[9].unicode() == 'l') {
                      if (s[10].unicode() == 'i') {
                        if (s[11].unicode() == 's') {
                          if (s[12].unicode() == 't') {
                            return T_DOXY_ANNOTATEDLIST;
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'e') {
    if (s[1].unicode() == 'n') {
      if (s[2].unicode() == 'd') {
        if (s[3].unicode() == 's') {
          if (s[4].unicode() == 'e') {
            if (s[5].unicode() == 'c') {
              if (s[6].unicode() == 'r') {
                if (s[7].unicode() == 'e') {
                  if (s[8].unicode() == 'f') {
                    if (s[9].unicode() == 'l') {
                      if (s[10].unicode() == 'i') {
                        if (s[11].unicode() == 's') {
                          if (s[12].unicode() == 't') {
                            return T_DOXY_ENDSECREFLIST;
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'h') {
    if (s[1].unicode() == 'i') {
      if (s[2].unicode() == 'd') {
        if (s[3].unicode() == 'e') {
          if (s[4].unicode() == 'c') {
            if (s[5].unicode() == 'a') {
              if (s[6].unicode() == 'l') {
                if (s[7].unicode() == 'l') {
                  if (s[8].unicode() == 'g') {
                    if (s[9].unicode() == 'r') {
                      if (s[10].unicode() == 'a') {
                        if (s[11].unicode() == 'p') {
                          if (s[12].unicode() == 'h') {
                            return T_DOXY_HIDECALLGRAPH;
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'i') {
    if (s[1].unicode() == 'n') {
      if (s[2].unicode() == 'c') {
        if (s[3].unicode() == 'l') {
          if (s[4].unicode() == 'u') {
            if (s[5].unicode() == 'd') {
              if (s[6].unicode() == 'e') {
                if (s[7].unicode() == 'l') {
                  if (s[8].unicode() == 'i') {
                    if (s[9].unicode() == 'n') {
                      if (s[10].unicode() == 'e') {
                        if (s[11].unicode() == 'n') {
                          if (s[12].unicode() == 'o') {
                            return T_DOXY_INCLUDELINENO;
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
      else if (s[2].unicode() == 'p') {
        if (s[3].unicode() == 'u') {
          if (s[4].unicode() == 'b') {
            if (s[5].unicode() == 'l') {
              if (s[6].unicode() == 'i') {
                if (s[7].unicode() == 'c') {
                  if (s[8].unicode() == 'g') {
                    if (s[9].unicode() == 'r') {
                      if (s[10].unicode() == 'o') {
                        if (s[11].unicode() == 'u') {
                          if (s[12].unicode() == 'p') {
                            return T_DOXY_INPUBLICGROUP;
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'n') {
    if (s[1].unicode() == 'o') {
      if (s[2].unicode() == 's') {
        if (s[3].unicode() == 'u') {
          if (s[4].unicode() == 'b') {
            if (s[5].unicode() == 'g') {
              if (s[6].unicode() == 'r') {
                if (s[7].unicode() == 'o') {
                  if (s[8].unicode() == 'u') {
                    if (s[9].unicode() == 'p') {
                      if (s[10].unicode() == 'i') {
                        if (s[11].unicode() == 'n') {
                          if (s[12].unicode() == 'g') {
                            return T_DOXY_NOSUBGROUPING;
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'p') {
    if (s[1].unicode() == 'u') {
      if (s[2].unicode() == 'b') {
        if (s[3].unicode() == 'l') {
          if (s[4].unicode() == 'i') {
            if (s[5].unicode() == 'c') {
              if (s[6].unicode() == 's') {
                if (s[7].unicode() == 'e') {
                  if (s[8].unicode() == 'c') {
                    if (s[9].unicode() == 't') {
                      if (s[10].unicode() == 'i') {
                        if (s[11].unicode() == 'o') {
                          if (s[12].unicode() == 'n') {
                            return T_DOXY_PUBLICSECTION;
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'q') {
    if (s[1].unicode() == 'u') {
      if (s[2].unicode() == 'o') {
        if (s[3].unicode() == 't') {
          if (s[4].unicode() == 'e') {
            if (s[5].unicode() == 'f') {
              if (s[6].unicode() == 'r') {
                if (s[7].unicode() == 'o') {
                  if (s[8].unicode() == 'm') {
                    if (s[9].unicode() == 'f') {
                      if (s[10].unicode() == 'i') {
                        if (s[11].unicode() == 'l') {
                          if (s[12].unicode() == 'e') {
                            return T_DOXY_QUOTEFROMFILE;
                          }
                        }
                      }
                    }
                  }
                }
              }
              else if (s[6].unicode() == 'u') {
                if (s[7].unicode() == 'n') {
                  if (s[8].unicode() == 'c') {
                    if (s[9].unicode() == 't') {
                      if (s[10].unicode() == 'i') {
                        if (s[11].unicode() == 'o') {
                          if (s[12].unicode() == 'n') {
                            return T_DOXY_QUOTEFUNCTION;
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 's') {
    if (s[1].unicode() == 'u') {
      if (s[2].unicode() == 'b') {
        if (s[3].unicode() == 's') {
          if (s[4].unicode() == 'u') {
            if (s[5].unicode() == 'b') {
              if (s[6].unicode() == 's') {
                if (s[7].unicode() == 'e') {
                  if (s[8].unicode() == 'c') {
                    if (s[9].unicode() == 't') {
                      if (s[10].unicode() == 'i') {
                        if (s[11].unicode() == 'o') {
                          if (s[12].unicode() == 'n') {
                            return T_DOXY_SUBSUBSECTION;
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  return T_DOXY_IDENTIFIER;
}

static inline int classify14(const QChar *s) {
  if (s[0].unicode() == 'e') {
    if (s[1].unicode() == 'n') {
      if (s[2].unicode() == 'd') {
        if (s[3].unicode() == 'd') {
          if (s[4].unicode() == 'o') {
            if (s[5].unicode() == 'c') {
              if (s[6].unicode() == 'b') {
                if (s[7].unicode() == 'o') {
                  if (s[8].unicode() == 'o') {
                    if (s[9].unicode() == 'k') {
                      if (s[10].unicode() == 'o') {
                        if (s[11].unicode() == 'n') {
                          if (s[12].unicode() == 'l') {
                            if (s[13].unicode() == 'y') {
                              return T_DOXY_ENDDOCBOOKONLY;
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 'p') {
    if (s[1].unicode() == 'r') {
      if (s[2].unicode() == 'i') {
        if (s[3].unicode() == 'v') {
          if (s[4].unicode() == 'a') {
            if (s[5].unicode() == 't') {
              if (s[6].unicode() == 'e') {
                if (s[7].unicode() == 's') {
                  if (s[8].unicode() == 'e') {
                    if (s[9].unicode() == 'c') {
                      if (s[10].unicode() == 't') {
                        if (s[11].unicode() == 'i') {
                          if (s[12].unicode() == 'o') {
                            if (s[13].unicode() == 'n') {
                              return T_DOXY_PRIVATESECTION;
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  return T_DOXY_IDENTIFIER;
}

static inline int classify15(const QChar *s) {
  if (s[0].unicode() == 'h') {
    if (s[1].unicode() == 'i') {
      if (s[2].unicode() == 'd') {
        if (s[3].unicode() == 'e') {
          if (s[4].unicode() == 'c') {
            if (s[5].unicode() == 'a') {
              if (s[6].unicode() == 'l') {
                if (s[7].unicode() == 'l') {
                  if (s[8].unicode() == 'e') {
                    if (s[9].unicode() == 'r') {
                      if (s[10].unicode() == 'g') {
                        if (s[11].unicode() == 'r') {
                          if (s[12].unicode() == 'a') {
                            if (s[13].unicode() == 'p') {
                              if (s[14].unicode() == 'h') {
                                return T_DOXY_HIDECALLERGRAPH;
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
          else if (s[4].unicode() == 'i') {
            if (s[5].unicode() == 'n') {
              if (s[6].unicode() == 'i') {
                if (s[7].unicode() == 't') {
                  if (s[8].unicode() == 'i') {
                    if (s[9].unicode() == 'a') {
                      if (s[10].unicode() == 'l') {
                        if (s[11].unicode() == 'i') {
                          if (s[12].unicode() == 'z') {
                            if (s[13].unicode() == 'e') {
                              if (s[14].unicode() == 'r') {
                                return T_DOXY_HIDEINITIALIZER;
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 's') {
    if (s[1].unicode() == 'h') {
      if (s[2].unicode() == 'o') {
        if (s[3].unicode() == 'w') {
          if (s[4].unicode() == 'i') {
            if (s[5].unicode() == 'n') {
              if (s[6].unicode() == 'i') {
                if (s[7].unicode() == 't') {
                  if (s[8].unicode() == 'i') {
                    if (s[9].unicode() == 'a') {
                      if (s[10].unicode() == 'l') {
                        if (s[11].unicode() == 'i') {
                          if (s[12].unicode() == 'z') {
                            if (s[13].unicode() == 'e') {
                              if (s[14].unicode() == 'r') {
                                return T_DOXY_SHOWINITIALIZER;
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  else if (s[0].unicode() == 't') {
    if (s[1].unicode() == 'a') {
      if (s[2].unicode() == 'b') {
        if (s[3].unicode() == 'l') {
          if (s[4].unicode() == 'e') {
            if (s[5].unicode() == 'o') {
              if (s[6].unicode() == 'f') {
                if (s[7].unicode() == 'c') {
                  if (s[8].unicode() == 'o') {
                    if (s[9].unicode() == 'n') {
                      if (s[10].unicode() == 't') {
                        if (s[11].unicode() == 'e') {
                          if (s[12].unicode() == 'n') {
                            if (s[13].unicode() == 't') {
                              if (s[14].unicode() == 's') {
                                return T_DOXY_TABLEOFCONTENTS;
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  return T_DOXY_IDENTIFIER;
}

static inline int classify16(const QChar *s) {
  if (s[0].unicode() == 'p') {
    if (s[1].unicode() == 'r') {
      if (s[2].unicode() == 'o') {
        if (s[3].unicode() == 't') {
          if (s[4].unicode() == 'e') {
            if (s[5].unicode() == 'c') {
              if (s[6].unicode() == 't') {
                if (s[7].unicode() == 'e') {
                  if (s[8].unicode() == 'd') {
                    if (s[9].unicode() == 's') {
                      if (s[10].unicode() == 'e') {
                        if (s[11].unicode() == 'c') {
                          if (s[12].unicode() == 't') {
                            if (s[13].unicode() == 'i') {
                              if (s[14].unicode() == 'o') {
                                if (s[15].unicode() == 'n') {
                                  return T_DOXY_PROTECTEDSECTION;
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  return T_DOXY_IDENTIFIER;
}

static inline int classify17(const QChar *s) {
  if (s[0].unicode() == 'q') {
    if (s[1].unicode() == 'm') {
      if (s[2].unicode() == 'l') {
        if (s[3].unicode() == 'a') {
          if (s[4].unicode() == 't') {
            if (s[5].unicode() == 't') {
              if (s[6].unicode() == 'a') {
                if (s[7].unicode() == 'c') {
                  if (s[8].unicode() == 'h') {
                    if (s[9].unicode() == 'e') {
                      if (s[10].unicode() == 'd') {
                        if (s[11].unicode() == 's') {
                          if (s[12].unicode() == 'i') {
                            if (s[13].unicode() == 'g') {
                              if (s[14].unicode() == 'n') {
                                if (s[15].unicode() == 'a') {
                                  if (s[16].unicode() == 'l') {
                                    return T_DOXY_QMLATTACHEDSIGNAL;
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  return T_DOXY_IDENTIFIER;
}

static inline int classify19(const QChar *s) {
  if (s[0].unicode() == 'q') {
    if (s[1].unicode() == 'm') {
      if (s[2].unicode() == 'l') {
        if (s[3].unicode() == 'a') {
          if (s[4].unicode() == 't') {
            if (s[5].unicode() == 't') {
              if (s[6].unicode() == 'a') {
                if (s[7].unicode() == 'c') {
                  if (s[8].unicode() == 'h') {
                    if (s[9].unicode() == 'e') {
                      if (s[10].unicode() == 'd') {
                        if (s[11].unicode() == 'p') {
                          if (s[12].unicode() == 'r') {
                            if (s[13].unicode() == 'o') {
                              if (s[14].unicode() == 'p') {
                                if (s[15].unicode() == 'e') {
                                  if (s[16].unicode() == 'r') {
                                    if (s[17].unicode() == 't') {
                                      if (s[18].unicode() == 'y') {
                                        return T_DOXY_QMLATTACHEDPROPERTY;
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  return T_DOXY_IDENTIFIER;
}

int CppTools::classifyDoxygenTag(const QChar *s, int n) {
  switch (n) {
    case 1: return classify1(s);
    case 2: return classify2(s);
    case 3: return classify3(s);
    case 4: return classify4(s);
    case 5: return classify5(s);
    case 6: return classify6(s);
    case 7: return classify7(s);
    case 8: return classify8(s);
    case 9: return classify9(s);
    case 10: return classify10(s);
    case 11: return classify11(s);
    case 12: return classify12(s);
    case 13: return classify13(s);
    case 14: return classify14(s);
    case 15: return classify15(s);
    case 16: return classify16(s);
    case 17: return classify17(s);
    case 19: return classify19(s);
    default: return T_DOXY_IDENTIFIER;
  } // switch
}
