#ifdef PARSESTART
__PARSESTART = DIAG_START_PARSE,
#undef PARSESTART
#endif

DIAG(err_access_specifier_interface, CLASS_ERROR, (unsigned)diag::Severity::Error, "interface types cannot specify '%select{private|protected}0' access", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_address_of_label_outside_fn, CLASS_ERROR, (unsigned)diag::Severity::Error, "use of address-of-label extension outside of a function body", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_alias_declaration_not_identifier, CLASS_ERROR, (unsigned)diag::Severity::Error, "name defined in alias declaration must be an identifier", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_alias_declaration_pack_expansion, CLASS_ERROR, (unsigned)diag::Severity::Error, "alias declaration cannot be a pack expansion", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_alias_declaration_specialization, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{partial specialization|explicit specialization|explicit instantiation}0 of alias templates is not permitted", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_anon_type_definition, CLASS_ERROR, (unsigned)diag::Severity::Error, "declaration of anonymous %0 must be a definition", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_arc_bridge_retain, CLASS_ERROR, (unsigned)diag::Severity::Error, "unknown cast annotation __bridge_retain; did you mean __bridge_retained?", 0, SFINAE_SubstitutionFailure, false, true, 8)
DIAG(err_argument_required_after_attribute, CLASS_ERROR, (unsigned)diag::Severity::Error, "argument required after attribute", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_asm_empty, CLASS_ERROR, (unsigned)diag::Severity::Error, "__asm used with no assembly instructions", 0, SFINAE_SubstitutionFailure, false, true, 12)
DIAG(err_asm_goto_not_supported_yet, CLASS_ERROR, (unsigned)diag::Severity::Error, "'asm goto' constructs are not supported yet", 0, SFINAE_SubstitutionFailure, false, true, 12)
DIAG(err_asm_operand_wide_string_literal, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot use %select{unicode|wide}0 string literal in 'asm'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_at_defs_cxx, CLASS_ERROR, (unsigned)diag::Severity::Error, "@defs is not supported in Objective-C++", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_at_in_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "unexpected '@' in member specification", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_atimport, CLASS_ERROR, (unsigned)diag::Severity::Error, "use of '@import' when modules are disabled", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_attribute_not_import_attr, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 attribute cannot be applied to a module import", 0, SFINAE_SubstitutionFailure, false, true, 13)
DIAG(err_attribute_not_module_attr, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 attribute cannot be applied to a module", 0, SFINAE_SubstitutionFailure, false, true, 13)
DIAG(err_attribute_requires_arguments, CLASS_ERROR, (unsigned)diag::Severity::Error, "parentheses must be omitted if %0 attribute's argument list is empty", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_attributes_not_allowed, CLASS_ERROR, (unsigned)diag::Severity::Error, "an attribute list cannot appear here", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_avail_query_expected_platform_name, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected a platform name here", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_avail_query_unrecognized_platform_name, CLASS_ERROR, (unsigned)diag::Severity::Error, "unrecognized platform name %0", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_availability_expected_change, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected 'introduced', 'deprecated', or 'obsoleted'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_availability_expected_platform, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected a platform name, e.g., 'macos'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_availability_query_repeated_platform, CLASS_ERROR, (unsigned)diag::Severity::Error, "version for '%0' already specified", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_availability_query_repeated_star, CLASS_ERROR, (unsigned)diag::Severity::Error, "'*' query has already been specified", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_availability_query_wildcard_required, CLASS_ERROR, (unsigned)diag::Severity::Error, "must handle potential future platforms with '*'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_availability_redundant, CLASS_ERROR, (unsigned)diag::Severity::Error, "redundant %0 availability change; only the last specified change will be used", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_availability_unknown_change, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 is not an availability stage; use 'introduced', 'deprecated', or 'obsoleted'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_bitfield_member_init, CLASS_ERROR, (unsigned)diag::Severity::Error, "bit-field member cannot have an in-class initializer", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_bool_redeclaration, CLASS_ERROR, (unsigned)diag::Severity::Error, "redeclaration of C++ built-in type 'bool'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_bracket_depth_exceeded, CLASS_ERROR, (unsigned)diag::Severity::Fatal, "bracket nesting level exceeded maximum of %0", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_brackets_go_after_unqualified_id, CLASS_ERROR, (unsigned)diag::Severity::Error, "brackets are not allowed here; to declare an array, place the brackets after the %select{identifier|name}0", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_c11_noreturn_misplaced, CLASS_ERROR, (unsigned)diag::Severity::Error, "'_Noreturn' keyword must precede function declarator", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_class_on_template_template_param, CLASS_ERROR, (unsigned)diag::Severity::Error, "template template parameter requires 'class' after the parameter list", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_constructor_bad_name, CLASS_ERROR, (unsigned)diag::Severity::Error, "missing return type for function %0; did you mean the constructor name %1?", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_ctor_init_missing_comma, CLASS_ERROR, (unsigned)diag::Severity::Error, "missing ',' between base or member initializers", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_cxx11_attribute_forbids_arguments, CLASS_ERROR, (unsigned)diag::Severity::Error, "attribute %0 cannot have an argument list", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_cxx11_attribute_forbids_ellipsis, CLASS_ERROR, (unsigned)diag::Severity::Error, "attribute '%0' cannot be used as an attribute pack", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_cxx11_attribute_repeated, CLASS_ERROR, (unsigned)diag::Severity::Error, "attribute %0 cannot appear multiple times in an attribute specifier", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_declaration_does_not_declare_param, CLASS_ERROR, (unsigned)diag::Severity::Error, "declaration does not declare a parameter", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_declspec_after_virtspec, CLASS_ERROR, (unsigned)diag::Severity::Error, "'%0' qualifier may not appear after the virtual specifier '%1'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_default_arg_unparsed, CLASS_ERROR, (unsigned)diag::Severity::Error, "unexpected end of default argument expression", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_default_delete_in_multiple_declaration, CLASS_ERROR, (unsigned)diag::Severity::Error, "'= %select{default|delete}0' is a function definition and must occur in a standalone declaration", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_default_template_template_parameter_not_template, CLASS_ERROR, (unsigned)diag::Severity::Error, "default template argument for a template template parameter must be a class template", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_destructor_template_id, CLASS_ERROR, (unsigned)diag::Severity::Error, "destructor name %0 does not refer to a template", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_destructor_tilde_identifier, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected a class name after '~' to name a destructor", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_destructor_tilde_scope, CLASS_ERROR, (unsigned)diag::Severity::Error, "'~' in destructor name should be after nested name specifier", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_dup_virtual, CLASS_ERROR, (unsigned)diag::Severity::Error, "duplicate 'virtual' in base specifier", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_duplicate_default_assoc, CLASS_ERROR, (unsigned)diag::Severity::Error, "duplicate default generic association", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_duplicate_virt_specifier, CLASS_ERROR, (unsigned)diag::Severity::Error, "class member already marked '%0'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_dynamic_and_noexcept_specification, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot have both throw() and noexcept() clause on the same function", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_empty_enum, CLASS_ERROR, (unsigned)diag::Severity::Error, "use of empty enum", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_enumerator_list_missing_comma, CLASS_ERROR, (unsigned)diag::Severity::Error, "missing ',' between enumerators", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_enumerator_unnamed_no_def, CLASS_ERROR, (unsigned)diag::Severity::Error, "unnamed enumeration must be a definition", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_except_spec_unparsed, CLASS_ERROR, (unsigned)diag::Severity::Error, "unexpected end of exception specification", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_capture, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected variable name or 'this' in lambda capture list", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_case_before_expression, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected 'case' keyword before expression", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_catch, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected catch", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_class_name, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected class name", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_class_name_not_template, CLASS_ERROR, (unsigned)diag::Severity::Error, "'typename' is redundant; base classes are implicitly types", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_coloncolon_after_super, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected '::' after '__super'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_comma_greater, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected ',' or '>' in template-parameter-list", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_comma_or_rsquare, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected ',' or ']' in lambda capture list", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_end_declare_target, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected '#pragma omp end declare target'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_end_of_enumerator, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected '= constant-expression' or end of enumerator definition", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_equal_designator, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected '=' or another designator", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_expression, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected expression", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_external_declaration, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected external declaration", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_field_designator, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected a field designator, such as '.field = 4'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_fn_body, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected function body after function declarator", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_fold_operator, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected a foldable binary operator in fold expression", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_init_in_condition, CLASS_ERROR, (unsigned)diag::Severity::Error, "variable declaration in condition must have an initializer", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_init_in_condition_lparen, CLASS_ERROR, (unsigned)diag::Severity::Error, "variable declaration in condition cannot have a parenthesized initializer", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_lambda_body, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected body of lambda expression", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_lbrace_after_base_specifiers, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected '{' after base class list", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_lbrace_in_compound_literal, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected '{' in compound literal", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_less_after, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected '<' after '%0'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_lparen_after, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected '(' after '%0'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_lparen_after_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected '(' for function-style cast or type construction", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_member_name_or_semi, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected member name or ';' after declaration specifiers", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_member_name_or_semi_objcxx_keyword, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected member name or ';' after declaration specifiers; %0 is a keyword in Objective-C++", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_member_or_base_name, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected class member or base class name", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_method_body, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected method body", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_minus_or_plus, CLASS_ERROR, (unsigned)diag::Severity::Error, "method type specifier must start with '-' or '+'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_objc_container, CLASS_ERROR, (unsigned)diag::Severity::Error, "'@end' must appear in an Objective-C context", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_parameter_pack, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected the name of a parameter pack", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_parentheses_around_typename, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected parentheses around type name in %0 expression", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_property_name, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected property name", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_punc, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected ')' or ',' after '%0'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_qualified_after_typename, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected a qualified name after 'typename'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_rparen_after, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected ')' after '%0'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_selector_for_method, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected selector for Objective-C method", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_semi_after_attribute_list, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected ';' after attribute list", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_semi_after_expr, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected ';' after expression", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_semi_after_method_proto, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected ';' after method prototype", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_semi_after_namespace_name, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected ';' after namespace name", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_semi_after_static_assert, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected ';' after static_assert", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_semi_after_stmt, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected ';' after %0 statement", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_semi_decl_list, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected ';' at end of declaration list", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_semi_declaration, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected ';' at end of declaration", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_semi_for, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected ';' in 'for' statement specifier", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_star_this_capture, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected 'this' following '*' in lambda capture list", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_statement, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected statement", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_template, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected template", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_template_parameter, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected template parameter", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_token_instead_of_objcxx_keyword, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected %0; %1 is a keyword in Objective-C++", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected a type", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_type_name_after_typename, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected an identifier or template-id after '::'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_unqualified_id, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected %select{identifier|unqualified-id}0", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_version, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected a version of the form 'major[.minor[.subminor]]'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_expected_while, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected 'while' in do/while loop", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_explicit_instantiation_enum, CLASS_ERROR, (unsigned)diag::Severity::Error, "enumerations cannot be explicitly instantiated", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_explicit_instantiation_with_definition, CLASS_ERROR, (unsigned)diag::Severity::Error, "explicit template instantiation cannot have a definition; if this definition is meant to be an explicit specialization, add '<>' after the 'template' keyword", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_explicit_spec_non_template, CLASS_ERROR, (unsigned)diag::Severity::Error, "explicit %select{specialization|instantiation}0 of non-template %1 %2", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_export_empty, CLASS_ERROR, (unsigned)diag::Severity::Error, "export declaration cannot be empty", 0, SFINAE_SubstitutionFailure, false, true, 13)
DIAG(err_external_source_symbol_duplicate_clause, CLASS_ERROR, (unsigned)diag::Severity::Error, "duplicate %0 clause in an 'external_source_symbol' attribute", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_external_source_symbol_expected_keyword, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected 'language', 'defined_in', or 'generated_declaration'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_extraneous_closing_brace, CLASS_ERROR, (unsigned)diag::Severity::Error, "extraneous closing brace ('}')", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_extraneous_rparen_in_condition, CLASS_ERROR, (unsigned)diag::Severity::Error, "extraneous ')' after condition, expected a statement", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_extraneous_token_before_semi, CLASS_ERROR, (unsigned)diag::Severity::Error, "extraneous '%0' before ';'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_fold_operator_mismatch, CLASS_ERROR, (unsigned)diag::Severity::Error, "operators in fold expression must be the same", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_for_co_await_not_range_for, CLASS_ERROR, (unsigned)diag::Severity::Error, "'co_await' modifier can only be applied to range-based for loop", 0, SFINAE_SubstitutionFailure, false, true, 14)
DIAG(err_for_range_expected_decl, CLASS_ERROR, (unsigned)diag::Severity::Error, "for range declaration must declare a variable", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_for_range_identifier, CLASS_ERROR, (unsigned)diag::Severity::Error, "range-based for loop requires type for loop variable", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_friend_decl_defines_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot define a type in a friend declaration", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_friend_explicit_instantiation, CLASS_ERROR, (unsigned)diag::Severity::Error, "friend cannot be declared in an explicit instantiation; if this declaration is meant to be a friend declaration, remove the 'template' keyword", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_friend_invalid_in_context, CLASS_ERROR, (unsigned)diag::Severity::Error, "'friend' used outside of class", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_func_def_no_params, CLASS_ERROR, (unsigned)diag::Severity::Error, "function definition does not declare parameters", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_function_declared_typedef, CLASS_ERROR, (unsigned)diag::Severity::Error, "function definition declared 'typedef'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_function_definition_not_allowed, CLASS_ERROR, (unsigned)diag::Severity::Error, "function definition is not allowed here", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_function_is_not_record, CLASS_ERROR, (unsigned)diag::Severity::Error, "unexpected %0 in function call; perhaps remove the %0?", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_gnu_inline_asm_disabled, CLASS_ERROR, (unsigned)diag::Severity::Error, "GNU-style inline assembly is disabled", 0, SFINAE_SubstitutionFailure, false, true, 12)
DIAG(err_id_after_template_in_nested_name_spec, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected template name after 'template' keyword in nested name specifier", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_illegal_decl_reference_to_reference, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0 declared as a reference to a reference", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_illegal_super_cast, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot cast 'super' (it isn't an expression)", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_incomplete_array_member_init, CLASS_ERROR, (unsigned)diag::Severity::Error, "array bound cannot be deduced from an in-class initializer", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_init_list_bin_op, CLASS_ERROR, (unsigned)diag::Severity::Error, "initializer list cannot be used on the %select{left|right}0 hand side of operator '%1'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_inline_ms_asm_parsing, CLASS_ERROR, (unsigned)diag::Severity::Error, "%0", 0, SFINAE_SubstitutionFailure, false, true, 12)
DIAG(err_inline_namespace_alias, CLASS_ERROR, (unsigned)diag::Severity::Error, "namespace alias cannot be inline", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_inline_nested_namespace_definition, CLASS_ERROR, (unsigned)diag::Severity::Error, "nested namespace definition cannot be 'inline'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_invalid_operator_on_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot use %select{dot|arrow}0 operator on a type", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_invalid_reference_qualifier_application, CLASS_ERROR, (unsigned)diag::Severity::Error, "'%0' qualifier may not be applied to a reference", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_invalid_token_after_declarator_suggest_equal, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid %0 at end of declaration; did you mean '='?", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_invalid_token_after_toplevel_declarator, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected ';' after top level declarator", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_l_square_l_square_not_attribute, CLASS_ERROR, (unsigned)diag::Severity::Error, "C++11 only allows consecutive left square brackets when introducing an attribute", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_label_end_of_compound_statement, CLASS_ERROR, (unsigned)diag::Severity::Error, "label at end of compound statement: expected statement", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_lambda_decl_specifier_repeated, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{'mutable'|'constexpr'}0 cannot appear multiple times in a lambda declarator", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_lambda_missing_parens, CLASS_ERROR, (unsigned)diag::Severity::Error, "lambda requires '()' before %select{'mutable'|return type|attribute specifier|'constexpr'}0", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_literal_operator_string_not_empty, CLASS_ERROR, (unsigned)diag::Severity::Error, "string literal after 'operator' must be '\"\"'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_literal_operator_string_prefix, CLASS_ERROR, (unsigned)diag::Severity::Error, "string literal after 'operator' cannot have an encoding prefix", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_misplaced_ellipsis_in_declaration, CLASS_ERROR, (unsigned)diag::Severity::Error, "'...' must %select{immediately precede declared identifier|be innermost component of anonymous pack declaration}0", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_missing_before_module_end, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected %0 at end of module", 0, SFINAE_SubstitutionFailure, false, true, 13)
DIAG(err_missing_catch_finally, CLASS_ERROR, (unsigned)diag::Severity::Error, "@try statement without a @catch and @finally clause", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_missing_comma_before_ellipsis, CLASS_ERROR, (unsigned)diag::Severity::Error, "C requires a comma prior to the ellipsis in a variadic function type", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_missing_dependent_template_keyword, CLASS_ERROR, (unsigned)diag::Severity::Error, "use 'template' keyword to treat '%0' as a dependent template name", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_missing_end_of_definition, CLASS_ERROR, (unsigned)diag::Severity::Error, "missing '}' at end of definition of %q0", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_missing_param, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected parameter declarator", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_missing_whitespace_digraph, CLASS_ERROR, (unsigned)diag::Severity::Error, "found '<::' after a %select{template name|const_cast|dynamic_cast|reinterpret_cast|static_cast}0 which forms the digraph '<:' (aka '[') and a ':', did you mean '< ::'?", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_module_expected_ident, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected a module name after '%select{module|import}0'", 0, SFINAE_SubstitutionFailure, false, true, 13)
DIAG(err_module_expected_semi, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected ';' after module name", 0, SFINAE_SubstitutionFailure, false, true, 13)
DIAG(err_module_implementation_partition, CLASS_ERROR, (unsigned)diag::Severity::Error, "module partition must be declared 'export'", 0, SFINAE_SubstitutionFailure, false, true, 13)
DIAG(err_ms_attributes_not_enabled, CLASS_ERROR, (unsigned)diag::Severity::Error, "'__declspec' attributes are not enabled; use '-fdeclspec' or '-fms-extensions' to enable support for __declspec attributes", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_ms_declspec_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "__declspec attributes must be an identifier or string literal", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_ms_property_duplicate_accessor, CLASS_ERROR, (unsigned)diag::Severity::Error, "property declaration specifies '%0' accessor twice", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_ms_property_expected_accessor_name, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected name of accessor method", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_ms_property_expected_comma_or_rparen, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected ',' or ')' at end of property accessor list", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_ms_property_expected_equal, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected '=' after '%0'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_ms_property_has_set_accessor, CLASS_ERROR, (unsigned)diag::Severity::Error, "putter for property must be specified as 'put', not 'set'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_ms_property_initializer, CLASS_ERROR, (unsigned)diag::Severity::Error, "property declaration cannot have an in-class initializer", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_ms_property_missing_accessor_kind, CLASS_ERROR, (unsigned)diag::Severity::Error, "missing 'get=' or 'put='", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_ms_property_no_getter_or_putter, CLASS_ERROR, (unsigned)diag::Severity::Error, "property does not specify a getter or a putter", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_ms_property_unknown_accessor, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected 'get' or 'put' in property declaration", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_msasm_unable_to_create_target, CLASS_ERROR, (unsigned)diag::Severity::Error, "MS-style inline assembly is not available: %0", 0, SFINAE_SubstitutionFailure, false, true, 12)
DIAG(err_msasm_unsupported_arch, CLASS_ERROR, (unsigned)diag::Severity::Error, "Unsupported architecture '%0' for MS-style inline assembly", 0, SFINAE_SubstitutionFailure, false, true, 12)
DIAG(err_multiple_template_declarators, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{|a template declaration|an explicit template specialization|an explicit template instantiation}0 can only %select{|declare|declare|instantiate}0 a single entity", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_namespace_nonnamespace_scope, CLASS_ERROR, (unsigned)diag::Severity::Error, "namespaces can only be defined in global or namespace scope", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_no_matching_param, CLASS_ERROR, (unsigned)diag::Severity::Error, "parameter named %0 is missing", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_nsnumber_nonliteral_unary, CLASS_ERROR, (unsigned)diag::Severity::Error, "@%0 must be followed by a number to form an NSNumber object", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_objc_concat_string, CLASS_ERROR, (unsigned)diag::Severity::Error, "unexpected token after Objective-C string", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_objc_directive_only_in_protocol, CLASS_ERROR, (unsigned)diag::Severity::Error, "directive may only be specified in protocols only", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_objc_expected_equal_for_getter, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected '=' for Objective-C getter", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_objc_expected_equal_for_setter, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected '=' for Objective-C setter", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_objc_expected_property_attr, CLASS_ERROR, (unsigned)diag::Severity::Error, "unknown property attribute %0", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_objc_expected_selector_for_getter_setter, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected selector for Objective-C %select{setter|getter}0", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_objc_expected_type_parameter, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected type parameter name", 0, SFINAE_SubstitutionFailure, false, true, 20)
DIAG(err_objc_illegal_interface_qual, CLASS_ERROR, (unsigned)diag::Severity::Error, "illegal interface qualifier", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_objc_illegal_visibility_spec, CLASS_ERROR, (unsigned)diag::Severity::Error, "illegal visibility specification", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_objc_missing_end, CLASS_ERROR, (unsigned)diag::Severity::Error, "missing '@end'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_objc_parameterized_implementation, CLASS_ERROR, (unsigned)diag::Severity::Error, "@implementation cannot have type parameters", 0, SFINAE_SubstitutionFailure, false, true, 20)
DIAG(err_objc_postfix_attribute, CLASS_ERROR, (unsigned)diag::Severity::Error, "postfix attributes are not allowed on Objective-C directives", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_objc_postfix_attribute_hint, CLASS_ERROR, (unsigned)diag::Severity::Error, "postfix attributes are not allowed on Objective-C directives, place them in front of '%select{@interface|@protocol}0'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_objc_properties_require_objc2, CLASS_ERROR, (unsigned)diag::Severity::Error, "properties are an Objective-C 2 feature", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_objc_property_bitfield, CLASS_ERROR, (unsigned)diag::Severity::Error, "property name cannot be a bit-field", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_objc_property_requires_field_name, CLASS_ERROR, (unsigned)diag::Severity::Error, "property requires fields to be named", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_objc_type_args_after_protocols, CLASS_ERROR, (unsigned)diag::Severity::Error, "protocol qualifiers must precede type arguments", 0, SFINAE_SubstitutionFailure, false, true, 20)
DIAG(err_objc_unexpected_atend, CLASS_ERROR, (unsigned)diag::Severity::Error, "'@end' appears where closing brace '}' is expected", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_objc_unexpected_attr, CLASS_ERROR, (unsigned)diag::Severity::Error, "prefix attribute must be followed by an interface or protocol", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_objc_unknown_at, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected an Objective-C directive after '@'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_objcbridge_related_expected_related_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected a related ObjectiveC class name, e.g., 'NSColor'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_objcbridge_related_selector_name, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected a class method selector with single argument, e.g., 'colorWithCGColor:'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_omp_decl_in_declare_simd, CLASS_ERROR, (unsigned)diag::Severity::Error, "function declaration is expected after 'declare simd' directive", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_omp_declare_simd_inbranch_notinbranch, CLASS_ERROR, (unsigned)diag::Severity::Error, "unexpected '%0' clause, '%1' is specified already", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_omp_declare_target_unexpected_clause, CLASS_ERROR, (unsigned)diag::Severity::Error, "unexpected '%0' clause, only 'to' or 'link' clauses expected", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_omp_expected_identifier_for_critical, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected identifier specifying the name of the 'omp critical' directive", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_omp_expected_punc, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected ',' or ')' in '%0' %select{clause|directive}1", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_omp_expected_reduction_identifier, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected identifier or one of the following operators: '+', '-', '*', '&', '|', '^', '&&', or '||'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_omp_immediate_directive, CLASS_ERROR, (unsigned)diag::Severity::Error, "'#pragma omp %0' %select{|with '%2' clause }1cannot be an immediate substatement", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_omp_map_type_missing, CLASS_ERROR, (unsigned)diag::Severity::Error, "missing map type", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_omp_unexpected_clause, CLASS_ERROR, (unsigned)diag::Severity::Error, "unexpected OpenMP clause '%0' in directive '#pragma omp %1'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_omp_unexpected_directive, CLASS_ERROR, (unsigned)diag::Severity::Error, "unexpected OpenMP directive '#pragma omp %0'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_omp_unknown_directive, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected an OpenMP directive", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_omp_unknown_map_type, CLASS_ERROR, (unsigned)diag::Severity::Error, "incorrect map type, expected one of 'to', 'from', 'tofrom', 'alloc', 'release', or 'delete'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_omp_unknown_map_type_modifier, CLASS_ERROR, (unsigned)diag::Severity::Error, "incorrect map type modifier, expected 'always'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_opencl_logical_exclusive_or, CLASS_ERROR, (unsigned)diag::Severity::Error, "^^ is a reserved operator in OpenCL", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_opencl_taking_function_address_parser, CLASS_ERROR, (unsigned)diag::Severity::Error, "taking address of function is not allowed", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_opencl_unroll_hint_on_non_loop, CLASS_ERROR, (unsigned)diag::Severity::Error, "OpenCL only supports 'opencl_unroll_hint' attribute on for, while, and do statements", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_out_of_line_constructor_template_id, CLASS_ERROR, (unsigned)diag::Severity::Error, "out-of-line constructor for %0 cannot have template arguments", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_override_control_interface, CLASS_ERROR, (unsigned)diag::Severity::Error, "'%0' keyword not permitted with interface types", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_paren_sizeof_parameter_pack, CLASS_ERROR, (unsigned)diag::Severity::Error, "missing parentheses around the size of parameter pack %0", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_pragma_attribute_duplicate_subject, CLASS_ERROR, (unsigned)diag::Severity::Error, "duplicate attribute subject matcher '%0'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_pragma_attribute_expected_attribute, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected an attribute after '('", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_pragma_attribute_expected_attribute_name, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected identifier that represents an attribute name", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_pragma_attribute_expected_attribute_syntax, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected an attribute that is specified using the GNU, C++11 or '__declspec' syntax", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_pragma_attribute_expected_push_pop, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected 'push' or 'pop' after '#pragma clang attribute'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_pragma_attribute_expected_subject_identifier, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected an identifier that corresponds to an attribute subject rule", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_pragma_attribute_expected_subject_sub_identifier, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected an identifier that corresponds to an attribute subject matcher sub-rule; '%0' matcher %select{does not support sub-rules|supports the following sub-rules: %2|}1", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_pragma_attribute_extra_tokens_after_attribute, CLASS_ERROR, (unsigned)diag::Severity::Error, "extra tokens after attribute in a '#pragma clang attribute push'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_pragma_attribute_invalid_argument, CLASS_ERROR, (unsigned)diag::Severity::Error, "unexpected argument '%0' to '#pragma clang attribute'; expected 'push' or 'pop'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_pragma_attribute_invalid_subject_set_specifier, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected attribute subject set specifier 'apply_to'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_pragma_attribute_multiple_attributes, CLASS_ERROR, (unsigned)diag::Severity::Error, "more than one attribute specified in '#pragma clang attribute push'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_pragma_attribute_unknown_subject_rule, CLASS_ERROR, (unsigned)diag::Severity::Error, "unknown attribute subject rule '%0'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_pragma_attribute_unknown_subject_sub_rule, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{invalid use of|unknown}2 attribute subject matcher sub-rule '%0'; '%1' matcher %select{does not support sub-rules|supports the following sub-rules: %3}2", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_pragma_attribute_unsupported_attribute, CLASS_ERROR, (unsigned)diag::Severity::Error, "attribute %0 is not supported by '#pragma clang attribute'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_pragma_cannot_end_force_cuda_host_device, CLASS_ERROR, (unsigned)diag::Severity::Error, "force_cuda_host_device end pragma without matching force_cuda_host_device begin", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_pragma_clang_section_expected_equal, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected '=' following '#pragma clang section %select{invalid|bss|data|rodata|text}0'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_pragma_clang_section_expected_name_or_clear, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected section name or '\"\"' following '#pragma clang section %select{invalid|bss|data|rodata|text}0'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_pragma_comment_malformed, CLASS_ERROR, (unsigned)diag::Severity::Error, "pragma comment requires parenthesized identifier and optional string", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_pragma_comment_unknown_kind, CLASS_ERROR, (unsigned)diag::Severity::Error, "unknown kind of pragma comment", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_pragma_detect_mismatch_malformed, CLASS_ERROR, (unsigned)diag::Severity::Error, "pragma detect_mismatch is malformed; it requires two comma-separated string literals", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_pragma_expected_clang_section_name, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected one of [bss|data|rodata|text] section kind in '#pragma %0'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_pragma_fp_contract_scope, CLASS_ERROR, (unsigned)diag::Severity::Error, "'#pragma fp_contract' can only appear at file scope or at the start of a compound statement", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_pragma_fp_invalid_argument, CLASS_ERROR, (unsigned)diag::Severity::Error, "unexpected argument '%0' to '#pragma clang fp %1'; expected 'on', 'fast' or 'off'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_pragma_fp_invalid_option, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{invalid|missing}0 option%select{ %1|}0; expected contract", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_pragma_fp_scope, CLASS_ERROR, (unsigned)diag::Severity::Error, "'#pragma clang fp' can only appear at file scope or at the start of a compound statement", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_pragma_invalid_keyword, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid argument; expected 'enable'%select{|, 'full'}0%select{|, 'assume_safety'}1 or 'disable'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_pragma_loop_invalid_option, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{invalid|missing}0 option%select{ %1|}0; expected vectorize, vectorize_width, interleave, interleave_count, unroll, unroll_count, or distribute", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_pragma_loop_missing_argument, CLASS_ERROR, (unsigned)diag::Severity::Error, "missing argument; expected %select{an integer value|'enable'%select{|, 'full'}1%select{|, 'assume_safety'}2 or 'disable'}0", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_pragma_missing_argument, CLASS_ERROR, (unsigned)diag::Severity::Error, "missing argument to '#pragma %0'%select{|; expected %2}1", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_pragma_optimize_extra_argument, CLASS_ERROR, (unsigned)diag::Severity::Error, "unexpected extra argument '%0' to '#pragma clang optimize'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_pragma_optimize_invalid_argument, CLASS_ERROR, (unsigned)diag::Severity::Error, "unexpected argument '%0' to '#pragma clang optimize'; expected 'on' or 'off'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_pragma_pointers_to_members_unknown_kind, CLASS_ERROR, (unsigned)diag::Severity::Error, "unexpected %0, expected to see one of %select{|'best_case', 'full_generality', }1'single_inheritance', 'multiple_inheritance', or 'virtual_inheritance'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_right_angle_bracket_equal_needs_space, CLASS_ERROR, (unsigned)diag::Severity::Error, "a space is required between a right angle bracket and an equals sign (use '> =')", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_scoped_enum_missing_identifier, CLASS_ERROR, (unsigned)diag::Severity::Error, "scoped enumeration requires a name", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_single_decl_assign_in_for_range, CLASS_ERROR, (unsigned)diag::Severity::Error, "range-based 'for' statement uses ':', not '='", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_sizeof_parameter_pack, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected parenthesized parameter pack name in 'sizeof...' expression", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_stmtexpr_file_scope, CLASS_ERROR, (unsigned)diag::Severity::Error, "statement expression not allowed at file scope", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_super_in_using_declaration, CLASS_ERROR, (unsigned)diag::Severity::Error, "'__super' cannot be used with a using declaration", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_synthesized_property_name, CLASS_ERROR, (unsigned)diag::Severity::Error, "expected a property name in @synthesize", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_template_defn_explicit_instantiation, CLASS_ERROR, (unsigned)diag::Severity::Error, "%select{function|class|variable}0 cannot be defined in an explicit instantiation; if this declaration is meant to be a %select{function|class|variable}0 definition, remove the 'template' keyword", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_template_spec_syntax_non_template, CLASS_ERROR, (unsigned)diag::Severity::Error, "identifier followed by '<' indicates a class template specialization but %0 %select{does not refer to a template|refers to a function template|<unused>|refers to a variable template|<unused>}1", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_templated_invalid_declaration, CLASS_ERROR, (unsigned)diag::Severity::Error, "a static_assert declaration cannot be a template", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_templated_using_directive_declaration, CLASS_ERROR, (unsigned)diag::Severity::Error, "cannot template a using %select{directive|declaration}0", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_this_captured_by_reference, CLASS_ERROR, (unsigned)diag::Severity::Error, "'this' cannot be captured by reference", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_two_right_angle_brackets_need_space, CLASS_ERROR, (unsigned)diag::Severity::Error, "a space is required between consecutive right angle brackets (use '> >')", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_type_safety_unknown_flag, CLASS_ERROR, (unsigned)diag::Severity::Error, "invalid comparison flag %0; use 'layout_compatible' or 'must_be_null'", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_type_trait_arity, CLASS_ERROR, (unsigned)diag::Severity::Error, "type trait requires %0%select{| or more}1 argument%select{|s}2; have %3 argument%s3", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_typename_identifiers_only, CLASS_ERROR, (unsigned)diag::Severity::Error, "typename is allowed for identifiers only", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_typename_invalid_constexpr, CLASS_ERROR, (unsigned)diag::Severity::Error, "type name does not allow constexpr specifier to be specified", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_typename_invalid_functionspec, CLASS_ERROR, (unsigned)diag::Severity::Error, "type name does not allow function specifier to be specified", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_typename_invalid_storageclass, CLASS_ERROR, (unsigned)diag::Severity::Error, "type name does not allow storage class to be specified", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_typename_refers_to_non_type_template, CLASS_ERROR, (unsigned)diag::Severity::Error, "typename specifier refers to a non-type template", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_typename_requires_specqual, CLASS_ERROR, (unsigned)diag::Severity::Error, "type name requires a specifier or qualifier", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_unexpected_at, CLASS_ERROR, (unsigned)diag::Severity::Error, "unexpected '@' in program", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_unexpected_colon_in_nested_name_spec, CLASS_ERROR, (unsigned)diag::Severity::Error, "unexpected ':' in nested name specifier; did you mean '::'?", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_unexpected_module_decl, CLASS_ERROR, (unsigned)diag::Severity::Error, "module declaration can only appear at the top level", 0, SFINAE_SubstitutionFailure, false, true, 13)
DIAG(err_unexpected_namespace_attributes_alias, CLASS_ERROR, (unsigned)diag::Severity::Error, "attributes cannot be specified on namespace alias", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_unexpected_nested_namespace_attribute, CLASS_ERROR, (unsigned)diag::Severity::Error, "attributes cannot be specified on a nested namespace definition", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_unexpected_protocol_qualifier, CLASS_ERROR, (unsigned)diag::Severity::Error, "@implementation declaration cannot be protocol qualified", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_unexpected_scope_on_base_decltype, CLASS_ERROR, (unsigned)diag::Severity::Error, "unexpected namespace scope prior to decltype", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_unexpected_semi, CLASS_ERROR, (unsigned)diag::Severity::Error, "unexpected ';' before %0", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_unexpected_token_in_nested_name_spec, CLASS_ERROR, (unsigned)diag::Severity::Error, "'%0' cannot be a part of nested name specifier; did you mean ':'?", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_unexpected_typedef_ident, CLASS_ERROR, (unsigned)diag::Severity::Error, "unexpected type name %0: expected identifier", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_unexpected_unqualified_id, CLASS_ERROR, (unsigned)diag::Severity::Error, "type-id cannot have a name", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_unknown_template_name, CLASS_ERROR, (unsigned)diag::Severity::Error, "unknown template name %0", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_unspecified_size_with_static, CLASS_ERROR, (unsigned)diag::Severity::Error, "'static' may not be used without an array size", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_unspecified_vla_size_with_static, CLASS_ERROR, (unsigned)diag::Severity::Error, "'static' may not be used with an unspecified variable length array size", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_using_attribute_ns_conflict, CLASS_ERROR, (unsigned)diag::Severity::Error, "attribute with scope specifier cannot follow default scope specifier", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_using_namespace_in_class, CLASS_ERROR, (unsigned)diag::Severity::Error, "'using namespace' is not allowed in classes", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(err_zero_version, CLASS_ERROR, (unsigned)diag::Severity::Error, "version number must have non-zero major, minor, or sub-minor version", 0, SFINAE_SubstitutionFailure, false, true, 4)
DIAG(ext_abstract_pack_declarator_parens, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "ISO C++11 requires a parenthesized pack declaration to have a name", 24, SFINAE_Suppress, false, false, 4)
DIAG(ext_alias_declaration, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "alias declarations are a C++11 extension", 75, SFINAE_Suppress, false, false, 4)
DIAG(ext_alignof_expr, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "%0 applied to an expression is a GNU extension", 225, SFINAE_Suppress, false, false, 4)
DIAG(ext_auto_storage_class, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "'auto' storage class specifier is not permitted in C++11, and will not be supported in future releases", 48, SFINAE_Suppress, false, false, 4)
DIAG(ext_auto_type, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "'__auto_type' is a GNU extension", 228, SFINAE_Suppress, false, false, 4)
DIAG(ext_c11_alignment, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "%0 is a C11-specific feature", 100, SFINAE_Suppress, false, false, 4)
DIAG(ext_c11_generic_selection, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "generic selections are a C11-specific feature", 100, SFINAE_Suppress, false, false, 4)
DIAG(ext_c11_noreturn, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "_Noreturn functions are a C11-specific feature", 100, SFINAE_Suppress, false, false, 4)
DIAG(ext_c11_static_assert, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "_Static_assert is a C11-specific feature", 100, SFINAE_Suppress, false, false, 4)
DIAG(ext_c99_compound_literal, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "compound literals are a C99-specific feature", 102, SFINAE_Suppress, false, false, 4)
DIAG(ext_c99_variable_decl_in_for_loop, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "variable declaration in for loop is a C99-specific feature", 102, SFINAE_Suppress, false, false, 4)
DIAG(ext_c_enum_fixed_underlying_type, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "enumeration types with a fixed underlying type are a Microsoft extension", 352, SFINAE_Suppress, false, false, 4)
DIAG(ext_constexpr_if, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "constexpr if is a C++17 extension", 86, SFINAE_Suppress, false, false, 4)
DIAG(ext_constexpr_on_lambda_cxx1z, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "'constexpr' on lambda expressions is a C++17 extension", 86, SFINAE_Suppress, false, false, 4)
DIAG(ext_cxx11_enum_fixed_underlying_type, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "enumeration types with a fixed underlying type are a C++11 extension", 75, SFINAE_Suppress, false, false, 4)
DIAG(ext_decltype_auto_type_specifier, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "'decltype(auto)' type specifier is a C++14 extension", 83, SFINAE_Suppress, false, false, 4)
DIAG(ext_decomp_decl_empty, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "ISO C++17 does not allow a decomposition group to be empty", 181, SFINAE_Suppress, false, false, 4)
DIAG(ext_defaulted_deleted_function, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "%select{defaulted|deleted}0 function definitions are a C++11 extension", 75, SFINAE_Suppress, false, false, 4)
DIAG(ext_ellipsis_exception_spec, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "exception specification of '...' is a Microsoft extension", 348, SFINAE_Suppress, false, false, 4)
DIAG(ext_empty_translation_unit, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "ISO C requires a translation unit to contain at least one declaration", 182, SFINAE_Suppress, false, false, 4)
DIAG(ext_enumerator_list_comma_c, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "commas at the end of enumerator lists are a C99-specific feature", 102, SFINAE_Suppress, false, false, 4)
DIAG(ext_enumerator_list_comma_cxx, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "commas at the end of enumerator lists are a C++11 extension", 75, SFINAE_Suppress, false, false, 4)
DIAG(ext_expected_semi_decl_list, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "expected ';' at end of declaration list", 0, SFINAE_Suppress, false, false, 4)
DIAG(ext_extern_template, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "extern templates are a C++11 extension", 75, SFINAE_Suppress, false, false, 4)
DIAG(ext_extra_semi, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "extra ';' %select{outside of a function|inside a %1|inside instance variable list|after member function definition}0", 198, SFINAE_Suppress, false, false, 4)
DIAG(ext_extra_semi_cxx11, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "extra ';' outside of a function is a C++11 extension", 76, SFINAE_Suppress, false, false, 4)
DIAG(ext_fold_expression, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "pack fold expression is a C++17 extension", 86, SFINAE_Suppress, false, false, 4)
DIAG(ext_for_range, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "range-based for loop is a C++11 extension", 75, SFINAE_Suppress, false, false, 4)
DIAG(ext_generalized_initializer_lists, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "generalized initializer lists are a C++11 extension", 75, SFINAE_Suppress, false, false, 4)
DIAG(ext_gnu_address_of_label, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "use of GNU address-of-label extension", 242, SFINAE_Suppress, false, false, 4)
DIAG(ext_gnu_array_range, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "use of GNU array range extension", 234, SFINAE_Suppress, false, false, 4)
DIAG(ext_gnu_case_range, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "use of GNU case range extension", 230, SFINAE_Suppress, false, false, 4)
DIAG(ext_gnu_conditional_expr, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "use of GNU ?: conditional expression extension, omitting middle operand", 233, SFINAE_Suppress, false, false, 4)
DIAG(ext_gnu_empty_initializer, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "use of GNU empty initializer extension", 235, SFINAE_Suppress, false, false, 4)
DIAG(ext_gnu_indirect_goto, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "use of GNU indirect-goto extension", 242, SFINAE_Suppress, false, false, 4)
DIAG(ext_gnu_missing_equal_designator, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "use of GNU 'missing =' extension in designator", 234, SFINAE_Suppress, false, false, 4)
DIAG(ext_gnu_old_style_field_designator, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "use of GNU old-style field designator extension", 234, SFINAE_Suppress, false, false, 4)
DIAG(ext_gnu_statement_expr, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "use of GNU statement expression extension", 244, SFINAE_Suppress, false, false, 4)
DIAG(ext_ident_list_in_param, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "type-less parameter names in function declaration", 480, SFINAE_Suppress, false, false, 4)
DIAG(ext_init_statement, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "'%select{if|switch}0' initialization statements are a C++17 extension", 86, SFINAE_Suppress, false, false, 4)
DIAG(ext_inline_namespace, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "inline namespaces are a C++11 feature", 77, SFINAE_Suppress, false, false, 4)
DIAG(ext_keyword_as_ident, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "keyword '%0' will be made available as an identifier %select{here|for the remainder of the translation unit}1", 316, SFINAE_Suppress, false, false, 4)
DIAG(ext_ms_sealed_keyword, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "'sealed' keyword is a Microsoft extension", 359, SFINAE_Suppress, false, false, 4)
DIAG(ext_multi_using_declaration, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "use of multiple declarators in a single using declaration is a C++17 extension", 86, SFINAE_Suppress, false, false, 4)
DIAG(ext_nested_namespace_definition, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "nested namespace definition is a C++17 extension; define each namespace separately", 86, SFINAE_Suppress, false, false, 4)
DIAG(ext_nonstatic_member_init, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "in-class initialization of non-static data member is a C++11 extension", 75, SFINAE_Suppress, false, false, 4)
DIAG(ext_nullability, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "type nullability specifier %0 is a Clang extension", 420, SFINAE_Suppress, false, false, 4)
DIAG(ext_override_control_keyword, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "'%0' keyword is a C++11 extension", 75, SFINAE_Suppress, false, false, 4)
DIAG(ext_ref_qualifier, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "reference qualifiers on functions are a C++11 extension", 75, SFINAE_Suppress, false, false, 4)
DIAG(ext_rvalue_reference, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "rvalue references are a C++11 extension", 75, SFINAE_Suppress, false, false, 4)
DIAG(ext_scoped_enum, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "scoped enumerations are a C++11 extension", 75, SFINAE_Suppress, false, false, 4)
DIAG(ext_template_template_param_typename, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "template template parameter using 'typename' is a C++17 extension", 86, SFINAE_Suppress, false, false, 4)
DIAG(ext_thread_before, CLASS_EXTENSION, (unsigned)diag::Severity::Ignored, "'__thread' before '%0'", 480, SFINAE_Suppress, false, false, 4)
DIAG(ext_using_attribute_ns, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "default scope specifier for attributes is a C++17 extension", 86, SFINAE_Suppress, false, false, 4)
DIAG(ext_using_declaration_pack, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "pack expansion of using declaration is a C++17 extension", 86, SFINAE_Suppress, false, false, 4)
DIAG(note_bracket_depth, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "use -fbracket-depth=N to increase maximum nesting level", 0, SFINAE_Suppress, false, false, 4)
DIAG(note_extra_comma_message_arg, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "comma separating Objective-C messaging arguments", 0, SFINAE_Suppress, false, false, 4)
DIAG(note_force_empty_selector_name, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "or insert whitespace before ':' to use %0 as parameter name and have an empty entry in the selector", 0, SFINAE_Suppress, false, false, 4)
DIAG(note_misplaced_ellipsis_vararg_add_comma, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "insert ',' before '...' to silence this warning", 0, SFINAE_Suppress, false, false, 4)
DIAG(note_misplaced_ellipsis_vararg_add_ellipsis, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "place '...' %select{immediately before declared identifier|here}0 to declare a function parameter pack", 0, SFINAE_Suppress, false, false, 4)
DIAG(note_misplaced_ellipsis_vararg_existing_ellipsis, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "preceding '...' declares a function parameter pack", 0, SFINAE_Suppress, false, false, 4)
DIAG(note_missing_end_of_definition_before, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "still within definition of %q0 here", 0, SFINAE_Suppress, false, false, 4)
DIAG(note_missing_selector_name, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "introduce a parameter name to make %0 part of the selector", 0, SFINAE_Suppress, false, false, 4)
DIAG(note_objc_container_start, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "%select{class|protocol|category|class extension|implementation|category implementation}0 started here", 0, SFINAE_Suppress, false, false, 4)
DIAG(note_pragma_attribute_use_attribute_kw, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "use the GNU '__attribute__' syntax", 0, SFINAE_Suppress, false, false, 4)
DIAG(note_previous_default_assoc, CLASS_NOTE, (unsigned)diag::Severity::Fatal, "previous default generic association is here", 0, SFINAE_Suppress, false, false, 4)
DIAG(warn_arc_bridge_cast_nonarc, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'%0' casts have no effect when not using ARC", 26, SFINAE_Suppress, false, false, 8)
DIAG(warn_asm_qualifier_ignored, CLASS_WARNING, (unsigned)diag::Severity::Warning, "ignored %0 qualifier on asm", 36, SFINAE_Suppress, false, false, 12)
DIAG(warn_attribute_no_decl, CLASS_WARNING, (unsigned)diag::Severity::Warning, "attribute %0 ignored, because it is not attached to a declaration", 254, SFINAE_Suppress, false, false, 4)
DIAG(warn_attribute_on_function_definition, CLASS_WARNING, (unsigned)diag::Severity::Warning, "GCC does not allow %0 attribute in this position on a function definition", 222, SFINAE_Suppress, false, false, 4)
DIAG(warn_availability_and_unavailable, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'unavailable' availability overrides all other availability information", 50, SFINAE_Suppress, false, false, 4)
DIAG(warn_cstyle_param, CLASS_WARNING, (unsigned)diag::Severity::Warning, "use of C-style parameters in Objective-C method declarations is deprecated", 145, SFINAE_Suppress, false, false, 26)
DIAG(warn_cuda_attr_lambda_position, CLASS_WARNING, (unsigned)diag::Severity::Warning, "nvcc does not allow '__%0__' to appear after '()' in lambdas", 131, SFINAE_Suppress, false, false, 4)
DIAG(warn_cxx11_compat_decltype_auto_type_specifier, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "'decltype(auto)' type specifier is incompatible with C++ standards before C++14", 93, SFINAE_Suppress, false, false, 4)
DIAG(warn_cxx11_right_shift_in_template_arg, CLASS_WARNING, (unsigned)diag::Severity::Warning, "use of right-shift operator ('>>') in template argument will require parentheses in C++11", 71, SFINAE_Suppress, false, false, 4)
DIAG(warn_cxx14_compat_attribute, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "attributes on %select{a namespace|an enumerator}0 declaration are incompatible with C++ standards before C++17", 91, SFINAE_Suppress, false, false, 4)
DIAG(warn_cxx14_compat_constexpr_if, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "constexpr if is incompatible with C++ standards before C++17", 91, SFINAE_Suppress, false, false, 4)
DIAG(warn_cxx14_compat_constexpr_on_lambda, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "constexpr on lambda expressions is incompatible with C++ standards before C++17", 91, SFINAE_Suppress, false, false, 4)
DIAG(warn_cxx14_compat_fold_expression, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "pack fold expression is incompatible with C++ standards before C++17", 91, SFINAE_Suppress, false, false, 4)
DIAG(warn_cxx14_compat_init_statement, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%select{if|switch}0 initialization statements are incompatible with C++ standards before C++17", 91, SFINAE_Suppress, false, false, 4)
DIAG(warn_cxx14_compat_nested_namespace_definition, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "nested namespace definition is incompatible with C++ standards before C++17", 91, SFINAE_Suppress, false, false, 4)
DIAG(warn_cxx14_compat_template_template_param_typename, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "template template parameter using 'typename' is incompatible with C++ standards before C++17", 91, SFINAE_Suppress, false, false, 4)
DIAG(warn_cxx14_compat_using_attribute_ns, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "default scope specifier for attributes is incompatible with C++ standards before C++17", 91, SFINAE_Suppress, false, false, 4)
DIAG(warn_cxx1z_compat_multi_using_declaration, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "use of multiple declarators in a single using declaration is incompatible with C++ standards before C++17", 91, SFINAE_Suppress, false, false, 4)
DIAG(warn_cxx1z_compat_using_declaration_pack, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "pack expansion using declaration is incompatible with C++ standards before C++17", 91, SFINAE_Suppress, false, false, 4)
DIAG(warn_cxx98_compat_alias_declaration, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "alias declarations are incompatible with C++98", 95, SFINAE_Suppress, false, false, 4)
DIAG(warn_cxx98_compat_alignas, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "'alignas' is incompatible with C++98", 95, SFINAE_Suppress, false, false, 4)
DIAG(warn_cxx98_compat_alignof, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "alignof expressions are incompatible with C++98", 95, SFINAE_Suppress, false, false, 4)
DIAG(warn_cxx98_compat_attribute, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "C++11 attribute syntax is incompatible with C++98", 95, SFINAE_Suppress, false, false, 4)
DIAG(warn_cxx98_compat_decltype, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "'decltype' type specifier is incompatible with C++98", 95, SFINAE_Suppress, false, false, 4)
DIAG(warn_cxx98_compat_defaulted_deleted_function, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "%select{defaulted|deleted}0 function definitions are incompatible with C++98", 95, SFINAE_Suppress, false, false, 4)
DIAG(warn_cxx98_compat_enum_fixed_underlying_type, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "enumeration types with a fixed underlying type are incompatible with C++98", 95, SFINAE_Suppress, false, false, 4)
DIAG(warn_cxx98_compat_enumerator_list_comma, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "commas at the end of enumerator lists are incompatible with C++98", 98, SFINAE_Suppress, false, false, 4)
DIAG(warn_cxx98_compat_extern_template, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "extern templates are incompatible with C++98", 98, SFINAE_Suppress, false, false, 4)
DIAG(warn_cxx98_compat_for_range, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "range-based for loop is incompatible with C++98", 95, SFINAE_Suppress, false, false, 4)
DIAG(warn_cxx98_compat_generalized_initializer_lists, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "generalized initializer lists are incompatible with C++98", 95, SFINAE_Suppress, false, false, 4)
DIAG(warn_cxx98_compat_inline_namespace, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "inline namespaces are incompatible with C++98", 95, SFINAE_Suppress, false, false, 4)
DIAG(warn_cxx98_compat_lambda, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "lambda expressions are incompatible with C++98", 95, SFINAE_Suppress, false, false, 4)
DIAG(warn_cxx98_compat_literal_operator, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "literal operators are incompatible with C++98", 95, SFINAE_Suppress, false, false, 4)
DIAG(warn_cxx98_compat_noexcept_decl, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "noexcept specifications are incompatible with C++98", 95, SFINAE_Suppress, false, false, 4)
DIAG(warn_cxx98_compat_noexcept_expr, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "noexcept expressions are incompatible with C++98", 95, SFINAE_Suppress, false, false, 4)
DIAG(warn_cxx98_compat_nonstatic_member_init, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "in-class initialization of non-static data members is incompatible with C++98", 95, SFINAE_Suppress, false, false, 4)
DIAG(warn_cxx98_compat_nullptr, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "'nullptr' is incompatible with C++98", 95, SFINAE_Suppress, false, false, 4)
DIAG(warn_cxx98_compat_override_control_keyword, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "'%0' keyword is incompatible with C++98", 95, SFINAE_Suppress, false, false, 4)
DIAG(warn_cxx98_compat_ref_qualifier, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "reference qualifiers on functions are incompatible with C++98", 95, SFINAE_Suppress, false, false, 4)
DIAG(warn_cxx98_compat_rvalue_reference, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "rvalue references are incompatible with C++98", 95, SFINAE_Suppress, false, false, 4)
DIAG(warn_cxx98_compat_scoped_enum, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "scoped enumerations are incompatible with C++98", 95, SFINAE_Suppress, false, false, 4)
DIAG(warn_cxx98_compat_static_assert, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "static_assert declarations are incompatible with C++98", 95, SFINAE_Suppress, false, false, 4)
DIAG(warn_cxx98_compat_top_level_semi, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "extra ';' outside of a function is incompatible with C++98", 98, SFINAE_Suppress, false, false, 4)
DIAG(warn_cxx98_compat_trailing_return_type, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "trailing return types are incompatible with C++98", 95, SFINAE_Suppress, false, false, 4)
DIAG(warn_cxx98_compat_two_right_angle_brackets, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "consecutive right angle brackets are incompatible with C++98 (use '> >')", 95, SFINAE_Suppress, false, false, 4)
DIAG(warn_dangling_else, CLASS_WARNING, (unsigned)diag::Severity::Warning, "add explicit braces to avoid dangling else", 133, SFINAE_Suppress, false, false, 4)
DIAG(warn_expected_consistent_version_separator, CLASS_WARNING, (unsigned)diag::Severity::Warning, "use same version number separators '_' or '.'; as in 'major[.minor[.subminor]]'", 50, SFINAE_Suppress, false, false, 4)
DIAG(warn_expected_qualified_after_typename, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "expected a qualified name after 'typename'", 0, SFINAE_Suppress, false, false, 4)
DIAG(warn_extra_semi_after_mem_fn_def, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "extra ';' after member function definition", 198, SFINAE_Suppress, false, false, 4)
DIAG(warn_file_asm_volatile, CLASS_WARNING, (unsigned)diag::Severity::Warning, "meaningless 'volatile' on asm outside function", 36, SFINAE_Suppress, false, false, 12)
DIAG(warn_gcc_attribute_location, CLASS_WARNING, (unsigned)diag::Severity::Warning, "GCC does not allow an attribute in this position on a function declaration", 222, SFINAE_Suppress, false, false, 4)
DIAG(warn_microsoft_dependent_exists, CLASS_WARNING, (unsigned)diag::Severity::Warning, "dependent %select{__if_not_exists|__if_exists}0 declarations are ignored", 349, SFINAE_Suppress, false, false, 4)
DIAG(warn_microsoft_qualifiers_ignored, CLASS_WARNING, (unsigned)diag::Severity::Warning, "qualifiers after comma in declarator list are ignored", 254, SFINAE_Suppress, false, false, 4)
DIAG(warn_misplaced_ellipsis_vararg, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'...' in this location creates a C-style varargs function%select{, not a function parameter pack|}0", 20, SFINAE_Suppress, false, false, 4)
DIAG(warn_missing_dependent_template_keyword, CLASS_EXTENSION, (unsigned)diag::Severity::Warning, "use 'template' keyword to treat '%0' as a dependent template name", 0, SFINAE_Suppress, false, false, 4)
DIAG(warn_missing_selector_name, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%0 used as the name of the previous parameter rather than as part of the selector", 379, SFINAE_Suppress, false, false, 4)
DIAG(warn_objc_protocol_qualifier_missing_id, CLASS_WARNING, (unsigned)diag::Severity::Warning, "protocol has no object type specified; defaults to qualified 'id'", 0, SFINAE_Suppress, false, false, 4)
DIAG(warn_omp_extra_tokens_at_eol, CLASS_WARNING, (unsigned)diag::Severity::Warning, "extra tokens at the end of '#pragma omp %0' are ignored", 199, SFINAE_Suppress, false, false, 4)
DIAG(warn_pragma_align_expected_equal, CLASS_WARNING, (unsigned)diag::Severity::Warning, "expected '=' following '#pragma %select{align|options align}0' - ignored", 257, SFINAE_Suppress, false, false, 4)
DIAG(warn_pragma_align_invalid_option, CLASS_WARNING, (unsigned)diag::Severity::Warning, "invalid alignment option in '#pragma %select{align|options align}0' - ignored", 257, SFINAE_Suppress, false, false, 4)
DIAG(warn_pragma_begin_end_mismatch, CLASS_WARNING, (unsigned)diag::Severity::Warning, "OpenCL extension end directive mismatches begin directive - ignoring", 257, SFINAE_Suppress, false, false, 4)
DIAG(warn_pragma_comment_ignored, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'#pragma comment %0' ignored", 257, SFINAE_Suppress, false, false, 4)
DIAG(warn_pragma_expected_action_or_r_paren, CLASS_WARNING, (unsigned)diag::Severity::Warning, "expected action or ')' in '#pragma %0' - ignored", 257, SFINAE_Suppress, false, false, 4)
DIAG(warn_pragma_expected_colon, CLASS_WARNING, (unsigned)diag::Severity::Warning, "missing ':' after %0 - ignoring", 257, SFINAE_Suppress, false, false, 4)
DIAG(warn_pragma_expected_colon_r_paren, CLASS_WARNING, (unsigned)diag::Severity::Warning, "missing ':' or ')' after %0 - ignoring", 257, SFINAE_Suppress, false, false, 4)
DIAG(warn_pragma_expected_identifier, CLASS_WARNING, (unsigned)diag::Severity::Warning, "expected identifier in '#pragma %0' - ignored", 257, SFINAE_Suppress, false, false, 4)
DIAG(warn_pragma_expected_init_seg, CLASS_WARNING, (unsigned)diag::Severity::Warning, "expected 'compiler', 'lib', 'user', or a string literal for the section name in '#pragma %0' - ignored", 257, SFINAE_Suppress, false, false, 4)
DIAG(warn_pragma_expected_integer, CLASS_WARNING, (unsigned)diag::Severity::Warning, "expected integer between %0 and %1 inclusive in '#pragma %2' - ignored", 257, SFINAE_Suppress, false, false, 4)
DIAG(warn_pragma_expected_lparen, CLASS_WARNING, (unsigned)diag::Severity::Warning, "missing '(' after '#pragma %0' - ignoring", 257, SFINAE_Suppress, false, false, 4)
DIAG(warn_pragma_expected_non_wide_string, CLASS_WARNING, (unsigned)diag::Severity::Warning, "expected non-wide string literal in '#pragma %0'", 257, SFINAE_Suppress, false, false, 4)
DIAG(warn_pragma_expected_predicate, CLASS_WARNING, (unsigned)diag::Severity::Warning, "expected %select{'enable', 'disable', 'begin' or 'end'|'disable'}0 - ignoring", 257, SFINAE_Suppress, false, false, 4)
DIAG(warn_pragma_expected_punc, CLASS_WARNING, (unsigned)diag::Severity::Warning, "expected ')' or ',' in '#pragma %0'", 257, SFINAE_Suppress, false, false, 4)
DIAG(warn_pragma_expected_rparen, CLASS_WARNING, (unsigned)diag::Severity::Warning, "missing ')' after '#pragma %0' - ignoring", 257, SFINAE_Suppress, false, false, 4)
DIAG(warn_pragma_expected_section_label_or_name, CLASS_WARNING, (unsigned)diag::Severity::Warning, "expected a stack label or a string literal for the section name in '#pragma %0' - ignored", 257, SFINAE_Suppress, false, false, 4)
DIAG(warn_pragma_expected_section_name, CLASS_WARNING, (unsigned)diag::Severity::Warning, "expected a string literal for the section name in '#pragma %0' - ignored", 257, SFINAE_Suppress, false, false, 4)
DIAG(warn_pragma_expected_section_push_pop_or_name, CLASS_WARNING, (unsigned)diag::Severity::Warning, "expected push, pop or a string literal for the section name in '#pragma %0' - ignored", 257, SFINAE_Suppress, false, false, 4)
DIAG(warn_pragma_extension_is_core, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "OpenCL extension %0 is core feature or supported optional core feature - ignoring", 481, SFINAE_Suppress, false, false, 4)
DIAG(warn_pragma_extra_tokens_at_eol, CLASS_WARNING, (unsigned)diag::Severity::Warning, "extra tokens at end of '#pragma %0' - ignored", 257, SFINAE_Suppress, false, false, 4)
DIAG(warn_pragma_force_cuda_host_device_bad_arg, CLASS_WARNING, (unsigned)diag::Severity::Warning, "incorrect use of #pragma clang force_cuda_host_device begin|end", 257, SFINAE_Suppress, false, false, 4)
DIAG(warn_pragma_init_seg_unsupported_target, CLASS_WARNING, (unsigned)diag::Severity::Warning, "'#pragma init_seg' is only supported when targeting a Microsoft environment", 257, SFINAE_Suppress, false, false, 4)
DIAG(warn_pragma_intrinsic_builtin, CLASS_WARNING, (unsigned)diag::Severity::Warning, "%0 is not a recognized builtin%select{|; consider including <intrin.h> to access non-builtin intrinsics}1", 256, SFINAE_Suppress, false, false, 4)
DIAG(warn_pragma_invalid_action, CLASS_WARNING, (unsigned)diag::Severity::Warning, "unknown action for '#pragma %0' - ignored", 257, SFINAE_Suppress, false, false, 4)
DIAG(warn_pragma_invalid_specific_action, CLASS_WARNING, (unsigned)diag::Severity::Warning, "unknown action '%1' for '#pragma %0' - ignored", 257, SFINAE_Suppress, false, false, 4)
DIAG(warn_pragma_ms_struct, CLASS_WARNING, (unsigned)diag::Severity::Warning, "incorrect use of '#pragma ms_struct on|off' - ignored", 257, SFINAE_Suppress, false, false, 4)
DIAG(warn_pragma_omp_ignored, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "unexpected '#pragma omp ...' in program", 558, SFINAE_Suppress, false, false, 4)
DIAG(warn_pragma_options_expected_align, CLASS_WARNING, (unsigned)diag::Severity::Warning, "expected 'align' following '#pragma options' - ignored", 257, SFINAE_Suppress, false, false, 4)
DIAG(warn_pragma_pack_malformed, CLASS_WARNING, (unsigned)diag::Severity::Warning, "expected integer or identifier in '#pragma pack' - ignored", 257, SFINAE_Suppress, false, false, 4)
DIAG(warn_pragma_unknown_extension, CLASS_WARNING, (unsigned)diag::Severity::Warning, "unknown OpenCL extension %0 - ignoring", 257, SFINAE_Suppress, false, false, 4)
DIAG(warn_pragma_unroll_cuda_value_in_parens, CLASS_WARNING, (unsigned)diag::Severity::Warning, "argument to '#pragma unroll' should not be in parentheses in CUDA C/C++", 131, SFINAE_Suppress, false, false, 4)
DIAG(warn_pragma_unsupported_action, CLASS_WARNING, (unsigned)diag::Severity::Warning, "known but unsupported action '%1' for '#pragma %0' - ignored", 257, SFINAE_Suppress, false, false, 4)
DIAG(warn_pragma_unsupported_extension, CLASS_WARNING, (unsigned)diag::Severity::Warning, "unsupported OpenCL extension %0 - ignoring", 257, SFINAE_Suppress, false, false, 4)
DIAG(warn_pragma_unused_expected_var, CLASS_WARNING, (unsigned)diag::Severity::Warning, "expected '#pragma unused' argument to be a variable name", 257, SFINAE_Suppress, false, false, 4)
DIAG(warn_semicolon_before_method_body, CLASS_WARNING, (unsigned)diag::Severity::Ignored, "semicolon before method body is ignored", 531, SFINAE_Suppress, false, false, 4)
DIAG(warn_static_inline_explicit_inst_ignored, CLASS_WARNING, (unsigned)diag::Severity::Warning, "ignoring '%select{static|inline}0' keyword on explicit template instantiation", 563, SFINAE_Suppress, false, false, 4)
