/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.Looper;
import com.google.android.gms.common.api.AbstractPendingResult;
import com.google.android.gms.common.api.BatchResult;
import com.google.android.gms.common.api.BatchResultToken;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import java.util.ArrayList;
import java.util.List;

public final class Batch
extends AbstractPendingResult<BatchResult> {
    private int zzWn;
    private boolean zzWo;
    private boolean zzWp;
    private final PendingResult<?>[] zzWq;
    private final Object zzqt = new Object();

    private Batch(List<PendingResult<?>> pendingResultList, Looper looper) {
        super(new AbstractPendingResult.CallbackHandler(looper));
        this.zzWn = pendingResultList.size();
        this.zzWq = new PendingResult[this.zzWn];
        for (int i = 0; i < pendingResultList.size(); ++i) {
            PendingResult<?> pendingResult = pendingResultList.get(i);
            this.zzWq[i] = pendingResult;
            pendingResult.addBatchCallback(new PendingResult.BatchCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void zzs(Status status) {
                    Object object = Batch.this.zzqt;
                    synchronized (object) {
                        if (Batch.this.isCanceled()) {
                            return;
                        }
                        if (status.isCanceled()) {
                            Batch.this.zzWp = true;
                        } else if (!status.isSuccess()) {
                            Batch.this.zzWo = true;
                        }
                        Batch.this.zzWn--;
                        if (Batch.this.zzWn == 0) {
                            if (Batch.this.zzWp) {
                                Batch.super.cancel();
                            } else {
                                Status status2 = Batch.this.zzWo ? new Status(13) : Status.zzXP;
                                Batch.this.setResult(new BatchResult(status2, Batch.this.zzWq));
                            }
                        }
                    }
                }
            });
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        for (PendingResult<?> pendingResult : this.zzWq) {
            pendingResult.cancel();
        }
    }

    @Override
    public BatchResult createFailedResult(Status status) {
        return new BatchResult(status, this.zzWq);
    }

    public static final class Builder {
        private List<PendingResult<?>> zzWs = new ArrayList();
        private Looper zzWt;

        public Builder(GoogleApiClient googleApiClient) {
            this.zzWt = googleApiClient.getLooper();
        }

        public <R extends Result> BatchResultToken<R> add(PendingResult<R> pendingResult) {
            BatchResultToken batchResultToken = new BatchResultToken(this.zzWs.size());
            this.zzWs.add(pendingResult);
            return batchResultToken;
        }

        public Batch build() {
            return new Batch(this.zzWs, this.zzWt);
        }
    }
}

