/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.Looper;
import com.google.android.gms.common.api.AbstractPendingResult;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zzl;
import com.google.android.gms.common.internal.zzu;

public final class PendingResults {
    public static PendingResult<Status> immediatePendingResult(Status result) {
        zzu.zzb(result, (Object)"Result must not be null");
        zzl zzl2 = new zzl(Looper.getMainLooper());
        zzl2.setResult(result);
        return zzl2;
    }

    public static <R extends Result> PendingResult<R> immediatePendingResult(R result) {
        zzu.zzb(result, (Object)"Result must not be null");
        zzb<R> zzb2 = new zzb<R>();
        zzb2.setResult(result);
        return zzb2;
    }

    public static PendingResult<Status> canceledPendingResult() {
        zzl zzl2 = new zzl(Looper.getMainLooper());
        zzl2.cancel();
        return zzl2;
    }

    public static <R extends Result> PendingResult<R> canceledPendingResult(R result) {
        zzu.zzb(result, (Object)"Result must not be null");
        zzu.zzb(result.getStatus().getStatusCode() == 16, (Object)"Status code must be CommonStatusCodes.CANCELED");
        zza<R> zza2 = new zza<R>(result);
        zza2.cancel();
        return zza2;
    }

    private PendingResults() {
    }

    private static final class zza<R extends Result>
    extends AbstractPendingResult<R> {
        private final R zzXN;

        public zza(R r) {
            super(Looper.getMainLooper());
            this.zzXN = r;
        }

        @Override
        protected R createFailedResult(Status status) {
            if (status.getStatusCode() != this.zzXN.getStatus().getStatusCode()) {
                throw new UnsupportedOperationException("Creating failed results is not supported");
            }
            return this.zzXN;
        }
    }

    private static final class zzb<R extends Result>
    extends AbstractPendingResult<R> {
        public zzb() {
            super(Looper.getMainLooper());
        }

        @Override
        protected R createFailedResult(Status status) {
            throw new UnsupportedOperationException("Creating failed results is not supported");
        }
    }
}

