10 PRINT "PROGRAM FILE 142: SERIAL CORRELATION TEST OF RND FUNCTION."
20 PRINT "    ANSI STANDARD 8.4"
30 PRINT
40 PRINT "SECTION 142.1: SERIAL CORRELATION TEST OF RND FUNCTION."
50 PRINT
60 PRINT "THIS PROGRAM COMPUTES THE SERIAL CORRELATION COEFFICIENT"
70 PRINT "BETWEEN PAIRS OF ADJACENT RANDOM NUMBERS. THE RESULT IS "
80 PRINT "COMPARED WITH THE EXPECTED VALUE FOR UNIFORM INDEPENDENT"
90 PRINT "RANDOM NUMBERS. (BECAUSE THE PAIR I AND I+1 IS NOT"
100 PRINT "COMPLETELY INDEPENDENT OF I+1, I+2, THE EXPECTED VALUE"
110 PRINT "OF THE COEFFICIENT IS NOT EXACTLY ZERO.)"
120 PRINT
130 PRINT "***** THIS TEST IS INFORMATIVE ONLY *****"
140 PRINT
150 PRINT "                  BEGIN TEST"
160 PRINT
170 LET N=1000
180 LET Y=RND
190 LET S1=Y
200 LET S2=Y*Y
210 LET S3=0
220 LET Z=Y
230 REM IN LOOP, X IS CURRENT RND, Y IS PREVIOUS RND.
240 FOR N1=1 TO N
250 LET X=RND
260 LET S1=S1+X
270 LET S2=S2+(X*X)
280 LET S3=S3+(X*Y)
290 LET Y=X
300 NEXT N1
310 LET S3=S3+(X*Z)
320 LET S4=S1*S1
330 LET C=((N*S3) - S4) / ((N*S2) - S4)
340 LET U=1/(1-N)
350 LET D=SQR((N*(N-3)) / (N+1)) / (N-1)
360 LET D=D+D
370 PRINT "WITH ABOUT 95% PROBABILITY, WE EXPECT CORRELATION TO"
380 PRINT "EQUAL ";U;" + OR - ";D
390 PRINT
400 PRINT "THAT IS, WE EXPECT ";U-D;" <= CORRELATION <= ";U+D
410 PRINT
420 PRINT "ACTUAL CORRELATION = ";C
430 LET E1=ABS(C-U)
440 PRINT
450 IF E1<=D THEN 480
460 PRINT "*** INFORMATIVE TEST FAILED ***"
470 GOTO 490
480 PRINT "*** INFORMATIVE TEST PASSED ***"
490 PRINT
500 PRINT "                  END TEST"
510 PRINT
520 PRINT "END PROGRAM 142"
530 END
