10 PRINT "PROGRAM FILE 169: EXCEPTION - NUMERIC UNDERFLOW IN THE"
20 PRINT "        EVALUATION OF NUMERIC EXPRESSIONS ACTING AS "
30 PRINT "        ARGUMENTS AND SUBSCRIPTS."
40 PRINT "    ANSI STANDARD 6.4, 7.4, 7.6, 8.4"
50 PRINT
60 PRINT "THIS PROGRAM TESTS THAT THE HANDLING OF"
70 PRINT "UNDERFLOW OCCURRING DURING THE EVALUATION OF NUMERIC"
80 PRINT "EXPRESSIONS WORKS PROPERLY IN CONTEXTS OTHER THAN SIMPLE"
90 PRINT "ASSIGNMENT OF THE EXPRESSION TO A VARIABLE. SPECIFICALLY,"
100 PRINT "EXPRESSIONS ARE USED AS ARGUMENTS TO FUNCTIONS AND"
110 PRINT "SUBSCRIPTS OF ARRAYS."
120 PRINT
130 PRINT "SECTION 169.1: NUMERIC UNDERFLOW IN AN ARGUMENT TO A"
140 PRINT "        SUPPLIED FUNCTION."
150 PRINT
160 PRINT "TO PASS THIS TEST:"
170 PRINT
180 PRINT "    1) A MESSAGE IDENTIFYING AN EXCEPTION MAY BE"
190 PRINT "       DISPLAYED (NOT MANDATORY), AND"
200 PRINT
210 PRINT "    2) ZERO MUST BE SUPPLIED AS THE VALUE"
220 PRINT "       OF THE ARGUMENT AND EXECUTION CONTINUES."
230 PRINT
240 PRINT "                   BEGIN TEST."
250 PRINT
270 LET A=5000
280 LET B=1E-20
290 PRINT "ABOUT TO EVALUATE EXP(1E-20 ^ 5000)."
310 PRINT
320 LET C=EXP(B^A)
330 PRINT
340 PRINT "RESULT OF EXP(1E-20 ^ 5000) = ";C
350 PRINT
360 IF ABS(C-1) <= .001 THEN 400
370 PRINT "*** TEST FAILED: RESULT <> 1 ***"
380 GOTO 440
400 PRINT "*** TEST PASSED ***"
440 PRINT
450 PRINT "                    END TEST."
460 PRINT
1110 PRINT "SECTION 169.2: NUMERIC UNDERFLOW IN AN ARRAY SUBSCRIPT."
1130 PRINT
1160 PRINT "TO PASS THIS TEST:"
1170 PRINT
1180 PRINT "    1) A MESSAGE IDENTIFYING AN EXCEPTION MAY BE"
1190 PRINT "       DISPLAYED (NOT MANDATORY), AND"
1200 PRINT
1210 PRINT "    2) ZERO MUST BE SUPPLIED AS THE VALUE"
1220 PRINT "       OF THE SUBSCRIPT AND EXECUTION CONTINUES."
1230 PRINT
1240 PRINT "                   BEGIN TEST."
1250 PRINT
1270 LET A=5001
1280 LET B=-1E-20
1282 FOR I=0 TO 10
1284 LET Z(I)=100+I
1286 NEXT I
1290 PRINT "ABOUT TO EVALUATE Z(-1E-20 ^ 5001), WHERE Z(I) = I + 100."
1310 PRINT
1320 LET C=Z(B^A)
1330 PRINT
1340 PRINT "RESULT OF Z(-1E-20 ^ 5001) = ";C
1350 PRINT
1360 IF ABS(C-100) <= .01 THEN 1400
1370 PRINT "*** TEST FAILED: RESULT <> 100 ***"
1380 GOTO 1440
1400 PRINT "*** TEST PASSED ***"
1440 PRINT
1450 PRINT "                    END TEST."
1460 PRINT
3440 PRINT "END PROGRAM 169"
3450 END
