// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v4.25.3
// source: google/cloud/apigeeconnect/v1/tether.proto

package apigeeconnectpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The action taken by agent.
type Action int32

const (
	// Unspecified Action.
	Action_ACTION_UNSPECIFIED Action = 0
	// Indicates that agent should open a new stream.
	Action_OPEN_NEW_STREAM Action = 1
)

// Enum value maps for Action.
var (
	Action_name = map[int32]string{
		0: "ACTION_UNSPECIFIED",
		1: "OPEN_NEW_STREAM",
	}
	Action_value = map[string]int32{
		"ACTION_UNSPECIFIED": 0,
		"OPEN_NEW_STREAM":    1,
	}
)

func (x Action) Enum() *Action {
	p := new(Action)
	*p = x
	return p
}

func (x Action) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Action) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_apigeeconnect_v1_tether_proto_enumTypes[0].Descriptor()
}

func (Action) Type() protoreflect.EnumType {
	return &file_google_cloud_apigeeconnect_v1_tether_proto_enumTypes[0]
}

func (x Action) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Action.Descriptor instead.
func (Action) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_apigeeconnect_v1_tether_proto_rawDescGZIP(), []int{0}
}

// Endpoint indicates where the messages will be delivered.
type TetherEndpoint int32

const (
	// Unspecified tether endpoint.
	TetherEndpoint_TETHER_ENDPOINT_UNSPECIFIED TetherEndpoint = 0
	// Apigee MART endpoint.
	TetherEndpoint_APIGEE_MART TetherEndpoint = 1
	// Apigee Runtime endpoint.
	TetherEndpoint_APIGEE_RUNTIME TetherEndpoint = 2
	// Apigee Mint Rating endpoint.
	TetherEndpoint_APIGEE_MINT_RATING TetherEndpoint = 3
)

// Enum value maps for TetherEndpoint.
var (
	TetherEndpoint_name = map[int32]string{
		0: "TETHER_ENDPOINT_UNSPECIFIED",
		1: "APIGEE_MART",
		2: "APIGEE_RUNTIME",
		3: "APIGEE_MINT_RATING",
	}
	TetherEndpoint_value = map[string]int32{
		"TETHER_ENDPOINT_UNSPECIFIED": 0,
		"APIGEE_MART":                 1,
		"APIGEE_RUNTIME":              2,
		"APIGEE_MINT_RATING":          3,
	}
)

func (x TetherEndpoint) Enum() *TetherEndpoint {
	p := new(TetherEndpoint)
	*p = x
	return p
}

func (x TetherEndpoint) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TetherEndpoint) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_apigeeconnect_v1_tether_proto_enumTypes[1].Descriptor()
}

func (TetherEndpoint) Type() protoreflect.EnumType {
	return &file_google_cloud_apigeeconnect_v1_tether_proto_enumTypes[1]
}

func (x TetherEndpoint) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TetherEndpoint.Descriptor instead.
func (TetherEndpoint) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_apigeeconnect_v1_tether_proto_rawDescGZIP(), []int{1}
}

// HTTP Scheme.
type Scheme int32

const (
	// Unspecified scheme.
	Scheme_SCHEME_UNSPECIFIED Scheme = 0
	// HTTPS protocol.
	Scheme_HTTPS Scheme = 1
)

// Enum value maps for Scheme.
var (
	Scheme_name = map[int32]string{
		0: "SCHEME_UNSPECIFIED",
		1: "HTTPS",
	}
	Scheme_value = map[string]int32{
		"SCHEME_UNSPECIFIED": 0,
		"HTTPS":              1,
	}
)

func (x Scheme) Enum() *Scheme {
	p := new(Scheme)
	*p = x
	return p
}

func (x Scheme) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Scheme) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_apigeeconnect_v1_tether_proto_enumTypes[2].Descriptor()
}

func (Scheme) Type() protoreflect.EnumType {
	return &file_google_cloud_apigeeconnect_v1_tether_proto_enumTypes[2]
}

func (x Scheme) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Scheme.Descriptor instead.
func (Scheme) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_apigeeconnect_v1_tether_proto_rawDescGZIP(), []int{2}
}

// gRPC request payload for tether.
type EgressRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unique identifier for the request.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Actual payload to send to agent.
	Payload *Payload `protobuf:"bytes,2,opt,name=payload,proto3" json:"payload,omitempty"`
	// Tether Endpoint.
	Endpoint TetherEndpoint `protobuf:"varint,3,opt,name=endpoint,proto3,enum=google.cloud.apigeeconnect.v1.TetherEndpoint" json:"endpoint,omitempty"`
	// GCP Project.
	// Format: `projects/{project_number}`.
	Project string `protobuf:"bytes,4,opt,name=project,proto3" json:"project,omitempty"`
	// Unique identifier for clients to trace their request/response.
	TraceId string `protobuf:"bytes,5,opt,name=trace_id,json=traceId,proto3" json:"trace_id,omitempty"`
	// Timeout for the HTTP request.
	Timeout *durationpb.Duration `protobuf:"bytes,6,opt,name=timeout,proto3" json:"timeout,omitempty"`
}

func (x *EgressRequest) Reset() {
	*x = EgressRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_apigeeconnect_v1_tether_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EgressRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EgressRequest) ProtoMessage() {}

func (x *EgressRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apigeeconnect_v1_tether_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EgressRequest.ProtoReflect.Descriptor instead.
func (*EgressRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apigeeconnect_v1_tether_proto_rawDescGZIP(), []int{0}
}

func (x *EgressRequest) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *EgressRequest) GetPayload() *Payload {
	if x != nil {
		return x.Payload
	}
	return nil
}

func (x *EgressRequest) GetEndpoint() TetherEndpoint {
	if x != nil {
		return x.Endpoint
	}
	return TetherEndpoint_TETHER_ENDPOINT_UNSPECIFIED
}

func (x *EgressRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *EgressRequest) GetTraceId() string {
	if x != nil {
		return x.TraceId
	}
	return ""
}

func (x *EgressRequest) GetTimeout() *durationpb.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

// Payload for EgressRequest.
type Payload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The kind of payload.
	//
	// Types that are assignable to Kind:
	//
	//	*Payload_HttpRequest
	//	*Payload_StreamInfo
	//	*Payload_Action
	Kind isPayload_Kind `protobuf_oneof:"kind"`
}

func (x *Payload) Reset() {
	*x = Payload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_apigeeconnect_v1_tether_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Payload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Payload) ProtoMessage() {}

func (x *Payload) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apigeeconnect_v1_tether_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Payload.ProtoReflect.Descriptor instead.
func (*Payload) Descriptor() ([]byte, []int) {
	return file_google_cloud_apigeeconnect_v1_tether_proto_rawDescGZIP(), []int{1}
}

func (m *Payload) GetKind() isPayload_Kind {
	if m != nil {
		return m.Kind
	}
	return nil
}

func (x *Payload) GetHttpRequest() *HttpRequest {
	if x, ok := x.GetKind().(*Payload_HttpRequest); ok {
		return x.HttpRequest
	}
	return nil
}

func (x *Payload) GetStreamInfo() *StreamInfo {
	if x, ok := x.GetKind().(*Payload_StreamInfo); ok {
		return x.StreamInfo
	}
	return nil
}

func (x *Payload) GetAction() Action {
	if x, ok := x.GetKind().(*Payload_Action); ok {
		return x.Action
	}
	return Action_ACTION_UNSPECIFIED
}

type isPayload_Kind interface {
	isPayload_Kind()
}

type Payload_HttpRequest struct {
	// The HttpRequest proto.
	HttpRequest *HttpRequest `protobuf:"bytes,1,opt,name=http_request,json=httpRequest,proto3,oneof"`
}

type Payload_StreamInfo struct {
	// The information of stream.
	StreamInfo *StreamInfo `protobuf:"bytes,2,opt,name=stream_info,json=streamInfo,proto3,oneof"`
}

type Payload_Action struct {
	// The action taken by agent.
	Action Action `protobuf:"varint,3,opt,name=action,proto3,enum=google.cloud.apigeeconnect.v1.Action,oneof"`
}

func (*Payload_HttpRequest) isPayload_Kind() {}

func (*Payload_StreamInfo) isPayload_Kind() {}

func (*Payload_Action) isPayload_Kind() {}

// The Information of bi-directional stream.
type StreamInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unique identifier for the stream.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *StreamInfo) Reset() {
	*x = StreamInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_apigeeconnect_v1_tether_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamInfo) ProtoMessage() {}

func (x *StreamInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apigeeconnect_v1_tether_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamInfo.ProtoReflect.Descriptor instead.
func (*StreamInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_apigeeconnect_v1_tether_proto_rawDescGZIP(), []int{2}
}

func (x *StreamInfo) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

// gRPC response payload for tether.
type EgressResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unique identifier for the response. Matches the EgressRequest's id.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// HttpResponse.
	HttpResponse *HttpResponse `protobuf:"bytes,2,opt,name=http_response,json=httpResponse,proto3" json:"http_response,omitempty"`
	// Errors from application when handling the http request.
	Status *status.Status `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	// GCP Project.
	// Format: `projects/{project_number}`.
	Project string `protobuf:"bytes,4,opt,name=project,proto3" json:"project,omitempty"`
	// Unique identifier for clients to trace their request/response. Matches the
	// EgressRequest's trace id
	TraceId string `protobuf:"bytes,5,opt,name=trace_id,json=traceId,proto3" json:"trace_id,omitempty"`
	// Tether Endpoint.
	Endpoint TetherEndpoint `protobuf:"varint,6,opt,name=endpoint,proto3,enum=google.cloud.apigeeconnect.v1.TetherEndpoint" json:"endpoint,omitempty"`
	// Name is the full resource path of endpoint.
	// Format: `projects/{project_number or project_id}/endpoints/{endpoint}`
	Name string `protobuf:"bytes,7,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *EgressResponse) Reset() {
	*x = EgressResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_apigeeconnect_v1_tether_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EgressResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EgressResponse) ProtoMessage() {}

func (x *EgressResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apigeeconnect_v1_tether_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EgressResponse.ProtoReflect.Descriptor instead.
func (*EgressResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_apigeeconnect_v1_tether_proto_rawDescGZIP(), []int{3}
}

func (x *EgressResponse) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *EgressResponse) GetHttpResponse() *HttpResponse {
	if x != nil {
		return x.HttpResponse
	}
	return nil
}

func (x *EgressResponse) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *EgressResponse) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *EgressResponse) GetTraceId() string {
	if x != nil {
		return x.TraceId
	}
	return ""
}

func (x *EgressResponse) GetEndpoint() TetherEndpoint {
	if x != nil {
		return x.Endpoint
	}
	return TetherEndpoint_TETHER_ENDPOINT_UNSPECIFIED
}

func (x *EgressResponse) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The proto definition of http request.
type HttpRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique identifier for the request.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The HTTP request method.
	// Valid methods: "GET", "HEAD", "POST", "PUT", "PATCH","DELETE".
	Method string `protobuf:"bytes,2,opt,name=method,proto3" json:"method,omitempty"`
	// The HTTP request URL.
	Url *Url `protobuf:"bytes,3,opt,name=url,proto3" json:"url,omitempty"`
	// The HTTP request headers.
	Headers []*Header `protobuf:"bytes,4,rep,name=headers,proto3" json:"headers,omitempty"`
	// HTTP request body.
	Body []byte `protobuf:"bytes,5,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *HttpRequest) Reset() {
	*x = HttpRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_apigeeconnect_v1_tether_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HttpRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpRequest) ProtoMessage() {}

func (x *HttpRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apigeeconnect_v1_tether_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpRequest.ProtoReflect.Descriptor instead.
func (*HttpRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_apigeeconnect_v1_tether_proto_rawDescGZIP(), []int{4}
}

func (x *HttpRequest) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *HttpRequest) GetMethod() string {
	if x != nil {
		return x.Method
	}
	return ""
}

func (x *HttpRequest) GetUrl() *Url {
	if x != nil {
		return x.Url
	}
	return nil
}

func (x *HttpRequest) GetHeaders() []*Header {
	if x != nil {
		return x.Headers
	}
	return nil
}

func (x *HttpRequest) GetBody() []byte {
	if x != nil {
		return x.Body
	}
	return nil
}

// The proto definition of url.
// A url represents a URL and the general form represented is:
//
//	`[scheme://][google.cloud.apigeeconnect.v1.Url.host][path]`
type Url struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Scheme.
	Scheme Scheme `protobuf:"varint,1,opt,name=scheme,proto3,enum=google.cloud.apigeeconnect.v1.Scheme" json:"scheme,omitempty"`
	// Host or Host:Port.
	Host string `protobuf:"bytes,2,opt,name=host,proto3" json:"host,omitempty"`
	// Path starts with `/`.
	Path string `protobuf:"bytes,3,opt,name=path,proto3" json:"path,omitempty"`
}

func (x *Url) Reset() {
	*x = Url{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_apigeeconnect_v1_tether_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Url) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Url) ProtoMessage() {}

func (x *Url) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apigeeconnect_v1_tether_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Url.ProtoReflect.Descriptor instead.
func (*Url) Descriptor() ([]byte, []int) {
	return file_google_cloud_apigeeconnect_v1_tether_proto_rawDescGZIP(), []int{5}
}

func (x *Url) GetScheme() Scheme {
	if x != nil {
		return x.Scheme
	}
	return Scheme_SCHEME_UNSPECIFIED
}

func (x *Url) GetHost() string {
	if x != nil {
		return x.Host
	}
	return ""
}

func (x *Url) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

// The http headers.
type Header struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key    string   `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Values []string `protobuf:"bytes,2,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *Header) Reset() {
	*x = Header{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_apigeeconnect_v1_tether_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Header) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Header) ProtoMessage() {}

func (x *Header) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apigeeconnect_v1_tether_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Header.ProtoReflect.Descriptor instead.
func (*Header) Descriptor() ([]byte, []int) {
	return file_google_cloud_apigeeconnect_v1_tether_proto_rawDescGZIP(), []int{6}
}

func (x *Header) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *Header) GetValues() []string {
	if x != nil {
		return x.Values
	}
	return nil
}

// The proto definition of http response.
type HttpResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique identifier that matches the request ID.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Status of http response, e.g. "200 OK".
	Status string `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	// Status code of http response, e.g. 200.
	StatusCode int32 `protobuf:"varint,3,opt,name=status_code,json=statusCode,proto3" json:"status_code,omitempty"`
	// The HTTP 1.1 response body.
	Body []byte `protobuf:"bytes,4,opt,name=body,proto3" json:"body,omitempty"`
	// The HTTP response headers.
	Headers []*Header `protobuf:"bytes,5,rep,name=headers,proto3" json:"headers,omitempty"`
	// Content length records the length of the associated content. The
	// value -1 indicates that the length is unknown. Unless http method
	// is "HEAD", values >= 0 indicate that the given number of bytes may
	// be read from Body.
	ContentLength int64 `protobuf:"varint,6,opt,name=content_length,json=contentLength,proto3" json:"content_length,omitempty"`
}

func (x *HttpResponse) Reset() {
	*x = HttpResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_apigeeconnect_v1_tether_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HttpResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpResponse) ProtoMessage() {}

func (x *HttpResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_apigeeconnect_v1_tether_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpResponse.ProtoReflect.Descriptor instead.
func (*HttpResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_apigeeconnect_v1_tether_proto_rawDescGZIP(), []int{7}
}

func (x *HttpResponse) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *HttpResponse) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

func (x *HttpResponse) GetStatusCode() int32 {
	if x != nil {
		return x.StatusCode
	}
	return 0
}

func (x *HttpResponse) GetBody() []byte {
	if x != nil {
		return x.Body
	}
	return nil
}

func (x *HttpResponse) GetHeaders() []*Header {
	if x != nil {
		return x.Headers
	}
	return nil
}

func (x *HttpResponse) GetContentLength() int64 {
	if x != nil {
		return x.ContentLength
	}
	return 0
}

var File_google_cloud_apigeeconnect_v1_tether_proto protoreflect.FileDescriptor

var file_google_cloud_apigeeconnect_v1_tether_proto_rawDesc = []byte{
	0x0a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x70, 0x69, 0x67, 0x65, 0x65, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2f, 0x76, 0x31, 0x2f,
	0x74, 0x65, 0x74, 0x68, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x67, 0x65,
	0x65, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x1a, 0x1e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x96, 0x02,
	0x0a, 0x0d, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12,
	0x40, 0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x70, 0x69, 0x67, 0x65, 0x65, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x12, 0x49, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x67, 0x65, 0x65, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x74, 0x68, 0x65, 0x72, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x18, 0x0a, 0x07,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x72, 0x61, 0x63, 0x65, 0x5f,
	0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x74, 0x72, 0x61, 0x63, 0x65, 0x49,
	0x64, 0x12, 0x33, 0x0a, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x74,
	0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x22, 0xf1, 0x01, 0x0a, 0x07, 0x50, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x12, 0x4f, 0x0a, 0x0c, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x67, 0x65, 0x65, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0b, 0x68, 0x74, 0x74, 0x70, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x0b, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x69, 0x6e,
	0x66, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x67, 0x65, 0x65, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49,
	0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x0a, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x3f, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x70, 0x69, 0x67, 0x65, 0x65, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x06, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x22, 0x1c, 0x0a, 0x0a, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x22, 0xb2, 0x02, 0x0a, 0x0e, 0x45, 0x67, 0x72,
	0x65, 0x73, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x50, 0x0a, 0x0d, 0x68,
	0x74, 0x74, 0x70, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x70, 0x69, 0x67, 0x65, 0x65, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52,
	0x0c, 0x68, 0x74, 0x74, 0x70, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2a, 0x0a,
	0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x72, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x74, 0x72, 0x61, 0x63, 0x65, 0x49, 0x64, 0x12, 0x49,
	0x0a, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x70, 0x69, 0x67, 0x65, 0x65, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x65, 0x74, 0x68, 0x65, 0x72, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52,
	0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc0, 0x01,
	0x0a, 0x0b, 0x48, 0x74, 0x74, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x0e, 0x0a,
	0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x16, 0x0a,
	0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6d,
	0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x34, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x70, 0x69, 0x67, 0x65, 0x65, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x55, 0x72, 0x6c, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x12, 0x3f, 0x0a, 0x07, 0x68,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x67,
	0x65, 0x65, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x52, 0x07, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x12, 0x0a, 0x04,
	0x62, 0x6f, 0x64, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x62, 0x6f, 0x64, 0x79,
	0x22, 0x6c, 0x0a, 0x03, 0x55, 0x72, 0x6c, 0x12, 0x3d, 0x0a, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x67, 0x65, 0x65, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x65, 0x52, 0x06,
	0x73, 0x63, 0x68, 0x65, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x68, 0x6f, 0x73, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x68, 0x6f, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61,
	0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x22, 0x32,
	0x0a, 0x06, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x16, 0x0a, 0x06, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x22, 0xd3, 0x01, 0x0a, 0x0c, 0x48, 0x74, 0x74, 0x70, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x02, 0x69, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x62, 0x6f, 0x64, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x62, 0x6f, 0x64, 0x79,
	0x12, 0x3f, 0x0a, 0x07, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x70, 0x69, 0x67, 0x65, 0x65, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x07, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x73, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x65, 0x6e,
	0x67, 0x74, 0x68, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x2a, 0x35, 0x0a, 0x06, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x12, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x4f, 0x50,
	0x45, 0x4e, 0x5f, 0x4e, 0x45, 0x57, 0x5f, 0x53, 0x54, 0x52, 0x45, 0x41, 0x4d, 0x10, 0x01, 0x2a,
	0x6e, 0x0a, 0x0e, 0x54, 0x65, 0x74, 0x68, 0x65, 0x72, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x12, 0x1f, 0x0a, 0x1b, 0x54, 0x45, 0x54, 0x48, 0x45, 0x52, 0x5f, 0x45, 0x4e, 0x44, 0x50,
	0x4f, 0x49, 0x4e, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x41, 0x50, 0x49, 0x47, 0x45, 0x45, 0x5f, 0x4d, 0x41, 0x52,
	0x54, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x41, 0x50, 0x49, 0x47, 0x45, 0x45, 0x5f, 0x52, 0x55,
	0x4e, 0x54, 0x49, 0x4d, 0x45, 0x10, 0x02, 0x12, 0x16, 0x0a, 0x12, 0x41, 0x50, 0x49, 0x47, 0x45,
	0x45, 0x5f, 0x4d, 0x49, 0x4e, 0x54, 0x5f, 0x52, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x2a,
	0x2b, 0x0a, 0x06, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x43, 0x48,
	0x45, 0x4d, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x09, 0x0a, 0x05, 0x48, 0x54, 0x54, 0x50, 0x53, 0x10, 0x01, 0x32, 0xc7, 0x01, 0x0a,
	0x06, 0x54, 0x65, 0x74, 0x68, 0x65, 0x72, 0x12, 0x6b, 0x0a, 0x06, 0x45, 0x67, 0x72, 0x65, 0x73,
	0x73, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x70, 0x69, 0x67, 0x65, 0x65, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x70, 0x69, 0x67, 0x65, 0x65, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x00,
	0x28, 0x01, 0x30, 0x01, 0x1a, 0x50, 0xca, 0x41, 0x1c, 0x61, 0x70, 0x69, 0x67, 0x65, 0x65, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f,
	0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xde, 0x01, 0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x70, 0x69, 0x67,
	0x65, 0x65, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x76, 0x31, 0x42, 0x0b, 0x54, 0x65,
	0x74, 0x68, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x47, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f,
	0x2f, 0x61, 0x70, 0x69, 0x67, 0x65, 0x65, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2f, 0x61,
	0x70, 0x69, 0x76, 0x31, 0x2f, 0x61, 0x70, 0x69, 0x67, 0x65, 0x65, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x70, 0x62, 0x3b, 0x61, 0x70, 0x69, 0x67, 0x65, 0x65, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x70, 0x62, 0xaa, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x41, 0x70, 0x69, 0x67, 0x65, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x5c, 0x41, 0x70, 0x69, 0x67, 0x65, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x70, 0x69, 0x67, 0x65, 0x65, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_apigeeconnect_v1_tether_proto_rawDescOnce sync.Once
	file_google_cloud_apigeeconnect_v1_tether_proto_rawDescData = file_google_cloud_apigeeconnect_v1_tether_proto_rawDesc
)

func file_google_cloud_apigeeconnect_v1_tether_proto_rawDescGZIP() []byte {
	file_google_cloud_apigeeconnect_v1_tether_proto_rawDescOnce.Do(func() {
		file_google_cloud_apigeeconnect_v1_tether_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_apigeeconnect_v1_tether_proto_rawDescData)
	})
	return file_google_cloud_apigeeconnect_v1_tether_proto_rawDescData
}

var file_google_cloud_apigeeconnect_v1_tether_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_apigeeconnect_v1_tether_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_cloud_apigeeconnect_v1_tether_proto_goTypes = []any{
	(Action)(0),                 // 0: google.cloud.apigeeconnect.v1.Action
	(TetherEndpoint)(0),         // 1: google.cloud.apigeeconnect.v1.TetherEndpoint
	(Scheme)(0),                 // 2: google.cloud.apigeeconnect.v1.Scheme
	(*EgressRequest)(nil),       // 3: google.cloud.apigeeconnect.v1.EgressRequest
	(*Payload)(nil),             // 4: google.cloud.apigeeconnect.v1.Payload
	(*StreamInfo)(nil),          // 5: google.cloud.apigeeconnect.v1.StreamInfo
	(*EgressResponse)(nil),      // 6: google.cloud.apigeeconnect.v1.EgressResponse
	(*HttpRequest)(nil),         // 7: google.cloud.apigeeconnect.v1.HttpRequest
	(*Url)(nil),                 // 8: google.cloud.apigeeconnect.v1.Url
	(*Header)(nil),              // 9: google.cloud.apigeeconnect.v1.Header
	(*HttpResponse)(nil),        // 10: google.cloud.apigeeconnect.v1.HttpResponse
	(*durationpb.Duration)(nil), // 11: google.protobuf.Duration
	(*status.Status)(nil),       // 12: google.rpc.Status
}
var file_google_cloud_apigeeconnect_v1_tether_proto_depIdxs = []int32{
	4,  // 0: google.cloud.apigeeconnect.v1.EgressRequest.payload:type_name -> google.cloud.apigeeconnect.v1.Payload
	1,  // 1: google.cloud.apigeeconnect.v1.EgressRequest.endpoint:type_name -> google.cloud.apigeeconnect.v1.TetherEndpoint
	11, // 2: google.cloud.apigeeconnect.v1.EgressRequest.timeout:type_name -> google.protobuf.Duration
	7,  // 3: google.cloud.apigeeconnect.v1.Payload.http_request:type_name -> google.cloud.apigeeconnect.v1.HttpRequest
	5,  // 4: google.cloud.apigeeconnect.v1.Payload.stream_info:type_name -> google.cloud.apigeeconnect.v1.StreamInfo
	0,  // 5: google.cloud.apigeeconnect.v1.Payload.action:type_name -> google.cloud.apigeeconnect.v1.Action
	10, // 6: google.cloud.apigeeconnect.v1.EgressResponse.http_response:type_name -> google.cloud.apigeeconnect.v1.HttpResponse
	12, // 7: google.cloud.apigeeconnect.v1.EgressResponse.status:type_name -> google.rpc.Status
	1,  // 8: google.cloud.apigeeconnect.v1.EgressResponse.endpoint:type_name -> google.cloud.apigeeconnect.v1.TetherEndpoint
	8,  // 9: google.cloud.apigeeconnect.v1.HttpRequest.url:type_name -> google.cloud.apigeeconnect.v1.Url
	9,  // 10: google.cloud.apigeeconnect.v1.HttpRequest.headers:type_name -> google.cloud.apigeeconnect.v1.Header
	2,  // 11: google.cloud.apigeeconnect.v1.Url.scheme:type_name -> google.cloud.apigeeconnect.v1.Scheme
	9,  // 12: google.cloud.apigeeconnect.v1.HttpResponse.headers:type_name -> google.cloud.apigeeconnect.v1.Header
	6,  // 13: google.cloud.apigeeconnect.v1.Tether.Egress:input_type -> google.cloud.apigeeconnect.v1.EgressResponse
	3,  // 14: google.cloud.apigeeconnect.v1.Tether.Egress:output_type -> google.cloud.apigeeconnect.v1.EgressRequest
	14, // [14:15] is the sub-list for method output_type
	13, // [13:14] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_google_cloud_apigeeconnect_v1_tether_proto_init() }
func file_google_cloud_apigeeconnect_v1_tether_proto_init() {
	if File_google_cloud_apigeeconnect_v1_tether_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_apigeeconnect_v1_tether_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*EgressRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_apigeeconnect_v1_tether_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*Payload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_apigeeconnect_v1_tether_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*StreamInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_apigeeconnect_v1_tether_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*EgressResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_apigeeconnect_v1_tether_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*HttpRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_apigeeconnect_v1_tether_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*Url); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_apigeeconnect_v1_tether_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*Header); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_apigeeconnect_v1_tether_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*HttpResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_apigeeconnect_v1_tether_proto_msgTypes[1].OneofWrappers = []any{
		(*Payload_HttpRequest)(nil),
		(*Payload_StreamInfo)(nil),
		(*Payload_Action)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_apigeeconnect_v1_tether_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_apigeeconnect_v1_tether_proto_goTypes,
		DependencyIndexes: file_google_cloud_apigeeconnect_v1_tether_proto_depIdxs,
		EnumInfos:         file_google_cloud_apigeeconnect_v1_tether_proto_enumTypes,
		MessageInfos:      file_google_cloud_apigeeconnect_v1_tether_proto_msgTypes,
	}.Build()
	File_google_cloud_apigeeconnect_v1_tether_proto = out.File
	file_google_cloud_apigeeconnect_v1_tether_proto_rawDesc = nil
	file_google_cloud_apigeeconnect_v1_tether_proto_goTypes = nil
	file_google_cloud_apigeeconnect_v1_tether_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// TetherClient is the client API for Tether service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type TetherClient interface {
	// Egress streams egress requests and responses. Logically, this is not
	// actually a streaming request, but uses streaming as a mechanism to flip
	// the client-server relationship of gRPC so that the server can act as a
	// client.
	// The listener, the RPC server, accepts connections from the dialer,
	// the RPC client.
	// The listener streams http requests and the dialer streams http responses.
	Egress(ctx context.Context, opts ...grpc.CallOption) (Tether_EgressClient, error)
}

type tetherClient struct {
	cc grpc.ClientConnInterface
}

func NewTetherClient(cc grpc.ClientConnInterface) TetherClient {
	return &tetherClient{cc}
}

func (c *tetherClient) Egress(ctx context.Context, opts ...grpc.CallOption) (Tether_EgressClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Tether_serviceDesc.Streams[0], "/google.cloud.apigeeconnect.v1.Tether/Egress", opts...)
	if err != nil {
		return nil, err
	}
	x := &tetherEgressClient{stream}
	return x, nil
}

type Tether_EgressClient interface {
	Send(*EgressResponse) error
	Recv() (*EgressRequest, error)
	grpc.ClientStream
}

type tetherEgressClient struct {
	grpc.ClientStream
}

func (x *tetherEgressClient) Send(m *EgressResponse) error {
	return x.ClientStream.SendMsg(m)
}

func (x *tetherEgressClient) Recv() (*EgressRequest, error) {
	m := new(EgressRequest)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// TetherServer is the server API for Tether service.
type TetherServer interface {
	// Egress streams egress requests and responses. Logically, this is not
	// actually a streaming request, but uses streaming as a mechanism to flip
	// the client-server relationship of gRPC so that the server can act as a
	// client.
	// The listener, the RPC server, accepts connections from the dialer,
	// the RPC client.
	// The listener streams http requests and the dialer streams http responses.
	Egress(Tether_EgressServer) error
}

// UnimplementedTetherServer can be embedded to have forward compatible implementations.
type UnimplementedTetherServer struct {
}

func (*UnimplementedTetherServer) Egress(Tether_EgressServer) error {
	return status1.Errorf(codes.Unimplemented, "method Egress not implemented")
}

func RegisterTetherServer(s *grpc.Server, srv TetherServer) {
	s.RegisterService(&_Tether_serviceDesc, srv)
}

func _Tether_Egress_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(TetherServer).Egress(&tetherEgressServer{stream})
}

type Tether_EgressServer interface {
	Send(*EgressRequest) error
	Recv() (*EgressResponse, error)
	grpc.ServerStream
}

type tetherEgressServer struct {
	grpc.ServerStream
}

func (x *tetherEgressServer) Send(m *EgressRequest) error {
	return x.ServerStream.SendMsg(m)
}

func (x *tetherEgressServer) Recv() (*EgressResponse, error) {
	m := new(EgressResponse)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _Tether_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.apigeeconnect.v1.Tether",
	HandlerType: (*TetherServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Egress",
			Handler:       _Tether_Egress_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/cloud/apigeeconnect/v1/tether.proto",
}
