// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v4.23.2
// source: google/devtools/cloudbuild/v2/repositories.proto

package cloudbuildpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	httpbody "google.golang.org/genproto/googleapis/api/httpbody"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Stage of the installation process.
type InstallationState_Stage int32

const (
	// No stage specified.
	InstallationState_STAGE_UNSPECIFIED InstallationState_Stage = 0
	// Only for GitHub Enterprise. An App creation has been requested.
	// The user needs to confirm the creation in their GitHub enterprise host.
	InstallationState_PENDING_CREATE_APP InstallationState_Stage = 1
	// User needs to authorize the GitHub (or Enterprise) App via OAuth.
	InstallationState_PENDING_USER_OAUTH InstallationState_Stage = 2
	// User needs to follow the link to install the GitHub (or Enterprise) App.
	InstallationState_PENDING_INSTALL_APP InstallationState_Stage = 3
	// Installation process has been completed.
	InstallationState_COMPLETE InstallationState_Stage = 10
)

// Enum value maps for InstallationState_Stage.
var (
	InstallationState_Stage_name = map[int32]string{
		0:  "STAGE_UNSPECIFIED",
		1:  "PENDING_CREATE_APP",
		2:  "PENDING_USER_OAUTH",
		3:  "PENDING_INSTALL_APP",
		10: "COMPLETE",
	}
	InstallationState_Stage_value = map[string]int32{
		"STAGE_UNSPECIFIED":   0,
		"PENDING_CREATE_APP":  1,
		"PENDING_USER_OAUTH":  2,
		"PENDING_INSTALL_APP": 3,
		"COMPLETE":            10,
	}
)

func (x InstallationState_Stage) Enum() *InstallationState_Stage {
	p := new(InstallationState_Stage)
	*p = x
	return p
}

func (x InstallationState_Stage) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstallationState_Stage) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_cloudbuild_v2_repositories_proto_enumTypes[0].Descriptor()
}

func (InstallationState_Stage) Type() protoreflect.EnumType {
	return &file_google_devtools_cloudbuild_v2_repositories_proto_enumTypes[0]
}

func (x InstallationState_Stage) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstallationState_Stage.Descriptor instead.
func (InstallationState_Stage) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v2_repositories_proto_rawDescGZIP(), []int{1, 0}
}

// Type of refs
type FetchGitRefsRequest_RefType int32

const (
	// No type specified.
	FetchGitRefsRequest_REF_TYPE_UNSPECIFIED FetchGitRefsRequest_RefType = 0
	// To fetch tags.
	FetchGitRefsRequest_TAG FetchGitRefsRequest_RefType = 1
	// To fetch branches.
	FetchGitRefsRequest_BRANCH FetchGitRefsRequest_RefType = 2
)

// Enum value maps for FetchGitRefsRequest_RefType.
var (
	FetchGitRefsRequest_RefType_name = map[int32]string{
		0: "REF_TYPE_UNSPECIFIED",
		1: "TAG",
		2: "BRANCH",
	}
	FetchGitRefsRequest_RefType_value = map[string]int32{
		"REF_TYPE_UNSPECIFIED": 0,
		"TAG":                  1,
		"BRANCH":               2,
	}
)

func (x FetchGitRefsRequest_RefType) Enum() *FetchGitRefsRequest_RefType {
	p := new(FetchGitRefsRequest_RefType)
	*p = x
	return p
}

func (x FetchGitRefsRequest_RefType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FetchGitRefsRequest_RefType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_cloudbuild_v2_repositories_proto_enumTypes[1].Descriptor()
}

func (FetchGitRefsRequest_RefType) Type() protoreflect.EnumType {
	return &file_google_devtools_cloudbuild_v2_repositories_proto_enumTypes[1]
}

func (x FetchGitRefsRequest_RefType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FetchGitRefsRequest_RefType.Descriptor instead.
func (FetchGitRefsRequest_RefType) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v2_repositories_proto_rawDescGZIP(), []int{29, 0}
}

// A connection to a SCM like GitHub, GitHub Enterprise, Bitbucket Server or
// GitLab.
type Connection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The resource name of the connection, in the format
	// `projects/{project}/locations/{location}/connections/{connection_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Server assigned timestamp for when the connection was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Server assigned timestamp for when the connection was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Configuration for the connection depending on the type of provider.
	//
	// Types that are assignable to ConnectionConfig:
	//	*Connection_GithubConfig
	//	*Connection_GithubEnterpriseConfig
	//	*Connection_GitlabConfig
	ConnectionConfig isConnection_ConnectionConfig `protobuf_oneof:"connection_config"`
	// Output only. Installation state of the Connection.
	InstallationState *InstallationState `protobuf:"bytes,12,opt,name=installation_state,json=installationState,proto3" json:"installation_state,omitempty"`
	// If disabled is set to true, functionality is disabled for this connection.
	// Repository based API methods and webhooks processing for repositories in
	// this connection will be disabled.
	Disabled bool `protobuf:"varint,13,opt,name=disabled,proto3" json:"disabled,omitempty"`
	// Output only. Set to true when the connection is being set up or updated in
	// the background.
	Reconciling bool `protobuf:"varint,14,opt,name=reconciling,proto3" json:"reconciling,omitempty"`
	// Allows clients to store small amounts of arbitrary data.
	Annotations map[string]string `protobuf:"bytes,15,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// This checksum is computed by the server based on the value of other
	// fields, and may be sent on update and delete requests to ensure the
	// client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,16,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *Connection) Reset() {
	*x = Connection{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Connection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Connection) ProtoMessage() {}

func (x *Connection) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Connection.ProtoReflect.Descriptor instead.
func (*Connection) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v2_repositories_proto_rawDescGZIP(), []int{0}
}

func (x *Connection) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Connection) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Connection) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (m *Connection) GetConnectionConfig() isConnection_ConnectionConfig {
	if m != nil {
		return m.ConnectionConfig
	}
	return nil
}

func (x *Connection) GetGithubConfig() *GitHubConfig {
	if x, ok := x.GetConnectionConfig().(*Connection_GithubConfig); ok {
		return x.GithubConfig
	}
	return nil
}

func (x *Connection) GetGithubEnterpriseConfig() *GitHubEnterpriseConfig {
	if x, ok := x.GetConnectionConfig().(*Connection_GithubEnterpriseConfig); ok {
		return x.GithubEnterpriseConfig
	}
	return nil
}

func (x *Connection) GetGitlabConfig() *GitLabConfig {
	if x, ok := x.GetConnectionConfig().(*Connection_GitlabConfig); ok {
		return x.GitlabConfig
	}
	return nil
}

func (x *Connection) GetInstallationState() *InstallationState {
	if x != nil {
		return x.InstallationState
	}
	return nil
}

func (x *Connection) GetDisabled() bool {
	if x != nil {
		return x.Disabled
	}
	return false
}

func (x *Connection) GetReconciling() bool {
	if x != nil {
		return x.Reconciling
	}
	return false
}

func (x *Connection) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *Connection) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

type isConnection_ConnectionConfig interface {
	isConnection_ConnectionConfig()
}

type Connection_GithubConfig struct {
	// Configuration for connections to github.com.
	GithubConfig *GitHubConfig `protobuf:"bytes,5,opt,name=github_config,json=githubConfig,proto3,oneof"`
}

type Connection_GithubEnterpriseConfig struct {
	// Configuration for connections to an instance of GitHub Enterprise.
	GithubEnterpriseConfig *GitHubEnterpriseConfig `protobuf:"bytes,6,opt,name=github_enterprise_config,json=githubEnterpriseConfig,proto3,oneof"`
}

type Connection_GitlabConfig struct {
	// Configuration for connections to gitlab.com or an instance of GitLab
	// Enterprise.
	GitlabConfig *GitLabConfig `protobuf:"bytes,7,opt,name=gitlab_config,json=gitlabConfig,proto3,oneof"`
}

func (*Connection_GithubConfig) isConnection_ConnectionConfig() {}

func (*Connection_GithubEnterpriseConfig) isConnection_ConnectionConfig() {}

func (*Connection_GitlabConfig) isConnection_ConnectionConfig() {}

// Describes stage and necessary actions to be taken by the
// user to complete the installation. Used for GitHub and GitHub Enterprise
// based connections.
type InstallationState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Current step of the installation process.
	Stage InstallationState_Stage `protobuf:"varint,1,opt,name=stage,proto3,enum=google.devtools.cloudbuild.v2.InstallationState_Stage" json:"stage,omitempty"`
	// Output only. Message of what the user should do next to continue the
	// installation. Empty string if the installation is already complete.
	Message string `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	// Output only. Link to follow for next action. Empty string if the
	// installation is already complete.
	ActionUri string `protobuf:"bytes,3,opt,name=action_uri,json=actionUri,proto3" json:"action_uri,omitempty"`
}

func (x *InstallationState) Reset() {
	*x = InstallationState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstallationState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstallationState) ProtoMessage() {}

func (x *InstallationState) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstallationState.ProtoReflect.Descriptor instead.
func (*InstallationState) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v2_repositories_proto_rawDescGZIP(), []int{1}
}

func (x *InstallationState) GetStage() InstallationState_Stage {
	if x != nil {
		return x.Stage
	}
	return InstallationState_STAGE_UNSPECIFIED
}

func (x *InstallationState) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *InstallationState) GetActionUri() string {
	if x != nil {
		return x.ActionUri
	}
	return ""
}

// Request message for FetchLinkableRepositories.
type FetchLinkableRepositoriesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Connection.
	// Format: `projects/*/locations/*/connections/*`.
	Connection string `protobuf:"bytes,1,opt,name=connection,proto3" json:"connection,omitempty"`
	// Number of results to return in the list. Default to 20.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page start.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *FetchLinkableRepositoriesRequest) Reset() {
	*x = FetchLinkableRepositoriesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchLinkableRepositoriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchLinkableRepositoriesRequest) ProtoMessage() {}

func (x *FetchLinkableRepositoriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchLinkableRepositoriesRequest.ProtoReflect.Descriptor instead.
func (*FetchLinkableRepositoriesRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v2_repositories_proto_rawDescGZIP(), []int{2}
}

func (x *FetchLinkableRepositoriesRequest) GetConnection() string {
	if x != nil {
		return x.Connection
	}
	return ""
}

func (x *FetchLinkableRepositoriesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *FetchLinkableRepositoriesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for FetchLinkableRepositories.
type FetchLinkableRepositoriesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// repositories ready to be created.
	Repositories []*Repository `protobuf:"bytes,1,rep,name=repositories,proto3" json:"repositories,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *FetchLinkableRepositoriesResponse) Reset() {
	*x = FetchLinkableRepositoriesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchLinkableRepositoriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchLinkableRepositoriesResponse) ProtoMessage() {}

func (x *FetchLinkableRepositoriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchLinkableRepositoriesResponse.ProtoReflect.Descriptor instead.
func (*FetchLinkableRepositoriesResponse) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v2_repositories_proto_rawDescGZIP(), []int{3}
}

func (x *FetchLinkableRepositoriesResponse) GetRepositories() []*Repository {
	if x != nil {
		return x.Repositories
	}
	return nil
}

func (x *FetchLinkableRepositoriesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Configuration for connections to github.com.
type GitHubConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// OAuth credential of the account that authorized the Cloud Build GitHub App.
	// It is recommended to use a robot account instead of a human user account.
	// The OAuth token must be tied to the Cloud Build GitHub App.
	AuthorizerCredential *OAuthCredential `protobuf:"bytes,1,opt,name=authorizer_credential,json=authorizerCredential,proto3" json:"authorizer_credential,omitempty"`
	// GitHub App installation id.
	AppInstallationId int64 `protobuf:"varint,2,opt,name=app_installation_id,json=appInstallationId,proto3" json:"app_installation_id,omitempty"`
}

func (x *GitHubConfig) Reset() {
	*x = GitHubConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GitHubConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GitHubConfig) ProtoMessage() {}

func (x *GitHubConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GitHubConfig.ProtoReflect.Descriptor instead.
func (*GitHubConfig) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v2_repositories_proto_rawDescGZIP(), []int{4}
}

func (x *GitHubConfig) GetAuthorizerCredential() *OAuthCredential {
	if x != nil {
		return x.AuthorizerCredential
	}
	return nil
}

func (x *GitHubConfig) GetAppInstallationId() int64 {
	if x != nil {
		return x.AppInstallationId
	}
	return 0
}

// Configuration for connections to an instance of GitHub Enterprise.
type GitHubEnterpriseConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The URI of the GitHub Enterprise host this connection is for.
	HostUri string `protobuf:"bytes,1,opt,name=host_uri,json=hostUri,proto3" json:"host_uri,omitempty"`
	// Required. API Key used for authentication of webhook events.
	ApiKey string `protobuf:"bytes,12,opt,name=api_key,json=apiKey,proto3" json:"api_key,omitempty"`
	// Id of the GitHub App created from the manifest.
	AppId int64 `protobuf:"varint,2,opt,name=app_id,json=appId,proto3" json:"app_id,omitempty"`
	// The URL-friendly name of the GitHub App.
	AppSlug string `protobuf:"bytes,13,opt,name=app_slug,json=appSlug,proto3" json:"app_slug,omitempty"`
	// SecretManager resource containing the private key of the GitHub App,
	// formatted as `projects/*/secrets/*/versions/*`.
	PrivateKeySecretVersion string `protobuf:"bytes,4,opt,name=private_key_secret_version,json=privateKeySecretVersion,proto3" json:"private_key_secret_version,omitempty"`
	// SecretManager resource containing the webhook secret of the GitHub App,
	// formatted as `projects/*/secrets/*/versions/*`.
	WebhookSecretSecretVersion string `protobuf:"bytes,5,opt,name=webhook_secret_secret_version,json=webhookSecretSecretVersion,proto3" json:"webhook_secret_secret_version,omitempty"`
	// ID of the installation of the GitHub App.
	AppInstallationId int64 `protobuf:"varint,9,opt,name=app_installation_id,json=appInstallationId,proto3" json:"app_installation_id,omitempty"`
	// Configuration for using Service Directory to privately connect to a GitHub
	// Enterprise server. This should only be set if the GitHub Enterprise server
	// is hosted on-premises and not reachable by public internet. If this field
	// is left empty, calls to the GitHub Enterprise server will be made over the
	// public internet.
	ServiceDirectoryConfig *ServiceDirectoryConfig `protobuf:"bytes,10,opt,name=service_directory_config,json=serviceDirectoryConfig,proto3" json:"service_directory_config,omitempty"`
	// SSL certificate to use for requests to GitHub Enterprise.
	SslCa string `protobuf:"bytes,11,opt,name=ssl_ca,json=sslCa,proto3" json:"ssl_ca,omitempty"`
	// Output only. GitHub Enterprise version installed at the host_uri.
	ServerVersion string `protobuf:"bytes,14,opt,name=server_version,json=serverVersion,proto3" json:"server_version,omitempty"`
}

func (x *GitHubEnterpriseConfig) Reset() {
	*x = GitHubEnterpriseConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GitHubEnterpriseConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GitHubEnterpriseConfig) ProtoMessage() {}

func (x *GitHubEnterpriseConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GitHubEnterpriseConfig.ProtoReflect.Descriptor instead.
func (*GitHubEnterpriseConfig) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v2_repositories_proto_rawDescGZIP(), []int{5}
}

func (x *GitHubEnterpriseConfig) GetHostUri() string {
	if x != nil {
		return x.HostUri
	}
	return ""
}

func (x *GitHubEnterpriseConfig) GetApiKey() string {
	if x != nil {
		return x.ApiKey
	}
	return ""
}

func (x *GitHubEnterpriseConfig) GetAppId() int64 {
	if x != nil {
		return x.AppId
	}
	return 0
}

func (x *GitHubEnterpriseConfig) GetAppSlug() string {
	if x != nil {
		return x.AppSlug
	}
	return ""
}

func (x *GitHubEnterpriseConfig) GetPrivateKeySecretVersion() string {
	if x != nil {
		return x.PrivateKeySecretVersion
	}
	return ""
}

func (x *GitHubEnterpriseConfig) GetWebhookSecretSecretVersion() string {
	if x != nil {
		return x.WebhookSecretSecretVersion
	}
	return ""
}

func (x *GitHubEnterpriseConfig) GetAppInstallationId() int64 {
	if x != nil {
		return x.AppInstallationId
	}
	return 0
}

func (x *GitHubEnterpriseConfig) GetServiceDirectoryConfig() *ServiceDirectoryConfig {
	if x != nil {
		return x.ServiceDirectoryConfig
	}
	return nil
}

func (x *GitHubEnterpriseConfig) GetSslCa() string {
	if x != nil {
		return x.SslCa
	}
	return ""
}

func (x *GitHubEnterpriseConfig) GetServerVersion() string {
	if x != nil {
		return x.ServerVersion
	}
	return ""
}

// Configuration for connections to gitlab.com or an instance of GitLab
// Enterprise.
type GitLabConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The URI of the GitLab Enterprise host this connection is for.
	// If not specified, the default value is https://gitlab.com.
	HostUri string `protobuf:"bytes,1,opt,name=host_uri,json=hostUri,proto3" json:"host_uri,omitempty"`
	// Required. Immutable. SecretManager resource containing the webhook secret
	// of a GitLab Enterprise project, formatted as
	// `projects/*/secrets/*/versions/*`.
	WebhookSecretSecretVersion string `protobuf:"bytes,2,opt,name=webhook_secret_secret_version,json=webhookSecretSecretVersion,proto3" json:"webhook_secret_secret_version,omitempty"`
	// Required. A GitLab personal access token with the minimum `read_api` scope
	// access.
	ReadAuthorizerCredential *UserCredential `protobuf:"bytes,3,opt,name=read_authorizer_credential,json=readAuthorizerCredential,proto3" json:"read_authorizer_credential,omitempty"`
	// Required. A GitLab personal access token with the `api` scope access.
	AuthorizerCredential *UserCredential `protobuf:"bytes,4,opt,name=authorizer_credential,json=authorizerCredential,proto3" json:"authorizer_credential,omitempty"`
	// Configuration for using Service Directory to privately connect to a GitLab
	// Enterprise server. This should only be set if the GitLab Enterprise server
	// is hosted on-premises and not reachable by public internet. If this field
	// is left empty, calls to the GitLab Enterprise server will be made over the
	// public internet.
	ServiceDirectoryConfig *ServiceDirectoryConfig `protobuf:"bytes,5,opt,name=service_directory_config,json=serviceDirectoryConfig,proto3" json:"service_directory_config,omitempty"`
	// SSL certificate to use for requests to GitLab Enterprise.
	SslCa string `protobuf:"bytes,6,opt,name=ssl_ca,json=sslCa,proto3" json:"ssl_ca,omitempty"`
	// Output only. Version of the GitLab Enterprise server running on the
	// `host_uri`.
	ServerVersion string `protobuf:"bytes,7,opt,name=server_version,json=serverVersion,proto3" json:"server_version,omitempty"`
}

func (x *GitLabConfig) Reset() {
	*x = GitLabConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GitLabConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GitLabConfig) ProtoMessage() {}

func (x *GitLabConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GitLabConfig.ProtoReflect.Descriptor instead.
func (*GitLabConfig) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v2_repositories_proto_rawDescGZIP(), []int{6}
}

func (x *GitLabConfig) GetHostUri() string {
	if x != nil {
		return x.HostUri
	}
	return ""
}

func (x *GitLabConfig) GetWebhookSecretSecretVersion() string {
	if x != nil {
		return x.WebhookSecretSecretVersion
	}
	return ""
}

func (x *GitLabConfig) GetReadAuthorizerCredential() *UserCredential {
	if x != nil {
		return x.ReadAuthorizerCredential
	}
	return nil
}

func (x *GitLabConfig) GetAuthorizerCredential() *UserCredential {
	if x != nil {
		return x.AuthorizerCredential
	}
	return nil
}

func (x *GitLabConfig) GetServiceDirectoryConfig() *ServiceDirectoryConfig {
	if x != nil {
		return x.ServiceDirectoryConfig
	}
	return nil
}

func (x *GitLabConfig) GetSslCa() string {
	if x != nil {
		return x.SslCa
	}
	return ""
}

func (x *GitLabConfig) GetServerVersion() string {
	if x != nil {
		return x.ServerVersion
	}
	return ""
}

// ServiceDirectoryConfig represents Service Directory configuration for a
// connection.
type ServiceDirectoryConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Service Directory service name.
	// Format:
	// projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}.
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
}

func (x *ServiceDirectoryConfig) Reset() {
	*x = ServiceDirectoryConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServiceDirectoryConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceDirectoryConfig) ProtoMessage() {}

func (x *ServiceDirectoryConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceDirectoryConfig.ProtoReflect.Descriptor instead.
func (*ServiceDirectoryConfig) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v2_repositories_proto_rawDescGZIP(), []int{7}
}

func (x *ServiceDirectoryConfig) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

// A repository associated to a parent connection.
type Repository struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. Resource name of the repository, in the format
	// `projects/*/locations/*/connections/*/repositories/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Git Clone HTTPS URI.
	RemoteUri string `protobuf:"bytes,2,opt,name=remote_uri,json=remoteUri,proto3" json:"remote_uri,omitempty"`
	// Output only. Server assigned timestamp for when the connection was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Server assigned timestamp for when the connection was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Allows clients to store small amounts of arbitrary data.
	Annotations map[string]string `protobuf:"bytes,6,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// This checksum is computed by the server based on the value of other
	// fields, and may be sent on update and delete requests to ensure the
	// client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,7,opt,name=etag,proto3" json:"etag,omitempty"`
	// Output only. External ID of the webhook created for the repository.
	WebhookId string `protobuf:"bytes,8,opt,name=webhook_id,json=webhookId,proto3" json:"webhook_id,omitempty"`
}

func (x *Repository) Reset() {
	*x = Repository{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Repository) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Repository) ProtoMessage() {}

func (x *Repository) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Repository.ProtoReflect.Descriptor instead.
func (*Repository) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v2_repositories_proto_rawDescGZIP(), []int{8}
}

func (x *Repository) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Repository) GetRemoteUri() string {
	if x != nil {
		return x.RemoteUri
	}
	return ""
}

func (x *Repository) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Repository) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Repository) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *Repository) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *Repository) GetWebhookId() string {
	if x != nil {
		return x.WebhookId
	}
	return ""
}

// Represents an OAuth token of the account that authorized the Connection,
// and associated metadata.
type OAuthCredential struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A SecretManager resource containing the OAuth token that authorizes
	// the Cloud Build connection. Format: `projects/*/secrets/*/versions/*`.
	OauthTokenSecretVersion string `protobuf:"bytes,1,opt,name=oauth_token_secret_version,json=oauthTokenSecretVersion,proto3" json:"oauth_token_secret_version,omitempty"`
	// Output only. The username associated to this token.
	Username string `protobuf:"bytes,2,opt,name=username,proto3" json:"username,omitempty"`
}

func (x *OAuthCredential) Reset() {
	*x = OAuthCredential{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OAuthCredential) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OAuthCredential) ProtoMessage() {}

func (x *OAuthCredential) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OAuthCredential.ProtoReflect.Descriptor instead.
func (*OAuthCredential) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v2_repositories_proto_rawDescGZIP(), []int{9}
}

func (x *OAuthCredential) GetOauthTokenSecretVersion() string {
	if x != nil {
		return x.OauthTokenSecretVersion
	}
	return ""
}

func (x *OAuthCredential) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

// Represents a personal access token that authorized the Connection,
// and associated metadata.
type UserCredential struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A SecretManager resource containing the user token that
	// authorizes the Cloud Build connection. Format:
	// `projects/*/secrets/*/versions/*`.
	UserTokenSecretVersion string `protobuf:"bytes,1,opt,name=user_token_secret_version,json=userTokenSecretVersion,proto3" json:"user_token_secret_version,omitempty"`
	// Output only. The username associated to this token.
	Username string `protobuf:"bytes,2,opt,name=username,proto3" json:"username,omitempty"`
}

func (x *UserCredential) Reset() {
	*x = UserCredential{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserCredential) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserCredential) ProtoMessage() {}

func (x *UserCredential) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserCredential.ProtoReflect.Descriptor instead.
func (*UserCredential) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v2_repositories_proto_rawDescGZIP(), []int{10}
}

func (x *UserCredential) GetUserTokenSecretVersion() string {
	if x != nil {
		return x.UserTokenSecretVersion
	}
	return ""
}

func (x *UserCredential) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

// Message for creating a Connection
type CreateConnectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Project and location where the connection will be created.
	// Format: `projects/*/locations/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The Connection to create.
	Connection *Connection `protobuf:"bytes,2,opt,name=connection,proto3" json:"connection,omitempty"`
	// Required. The ID to use for the Connection, which will become the final
	// component of the Connection's resource name. Names must be unique
	// per-project per-location. Allows alphanumeric characters and any of
	// -._~%!$&'()*+,;=@.
	ConnectionId string `protobuf:"bytes,3,opt,name=connection_id,json=connectionId,proto3" json:"connection_id,omitempty"`
}

func (x *CreateConnectionRequest) Reset() {
	*x = CreateConnectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateConnectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateConnectionRequest) ProtoMessage() {}

func (x *CreateConnectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateConnectionRequest.ProtoReflect.Descriptor instead.
func (*CreateConnectionRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v2_repositories_proto_rawDescGZIP(), []int{11}
}

func (x *CreateConnectionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateConnectionRequest) GetConnection() *Connection {
	if x != nil {
		return x.Connection
	}
	return nil
}

func (x *CreateConnectionRequest) GetConnectionId() string {
	if x != nil {
		return x.ConnectionId
	}
	return ""
}

// Message for getting the details of a Connection.
type GetConnectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Connection to retrieve.
	// Format: `projects/*/locations/*/connections/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetConnectionRequest) Reset() {
	*x = GetConnectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetConnectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConnectionRequest) ProtoMessage() {}

func (x *GetConnectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConnectionRequest.ProtoReflect.Descriptor instead.
func (*GetConnectionRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v2_repositories_proto_rawDescGZIP(), []int{12}
}

func (x *GetConnectionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for requesting list of Connections.
type ListConnectionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of Connections.
	// Format: `projects/*/locations/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Number of results to return in the list.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page start.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListConnectionsRequest) Reset() {
	*x = ListConnectionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConnectionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConnectionsRequest) ProtoMessage() {}

func (x *ListConnectionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConnectionsRequest.ProtoReflect.Descriptor instead.
func (*ListConnectionsRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v2_repositories_proto_rawDescGZIP(), []int{13}
}

func (x *ListConnectionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListConnectionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListConnectionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Message for response to listing Connections.
type ListConnectionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Connections.
	Connections []*Connection `protobuf:"bytes,1,rep,name=connections,proto3" json:"connections,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListConnectionsResponse) Reset() {
	*x = ListConnectionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConnectionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConnectionsResponse) ProtoMessage() {}

func (x *ListConnectionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConnectionsResponse.ProtoReflect.Descriptor instead.
func (*ListConnectionsResponse) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v2_repositories_proto_rawDescGZIP(), []int{14}
}

func (x *ListConnectionsResponse) GetConnections() []*Connection {
	if x != nil {
		return x.Connections
	}
	return nil
}

func (x *ListConnectionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Message for updating a Connection.
type UpdateConnectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Connection to update.
	Connection *Connection `protobuf:"bytes,1,opt,name=connection,proto3" json:"connection,omitempty"`
	// The list of fields to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// If set to true, and the connection is not found a new connection
	// will be created. In this situation `update_mask` is ignored.
	// The creation will succeed only if the input connection has all the
	// necessary information (e.g a github_config with both  user_oauth_token and
	// installation_id properties).
	AllowMissing bool `protobuf:"varint,3,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
	// The current etag of the connection.
	// If an etag is provided and does not match the current etag of the
	// connection, update will be blocked and an ABORTED error will be returned.
	Etag string `protobuf:"bytes,4,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *UpdateConnectionRequest) Reset() {
	*x = UpdateConnectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateConnectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateConnectionRequest) ProtoMessage() {}

func (x *UpdateConnectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateConnectionRequest.ProtoReflect.Descriptor instead.
func (*UpdateConnectionRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v2_repositories_proto_rawDescGZIP(), []int{15}
}

func (x *UpdateConnectionRequest) GetConnection() *Connection {
	if x != nil {
		return x.Connection
	}
	return nil
}

func (x *UpdateConnectionRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateConnectionRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

func (x *UpdateConnectionRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Message for deleting a Connection.
type DeleteConnectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Connection to delete.
	// Format: `projects/*/locations/*/connections/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The current etag of the connection.
	// If an etag is provided and does not match the current etag of the
	// connection, deletion will be blocked and an ABORTED error will be returned.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	// If set, validate the request, but do not actually post it.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *DeleteConnectionRequest) Reset() {
	*x = DeleteConnectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteConnectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteConnectionRequest) ProtoMessage() {}

func (x *DeleteConnectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteConnectionRequest.ProtoReflect.Descriptor instead.
func (*DeleteConnectionRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v2_repositories_proto_rawDescGZIP(), []int{16}
}

func (x *DeleteConnectionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteConnectionRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *DeleteConnectionRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Message for creating a Repository.
type CreateRepositoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The connection to contain the repository. If the request is part
	// of a BatchCreateRepositoriesRequest, this field should be empty or match
	// the parent specified there.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The repository to create.
	Repository *Repository `protobuf:"bytes,2,opt,name=repository,proto3" json:"repository,omitempty"`
	// Required. The ID to use for the repository, which will become the final
	// component of the repository's resource name. This ID should be unique in
	// the connection. Allows alphanumeric characters and any of
	// -._~%!$&'()*+,;=@.
	RepositoryId string `protobuf:"bytes,3,opt,name=repository_id,json=repositoryId,proto3" json:"repository_id,omitempty"`
}

func (x *CreateRepositoryRequest) Reset() {
	*x = CreateRepositoryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateRepositoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateRepositoryRequest) ProtoMessage() {}

func (x *CreateRepositoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateRepositoryRequest.ProtoReflect.Descriptor instead.
func (*CreateRepositoryRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v2_repositories_proto_rawDescGZIP(), []int{17}
}

func (x *CreateRepositoryRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateRepositoryRequest) GetRepository() *Repository {
	if x != nil {
		return x.Repository
	}
	return nil
}

func (x *CreateRepositoryRequest) GetRepositoryId() string {
	if x != nil {
		return x.RepositoryId
	}
	return ""
}

// Message for creating repositoritories in batch.
type BatchCreateRepositoriesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The connection to contain all the repositories being created.
	// Format: projects/*/locations/*/connections/*
	// The parent field in the CreateRepositoryRequest messages
	// must either be empty or match this field.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The request messages specifying the repositories to create.
	Requests []*CreateRepositoryRequest `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
}

func (x *BatchCreateRepositoriesRequest) Reset() {
	*x = BatchCreateRepositoriesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateRepositoriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateRepositoriesRequest) ProtoMessage() {}

func (x *BatchCreateRepositoriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateRepositoriesRequest.ProtoReflect.Descriptor instead.
func (*BatchCreateRepositoriesRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v2_repositories_proto_rawDescGZIP(), []int{18}
}

func (x *BatchCreateRepositoriesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchCreateRepositoriesRequest) GetRequests() []*CreateRepositoryRequest {
	if x != nil {
		return x.Requests
	}
	return nil
}

// Message for response of creating repositories in batch.
type BatchCreateRepositoriesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Repository resources created.
	Repositories []*Repository `protobuf:"bytes,1,rep,name=repositories,proto3" json:"repositories,omitempty"`
}

func (x *BatchCreateRepositoriesResponse) Reset() {
	*x = BatchCreateRepositoriesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchCreateRepositoriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchCreateRepositoriesResponse) ProtoMessage() {}

func (x *BatchCreateRepositoriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchCreateRepositoriesResponse.ProtoReflect.Descriptor instead.
func (*BatchCreateRepositoriesResponse) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v2_repositories_proto_rawDescGZIP(), []int{19}
}

func (x *BatchCreateRepositoriesResponse) GetRepositories() []*Repository {
	if x != nil {
		return x.Repositories
	}
	return nil
}

// Message for getting the details of a Repository.
type GetRepositoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Repository to retrieve.
	// Format: `projects/*/locations/*/connections/*/repositories/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetRepositoryRequest) Reset() {
	*x = GetRepositoryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetRepositoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRepositoryRequest) ProtoMessage() {}

func (x *GetRepositoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRepositoryRequest.ProtoReflect.Descriptor instead.
func (*GetRepositoryRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v2_repositories_proto_rawDescGZIP(), []int{20}
}

func (x *GetRepositoryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for requesting list of Repositories.
type ListRepositoriesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of Repositories.
	// Format: `projects/*/locations/*/connections/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Number of results to return in the list.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page start.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters resources listed in the response.
	// Expressions must follow API improvement proposal
	// [AIP-160](https://google.aip.dev/160). e.g.
	// `remote_uri:"https://github.com*"`.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListRepositoriesRequest) Reset() {
	*x = ListRepositoriesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRepositoriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRepositoriesRequest) ProtoMessage() {}

func (x *ListRepositoriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRepositoriesRequest.ProtoReflect.Descriptor instead.
func (*ListRepositoriesRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v2_repositories_proto_rawDescGZIP(), []int{21}
}

func (x *ListRepositoriesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListRepositoriesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListRepositoriesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListRepositoriesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Message for response to listing Repositories.
type ListRepositoriesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Repositories.
	Repositories []*Repository `protobuf:"bytes,1,rep,name=repositories,proto3" json:"repositories,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListRepositoriesResponse) Reset() {
	*x = ListRepositoriesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRepositoriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRepositoriesResponse) ProtoMessage() {}

func (x *ListRepositoriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRepositoriesResponse.ProtoReflect.Descriptor instead.
func (*ListRepositoriesResponse) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v2_repositories_proto_rawDescGZIP(), []int{22}
}

func (x *ListRepositoriesResponse) GetRepositories() []*Repository {
	if x != nil {
		return x.Repositories
	}
	return nil
}

func (x *ListRepositoriesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Message for deleting a Repository.
type DeleteRepositoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Repository to delete.
	// Format: `projects/*/locations/*/connections/*/repositories/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The current etag of the repository.
	// If an etag is provided and does not match the current etag of the
	// repository, deletion will be blocked and an ABORTED error will be returned.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	// If set, validate the request, but do not actually post it.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *DeleteRepositoryRequest) Reset() {
	*x = DeleteRepositoryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteRepositoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRepositoryRequest) ProtoMessage() {}

func (x *DeleteRepositoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteRepositoryRequest.ProtoReflect.Descriptor instead.
func (*DeleteRepositoryRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v2_repositories_proto_rawDescGZIP(), []int{23}
}

func (x *DeleteRepositoryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteRepositoryRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *DeleteRepositoryRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Message for fetching SCM read/write token.
type FetchReadWriteTokenRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the repository in the format
	// `projects/*/locations/*/connections/*/repositories/*`.
	Repository string `protobuf:"bytes,1,opt,name=repository,proto3" json:"repository,omitempty"`
}

func (x *FetchReadWriteTokenRequest) Reset() {
	*x = FetchReadWriteTokenRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchReadWriteTokenRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchReadWriteTokenRequest) ProtoMessage() {}

func (x *FetchReadWriteTokenRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchReadWriteTokenRequest.ProtoReflect.Descriptor instead.
func (*FetchReadWriteTokenRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v2_repositories_proto_rawDescGZIP(), []int{24}
}

func (x *FetchReadWriteTokenRequest) GetRepository() string {
	if x != nil {
		return x.Repository
	}
	return ""
}

// Message for fetching SCM read token.
type FetchReadTokenRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the repository in the format
	// `projects/*/locations/*/connections/*/repositories/*`.
	Repository string `protobuf:"bytes,1,opt,name=repository,proto3" json:"repository,omitempty"`
}

func (x *FetchReadTokenRequest) Reset() {
	*x = FetchReadTokenRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchReadTokenRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchReadTokenRequest) ProtoMessage() {}

func (x *FetchReadTokenRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchReadTokenRequest.ProtoReflect.Descriptor instead.
func (*FetchReadTokenRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v2_repositories_proto_rawDescGZIP(), []int{25}
}

func (x *FetchReadTokenRequest) GetRepository() string {
	if x != nil {
		return x.Repository
	}
	return ""
}

// Message for responding to get read token.
type FetchReadTokenResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The token content.
	Token string `protobuf:"bytes,1,opt,name=token,proto3" json:"token,omitempty"`
	// Expiration timestamp. Can be empty if unknown or non-expiring.
	ExpirationTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=expiration_time,json=expirationTime,proto3" json:"expiration_time,omitempty"`
}

func (x *FetchReadTokenResponse) Reset() {
	*x = FetchReadTokenResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchReadTokenResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchReadTokenResponse) ProtoMessage() {}

func (x *FetchReadTokenResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchReadTokenResponse.ProtoReflect.Descriptor instead.
func (*FetchReadTokenResponse) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v2_repositories_proto_rawDescGZIP(), []int{26}
}

func (x *FetchReadTokenResponse) GetToken() string {
	if x != nil {
		return x.Token
	}
	return ""
}

func (x *FetchReadTokenResponse) GetExpirationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpirationTime
	}
	return nil
}

// Message for responding to get read/write token.
type FetchReadWriteTokenResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The token content.
	Token string `protobuf:"bytes,1,opt,name=token,proto3" json:"token,omitempty"`
	// Expiration timestamp. Can be empty if unknown or non-expiring.
	ExpirationTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=expiration_time,json=expirationTime,proto3" json:"expiration_time,omitempty"`
}

func (x *FetchReadWriteTokenResponse) Reset() {
	*x = FetchReadWriteTokenResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchReadWriteTokenResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchReadWriteTokenResponse) ProtoMessage() {}

func (x *FetchReadWriteTokenResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchReadWriteTokenResponse.ProtoReflect.Descriptor instead.
func (*FetchReadWriteTokenResponse) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v2_repositories_proto_rawDescGZIP(), []int{27}
}

func (x *FetchReadWriteTokenResponse) GetToken() string {
	if x != nil {
		return x.Token
	}
	return ""
}

func (x *FetchReadWriteTokenResponse) GetExpirationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpirationTime
	}
	return nil
}

// RPC request object accepted by the ProcessWebhook RPC method.
type ProcessWebhookRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Project and location where the webhook will be received.
	// Format: `projects/*/locations/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// HTTP request body.
	Body *httpbody.HttpBody `protobuf:"bytes,2,opt,name=body,proto3" json:"body,omitempty"`
	// Arbitrary additional key to find the maching repository for a webhook event
	// if needed.
	WebhookKey string `protobuf:"bytes,3,opt,name=webhook_key,json=webhookKey,proto3" json:"webhook_key,omitempty"`
}

func (x *ProcessWebhookRequest) Reset() {
	*x = ProcessWebhookRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProcessWebhookRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProcessWebhookRequest) ProtoMessage() {}

func (x *ProcessWebhookRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProcessWebhookRequest.ProtoReflect.Descriptor instead.
func (*ProcessWebhookRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v2_repositories_proto_rawDescGZIP(), []int{28}
}

func (x *ProcessWebhookRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ProcessWebhookRequest) GetBody() *httpbody.HttpBody {
	if x != nil {
		return x.Body
	}
	return nil
}

func (x *ProcessWebhookRequest) GetWebhookKey() string {
	if x != nil {
		return x.WebhookKey
	}
	return ""
}

// Request for fetching git refs
type FetchGitRefsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the repository in the format
	// `projects/*/locations/*/connections/*/repositories/*`.
	Repository string `protobuf:"bytes,1,opt,name=repository,proto3" json:"repository,omitempty"`
	// Type of refs to fetch
	RefType FetchGitRefsRequest_RefType `protobuf:"varint,2,opt,name=ref_type,json=refType,proto3,enum=google.devtools.cloudbuild.v2.FetchGitRefsRequest_RefType" json:"ref_type,omitempty"`
}

func (x *FetchGitRefsRequest) Reset() {
	*x = FetchGitRefsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchGitRefsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchGitRefsRequest) ProtoMessage() {}

func (x *FetchGitRefsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchGitRefsRequest.ProtoReflect.Descriptor instead.
func (*FetchGitRefsRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v2_repositories_proto_rawDescGZIP(), []int{29}
}

func (x *FetchGitRefsRequest) GetRepository() string {
	if x != nil {
		return x.Repository
	}
	return ""
}

func (x *FetchGitRefsRequest) GetRefType() FetchGitRefsRequest_RefType {
	if x != nil {
		return x.RefType
	}
	return FetchGitRefsRequest_REF_TYPE_UNSPECIFIED
}

// Response for fetching git refs
type FetchGitRefsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the refs fetched.
	RefNames []string `protobuf:"bytes,1,rep,name=ref_names,json=refNames,proto3" json:"ref_names,omitempty"`
}

func (x *FetchGitRefsResponse) Reset() {
	*x = FetchGitRefsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchGitRefsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchGitRefsResponse) ProtoMessage() {}

func (x *FetchGitRefsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchGitRefsResponse.ProtoReflect.Descriptor instead.
func (*FetchGitRefsResponse) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudbuild_v2_repositories_proto_rawDescGZIP(), []int{30}
}

func (x *FetchGitRefsResponse) GetRefNames() []string {
	if x != nil {
		return x.RefNames
	}
	return nil
}

var File_google_devtools_cloudbuild_v2_repositories_proto protoreflect.FileDescriptor

var file_google_devtools_cloudbuild_v2_repositories_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x76, 0x32, 0x2f,
	0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76,
	0x32, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x68, 0x74, 0x74, 0x70, 0x62, 0x6f, 0x64, 0x79, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xbf, 0x07, 0x0a, 0x0a, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x52, 0x0a, 0x0d, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62,
	0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x69, 0x74, 0x48, 0x75, 0x62, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0c, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x71, 0x0a, 0x18, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x5f, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x69, 0x74, 0x48, 0x75, 0x62, 0x45, 0x6e, 0x74,
	0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52,
	0x16, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x52, 0x0a, 0x0d, 0x67, 0x69, 0x74, 0x6c, 0x61,
	0x62, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x32, 0x2e, 0x47,
	0x69, 0x74, 0x4c, 0x61, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0c, 0x67,
	0x69, 0x74, 0x6c, 0x61, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x64, 0x0a, 0x12, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62,
	0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x25, 0x0a,
	0x0b, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x0e, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69,
	0x6c, 0x69, 0x6e, 0x67, 0x12, 0x5c, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x88, 0x01, 0xea, 0x41, 0x84, 0x01, 0x0a, 0x24, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x40, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2a, 0x0b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x32, 0x0a, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x01,
	0x01, 0x42, 0x13, 0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xa0, 0x02, 0x0a, 0x11, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x51, 0x0a, 0x05,
	0x73, 0x74, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x53, 0x74,
	0x61, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x67, 0x65, 0x12,
	0x1d, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x22,
	0x0a, 0x0a, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x55,
	0x72, 0x69, 0x22, 0x75, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x67, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53,
	0x54, 0x41, 0x47, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x43, 0x52,
	0x45, 0x41, 0x54, 0x45, 0x5f, 0x41, 0x50, 0x50, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x50, 0x45,
	0x4e, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x4f, 0x41, 0x55, 0x54, 0x48,
	0x10, 0x02, 0x12, 0x17, 0x0a, 0x13, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x49, 0x4e,
	0x53, 0x54, 0x41, 0x4c, 0x4c, 0x5f, 0x41, 0x50, 0x50, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x43,
	0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x0a, 0x22, 0xac, 0x01, 0x0a, 0x20, 0x46, 0x65,
	0x74, 0x63, 0x68, 0x4c, 0x69, 0x6e, 0x6b, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c,
	0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x9a, 0x01, 0x0a, 0x21, 0x46, 0x65, 0x74,
	0x63, 0x68, 0x4c, 0x69, 0x6e, 0x6b, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4d,
	0x0a, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65,
	0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52,
	0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa3, 0x01, 0x0a, 0x0c, 0x47, 0x69, 0x74, 0x48, 0x75, 0x62,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x63, 0x0a, 0x15, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x7a, 0x65, 0x72, 0x5f, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x2e, 0x76, 0x32, 0x2e, 0x4f, 0x41, 0x75, 0x74, 0x68, 0x43, 0x72, 0x65, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x61, 0x6c, 0x52, 0x14, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65,
	0x72, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x12, 0x2e, 0x0a, 0x13, 0x61,
	0x70, 0x70, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x11, 0x61, 0x70, 0x70, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0xce, 0x04, 0x0a, 0x16,
	0x47, 0x69, 0x74, 0x48, 0x75, 0x62, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1e, 0x0a, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x75,
	0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x68,
	0x6f, 0x73, 0x74, 0x55, 0x72, 0x69, 0x12, 0x1c, 0x0a, 0x07, 0x61, 0x70, 0x69, 0x5f, 0x6b, 0x65,
	0x79, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x61, 0x70,
	0x69, 0x4b, 0x65, 0x79, 0x12, 0x15, 0x0a, 0x06, 0x61, 0x70, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x61, 0x70, 0x70, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x61,
	0x70, 0x70, 0x5f, 0x73, 0x6c, 0x75, 0x67, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61,
	0x70, 0x70, 0x53, 0x6c, 0x75, 0x67, 0x12, 0x6c, 0x0a, 0x1a, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xfa, 0x41, 0x2c, 0x0a,
	0x2a, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x17, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x72, 0x0a, 0x1d, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x5f,
	0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xfa, 0x41, 0x2c,
	0x0a, 0x2a, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x1a, 0x77, 0x65,
	0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x53, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2e, 0x0a, 0x13, 0x61, 0x70, 0x70, 0x5f,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x03, 0x52, 0x11, 0x61, 0x70, 0x70, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6c,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x6f, 0x0a, 0x18, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x16, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x15, 0x0a, 0x06, 0x73, 0x73, 0x6c,
	0x5f, 0x63, 0x61, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x73, 0x73, 0x6c, 0x43, 0x61,
	0x12, 0x2a, 0x0a, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xb2, 0x04, 0x0a,
	0x0c, 0x47, 0x69, 0x74, 0x4c, 0x61, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x19, 0x0a,
	0x08, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x68, 0x6f, 0x73, 0x74, 0x55, 0x72, 0x69, 0x12, 0x78, 0x0a, 0x1d, 0x77, 0x65, 0x62, 0x68,
	0x6f, 0x6f, 0x6b, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x35, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x73, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x1a, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x53,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x70, 0x0a, 0x1a, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x7a, 0x65, 0x72, 0x5f, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x72, 0x65, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x61, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x18, 0x72, 0x65, 0x61, 0x64,
	0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x72, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x61, 0x6c, 0x12, 0x67, 0x0a, 0x15, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x65, 0x72, 0x5f, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x2e, 0x76, 0x32, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x61, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x14, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x7a, 0x65, 0x72, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x12, 0x6f, 0x0a,
	0x18, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x32, 0x2e,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x16, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x44,
	0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x15,
	0x0a, 0x06, 0x73, 0x73, 0x6c, 0x5f, 0x63, 0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x73, 0x73, 0x6c, 0x43, 0x61, 0x12, 0x2a, 0x0a, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0d, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x22, 0x63, 0x0a, 0x16, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x44, 0x69, 0x72, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x49, 0x0a, 0x07, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x64, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x07, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x22, 0xc9, 0x04, 0x0a, 0x0a, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22,
	0x0a, 0x0a, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x55,
	0x72, 0x69, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5c, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x22, 0x0a, 0x0a, 0x77, 0x65, 0x62, 0x68,
	0x6f, 0x6f, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x09, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x49, 0x64, 0x1a, 0x3e, 0x0a, 0x10,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0xa3, 0x01, 0xea,
	0x41, 0x9f, 0x01, 0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x5a, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x7d, 0x2a, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x65, 0x73, 0x32, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52,
	0x01, 0x01, 0x22, 0xa0, 0x01, 0x0a, 0x0f, 0x4f, 0x41, 0x75, 0x74, 0x68, 0x43, 0x72, 0x65, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x12, 0x6c, 0x0a, 0x1a, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xfa, 0x41, 0x2c, 0x0a,
	0x2a, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x17, 0x6f, 0x61, 0x75,
	0x74, 0x68, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x75, 0x73, 0x65,
	0x72, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa0, 0x01, 0x0a, 0x0e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x72,
	0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x12, 0x6d, 0x0a, 0x19, 0x75, 0x73, 0x65, 0x72,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x16, 0x75, 0x73, 0x65, 0x72, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08,
	0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd9, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x12, 0x24, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4e, 0x0a, 0x0a, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x32, 0x2e, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x0d, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x64, 0x22, 0x58, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x26, 0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x9a,
	0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x26, 0x12, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8e, 0x01, 0x0a, 0x17,
	0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4b, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xdf, 0x01, 0x0a,
	0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74,
	0x61, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0x94,
	0x01, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26,
	0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x65, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67,
	0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c,
	0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xd9, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4e, 0x0a, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x72, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x28, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x49,
	0x64, 0x22, 0xbf, 0x01, 0x0a, 0x1e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x57, 0x0a, 0x08, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x73, 0x22, 0x70, 0x0a, 0x1f, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4d, 0x0a, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x69, 0x65, 0x73, 0x22, 0x58, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x26, 0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xb3, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x26, 0x12, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x91, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x4d, 0x0a, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x94, 0x01, 0x0a, 0x17, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x23, 0x0a, 0x0d, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79,
	0x22, 0x6a, 0x0a, 0x1a, 0x46, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65, 0x61, 0x64, 0x57, 0x72, 0x69,
	0x74, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c,
	0x0a, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79,
	0x52, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x22, 0x65, 0x0a, 0x15,
	0x46, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65, 0x61, 0x64, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x26, 0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x22, 0x73, 0x0a, 0x16, 0x46, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65, 0x61, 0x64,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x14, 0x0a,
	0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x43, 0x0a, 0x0f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x78, 0x0a, 0x1b, 0x46, 0x65, 0x74, 0x63,
	0x68, 0x52, 0x65, 0x61, 0x64, 0x57, 0x72, 0x69, 0x74, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x43, 0x0a,
	0x0f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x0e, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69,
	0x6d, 0x65, 0x22, 0xa8, 0x01, 0x0a, 0x15, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x57, 0x65,
	0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x26, 0x12, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x28, 0x0a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x48, 0x74,
	0x74, 0x70, 0x42, 0x6f, 0x64, 0x79, 0x52, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x12, 0x1f, 0x0a, 0x0b,
	0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x4b, 0x65, 0x79, 0x22, 0xf4, 0x01,
	0x0a, 0x13, 0x46, 0x65, 0x74, 0x63, 0x68, 0x47, 0x69, 0x74, 0x52, 0x65, 0x66, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x26, 0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x12, 0x55, 0x0a, 0x08, 0x72, 0x65, 0x66, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x47, 0x69, 0x74, 0x52, 0x65,
	0x66, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x52, 0x65, 0x66, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x07, 0x72, 0x65, 0x66, 0x54, 0x79, 0x70, 0x65, 0x22, 0x38, 0x0a, 0x07, 0x52, 0x65,
	0x66, 0x54, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x14, 0x52, 0x45, 0x46, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x07, 0x0a, 0x03, 0x54, 0x41, 0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x42, 0x52, 0x41, 0x4e,
	0x43, 0x48, 0x10, 0x02, 0x22, 0x33, 0x0a, 0x14, 0x46, 0x65, 0x74, 0x63, 0x68, 0x47, 0x69, 0x74,
	0x52, 0x65, 0x66, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1b, 0x0a, 0x09,
	0x72, 0x65, 0x66, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x08, 0x72, 0x65, 0x66, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x32, 0xc2, 0x1b, 0x0a, 0x11, 0x52, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x12,
	0x91, 0x02, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65,
	0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa5, 0x01, 0xca, 0x41,
	0x3d, 0x0a, 0x0a, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x32, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41,
	0x1f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2c, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x3a, 0x0a, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x2f, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0xaf, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x3e, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc2, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x32,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x40, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x32, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x93, 0x02, 0x0a, 0x10, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x32, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa7, 0x01, 0xca, 0x41, 0x3d, 0x0a, 0x0a, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62,
	0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x32, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x16, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x3a, 0x0a, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x32, 0x3a, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xf5, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x89, 0x01, 0xca,
	0x41, 0x48, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x32, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x2a, 0x2f, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa0, 0x02, 0x0a, 0x10, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb4, 0x01, 0xca, 0x41, 0x3d, 0x0a, 0x0a, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x2e, 0x76, 0x32, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x2c, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x2c, 0x72, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4c, 0x3a,
	0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x22, 0x3e, 0x2f, 0x76, 0x32,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0xb6, 0x02, 0x0a, 0x17,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62,
	0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xbc, 0x01, 0xca, 0x41, 0x52, 0x0a, 0x1f, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x32, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x0f,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x4f, 0x3a, 0x01, 0x2a, 0x22, 0x4a, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x12, 0xbe, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x22, 0x4d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x40, 0x12, 0x3e, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd4, 0x01, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65,
	0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e,
	0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4f, 0xda, 0x41, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40, 0x12, 0x3e, 0x2f, 0x76,
	0x32, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x84, 0x02, 0x0a,
	0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76,
	0x32, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x98, 0x01, 0xca, 0x41, 0x48, 0x0a, 0x15,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65,
	0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x2e, 0x76, 0x32, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x40, 0x2a, 0x3e, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xff, 0x01, 0x0a, 0x13, 0x46, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65, 0x61,
	0x64, 0x57, 0x72, 0x69, 0x74, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x39, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x65, 0x74, 0x63,
	0x68, 0x52, 0x65, 0x61, 0x64, 0x57, 0x72, 0x69, 0x74, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65, 0x61, 0x64,
	0x57, 0x72, 0x69, 0x74, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x71, 0xda, 0x41, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72,
	0x79, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5e, 0x3a, 0x01, 0x2a, 0x22, 0x59, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x61, 0x64, 0x57, 0x72, 0x69, 0x74, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0xeb, 0x01, 0x0a, 0x0e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x52,
	0x65, 0x61, 0x64, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x52, 0x65,
	0x61, 0x64, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x32, 0x2e, 0x46,
	0x65, 0x74, 0x63, 0x68, 0x52, 0x65, 0x61, 0x64, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x6c, 0xda, 0x41, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x59, 0x3a, 0x01, 0x2a, 0x22, 0x54, 0x2f,
	0x76, 0x32, 0x2f, 0x7b, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x61, 0x64, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0xf7, 0x01, 0x0a, 0x19, 0x46, 0x65, 0x74, 0x63, 0x68, 0x4c, 0x69, 0x6e,
	0x6b, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65,
	0x73, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76,
	0x32, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x4c, 0x69, 0x6e, 0x6b, 0x61, 0x62, 0x6c, 0x65, 0x52,
	0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e,
	0x76, 0x32, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x4c, 0x69, 0x6e, 0x6b, 0x61, 0x62, 0x6c, 0x65,
	0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x57, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x51, 0x12, 0x4f, 0x2f, 0x76,
	0x32, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x66, 0x65, 0x74, 0x63, 0x68, 0x4c, 0x69, 0x6e, 0x6b, 0x61, 0x62, 0x6c,
	0x65, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0xdf, 0x01,
	0x0a, 0x0c, 0x46, 0x65, 0x74, 0x63, 0x68, 0x47, 0x69, 0x74, 0x52, 0x65, 0x66, 0x73, 0x12, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x32, 0x2e, 0x46,
	0x65, 0x74, 0x63, 0x68, 0x47, 0x69, 0x74, 0x52, 0x65, 0x66, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e,
	0x76, 0x32, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x47, 0x69, 0x74, 0x52, 0x65, 0x66, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x66, 0xda, 0x41, 0x0a, 0x72, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x53, 0x12, 0x51, 0x2f, 0x76,
	0x32, 0x2f, 0x7b, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x66, 0x65, 0x74, 0x63, 0x68, 0x47, 0x69, 0x74, 0x52, 0x65, 0x66, 0x73, 0x1a,
	0x4d, 0xca, 0x41, 0x19, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e,
	0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xc9,
	0x02, 0xea, 0x41, 0x7c, 0x0a, 0x27, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x64, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x51, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x73, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x7d, 0x2f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x7d,
	0x0a, 0x18, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x76, 0x32, 0x42, 0x16, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62,
	0x75, 0x69, 0x6c, 0x64, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x62, 0x75, 0x69, 0x6c, 0x64, 0x70, 0x62, 0x3b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x70, 0x62, 0xa2, 0x02, 0x03, 0x47, 0x43, 0x42, 0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x42,
	0x75, 0x69, 0x6c, 0x64, 0x2e, 0x56, 0x32, 0xca, 0x02, 0x15, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x5c, 0x56, 0x32, 0xea,
	0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a,
	0x3a, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x3a, 0x3a, 0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_devtools_cloudbuild_v2_repositories_proto_rawDescOnce sync.Once
	file_google_devtools_cloudbuild_v2_repositories_proto_rawDescData = file_google_devtools_cloudbuild_v2_repositories_proto_rawDesc
)

func file_google_devtools_cloudbuild_v2_repositories_proto_rawDescGZIP() []byte {
	file_google_devtools_cloudbuild_v2_repositories_proto_rawDescOnce.Do(func() {
		file_google_devtools_cloudbuild_v2_repositories_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_devtools_cloudbuild_v2_repositories_proto_rawDescData)
	})
	return file_google_devtools_cloudbuild_v2_repositories_proto_rawDescData
}

var file_google_devtools_cloudbuild_v2_repositories_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes = make([]protoimpl.MessageInfo, 33)
var file_google_devtools_cloudbuild_v2_repositories_proto_goTypes = []interface{}{
	(InstallationState_Stage)(0),              // 0: google.devtools.cloudbuild.v2.InstallationState.Stage
	(FetchGitRefsRequest_RefType)(0),          // 1: google.devtools.cloudbuild.v2.FetchGitRefsRequest.RefType
	(*Connection)(nil),                        // 2: google.devtools.cloudbuild.v2.Connection
	(*InstallationState)(nil),                 // 3: google.devtools.cloudbuild.v2.InstallationState
	(*FetchLinkableRepositoriesRequest)(nil),  // 4: google.devtools.cloudbuild.v2.FetchLinkableRepositoriesRequest
	(*FetchLinkableRepositoriesResponse)(nil), // 5: google.devtools.cloudbuild.v2.FetchLinkableRepositoriesResponse
	(*GitHubConfig)(nil),                      // 6: google.devtools.cloudbuild.v2.GitHubConfig
	(*GitHubEnterpriseConfig)(nil),            // 7: google.devtools.cloudbuild.v2.GitHubEnterpriseConfig
	(*GitLabConfig)(nil),                      // 8: google.devtools.cloudbuild.v2.GitLabConfig
	(*ServiceDirectoryConfig)(nil),            // 9: google.devtools.cloudbuild.v2.ServiceDirectoryConfig
	(*Repository)(nil),                        // 10: google.devtools.cloudbuild.v2.Repository
	(*OAuthCredential)(nil),                   // 11: google.devtools.cloudbuild.v2.OAuthCredential
	(*UserCredential)(nil),                    // 12: google.devtools.cloudbuild.v2.UserCredential
	(*CreateConnectionRequest)(nil),           // 13: google.devtools.cloudbuild.v2.CreateConnectionRequest
	(*GetConnectionRequest)(nil),              // 14: google.devtools.cloudbuild.v2.GetConnectionRequest
	(*ListConnectionsRequest)(nil),            // 15: google.devtools.cloudbuild.v2.ListConnectionsRequest
	(*ListConnectionsResponse)(nil),           // 16: google.devtools.cloudbuild.v2.ListConnectionsResponse
	(*UpdateConnectionRequest)(nil),           // 17: google.devtools.cloudbuild.v2.UpdateConnectionRequest
	(*DeleteConnectionRequest)(nil),           // 18: google.devtools.cloudbuild.v2.DeleteConnectionRequest
	(*CreateRepositoryRequest)(nil),           // 19: google.devtools.cloudbuild.v2.CreateRepositoryRequest
	(*BatchCreateRepositoriesRequest)(nil),    // 20: google.devtools.cloudbuild.v2.BatchCreateRepositoriesRequest
	(*BatchCreateRepositoriesResponse)(nil),   // 21: google.devtools.cloudbuild.v2.BatchCreateRepositoriesResponse
	(*GetRepositoryRequest)(nil),              // 22: google.devtools.cloudbuild.v2.GetRepositoryRequest
	(*ListRepositoriesRequest)(nil),           // 23: google.devtools.cloudbuild.v2.ListRepositoriesRequest
	(*ListRepositoriesResponse)(nil),          // 24: google.devtools.cloudbuild.v2.ListRepositoriesResponse
	(*DeleteRepositoryRequest)(nil),           // 25: google.devtools.cloudbuild.v2.DeleteRepositoryRequest
	(*FetchReadWriteTokenRequest)(nil),        // 26: google.devtools.cloudbuild.v2.FetchReadWriteTokenRequest
	(*FetchReadTokenRequest)(nil),             // 27: google.devtools.cloudbuild.v2.FetchReadTokenRequest
	(*FetchReadTokenResponse)(nil),            // 28: google.devtools.cloudbuild.v2.FetchReadTokenResponse
	(*FetchReadWriteTokenResponse)(nil),       // 29: google.devtools.cloudbuild.v2.FetchReadWriteTokenResponse
	(*ProcessWebhookRequest)(nil),             // 30: google.devtools.cloudbuild.v2.ProcessWebhookRequest
	(*FetchGitRefsRequest)(nil),               // 31: google.devtools.cloudbuild.v2.FetchGitRefsRequest
	(*FetchGitRefsResponse)(nil),              // 32: google.devtools.cloudbuild.v2.FetchGitRefsResponse
	nil,                                       // 33: google.devtools.cloudbuild.v2.Connection.AnnotationsEntry
	nil,                                       // 34: google.devtools.cloudbuild.v2.Repository.AnnotationsEntry
	(*timestamppb.Timestamp)(nil),             // 35: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),             // 36: google.protobuf.FieldMask
	(*httpbody.HttpBody)(nil),                 // 37: google.api.HttpBody
	(*longrunningpb.Operation)(nil),           // 38: google.longrunning.Operation
}
var file_google_devtools_cloudbuild_v2_repositories_proto_depIdxs = []int32{
	35, // 0: google.devtools.cloudbuild.v2.Connection.create_time:type_name -> google.protobuf.Timestamp
	35, // 1: google.devtools.cloudbuild.v2.Connection.update_time:type_name -> google.protobuf.Timestamp
	6,  // 2: google.devtools.cloudbuild.v2.Connection.github_config:type_name -> google.devtools.cloudbuild.v2.GitHubConfig
	7,  // 3: google.devtools.cloudbuild.v2.Connection.github_enterprise_config:type_name -> google.devtools.cloudbuild.v2.GitHubEnterpriseConfig
	8,  // 4: google.devtools.cloudbuild.v2.Connection.gitlab_config:type_name -> google.devtools.cloudbuild.v2.GitLabConfig
	3,  // 5: google.devtools.cloudbuild.v2.Connection.installation_state:type_name -> google.devtools.cloudbuild.v2.InstallationState
	33, // 6: google.devtools.cloudbuild.v2.Connection.annotations:type_name -> google.devtools.cloudbuild.v2.Connection.AnnotationsEntry
	0,  // 7: google.devtools.cloudbuild.v2.InstallationState.stage:type_name -> google.devtools.cloudbuild.v2.InstallationState.Stage
	10, // 8: google.devtools.cloudbuild.v2.FetchLinkableRepositoriesResponse.repositories:type_name -> google.devtools.cloudbuild.v2.Repository
	11, // 9: google.devtools.cloudbuild.v2.GitHubConfig.authorizer_credential:type_name -> google.devtools.cloudbuild.v2.OAuthCredential
	9,  // 10: google.devtools.cloudbuild.v2.GitHubEnterpriseConfig.service_directory_config:type_name -> google.devtools.cloudbuild.v2.ServiceDirectoryConfig
	12, // 11: google.devtools.cloudbuild.v2.GitLabConfig.read_authorizer_credential:type_name -> google.devtools.cloudbuild.v2.UserCredential
	12, // 12: google.devtools.cloudbuild.v2.GitLabConfig.authorizer_credential:type_name -> google.devtools.cloudbuild.v2.UserCredential
	9,  // 13: google.devtools.cloudbuild.v2.GitLabConfig.service_directory_config:type_name -> google.devtools.cloudbuild.v2.ServiceDirectoryConfig
	35, // 14: google.devtools.cloudbuild.v2.Repository.create_time:type_name -> google.protobuf.Timestamp
	35, // 15: google.devtools.cloudbuild.v2.Repository.update_time:type_name -> google.protobuf.Timestamp
	34, // 16: google.devtools.cloudbuild.v2.Repository.annotations:type_name -> google.devtools.cloudbuild.v2.Repository.AnnotationsEntry
	2,  // 17: google.devtools.cloudbuild.v2.CreateConnectionRequest.connection:type_name -> google.devtools.cloudbuild.v2.Connection
	2,  // 18: google.devtools.cloudbuild.v2.ListConnectionsResponse.connections:type_name -> google.devtools.cloudbuild.v2.Connection
	2,  // 19: google.devtools.cloudbuild.v2.UpdateConnectionRequest.connection:type_name -> google.devtools.cloudbuild.v2.Connection
	36, // 20: google.devtools.cloudbuild.v2.UpdateConnectionRequest.update_mask:type_name -> google.protobuf.FieldMask
	10, // 21: google.devtools.cloudbuild.v2.CreateRepositoryRequest.repository:type_name -> google.devtools.cloudbuild.v2.Repository
	19, // 22: google.devtools.cloudbuild.v2.BatchCreateRepositoriesRequest.requests:type_name -> google.devtools.cloudbuild.v2.CreateRepositoryRequest
	10, // 23: google.devtools.cloudbuild.v2.BatchCreateRepositoriesResponse.repositories:type_name -> google.devtools.cloudbuild.v2.Repository
	10, // 24: google.devtools.cloudbuild.v2.ListRepositoriesResponse.repositories:type_name -> google.devtools.cloudbuild.v2.Repository
	35, // 25: google.devtools.cloudbuild.v2.FetchReadTokenResponse.expiration_time:type_name -> google.protobuf.Timestamp
	35, // 26: google.devtools.cloudbuild.v2.FetchReadWriteTokenResponse.expiration_time:type_name -> google.protobuf.Timestamp
	37, // 27: google.devtools.cloudbuild.v2.ProcessWebhookRequest.body:type_name -> google.api.HttpBody
	1,  // 28: google.devtools.cloudbuild.v2.FetchGitRefsRequest.ref_type:type_name -> google.devtools.cloudbuild.v2.FetchGitRefsRequest.RefType
	13, // 29: google.devtools.cloudbuild.v2.RepositoryManager.CreateConnection:input_type -> google.devtools.cloudbuild.v2.CreateConnectionRequest
	14, // 30: google.devtools.cloudbuild.v2.RepositoryManager.GetConnection:input_type -> google.devtools.cloudbuild.v2.GetConnectionRequest
	15, // 31: google.devtools.cloudbuild.v2.RepositoryManager.ListConnections:input_type -> google.devtools.cloudbuild.v2.ListConnectionsRequest
	17, // 32: google.devtools.cloudbuild.v2.RepositoryManager.UpdateConnection:input_type -> google.devtools.cloudbuild.v2.UpdateConnectionRequest
	18, // 33: google.devtools.cloudbuild.v2.RepositoryManager.DeleteConnection:input_type -> google.devtools.cloudbuild.v2.DeleteConnectionRequest
	19, // 34: google.devtools.cloudbuild.v2.RepositoryManager.CreateRepository:input_type -> google.devtools.cloudbuild.v2.CreateRepositoryRequest
	20, // 35: google.devtools.cloudbuild.v2.RepositoryManager.BatchCreateRepositories:input_type -> google.devtools.cloudbuild.v2.BatchCreateRepositoriesRequest
	22, // 36: google.devtools.cloudbuild.v2.RepositoryManager.GetRepository:input_type -> google.devtools.cloudbuild.v2.GetRepositoryRequest
	23, // 37: google.devtools.cloudbuild.v2.RepositoryManager.ListRepositories:input_type -> google.devtools.cloudbuild.v2.ListRepositoriesRequest
	25, // 38: google.devtools.cloudbuild.v2.RepositoryManager.DeleteRepository:input_type -> google.devtools.cloudbuild.v2.DeleteRepositoryRequest
	26, // 39: google.devtools.cloudbuild.v2.RepositoryManager.FetchReadWriteToken:input_type -> google.devtools.cloudbuild.v2.FetchReadWriteTokenRequest
	27, // 40: google.devtools.cloudbuild.v2.RepositoryManager.FetchReadToken:input_type -> google.devtools.cloudbuild.v2.FetchReadTokenRequest
	4,  // 41: google.devtools.cloudbuild.v2.RepositoryManager.FetchLinkableRepositories:input_type -> google.devtools.cloudbuild.v2.FetchLinkableRepositoriesRequest
	31, // 42: google.devtools.cloudbuild.v2.RepositoryManager.FetchGitRefs:input_type -> google.devtools.cloudbuild.v2.FetchGitRefsRequest
	38, // 43: google.devtools.cloudbuild.v2.RepositoryManager.CreateConnection:output_type -> google.longrunning.Operation
	2,  // 44: google.devtools.cloudbuild.v2.RepositoryManager.GetConnection:output_type -> google.devtools.cloudbuild.v2.Connection
	16, // 45: google.devtools.cloudbuild.v2.RepositoryManager.ListConnections:output_type -> google.devtools.cloudbuild.v2.ListConnectionsResponse
	38, // 46: google.devtools.cloudbuild.v2.RepositoryManager.UpdateConnection:output_type -> google.longrunning.Operation
	38, // 47: google.devtools.cloudbuild.v2.RepositoryManager.DeleteConnection:output_type -> google.longrunning.Operation
	38, // 48: google.devtools.cloudbuild.v2.RepositoryManager.CreateRepository:output_type -> google.longrunning.Operation
	38, // 49: google.devtools.cloudbuild.v2.RepositoryManager.BatchCreateRepositories:output_type -> google.longrunning.Operation
	10, // 50: google.devtools.cloudbuild.v2.RepositoryManager.GetRepository:output_type -> google.devtools.cloudbuild.v2.Repository
	24, // 51: google.devtools.cloudbuild.v2.RepositoryManager.ListRepositories:output_type -> google.devtools.cloudbuild.v2.ListRepositoriesResponse
	38, // 52: google.devtools.cloudbuild.v2.RepositoryManager.DeleteRepository:output_type -> google.longrunning.Operation
	29, // 53: google.devtools.cloudbuild.v2.RepositoryManager.FetchReadWriteToken:output_type -> google.devtools.cloudbuild.v2.FetchReadWriteTokenResponse
	28, // 54: google.devtools.cloudbuild.v2.RepositoryManager.FetchReadToken:output_type -> google.devtools.cloudbuild.v2.FetchReadTokenResponse
	5,  // 55: google.devtools.cloudbuild.v2.RepositoryManager.FetchLinkableRepositories:output_type -> google.devtools.cloudbuild.v2.FetchLinkableRepositoriesResponse
	32, // 56: google.devtools.cloudbuild.v2.RepositoryManager.FetchGitRefs:output_type -> google.devtools.cloudbuild.v2.FetchGitRefsResponse
	43, // [43:57] is the sub-list for method output_type
	29, // [29:43] is the sub-list for method input_type
	29, // [29:29] is the sub-list for extension type_name
	29, // [29:29] is the sub-list for extension extendee
	0,  // [0:29] is the sub-list for field type_name
}

func init() { file_google_devtools_cloudbuild_v2_repositories_proto_init() }
func file_google_devtools_cloudbuild_v2_repositories_proto_init() {
	if File_google_devtools_cloudbuild_v2_repositories_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Connection); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InstallationState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchLinkableRepositoriesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchLinkableRepositoriesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GitHubConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GitHubEnterpriseConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GitLabConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServiceDirectoryConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Repository); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OAuthCredential); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserCredential); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateConnectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetConnectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConnectionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConnectionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateConnectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteConnectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateRepositoryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateRepositoriesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchCreateRepositoriesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetRepositoryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRepositoriesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRepositoriesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteRepositoryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchReadWriteTokenRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchReadTokenRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchReadTokenResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchReadWriteTokenResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProcessWebhookRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchGitRefsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchGitRefsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Connection_GithubConfig)(nil),
		(*Connection_GithubEnterpriseConfig)(nil),
		(*Connection_GitlabConfig)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_devtools_cloudbuild_v2_repositories_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   33,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_devtools_cloudbuild_v2_repositories_proto_goTypes,
		DependencyIndexes: file_google_devtools_cloudbuild_v2_repositories_proto_depIdxs,
		EnumInfos:         file_google_devtools_cloudbuild_v2_repositories_proto_enumTypes,
		MessageInfos:      file_google_devtools_cloudbuild_v2_repositories_proto_msgTypes,
	}.Build()
	File_google_devtools_cloudbuild_v2_repositories_proto = out.File
	file_google_devtools_cloudbuild_v2_repositories_proto_rawDesc = nil
	file_google_devtools_cloudbuild_v2_repositories_proto_goTypes = nil
	file_google_devtools_cloudbuild_v2_repositories_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// RepositoryManagerClient is the client API for RepositoryManager service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type RepositoryManagerClient interface {
	// Creates a Connection.
	CreateConnection(ctx context.Context, in *CreateConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets details of a single connection.
	GetConnection(ctx context.Context, in *GetConnectionRequest, opts ...grpc.CallOption) (*Connection, error)
	// Lists Connections in a given project and location.
	ListConnections(ctx context.Context, in *ListConnectionsRequest, opts ...grpc.CallOption) (*ListConnectionsResponse, error)
	// Updates a single connection.
	UpdateConnection(ctx context.Context, in *UpdateConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single connection.
	DeleteConnection(ctx context.Context, in *DeleteConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a Repository.
	CreateRepository(ctx context.Context, in *CreateRepositoryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates multiple repositories inside a connection.
	BatchCreateRepositories(ctx context.Context, in *BatchCreateRepositoriesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets details of a single repository.
	GetRepository(ctx context.Context, in *GetRepositoryRequest, opts ...grpc.CallOption) (*Repository, error)
	// Lists Repositories in a given connection.
	ListRepositories(ctx context.Context, in *ListRepositoriesRequest, opts ...grpc.CallOption) (*ListRepositoriesResponse, error)
	// Deletes a single repository.
	DeleteRepository(ctx context.Context, in *DeleteRepositoryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Fetches read/write token of a given repository.
	FetchReadWriteToken(ctx context.Context, in *FetchReadWriteTokenRequest, opts ...grpc.CallOption) (*FetchReadWriteTokenResponse, error)
	// Fetches read token of a given repository.
	FetchReadToken(ctx context.Context, in *FetchReadTokenRequest, opts ...grpc.CallOption) (*FetchReadTokenResponse, error)
	// FetchLinkableRepositories get repositories from SCM that are
	// accessible and could be added to the connection.
	FetchLinkableRepositories(ctx context.Context, in *FetchLinkableRepositoriesRequest, opts ...grpc.CallOption) (*FetchLinkableRepositoriesResponse, error)
	// Fetch the list of branches or tags for a given repository.
	FetchGitRefs(ctx context.Context, in *FetchGitRefsRequest, opts ...grpc.CallOption) (*FetchGitRefsResponse, error)
}

type repositoryManagerClient struct {
	cc grpc.ClientConnInterface
}

func NewRepositoryManagerClient(cc grpc.ClientConnInterface) RepositoryManagerClient {
	return &repositoryManagerClient{cc}
}

func (c *repositoryManagerClient) CreateConnection(ctx context.Context, in *CreateConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v2.RepositoryManager/CreateConnection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryManagerClient) GetConnection(ctx context.Context, in *GetConnectionRequest, opts ...grpc.CallOption) (*Connection, error) {
	out := new(Connection)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v2.RepositoryManager/GetConnection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryManagerClient) ListConnections(ctx context.Context, in *ListConnectionsRequest, opts ...grpc.CallOption) (*ListConnectionsResponse, error) {
	out := new(ListConnectionsResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v2.RepositoryManager/ListConnections", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryManagerClient) UpdateConnection(ctx context.Context, in *UpdateConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v2.RepositoryManager/UpdateConnection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryManagerClient) DeleteConnection(ctx context.Context, in *DeleteConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v2.RepositoryManager/DeleteConnection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryManagerClient) CreateRepository(ctx context.Context, in *CreateRepositoryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v2.RepositoryManager/CreateRepository", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryManagerClient) BatchCreateRepositories(ctx context.Context, in *BatchCreateRepositoriesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v2.RepositoryManager/BatchCreateRepositories", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryManagerClient) GetRepository(ctx context.Context, in *GetRepositoryRequest, opts ...grpc.CallOption) (*Repository, error) {
	out := new(Repository)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v2.RepositoryManager/GetRepository", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryManagerClient) ListRepositories(ctx context.Context, in *ListRepositoriesRequest, opts ...grpc.CallOption) (*ListRepositoriesResponse, error) {
	out := new(ListRepositoriesResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v2.RepositoryManager/ListRepositories", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryManagerClient) DeleteRepository(ctx context.Context, in *DeleteRepositoryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v2.RepositoryManager/DeleteRepository", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryManagerClient) FetchReadWriteToken(ctx context.Context, in *FetchReadWriteTokenRequest, opts ...grpc.CallOption) (*FetchReadWriteTokenResponse, error) {
	out := new(FetchReadWriteTokenResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v2.RepositoryManager/FetchReadWriteToken", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryManagerClient) FetchReadToken(ctx context.Context, in *FetchReadTokenRequest, opts ...grpc.CallOption) (*FetchReadTokenResponse, error) {
	out := new(FetchReadTokenResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v2.RepositoryManager/FetchReadToken", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryManagerClient) FetchLinkableRepositories(ctx context.Context, in *FetchLinkableRepositoriesRequest, opts ...grpc.CallOption) (*FetchLinkableRepositoriesResponse, error) {
	out := new(FetchLinkableRepositoriesResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v2.RepositoryManager/FetchLinkableRepositories", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryManagerClient) FetchGitRefs(ctx context.Context, in *FetchGitRefsRequest, opts ...grpc.CallOption) (*FetchGitRefsResponse, error) {
	out := new(FetchGitRefsResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudbuild.v2.RepositoryManager/FetchGitRefs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RepositoryManagerServer is the server API for RepositoryManager service.
type RepositoryManagerServer interface {
	// Creates a Connection.
	CreateConnection(context.Context, *CreateConnectionRequest) (*longrunningpb.Operation, error)
	// Gets details of a single connection.
	GetConnection(context.Context, *GetConnectionRequest) (*Connection, error)
	// Lists Connections in a given project and location.
	ListConnections(context.Context, *ListConnectionsRequest) (*ListConnectionsResponse, error)
	// Updates a single connection.
	UpdateConnection(context.Context, *UpdateConnectionRequest) (*longrunningpb.Operation, error)
	// Deletes a single connection.
	DeleteConnection(context.Context, *DeleteConnectionRequest) (*longrunningpb.Operation, error)
	// Creates a Repository.
	CreateRepository(context.Context, *CreateRepositoryRequest) (*longrunningpb.Operation, error)
	// Creates multiple repositories inside a connection.
	BatchCreateRepositories(context.Context, *BatchCreateRepositoriesRequest) (*longrunningpb.Operation, error)
	// Gets details of a single repository.
	GetRepository(context.Context, *GetRepositoryRequest) (*Repository, error)
	// Lists Repositories in a given connection.
	ListRepositories(context.Context, *ListRepositoriesRequest) (*ListRepositoriesResponse, error)
	// Deletes a single repository.
	DeleteRepository(context.Context, *DeleteRepositoryRequest) (*longrunningpb.Operation, error)
	// Fetches read/write token of a given repository.
	FetchReadWriteToken(context.Context, *FetchReadWriteTokenRequest) (*FetchReadWriteTokenResponse, error)
	// Fetches read token of a given repository.
	FetchReadToken(context.Context, *FetchReadTokenRequest) (*FetchReadTokenResponse, error)
	// FetchLinkableRepositories get repositories from SCM that are
	// accessible and could be added to the connection.
	FetchLinkableRepositories(context.Context, *FetchLinkableRepositoriesRequest) (*FetchLinkableRepositoriesResponse, error)
	// Fetch the list of branches or tags for a given repository.
	FetchGitRefs(context.Context, *FetchGitRefsRequest) (*FetchGitRefsResponse, error)
}

// UnimplementedRepositoryManagerServer can be embedded to have forward compatible implementations.
type UnimplementedRepositoryManagerServer struct {
}

func (*UnimplementedRepositoryManagerServer) CreateConnection(context.Context, *CreateConnectionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConnection not implemented")
}
func (*UnimplementedRepositoryManagerServer) GetConnection(context.Context, *GetConnectionRequest) (*Connection, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConnection not implemented")
}
func (*UnimplementedRepositoryManagerServer) ListConnections(context.Context, *ListConnectionsRequest) (*ListConnectionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConnections not implemented")
}
func (*UnimplementedRepositoryManagerServer) UpdateConnection(context.Context, *UpdateConnectionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateConnection not implemented")
}
func (*UnimplementedRepositoryManagerServer) DeleteConnection(context.Context, *DeleteConnectionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteConnection not implemented")
}
func (*UnimplementedRepositoryManagerServer) CreateRepository(context.Context, *CreateRepositoryRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRepository not implemented")
}
func (*UnimplementedRepositoryManagerServer) BatchCreateRepositories(context.Context, *BatchCreateRepositoriesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCreateRepositories not implemented")
}
func (*UnimplementedRepositoryManagerServer) GetRepository(context.Context, *GetRepositoryRequest) (*Repository, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRepository not implemented")
}
func (*UnimplementedRepositoryManagerServer) ListRepositories(context.Context, *ListRepositoriesRequest) (*ListRepositoriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRepositories not implemented")
}
func (*UnimplementedRepositoryManagerServer) DeleteRepository(context.Context, *DeleteRepositoryRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRepository not implemented")
}
func (*UnimplementedRepositoryManagerServer) FetchReadWriteToken(context.Context, *FetchReadWriteTokenRequest) (*FetchReadWriteTokenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchReadWriteToken not implemented")
}
func (*UnimplementedRepositoryManagerServer) FetchReadToken(context.Context, *FetchReadTokenRequest) (*FetchReadTokenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchReadToken not implemented")
}
func (*UnimplementedRepositoryManagerServer) FetchLinkableRepositories(context.Context, *FetchLinkableRepositoriesRequest) (*FetchLinkableRepositoriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchLinkableRepositories not implemented")
}
func (*UnimplementedRepositoryManagerServer) FetchGitRefs(context.Context, *FetchGitRefsRequest) (*FetchGitRefsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchGitRefs not implemented")
}

func RegisterRepositoryManagerServer(s *grpc.Server, srv RepositoryManagerServer) {
	s.RegisterService(&_RepositoryManager_serviceDesc, srv)
}

func _RepositoryManager_CreateConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryManagerServer).CreateConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v2.RepositoryManager/CreateConnection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryManagerServer).CreateConnection(ctx, req.(*CreateConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryManager_GetConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryManagerServer).GetConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v2.RepositoryManager/GetConnection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryManagerServer).GetConnection(ctx, req.(*GetConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryManager_ListConnections_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConnectionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryManagerServer).ListConnections(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v2.RepositoryManager/ListConnections",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryManagerServer).ListConnections(ctx, req.(*ListConnectionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryManager_UpdateConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryManagerServer).UpdateConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v2.RepositoryManager/UpdateConnection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryManagerServer).UpdateConnection(ctx, req.(*UpdateConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryManager_DeleteConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryManagerServer).DeleteConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v2.RepositoryManager/DeleteConnection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryManagerServer).DeleteConnection(ctx, req.(*DeleteConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryManager_CreateRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryManagerServer).CreateRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v2.RepositoryManager/CreateRepository",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryManagerServer).CreateRepository(ctx, req.(*CreateRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryManager_BatchCreateRepositories_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateRepositoriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryManagerServer).BatchCreateRepositories(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v2.RepositoryManager/BatchCreateRepositories",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryManagerServer).BatchCreateRepositories(ctx, req.(*BatchCreateRepositoriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryManager_GetRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryManagerServer).GetRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v2.RepositoryManager/GetRepository",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryManagerServer).GetRepository(ctx, req.(*GetRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryManager_ListRepositories_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRepositoriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryManagerServer).ListRepositories(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v2.RepositoryManager/ListRepositories",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryManagerServer).ListRepositories(ctx, req.(*ListRepositoriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryManager_DeleteRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryManagerServer).DeleteRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v2.RepositoryManager/DeleteRepository",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryManagerServer).DeleteRepository(ctx, req.(*DeleteRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryManager_FetchReadWriteToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchReadWriteTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryManagerServer).FetchReadWriteToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v2.RepositoryManager/FetchReadWriteToken",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryManagerServer).FetchReadWriteToken(ctx, req.(*FetchReadWriteTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryManager_FetchReadToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchReadTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryManagerServer).FetchReadToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v2.RepositoryManager/FetchReadToken",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryManagerServer).FetchReadToken(ctx, req.(*FetchReadTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryManager_FetchLinkableRepositories_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchLinkableRepositoriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryManagerServer).FetchLinkableRepositories(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v2.RepositoryManager/FetchLinkableRepositories",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryManagerServer).FetchLinkableRepositories(ctx, req.(*FetchLinkableRepositoriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryManager_FetchGitRefs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchGitRefsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryManagerServer).FetchGitRefs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudbuild.v2.RepositoryManager/FetchGitRefs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryManagerServer).FetchGitRefs(ctx, req.(*FetchGitRefsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _RepositoryManager_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.cloudbuild.v2.RepositoryManager",
	HandlerType: (*RepositoryManagerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateConnection",
			Handler:    _RepositoryManager_CreateConnection_Handler,
		},
		{
			MethodName: "GetConnection",
			Handler:    _RepositoryManager_GetConnection_Handler,
		},
		{
			MethodName: "ListConnections",
			Handler:    _RepositoryManager_ListConnections_Handler,
		},
		{
			MethodName: "UpdateConnection",
			Handler:    _RepositoryManager_UpdateConnection_Handler,
		},
		{
			MethodName: "DeleteConnection",
			Handler:    _RepositoryManager_DeleteConnection_Handler,
		},
		{
			MethodName: "CreateRepository",
			Handler:    _RepositoryManager_CreateRepository_Handler,
		},
		{
			MethodName: "BatchCreateRepositories",
			Handler:    _RepositoryManager_BatchCreateRepositories_Handler,
		},
		{
			MethodName: "GetRepository",
			Handler:    _RepositoryManager_GetRepository_Handler,
		},
		{
			MethodName: "ListRepositories",
			Handler:    _RepositoryManager_ListRepositories_Handler,
		},
		{
			MethodName: "DeleteRepository",
			Handler:    _RepositoryManager_DeleteRepository_Handler,
		},
		{
			MethodName: "FetchReadWriteToken",
			Handler:    _RepositoryManager_FetchReadWriteToken_Handler,
		},
		{
			MethodName: "FetchReadToken",
			Handler:    _RepositoryManager_FetchReadToken_Handler,
		},
		{
			MethodName: "FetchLinkableRepositories",
			Handler:    _RepositoryManager_FetchLinkableRepositories_Handler,
		},
		{
			MethodName: "FetchGitRefs",
			Handler:    _RepositoryManager_FetchGitRefs_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/cloudbuild/v2/repositories.proto",
}
