// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v4.25.3
// source: google/cloud/dialogflow/cx/v3/experiment.proto

package cxpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The state of the experiment.
type Experiment_State int32

const (
	// State unspecified.
	Experiment_STATE_UNSPECIFIED Experiment_State = 0
	// The experiment is created but not started yet.
	Experiment_DRAFT Experiment_State = 1
	// The experiment is running.
	Experiment_RUNNING Experiment_State = 2
	// The experiment is done.
	Experiment_DONE Experiment_State = 3
	// The experiment with auto-rollout enabled has failed.
	Experiment_ROLLOUT_FAILED Experiment_State = 4
)

// Enum value maps for Experiment_State.
var (
	Experiment_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "DRAFT",
		2: "RUNNING",
		3: "DONE",
		4: "ROLLOUT_FAILED",
	}
	Experiment_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"DRAFT":             1,
		"RUNNING":           2,
		"DONE":              3,
		"ROLLOUT_FAILED":    4,
	}
)

func (x Experiment_State) Enum() *Experiment_State {
	p := new(Experiment_State)
	*p = x
	return p
}

func (x Experiment_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Experiment_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3_experiment_proto_enumTypes[0].Descriptor()
}

func (Experiment_State) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3_experiment_proto_enumTypes[0]
}

func (x Experiment_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Experiment_State.Descriptor instead.
func (Experiment_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_experiment_proto_rawDescGZIP(), []int{0, 0}
}

// Types of ratio-based metric for Dialogflow experiment.
type Experiment_Result_MetricType int32

const (
	// Metric unspecified.
	Experiment_Result_METRIC_UNSPECIFIED Experiment_Result_MetricType = 0
	// Percentage of contained sessions without user calling back in 24 hours.
	Experiment_Result_CONTAINED_SESSION_NO_CALLBACK_RATE Experiment_Result_MetricType = 1
	// Percentage of sessions that were handed to a human agent.
	Experiment_Result_LIVE_AGENT_HANDOFF_RATE Experiment_Result_MetricType = 2
	// Percentage of sessions with the same user calling back.
	Experiment_Result_CALLBACK_SESSION_RATE Experiment_Result_MetricType = 3
	// Percentage of sessions where user hung up.
	Experiment_Result_ABANDONED_SESSION_RATE Experiment_Result_MetricType = 4
	// Percentage of sessions reached Dialogflow 'END_PAGE' or
	// 'END_SESSION'.
	Experiment_Result_SESSION_END_RATE Experiment_Result_MetricType = 5
)

// Enum value maps for Experiment_Result_MetricType.
var (
	Experiment_Result_MetricType_name = map[int32]string{
		0: "METRIC_UNSPECIFIED",
		1: "CONTAINED_SESSION_NO_CALLBACK_RATE",
		2: "LIVE_AGENT_HANDOFF_RATE",
		3: "CALLBACK_SESSION_RATE",
		4: "ABANDONED_SESSION_RATE",
		5: "SESSION_END_RATE",
	}
	Experiment_Result_MetricType_value = map[string]int32{
		"METRIC_UNSPECIFIED":                 0,
		"CONTAINED_SESSION_NO_CALLBACK_RATE": 1,
		"LIVE_AGENT_HANDOFF_RATE":            2,
		"CALLBACK_SESSION_RATE":              3,
		"ABANDONED_SESSION_RATE":             4,
		"SESSION_END_RATE":                   5,
	}
)

func (x Experiment_Result_MetricType) Enum() *Experiment_Result_MetricType {
	p := new(Experiment_Result_MetricType)
	*p = x
	return p
}

func (x Experiment_Result_MetricType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Experiment_Result_MetricType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3_experiment_proto_enumTypes[1].Descriptor()
}

func (Experiment_Result_MetricType) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3_experiment_proto_enumTypes[1]
}

func (x Experiment_Result_MetricType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Experiment_Result_MetricType.Descriptor instead.
func (Experiment_Result_MetricType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_experiment_proto_rawDescGZIP(), []int{0, 1, 0}
}

// Types of count-based metric for Dialogflow experiment.
type Experiment_Result_CountType int32

const (
	// Count type unspecified.
	Experiment_Result_COUNT_TYPE_UNSPECIFIED Experiment_Result_CountType = 0
	// Total number of occurrences of a 'NO_MATCH'.
	Experiment_Result_TOTAL_NO_MATCH_COUNT Experiment_Result_CountType = 1
	// Total number of turn counts.
	Experiment_Result_TOTAL_TURN_COUNT Experiment_Result_CountType = 2
	// Average turn count in a session.
	Experiment_Result_AVERAGE_TURN_COUNT Experiment_Result_CountType = 3
)

// Enum value maps for Experiment_Result_CountType.
var (
	Experiment_Result_CountType_name = map[int32]string{
		0: "COUNT_TYPE_UNSPECIFIED",
		1: "TOTAL_NO_MATCH_COUNT",
		2: "TOTAL_TURN_COUNT",
		3: "AVERAGE_TURN_COUNT",
	}
	Experiment_Result_CountType_value = map[string]int32{
		"COUNT_TYPE_UNSPECIFIED": 0,
		"TOTAL_NO_MATCH_COUNT":   1,
		"TOTAL_TURN_COUNT":       2,
		"AVERAGE_TURN_COUNT":     3,
	}
)

func (x Experiment_Result_CountType) Enum() *Experiment_Result_CountType {
	p := new(Experiment_Result_CountType)
	*p = x
	return p
}

func (x Experiment_Result_CountType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Experiment_Result_CountType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3_experiment_proto_enumTypes[2].Descriptor()
}

func (Experiment_Result_CountType) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3_experiment_proto_enumTypes[2]
}

func (x Experiment_Result_CountType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Experiment_Result_CountType.Descriptor instead.
func (Experiment_Result_CountType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_experiment_proto_rawDescGZIP(), []int{0, 1, 1}
}

// Represents an experiment in an environment.
type Experiment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the experiment.
	// Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/environments/<Environment ID>/experiments/<Experiment ID>..
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The human-readable name of the experiment (unique in an
	// environment). Limit of 64 characters.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The human-readable description of the experiment.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// The current state of the experiment.
	// Transition triggered by Experiments.StartExperiment: DRAFT->RUNNING.
	// Transition triggered by Experiments.CancelExperiment: DRAFT->DONE or
	// RUNNING->DONE.
	State Experiment_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.dialogflow.cx.v3.Experiment_State" json:"state,omitempty"`
	// The definition of the experiment.
	Definition *Experiment_Definition `protobuf:"bytes,5,opt,name=definition,proto3" json:"definition,omitempty"`
	// The configuration for auto rollout. If set, there should be exactly two
	// variants in the experiment (control variant being the default version of
	// the flow), the traffic allocation for the non-control variant will
	// gradually increase to 100% when conditions are met, and eventually
	// replace the control variant to become the default version of the flow.
	RolloutConfig *RolloutConfig `protobuf:"bytes,14,opt,name=rollout_config,json=rolloutConfig,proto3" json:"rollout_config,omitempty"`
	// State of the auto rollout process.
	RolloutState *RolloutState `protobuf:"bytes,15,opt,name=rollout_state,json=rolloutState,proto3" json:"rollout_state,omitempty"`
	// The reason why rollout has failed. Should only be set when state is
	// ROLLOUT_FAILED.
	RolloutFailureReason string `protobuf:"bytes,16,opt,name=rollout_failure_reason,json=rolloutFailureReason,proto3" json:"rollout_failure_reason,omitempty"`
	// Inference result of the experiment.
	Result *Experiment_Result `protobuf:"bytes,6,opt,name=result,proto3" json:"result,omitempty"`
	// Creation time of this experiment.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Start time of this experiment.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// End time of this experiment.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Last update time of this experiment.
	LastUpdateTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=last_update_time,json=lastUpdateTime,proto3" json:"last_update_time,omitempty"`
	// Maximum number of days to run the experiment/rollout. If auto-rollout is
	// not enabled, default value and maximum will be 30 days. If auto-rollout is
	// enabled, default value and maximum will be 6 days.
	ExperimentLength *durationpb.Duration `protobuf:"bytes,11,opt,name=experiment_length,json=experimentLength,proto3" json:"experiment_length,omitempty"`
	// The history of updates to the experiment variants.
	VariantsHistory []*VariantsHistory `protobuf:"bytes,12,rep,name=variants_history,json=variantsHistory,proto3" json:"variants_history,omitempty"`
}

func (x *Experiment) Reset() {
	*x = Experiment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Experiment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Experiment) ProtoMessage() {}

func (x *Experiment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Experiment.ProtoReflect.Descriptor instead.
func (*Experiment) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_experiment_proto_rawDescGZIP(), []int{0}
}

func (x *Experiment) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Experiment) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Experiment) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Experiment) GetState() Experiment_State {
	if x != nil {
		return x.State
	}
	return Experiment_STATE_UNSPECIFIED
}

func (x *Experiment) GetDefinition() *Experiment_Definition {
	if x != nil {
		return x.Definition
	}
	return nil
}

func (x *Experiment) GetRolloutConfig() *RolloutConfig {
	if x != nil {
		return x.RolloutConfig
	}
	return nil
}

func (x *Experiment) GetRolloutState() *RolloutState {
	if x != nil {
		return x.RolloutState
	}
	return nil
}

func (x *Experiment) GetRolloutFailureReason() string {
	if x != nil {
		return x.RolloutFailureReason
	}
	return ""
}

func (x *Experiment) GetResult() *Experiment_Result {
	if x != nil {
		return x.Result
	}
	return nil
}

func (x *Experiment) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Experiment) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Experiment) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *Experiment) GetLastUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastUpdateTime
	}
	return nil
}

func (x *Experiment) GetExperimentLength() *durationpb.Duration {
	if x != nil {
		return x.ExperimentLength
	}
	return nil
}

func (x *Experiment) GetVariantsHistory() []*VariantsHistory {
	if x != nil {
		return x.VariantsHistory
	}
	return nil
}

// A list of flow version variants.
type VersionVariants struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of flow version variants.
	Variants []*VersionVariants_Variant `protobuf:"bytes,1,rep,name=variants,proto3" json:"variants,omitempty"`
}

func (x *VersionVariants) Reset() {
	*x = VersionVariants{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VersionVariants) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VersionVariants) ProtoMessage() {}

func (x *VersionVariants) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VersionVariants.ProtoReflect.Descriptor instead.
func (*VersionVariants) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_experiment_proto_rawDescGZIP(), []int{1}
}

func (x *VersionVariants) GetVariants() []*VersionVariants_Variant {
	if x != nil {
		return x.Variants
	}
	return nil
}

// The history of variants update.
type VariantsHistory struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The variants updated. We currently only support single variant
	// experiment.
	//
	// Types that are assignable to Variants:
	//
	//	*VariantsHistory_VersionVariants
	Variants isVariantsHistory_Variants `protobuf_oneof:"variants"`
	// Update time of the variants.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *VariantsHistory) Reset() {
	*x = VariantsHistory{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VariantsHistory) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VariantsHistory) ProtoMessage() {}

func (x *VariantsHistory) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VariantsHistory.ProtoReflect.Descriptor instead.
func (*VariantsHistory) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_experiment_proto_rawDescGZIP(), []int{2}
}

func (m *VariantsHistory) GetVariants() isVariantsHistory_Variants {
	if m != nil {
		return m.Variants
	}
	return nil
}

func (x *VariantsHistory) GetVersionVariants() *VersionVariants {
	if x, ok := x.GetVariants().(*VariantsHistory_VersionVariants); ok {
		return x.VersionVariants
	}
	return nil
}

func (x *VariantsHistory) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

type isVariantsHistory_Variants interface {
	isVariantsHistory_Variants()
}

type VariantsHistory_VersionVariants struct {
	// The flow versions as the variants.
	VersionVariants *VersionVariants `protobuf:"bytes,1,opt,name=version_variants,json=versionVariants,proto3,oneof"`
}

func (*VariantsHistory_VersionVariants) isVariantsHistory_Variants() {}

// The configuration for auto rollout.
type RolloutConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Steps to roll out a flow version. Steps should be sorted by percentage in
	// ascending order.
	RolloutSteps []*RolloutConfig_RolloutStep `protobuf:"bytes,1,rep,name=rollout_steps,json=rolloutSteps,proto3" json:"rollout_steps,omitempty"`
	// The conditions that are used to evaluate the success of a rollout
	// step. If not specified, all rollout steps will proceed to the next one
	// unless failure conditions are met. E.g. "containment_rate > 60% AND
	// callback_rate < 20%". See the [conditions
	// reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
	RolloutCondition string `protobuf:"bytes,2,opt,name=rollout_condition,json=rolloutCondition,proto3" json:"rollout_condition,omitempty"`
	// The conditions that are used to evaluate the failure of a rollout
	// step. If not specified, no rollout steps will fail. E.g. "containment_rate
	// < 10% OR average_turn_count < 3". See the [conditions
	// reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
	FailureCondition string `protobuf:"bytes,3,opt,name=failure_condition,json=failureCondition,proto3" json:"failure_condition,omitempty"`
}

func (x *RolloutConfig) Reset() {
	*x = RolloutConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RolloutConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RolloutConfig) ProtoMessage() {}

func (x *RolloutConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RolloutConfig.ProtoReflect.Descriptor instead.
func (*RolloutConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_experiment_proto_rawDescGZIP(), []int{3}
}

func (x *RolloutConfig) GetRolloutSteps() []*RolloutConfig_RolloutStep {
	if x != nil {
		return x.RolloutSteps
	}
	return nil
}

func (x *RolloutConfig) GetRolloutCondition() string {
	if x != nil {
		return x.RolloutCondition
	}
	return ""
}

func (x *RolloutConfig) GetFailureCondition() string {
	if x != nil {
		return x.FailureCondition
	}
	return ""
}

// State of the auto-rollout process.
type RolloutState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Display name of the current auto rollout step.
	Step string `protobuf:"bytes,1,opt,name=step,proto3" json:"step,omitempty"`
	// Index of the current step in the auto rollout steps list.
	StepIndex int32 `protobuf:"varint,3,opt,name=step_index,json=stepIndex,proto3" json:"step_index,omitempty"`
	// Start time of the current step.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
}

func (x *RolloutState) Reset() {
	*x = RolloutState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RolloutState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RolloutState) ProtoMessage() {}

func (x *RolloutState) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RolloutState.ProtoReflect.Descriptor instead.
func (*RolloutState) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_experiment_proto_rawDescGZIP(), []int{4}
}

func (x *RolloutState) GetStep() string {
	if x != nil {
		return x.Step
	}
	return ""
}

func (x *RolloutState) GetStepIndex() int32 {
	if x != nil {
		return x.StepIndex
	}
	return 0
}

func (x *RolloutState) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

// The request message for
// [Experiments.ListExperiments][google.cloud.dialogflow.cx.v3.Experiments.ListExperiments].
type ListExperimentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The [Environment][google.cloud.dialogflow.cx.v3.Environment] to
	// list all environments for. Format: `projects/<Project
	// ID>/locations/<Location ID>/agents/<Agent ID>/environments/<Environment
	// ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return in a single page. By default 20 and
	// at most 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListExperimentsRequest) Reset() {
	*x = ListExperimentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListExperimentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListExperimentsRequest) ProtoMessage() {}

func (x *ListExperimentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListExperimentsRequest.ProtoReflect.Descriptor instead.
func (*ListExperimentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_experiment_proto_rawDescGZIP(), []int{5}
}

func (x *ListExperimentsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListExperimentsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListExperimentsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for
// [Experiments.ListExperiments][google.cloud.dialogflow.cx.v3.Experiments.ListExperiments].
type ListExperimentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of experiments. There will be a maximum number of items
	// returned based on the page_size field in the request. The list may in some
	// cases be empty or contain fewer entries than page_size even if this isn't
	// the last page.
	Experiments []*Experiment `protobuf:"bytes,1,rep,name=experiments,proto3" json:"experiments,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListExperimentsResponse) Reset() {
	*x = ListExperimentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListExperimentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListExperimentsResponse) ProtoMessage() {}

func (x *ListExperimentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListExperimentsResponse.ProtoReflect.Descriptor instead.
func (*ListExperimentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_experiment_proto_rawDescGZIP(), []int{6}
}

func (x *ListExperimentsResponse) GetExperiments() []*Experiment {
	if x != nil {
		return x.Experiments
	}
	return nil
}

func (x *ListExperimentsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for
// [Experiments.GetExperiment][google.cloud.dialogflow.cx.v3.Experiments.GetExperiment].
type GetExperimentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the
	// [Environment][google.cloud.dialogflow.cx.v3.Environment]. Format:
	// `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/environments/<Environment ID>/experiments/<Experiment ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetExperimentRequest) Reset() {
	*x = GetExperimentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetExperimentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetExperimentRequest) ProtoMessage() {}

func (x *GetExperimentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetExperimentRequest.ProtoReflect.Descriptor instead.
func (*GetExperimentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_experiment_proto_rawDescGZIP(), []int{7}
}

func (x *GetExperimentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for
// [Experiments.CreateExperiment][google.cloud.dialogflow.cx.v3.Experiments.CreateExperiment].
type CreateExperimentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The [Agent][google.cloud.dialogflow.cx.v3.Agent] to create an
	// [Environment][google.cloud.dialogflow.cx.v3.Environment] for. Format:
	// `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/environments/<Environment ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The experiment to create.
	Experiment *Experiment `protobuf:"bytes,2,opt,name=experiment,proto3" json:"experiment,omitempty"`
}

func (x *CreateExperimentRequest) Reset() {
	*x = CreateExperimentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateExperimentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateExperimentRequest) ProtoMessage() {}

func (x *CreateExperimentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateExperimentRequest.ProtoReflect.Descriptor instead.
func (*CreateExperimentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_experiment_proto_rawDescGZIP(), []int{8}
}

func (x *CreateExperimentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateExperimentRequest) GetExperiment() *Experiment {
	if x != nil {
		return x.Experiment
	}
	return nil
}

// The request message for
// [Experiments.UpdateExperiment][google.cloud.dialogflow.cx.v3.Experiments.UpdateExperiment].
type UpdateExperimentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The experiment to update.
	Experiment *Experiment `protobuf:"bytes,1,opt,name=experiment,proto3" json:"experiment,omitempty"`
	// Required. The mask to control which fields get updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateExperimentRequest) Reset() {
	*x = UpdateExperimentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateExperimentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateExperimentRequest) ProtoMessage() {}

func (x *UpdateExperimentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateExperimentRequest.ProtoReflect.Descriptor instead.
func (*UpdateExperimentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_experiment_proto_rawDescGZIP(), []int{9}
}

func (x *UpdateExperimentRequest) GetExperiment() *Experiment {
	if x != nil {
		return x.Experiment
	}
	return nil
}

func (x *UpdateExperimentRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request message for
// [Experiments.DeleteExperiment][google.cloud.dialogflow.cx.v3.Experiments.DeleteExperiment].
type DeleteExperimentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the
	// [Environment][google.cloud.dialogflow.cx.v3.Environment] to delete. Format:
	// `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/environments/<Environment ID>/experiments/<Experiment ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteExperimentRequest) Reset() {
	*x = DeleteExperimentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteExperimentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteExperimentRequest) ProtoMessage() {}

func (x *DeleteExperimentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteExperimentRequest.ProtoReflect.Descriptor instead.
func (*DeleteExperimentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_experiment_proto_rawDescGZIP(), []int{10}
}

func (x *DeleteExperimentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for
// [Experiments.StartExperiment][google.cloud.dialogflow.cx.v3.Experiments.StartExperiment].
type StartExperimentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the experiment to start.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/environments/<Environment ID>/experiments/<Experiment ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *StartExperimentRequest) Reset() {
	*x = StartExperimentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StartExperimentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartExperimentRequest) ProtoMessage() {}

func (x *StartExperimentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartExperimentRequest.ProtoReflect.Descriptor instead.
func (*StartExperimentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_experiment_proto_rawDescGZIP(), []int{11}
}

func (x *StartExperimentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for
// [Experiments.StopExperiment][google.cloud.dialogflow.cx.v3.Experiments.StopExperiment].
type StopExperimentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the experiment to stop.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/environments/<Environment ID>/experiments/<Experiment ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *StopExperimentRequest) Reset() {
	*x = StopExperimentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StopExperimentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StopExperimentRequest) ProtoMessage() {}

func (x *StopExperimentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StopExperimentRequest.ProtoReflect.Descriptor instead.
func (*StopExperimentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_experiment_proto_rawDescGZIP(), []int{12}
}

func (x *StopExperimentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Definition of the experiment.
type Experiment_Definition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The condition defines which subset of sessions are selected for
	// this experiment. If not specified, all sessions are eligible. E.g.
	// "query_input.language_code=en" See the [conditions
	// reference](https://cloud.google.com/dialogflow/cx/docs/reference/condition).
	Condition string `protobuf:"bytes,1,opt,name=condition,proto3" json:"condition,omitempty"`
	// The variants of the experiment. We currently only support single variant
	// experiment.
	//
	// Types that are assignable to Variants:
	//
	//	*Experiment_Definition_VersionVariants
	Variants isExperiment_Definition_Variants `protobuf_oneof:"variants"`
}

func (x *Experiment_Definition) Reset() {
	*x = Experiment_Definition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Experiment_Definition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Experiment_Definition) ProtoMessage() {}

func (x *Experiment_Definition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Experiment_Definition.ProtoReflect.Descriptor instead.
func (*Experiment_Definition) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_experiment_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Experiment_Definition) GetCondition() string {
	if x != nil {
		return x.Condition
	}
	return ""
}

func (m *Experiment_Definition) GetVariants() isExperiment_Definition_Variants {
	if m != nil {
		return m.Variants
	}
	return nil
}

func (x *Experiment_Definition) GetVersionVariants() *VersionVariants {
	if x, ok := x.GetVariants().(*Experiment_Definition_VersionVariants); ok {
		return x.VersionVariants
	}
	return nil
}

type isExperiment_Definition_Variants interface {
	isExperiment_Definition_Variants()
}

type Experiment_Definition_VersionVariants struct {
	// The flow versions as the variants of this experiment.
	VersionVariants *VersionVariants `protobuf:"bytes,2,opt,name=version_variants,json=versionVariants,proto3,oneof"`
}

func (*Experiment_Definition_VersionVariants) isExperiment_Definition_Variants() {}

// The inference result which includes an objective metric to optimize and the
// confidence interval.
type Experiment_Result struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Version variants and metrics.
	VersionMetrics []*Experiment_Result_VersionMetrics `protobuf:"bytes,1,rep,name=version_metrics,json=versionMetrics,proto3" json:"version_metrics,omitempty"`
	// The last time the experiment's stats data was updated. Will have default
	// value if stats have never been computed for this experiment.
	LastUpdateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=last_update_time,json=lastUpdateTime,proto3" json:"last_update_time,omitempty"`
}

func (x *Experiment_Result) Reset() {
	*x = Experiment_Result{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Experiment_Result) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Experiment_Result) ProtoMessage() {}

func (x *Experiment_Result) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Experiment_Result.ProtoReflect.Descriptor instead.
func (*Experiment_Result) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_experiment_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Experiment_Result) GetVersionMetrics() []*Experiment_Result_VersionMetrics {
	if x != nil {
		return x.VersionMetrics
	}
	return nil
}

func (x *Experiment_Result) GetLastUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastUpdateTime
	}
	return nil
}

// A confidence interval is a range of possible values for the experiment
// objective you are trying to measure.
type Experiment_Result_ConfidenceInterval struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The confidence level used to construct the interval, i.e. there is X%
	// chance that the true value is within this interval.
	ConfidenceLevel float64 `protobuf:"fixed64,1,opt,name=confidence_level,json=confidenceLevel,proto3" json:"confidence_level,omitempty"`
	// The percent change between an experiment metric's value and the value
	// for its control.
	Ratio float64 `protobuf:"fixed64,2,opt,name=ratio,proto3" json:"ratio,omitempty"`
	// Lower bound of the interval.
	LowerBound float64 `protobuf:"fixed64,3,opt,name=lower_bound,json=lowerBound,proto3" json:"lower_bound,omitempty"`
	// Upper bound of the interval.
	UpperBound float64 `protobuf:"fixed64,4,opt,name=upper_bound,json=upperBound,proto3" json:"upper_bound,omitempty"`
}

func (x *Experiment_Result_ConfidenceInterval) Reset() {
	*x = Experiment_Result_ConfidenceInterval{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Experiment_Result_ConfidenceInterval) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Experiment_Result_ConfidenceInterval) ProtoMessage() {}

func (x *Experiment_Result_ConfidenceInterval) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Experiment_Result_ConfidenceInterval.ProtoReflect.Descriptor instead.
func (*Experiment_Result_ConfidenceInterval) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_experiment_proto_rawDescGZIP(), []int{0, 1, 0}
}

func (x *Experiment_Result_ConfidenceInterval) GetConfidenceLevel() float64 {
	if x != nil {
		return x.ConfidenceLevel
	}
	return 0
}

func (x *Experiment_Result_ConfidenceInterval) GetRatio() float64 {
	if x != nil {
		return x.Ratio
	}
	return 0
}

func (x *Experiment_Result_ConfidenceInterval) GetLowerBound() float64 {
	if x != nil {
		return x.LowerBound
	}
	return 0
}

func (x *Experiment_Result_ConfidenceInterval) GetUpperBound() float64 {
	if x != nil {
		return x.UpperBound
	}
	return 0
}

// Metric and corresponding confidence intervals.
type Experiment_Result_Metric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Ratio-based metric type. Only one of type or count_type is specified in
	// each Metric.
	Type Experiment_Result_MetricType `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.dialogflow.cx.v3.Experiment_Result_MetricType" json:"type,omitempty"`
	// Count-based metric type. Only one of type or count_type is specified in
	// each Metric.
	CountType Experiment_Result_CountType `protobuf:"varint,5,opt,name=count_type,json=countType,proto3,enum=google.cloud.dialogflow.cx.v3.Experiment_Result_CountType" json:"count_type,omitempty"`
	// The actual value of the metric.
	//
	// Types that are assignable to Value:
	//
	//	*Experiment_Result_Metric_Ratio
	//	*Experiment_Result_Metric_Count
	Value isExperiment_Result_Metric_Value `protobuf_oneof:"value"`
	// The probability that the treatment is better than all other treatments
	// in the experiment
	ConfidenceInterval *Experiment_Result_ConfidenceInterval `protobuf:"bytes,3,opt,name=confidence_interval,json=confidenceInterval,proto3" json:"confidence_interval,omitempty"`
}

func (x *Experiment_Result_Metric) Reset() {
	*x = Experiment_Result_Metric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Experiment_Result_Metric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Experiment_Result_Metric) ProtoMessage() {}

func (x *Experiment_Result_Metric) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Experiment_Result_Metric.ProtoReflect.Descriptor instead.
func (*Experiment_Result_Metric) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_experiment_proto_rawDescGZIP(), []int{0, 1, 1}
}

func (x *Experiment_Result_Metric) GetType() Experiment_Result_MetricType {
	if x != nil {
		return x.Type
	}
	return Experiment_Result_METRIC_UNSPECIFIED
}

func (x *Experiment_Result_Metric) GetCountType() Experiment_Result_CountType {
	if x != nil {
		return x.CountType
	}
	return Experiment_Result_COUNT_TYPE_UNSPECIFIED
}

func (m *Experiment_Result_Metric) GetValue() isExperiment_Result_Metric_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *Experiment_Result_Metric) GetRatio() float64 {
	if x, ok := x.GetValue().(*Experiment_Result_Metric_Ratio); ok {
		return x.Ratio
	}
	return 0
}

func (x *Experiment_Result_Metric) GetCount() float64 {
	if x, ok := x.GetValue().(*Experiment_Result_Metric_Count); ok {
		return x.Count
	}
	return 0
}

func (x *Experiment_Result_Metric) GetConfidenceInterval() *Experiment_Result_ConfidenceInterval {
	if x != nil {
		return x.ConfidenceInterval
	}
	return nil
}

type isExperiment_Result_Metric_Value interface {
	isExperiment_Result_Metric_Value()
}

type Experiment_Result_Metric_Ratio struct {
	// Ratio value of a metric.
	Ratio float64 `protobuf:"fixed64,2,opt,name=ratio,proto3,oneof"`
}

type Experiment_Result_Metric_Count struct {
	// Count value of a metric.
	Count float64 `protobuf:"fixed64,4,opt,name=count,proto3,oneof"`
}

func (*Experiment_Result_Metric_Ratio) isExperiment_Result_Metric_Value() {}

func (*Experiment_Result_Metric_Count) isExperiment_Result_Metric_Value() {}

// Version variant and associated metrics.
type Experiment_Result_VersionMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the flow [Version][google.cloud.dialogflow.cx.v3.Version].
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/agents/<Agent ID>/flows/<Flow ID>/versions/<Version ID>`.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// The metrics and corresponding confidence intervals in the inference
	// result.
	Metrics []*Experiment_Result_Metric `protobuf:"bytes,2,rep,name=metrics,proto3" json:"metrics,omitempty"`
	// Number of sessions that were allocated to this version.
	SessionCount int32 `protobuf:"varint,3,opt,name=session_count,json=sessionCount,proto3" json:"session_count,omitempty"`
}

func (x *Experiment_Result_VersionMetrics) Reset() {
	*x = Experiment_Result_VersionMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Experiment_Result_VersionMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Experiment_Result_VersionMetrics) ProtoMessage() {}

func (x *Experiment_Result_VersionMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Experiment_Result_VersionMetrics.ProtoReflect.Descriptor instead.
func (*Experiment_Result_VersionMetrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_experiment_proto_rawDescGZIP(), []int{0, 1, 2}
}

func (x *Experiment_Result_VersionMetrics) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *Experiment_Result_VersionMetrics) GetMetrics() []*Experiment_Result_Metric {
	if x != nil {
		return x.Metrics
	}
	return nil
}

func (x *Experiment_Result_VersionMetrics) GetSessionCount() int32 {
	if x != nil {
		return x.SessionCount
	}
	return 0
}

// A single flow version with specified traffic allocation.
type VersionVariants_Variant struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the flow version.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/flows/<Flow ID>/versions/<Version ID>`.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Percentage of the traffic which should be routed to this
	// version of flow. Traffic allocation for a single flow must sum up to 1.0.
	TrafficAllocation float32 `protobuf:"fixed32,2,opt,name=traffic_allocation,json=trafficAllocation,proto3" json:"traffic_allocation,omitempty"`
	// Whether the variant is for the control group.
	IsControlGroup bool `protobuf:"varint,3,opt,name=is_control_group,json=isControlGroup,proto3" json:"is_control_group,omitempty"`
}

func (x *VersionVariants_Variant) Reset() {
	*x = VersionVariants_Variant{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VersionVariants_Variant) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VersionVariants_Variant) ProtoMessage() {}

func (x *VersionVariants_Variant) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VersionVariants_Variant.ProtoReflect.Descriptor instead.
func (*VersionVariants_Variant) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_experiment_proto_rawDescGZIP(), []int{1, 0}
}

func (x *VersionVariants_Variant) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *VersionVariants_Variant) GetTrafficAllocation() float32 {
	if x != nil {
		return x.TrafficAllocation
	}
	return 0
}

func (x *VersionVariants_Variant) GetIsControlGroup() bool {
	if x != nil {
		return x.IsControlGroup
	}
	return false
}

// A single rollout step with specified traffic allocation.
type RolloutConfig_RolloutStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the rollout step;
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The percentage of traffic allocated to the flow version of this rollout
	// step. (0%, 100%].
	TrafficPercent int32 `protobuf:"varint,2,opt,name=traffic_percent,json=trafficPercent,proto3" json:"traffic_percent,omitempty"`
	// The minimum time that this step should last. Should be longer than 1
	// hour. If not set, the default minimum duration for each step will be 1
	// hour.
	MinDuration *durationpb.Duration `protobuf:"bytes,3,opt,name=min_duration,json=minDuration,proto3" json:"min_duration,omitempty"`
}

func (x *RolloutConfig_RolloutStep) Reset() {
	*x = RolloutConfig_RolloutStep{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RolloutConfig_RolloutStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RolloutConfig_RolloutStep) ProtoMessage() {}

func (x *RolloutConfig_RolloutStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RolloutConfig_RolloutStep.ProtoReflect.Descriptor instead.
func (*RolloutConfig_RolloutStep) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_experiment_proto_rawDescGZIP(), []int{3, 0}
}

func (x *RolloutConfig_RolloutStep) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *RolloutConfig_RolloutStep) GetTrafficPercent() int32 {
	if x != nil {
		return x.TrafficPercent
	}
	return 0
}

func (x *RolloutConfig_RolloutStep) GetMinDuration() *durationpb.Duration {
	if x != nil {
		return x.MinDuration
	}
	return nil
}

var File_google_cloud_dialogflow_cx_v3_experiment_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_cx_v3_experiment_proto_rawDesc = []byte{
	0x0a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x2f,
	0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xfd, 0x13, 0x0a, 0x0a, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x45, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x45,
	0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x54, 0x0a, 0x0a, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x78, 0x70, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0a, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x53, 0x0a, 0x0e,
	0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0e,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x0d, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x50, 0x0a, 0x0d, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0c, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x34, 0x0a, 0x16, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x5f, 0x66,
	0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x10, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x14, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x46, 0x61, 0x69, 0x6c,
	0x75, 0x72, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x48, 0x0a, 0x06, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x06, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65,
	0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x44, 0x0a, 0x10, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e, 0x6c, 0x61, 0x73, 0x74, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x46, 0x0a, 0x11, 0x65, 0x78, 0x70, 0x65,
	0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10,
	0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68,
	0x12, 0x59, 0x0a, 0x10, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x5f, 0x68, 0x69, 0x73,
	0x74, 0x6f, 0x72, 0x79, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x56, 0x61, 0x72, 0x69, 0x61,
	0x6e, 0x74, 0x73, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x0f, 0x76, 0x61, 0x72, 0x69,
	0x61, 0x6e, 0x74, 0x73, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x1a, 0x93, 0x01, 0x0a, 0x0a,
	0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5b, 0x0a, 0x10, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e,
	0x74, 0x73, 0x48, 0x00, 0x52, 0x0f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x72,
	0x69, 0x61, 0x6e, 0x74, 0x73, 0x42, 0x0a, 0x0a, 0x08, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74,
	0x73, 0x1a, 0xaf, 0x09, 0x0a, 0x06, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x68, 0x0a, 0x0f,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x0e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x44, 0x0a, 0x10, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e, 0x6c, 0x61,
	0x73, 0x74, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x97, 0x01, 0x0a,
	0x12, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x72,
	0x76, 0x61, 0x6c, 0x12, 0x29, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63,
	0x65, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x14,
	0x0a, 0x05, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x05, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x12, 0x1f, 0x0a, 0x0b, 0x6c, 0x6f, 0x77, 0x65, 0x72, 0x5f, 0x62, 0x6f,
	0x75, 0x6e, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0a, 0x6c, 0x6f, 0x77, 0x65, 0x72,
	0x42, 0x6f, 0x75, 0x6e, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x75, 0x70, 0x70, 0x65, 0x72, 0x5f, 0x62,
	0x6f, 0x75, 0x6e, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x70, 0x65,
	0x72, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x1a, 0xe3, 0x02, 0x0a, 0x06, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x12, 0x4f, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e,
	0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x12, 0x59, 0x0a, 0x0a, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x09, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x16, 0x0a,
	0x05, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x05,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x12, 0x16, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x74, 0x0a,
	0x13, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x76, 0x61, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x78, 0x70, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x52,
	0x12, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x72,
	0x76, 0x61, 0x6c, 0x42, 0x07, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0xca, 0x01, 0x0a,
	0x0e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12,
	0x40, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x26, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x51, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x2e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x07, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x73, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xb6, 0x01, 0x0a, 0x0a, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x54, 0x79, 0x70, 0x65, 0x12, 0x16, 0x0a, 0x12, 0x4d, 0x45, 0x54, 0x52,
	0x49, 0x43, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x26, 0x0a, 0x22, 0x43, 0x4f, 0x4e, 0x54, 0x41, 0x49, 0x4e, 0x45, 0x44, 0x5f, 0x53, 0x45,
	0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x4e, 0x4f, 0x5f, 0x43, 0x41, 0x4c, 0x4c, 0x42, 0x41, 0x43,
	0x4b, 0x5f, 0x52, 0x41, 0x54, 0x45, 0x10, 0x01, 0x12, 0x1b, 0x0a, 0x17, 0x4c, 0x49, 0x56, 0x45,
	0x5f, 0x41, 0x47, 0x45, 0x4e, 0x54, 0x5f, 0x48, 0x41, 0x4e, 0x44, 0x4f, 0x46, 0x46, 0x5f, 0x52,
	0x41, 0x54, 0x45, 0x10, 0x02, 0x12, 0x19, 0x0a, 0x15, 0x43, 0x41, 0x4c, 0x4c, 0x42, 0x41, 0x43,
	0x4b, 0x5f, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x41, 0x54, 0x45, 0x10, 0x03,
	0x12, 0x1a, 0x0a, 0x16, 0x41, 0x42, 0x41, 0x4e, 0x44, 0x4f, 0x4e, 0x45, 0x44, 0x5f, 0x53, 0x45,
	0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x41, 0x54, 0x45, 0x10, 0x04, 0x12, 0x14, 0x0a, 0x10,
	0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x4e, 0x44, 0x5f, 0x52, 0x41, 0x54, 0x45,
	0x10, 0x05, 0x22, 0x6f, 0x0a, 0x09, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x1a, 0x0a, 0x16, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x18, 0x0a, 0x14, 0x54,
	0x4f, 0x54, 0x41, 0x4c, 0x5f, 0x4e, 0x4f, 0x5f, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x5f, 0x43, 0x4f,
	0x55, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x4f, 0x54, 0x41, 0x4c, 0x5f, 0x54,
	0x55, 0x52, 0x4e, 0x5f, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x10, 0x02, 0x12, 0x16, 0x0a, 0x12, 0x41,
	0x56, 0x45, 0x52, 0x41, 0x47, 0x45, 0x5f, 0x54, 0x55, 0x52, 0x4e, 0x5f, 0x43, 0x4f, 0x55, 0x4e,
	0x54, 0x10, 0x03, 0x22, 0x54, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x44, 0x52, 0x41, 0x46, 0x54, 0x10, 0x01, 0x12, 0x0b,
	0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x44,
	0x4f, 0x4e, 0x45, 0x10, 0x03, 0x12, 0x12, 0x0a, 0x0e, 0x52, 0x4f, 0x4c, 0x4c, 0x4f, 0x55, 0x54,
	0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x3a, 0x96, 0x01, 0xea, 0x41, 0x92, 0x01,
	0x0a, 0x24, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x78, 0x70, 0x65,
	0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x6a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x65,
	0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x76,
	0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x7d, 0x22, 0xe3, 0x01, 0x0a, 0x0f, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61,
	0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x12, 0x52, 0x0a, 0x08, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e,
	0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x2e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74,
	0x52, 0x08, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x1a, 0x7c, 0x0a, 0x07, 0x56, 0x61,
	0x72, 0x69, 0x61, 0x6e, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x2d, 0x0a, 0x12, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x11, 0x74, 0x72, 0x61,
	0x66, 0x66, 0x69, 0x63, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x28,
	0x0a, 0x10, 0x69, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x5f, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x69, 0x73, 0x43, 0x6f, 0x6e, 0x74,
	0x72, 0x6f, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x22, 0xb7, 0x01, 0x0a, 0x0f, 0x56, 0x61, 0x72,
	0x69, 0x61, 0x6e, 0x74, 0x73, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x5b, 0x0a, 0x10,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61,
	0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x48, 0x00, 0x52, 0x0f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x0a, 0x0a, 0x08, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e,
	0x74, 0x73, 0x22, 0xe2, 0x02, 0x0a, 0x0d, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x5d, 0x0a, 0x0d, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x5f,
	0x73, 0x74, 0x65, 0x70, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x6f, 0x6c, 0x6c,
	0x6f, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75,
	0x74, 0x53, 0x74, 0x65, 0x70, 0x52, 0x0c, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x53, 0x74,
	0x65, 0x70, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x5f, 0x63,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10,
	0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x2b, 0x0a, 0x11, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x66, 0x61, 0x69,
	0x6c, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x97, 0x01,
	0x0a, 0x0b, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x53, 0x74, 0x65, 0x70, 0x12, 0x21, 0x0a,
	0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x27, 0x0a, 0x0f, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69, 0x63, 0x5f, 0x70, 0x65, 0x72, 0x63,
	0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x74, 0x72, 0x61, 0x66, 0x66,
	0x69, 0x63, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x12, 0x3c, 0x0a, 0x0c, 0x6d, 0x69, 0x6e,
	0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x6d, 0x69, 0x6e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7c, 0x0a, 0x0c, 0x52, 0x6f, 0x6c, 0x6c, 0x6f,
	0x75, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x74, 0x65, 0x70, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x73, 0x74, 0x65, 0x70, 0x12, 0x1d, 0x0a, 0x0a, 0x73,
	0x74, 0x65, 0x70, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x09, 0x73, 0x74, 0x65, 0x70, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x9a, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x12, 0x24, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0x8e, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x78, 0x70, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4b,
	0x0a, 0x0b, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78,
	0x2e, 0x76, 0x33, 0x2e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0b,
	0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x58, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x26, 0x0a, 0x24, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xaf, 0x01,
	0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x26, 0x12, 0x24, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x4e, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78,
	0x2e, 0x76, 0x33, 0x2e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x22,
	0xab, 0x01, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x0a, 0x65,
	0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e,
	0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0a, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x5b, 0x0a,
	0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x5a, 0x0a, 0x16, 0x53, 0x74,
	0x61, 0x72, 0x74, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x59, 0x0a, 0x15, 0x53, 0x74, 0x6f, 0x70, 0x45, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x32, 0xf8, 0x0c, 0x0a, 0x0b, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x12, 0xda, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x58, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x49, 0x12, 0x47, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0xc7,
	0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x2e, 0x47, 0x65, 0x74, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x22, 0x56, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49, 0x12,
	0x47, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x76, 0x69, 0x72,
	0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe6, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x22, 0x6f, 0xda, 0x41, 0x11, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x65, 0x78, 0x70, 0x65,
	0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x55, 0x3a, 0x0a, 0x65, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x47, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x12, 0xf6, 0x01, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x78, 0x70, 0x65,
	0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x45,
	0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x7f, 0xda, 0x41, 0x16, 0x65, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x60, 0x3a, 0x0a, 0x65, 0x78, 0x70, 0x65,
	0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x32, 0x52, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x65, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x76,
	0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x70, 0x65,
	0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xba, 0x01, 0x0a, 0x10, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22,
	0x56, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49, 0x2a, 0x47,
	0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd4, 0x01, 0x0a, 0x0f, 0x53, 0x74, 0x61, 0x72,
	0x74, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x53, 0x74, 0x61, 0x72,
	0x74, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x2e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x5f, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x52, 0x3a, 0x01, 0x2a, 0x22,
	0x4d, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x76, 0x69, 0x72,
	0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12, 0xd1,
	0x01, 0x0a, 0x0e, 0x53, 0x74, 0x6f, 0x70, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x2e, 0x53, 0x74, 0x6f, 0x70, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0x22, 0x5e, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x51, 0x3a, 0x01, 0x2a, 0x22, 0x4c, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x65,
	0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x74,
	0x6f, 0x70, 0x1a, 0x78, 0xca, 0x41, 0x19, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0xd2, 0x41, 0x59, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x42, 0xb5, 0x01, 0x0a,
	0x21, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x42, 0x0f, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x31, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x33, 0x2f, 0x63,
	0x78, 0x70, 0x62, 0x3b, 0x63, 0x78, 0x70, 0x62, 0xf8, 0x01, 0x01, 0xa2, 0x02, 0x02, 0x44, 0x46,
	0xaa, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x43, 0x78, 0x2e, 0x56, 0x33,
	0xea, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x3a, 0x3a, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x3a, 0x3a, 0x43, 0x58,
	0x3a, 0x3a, 0x56, 0x33, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dialogflow_cx_v3_experiment_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_cx_v3_experiment_proto_rawDescData = file_google_cloud_dialogflow_cx_v3_experiment_proto_rawDesc
)

func file_google_cloud_dialogflow_cx_v3_experiment_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_cx_v3_experiment_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_cx_v3_experiment_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_cx_v3_experiment_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_cx_v3_experiment_proto_rawDescData
}

var file_google_cloud_dialogflow_cx_v3_experiment_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes = make([]protoimpl.MessageInfo, 20)
var file_google_cloud_dialogflow_cx_v3_experiment_proto_goTypes = []any{
	(Experiment_State)(0),                        // 0: google.cloud.dialogflow.cx.v3.Experiment.State
	(Experiment_Result_MetricType)(0),            // 1: google.cloud.dialogflow.cx.v3.Experiment.Result.MetricType
	(Experiment_Result_CountType)(0),             // 2: google.cloud.dialogflow.cx.v3.Experiment.Result.CountType
	(*Experiment)(nil),                           // 3: google.cloud.dialogflow.cx.v3.Experiment
	(*VersionVariants)(nil),                      // 4: google.cloud.dialogflow.cx.v3.VersionVariants
	(*VariantsHistory)(nil),                      // 5: google.cloud.dialogflow.cx.v3.VariantsHistory
	(*RolloutConfig)(nil),                        // 6: google.cloud.dialogflow.cx.v3.RolloutConfig
	(*RolloutState)(nil),                         // 7: google.cloud.dialogflow.cx.v3.RolloutState
	(*ListExperimentsRequest)(nil),               // 8: google.cloud.dialogflow.cx.v3.ListExperimentsRequest
	(*ListExperimentsResponse)(nil),              // 9: google.cloud.dialogflow.cx.v3.ListExperimentsResponse
	(*GetExperimentRequest)(nil),                 // 10: google.cloud.dialogflow.cx.v3.GetExperimentRequest
	(*CreateExperimentRequest)(nil),              // 11: google.cloud.dialogflow.cx.v3.CreateExperimentRequest
	(*UpdateExperimentRequest)(nil),              // 12: google.cloud.dialogflow.cx.v3.UpdateExperimentRequest
	(*DeleteExperimentRequest)(nil),              // 13: google.cloud.dialogflow.cx.v3.DeleteExperimentRequest
	(*StartExperimentRequest)(nil),               // 14: google.cloud.dialogflow.cx.v3.StartExperimentRequest
	(*StopExperimentRequest)(nil),                // 15: google.cloud.dialogflow.cx.v3.StopExperimentRequest
	(*Experiment_Definition)(nil),                // 16: google.cloud.dialogflow.cx.v3.Experiment.Definition
	(*Experiment_Result)(nil),                    // 17: google.cloud.dialogflow.cx.v3.Experiment.Result
	(*Experiment_Result_ConfidenceInterval)(nil), // 18: google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval
	(*Experiment_Result_Metric)(nil),             // 19: google.cloud.dialogflow.cx.v3.Experiment.Result.Metric
	(*Experiment_Result_VersionMetrics)(nil),     // 20: google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics
	(*VersionVariants_Variant)(nil),              // 21: google.cloud.dialogflow.cx.v3.VersionVariants.Variant
	(*RolloutConfig_RolloutStep)(nil),            // 22: google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep
	(*timestamppb.Timestamp)(nil),                // 23: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),                  // 24: google.protobuf.Duration
	(*fieldmaskpb.FieldMask)(nil),                // 25: google.protobuf.FieldMask
	(*emptypb.Empty)(nil),                        // 26: google.protobuf.Empty
}
var file_google_cloud_dialogflow_cx_v3_experiment_proto_depIdxs = []int32{
	0,  // 0: google.cloud.dialogflow.cx.v3.Experiment.state:type_name -> google.cloud.dialogflow.cx.v3.Experiment.State
	16, // 1: google.cloud.dialogflow.cx.v3.Experiment.definition:type_name -> google.cloud.dialogflow.cx.v3.Experiment.Definition
	6,  // 2: google.cloud.dialogflow.cx.v3.Experiment.rollout_config:type_name -> google.cloud.dialogflow.cx.v3.RolloutConfig
	7,  // 3: google.cloud.dialogflow.cx.v3.Experiment.rollout_state:type_name -> google.cloud.dialogflow.cx.v3.RolloutState
	17, // 4: google.cloud.dialogflow.cx.v3.Experiment.result:type_name -> google.cloud.dialogflow.cx.v3.Experiment.Result
	23, // 5: google.cloud.dialogflow.cx.v3.Experiment.create_time:type_name -> google.protobuf.Timestamp
	23, // 6: google.cloud.dialogflow.cx.v3.Experiment.start_time:type_name -> google.protobuf.Timestamp
	23, // 7: google.cloud.dialogflow.cx.v3.Experiment.end_time:type_name -> google.protobuf.Timestamp
	23, // 8: google.cloud.dialogflow.cx.v3.Experiment.last_update_time:type_name -> google.protobuf.Timestamp
	24, // 9: google.cloud.dialogflow.cx.v3.Experiment.experiment_length:type_name -> google.protobuf.Duration
	5,  // 10: google.cloud.dialogflow.cx.v3.Experiment.variants_history:type_name -> google.cloud.dialogflow.cx.v3.VariantsHistory
	21, // 11: google.cloud.dialogflow.cx.v3.VersionVariants.variants:type_name -> google.cloud.dialogflow.cx.v3.VersionVariants.Variant
	4,  // 12: google.cloud.dialogflow.cx.v3.VariantsHistory.version_variants:type_name -> google.cloud.dialogflow.cx.v3.VersionVariants
	23, // 13: google.cloud.dialogflow.cx.v3.VariantsHistory.update_time:type_name -> google.protobuf.Timestamp
	22, // 14: google.cloud.dialogflow.cx.v3.RolloutConfig.rollout_steps:type_name -> google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep
	23, // 15: google.cloud.dialogflow.cx.v3.RolloutState.start_time:type_name -> google.protobuf.Timestamp
	3,  // 16: google.cloud.dialogflow.cx.v3.ListExperimentsResponse.experiments:type_name -> google.cloud.dialogflow.cx.v3.Experiment
	3,  // 17: google.cloud.dialogflow.cx.v3.CreateExperimentRequest.experiment:type_name -> google.cloud.dialogflow.cx.v3.Experiment
	3,  // 18: google.cloud.dialogflow.cx.v3.UpdateExperimentRequest.experiment:type_name -> google.cloud.dialogflow.cx.v3.Experiment
	25, // 19: google.cloud.dialogflow.cx.v3.UpdateExperimentRequest.update_mask:type_name -> google.protobuf.FieldMask
	4,  // 20: google.cloud.dialogflow.cx.v3.Experiment.Definition.version_variants:type_name -> google.cloud.dialogflow.cx.v3.VersionVariants
	20, // 21: google.cloud.dialogflow.cx.v3.Experiment.Result.version_metrics:type_name -> google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics
	23, // 22: google.cloud.dialogflow.cx.v3.Experiment.Result.last_update_time:type_name -> google.protobuf.Timestamp
	1,  // 23: google.cloud.dialogflow.cx.v3.Experiment.Result.Metric.type:type_name -> google.cloud.dialogflow.cx.v3.Experiment.Result.MetricType
	2,  // 24: google.cloud.dialogflow.cx.v3.Experiment.Result.Metric.count_type:type_name -> google.cloud.dialogflow.cx.v3.Experiment.Result.CountType
	18, // 25: google.cloud.dialogflow.cx.v3.Experiment.Result.Metric.confidence_interval:type_name -> google.cloud.dialogflow.cx.v3.Experiment.Result.ConfidenceInterval
	19, // 26: google.cloud.dialogflow.cx.v3.Experiment.Result.VersionMetrics.metrics:type_name -> google.cloud.dialogflow.cx.v3.Experiment.Result.Metric
	24, // 27: google.cloud.dialogflow.cx.v3.RolloutConfig.RolloutStep.min_duration:type_name -> google.protobuf.Duration
	8,  // 28: google.cloud.dialogflow.cx.v3.Experiments.ListExperiments:input_type -> google.cloud.dialogflow.cx.v3.ListExperimentsRequest
	10, // 29: google.cloud.dialogflow.cx.v3.Experiments.GetExperiment:input_type -> google.cloud.dialogflow.cx.v3.GetExperimentRequest
	11, // 30: google.cloud.dialogflow.cx.v3.Experiments.CreateExperiment:input_type -> google.cloud.dialogflow.cx.v3.CreateExperimentRequest
	12, // 31: google.cloud.dialogflow.cx.v3.Experiments.UpdateExperiment:input_type -> google.cloud.dialogflow.cx.v3.UpdateExperimentRequest
	13, // 32: google.cloud.dialogflow.cx.v3.Experiments.DeleteExperiment:input_type -> google.cloud.dialogflow.cx.v3.DeleteExperimentRequest
	14, // 33: google.cloud.dialogflow.cx.v3.Experiments.StartExperiment:input_type -> google.cloud.dialogflow.cx.v3.StartExperimentRequest
	15, // 34: google.cloud.dialogflow.cx.v3.Experiments.StopExperiment:input_type -> google.cloud.dialogflow.cx.v3.StopExperimentRequest
	9,  // 35: google.cloud.dialogflow.cx.v3.Experiments.ListExperiments:output_type -> google.cloud.dialogflow.cx.v3.ListExperimentsResponse
	3,  // 36: google.cloud.dialogflow.cx.v3.Experiments.GetExperiment:output_type -> google.cloud.dialogflow.cx.v3.Experiment
	3,  // 37: google.cloud.dialogflow.cx.v3.Experiments.CreateExperiment:output_type -> google.cloud.dialogflow.cx.v3.Experiment
	3,  // 38: google.cloud.dialogflow.cx.v3.Experiments.UpdateExperiment:output_type -> google.cloud.dialogflow.cx.v3.Experiment
	26, // 39: google.cloud.dialogflow.cx.v3.Experiments.DeleteExperiment:output_type -> google.protobuf.Empty
	3,  // 40: google.cloud.dialogflow.cx.v3.Experiments.StartExperiment:output_type -> google.cloud.dialogflow.cx.v3.Experiment
	3,  // 41: google.cloud.dialogflow.cx.v3.Experiments.StopExperiment:output_type -> google.cloud.dialogflow.cx.v3.Experiment
	35, // [35:42] is the sub-list for method output_type
	28, // [28:35] is the sub-list for method input_type
	28, // [28:28] is the sub-list for extension type_name
	28, // [28:28] is the sub-list for extension extendee
	0,  // [0:28] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_cx_v3_experiment_proto_init() }
func file_google_cloud_dialogflow_cx_v3_experiment_proto_init() {
	if File_google_cloud_dialogflow_cx_v3_experiment_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*Experiment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*VersionVariants); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*VariantsHistory); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*RolloutConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*RolloutState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*ListExperimentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*ListExperimentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*GetExperimentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*CreateExperimentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateExperimentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*DeleteExperimentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*StartExperimentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[12].Exporter = func(v any, i int) any {
			switch v := v.(*StopExperimentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[13].Exporter = func(v any, i int) any {
			switch v := v.(*Experiment_Definition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[14].Exporter = func(v any, i int) any {
			switch v := v.(*Experiment_Result); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[15].Exporter = func(v any, i int) any {
			switch v := v.(*Experiment_Result_ConfidenceInterval); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[16].Exporter = func(v any, i int) any {
			switch v := v.(*Experiment_Result_Metric); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[17].Exporter = func(v any, i int) any {
			switch v := v.(*Experiment_Result_VersionMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[18].Exporter = func(v any, i int) any {
			switch v := v.(*VersionVariants_Variant); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[19].Exporter = func(v any, i int) any {
			switch v := v.(*RolloutConfig_RolloutStep); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[2].OneofWrappers = []any{
		(*VariantsHistory_VersionVariants)(nil),
	}
	file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[13].OneofWrappers = []any{
		(*Experiment_Definition_VersionVariants)(nil),
	}
	file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes[16].OneofWrappers = []any{
		(*Experiment_Result_Metric_Ratio)(nil),
		(*Experiment_Result_Metric_Count)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_cx_v3_experiment_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   20,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dialogflow_cx_v3_experiment_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_cx_v3_experiment_proto_depIdxs,
		EnumInfos:         file_google_cloud_dialogflow_cx_v3_experiment_proto_enumTypes,
		MessageInfos:      file_google_cloud_dialogflow_cx_v3_experiment_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_cx_v3_experiment_proto = out.File
	file_google_cloud_dialogflow_cx_v3_experiment_proto_rawDesc = nil
	file_google_cloud_dialogflow_cx_v3_experiment_proto_goTypes = nil
	file_google_cloud_dialogflow_cx_v3_experiment_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ExperimentsClient is the client API for Experiments service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ExperimentsClient interface {
	// Returns the list of all experiments in the specified
	// [Environment][google.cloud.dialogflow.cx.v3.Environment].
	ListExperiments(ctx context.Context, in *ListExperimentsRequest, opts ...grpc.CallOption) (*ListExperimentsResponse, error)
	// Retrieves the specified
	// [Experiment][google.cloud.dialogflow.cx.v3.Experiment].
	GetExperiment(ctx context.Context, in *GetExperimentRequest, opts ...grpc.CallOption) (*Experiment, error)
	// Creates an [Experiment][google.cloud.dialogflow.cx.v3.Experiment] in the
	// specified [Environment][google.cloud.dialogflow.cx.v3.Environment].
	CreateExperiment(ctx context.Context, in *CreateExperimentRequest, opts ...grpc.CallOption) (*Experiment, error)
	// Updates the specified
	// [Experiment][google.cloud.dialogflow.cx.v3.Experiment].
	UpdateExperiment(ctx context.Context, in *UpdateExperimentRequest, opts ...grpc.CallOption) (*Experiment, error)
	// Deletes the specified
	// [Experiment][google.cloud.dialogflow.cx.v3.Experiment].
	DeleteExperiment(ctx context.Context, in *DeleteExperimentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Starts the specified
	// [Experiment][google.cloud.dialogflow.cx.v3.Experiment]. This rpc only
	// changes the state of experiment from PENDING to RUNNING.
	StartExperiment(ctx context.Context, in *StartExperimentRequest, opts ...grpc.CallOption) (*Experiment, error)
	// Stops the specified [Experiment][google.cloud.dialogflow.cx.v3.Experiment].
	// This rpc only changes the state of experiment from RUNNING to DONE.
	StopExperiment(ctx context.Context, in *StopExperimentRequest, opts ...grpc.CallOption) (*Experiment, error)
}

type experimentsClient struct {
	cc grpc.ClientConnInterface
}

func NewExperimentsClient(cc grpc.ClientConnInterface) ExperimentsClient {
	return &experimentsClient{cc}
}

func (c *experimentsClient) ListExperiments(ctx context.Context, in *ListExperimentsRequest, opts ...grpc.CallOption) (*ListExperimentsResponse, error) {
	out := new(ListExperimentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3.Experiments/ListExperiments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *experimentsClient) GetExperiment(ctx context.Context, in *GetExperimentRequest, opts ...grpc.CallOption) (*Experiment, error) {
	out := new(Experiment)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3.Experiments/GetExperiment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *experimentsClient) CreateExperiment(ctx context.Context, in *CreateExperimentRequest, opts ...grpc.CallOption) (*Experiment, error) {
	out := new(Experiment)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3.Experiments/CreateExperiment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *experimentsClient) UpdateExperiment(ctx context.Context, in *UpdateExperimentRequest, opts ...grpc.CallOption) (*Experiment, error) {
	out := new(Experiment)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3.Experiments/UpdateExperiment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *experimentsClient) DeleteExperiment(ctx context.Context, in *DeleteExperimentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3.Experiments/DeleteExperiment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *experimentsClient) StartExperiment(ctx context.Context, in *StartExperimentRequest, opts ...grpc.CallOption) (*Experiment, error) {
	out := new(Experiment)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3.Experiments/StartExperiment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *experimentsClient) StopExperiment(ctx context.Context, in *StopExperimentRequest, opts ...grpc.CallOption) (*Experiment, error) {
	out := new(Experiment)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.cx.v3.Experiments/StopExperiment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ExperimentsServer is the server API for Experiments service.
type ExperimentsServer interface {
	// Returns the list of all experiments in the specified
	// [Environment][google.cloud.dialogflow.cx.v3.Environment].
	ListExperiments(context.Context, *ListExperimentsRequest) (*ListExperimentsResponse, error)
	// Retrieves the specified
	// [Experiment][google.cloud.dialogflow.cx.v3.Experiment].
	GetExperiment(context.Context, *GetExperimentRequest) (*Experiment, error)
	// Creates an [Experiment][google.cloud.dialogflow.cx.v3.Experiment] in the
	// specified [Environment][google.cloud.dialogflow.cx.v3.Environment].
	CreateExperiment(context.Context, *CreateExperimentRequest) (*Experiment, error)
	// Updates the specified
	// [Experiment][google.cloud.dialogflow.cx.v3.Experiment].
	UpdateExperiment(context.Context, *UpdateExperimentRequest) (*Experiment, error)
	// Deletes the specified
	// [Experiment][google.cloud.dialogflow.cx.v3.Experiment].
	DeleteExperiment(context.Context, *DeleteExperimentRequest) (*emptypb.Empty, error)
	// Starts the specified
	// [Experiment][google.cloud.dialogflow.cx.v3.Experiment]. This rpc only
	// changes the state of experiment from PENDING to RUNNING.
	StartExperiment(context.Context, *StartExperimentRequest) (*Experiment, error)
	// Stops the specified [Experiment][google.cloud.dialogflow.cx.v3.Experiment].
	// This rpc only changes the state of experiment from RUNNING to DONE.
	StopExperiment(context.Context, *StopExperimentRequest) (*Experiment, error)
}

// UnimplementedExperimentsServer can be embedded to have forward compatible implementations.
type UnimplementedExperimentsServer struct {
}

func (*UnimplementedExperimentsServer) ListExperiments(context.Context, *ListExperimentsRequest) (*ListExperimentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListExperiments not implemented")
}
func (*UnimplementedExperimentsServer) GetExperiment(context.Context, *GetExperimentRequest) (*Experiment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetExperiment not implemented")
}
func (*UnimplementedExperimentsServer) CreateExperiment(context.Context, *CreateExperimentRequest) (*Experiment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateExperiment not implemented")
}
func (*UnimplementedExperimentsServer) UpdateExperiment(context.Context, *UpdateExperimentRequest) (*Experiment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateExperiment not implemented")
}
func (*UnimplementedExperimentsServer) DeleteExperiment(context.Context, *DeleteExperimentRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteExperiment not implemented")
}
func (*UnimplementedExperimentsServer) StartExperiment(context.Context, *StartExperimentRequest) (*Experiment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartExperiment not implemented")
}
func (*UnimplementedExperimentsServer) StopExperiment(context.Context, *StopExperimentRequest) (*Experiment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopExperiment not implemented")
}

func RegisterExperimentsServer(s *grpc.Server, srv ExperimentsServer) {
	s.RegisterService(&_Experiments_serviceDesc, srv)
}

func _Experiments_ListExperiments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListExperimentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExperimentsServer).ListExperiments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3.Experiments/ListExperiments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExperimentsServer).ListExperiments(ctx, req.(*ListExperimentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Experiments_GetExperiment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetExperimentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExperimentsServer).GetExperiment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3.Experiments/GetExperiment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExperimentsServer).GetExperiment(ctx, req.(*GetExperimentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Experiments_CreateExperiment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateExperimentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExperimentsServer).CreateExperiment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3.Experiments/CreateExperiment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExperimentsServer).CreateExperiment(ctx, req.(*CreateExperimentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Experiments_UpdateExperiment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateExperimentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExperimentsServer).UpdateExperiment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3.Experiments/UpdateExperiment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExperimentsServer).UpdateExperiment(ctx, req.(*UpdateExperimentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Experiments_DeleteExperiment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteExperimentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExperimentsServer).DeleteExperiment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3.Experiments/DeleteExperiment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExperimentsServer).DeleteExperiment(ctx, req.(*DeleteExperimentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Experiments_StartExperiment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartExperimentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExperimentsServer).StartExperiment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3.Experiments/StartExperiment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExperimentsServer).StartExperiment(ctx, req.(*StartExperimentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Experiments_StopExperiment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopExperimentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExperimentsServer).StopExperiment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.cx.v3.Experiments/StopExperiment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExperimentsServer).StopExperiment(ctx, req.(*StopExperimentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Experiments_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.cx.v3.Experiments",
	HandlerType: (*ExperimentsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListExperiments",
			Handler:    _Experiments_ListExperiments_Handler,
		},
		{
			MethodName: "GetExperiment",
			Handler:    _Experiments_GetExperiment_Handler,
		},
		{
			MethodName: "CreateExperiment",
			Handler:    _Experiments_CreateExperiment_Handler,
		},
		{
			MethodName: "UpdateExperiment",
			Handler:    _Experiments_UpdateExperiment_Handler,
		},
		{
			MethodName: "DeleteExperiment",
			Handler:    _Experiments_DeleteExperiment_Handler,
		},
		{
			MethodName: "StartExperiment",
			Handler:    _Experiments_StartExperiment_Handler,
		},
		{
			MethodName: "StopExperiment",
			Handler:    _Experiments_StopExperiment_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/cx/v3/experiment.proto",
}
