// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.21.5
// source: google/cloud/notebooks/v1/execution.proto

package notebookspb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Required. Specifies the machine types, the number of replicas for workers
// and parameter servers.
type ExecutionTemplate_ScaleTier int32

const (
	// Unspecified Scale Tier.
	ExecutionTemplate_SCALE_TIER_UNSPECIFIED ExecutionTemplate_ScaleTier = 0
	// A single worker instance. This tier is suitable for learning how to use
	// Cloud ML, and for experimenting with new models using small datasets.
	ExecutionTemplate_BASIC ExecutionTemplate_ScaleTier = 1
	// Many workers and a few parameter servers.
	ExecutionTemplate_STANDARD_1 ExecutionTemplate_ScaleTier = 2
	// A large number of workers with many parameter servers.
	ExecutionTemplate_PREMIUM_1 ExecutionTemplate_ScaleTier = 3
	// A single worker instance with a K80 GPU.
	ExecutionTemplate_BASIC_GPU ExecutionTemplate_ScaleTier = 4
	// A single worker instance with a Cloud TPU.
	ExecutionTemplate_BASIC_TPU ExecutionTemplate_ScaleTier = 5
	// The CUSTOM tier is not a set tier, but rather enables you to use your
	// own cluster specification. When you use this tier, set values to
	// configure your processing cluster according to these guidelines:
	//
	//   - You _must_ set `ExecutionTemplate.masterType` to specify the type
	//     of machine to use for your master node. This is the only required
	//     setting.
	ExecutionTemplate_CUSTOM ExecutionTemplate_ScaleTier = 6
)

// Enum value maps for ExecutionTemplate_ScaleTier.
var (
	ExecutionTemplate_ScaleTier_name = map[int32]string{
		0: "SCALE_TIER_UNSPECIFIED",
		1: "BASIC",
		2: "STANDARD_1",
		3: "PREMIUM_1",
		4: "BASIC_GPU",
		5: "BASIC_TPU",
		6: "CUSTOM",
	}
	ExecutionTemplate_ScaleTier_value = map[string]int32{
		"SCALE_TIER_UNSPECIFIED": 0,
		"BASIC":                  1,
		"STANDARD_1":             2,
		"PREMIUM_1":              3,
		"BASIC_GPU":              4,
		"BASIC_TPU":              5,
		"CUSTOM":                 6,
	}
)

func (x ExecutionTemplate_ScaleTier) Enum() *ExecutionTemplate_ScaleTier {
	p := new(ExecutionTemplate_ScaleTier)
	*p = x
	return p
}

func (x ExecutionTemplate_ScaleTier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExecutionTemplate_ScaleTier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_notebooks_v1_execution_proto_enumTypes[0].Descriptor()
}

func (ExecutionTemplate_ScaleTier) Type() protoreflect.EnumType {
	return &file_google_cloud_notebooks_v1_execution_proto_enumTypes[0]
}

func (x ExecutionTemplate_ScaleTier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExecutionTemplate_ScaleTier.Descriptor instead.
func (ExecutionTemplate_ScaleTier) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_execution_proto_rawDescGZIP(), []int{0, 0}
}

// Hardware accelerator types for AI Platform Training jobs.
type ExecutionTemplate_SchedulerAcceleratorType int32

const (
	// Unspecified accelerator type. Default to no GPU.
	ExecutionTemplate_SCHEDULER_ACCELERATOR_TYPE_UNSPECIFIED ExecutionTemplate_SchedulerAcceleratorType = 0
	// Nvidia Tesla K80 GPU.
	ExecutionTemplate_NVIDIA_TESLA_K80 ExecutionTemplate_SchedulerAcceleratorType = 1
	// Nvidia Tesla P100 GPU.
	ExecutionTemplate_NVIDIA_TESLA_P100 ExecutionTemplate_SchedulerAcceleratorType = 2
	// Nvidia Tesla V100 GPU.
	ExecutionTemplate_NVIDIA_TESLA_V100 ExecutionTemplate_SchedulerAcceleratorType = 3
	// Nvidia Tesla P4 GPU.
	ExecutionTemplate_NVIDIA_TESLA_P4 ExecutionTemplate_SchedulerAcceleratorType = 4
	// Nvidia Tesla T4 GPU.
	ExecutionTemplate_NVIDIA_TESLA_T4 ExecutionTemplate_SchedulerAcceleratorType = 5
	// Nvidia Tesla A100 GPU.
	ExecutionTemplate_NVIDIA_TESLA_A100 ExecutionTemplate_SchedulerAcceleratorType = 10
	// TPU v2.
	ExecutionTemplate_TPU_V2 ExecutionTemplate_SchedulerAcceleratorType = 6
	// TPU v3.
	ExecutionTemplate_TPU_V3 ExecutionTemplate_SchedulerAcceleratorType = 7
)

// Enum value maps for ExecutionTemplate_SchedulerAcceleratorType.
var (
	ExecutionTemplate_SchedulerAcceleratorType_name = map[int32]string{
		0:  "SCHEDULER_ACCELERATOR_TYPE_UNSPECIFIED",
		1:  "NVIDIA_TESLA_K80",
		2:  "NVIDIA_TESLA_P100",
		3:  "NVIDIA_TESLA_V100",
		4:  "NVIDIA_TESLA_P4",
		5:  "NVIDIA_TESLA_T4",
		10: "NVIDIA_TESLA_A100",
		6:  "TPU_V2",
		7:  "TPU_V3",
	}
	ExecutionTemplate_SchedulerAcceleratorType_value = map[string]int32{
		"SCHEDULER_ACCELERATOR_TYPE_UNSPECIFIED": 0,
		"NVIDIA_TESLA_K80":                       1,
		"NVIDIA_TESLA_P100":                      2,
		"NVIDIA_TESLA_V100":                      3,
		"NVIDIA_TESLA_P4":                        4,
		"NVIDIA_TESLA_T4":                        5,
		"NVIDIA_TESLA_A100":                      10,
		"TPU_V2":                                 6,
		"TPU_V3":                                 7,
	}
)

func (x ExecutionTemplate_SchedulerAcceleratorType) Enum() *ExecutionTemplate_SchedulerAcceleratorType {
	p := new(ExecutionTemplate_SchedulerAcceleratorType)
	*p = x
	return p
}

func (x ExecutionTemplate_SchedulerAcceleratorType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExecutionTemplate_SchedulerAcceleratorType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_notebooks_v1_execution_proto_enumTypes[1].Descriptor()
}

func (ExecutionTemplate_SchedulerAcceleratorType) Type() protoreflect.EnumType {
	return &file_google_cloud_notebooks_v1_execution_proto_enumTypes[1]
}

func (x ExecutionTemplate_SchedulerAcceleratorType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExecutionTemplate_SchedulerAcceleratorType.Descriptor instead.
func (ExecutionTemplate_SchedulerAcceleratorType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_execution_proto_rawDescGZIP(), []int{0, 1}
}

// The backend used for this execution.
type ExecutionTemplate_JobType int32

const (
	// No type specified.
	ExecutionTemplate_JOB_TYPE_UNSPECIFIED ExecutionTemplate_JobType = 0
	// Custom Job in `aiplatform.googleapis.com`.
	// Default value for an execution.
	ExecutionTemplate_VERTEX_AI ExecutionTemplate_JobType = 1
	// Run execution on a cluster with Dataproc as a job.
	// https://cloud.google.com/dataproc/docs/reference/rest/v1/projects.regions.jobs
	ExecutionTemplate_DATAPROC ExecutionTemplate_JobType = 2
)

// Enum value maps for ExecutionTemplate_JobType.
var (
	ExecutionTemplate_JobType_name = map[int32]string{
		0: "JOB_TYPE_UNSPECIFIED",
		1: "VERTEX_AI",
		2: "DATAPROC",
	}
	ExecutionTemplate_JobType_value = map[string]int32{
		"JOB_TYPE_UNSPECIFIED": 0,
		"VERTEX_AI":            1,
		"DATAPROC":             2,
	}
)

func (x ExecutionTemplate_JobType) Enum() *ExecutionTemplate_JobType {
	p := new(ExecutionTemplate_JobType)
	*p = x
	return p
}

func (x ExecutionTemplate_JobType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExecutionTemplate_JobType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_notebooks_v1_execution_proto_enumTypes[2].Descriptor()
}

func (ExecutionTemplate_JobType) Type() protoreflect.EnumType {
	return &file_google_cloud_notebooks_v1_execution_proto_enumTypes[2]
}

func (x ExecutionTemplate_JobType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExecutionTemplate_JobType.Descriptor instead.
func (ExecutionTemplate_JobType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_execution_proto_rawDescGZIP(), []int{0, 2}
}

// Enum description of the state of the underlying AIP job.
type Execution_State int32

const (
	// The job state is unspecified.
	Execution_STATE_UNSPECIFIED Execution_State = 0
	// The job has been just created and processing has not yet begun.
	Execution_QUEUED Execution_State = 1
	// The service is preparing to execution the job.
	Execution_PREPARING Execution_State = 2
	// The job is in progress.
	Execution_RUNNING Execution_State = 3
	// The job completed successfully.
	Execution_SUCCEEDED Execution_State = 4
	// The job failed.
	// `error_message` should contain the details of the failure.
	Execution_FAILED Execution_State = 5
	// The job is being cancelled.
	// `error_message` should describe the reason for the cancellation.
	Execution_CANCELLING Execution_State = 6
	// The job has been cancelled.
	// `error_message` should describe the reason for the cancellation.
	Execution_CANCELLED Execution_State = 7
	// The job has become expired (relevant to Vertex AI jobs)
	// https://cloud.google.com/vertex-ai/docs/reference/rest/v1/JobState
	Execution_EXPIRED Execution_State = 9
	// The Execution is being created.
	Execution_INITIALIZING Execution_State = 10
)

// Enum value maps for Execution_State.
var (
	Execution_State_name = map[int32]string{
		0:  "STATE_UNSPECIFIED",
		1:  "QUEUED",
		2:  "PREPARING",
		3:  "RUNNING",
		4:  "SUCCEEDED",
		5:  "FAILED",
		6:  "CANCELLING",
		7:  "CANCELLED",
		9:  "EXPIRED",
		10: "INITIALIZING",
	}
	Execution_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"QUEUED":            1,
		"PREPARING":         2,
		"RUNNING":           3,
		"SUCCEEDED":         4,
		"FAILED":            5,
		"CANCELLING":        6,
		"CANCELLED":         7,
		"EXPIRED":           9,
		"INITIALIZING":      10,
	}
)

func (x Execution_State) Enum() *Execution_State {
	p := new(Execution_State)
	*p = x
	return p
}

func (x Execution_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Execution_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_notebooks_v1_execution_proto_enumTypes[3].Descriptor()
}

func (Execution_State) Type() protoreflect.EnumType {
	return &file_google_cloud_notebooks_v1_execution_proto_enumTypes[3]
}

func (x Execution_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Execution_State.Descriptor instead.
func (Execution_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_execution_proto_rawDescGZIP(), []int{1, 0}
}

// The description a notebook execution workload.
type ExecutionTemplate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Scale tier of the hardware used for notebook execution.
	// DEPRECATED Will be discontinued. As right now only CUSTOM is supported.
	//
	// Deprecated: Do not use.
	ScaleTier ExecutionTemplate_ScaleTier `protobuf:"varint,1,opt,name=scale_tier,json=scaleTier,proto3,enum=google.cloud.notebooks.v1.ExecutionTemplate_ScaleTier" json:"scale_tier,omitempty"`
	// Specifies the type of virtual machine to use for your training
	// job's master worker. You must specify this field when `scaleTier` is set to
	// `CUSTOM`.
	//
	// You can use certain Compute Engine machine types directly in this field.
	// The following types are supported:
	//
	// - `n1-standard-4`
	// - `n1-standard-8`
	// - `n1-standard-16`
	// - `n1-standard-32`
	// - `n1-standard-64`
	// - `n1-standard-96`
	// - `n1-highmem-2`
	// - `n1-highmem-4`
	// - `n1-highmem-8`
	// - `n1-highmem-16`
	// - `n1-highmem-32`
	// - `n1-highmem-64`
	// - `n1-highmem-96`
	// - `n1-highcpu-16`
	// - `n1-highcpu-32`
	// - `n1-highcpu-64`
	// - `n1-highcpu-96`
	//
	// Alternatively, you can use the following legacy machine types:
	//
	// - `standard`
	// - `large_model`
	// - `complex_model_s`
	// - `complex_model_m`
	// - `complex_model_l`
	// - `standard_gpu`
	// - `complex_model_m_gpu`
	// - `complex_model_l_gpu`
	// - `standard_p100`
	// - `complex_model_m_p100`
	// - `standard_v100`
	// - `large_model_v100`
	// - `complex_model_m_v100`
	// - `complex_model_l_v100`
	//
	// Finally, if you want to use a TPU for training, specify `cloud_tpu` in this
	// field. Learn more about the [special configuration options for training
	// with
	// TPU](https://cloud.google.com/ai-platform/training/docs/using-tpus#configuring_a_custom_tpu_machine).
	MasterType string `protobuf:"bytes,2,opt,name=master_type,json=masterType,proto3" json:"master_type,omitempty"`
	// Configuration (count and accelerator type) for hardware running notebook
	// execution.
	AcceleratorConfig *ExecutionTemplate_SchedulerAcceleratorConfig `protobuf:"bytes,3,opt,name=accelerator_config,json=acceleratorConfig,proto3" json:"accelerator_config,omitempty"`
	// Labels for execution.
	// If execution is scheduled, a field included will be 'nbs-scheduled'.
	// Otherwise, it is an immediate execution, and an included field will be
	// 'nbs-immediate'. Use fields to efficiently index between various types of
	// executions.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Path to the notebook file to execute.
	// Must be in a Google Cloud Storage bucket.
	// Format: `gs://{bucket_name}/{folder}/{notebook_file_name}`
	// Ex: `gs://notebook_user/scheduled_notebooks/sentiment_notebook.ipynb`
	InputNotebookFile string `protobuf:"bytes,5,opt,name=input_notebook_file,json=inputNotebookFile,proto3" json:"input_notebook_file,omitempty"`
	// Container Image URI to a DLVM
	// Example: 'gcr.io/deeplearning-platform-release/base-cu100'
	// More examples can be found at:
	// https://cloud.google.com/ai-platform/deep-learning-containers/docs/choosing-container
	ContainerImageUri string `protobuf:"bytes,6,opt,name=container_image_uri,json=containerImageUri,proto3" json:"container_image_uri,omitempty"`
	// Path to the notebook folder to write to.
	// Must be in a Google Cloud Storage bucket path.
	// Format: `gs://{bucket_name}/{folder}`
	// Ex: `gs://notebook_user/scheduled_notebooks`
	OutputNotebookFolder string `protobuf:"bytes,7,opt,name=output_notebook_folder,json=outputNotebookFolder,proto3" json:"output_notebook_folder,omitempty"`
	// Parameters to be overridden in the notebook during execution.
	// Ref https://papermill.readthedocs.io/en/latest/usage-parameterize.html on
	// how to specifying parameters in the input notebook and pass them here
	// in an YAML file.
	// Ex: `gs://notebook_user/scheduled_notebooks/sentiment_notebook_params.yaml`
	ParamsYamlFile string `protobuf:"bytes,8,opt,name=params_yaml_file,json=paramsYamlFile,proto3" json:"params_yaml_file,omitempty"`
	// Parameters used within the 'input_notebook_file' notebook.
	Parameters string `protobuf:"bytes,9,opt,name=parameters,proto3" json:"parameters,omitempty"`
	// The email address of a service account to use when running the execution.
	// You must have the `iam.serviceAccounts.actAs` permission for the specified
	// service account.
	ServiceAccount string `protobuf:"bytes,10,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// The type of Job to be used on this execution.
	JobType ExecutionTemplate_JobType `protobuf:"varint,11,opt,name=job_type,json=jobType,proto3,enum=google.cloud.notebooks.v1.ExecutionTemplate_JobType" json:"job_type,omitempty"`
	// Parameters for an execution type.
	// NOTE: There are currently no extra parameters for VertexAI jobs.
	//
	// Types that are assignable to JobParameters:
	//
	//	*ExecutionTemplate_DataprocParameters_
	//	*ExecutionTemplate_VertexAiParameters
	JobParameters isExecutionTemplate_JobParameters `protobuf_oneof:"job_parameters"`
	// Name of the kernel spec to use. This must be specified if the
	// kernel spec name on the execution target does not match the name in the
	// input notebook file.
	KernelSpec string `protobuf:"bytes,14,opt,name=kernel_spec,json=kernelSpec,proto3" json:"kernel_spec,omitempty"`
	// The name of a Vertex AI [Tensorboard] resource to which this execution
	// will upload Tensorboard logs.
	// Format:
	// `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
	Tensorboard string `protobuf:"bytes,15,opt,name=tensorboard,proto3" json:"tensorboard,omitempty"`
}

func (x *ExecutionTemplate) Reset() {
	*x = ExecutionTemplate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_notebooks_v1_execution_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutionTemplate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutionTemplate) ProtoMessage() {}

func (x *ExecutionTemplate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v1_execution_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutionTemplate.ProtoReflect.Descriptor instead.
func (*ExecutionTemplate) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_execution_proto_rawDescGZIP(), []int{0}
}

// Deprecated: Do not use.
func (x *ExecutionTemplate) GetScaleTier() ExecutionTemplate_ScaleTier {
	if x != nil {
		return x.ScaleTier
	}
	return ExecutionTemplate_SCALE_TIER_UNSPECIFIED
}

func (x *ExecutionTemplate) GetMasterType() string {
	if x != nil {
		return x.MasterType
	}
	return ""
}

func (x *ExecutionTemplate) GetAcceleratorConfig() *ExecutionTemplate_SchedulerAcceleratorConfig {
	if x != nil {
		return x.AcceleratorConfig
	}
	return nil
}

func (x *ExecutionTemplate) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ExecutionTemplate) GetInputNotebookFile() string {
	if x != nil {
		return x.InputNotebookFile
	}
	return ""
}

func (x *ExecutionTemplate) GetContainerImageUri() string {
	if x != nil {
		return x.ContainerImageUri
	}
	return ""
}

func (x *ExecutionTemplate) GetOutputNotebookFolder() string {
	if x != nil {
		return x.OutputNotebookFolder
	}
	return ""
}

func (x *ExecutionTemplate) GetParamsYamlFile() string {
	if x != nil {
		return x.ParamsYamlFile
	}
	return ""
}

func (x *ExecutionTemplate) GetParameters() string {
	if x != nil {
		return x.Parameters
	}
	return ""
}

func (x *ExecutionTemplate) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *ExecutionTemplate) GetJobType() ExecutionTemplate_JobType {
	if x != nil {
		return x.JobType
	}
	return ExecutionTemplate_JOB_TYPE_UNSPECIFIED
}

func (m *ExecutionTemplate) GetJobParameters() isExecutionTemplate_JobParameters {
	if m != nil {
		return m.JobParameters
	}
	return nil
}

func (x *ExecutionTemplate) GetDataprocParameters() *ExecutionTemplate_DataprocParameters {
	if x, ok := x.GetJobParameters().(*ExecutionTemplate_DataprocParameters_); ok {
		return x.DataprocParameters
	}
	return nil
}

func (x *ExecutionTemplate) GetVertexAiParameters() *ExecutionTemplate_VertexAIParameters {
	if x, ok := x.GetJobParameters().(*ExecutionTemplate_VertexAiParameters); ok {
		return x.VertexAiParameters
	}
	return nil
}

func (x *ExecutionTemplate) GetKernelSpec() string {
	if x != nil {
		return x.KernelSpec
	}
	return ""
}

func (x *ExecutionTemplate) GetTensorboard() string {
	if x != nil {
		return x.Tensorboard
	}
	return ""
}

type isExecutionTemplate_JobParameters interface {
	isExecutionTemplate_JobParameters()
}

type ExecutionTemplate_DataprocParameters_ struct {
	// Parameters used in Dataproc JobType executions.
	DataprocParameters *ExecutionTemplate_DataprocParameters `protobuf:"bytes,12,opt,name=dataproc_parameters,json=dataprocParameters,proto3,oneof"`
}

type ExecutionTemplate_VertexAiParameters struct {
	// Parameters used in Vertex AI JobType executions.
	VertexAiParameters *ExecutionTemplate_VertexAIParameters `protobuf:"bytes,13,opt,name=vertex_ai_parameters,json=vertexAiParameters,proto3,oneof"`
}

func (*ExecutionTemplate_DataprocParameters_) isExecutionTemplate_JobParameters() {}

func (*ExecutionTemplate_VertexAiParameters) isExecutionTemplate_JobParameters() {}

// The definition of a single executed notebook.
type Execution struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// execute metadata including name, hardware spec, region, labels, etc.
	ExecutionTemplate *ExecutionTemplate `protobuf:"bytes,1,opt,name=execution_template,json=executionTemplate,proto3" json:"execution_template,omitempty"`
	// Output only. The resource name of the execute. Format:
	// `projects/{project_id}/locations/{location}/executions/{execution_id}`
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Name used for UI purposes.
	// Name can only contain alphanumeric characters and underscores '_'.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// A brief description of this execution.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. Time the Execution was instantiated.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time the Execution was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. State of the underlying AI Platform job.
	State Execution_State `protobuf:"varint,7,opt,name=state,proto3,enum=google.cloud.notebooks.v1.Execution_State" json:"state,omitempty"`
	// Output notebook file generated by this execution
	OutputNotebookFile string `protobuf:"bytes,8,opt,name=output_notebook_file,json=outputNotebookFile,proto3" json:"output_notebook_file,omitempty"`
	// Output only. The URI of the external job used to execute the notebook.
	JobUri string `protobuf:"bytes,9,opt,name=job_uri,json=jobUri,proto3" json:"job_uri,omitempty"`
}

func (x *Execution) Reset() {
	*x = Execution{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_notebooks_v1_execution_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Execution) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Execution) ProtoMessage() {}

func (x *Execution) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v1_execution_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Execution.ProtoReflect.Descriptor instead.
func (*Execution) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_execution_proto_rawDescGZIP(), []int{1}
}

func (x *Execution) GetExecutionTemplate() *ExecutionTemplate {
	if x != nil {
		return x.ExecutionTemplate
	}
	return nil
}

func (x *Execution) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Execution) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Execution) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Execution) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Execution) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Execution) GetState() Execution_State {
	if x != nil {
		return x.State
	}
	return Execution_STATE_UNSPECIFIED
}

func (x *Execution) GetOutputNotebookFile() string {
	if x != nil {
		return x.OutputNotebookFile
	}
	return ""
}

func (x *Execution) GetJobUri() string {
	if x != nil {
		return x.JobUri
	}
	return ""
}

// Definition of a hardware accelerator. Note that not all combinations
// of `type` and `core_count` are valid. Check [GPUs on
// Compute Engine](https://cloud.google.com/compute/docs/gpus) to find a valid
// combination. TPUs are not supported.
type ExecutionTemplate_SchedulerAcceleratorConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of this accelerator.
	Type ExecutionTemplate_SchedulerAcceleratorType `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.notebooks.v1.ExecutionTemplate_SchedulerAcceleratorType" json:"type,omitempty"`
	// Count of cores of this accelerator.
	CoreCount int64 `protobuf:"varint,2,opt,name=core_count,json=coreCount,proto3" json:"core_count,omitempty"`
}

func (x *ExecutionTemplate_SchedulerAcceleratorConfig) Reset() {
	*x = ExecutionTemplate_SchedulerAcceleratorConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_notebooks_v1_execution_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutionTemplate_SchedulerAcceleratorConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutionTemplate_SchedulerAcceleratorConfig) ProtoMessage() {}

func (x *ExecutionTemplate_SchedulerAcceleratorConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v1_execution_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutionTemplate_SchedulerAcceleratorConfig.ProtoReflect.Descriptor instead.
func (*ExecutionTemplate_SchedulerAcceleratorConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_execution_proto_rawDescGZIP(), []int{0, 0}
}

func (x *ExecutionTemplate_SchedulerAcceleratorConfig) GetType() ExecutionTemplate_SchedulerAcceleratorType {
	if x != nil {
		return x.Type
	}
	return ExecutionTemplate_SCHEDULER_ACCELERATOR_TYPE_UNSPECIFIED
}

func (x *ExecutionTemplate_SchedulerAcceleratorConfig) GetCoreCount() int64 {
	if x != nil {
		return x.CoreCount
	}
	return 0
}

// Parameters used in Dataproc JobType executions.
type ExecutionTemplate_DataprocParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// URI for cluster used to run Dataproc execution.
	// Format: `projects/{PROJECT_ID}/regions/{REGION}/clusters/{CLUSTER_NAME}`
	Cluster string `protobuf:"bytes,1,opt,name=cluster,proto3" json:"cluster,omitempty"`
}

func (x *ExecutionTemplate_DataprocParameters) Reset() {
	*x = ExecutionTemplate_DataprocParameters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_notebooks_v1_execution_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutionTemplate_DataprocParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutionTemplate_DataprocParameters) ProtoMessage() {}

func (x *ExecutionTemplate_DataprocParameters) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v1_execution_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutionTemplate_DataprocParameters.ProtoReflect.Descriptor instead.
func (*ExecutionTemplate_DataprocParameters) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_execution_proto_rawDescGZIP(), []int{0, 1}
}

func (x *ExecutionTemplate_DataprocParameters) GetCluster() string {
	if x != nil {
		return x.Cluster
	}
	return ""
}

// Parameters used in Vertex AI JobType executions.
type ExecutionTemplate_VertexAIParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The full name of the Compute Engine
	// [network](/compute/docs/networks-and-firewalls#networks) to which the Job
	// should be peered. For example, `projects/12345/global/networks/myVPC`.
	// [Format](https://cloud.google.com/compute/docs/reference/rest/v1/networks/insert)
	// is of the form `projects/{project}/global/networks/{network}`.
	// Where {project} is a project number, as in `12345`, and {network} is a
	// network name.
	//
	// Private services access must already be configured for the network. If
	// left unspecified, the job is not peered with any network.
	Network string `protobuf:"bytes,1,opt,name=network,proto3" json:"network,omitempty"`
	// Environment variables.
	//
	//	At most 100 environment variables can be specified and unique.
	//
	// Example: GCP_BUCKET=gs://my-bucket/samples/
	Env map[string]string `protobuf:"bytes,2,rep,name=env,proto3" json:"env,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ExecutionTemplate_VertexAIParameters) Reset() {
	*x = ExecutionTemplate_VertexAIParameters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_notebooks_v1_execution_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutionTemplate_VertexAIParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutionTemplate_VertexAIParameters) ProtoMessage() {}

func (x *ExecutionTemplate_VertexAIParameters) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v1_execution_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutionTemplate_VertexAIParameters.ProtoReflect.Descriptor instead.
func (*ExecutionTemplate_VertexAIParameters) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1_execution_proto_rawDescGZIP(), []int{0, 2}
}

func (x *ExecutionTemplate_VertexAIParameters) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *ExecutionTemplate_VertexAIParameters) GetEnv() map[string]string {
	if x != nil {
		return x.Env
	}
	return nil
}

var File_google_cloud_notebooks_v1_execution_proto protoreflect.FileDescriptor

var file_google_cloud_notebooks_v1_execution_proto_rawDesc = []byte{
	0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e,
	0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f,
	0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0x8e, 0x0f, 0x0a, 0x11, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x5c, 0x0a, 0x0a, 0x73, 0x63, 0x61,
	0x6c, 0x65, 0x5f, 0x74, 0x69, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74,
	0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x53, 0x63, 0x61, 0x6c,
	0x65, 0x54, 0x69, 0x65, 0x72, 0x42, 0x05, 0x18, 0x01, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x73, 0x63,
	0x61, 0x6c, 0x65, 0x54, 0x69, 0x65, 0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x61, 0x73, 0x74, 0x65,
	0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6d, 0x61,
	0x73, 0x74, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x76, 0x0a, 0x12, 0x61, 0x63, 0x63, 0x65,
	0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x41, 0x63, 0x63, 0x65,
	0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x11, 0x61,
	0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x50, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x12, 0x2e, 0x0a, 0x13, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x6e, 0x6f, 0x74, 0x65,
	0x62, 0x6f, 0x6f, 0x6b, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x11, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x46, 0x69,
	0x6c, 0x65, 0x12, 0x2e, 0x0a, 0x13, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x11, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x55,
	0x72, 0x69, 0x12, 0x34, 0x0a, 0x16, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x6e, 0x6f, 0x74,
	0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x5f, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x14, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f,
	0x6f, 0x6b, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x12, 0x28, 0x0a, 0x10, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x73, 0x5f, 0x79, 0x61, 0x6d, 0x6c, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0e, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x59, 0x61, 0x6d, 0x6c, 0x46, 0x69,
	0x6c, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x4f, 0x0a, 0x08, 0x6a,
	0x6f, 0x62, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74,
	0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x4a, 0x6f, 0x62, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x07, 0x6a, 0x6f, 0x62, 0x54, 0x79, 0x70, 0x65, 0x12, 0x72, 0x0a, 0x13,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f,
	0x6b, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x48, 0x00, 0x52, 0x12, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x12, 0x73, 0x0a, 0x14, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x5f, 0x61, 0x69, 0x5f, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f,
	0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x56, 0x65, 0x72,
	0x74, 0x65, 0x78, 0x41, 0x49, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x48,
	0x00, 0x52, 0x12, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x41, 0x69, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x6b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x5f,
	0x73, 0x70, 0x65, 0x63, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6b, 0x65, 0x72, 0x6e,
	0x65, 0x6c, 0x53, 0x70, 0x65, 0x63, 0x12, 0x4c, 0x0a, 0x0b, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72,
	0x62, 0x6f, 0x61, 0x72, 0x64, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xfa, 0x41, 0x27,
	0x0a, 0x25, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65, 0x6e, 0x73,
	0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x52, 0x0b, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62,
	0x6f, 0x61, 0x72, 0x64, 0x1a, 0x96, 0x01, 0x0a, 0x1a, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c,
	0x65, 0x72, 0x41, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x59, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x2e,
	0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x41, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x63, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x09, 0x63, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x2e, 0x0a,
	0x12, 0x44, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x1a, 0xc2, 0x01,
	0x0a, 0x12, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x41, 0x49, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x5a,
	0x0a, 0x03, 0x65, 0x6e, 0x76, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62,
	0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78,
	0x41, 0x49, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x45, 0x6e, 0x76,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x03, 0x65, 0x6e, 0x76, 0x1a, 0x36, 0x0a, 0x08, 0x45, 0x6e,
	0x76, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x7b, 0x0a,
	0x09, 0x53, 0x63, 0x61, 0x6c, 0x65, 0x54, 0x69, 0x65, 0x72, 0x12, 0x1a, 0x0a, 0x16, 0x53, 0x43,
	0x41, 0x4c, 0x45, 0x5f, 0x54, 0x49, 0x45, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10,
	0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52, 0x44, 0x5f, 0x31, 0x10,
	0x02, 0x12, 0x0d, 0x0a, 0x09, 0x50, 0x52, 0x45, 0x4d, 0x49, 0x55, 0x4d, 0x5f, 0x31, 0x10, 0x03,
	0x12, 0x0d, 0x0a, 0x09, 0x42, 0x41, 0x53, 0x49, 0x43, 0x5f, 0x47, 0x50, 0x55, 0x10, 0x04, 0x12,
	0x0d, 0x0a, 0x09, 0x42, 0x41, 0x53, 0x49, 0x43, 0x5f, 0x54, 0x50, 0x55, 0x10, 0x05, 0x12, 0x0a,
	0x0a, 0x06, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x10, 0x06, 0x22, 0xe3, 0x01, 0x0a, 0x18, 0x53,
	0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x41, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61,
	0x74, 0x6f, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2a, 0x0a, 0x26, 0x53, 0x43, 0x48, 0x45, 0x44,
	0x55, 0x4c, 0x45, 0x52, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x4c, 0x45, 0x52, 0x41, 0x54, 0x4f, 0x52,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x4e, 0x56, 0x49, 0x44, 0x49, 0x41, 0x5f, 0x54, 0x45,
	0x53, 0x4c, 0x41, 0x5f, 0x4b, 0x38, 0x30, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x4e, 0x56, 0x49,
	0x44, 0x49, 0x41, 0x5f, 0x54, 0x45, 0x53, 0x4c, 0x41, 0x5f, 0x50, 0x31, 0x30, 0x30, 0x10, 0x02,
	0x12, 0x15, 0x0a, 0x11, 0x4e, 0x56, 0x49, 0x44, 0x49, 0x41, 0x5f, 0x54, 0x45, 0x53, 0x4c, 0x41,
	0x5f, 0x56, 0x31, 0x30, 0x30, 0x10, 0x03, 0x12, 0x13, 0x0a, 0x0f, 0x4e, 0x56, 0x49, 0x44, 0x49,
	0x41, 0x5f, 0x54, 0x45, 0x53, 0x4c, 0x41, 0x5f, 0x50, 0x34, 0x10, 0x04, 0x12, 0x13, 0x0a, 0x0f,
	0x4e, 0x56, 0x49, 0x44, 0x49, 0x41, 0x5f, 0x54, 0x45, 0x53, 0x4c, 0x41, 0x5f, 0x54, 0x34, 0x10,
	0x05, 0x12, 0x15, 0x0a, 0x11, 0x4e, 0x56, 0x49, 0x44, 0x49, 0x41, 0x5f, 0x54, 0x45, 0x53, 0x4c,
	0x41, 0x5f, 0x41, 0x31, 0x30, 0x30, 0x10, 0x0a, 0x12, 0x0a, 0x0a, 0x06, 0x54, 0x50, 0x55, 0x5f,
	0x56, 0x32, 0x10, 0x06, 0x12, 0x0a, 0x0a, 0x06, 0x54, 0x50, 0x55, 0x5f, 0x56, 0x33, 0x10, 0x07,
	0x22, 0x40, 0x0a, 0x07, 0x4a, 0x6f, 0x62, 0x54, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x14, 0x4a,
	0x4f, 0x42, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x56, 0x45, 0x52, 0x54, 0x45, 0x58, 0x5f,
	0x41, 0x49, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x41, 0x54, 0x41, 0x50, 0x52, 0x4f, 0x43,
	0x10, 0x02, 0x42, 0x10, 0x0a, 0x0e, 0x6a, 0x6f, 0x62, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x73, 0x22, 0xf0, 0x05, 0x0a, 0x09, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x5b, 0x0a, 0x12, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f,
	0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x11, 0x65, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12,
	0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x45, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x30, 0x0a,
	0x14, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b,
	0x5f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x46, 0x69, 0x6c, 0x65, 0x12,
	0x1c, 0x0a, 0x07, 0x6a, 0x6f, 0x62, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x6a, 0x6f, 0x62, 0x55, 0x72, 0x69, 0x22, 0x9f, 0x01,
	0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a,
	0x0a, 0x06, 0x51, 0x55, 0x45, 0x55, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x50, 0x52,
	0x45, 0x50, 0x41, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e,
	0x4e, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45,
	0x44, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10,
	0x05, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x10,
	0x06, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x07,
	0x12, 0x0b, 0x0a, 0x07, 0x45, 0x58, 0x50, 0x49, 0x52, 0x45, 0x44, 0x10, 0x09, 0x12, 0x10, 0x0a,
	0x0c, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41, 0x4c, 0x49, 0x5a, 0x49, 0x4e, 0x47, 0x10, 0x0a, 0x3a,
	0x66, 0xea, 0x41, 0x63, 0x0a, 0x22, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x65, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x42, 0xe3, 0x01, 0x0a, 0x1d, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74,
	0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x42, 0x0e, 0x45, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x42, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67,
	0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f,
	0x6b, 0x73, 0x2f, 0x76, 0x31, 0x3b, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0xea,
	0x41, 0x6b, 0x0a, 0x25, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65,
	0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x12, 0x42, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x73, 0x2f,
	0x7b, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x7d, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_notebooks_v1_execution_proto_rawDescOnce sync.Once
	file_google_cloud_notebooks_v1_execution_proto_rawDescData = file_google_cloud_notebooks_v1_execution_proto_rawDesc
)

func file_google_cloud_notebooks_v1_execution_proto_rawDescGZIP() []byte {
	file_google_cloud_notebooks_v1_execution_proto_rawDescOnce.Do(func() {
		file_google_cloud_notebooks_v1_execution_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_notebooks_v1_execution_proto_rawDescData)
	})
	return file_google_cloud_notebooks_v1_execution_proto_rawDescData
}

var file_google_cloud_notebooks_v1_execution_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_notebooks_v1_execution_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_google_cloud_notebooks_v1_execution_proto_goTypes = []interface{}{
	(ExecutionTemplate_ScaleTier)(0),                     // 0: google.cloud.notebooks.v1.ExecutionTemplate.ScaleTier
	(ExecutionTemplate_SchedulerAcceleratorType)(0),      // 1: google.cloud.notebooks.v1.ExecutionTemplate.SchedulerAcceleratorType
	(ExecutionTemplate_JobType)(0),                       // 2: google.cloud.notebooks.v1.ExecutionTemplate.JobType
	(Execution_State)(0),                                 // 3: google.cloud.notebooks.v1.Execution.State
	(*ExecutionTemplate)(nil),                            // 4: google.cloud.notebooks.v1.ExecutionTemplate
	(*Execution)(nil),                                    // 5: google.cloud.notebooks.v1.Execution
	(*ExecutionTemplate_SchedulerAcceleratorConfig)(nil), // 6: google.cloud.notebooks.v1.ExecutionTemplate.SchedulerAcceleratorConfig
	(*ExecutionTemplate_DataprocParameters)(nil),         // 7: google.cloud.notebooks.v1.ExecutionTemplate.DataprocParameters
	(*ExecutionTemplate_VertexAIParameters)(nil),         // 8: google.cloud.notebooks.v1.ExecutionTemplate.VertexAIParameters
	nil,                           // 9: google.cloud.notebooks.v1.ExecutionTemplate.LabelsEntry
	nil,                           // 10: google.cloud.notebooks.v1.ExecutionTemplate.VertexAIParameters.EnvEntry
	(*timestamppb.Timestamp)(nil), // 11: google.protobuf.Timestamp
}
var file_google_cloud_notebooks_v1_execution_proto_depIdxs = []int32{
	0,  // 0: google.cloud.notebooks.v1.ExecutionTemplate.scale_tier:type_name -> google.cloud.notebooks.v1.ExecutionTemplate.ScaleTier
	6,  // 1: google.cloud.notebooks.v1.ExecutionTemplate.accelerator_config:type_name -> google.cloud.notebooks.v1.ExecutionTemplate.SchedulerAcceleratorConfig
	9,  // 2: google.cloud.notebooks.v1.ExecutionTemplate.labels:type_name -> google.cloud.notebooks.v1.ExecutionTemplate.LabelsEntry
	2,  // 3: google.cloud.notebooks.v1.ExecutionTemplate.job_type:type_name -> google.cloud.notebooks.v1.ExecutionTemplate.JobType
	7,  // 4: google.cloud.notebooks.v1.ExecutionTemplate.dataproc_parameters:type_name -> google.cloud.notebooks.v1.ExecutionTemplate.DataprocParameters
	8,  // 5: google.cloud.notebooks.v1.ExecutionTemplate.vertex_ai_parameters:type_name -> google.cloud.notebooks.v1.ExecutionTemplate.VertexAIParameters
	4,  // 6: google.cloud.notebooks.v1.Execution.execution_template:type_name -> google.cloud.notebooks.v1.ExecutionTemplate
	11, // 7: google.cloud.notebooks.v1.Execution.create_time:type_name -> google.protobuf.Timestamp
	11, // 8: google.cloud.notebooks.v1.Execution.update_time:type_name -> google.protobuf.Timestamp
	3,  // 9: google.cloud.notebooks.v1.Execution.state:type_name -> google.cloud.notebooks.v1.Execution.State
	1,  // 10: google.cloud.notebooks.v1.ExecutionTemplate.SchedulerAcceleratorConfig.type:type_name -> google.cloud.notebooks.v1.ExecutionTemplate.SchedulerAcceleratorType
	10, // 11: google.cloud.notebooks.v1.ExecutionTemplate.VertexAIParameters.env:type_name -> google.cloud.notebooks.v1.ExecutionTemplate.VertexAIParameters.EnvEntry
	12, // [12:12] is the sub-list for method output_type
	12, // [12:12] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_google_cloud_notebooks_v1_execution_proto_init() }
func file_google_cloud_notebooks_v1_execution_proto_init() {
	if File_google_cloud_notebooks_v1_execution_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_notebooks_v1_execution_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutionTemplate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_notebooks_v1_execution_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Execution); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_notebooks_v1_execution_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutionTemplate_SchedulerAcceleratorConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_notebooks_v1_execution_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutionTemplate_DataprocParameters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_notebooks_v1_execution_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutionTemplate_VertexAIParameters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_notebooks_v1_execution_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*ExecutionTemplate_DataprocParameters_)(nil),
		(*ExecutionTemplate_VertexAiParameters)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_notebooks_v1_execution_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_notebooks_v1_execution_proto_goTypes,
		DependencyIndexes: file_google_cloud_notebooks_v1_execution_proto_depIdxs,
		EnumInfos:         file_google_cloud_notebooks_v1_execution_proto_enumTypes,
		MessageInfos:      file_google_cloud_notebooks_v1_execution_proto_msgTypes,
	}.Build()
	File_google_cloud_notebooks_v1_execution_proto = out.File
	file_google_cloud_notebooks_v1_execution_proto_rawDesc = nil
	file_google_cloud_notebooks_v1_execution_proto_goTypes = nil
	file_google_cloud_notebooks_v1_execution_proto_depIdxs = nil
}
