// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.21.5
// source: google/cloud/video/stitcher/v1/video_stitcher_service.proto

package stitcherpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for VideoStitcherService.createCdnKey.
type CreateCdnKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project in which the CDN key should be created, in the form of
	// `projects/{project_number}/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The CDN key resource to create.
	CdnKey *CdnKey `protobuf:"bytes,2,opt,name=cdn_key,json=cdnKey,proto3" json:"cdn_key,omitempty"`
	// Required. The ID to use for the CDN key, which will become the final component of
	// the CDN key's resource name.
	//
	// This value should conform to RFC-1034, which restricts to
	// lower-case letters, numbers, and hyphen, with the first character a
	// letter, the last a letter or a number, and a 63 character maximum.
	CdnKeyId string `protobuf:"bytes,3,opt,name=cdn_key_id,json=cdnKeyId,proto3" json:"cdn_key_id,omitempty"`
}

func (x *CreateCdnKeyRequest) Reset() {
	*x = CreateCdnKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateCdnKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCdnKeyRequest) ProtoMessage() {}

func (x *CreateCdnKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCdnKeyRequest.ProtoReflect.Descriptor instead.
func (*CreateCdnKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{0}
}

func (x *CreateCdnKeyRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateCdnKeyRequest) GetCdnKey() *CdnKey {
	if x != nil {
		return x.CdnKey
	}
	return nil
}

func (x *CreateCdnKeyRequest) GetCdnKeyId() string {
	if x != nil {
		return x.CdnKeyId
	}
	return ""
}

// Request message for VideoStitcherService.listCdnKeys.
type ListCdnKeysRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project that contains the list of CDN keys, in the form of
	// `projects/{project_number}/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. Server may return fewer items than requested.
	// If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filtering results
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Hint for how to order the results
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListCdnKeysRequest) Reset() {
	*x = ListCdnKeysRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCdnKeysRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCdnKeysRequest) ProtoMessage() {}

func (x *ListCdnKeysRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCdnKeysRequest.ProtoReflect.Descriptor instead.
func (*ListCdnKeysRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{1}
}

func (x *ListCdnKeysRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListCdnKeysRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCdnKeysRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListCdnKeysRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListCdnKeysRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for VideoStitcher.ListCdnKeys.
type ListCdnKeysResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of CDN keys.
	CdnKeys []*CdnKey `protobuf:"bytes,1,rep,name=cdn_keys,json=cdnKeys,proto3" json:"cdn_keys,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListCdnKeysResponse) Reset() {
	*x = ListCdnKeysResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCdnKeysResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCdnKeysResponse) ProtoMessage() {}

func (x *ListCdnKeysResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCdnKeysResponse.ProtoReflect.Descriptor instead.
func (*ListCdnKeysResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{2}
}

func (x *ListCdnKeysResponse) GetCdnKeys() []*CdnKey {
	if x != nil {
		return x.CdnKeys
	}
	return nil
}

func (x *ListCdnKeysResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListCdnKeysResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for VideoStitcherService.getCdnKey.
type GetCdnKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the CDN key to be retrieved, in the form of
	// `projects/{project}/locations/{location}/cdnKeys/{id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetCdnKeyRequest) Reset() {
	*x = GetCdnKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCdnKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCdnKeyRequest) ProtoMessage() {}

func (x *GetCdnKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCdnKeyRequest.ProtoReflect.Descriptor instead.
func (*GetCdnKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{3}
}

func (x *GetCdnKeyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for VideoStitcherService.deleteCdnKey.
type DeleteCdnKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the CDN key to be deleted, in the form of
	// `projects/{project_number}/locations/{location}/cdnKeys/{id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteCdnKeyRequest) Reset() {
	*x = DeleteCdnKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteCdnKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteCdnKeyRequest) ProtoMessage() {}

func (x *DeleteCdnKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteCdnKeyRequest.ProtoReflect.Descriptor instead.
func (*DeleteCdnKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{4}
}

func (x *DeleteCdnKeyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for VideoStitcherService.updateCdnKey.
type UpdateCdnKeyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The CDN key resource which replaces the resource on the server.
	CdnKey *CdnKey `protobuf:"bytes,1,opt,name=cdn_key,json=cdnKey,proto3" json:"cdn_key,omitempty"`
	// Required. The update mask applies to the resource.
	// For the `FieldMask` definition, see
	// https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateCdnKeyRequest) Reset() {
	*x = UpdateCdnKeyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateCdnKeyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCdnKeyRequest) ProtoMessage() {}

func (x *UpdateCdnKeyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCdnKeyRequest.ProtoReflect.Descriptor instead.
func (*UpdateCdnKeyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateCdnKeyRequest) GetCdnKey() *CdnKey {
	if x != nil {
		return x.CdnKey
	}
	return nil
}

func (x *UpdateCdnKeyRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for VideoStitcherService.createVodSession
type CreateVodSessionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location in which the VOD session should be created, in the
	// form of `projects/{project_number}/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Parameters for creating a session.
	VodSession *VodSession `protobuf:"bytes,2,opt,name=vod_session,json=vodSession,proto3" json:"vod_session,omitempty"`
}

func (x *CreateVodSessionRequest) Reset() {
	*x = CreateVodSessionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateVodSessionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateVodSessionRequest) ProtoMessage() {}

func (x *CreateVodSessionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateVodSessionRequest.ProtoReflect.Descriptor instead.
func (*CreateVodSessionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{6}
}

func (x *CreateVodSessionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateVodSessionRequest) GetVodSession() *VodSession {
	if x != nil {
		return x.VodSession
	}
	return nil
}

// Request message for VideoStitcherService.getVodSession
type GetVodSessionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the VOD session to be retrieved, in the form of
	// `projects/{project_number}/locations/{location}/vodSessions/{id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetVodSessionRequest) Reset() {
	*x = GetVodSessionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetVodSessionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetVodSessionRequest) ProtoMessage() {}

func (x *GetVodSessionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetVodSessionRequest.ProtoReflect.Descriptor instead.
func (*GetVodSessionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{7}
}

func (x *GetVodSessionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for VideoStitcherService.listVodStitchDetails.
type ListVodStitchDetailsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The VOD session where the stitch details belong to, in the form of
	// `projects/{project}/locations/{location}/vodSessions/{id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListVodStitchDetailsRequest) Reset() {
	*x = ListVodStitchDetailsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListVodStitchDetailsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVodStitchDetailsRequest) ProtoMessage() {}

func (x *ListVodStitchDetailsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVodStitchDetailsRequest.ProtoReflect.Descriptor instead.
func (*ListVodStitchDetailsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{8}
}

func (x *ListVodStitchDetailsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListVodStitchDetailsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListVodStitchDetailsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for VideoStitcherService.listVodStitchDetails.
type ListVodStitchDetailsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A List of stitch Details.
	VodStitchDetails []*VodStitchDetail `protobuf:"bytes,1,rep,name=vod_stitch_details,json=vodStitchDetails,proto3" json:"vod_stitch_details,omitempty"`
	// The pagination token.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListVodStitchDetailsResponse) Reset() {
	*x = ListVodStitchDetailsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListVodStitchDetailsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVodStitchDetailsResponse) ProtoMessage() {}

func (x *ListVodStitchDetailsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVodStitchDetailsResponse.ProtoReflect.Descriptor instead.
func (*ListVodStitchDetailsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{9}
}

func (x *ListVodStitchDetailsResponse) GetVodStitchDetails() []*VodStitchDetail {
	if x != nil {
		return x.VodStitchDetails
	}
	return nil
}

func (x *ListVodStitchDetailsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for VideoStitcherService.getVodStitchDetail.
type GetVodStitchDetailRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the stitch detail in the specified VOD session, in the form of
	// `projects/{project}/locations/{location}/vodSessions/{vod_session_id}/vodStitchDetails/{id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetVodStitchDetailRequest) Reset() {
	*x = GetVodStitchDetailRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetVodStitchDetailRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetVodStitchDetailRequest) ProtoMessage() {}

func (x *GetVodStitchDetailRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetVodStitchDetailRequest.ProtoReflect.Descriptor instead.
func (*GetVodStitchDetailRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{10}
}

func (x *GetVodStitchDetailRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for VideoStitcherService.listVodAdTagDetails.
type ListVodAdTagDetailsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The VOD session which the ad tag details belong to, in the form of
	// `projects/{project}/locations/{location}/vodSessions/{vod_session_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous List request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListVodAdTagDetailsRequest) Reset() {
	*x = ListVodAdTagDetailsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListVodAdTagDetailsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVodAdTagDetailsRequest) ProtoMessage() {}

func (x *ListVodAdTagDetailsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVodAdTagDetailsRequest.ProtoReflect.Descriptor instead.
func (*ListVodAdTagDetailsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{11}
}

func (x *ListVodAdTagDetailsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListVodAdTagDetailsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListVodAdTagDetailsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for VideoStitcherService.listVodAdTagDetails.
type ListVodAdTagDetailsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A List of ad tag details.
	VodAdTagDetails []*VodAdTagDetail `protobuf:"bytes,1,rep,name=vod_ad_tag_details,json=vodAdTagDetails,proto3" json:"vod_ad_tag_details,omitempty"`
	// The pagination token.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListVodAdTagDetailsResponse) Reset() {
	*x = ListVodAdTagDetailsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListVodAdTagDetailsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListVodAdTagDetailsResponse) ProtoMessage() {}

func (x *ListVodAdTagDetailsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListVodAdTagDetailsResponse.ProtoReflect.Descriptor instead.
func (*ListVodAdTagDetailsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{12}
}

func (x *ListVodAdTagDetailsResponse) GetVodAdTagDetails() []*VodAdTagDetail {
	if x != nil {
		return x.VodAdTagDetails
	}
	return nil
}

func (x *ListVodAdTagDetailsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for VideoStitcherService.getVodAdTagDetail
type GetVodAdTagDetailRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the ad tag detail for the specified VOD session, in the form of
	// `projects/{project}/locations/{location}/vodSessions/{vod_session_id}/vodAdTagDetails/{vod_ad_tag_detail}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetVodAdTagDetailRequest) Reset() {
	*x = GetVodAdTagDetailRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetVodAdTagDetailRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetVodAdTagDetailRequest) ProtoMessage() {}

func (x *GetVodAdTagDetailRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetVodAdTagDetailRequest.ProtoReflect.Descriptor instead.
func (*GetVodAdTagDetailRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{13}
}

func (x *GetVodAdTagDetailRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for VideoStitcherService.listLiveAdTagDetails.
type ListLiveAdTagDetailsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource parent in the form of
	// `projects/{project}/locations/{location}/liveSessions/{live_session}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The pagination token returned from a previous List request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListLiveAdTagDetailsRequest) Reset() {
	*x = ListLiveAdTagDetailsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListLiveAdTagDetailsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLiveAdTagDetailsRequest) ProtoMessage() {}

func (x *ListLiveAdTagDetailsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLiveAdTagDetailsRequest.ProtoReflect.Descriptor instead.
func (*ListLiveAdTagDetailsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{14}
}

func (x *ListLiveAdTagDetailsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListLiveAdTagDetailsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListLiveAdTagDetailsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for VideoStitcherService.listLiveAdTagDetails.
type ListLiveAdTagDetailsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of live session ad tag details.
	LiveAdTagDetails []*LiveAdTagDetail `protobuf:"bytes,1,rep,name=live_ad_tag_details,json=liveAdTagDetails,proto3" json:"live_ad_tag_details,omitempty"`
	// The pagination token.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListLiveAdTagDetailsResponse) Reset() {
	*x = ListLiveAdTagDetailsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListLiveAdTagDetailsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLiveAdTagDetailsResponse) ProtoMessage() {}

func (x *ListLiveAdTagDetailsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLiveAdTagDetailsResponse.ProtoReflect.Descriptor instead.
func (*ListLiveAdTagDetailsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{15}
}

func (x *ListLiveAdTagDetailsResponse) GetLiveAdTagDetails() []*LiveAdTagDetail {
	if x != nil {
		return x.LiveAdTagDetails
	}
	return nil
}

func (x *ListLiveAdTagDetailsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for VideoStitcherService.getLiveAdTagDetail
type GetLiveAdTagDetailRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name in the form of
	// `projects/{project}/locations/{location}/liveSessions/{live_session}/liveAdTagDetails/{live_ad_tag_detail}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetLiveAdTagDetailRequest) Reset() {
	*x = GetLiveAdTagDetailRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetLiveAdTagDetailRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLiveAdTagDetailRequest) ProtoMessage() {}

func (x *GetLiveAdTagDetailRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLiveAdTagDetailRequest.ProtoReflect.Descriptor instead.
func (*GetLiveAdTagDetailRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{16}
}

func (x *GetLiveAdTagDetailRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for VideoStitcherService.createSlate.
type CreateSlateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project in which the slate should be created, in the form of
	// `projects/{project_number}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The unique identifier for the slate.
	// This value should conform to RFC-1034, which restricts to
	// lower-case letters, numbers, and hyphen, with the first character a
	// letter, the last a letter or a number, and a 63 character maximum.
	SlateId string `protobuf:"bytes,2,opt,name=slate_id,json=slateId,proto3" json:"slate_id,omitempty"`
	// Required. The slate to create.
	Slate *Slate `protobuf:"bytes,3,opt,name=slate,proto3" json:"slate,omitempty"`
}

func (x *CreateSlateRequest) Reset() {
	*x = CreateSlateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSlateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSlateRequest) ProtoMessage() {}

func (x *CreateSlateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSlateRequest.ProtoReflect.Descriptor instead.
func (*CreateSlateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{17}
}

func (x *CreateSlateRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSlateRequest) GetSlateId() string {
	if x != nil {
		return x.SlateId
	}
	return ""
}

func (x *CreateSlateRequest) GetSlate() *Slate {
	if x != nil {
		return x.Slate
	}
	return nil
}

// Request message for VideoStitcherService.getSlate.
type GetSlateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the slate to be retrieved, of the slate, in the form of
	// `projects/{project_number}/locations/{location}/slates/{id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSlateRequest) Reset() {
	*x = GetSlateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSlateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSlateRequest) ProtoMessage() {}

func (x *GetSlateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSlateRequest.ProtoReflect.Descriptor instead.
func (*GetSlateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{18}
}

func (x *GetSlateRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for VideoStitcherService.listSlates.
type ListSlatesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project to list slates, in the form of `projects/{project_number}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. Server may return fewer items than requested.
	// If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filtering results
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Hint for how to order the results
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListSlatesRequest) Reset() {
	*x = ListSlatesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSlatesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSlatesRequest) ProtoMessage() {}

func (x *ListSlatesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSlatesRequest.ProtoReflect.Descriptor instead.
func (*ListSlatesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{19}
}

func (x *ListSlatesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSlatesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSlatesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListSlatesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListSlatesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for VideoStitcherService.listSlates.
type ListSlatesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of slates
	Slates []*Slate `protobuf:"bytes,1,rep,name=slates,proto3" json:"slates,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListSlatesResponse) Reset() {
	*x = ListSlatesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSlatesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSlatesResponse) ProtoMessage() {}

func (x *ListSlatesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSlatesResponse.ProtoReflect.Descriptor instead.
func (*ListSlatesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{20}
}

func (x *ListSlatesResponse) GetSlates() []*Slate {
	if x != nil {
		return x.Slates
	}
	return nil
}

func (x *ListSlatesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListSlatesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for VideoStitcherService.updateSlate.
type UpdateSlateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource with updated fields.
	Slate *Slate `protobuf:"bytes,1,opt,name=slate,proto3" json:"slate,omitempty"`
	// Required. The update mask which specifies fields which should be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateSlateRequest) Reset() {
	*x = UpdateSlateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSlateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSlateRequest) ProtoMessage() {}

func (x *UpdateSlateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSlateRequest.ProtoReflect.Descriptor instead.
func (*UpdateSlateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{21}
}

func (x *UpdateSlateRequest) GetSlate() *Slate {
	if x != nil {
		return x.Slate
	}
	return nil
}

func (x *UpdateSlateRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for VideoStitcherService.deleteSlate.
type DeleteSlateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the slate to be deleted, in the form of
	// `projects/{project_number}/locations/{location}/slates/{id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteSlateRequest) Reset() {
	*x = DeleteSlateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteSlateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSlateRequest) ProtoMessage() {}

func (x *DeleteSlateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSlateRequest.ProtoReflect.Descriptor instead.
func (*DeleteSlateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{22}
}

func (x *DeleteSlateRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for VideoStitcherService.createLiveSession.
type CreateLiveSessionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location in which the live session should be created,
	// in the form of `projects/{project_number}/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Parameters for creating a live session.
	LiveSession *LiveSession `protobuf:"bytes,2,opt,name=live_session,json=liveSession,proto3" json:"live_session,omitempty"`
}

func (x *CreateLiveSessionRequest) Reset() {
	*x = CreateLiveSessionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateLiveSessionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateLiveSessionRequest) ProtoMessage() {}

func (x *CreateLiveSessionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateLiveSessionRequest.ProtoReflect.Descriptor instead.
func (*CreateLiveSessionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{23}
}

func (x *CreateLiveSessionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateLiveSessionRequest) GetLiveSession() *LiveSession {
	if x != nil {
		return x.LiveSession
	}
	return nil
}

// Request message for VideoStitcherService.getSession.
type GetLiveSessionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the live session, in the form of
	// `projects/{project_number}/locations/{location}/liveSessions/{id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetLiveSessionRequest) Reset() {
	*x = GetLiveSessionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetLiveSessionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLiveSessionRequest) ProtoMessage() {}

func (x *GetLiveSessionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLiveSessionRequest.ProtoReflect.Descriptor instead.
func (*GetLiveSessionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP(), []int{24}
}

func (x *GetLiveSessionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_google_cloud_video_stitcher_v1_video_stitcher_service_proto protoreflect.FileDescriptor

var file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDesc = []byte{
	0x0a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2f, 0x76, 0x31,
	0x2f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2f, 0x76, 0x31,
	0x2f, 0x61, 0x64, 0x5f, 0x74, 0x61, 0x67, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x64, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65,
	0x72, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72,
	0x2f, 0x76, 0x31, 0x2f, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2f, 0x76, 0x31,
	0x2f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc3, 0x01, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43,
	0x64, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x25, 0x12, 0x23, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x74, 0x69, 0x74, 0x63,
	0x68, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x43, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x44, 0x0a, 0x07, 0x63, 0x64, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x06, 0x63, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x21, 0x0a, 0x0a, 0x63, 0x64, 0x6e, 0x5f, 0x6b,
	0x65, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x08, 0x63, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x49, 0x64, 0x22, 0xc8, 0x01, 0x0a, 0x12, 0x4c,
	0x69, 0x73, 0x74, 0x43, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x43, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x12, 0x23, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72,
	0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72,
	0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xa2, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x64,
	0x6e, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x41, 0x0a,
	0x08, 0x63, 0x64, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x07, 0x63, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65,
	0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75,
	0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x53, 0x0a, 0x10, 0x47, 0x65,
	0x74, 0x43, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x74, 0x69, 0x74, 0x63,
	0x68, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x43, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0x56, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x64, 0x6e, 0x4b, 0x65,
	0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x9d, 0x01, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x43, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x44, 0x0a, 0x07, 0x63, 0x64, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x63,
	0x64, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xb4, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x56, 0x6f, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x12, 0x27, 0x76, 0x69, 0x64,
	0x65, 0x6f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6f, 0x64, 0x53, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x50, 0x0a, 0x0b,
	0x76, 0x6f, 0x64, 0x5f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x56, 0x6f, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x76, 0x6f, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x5b,
	0x0a, 0x14, 0x47, 0x65, 0x74, 0x56, 0x6f, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6f, 0x64, 0x53, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa7, 0x01, 0x0a, 0x1b,
	0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x64, 0x53, 0x74, 0x69, 0x74, 0x63, 0x68, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2e, 0x12, 0x2c, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x56, 0x6f, 0x64, 0x53, 0x74, 0x69, 0x74, 0x63, 0x68, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa5, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f,
	0x64, 0x53, 0x74, 0x69, 0x74, 0x63, 0x68, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5d, 0x0a, 0x12, 0x76, 0x6f, 0x64, 0x5f, 0x73, 0x74,
	0x69, 0x74, 0x63, 0x68, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6f, 0x64, 0x53, 0x74, 0x69, 0x74, 0x63, 0x68, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x52, 0x10, 0x76, 0x6f, 0x64, 0x53, 0x74, 0x69, 0x74, 0x63, 0x68, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x65, 0x0a,
	0x19, 0x47, 0x65, 0x74, 0x56, 0x6f, 0x64, 0x53, 0x74, 0x69, 0x74, 0x63, 0x68, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e,
	0x0a, 0x2c, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56,
	0x6f, 0x64, 0x53, 0x74, 0x69, 0x74, 0x63, 0x68, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa5, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x64,
	0x41, 0x64, 0x54, 0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x12, 0x2b, 0x76, 0x69, 0x64,
	0x65, 0x6f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6f, 0x64, 0x41, 0x64, 0x54,
	0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa2, 0x01, 0x0a,
	0x1b, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x64, 0x41, 0x64, 0x54, 0x61, 0x67, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5b, 0x0a, 0x12,
	0x76, 0x6f, 0x64, 0x5f, 0x61, 0x64, 0x5f, 0x74, 0x61, 0x67, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74,
	0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6f, 0x64, 0x41, 0x64, 0x54,
	0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x52, 0x0f, 0x76, 0x6f, 0x64, 0x41, 0x64, 0x54,
	0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x63, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x56, 0x6f, 0x64, 0x41, 0x64, 0x54, 0x61, 0x67,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x56, 0x6f, 0x64, 0x41, 0x64, 0x54, 0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa7, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x4c,
	0x69, 0x76, 0x65, 0x41, 0x64, 0x54, 0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x12, 0x2c,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x69, 0x76,
	0x65, 0x41, 0x64, 0x54, 0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0xa6, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x69, 0x76, 0x65, 0x41, 0x64, 0x54,
	0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x5e, 0x0a, 0x13, 0x6c, 0x69, 0x76, 0x65, 0x5f, 0x61, 0x64, 0x5f, 0x74, 0x61, 0x67,
	0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x76, 0x65, 0x41, 0x64, 0x54, 0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x52,
	0x10, 0x6c, 0x69, 0x76, 0x65, 0x41, 0x64, 0x54, 0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x65, 0x0a, 0x19, 0x47, 0x65, 0x74,
	0x4c, 0x69, 0x76, 0x65, 0x41, 0x64, 0x54, 0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x0a, 0x2c, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x69, 0x76, 0x65, 0x41,
	0x64, 0x54, 0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0xba, 0x01, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x6c, 0x61, 0x74, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x12,
	0x22, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6c,
	0x61, 0x74, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1e, 0x0a, 0x08, 0x73,
	0x6c, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x07, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x49, 0x64, 0x12, 0x40, 0x0a, 0x05, 0x73,
	0x6c, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e,
	0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6c, 0x61, 0x74,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x22, 0x51, 0x0a,
	0x0f, 0x47, 0x65, 0x74, 0x53, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x74, 0x69,
	0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0xc6, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x12, 0x22,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6c, 0x61,
	0x74, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19,
	0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0x9d, 0x01, 0x0a, 0x12, 0x4c, 0x69,
	0x73, 0x74, 0x53, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x3d, 0x0a, 0x06, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x06, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61,
	0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e,
	0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x98, 0x01, 0x0a, 0x12, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x53, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x40, 0x0a, 0x05, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x6c, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x73, 0x6c, 0x61,
	0x74, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4d, 0x61, 0x73, 0x6b, 0x22, 0x54, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x6c,
	0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24,
	0x0a, 0x22, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53,
	0x6c, 0x61, 0x74, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xb9, 0x01, 0x0a, 0x18, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x76, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a,
	0x28, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x69,
	0x76, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x53, 0x0a, 0x0c, 0x6c, 0x69, 0x76, 0x65, 0x5f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69,
	0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x76, 0x65, 0x53, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x6c, 0x69, 0x76, 0x65, 0x53,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x5d, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x4c, 0x69, 0x76,
	0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x74, 0x69, 0x74,
	0x63, 0x68, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x69, 0x76, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x32, 0xaa, 0x1f, 0x0a, 0x14, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x53,
	0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xc5,
	0x01, 0x0a, 0x0c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x12,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x22, 0x58, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x36, 0x22, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x64, 0x6e, 0x4b, 0x65, 0x79,
	0x73, 0x3a, 0x07, 0x63, 0x64, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0xda, 0x41, 0x19, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x2c, 0x63, 0x64, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x2c, 0x63, 0x64, 0x6e, 0x5f,
	0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64, 0x12, 0xb4, 0x01, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x43,
	0x64, 0x6e, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74,
	0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x64, 0x6e, 0x4b,
	0x65, 0x79, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e,
	0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x43, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x3c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x12, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x64, 0x6e,
	0x4b, 0x65, 0x79, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xa1, 0x01,
	0x0a, 0x09, 0x47, 0x65, 0x74, 0x43, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x43, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64,
	0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x64, 0x6e, 0x4b, 0x65, 0x79, 0x22, 0x3a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x12, 0x2b, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x63, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x97, 0x01, 0x0a, 0x0c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x64, 0x6e, 0x4b,
	0x65, 0x79, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x64, 0x6e, 0x4b, 0x65, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22,
	0x3a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x2a, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x64, 0x6e, 0x4b, 0x65, 0x79,
	0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xc7, 0x01, 0x0a, 0x0c,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x43, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x64, 0x6e, 0x4b, 0x65, 0x79, 0x22, 0x5a, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x3e, 0x32, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x63, 0x64, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x2e,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x64, 0x6e, 0x4b,
	0x65, 0x79, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x07, 0x63, 0x64, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0xda,
	0x41, 0x13, 0x63, 0x64, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0xd2, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x56, 0x6f, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e,
	0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x56, 0x6f, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6f, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22,
	0x59, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x22, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x76, 0x6f, 0x64,
	0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x0b, 0x76, 0x6f, 0x64, 0x5f, 0x73, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0xda, 0x41, 0x12, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x76,
	0x6f, 0x64, 0x5f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0xb1, 0x01, 0x0a, 0x0d, 0x47,
	0x65, 0x74, 0x56, 0x6f, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x56, 0x6f, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6f, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x3e,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6f, 0x64, 0x53, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xe6,
	0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x64, 0x53, 0x74, 0x69, 0x74, 0x63, 0x68,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69,
	0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x64,
	0x53, 0x74, 0x69, 0x74, 0x63, 0x68, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x64, 0x53, 0x74, 0x69,
	0x74, 0x63, 0x68, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x53, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x12, 0x42, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76,
	0x6f, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x76, 0x6f,
	0x64, 0x53, 0x74, 0x69, 0x74, 0x63, 0x68, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xd3, 0x01, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x56,
	0x6f, 0x64, 0x53, 0x74, 0x69, 0x74, 0x63, 0x68, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x56, 0x6f, 0x64, 0x53, 0x74, 0x69, 0x74, 0x63, 0x68, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73,
	0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6f, 0x64, 0x53, 0x74,
	0x69, 0x74, 0x63, 0x68, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x22, 0x51, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x44, 0x12, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6f, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x76, 0x6f, 0x64, 0x53, 0x74, 0x69, 0x74, 0x63, 0x68, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xe2, 0x01,
	0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x64, 0x41, 0x64, 0x54, 0x61, 0x67, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63,
	0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x64, 0x41, 0x64,
	0x54, 0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x6f, 0x64, 0x41, 0x64, 0x54, 0x61, 0x67, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x52,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x12, 0x41, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6f, 0x64, 0x53, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x76, 0x6f, 0x64, 0x41, 0x64, 0x54,
	0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0xcf, 0x01, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x56, 0x6f, 0x64, 0x41, 0x64, 0x54,
	0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74,
	0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x56, 0x6f, 0x64,
	0x41, 0x64, 0x54, 0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6f, 0x64, 0x41, 0x64, 0x54, 0x61, 0x67, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x22, 0x50, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x12, 0x41, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6f, 0x64,
	0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x76, 0x6f, 0x64, 0x41, 0x64,
	0x54, 0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0xe7, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x69, 0x76,
	0x65, 0x41, 0x64, 0x54, 0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x3b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64,
	0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x4c, 0x69, 0x76, 0x65, 0x41, 0x64, 0x54, 0x61, 0x67, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e,
	0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x4c, 0x69, 0x76, 0x65, 0x41, 0x64, 0x54, 0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x54, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45,
	0x12, 0x43, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x69, 0x76, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6c, 0x69, 0x76, 0x65, 0x41, 0x64, 0x54, 0x61, 0x67, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xd4,
	0x01, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x4c, 0x69, 0x76, 0x65, 0x41, 0x64, 0x54, 0x61, 0x67, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63,
	0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4c, 0x69, 0x76, 0x65, 0x41, 0x64,
	0x54, 0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x76, 0x65, 0x41, 0x64, 0x54, 0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x22, 0x52, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x12, 0x43, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x69, 0x76, 0x65,
	0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x69, 0x76, 0x65, 0x41,
	0x64, 0x54, 0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xbb, 0x01, 0x0a, 0x0b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x53, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63,
	0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x6c, 0x61,
	0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73,
	0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6c, 0x61, 0x74, 0x65,
	0x22, 0x51, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x22, 0x2a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x6c,
	0x61, 0x74, 0x65, 0x73, 0x3a, 0x05, 0x73, 0x6c, 0x61, 0x74, 0x65, 0xda, 0x41, 0x15, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x2c, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x2c, 0x73, 0x6c, 0x61, 0x74, 0x65,
	0x5f, 0x69, 0x64, 0x12, 0xb0, 0x01, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6c, 0x61, 0x74,
	0x65, 0x73, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63,
	0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6c, 0x61, 0x74, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3b, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x2c, 0x12, 0x2a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x73, 0xda, 0x41, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x9d, 0x01, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x53, 0x6c,
	0x61, 0x74, 0x65, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6c, 0x61, 0x74, 0x65, 0x22, 0x39, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x2c, 0x12, 0x2a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xbd, 0x01, 0x0a, 0x0b, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x53, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74,
	0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x6c,
	0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e,
	0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6c, 0x61, 0x74,
	0x65, 0x22, 0x53, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x32, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x73, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x05, 0x73, 0x6c, 0x61,
	0x74, 0x65, 0xda, 0x41, 0x11, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x12, 0x94, 0x01, 0x0a, 0x0b, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x53, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74,
	0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x6c,
	0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x22, 0x39, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x2a, 0x2a, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6c, 0x61,
	0x74, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xd8, 0x01,
	0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x76, 0x65, 0x53, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x76, 0x65, 0x53,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64,
	0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x76, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x5c, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x40, 0x22, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6c, 0x69, 0x76, 0x65, 0x53, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x0c, 0x6c, 0x69, 0x76, 0x65, 0x5f, 0x73, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0xda, 0x41, 0x13, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6c, 0x69, 0x76, 0x65,
	0x5f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0xb5, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74,
	0x4c, 0x69, 0x76, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x4c, 0x69, 0x76, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x76, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22,
	0x3f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x69, 0x76, 0x65, 0x53, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x1a, 0x50, 0xca, 0x41, 0x1c, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x42, 0x89, 0x01, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74,
	0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x42, 0x19, 0x56, 0x69, 0x64, 0x65, 0x6f,
	0x53, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x46, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67,
	0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x2f, 0x76, 0x31, 0x3b, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescOnce sync.Once
	file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescData = file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDesc
)

func file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescGZIP() []byte {
	file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescData)
	})
	return file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDescData
}

var file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes = make([]protoimpl.MessageInfo, 25)
var file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_goTypes = []interface{}{
	(*CreateCdnKeyRequest)(nil),          // 0: google.cloud.video.stitcher.v1.CreateCdnKeyRequest
	(*ListCdnKeysRequest)(nil),           // 1: google.cloud.video.stitcher.v1.ListCdnKeysRequest
	(*ListCdnKeysResponse)(nil),          // 2: google.cloud.video.stitcher.v1.ListCdnKeysResponse
	(*GetCdnKeyRequest)(nil),             // 3: google.cloud.video.stitcher.v1.GetCdnKeyRequest
	(*DeleteCdnKeyRequest)(nil),          // 4: google.cloud.video.stitcher.v1.DeleteCdnKeyRequest
	(*UpdateCdnKeyRequest)(nil),          // 5: google.cloud.video.stitcher.v1.UpdateCdnKeyRequest
	(*CreateVodSessionRequest)(nil),      // 6: google.cloud.video.stitcher.v1.CreateVodSessionRequest
	(*GetVodSessionRequest)(nil),         // 7: google.cloud.video.stitcher.v1.GetVodSessionRequest
	(*ListVodStitchDetailsRequest)(nil),  // 8: google.cloud.video.stitcher.v1.ListVodStitchDetailsRequest
	(*ListVodStitchDetailsResponse)(nil), // 9: google.cloud.video.stitcher.v1.ListVodStitchDetailsResponse
	(*GetVodStitchDetailRequest)(nil),    // 10: google.cloud.video.stitcher.v1.GetVodStitchDetailRequest
	(*ListVodAdTagDetailsRequest)(nil),   // 11: google.cloud.video.stitcher.v1.ListVodAdTagDetailsRequest
	(*ListVodAdTagDetailsResponse)(nil),  // 12: google.cloud.video.stitcher.v1.ListVodAdTagDetailsResponse
	(*GetVodAdTagDetailRequest)(nil),     // 13: google.cloud.video.stitcher.v1.GetVodAdTagDetailRequest
	(*ListLiveAdTagDetailsRequest)(nil),  // 14: google.cloud.video.stitcher.v1.ListLiveAdTagDetailsRequest
	(*ListLiveAdTagDetailsResponse)(nil), // 15: google.cloud.video.stitcher.v1.ListLiveAdTagDetailsResponse
	(*GetLiveAdTagDetailRequest)(nil),    // 16: google.cloud.video.stitcher.v1.GetLiveAdTagDetailRequest
	(*CreateSlateRequest)(nil),           // 17: google.cloud.video.stitcher.v1.CreateSlateRequest
	(*GetSlateRequest)(nil),              // 18: google.cloud.video.stitcher.v1.GetSlateRequest
	(*ListSlatesRequest)(nil),            // 19: google.cloud.video.stitcher.v1.ListSlatesRequest
	(*ListSlatesResponse)(nil),           // 20: google.cloud.video.stitcher.v1.ListSlatesResponse
	(*UpdateSlateRequest)(nil),           // 21: google.cloud.video.stitcher.v1.UpdateSlateRequest
	(*DeleteSlateRequest)(nil),           // 22: google.cloud.video.stitcher.v1.DeleteSlateRequest
	(*CreateLiveSessionRequest)(nil),     // 23: google.cloud.video.stitcher.v1.CreateLiveSessionRequest
	(*GetLiveSessionRequest)(nil),        // 24: google.cloud.video.stitcher.v1.GetLiveSessionRequest
	(*CdnKey)(nil),                       // 25: google.cloud.video.stitcher.v1.CdnKey
	(*fieldmaskpb.FieldMask)(nil),        // 26: google.protobuf.FieldMask
	(*VodSession)(nil),                   // 27: google.cloud.video.stitcher.v1.VodSession
	(*VodStitchDetail)(nil),              // 28: google.cloud.video.stitcher.v1.VodStitchDetail
	(*VodAdTagDetail)(nil),               // 29: google.cloud.video.stitcher.v1.VodAdTagDetail
	(*LiveAdTagDetail)(nil),              // 30: google.cloud.video.stitcher.v1.LiveAdTagDetail
	(*Slate)(nil),                        // 31: google.cloud.video.stitcher.v1.Slate
	(*LiveSession)(nil),                  // 32: google.cloud.video.stitcher.v1.LiveSession
	(*emptypb.Empty)(nil),                // 33: google.protobuf.Empty
}
var file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_depIdxs = []int32{
	25, // 0: google.cloud.video.stitcher.v1.CreateCdnKeyRequest.cdn_key:type_name -> google.cloud.video.stitcher.v1.CdnKey
	25, // 1: google.cloud.video.stitcher.v1.ListCdnKeysResponse.cdn_keys:type_name -> google.cloud.video.stitcher.v1.CdnKey
	25, // 2: google.cloud.video.stitcher.v1.UpdateCdnKeyRequest.cdn_key:type_name -> google.cloud.video.stitcher.v1.CdnKey
	26, // 3: google.cloud.video.stitcher.v1.UpdateCdnKeyRequest.update_mask:type_name -> google.protobuf.FieldMask
	27, // 4: google.cloud.video.stitcher.v1.CreateVodSessionRequest.vod_session:type_name -> google.cloud.video.stitcher.v1.VodSession
	28, // 5: google.cloud.video.stitcher.v1.ListVodStitchDetailsResponse.vod_stitch_details:type_name -> google.cloud.video.stitcher.v1.VodStitchDetail
	29, // 6: google.cloud.video.stitcher.v1.ListVodAdTagDetailsResponse.vod_ad_tag_details:type_name -> google.cloud.video.stitcher.v1.VodAdTagDetail
	30, // 7: google.cloud.video.stitcher.v1.ListLiveAdTagDetailsResponse.live_ad_tag_details:type_name -> google.cloud.video.stitcher.v1.LiveAdTagDetail
	31, // 8: google.cloud.video.stitcher.v1.CreateSlateRequest.slate:type_name -> google.cloud.video.stitcher.v1.Slate
	31, // 9: google.cloud.video.stitcher.v1.ListSlatesResponse.slates:type_name -> google.cloud.video.stitcher.v1.Slate
	31, // 10: google.cloud.video.stitcher.v1.UpdateSlateRequest.slate:type_name -> google.cloud.video.stitcher.v1.Slate
	26, // 11: google.cloud.video.stitcher.v1.UpdateSlateRequest.update_mask:type_name -> google.protobuf.FieldMask
	32, // 12: google.cloud.video.stitcher.v1.CreateLiveSessionRequest.live_session:type_name -> google.cloud.video.stitcher.v1.LiveSession
	0,  // 13: google.cloud.video.stitcher.v1.VideoStitcherService.CreateCdnKey:input_type -> google.cloud.video.stitcher.v1.CreateCdnKeyRequest
	1,  // 14: google.cloud.video.stitcher.v1.VideoStitcherService.ListCdnKeys:input_type -> google.cloud.video.stitcher.v1.ListCdnKeysRequest
	3,  // 15: google.cloud.video.stitcher.v1.VideoStitcherService.GetCdnKey:input_type -> google.cloud.video.stitcher.v1.GetCdnKeyRequest
	4,  // 16: google.cloud.video.stitcher.v1.VideoStitcherService.DeleteCdnKey:input_type -> google.cloud.video.stitcher.v1.DeleteCdnKeyRequest
	5,  // 17: google.cloud.video.stitcher.v1.VideoStitcherService.UpdateCdnKey:input_type -> google.cloud.video.stitcher.v1.UpdateCdnKeyRequest
	6,  // 18: google.cloud.video.stitcher.v1.VideoStitcherService.CreateVodSession:input_type -> google.cloud.video.stitcher.v1.CreateVodSessionRequest
	7,  // 19: google.cloud.video.stitcher.v1.VideoStitcherService.GetVodSession:input_type -> google.cloud.video.stitcher.v1.GetVodSessionRequest
	8,  // 20: google.cloud.video.stitcher.v1.VideoStitcherService.ListVodStitchDetails:input_type -> google.cloud.video.stitcher.v1.ListVodStitchDetailsRequest
	10, // 21: google.cloud.video.stitcher.v1.VideoStitcherService.GetVodStitchDetail:input_type -> google.cloud.video.stitcher.v1.GetVodStitchDetailRequest
	11, // 22: google.cloud.video.stitcher.v1.VideoStitcherService.ListVodAdTagDetails:input_type -> google.cloud.video.stitcher.v1.ListVodAdTagDetailsRequest
	13, // 23: google.cloud.video.stitcher.v1.VideoStitcherService.GetVodAdTagDetail:input_type -> google.cloud.video.stitcher.v1.GetVodAdTagDetailRequest
	14, // 24: google.cloud.video.stitcher.v1.VideoStitcherService.ListLiveAdTagDetails:input_type -> google.cloud.video.stitcher.v1.ListLiveAdTagDetailsRequest
	16, // 25: google.cloud.video.stitcher.v1.VideoStitcherService.GetLiveAdTagDetail:input_type -> google.cloud.video.stitcher.v1.GetLiveAdTagDetailRequest
	17, // 26: google.cloud.video.stitcher.v1.VideoStitcherService.CreateSlate:input_type -> google.cloud.video.stitcher.v1.CreateSlateRequest
	19, // 27: google.cloud.video.stitcher.v1.VideoStitcherService.ListSlates:input_type -> google.cloud.video.stitcher.v1.ListSlatesRequest
	18, // 28: google.cloud.video.stitcher.v1.VideoStitcherService.GetSlate:input_type -> google.cloud.video.stitcher.v1.GetSlateRequest
	21, // 29: google.cloud.video.stitcher.v1.VideoStitcherService.UpdateSlate:input_type -> google.cloud.video.stitcher.v1.UpdateSlateRequest
	22, // 30: google.cloud.video.stitcher.v1.VideoStitcherService.DeleteSlate:input_type -> google.cloud.video.stitcher.v1.DeleteSlateRequest
	23, // 31: google.cloud.video.stitcher.v1.VideoStitcherService.CreateLiveSession:input_type -> google.cloud.video.stitcher.v1.CreateLiveSessionRequest
	24, // 32: google.cloud.video.stitcher.v1.VideoStitcherService.GetLiveSession:input_type -> google.cloud.video.stitcher.v1.GetLiveSessionRequest
	25, // 33: google.cloud.video.stitcher.v1.VideoStitcherService.CreateCdnKey:output_type -> google.cloud.video.stitcher.v1.CdnKey
	2,  // 34: google.cloud.video.stitcher.v1.VideoStitcherService.ListCdnKeys:output_type -> google.cloud.video.stitcher.v1.ListCdnKeysResponse
	25, // 35: google.cloud.video.stitcher.v1.VideoStitcherService.GetCdnKey:output_type -> google.cloud.video.stitcher.v1.CdnKey
	33, // 36: google.cloud.video.stitcher.v1.VideoStitcherService.DeleteCdnKey:output_type -> google.protobuf.Empty
	25, // 37: google.cloud.video.stitcher.v1.VideoStitcherService.UpdateCdnKey:output_type -> google.cloud.video.stitcher.v1.CdnKey
	27, // 38: google.cloud.video.stitcher.v1.VideoStitcherService.CreateVodSession:output_type -> google.cloud.video.stitcher.v1.VodSession
	27, // 39: google.cloud.video.stitcher.v1.VideoStitcherService.GetVodSession:output_type -> google.cloud.video.stitcher.v1.VodSession
	9,  // 40: google.cloud.video.stitcher.v1.VideoStitcherService.ListVodStitchDetails:output_type -> google.cloud.video.stitcher.v1.ListVodStitchDetailsResponse
	28, // 41: google.cloud.video.stitcher.v1.VideoStitcherService.GetVodStitchDetail:output_type -> google.cloud.video.stitcher.v1.VodStitchDetail
	12, // 42: google.cloud.video.stitcher.v1.VideoStitcherService.ListVodAdTagDetails:output_type -> google.cloud.video.stitcher.v1.ListVodAdTagDetailsResponse
	29, // 43: google.cloud.video.stitcher.v1.VideoStitcherService.GetVodAdTagDetail:output_type -> google.cloud.video.stitcher.v1.VodAdTagDetail
	15, // 44: google.cloud.video.stitcher.v1.VideoStitcherService.ListLiveAdTagDetails:output_type -> google.cloud.video.stitcher.v1.ListLiveAdTagDetailsResponse
	30, // 45: google.cloud.video.stitcher.v1.VideoStitcherService.GetLiveAdTagDetail:output_type -> google.cloud.video.stitcher.v1.LiveAdTagDetail
	31, // 46: google.cloud.video.stitcher.v1.VideoStitcherService.CreateSlate:output_type -> google.cloud.video.stitcher.v1.Slate
	20, // 47: google.cloud.video.stitcher.v1.VideoStitcherService.ListSlates:output_type -> google.cloud.video.stitcher.v1.ListSlatesResponse
	31, // 48: google.cloud.video.stitcher.v1.VideoStitcherService.GetSlate:output_type -> google.cloud.video.stitcher.v1.Slate
	31, // 49: google.cloud.video.stitcher.v1.VideoStitcherService.UpdateSlate:output_type -> google.cloud.video.stitcher.v1.Slate
	33, // 50: google.cloud.video.stitcher.v1.VideoStitcherService.DeleteSlate:output_type -> google.protobuf.Empty
	32, // 51: google.cloud.video.stitcher.v1.VideoStitcherService.CreateLiveSession:output_type -> google.cloud.video.stitcher.v1.LiveSession
	32, // 52: google.cloud.video.stitcher.v1.VideoStitcherService.GetLiveSession:output_type -> google.cloud.video.stitcher.v1.LiveSession
	33, // [33:53] is the sub-list for method output_type
	13, // [13:33] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_init() }
func file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_init() {
	if File_google_cloud_video_stitcher_v1_video_stitcher_service_proto != nil {
		return
	}
	file_google_cloud_video_stitcher_v1_ad_tag_details_proto_init()
	file_google_cloud_video_stitcher_v1_cdn_keys_proto_init()
	file_google_cloud_video_stitcher_v1_sessions_proto_init()
	file_google_cloud_video_stitcher_v1_slates_proto_init()
	file_google_cloud_video_stitcher_v1_stitch_details_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateCdnKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCdnKeysRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListCdnKeysResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCdnKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteCdnKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateCdnKeyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateVodSessionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetVodSessionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListVodStitchDetailsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListVodStitchDetailsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetVodStitchDetailRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListVodAdTagDetailsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListVodAdTagDetailsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetVodAdTagDetailRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListLiveAdTagDetailsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListLiveAdTagDetailsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetLiveAdTagDetailRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSlateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSlateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSlatesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSlatesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSlateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteSlateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateLiveSessionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetLiveSessionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   25,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_msgTypes,
	}.Build()
	File_google_cloud_video_stitcher_v1_video_stitcher_service_proto = out.File
	file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_rawDesc = nil
	file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_goTypes = nil
	file_google_cloud_video_stitcher_v1_video_stitcher_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// VideoStitcherServiceClient is the client API for VideoStitcherService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type VideoStitcherServiceClient interface {
	// Creates a new CDN key.
	CreateCdnKey(ctx context.Context, in *CreateCdnKeyRequest, opts ...grpc.CallOption) (*CdnKey, error)
	// Lists all CDN keys in the specified project and location.
	ListCdnKeys(ctx context.Context, in *ListCdnKeysRequest, opts ...grpc.CallOption) (*ListCdnKeysResponse, error)
	// Returns the specified CDN key.
	GetCdnKey(ctx context.Context, in *GetCdnKeyRequest, opts ...grpc.CallOption) (*CdnKey, error)
	// Deletes the specified CDN key.
	DeleteCdnKey(ctx context.Context, in *DeleteCdnKeyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates the specified CDN key. Only update fields specified
	// in the call method body.
	UpdateCdnKey(ctx context.Context, in *UpdateCdnKeyRequest, opts ...grpc.CallOption) (*CdnKey, error)
	// Creates a client side playback VOD session and returns the full
	// tracking and playback metadata of the session.
	CreateVodSession(ctx context.Context, in *CreateVodSessionRequest, opts ...grpc.CallOption) (*VodSession, error)
	// Returns the full tracking, playback metadata, and relevant ad-ops
	// logs for the specified VOD session.
	GetVodSession(ctx context.Context, in *GetVodSessionRequest, opts ...grpc.CallOption) (*VodSession, error)
	// Returns a list of detailed stitching information of the specified VOD
	// session.
	ListVodStitchDetails(ctx context.Context, in *ListVodStitchDetailsRequest, opts ...grpc.CallOption) (*ListVodStitchDetailsResponse, error)
	// Returns the specified stitching information for the specified VOD session.
	GetVodStitchDetail(ctx context.Context, in *GetVodStitchDetailRequest, opts ...grpc.CallOption) (*VodStitchDetail, error)
	// Return the list of ad tag details for the specified VOD session.
	ListVodAdTagDetails(ctx context.Context, in *ListVodAdTagDetailsRequest, opts ...grpc.CallOption) (*ListVodAdTagDetailsResponse, error)
	// Returns the specified ad tag detail for the specified VOD session.
	GetVodAdTagDetail(ctx context.Context, in *GetVodAdTagDetailRequest, opts ...grpc.CallOption) (*VodAdTagDetail, error)
	// Return the list of ad tag details for the specified live session.
	ListLiveAdTagDetails(ctx context.Context, in *ListLiveAdTagDetailsRequest, opts ...grpc.CallOption) (*ListLiveAdTagDetailsResponse, error)
	// Returns the specified ad tag detail for the specified live session.
	GetLiveAdTagDetail(ctx context.Context, in *GetLiveAdTagDetailRequest, opts ...grpc.CallOption) (*LiveAdTagDetail, error)
	// Creates a slate.
	CreateSlate(ctx context.Context, in *CreateSlateRequest, opts ...grpc.CallOption) (*Slate, error)
	// Lists all slates in the specified project and location.
	ListSlates(ctx context.Context, in *ListSlatesRequest, opts ...grpc.CallOption) (*ListSlatesResponse, error)
	// Returns the specified slate.
	GetSlate(ctx context.Context, in *GetSlateRequest, opts ...grpc.CallOption) (*Slate, error)
	// Updates the specified slate.
	UpdateSlate(ctx context.Context, in *UpdateSlateRequest, opts ...grpc.CallOption) (*Slate, error)
	// Deletes the specified slate.
	DeleteSlate(ctx context.Context, in *DeleteSlateRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates a new live session.
	CreateLiveSession(ctx context.Context, in *CreateLiveSessionRequest, opts ...grpc.CallOption) (*LiveSession, error)
	// Returns the details for the specified live session.
	GetLiveSession(ctx context.Context, in *GetLiveSessionRequest, opts ...grpc.CallOption) (*LiveSession, error)
}

type videoStitcherServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewVideoStitcherServiceClient(cc grpc.ClientConnInterface) VideoStitcherServiceClient {
	return &videoStitcherServiceClient{cc}
}

func (c *videoStitcherServiceClient) CreateCdnKey(ctx context.Context, in *CreateCdnKeyRequest, opts ...grpc.CallOption) (*CdnKey, error) {
	out := new(CdnKey)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/CreateCdnKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) ListCdnKeys(ctx context.Context, in *ListCdnKeysRequest, opts ...grpc.CallOption) (*ListCdnKeysResponse, error) {
	out := new(ListCdnKeysResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/ListCdnKeys", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) GetCdnKey(ctx context.Context, in *GetCdnKeyRequest, opts ...grpc.CallOption) (*CdnKey, error) {
	out := new(CdnKey)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/GetCdnKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) DeleteCdnKey(ctx context.Context, in *DeleteCdnKeyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/DeleteCdnKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) UpdateCdnKey(ctx context.Context, in *UpdateCdnKeyRequest, opts ...grpc.CallOption) (*CdnKey, error) {
	out := new(CdnKey)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/UpdateCdnKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) CreateVodSession(ctx context.Context, in *CreateVodSessionRequest, opts ...grpc.CallOption) (*VodSession, error) {
	out := new(VodSession)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/CreateVodSession", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) GetVodSession(ctx context.Context, in *GetVodSessionRequest, opts ...grpc.CallOption) (*VodSession, error) {
	out := new(VodSession)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/GetVodSession", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) ListVodStitchDetails(ctx context.Context, in *ListVodStitchDetailsRequest, opts ...grpc.CallOption) (*ListVodStitchDetailsResponse, error) {
	out := new(ListVodStitchDetailsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/ListVodStitchDetails", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) GetVodStitchDetail(ctx context.Context, in *GetVodStitchDetailRequest, opts ...grpc.CallOption) (*VodStitchDetail, error) {
	out := new(VodStitchDetail)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/GetVodStitchDetail", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) ListVodAdTagDetails(ctx context.Context, in *ListVodAdTagDetailsRequest, opts ...grpc.CallOption) (*ListVodAdTagDetailsResponse, error) {
	out := new(ListVodAdTagDetailsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/ListVodAdTagDetails", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) GetVodAdTagDetail(ctx context.Context, in *GetVodAdTagDetailRequest, opts ...grpc.CallOption) (*VodAdTagDetail, error) {
	out := new(VodAdTagDetail)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/GetVodAdTagDetail", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) ListLiveAdTagDetails(ctx context.Context, in *ListLiveAdTagDetailsRequest, opts ...grpc.CallOption) (*ListLiveAdTagDetailsResponse, error) {
	out := new(ListLiveAdTagDetailsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/ListLiveAdTagDetails", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) GetLiveAdTagDetail(ctx context.Context, in *GetLiveAdTagDetailRequest, opts ...grpc.CallOption) (*LiveAdTagDetail, error) {
	out := new(LiveAdTagDetail)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/GetLiveAdTagDetail", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) CreateSlate(ctx context.Context, in *CreateSlateRequest, opts ...grpc.CallOption) (*Slate, error) {
	out := new(Slate)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/CreateSlate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) ListSlates(ctx context.Context, in *ListSlatesRequest, opts ...grpc.CallOption) (*ListSlatesResponse, error) {
	out := new(ListSlatesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/ListSlates", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) GetSlate(ctx context.Context, in *GetSlateRequest, opts ...grpc.CallOption) (*Slate, error) {
	out := new(Slate)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/GetSlate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) UpdateSlate(ctx context.Context, in *UpdateSlateRequest, opts ...grpc.CallOption) (*Slate, error) {
	out := new(Slate)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/UpdateSlate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) DeleteSlate(ctx context.Context, in *DeleteSlateRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/DeleteSlate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) CreateLiveSession(ctx context.Context, in *CreateLiveSessionRequest, opts ...grpc.CallOption) (*LiveSession, error) {
	out := new(LiveSession)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/CreateLiveSession", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoStitcherServiceClient) GetLiveSession(ctx context.Context, in *GetLiveSessionRequest, opts ...grpc.CallOption) (*LiveSession, error) {
	out := new(LiveSession)
	err := c.cc.Invoke(ctx, "/google.cloud.video.stitcher.v1.VideoStitcherService/GetLiveSession", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VideoStitcherServiceServer is the server API for VideoStitcherService service.
type VideoStitcherServiceServer interface {
	// Creates a new CDN key.
	CreateCdnKey(context.Context, *CreateCdnKeyRequest) (*CdnKey, error)
	// Lists all CDN keys in the specified project and location.
	ListCdnKeys(context.Context, *ListCdnKeysRequest) (*ListCdnKeysResponse, error)
	// Returns the specified CDN key.
	GetCdnKey(context.Context, *GetCdnKeyRequest) (*CdnKey, error)
	// Deletes the specified CDN key.
	DeleteCdnKey(context.Context, *DeleteCdnKeyRequest) (*emptypb.Empty, error)
	// Updates the specified CDN key. Only update fields specified
	// in the call method body.
	UpdateCdnKey(context.Context, *UpdateCdnKeyRequest) (*CdnKey, error)
	// Creates a client side playback VOD session and returns the full
	// tracking and playback metadata of the session.
	CreateVodSession(context.Context, *CreateVodSessionRequest) (*VodSession, error)
	// Returns the full tracking, playback metadata, and relevant ad-ops
	// logs for the specified VOD session.
	GetVodSession(context.Context, *GetVodSessionRequest) (*VodSession, error)
	// Returns a list of detailed stitching information of the specified VOD
	// session.
	ListVodStitchDetails(context.Context, *ListVodStitchDetailsRequest) (*ListVodStitchDetailsResponse, error)
	// Returns the specified stitching information for the specified VOD session.
	GetVodStitchDetail(context.Context, *GetVodStitchDetailRequest) (*VodStitchDetail, error)
	// Return the list of ad tag details for the specified VOD session.
	ListVodAdTagDetails(context.Context, *ListVodAdTagDetailsRequest) (*ListVodAdTagDetailsResponse, error)
	// Returns the specified ad tag detail for the specified VOD session.
	GetVodAdTagDetail(context.Context, *GetVodAdTagDetailRequest) (*VodAdTagDetail, error)
	// Return the list of ad tag details for the specified live session.
	ListLiveAdTagDetails(context.Context, *ListLiveAdTagDetailsRequest) (*ListLiveAdTagDetailsResponse, error)
	// Returns the specified ad tag detail for the specified live session.
	GetLiveAdTagDetail(context.Context, *GetLiveAdTagDetailRequest) (*LiveAdTagDetail, error)
	// Creates a slate.
	CreateSlate(context.Context, *CreateSlateRequest) (*Slate, error)
	// Lists all slates in the specified project and location.
	ListSlates(context.Context, *ListSlatesRequest) (*ListSlatesResponse, error)
	// Returns the specified slate.
	GetSlate(context.Context, *GetSlateRequest) (*Slate, error)
	// Updates the specified slate.
	UpdateSlate(context.Context, *UpdateSlateRequest) (*Slate, error)
	// Deletes the specified slate.
	DeleteSlate(context.Context, *DeleteSlateRequest) (*emptypb.Empty, error)
	// Creates a new live session.
	CreateLiveSession(context.Context, *CreateLiveSessionRequest) (*LiveSession, error)
	// Returns the details for the specified live session.
	GetLiveSession(context.Context, *GetLiveSessionRequest) (*LiveSession, error)
}

// UnimplementedVideoStitcherServiceServer can be embedded to have forward compatible implementations.
type UnimplementedVideoStitcherServiceServer struct {
}

func (*UnimplementedVideoStitcherServiceServer) CreateCdnKey(context.Context, *CreateCdnKeyRequest) (*CdnKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCdnKey not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) ListCdnKeys(context.Context, *ListCdnKeysRequest) (*ListCdnKeysResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCdnKeys not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) GetCdnKey(context.Context, *GetCdnKeyRequest) (*CdnKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCdnKey not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) DeleteCdnKey(context.Context, *DeleteCdnKeyRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCdnKey not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) UpdateCdnKey(context.Context, *UpdateCdnKeyRequest) (*CdnKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCdnKey not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) CreateVodSession(context.Context, *CreateVodSessionRequest) (*VodSession, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateVodSession not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) GetVodSession(context.Context, *GetVodSessionRequest) (*VodSession, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVodSession not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) ListVodStitchDetails(context.Context, *ListVodStitchDetailsRequest) (*ListVodStitchDetailsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVodStitchDetails not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) GetVodStitchDetail(context.Context, *GetVodStitchDetailRequest) (*VodStitchDetail, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVodStitchDetail not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) ListVodAdTagDetails(context.Context, *ListVodAdTagDetailsRequest) (*ListVodAdTagDetailsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVodAdTagDetails not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) GetVodAdTagDetail(context.Context, *GetVodAdTagDetailRequest) (*VodAdTagDetail, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVodAdTagDetail not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) ListLiveAdTagDetails(context.Context, *ListLiveAdTagDetailsRequest) (*ListLiveAdTagDetailsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListLiveAdTagDetails not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) GetLiveAdTagDetail(context.Context, *GetLiveAdTagDetailRequest) (*LiveAdTagDetail, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLiveAdTagDetail not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) CreateSlate(context.Context, *CreateSlateRequest) (*Slate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSlate not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) ListSlates(context.Context, *ListSlatesRequest) (*ListSlatesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSlates not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) GetSlate(context.Context, *GetSlateRequest) (*Slate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSlate not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) UpdateSlate(context.Context, *UpdateSlateRequest) (*Slate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSlate not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) DeleteSlate(context.Context, *DeleteSlateRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSlate not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) CreateLiveSession(context.Context, *CreateLiveSessionRequest) (*LiveSession, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateLiveSession not implemented")
}
func (*UnimplementedVideoStitcherServiceServer) GetLiveSession(context.Context, *GetLiveSessionRequest) (*LiveSession, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLiveSession not implemented")
}

func RegisterVideoStitcherServiceServer(s *grpc.Server, srv VideoStitcherServiceServer) {
	s.RegisterService(&_VideoStitcherService_serviceDesc, srv)
}

func _VideoStitcherService_CreateCdnKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCdnKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).CreateCdnKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/CreateCdnKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).CreateCdnKey(ctx, req.(*CreateCdnKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_ListCdnKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCdnKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).ListCdnKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/ListCdnKeys",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).ListCdnKeys(ctx, req.(*ListCdnKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_GetCdnKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCdnKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).GetCdnKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/GetCdnKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).GetCdnKey(ctx, req.(*GetCdnKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_DeleteCdnKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCdnKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).DeleteCdnKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/DeleteCdnKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).DeleteCdnKey(ctx, req.(*DeleteCdnKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_UpdateCdnKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCdnKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).UpdateCdnKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/UpdateCdnKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).UpdateCdnKey(ctx, req.(*UpdateCdnKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_CreateVodSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateVodSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).CreateVodSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/CreateVodSession",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).CreateVodSession(ctx, req.(*CreateVodSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_GetVodSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVodSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).GetVodSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/GetVodSession",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).GetVodSession(ctx, req.(*GetVodSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_ListVodStitchDetails_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVodStitchDetailsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).ListVodStitchDetails(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/ListVodStitchDetails",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).ListVodStitchDetails(ctx, req.(*ListVodStitchDetailsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_GetVodStitchDetail_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVodStitchDetailRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).GetVodStitchDetail(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/GetVodStitchDetail",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).GetVodStitchDetail(ctx, req.(*GetVodStitchDetailRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_ListVodAdTagDetails_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVodAdTagDetailsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).ListVodAdTagDetails(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/ListVodAdTagDetails",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).ListVodAdTagDetails(ctx, req.(*ListVodAdTagDetailsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_GetVodAdTagDetail_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVodAdTagDetailRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).GetVodAdTagDetail(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/GetVodAdTagDetail",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).GetVodAdTagDetail(ctx, req.(*GetVodAdTagDetailRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_ListLiveAdTagDetails_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListLiveAdTagDetailsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).ListLiveAdTagDetails(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/ListLiveAdTagDetails",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).ListLiveAdTagDetails(ctx, req.(*ListLiveAdTagDetailsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_GetLiveAdTagDetail_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLiveAdTagDetailRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).GetLiveAdTagDetail(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/GetLiveAdTagDetail",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).GetLiveAdTagDetail(ctx, req.(*GetLiveAdTagDetailRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_CreateSlate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSlateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).CreateSlate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/CreateSlate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).CreateSlate(ctx, req.(*CreateSlateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_ListSlates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSlatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).ListSlates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/ListSlates",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).ListSlates(ctx, req.(*ListSlatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_GetSlate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSlateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).GetSlate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/GetSlate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).GetSlate(ctx, req.(*GetSlateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_UpdateSlate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSlateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).UpdateSlate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/UpdateSlate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).UpdateSlate(ctx, req.(*UpdateSlateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_DeleteSlate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSlateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).DeleteSlate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/DeleteSlate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).DeleteSlate(ctx, req.(*DeleteSlateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_CreateLiveSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateLiveSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).CreateLiveSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/CreateLiveSession",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).CreateLiveSession(ctx, req.(*CreateLiveSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoStitcherService_GetLiveSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLiveSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoStitcherServiceServer).GetLiveSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.video.stitcher.v1.VideoStitcherService/GetLiveSession",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoStitcherServiceServer).GetLiveSession(ctx, req.(*GetLiveSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _VideoStitcherService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.video.stitcher.v1.VideoStitcherService",
	HandlerType: (*VideoStitcherServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateCdnKey",
			Handler:    _VideoStitcherService_CreateCdnKey_Handler,
		},
		{
			MethodName: "ListCdnKeys",
			Handler:    _VideoStitcherService_ListCdnKeys_Handler,
		},
		{
			MethodName: "GetCdnKey",
			Handler:    _VideoStitcherService_GetCdnKey_Handler,
		},
		{
			MethodName: "DeleteCdnKey",
			Handler:    _VideoStitcherService_DeleteCdnKey_Handler,
		},
		{
			MethodName: "UpdateCdnKey",
			Handler:    _VideoStitcherService_UpdateCdnKey_Handler,
		},
		{
			MethodName: "CreateVodSession",
			Handler:    _VideoStitcherService_CreateVodSession_Handler,
		},
		{
			MethodName: "GetVodSession",
			Handler:    _VideoStitcherService_GetVodSession_Handler,
		},
		{
			MethodName: "ListVodStitchDetails",
			Handler:    _VideoStitcherService_ListVodStitchDetails_Handler,
		},
		{
			MethodName: "GetVodStitchDetail",
			Handler:    _VideoStitcherService_GetVodStitchDetail_Handler,
		},
		{
			MethodName: "ListVodAdTagDetails",
			Handler:    _VideoStitcherService_ListVodAdTagDetails_Handler,
		},
		{
			MethodName: "GetVodAdTagDetail",
			Handler:    _VideoStitcherService_GetVodAdTagDetail_Handler,
		},
		{
			MethodName: "ListLiveAdTagDetails",
			Handler:    _VideoStitcherService_ListLiveAdTagDetails_Handler,
		},
		{
			MethodName: "GetLiveAdTagDetail",
			Handler:    _VideoStitcherService_GetLiveAdTagDetail_Handler,
		},
		{
			MethodName: "CreateSlate",
			Handler:    _VideoStitcherService_CreateSlate_Handler,
		},
		{
			MethodName: "ListSlates",
			Handler:    _VideoStitcherService_ListSlates_Handler,
		},
		{
			MethodName: "GetSlate",
			Handler:    _VideoStitcherService_GetSlate_Handler,
		},
		{
			MethodName: "UpdateSlate",
			Handler:    _VideoStitcherService_UpdateSlate_Handler,
		},
		{
			MethodName: "DeleteSlate",
			Handler:    _VideoStitcherService_DeleteSlate_Handler,
		},
		{
			MethodName: "CreateLiveSession",
			Handler:    _VideoStitcherService_CreateLiveSession_Handler,
		},
		{
			MethodName: "GetLiveSession",
			Handler:    _VideoStitcherService_GetLiveSession_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/video/stitcher/v1/video_stitcher_service.proto",
}
