/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.adapter;

import java.awt.Component;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.flexdock.docking.adapter.AdapterMapping;

public class DockingAdapter {
    private static final Class[] EMPTY_PARAMS = new Class[0];
    private static final Object[] EMPTY_ARGS = new Object[0];
    private Component component;
    private AdapterMapping mapping;

    DockingAdapter(Component comp, AdapterMapping mapping) {
        this.component = comp;
        this.mapping = mapping;
    }

    public Component getComponent() {
        return this.component;
    }

    public List getDragSources() {
        Object obj = this.get(this.component, this.mapping.getDragSourceList());
        if (obj instanceof List) {
            return (List)obj;
        }
        obj = this.get(this.component, this.mapping.getDragSource());
        if (obj instanceof Component) {
            ArrayList<Object> list = new ArrayList<Object>(1);
            list.add(obj);
            return list;
        }
        return null;
    }

    public Set getFrameDragSources() {
        Object obj = this.get(this.component, this.mapping.getFrameDragSourceList());
        if (obj instanceof Set) {
            return (Set)obj;
        }
        obj = this.get(this.component, this.mapping.getFrameDragSource());
        if (obj instanceof Component) {
            HashSet<Object> set = new HashSet<Object>(1);
            set.add(obj);
            return set;
        }
        return null;
    }

    public String getPersistentId() {
        Object obj = this.get(this.component, this.mapping.getPersistentId());
        return obj instanceof String ? (String)obj : null;
    }

    public Icon getDockbarIcon() {
        Object obj = this.get(this.component, this.mapping.getDockbarIcon());
        return obj instanceof Icon ? (Icon)obj : null;
    }

    public String getTabText() {
        Object obj = this.get(this.component, this.mapping.getTabText());
        return obj instanceof String ? (String)obj : null;
    }

    private Object get(Object obj, String methodName) {
        if (obj == null || methodName == null) {
            return null;
        }
        try {
            Class<?> c = obj.getClass();
            Method method = c.getMethod(methodName, EMPTY_PARAMS);
            return method.invoke(obj, EMPTY_ARGS);
        }
        catch (Throwable t) {
            return null;
        }
    }
}

