/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.plaf.common.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.border.LineBorder;

public class RoundedLineBorder
extends LineBorder {
    private int mArcWidthHeight;
    private boolean mFilled;

    public RoundedLineBorder(Color color, int arcWidthHeight) {
        this(color, arcWidthHeight, 1);
    }

    public RoundedLineBorder(Color color, int arcWidthHeight, int thickness) {
        super(color, thickness);
        this.mArcWidthHeight = arcWidthHeight;
    }

    public void setFilled(boolean filled) {
        this.mFilled = filled;
    }

    public void paintBorder(Component component, Graphics g, int i, int j, int k, int l) {
        Graphics2D graphics2d = (Graphics2D)g;
        Object obj = graphics2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color color = graphics2d.getColor();
        graphics2d.setColor(this.lineColor);
        if (this.mFilled) {
            graphics2d.fillRoundRect(i, j, k - 1, l - 1, this.mArcWidthHeight, this.mArcWidthHeight);
        } else {
            for (int i1 = 0; i1 < this.thickness; ++i1) {
                graphics2d.drawRoundRect(i + i1, j + i1, k - i1 - i1 - 1, l - i1 - i1 - 1, this.mArcWidthHeight, this.mArcWidthHeight);
            }
        }
        graphics2d.setColor(color);
        graphics2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, obj);
    }
}

