/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.util;

import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public class ResourceManager {
    private static Log log = LogFactory.getLog((Class)ResourceManager.class);
    public static final String LIBRARY_EXTENSION = ResourceManager.getLibraryExtension();

    private ResourceManager() {
    }

    private static String getLibraryExtension() {
        return ResourceManager.isWindowsPlatform() ? ".dll" : ".so";
    }

    public static boolean isWindowsPlatform() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.indexOf("windows") != -1 || osName.endsWith(" nt");
    }

    public static URL getResource(String uri) {
        if (uri == null) {
            return null;
        }
        URL url = ResourceManager.class.getResource(uri);
        if (url == null) {
            url = ClassLoader.getSystemResource(uri);
        }
        if (url == null && !uri.startsWith("/")) {
            url = ResourceManager.getResource("/" + uri);
        }
        if (url == null) {
            try {
                File file = new File(uri);
                if (file.exists()) {
                    url = file.toURL();
                }
            }
            catch (MalformedURLException e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
                url = null;
            }
        }
        return url;
    }

    public static Image createImage(String url) {
        try {
            URL location = ResourceManager.getResource(url);
            return Toolkit.getDefaultToolkit().createImage(location);
        }
        catch (NullPointerException e) {
            throw new NullPointerException("Unable to locate image: " + url);
        }
    }

    public static Image createImage(URL imageLocation) {
        try {
            return Toolkit.getDefaultToolkit().createImage(imageLocation);
        }
        catch (NullPointerException e) {
            throw new NullPointerException("Unable to locate image: " + imageLocation);
        }
    }

    public static ImageIcon createIcon(String url) {
        try {
            URL location = ResourceManager.getResource(url);
            return new ImageIcon(location);
        }
        catch (NullPointerException e) {
            throw new NullPointerException("Unable to locate image: " + url);
        }
    }

    public static Cursor createCursor(URL imageURL, Point hotPoint, String name) {
        Image image = ResourceManager.createImage(imageURL);
        Cursor c = Toolkit.getDefaultToolkit().createCustomCursor(image, hotPoint, name);
        return c;
    }

    public static Cursor createCursor(String url, Point hotPoint, String name) {
        Image image = ResourceManager.createImage(url);
        Cursor c = Toolkit.getDefaultToolkit().createCustomCursor(image, hotPoint, name);
        return c;
    }

    public static void loadLibrary(String library, String classpathResource) {
        if (library == null) {
            return;
        }
        UnsatisfiedLinkError linkageError = null;
        try {
            System.loadLibrary(library);
            return;
        }
        catch (UnsatisfiedLinkError err) {
            linkageError = err;
            File file = new File(System.getProperty("user.home") + "/flexdock");
            file.mkdirs();
            file = new File(file.getAbsolutePath() + "/" + library + LIBRARY_EXTENSION);
            if (file.exists()) {
                try {
                    System.load(file.getAbsolutePath());
                    return;
                }
                catch (UnsatisfiedLinkError err2) {
                    linkageError = err2;
                }
            }
            if (classpathResource == null && linkageError != null) {
                throw linkageError;
            }
            FileOutputStream fileOut = null;
            ClassLoader cl = ResourceManager.class.getClassLoader();
            InputStream in = cl.getResourceAsStream(classpathResource);
            if (in == null) {
                throw new UnsatisfiedLinkError("Unable to locate classpath resource: " + classpathResource);
            }
            try {
                fileOut = new FileOutputStream(file);
                byte[] tmp = new byte[1024];
                int bytesRead = in.read(tmp);
                while (bytesRead != -1) {
                    fileOut.write(tmp, 0, bytesRead);
                    bytesRead = in.read(tmp);
                }
            }
            catch (IOException giveUp) {
                try {
                    UnsatisfiedLinkError err3 = new UnsatisfiedLinkError("Unable to extract resource to file: " + file.getAbsolutePath());
                    err3.initCause(giveUp);
                    throw err3;
                }
                catch (Throwable throwable) {
                    ResourceManager.close(fileOut);
                    ResourceManager.close(in);
                    throw throwable;
                }
            }
            ResourceManager.close(fileOut);
            ResourceManager.close(in);
            System.load(file.getAbsolutePath());
            return;
        }
    }

    public static Document getDocument(String uri) {
        URL resource = ResourceManager.getResource(uri);
        return ResourceManager.getDocument(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document getDocument(URL url) {
        if (url == null) {
            return null;
        }
        InputStream inStream = null;
        try {
            inStream = url.openStream();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(inStream);
            return document;
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            ResourceManager.close(inStream);
        }
        return null;
    }

    public static Properties getProperties(String uri) {
        return ResourceManager.getProperties(uri, false);
    }

    public static Properties getProperties(String uri, boolean failSilent) {
        URL url = ResourceManager.getResource(uri);
        return ResourceManager.getProperties(url, failSilent);
    }

    public static Properties getProperties(URL url) {
        return ResourceManager.getProperties(url, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(URL url, boolean failSilent) {
        if (failSilent && url == null) {
            return null;
        }
        InputStream in = null;
        try {
            in = url.openStream();
            Properties p = new Properties();
            p.load(in);
            Properties properties = p;
            return properties;
        }
        catch (Exception e) {
            if (!failSilent) {
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
            Properties properties = null;
            return properties;
        }
        finally {
            ResourceManager.close(in);
        }
    }

    public static void close(InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void close(OutputStream out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void close(Socket socket) {
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
    }
}

