// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package dns

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/dns/mgmt/2016-04-01/dns"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type HTTPStatusCode = original.HTTPStatusCode

const (
	Accepted                     HTTPStatusCode = original.Accepted
	Ambiguous                    HTTPStatusCode = original.Ambiguous
	BadGateway                   HTTPStatusCode = original.BadGateway
	BadRequest                   HTTPStatusCode = original.BadRequest
	Conflict                     HTTPStatusCode = original.Conflict
	Continue                     HTTPStatusCode = original.Continue
	Created                      HTTPStatusCode = original.Created
	ExpectationFailed            HTTPStatusCode = original.ExpectationFailed
	Forbidden                    HTTPStatusCode = original.Forbidden
	Found                        HTTPStatusCode = original.Found
	GatewayTimeout               HTTPStatusCode = original.GatewayTimeout
	Gone                         HTTPStatusCode = original.Gone
	HTTPVersionNotSupported      HTTPStatusCode = original.HTTPVersionNotSupported
	InternalServerError          HTTPStatusCode = original.InternalServerError
	LengthRequired               HTTPStatusCode = original.LengthRequired
	MethodNotAllowed             HTTPStatusCode = original.MethodNotAllowed
	Moved                        HTTPStatusCode = original.Moved
	MovedPermanently             HTTPStatusCode = original.MovedPermanently
	MultipleChoices              HTTPStatusCode = original.MultipleChoices
	NoContent                    HTTPStatusCode = original.NoContent
	NonAuthoritativeInformation  HTTPStatusCode = original.NonAuthoritativeInformation
	NotAcceptable                HTTPStatusCode = original.NotAcceptable
	NotFound                     HTTPStatusCode = original.NotFound
	NotImplemented               HTTPStatusCode = original.NotImplemented
	NotModified                  HTTPStatusCode = original.NotModified
	OK                           HTTPStatusCode = original.OK
	PartialContent               HTTPStatusCode = original.PartialContent
	PaymentRequired              HTTPStatusCode = original.PaymentRequired
	PreconditionFailed           HTTPStatusCode = original.PreconditionFailed
	ProxyAuthenticationRequired  HTTPStatusCode = original.ProxyAuthenticationRequired
	Redirect                     HTTPStatusCode = original.Redirect
	RedirectKeepVerb             HTTPStatusCode = original.RedirectKeepVerb
	RedirectMethod               HTTPStatusCode = original.RedirectMethod
	RequestedRangeNotSatisfiable HTTPStatusCode = original.RequestedRangeNotSatisfiable
	RequestEntityTooLarge        HTTPStatusCode = original.RequestEntityTooLarge
	RequestTimeout               HTTPStatusCode = original.RequestTimeout
	RequestURITooLong            HTTPStatusCode = original.RequestURITooLong
	ResetContent                 HTTPStatusCode = original.ResetContent
	SeeOther                     HTTPStatusCode = original.SeeOther
	ServiceUnavailable           HTTPStatusCode = original.ServiceUnavailable
	SwitchingProtocols           HTTPStatusCode = original.SwitchingProtocols
	TemporaryRedirect            HTTPStatusCode = original.TemporaryRedirect
	Unauthorized                 HTTPStatusCode = original.Unauthorized
	UnsupportedMediaType         HTTPStatusCode = original.UnsupportedMediaType
	Unused                       HTTPStatusCode = original.Unused
	UpgradeRequired              HTTPStatusCode = original.UpgradeRequired
	UseProxy                     HTTPStatusCode = original.UseProxy
)

type OperationStatus = original.OperationStatus

const (
	Failed     OperationStatus = original.Failed
	InProgress OperationStatus = original.InProgress
	Succeeded  OperationStatus = original.Succeeded
)

type RecordType = original.RecordType

const (
	A     RecordType = original.A
	AAAA  RecordType = original.AAAA
	CNAME RecordType = original.CNAME
	MX    RecordType = original.MX
	NS    RecordType = original.NS
	PTR   RecordType = original.PTR
	SOA   RecordType = original.SOA
	SRV   RecordType = original.SRV
	TXT   RecordType = original.TXT
)

type ARecord = original.ARecord
type AaaaRecord = original.AaaaRecord
type AzureEntityResource = original.AzureEntityResource
type BaseClient = original.BaseClient
type CloudError = original.CloudError
type CloudErrorBody = original.CloudErrorBody
type CnameRecord = original.CnameRecord
type MxRecord = original.MxRecord
type NsRecord = original.NsRecord
type ProxyResource = original.ProxyResource
type PtrRecord = original.PtrRecord
type RecordSet = original.RecordSet
type RecordSetListResult = original.RecordSetListResult
type RecordSetListResultIterator = original.RecordSetListResultIterator
type RecordSetListResultPage = original.RecordSetListResultPage
type RecordSetProperties = original.RecordSetProperties
type RecordSetUpdateParameters = original.RecordSetUpdateParameters
type RecordSetsClient = original.RecordSetsClient
type Resource = original.Resource
type SoaRecord = original.SoaRecord
type SrvRecord = original.SrvRecord
type SubResource = original.SubResource
type TrackedResource = original.TrackedResource
type TxtRecord = original.TxtRecord
type Zone = original.Zone
type ZoneDeleteResult = original.ZoneDeleteResult
type ZoneListResult = original.ZoneListResult
type ZoneListResultIterator = original.ZoneListResultIterator
type ZoneListResultPage = original.ZoneListResultPage
type ZoneProperties = original.ZoneProperties
type ZonesClient = original.ZonesClient
type ZonesDeleteFuture = original.ZonesDeleteFuture

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewRecordSetListResultIterator(page RecordSetListResultPage) RecordSetListResultIterator {
	return original.NewRecordSetListResultIterator(page)
}
func NewRecordSetListResultPage(cur RecordSetListResult, getNextPage func(context.Context, RecordSetListResult) (RecordSetListResult, error)) RecordSetListResultPage {
	return original.NewRecordSetListResultPage(cur, getNextPage)
}
func NewRecordSetsClient(subscriptionID string) RecordSetsClient {
	return original.NewRecordSetsClient(subscriptionID)
}
func NewRecordSetsClientWithBaseURI(baseURI string, subscriptionID string) RecordSetsClient {
	return original.NewRecordSetsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func NewZoneListResultIterator(page ZoneListResultPage) ZoneListResultIterator {
	return original.NewZoneListResultIterator(page)
}
func NewZoneListResultPage(cur ZoneListResult, getNextPage func(context.Context, ZoneListResult) (ZoneListResult, error)) ZoneListResultPage {
	return original.NewZoneListResultPage(cur, getNextPage)
}
func NewZonesClient(subscriptionID string) ZonesClient {
	return original.NewZonesClient(subscriptionID)
}
func NewZonesClientWithBaseURI(baseURI string, subscriptionID string) ZonesClient {
	return original.NewZonesClientWithBaseURI(baseURI, subscriptionID)
}
func PossibleHTTPStatusCodeValues() []HTTPStatusCode {
	return original.PossibleHTTPStatusCodeValues()
}
func PossibleOperationStatusValues() []OperationStatus {
	return original.PossibleOperationStatusValues()
}
func PossibleRecordTypeValues() []RecordType {
	return original.PossibleRecordTypeValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/2019-03-01"
}
func Version() string {
	return original.Version()
}
