package automanage

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/automanage/mgmt/2021-04-30-preview/automanage"

// AssignmentReportProperties data related to the report detail.
type AssignmentReportProperties struct {
	// StartTime - Start time of the configuration profile assignment processing.
	StartTime *string `json:"startTime,omitempty"`
	// EndTime - End time of the configuration profile assignment processing.
	EndTime *string `json:"endTime,omitempty"`
	// LastModifiedTime - READ-ONLY; Last modified time of the configuration profile assignment processing.
	LastModifiedTime *string `json:"lastModifiedTime,omitempty"`
	// Duration - READ-ONLY; Duration of the configuration profile assignment processing.
	Duration *string `json:"duration,omitempty"`
	// Type - READ-ONLY; Type of the configuration profile assignment processing (Initial/Consistency).
	Type *string `json:"type,omitempty"`
	// Status - READ-ONLY; The status of the configuration profile assignment.
	Status *string `json:"status,omitempty"`
	// ConfigurationProfile - READ-ONLY; The configurationProfile linked to the assignment.
	ConfigurationProfile *string `json:"configurationProfile,omitempty"`
	// Resources - READ-ONLY; List of resources processed by the configuration profile assignment.
	Resources *[]ReportResource `json:"resources,omitempty"`
	// Error - READ-ONLY; Error message, if any, returned by the configuration profile assignment processing.
	Error *ErrorDetail `json:"error,omitempty"`
	// ReportFormatVersion - READ-ONLY; Version of the report format
	ReportFormatVersion *string `json:"reportFormatVersion,omitempty"`
}

// MarshalJSON is the custom marshaler for AssignmentReportProperties.
func (arp AssignmentReportProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if arp.StartTime != nil {
		objectMap["startTime"] = arp.StartTime
	}
	if arp.EndTime != nil {
		objectMap["endTime"] = arp.EndTime
	}
	return json.Marshal(objectMap)
}

// AzureEntityResource the resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureEntityResource.
func (aer AzureEntityResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// BestPractice definition of the Automanage best practice.
type BestPractice struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The fully qualified ID for the best practice.  For example, /providers/Microsoft.Automanage/bestPractices/azureBestPracticesProduction
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; The type of the resource.  For example, Microsoft.Automanage/bestPractices
	Type *string `json:"type,omitempty"`
	// Name - READ-ONLY; The name of the best practice. For example, azureBestPracticesProduction
	Name *string `json:"name,omitempty"`
	// ConfigurationProfileProperties - Properties of the best practice.
	*ConfigurationProfileProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for BestPractice.
func (bp BestPractice) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bp.ConfigurationProfileProperties != nil {
		objectMap["properties"] = bp.ConfigurationProfileProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BestPractice struct.
func (bp *BestPractice) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bp.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bp.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bp.Name = &name
			}
		case "properties":
			if v != nil {
				var configurationProfileProperties ConfigurationProfileProperties
				err = json.Unmarshal(*v, &configurationProfileProperties)
				if err != nil {
					return err
				}
				bp.ConfigurationProfileProperties = &configurationProfileProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				bp.SystemData = &systemData
			}
		}
	}

	return nil
}

// BestPracticeList the response of the list best practice operation.
type BestPracticeList struct {
	autorest.Response `json:"-"`
	// Value - Result of the list best practice operation.
	Value *[]BestPractice `json:"value,omitempty"`
}

// ConfigurationProfile definition of the configuration profile.
type ConfigurationProfile struct {
	autorest.Response `json:"-"`
	// Properties - Properties of the configuration profile.
	Properties *ConfigurationProfileProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ConfigurationProfile.
func (cp ConfigurationProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.Properties != nil {
		objectMap["properties"] = cp.Properties
	}
	if cp.Tags != nil {
		objectMap["tags"] = cp.Tags
	}
	if cp.Location != nil {
		objectMap["location"] = cp.Location
	}
	return json.Marshal(objectMap)
}

// ConfigurationProfileAssignment configuration profile assignment is an association between a VM and
// automanage profile configuration.
type ConfigurationProfileAssignment struct {
	autorest.Response `json:"-"`
	// Properties - Properties of the configuration profile assignment.
	Properties *ConfigurationProfileAssignmentProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ConfigurationProfileAssignment.
func (cpa ConfigurationProfileAssignment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cpa.Properties != nil {
		objectMap["properties"] = cpa.Properties
	}
	return json.Marshal(objectMap)
}

// ConfigurationProfileAssignmentList the response of the list configuration profile assignment operation.
type ConfigurationProfileAssignmentList struct {
	autorest.Response `json:"-"`
	// Value - Result of the list configuration profile assignment operation.
	Value *[]ConfigurationProfileAssignment `json:"value,omitempty"`
}

// ConfigurationProfileAssignmentProperties automanage configuration profile assignment properties.
type ConfigurationProfileAssignmentProperties struct {
	// ConfigurationProfile - The Automanage configurationProfile ARM Resource URI.
	ConfigurationProfile *string `json:"configurationProfile,omitempty"`
	// TargetID - The target VM resource URI
	TargetID *string `json:"targetId,omitempty"`
	// Status - READ-ONLY; The status of onboarding, which only appears in the response.
	Status *string `json:"status,omitempty"`
	// ProfileOverrides - The profileOverrides setting for the configuration profile assignment.
	ProfileOverrides map[string]interface{} `json:"profileOverrides"`
}

// MarshalJSON is the custom marshaler for ConfigurationProfileAssignmentProperties.
func (cpap ConfigurationProfileAssignmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cpap.ConfigurationProfile != nil {
		objectMap["configurationProfile"] = cpap.ConfigurationProfile
	}
	if cpap.TargetID != nil {
		objectMap["targetId"] = cpap.TargetID
	}
	if cpap.ProfileOverrides != nil {
		objectMap["profileOverrides"] = cpap.ProfileOverrides
	}
	return json.Marshal(objectMap)
}

// ConfigurationProfileList the response of the list configuration profile operation.
type ConfigurationProfileList struct {
	autorest.Response `json:"-"`
	// Value - Result of the list ConfigurationProfile operation.
	Value *[]ConfigurationProfile `json:"value,omitempty"`
}

// ConfigurationProfileProperties automanage configuration profile properties.
type ConfigurationProfileProperties struct {
	// Configuration - configuration dictionary of the configuration profile.
	Configuration interface{} `json:"configuration,omitempty"`
	// Overrides - overrides of the configuration profile.
	Overrides *[]interface{} `json:"overrides,omitempty"`
}

// ConfigurationProfileUpdate definition of the configuration profile.
type ConfigurationProfileUpdate struct {
	// Properties - Properties of the configuration profile.
	Properties *ConfigurationProfileProperties `json:"properties,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ConfigurationProfileUpdate.
func (CPU ConfigurationProfileUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if CPU.Properties != nil {
		objectMap["properties"] = CPU.Properties
	}
	if CPU.Tags != nil {
		objectMap["tags"] = CPU.Tags
	}
	return json.Marshal(objectMap)
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorAdditionalInfo.
func (eai ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorDetail the error detail.
type ErrorDetail struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorDetail `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorDetail.
func (ed ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorResponse common error response for all Azure Resource Manager APIs to return error details for
// failed operations. (This also follows the OData error response format.).
type ErrorResponse struct {
	// Error - The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// Operation details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Name - READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action"
	Name *string `json:"name,omitempty"`
	// IsDataAction - READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane operations.
	IsDataAction *bool `json:"isDataAction,omitempty"`
	// Display - Localized display information for this particular operation.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default value is "user,system". Possible values include: 'OriginUser', 'OriginSystem', 'OriginUsersystem'
	Origin Origin `json:"origin,omitempty"`
	// ActionType - READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs. Possible values include: 'ActionTypeInternal'
	ActionType ActionType `json:"actionType,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	return json.Marshal(objectMap)
}

// OperationDisplay localized display information for this particular operation.
type OperationDisplay struct {
	// Provider - READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft Compute".
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job Schedule Collections".
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
	Operation *string `json:"operation,omitempty"`
	// Description - READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationListResult a list of REST API operations supported by an Azure Resource Provider. It contains
// an URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of operations supported by the resource provider
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationListResult.
func (olr OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ProxyResource the resource model definition for a Azure Resource Manager proxy resource. It will not
// have tags and a location
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Report definition of the report.
type Report struct {
	autorest.Response `json:"-"`
	// AssignmentReportProperties - The properties for the report.
	*AssignmentReportProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Report.
func (r Report) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.AssignmentReportProperties != nil {
		objectMap["properties"] = r.AssignmentReportProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Report struct.
func (r *Report) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var assignmentReportProperties AssignmentReportProperties
				err = json.Unmarshal(*v, &assignmentReportProperties)
				if err != nil {
					return err
				}
				r.AssignmentReportProperties = &assignmentReportProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				r.SystemData = &systemData
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				r.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				r.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				r.Type = &typeVar
			}
		}
	}

	return nil
}

// ReportList the response of the list report operation.
type ReportList struct {
	autorest.Response `json:"-"`
	// Value - Result of the list report operation.
	Value *[]Report `json:"value,omitempty"`
}

// ReportResource details about the resource processed by the configuration profile assignment
type ReportResource struct {
	// Name - READ-ONLY; Name of the resource.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; ARM id of the resource.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; Type of the resource.
	Type *string `json:"type,omitempty"`
	// Status - READ-ONLY; Status of the resource.
	Status *string `json:"status,omitempty"`
	// Error - READ-ONLY; Error message, if any, returned when deploying the resource.
	Error *ErrorDetail `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for ReportResource.
func (rr ReportResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Resource common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SystemData metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// TrackedResource the resource model definition for an Azure Resource Manager tracked top level resource
// which has 'tags' and a 'location'
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// UpdateResource represents an update resource
type UpdateResource struct {
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for UpdateResource.
func (ur UpdateResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ur.Tags != nil {
		objectMap["tags"] = ur.Tags
	}
	return json.Marshal(objectMap)
}
