package documentdbapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/cosmos-db/mgmt/2021-11-15-preview/documentdb"
	"github.com/Azure/go-autorest/autorest"
)

// DatabaseAccountsClientAPI contains the set of methods on the DatabaseAccountsClient type.
type DatabaseAccountsClientAPI interface {
	CheckNameExists(ctx context.Context, accountName string) (result autorest.Response, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, accountName string, createUpdateParameters documentdb.DatabaseAccountCreateUpdateParameters) (result documentdb.DatabaseAccountsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, accountName string) (result documentdb.DatabaseAccountsDeleteFuture, err error)
	FailoverPriorityChange(ctx context.Context, resourceGroupName string, accountName string, failoverParameters documentdb.FailoverPolicies) (result documentdb.DatabaseAccountsFailoverPriorityChangeFuture, err error)
	Get(ctx context.Context, resourceGroupName string, accountName string) (result documentdb.DatabaseAccountGetResults, err error)
	GetReadOnlyKeys(ctx context.Context, resourceGroupName string, accountName string) (result documentdb.DatabaseAccountListReadOnlyKeysResult, err error)
	List(ctx context.Context) (result documentdb.DatabaseAccountsListResult, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result documentdb.DatabaseAccountsListResult, err error)
	ListConnectionStrings(ctx context.Context, resourceGroupName string, accountName string) (result documentdb.DatabaseAccountListConnectionStringsResult, err error)
	ListKeys(ctx context.Context, resourceGroupName string, accountName string) (result documentdb.DatabaseAccountListKeysResult, err error)
	ListMetricDefinitions(ctx context.Context, resourceGroupName string, accountName string) (result documentdb.MetricDefinitionsListResult, err error)
	ListMetrics(ctx context.Context, resourceGroupName string, accountName string, filter string) (result documentdb.MetricListResult, err error)
	ListReadOnlyKeys(ctx context.Context, resourceGroupName string, accountName string) (result documentdb.DatabaseAccountListReadOnlyKeysResult, err error)
	ListUsages(ctx context.Context, resourceGroupName string, accountName string, filter string) (result documentdb.UsagesResult, err error)
	OfflineRegion(ctx context.Context, resourceGroupName string, accountName string, regionParameterForOffline documentdb.RegionForOnlineOffline) (result documentdb.DatabaseAccountsOfflineRegionFuture, err error)
	OnlineRegion(ctx context.Context, resourceGroupName string, accountName string, regionParameterForOnline documentdb.RegionForOnlineOffline) (result documentdb.DatabaseAccountsOnlineRegionFuture, err error)
	RegenerateKey(ctx context.Context, resourceGroupName string, accountName string, keyToRegenerate documentdb.DatabaseAccountRegenerateKeyParameters) (result documentdb.DatabaseAccountsRegenerateKeyFuture, err error)
	Update(ctx context.Context, resourceGroupName string, accountName string, updateParameters documentdb.DatabaseAccountUpdateParameters) (result documentdb.DatabaseAccountsUpdateFuture, err error)
}

var _ DatabaseAccountsClientAPI = (*documentdb.DatabaseAccountsClient)(nil)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result documentdb.OperationListResultPage, err error)
	ListComplete(ctx context.Context) (result documentdb.OperationListResultIterator, err error)
}

var _ OperationsClientAPI = (*documentdb.OperationsClient)(nil)

// DatabaseClientAPI contains the set of methods on the DatabaseClient type.
type DatabaseClientAPI interface {
	ListMetricDefinitions(ctx context.Context, resourceGroupName string, accountName string, databaseRid string) (result documentdb.MetricDefinitionsListResult, err error)
	ListMetrics(ctx context.Context, resourceGroupName string, accountName string, databaseRid string, filter string) (result documentdb.MetricListResult, err error)
	ListUsages(ctx context.Context, resourceGroupName string, accountName string, databaseRid string, filter string) (result documentdb.UsagesResult, err error)
}

var _ DatabaseClientAPI = (*documentdb.DatabaseClient)(nil)

// CollectionClientAPI contains the set of methods on the CollectionClient type.
type CollectionClientAPI interface {
	ListMetricDefinitions(ctx context.Context, resourceGroupName string, accountName string, databaseRid string, collectionRid string) (result documentdb.MetricDefinitionsListResult, err error)
	ListMetrics(ctx context.Context, resourceGroupName string, accountName string, databaseRid string, collectionRid string, filter string) (result documentdb.MetricListResult, err error)
	ListUsages(ctx context.Context, resourceGroupName string, accountName string, databaseRid string, collectionRid string, filter string) (result documentdb.UsagesResult, err error)
}

var _ CollectionClientAPI = (*documentdb.CollectionClient)(nil)

// CollectionRegionClientAPI contains the set of methods on the CollectionRegionClient type.
type CollectionRegionClientAPI interface {
	ListMetrics(ctx context.Context, resourceGroupName string, accountName string, region string, databaseRid string, collectionRid string, filter string) (result documentdb.MetricListResult, err error)
}

var _ CollectionRegionClientAPI = (*documentdb.CollectionRegionClient)(nil)

// DatabaseAccountRegionClientAPI contains the set of methods on the DatabaseAccountRegionClient type.
type DatabaseAccountRegionClientAPI interface {
	ListMetrics(ctx context.Context, resourceGroupName string, accountName string, region string, filter string) (result documentdb.MetricListResult, err error)
}

var _ DatabaseAccountRegionClientAPI = (*documentdb.DatabaseAccountRegionClient)(nil)

// PercentileSourceTargetClientAPI contains the set of methods on the PercentileSourceTargetClient type.
type PercentileSourceTargetClientAPI interface {
	ListMetrics(ctx context.Context, resourceGroupName string, accountName string, sourceRegion string, targetRegion string, filter string) (result documentdb.PercentileMetricListResult, err error)
}

var _ PercentileSourceTargetClientAPI = (*documentdb.PercentileSourceTargetClient)(nil)

// PercentileTargetClientAPI contains the set of methods on the PercentileTargetClient type.
type PercentileTargetClientAPI interface {
	ListMetrics(ctx context.Context, resourceGroupName string, accountName string, targetRegion string, filter string) (result documentdb.PercentileMetricListResult, err error)
}

var _ PercentileTargetClientAPI = (*documentdb.PercentileTargetClient)(nil)

// PercentileClientAPI contains the set of methods on the PercentileClient type.
type PercentileClientAPI interface {
	ListMetrics(ctx context.Context, resourceGroupName string, accountName string, filter string) (result documentdb.PercentileMetricListResult, err error)
}

var _ PercentileClientAPI = (*documentdb.PercentileClient)(nil)

// CollectionPartitionRegionClientAPI contains the set of methods on the CollectionPartitionRegionClient type.
type CollectionPartitionRegionClientAPI interface {
	ListMetrics(ctx context.Context, resourceGroupName string, accountName string, region string, databaseRid string, collectionRid string, filter string) (result documentdb.PartitionMetricListResult, err error)
}

var _ CollectionPartitionRegionClientAPI = (*documentdb.CollectionPartitionRegionClient)(nil)

// CollectionPartitionClientAPI contains the set of methods on the CollectionPartitionClient type.
type CollectionPartitionClientAPI interface {
	ListMetrics(ctx context.Context, resourceGroupName string, accountName string, databaseRid string, collectionRid string, filter string) (result documentdb.PartitionMetricListResult, err error)
	ListUsages(ctx context.Context, resourceGroupName string, accountName string, databaseRid string, collectionRid string, filter string) (result documentdb.PartitionUsagesResult, err error)
}

var _ CollectionPartitionClientAPI = (*documentdb.CollectionPartitionClient)(nil)

// PartitionKeyRangeIDClientAPI contains the set of methods on the PartitionKeyRangeIDClient type.
type PartitionKeyRangeIDClientAPI interface {
	ListMetrics(ctx context.Context, resourceGroupName string, accountName string, databaseRid string, collectionRid string, partitionKeyRangeID string, filter string) (result documentdb.PartitionMetricListResult, err error)
}

var _ PartitionKeyRangeIDClientAPI = (*documentdb.PartitionKeyRangeIDClient)(nil)

// PartitionKeyRangeIDRegionClientAPI contains the set of methods on the PartitionKeyRangeIDRegionClient type.
type PartitionKeyRangeIDRegionClientAPI interface {
	ListMetrics(ctx context.Context, resourceGroupName string, accountName string, region string, databaseRid string, collectionRid string, partitionKeyRangeID string, filter string) (result documentdb.PartitionMetricListResult, err error)
}

var _ PartitionKeyRangeIDRegionClientAPI = (*documentdb.PartitionKeyRangeIDRegionClient)(nil)

// GraphResourcesClientAPI contains the set of methods on the GraphResourcesClient type.
type GraphResourcesClientAPI interface {
	CreateUpdateGraph(ctx context.Context, resourceGroupName string, accountName string, graphName string, createUpdateGraphParameters documentdb.GraphResourceCreateUpdateParameters) (result documentdb.GraphResourcesCreateUpdateGraphFuture, err error)
	DeleteGraphResource(ctx context.Context, resourceGroupName string, accountName string, graphName string) (result documentdb.GraphResourcesDeleteGraphResourceFuture, err error)
	GetGraph(ctx context.Context, resourceGroupName string, accountName string, graphName string) (result documentdb.GraphResourceGetResults, err error)
	ListGraphs(ctx context.Context, resourceGroupName string, accountName string) (result documentdb.GraphResourcesListResult, err error)
}

var _ GraphResourcesClientAPI = (*documentdb.GraphResourcesClient)(nil)

// SQLResourcesClientAPI contains the set of methods on the SQLResourcesClient type.
type SQLResourcesClientAPI interface {
	CreateUpdateClientEncryptionKey(ctx context.Context, resourceGroupName string, accountName string, databaseName string, clientEncryptionKeyName string, createUpdateClientEncryptionKeyParameters documentdb.ClientEncryptionKeyCreateUpdateParameters) (result documentdb.SQLResourcesCreateUpdateClientEncryptionKeyFuture, err error)
	CreateUpdateSQLContainer(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, createUpdateSQLContainerParameters documentdb.SQLContainerCreateUpdateParameters) (result documentdb.SQLResourcesCreateUpdateSQLContainerFuture, err error)
	CreateUpdateSQLDatabase(ctx context.Context, resourceGroupName string, accountName string, databaseName string, createUpdateSQLDatabaseParameters documentdb.SQLDatabaseCreateUpdateParameters) (result documentdb.SQLResourcesCreateUpdateSQLDatabaseFuture, err error)
	CreateUpdateSQLRoleAssignment(ctx context.Context, roleAssignmentID string, resourceGroupName string, accountName string, createUpdateSQLRoleAssignmentParameters documentdb.SQLRoleAssignmentCreateUpdateParameters) (result documentdb.SQLResourcesCreateUpdateSQLRoleAssignmentFuture, err error)
	CreateUpdateSQLRoleDefinition(ctx context.Context, roleDefinitionID string, resourceGroupName string, accountName string, createUpdateSQLRoleDefinitionParameters documentdb.SQLRoleDefinitionCreateUpdateParameters) (result documentdb.SQLResourcesCreateUpdateSQLRoleDefinitionFuture, err error)
	CreateUpdateSQLStoredProcedure(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, storedProcedureName string, createUpdateSQLStoredProcedureParameters documentdb.SQLStoredProcedureCreateUpdateParameters) (result documentdb.SQLResourcesCreateUpdateSQLStoredProcedureFuture, err error)
	CreateUpdateSQLTrigger(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, triggerName string, createUpdateSQLTriggerParameters documentdb.SQLTriggerCreateUpdateParameters) (result documentdb.SQLResourcesCreateUpdateSQLTriggerFuture, err error)
	CreateUpdateSQLUserDefinedFunction(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, userDefinedFunctionName string, createUpdateSQLUserDefinedFunctionParameters documentdb.SQLUserDefinedFunctionCreateUpdateParameters) (result documentdb.SQLResourcesCreateUpdateSQLUserDefinedFunctionFuture, err error)
	DeleteSQLContainer(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string) (result documentdb.SQLResourcesDeleteSQLContainerFuture, err error)
	DeleteSQLDatabase(ctx context.Context, resourceGroupName string, accountName string, databaseName string) (result documentdb.SQLResourcesDeleteSQLDatabaseFuture, err error)
	DeleteSQLRoleAssignment(ctx context.Context, roleAssignmentID string, resourceGroupName string, accountName string) (result documentdb.SQLResourcesDeleteSQLRoleAssignmentFuture, err error)
	DeleteSQLRoleDefinition(ctx context.Context, roleDefinitionID string, resourceGroupName string, accountName string) (result documentdb.SQLResourcesDeleteSQLRoleDefinitionFuture, err error)
	DeleteSQLStoredProcedure(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, storedProcedureName string) (result documentdb.SQLResourcesDeleteSQLStoredProcedureFuture, err error)
	DeleteSQLTrigger(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, triggerName string) (result documentdb.SQLResourcesDeleteSQLTriggerFuture, err error)
	DeleteSQLUserDefinedFunction(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, userDefinedFunctionName string) (result documentdb.SQLResourcesDeleteSQLUserDefinedFunctionFuture, err error)
	GetClientEncryptionKey(ctx context.Context, resourceGroupName string, accountName string, databaseName string, clientEncryptionKeyName string) (result documentdb.ClientEncryptionKeyGetResults, err error)
	GetSQLContainer(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string) (result documentdb.SQLContainerGetResults, err error)
	GetSQLContainerThroughput(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string) (result documentdb.ThroughputSettingsGetResults, err error)
	GetSQLDatabase(ctx context.Context, resourceGroupName string, accountName string, databaseName string) (result documentdb.SQLDatabaseGetResults, err error)
	GetSQLDatabaseThroughput(ctx context.Context, resourceGroupName string, accountName string, databaseName string) (result documentdb.ThroughputSettingsGetResults, err error)
	GetSQLRoleAssignment(ctx context.Context, roleAssignmentID string, resourceGroupName string, accountName string) (result documentdb.SQLRoleAssignmentGetResults, err error)
	GetSQLRoleDefinition(ctx context.Context, roleDefinitionID string, resourceGroupName string, accountName string) (result documentdb.SQLRoleDefinitionGetResults, err error)
	GetSQLStoredProcedure(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, storedProcedureName string) (result documentdb.SQLStoredProcedureGetResults, err error)
	GetSQLTrigger(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, triggerName string) (result documentdb.SQLTriggerGetResults, err error)
	GetSQLUserDefinedFunction(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, userDefinedFunctionName string) (result documentdb.SQLUserDefinedFunctionGetResults, err error)
	ListClientEncryptionKeys(ctx context.Context, resourceGroupName string, accountName string, databaseName string) (result documentdb.ClientEncryptionKeysListResult, err error)
	ListSQLContainers(ctx context.Context, resourceGroupName string, accountName string, databaseName string) (result documentdb.SQLContainerListResult, err error)
	ListSQLDatabases(ctx context.Context, resourceGroupName string, accountName string) (result documentdb.SQLDatabaseListResult, err error)
	ListSQLRoleAssignments(ctx context.Context, resourceGroupName string, accountName string) (result documentdb.SQLRoleAssignmentListResult, err error)
	ListSQLRoleDefinitions(ctx context.Context, resourceGroupName string, accountName string) (result documentdb.SQLRoleDefinitionListResult, err error)
	ListSQLStoredProcedures(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string) (result documentdb.SQLStoredProcedureListResult, err error)
	ListSQLTriggers(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string) (result documentdb.SQLTriggerListResult, err error)
	ListSQLUserDefinedFunctions(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string) (result documentdb.SQLUserDefinedFunctionListResult, err error)
	MigrateSQLContainerToAutoscale(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string) (result documentdb.SQLResourcesMigrateSQLContainerToAutoscaleFuture, err error)
	MigrateSQLContainerToManualThroughput(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string) (result documentdb.SQLResourcesMigrateSQLContainerToManualThroughputFuture, err error)
	MigrateSQLDatabaseToAutoscale(ctx context.Context, resourceGroupName string, accountName string, databaseName string) (result documentdb.SQLResourcesMigrateSQLDatabaseToAutoscaleFuture, err error)
	MigrateSQLDatabaseToManualThroughput(ctx context.Context, resourceGroupName string, accountName string, databaseName string) (result documentdb.SQLResourcesMigrateSQLDatabaseToManualThroughputFuture, err error)
	RetrieveContinuousBackupInformation(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, location documentdb.ContinuousBackupRestoreLocation) (result documentdb.SQLResourcesRetrieveContinuousBackupInformationFuture, err error)
	UpdateSQLContainerThroughput(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, updateThroughputParameters documentdb.ThroughputSettingsUpdateParameters) (result documentdb.SQLResourcesUpdateSQLContainerThroughputFuture, err error)
	UpdateSQLDatabaseThroughput(ctx context.Context, resourceGroupName string, accountName string, databaseName string, updateThroughputParameters documentdb.ThroughputSettingsUpdateParameters) (result documentdb.SQLResourcesUpdateSQLDatabaseThroughputFuture, err error)
}

var _ SQLResourcesClientAPI = (*documentdb.SQLResourcesClient)(nil)

// MongoDBResourcesClientAPI contains the set of methods on the MongoDBResourcesClient type.
type MongoDBResourcesClientAPI interface {
	CreateUpdateMongoDBCollection(ctx context.Context, resourceGroupName string, accountName string, databaseName string, collectionName string, createUpdateMongoDBCollectionParameters documentdb.MongoDBCollectionCreateUpdateParameters) (result documentdb.MongoDBResourcesCreateUpdateMongoDBCollectionFuture, err error)
	CreateUpdateMongoDBDatabase(ctx context.Context, resourceGroupName string, accountName string, databaseName string, createUpdateMongoDBDatabaseParameters documentdb.MongoDBDatabaseCreateUpdateParameters) (result documentdb.MongoDBResourcesCreateUpdateMongoDBDatabaseFuture, err error)
	CreateUpdateMongoRoleDefinition(ctx context.Context, mongoRoleDefinitionID string, resourceGroupName string, accountName string, createUpdateMongoRoleDefinitionParameters documentdb.MongoRoleDefinitionCreateUpdateParameters) (result documentdb.MongoDBResourcesCreateUpdateMongoRoleDefinitionFuture, err error)
	CreateUpdateMongoUserDefinition(ctx context.Context, mongoUserDefinitionID string, resourceGroupName string, accountName string, createUpdateMongoUserDefinitionParameters documentdb.MongoUserDefinitionCreateUpdateParameters) (result documentdb.MongoDBResourcesCreateUpdateMongoUserDefinitionFuture, err error)
	DeleteMongoDBCollection(ctx context.Context, resourceGroupName string, accountName string, databaseName string, collectionName string) (result documentdb.MongoDBResourcesDeleteMongoDBCollectionFuture, err error)
	DeleteMongoDBDatabase(ctx context.Context, resourceGroupName string, accountName string, databaseName string) (result documentdb.MongoDBResourcesDeleteMongoDBDatabaseFuture, err error)
	DeleteMongoRoleDefinition(ctx context.Context, mongoRoleDefinitionID string, resourceGroupName string, accountName string) (result documentdb.MongoDBResourcesDeleteMongoRoleDefinitionFuture, err error)
	DeleteMongoUserDefinition(ctx context.Context, mongoUserDefinitionID string, resourceGroupName string, accountName string) (result documentdb.MongoDBResourcesDeleteMongoUserDefinitionFuture, err error)
	GetMongoDBCollection(ctx context.Context, resourceGroupName string, accountName string, databaseName string, collectionName string) (result documentdb.MongoDBCollectionGetResults, err error)
	GetMongoDBCollectionThroughput(ctx context.Context, resourceGroupName string, accountName string, databaseName string, collectionName string) (result documentdb.ThroughputSettingsGetResults, err error)
	GetMongoDBDatabase(ctx context.Context, resourceGroupName string, accountName string, databaseName string) (result documentdb.MongoDBDatabaseGetResults, err error)
	GetMongoDBDatabaseThroughput(ctx context.Context, resourceGroupName string, accountName string, databaseName string) (result documentdb.ThroughputSettingsGetResults, err error)
	GetMongoRoleDefinition(ctx context.Context, mongoRoleDefinitionID string, resourceGroupName string, accountName string) (result documentdb.MongoRoleDefinitionGetResults, err error)
	GetMongoUserDefinition(ctx context.Context, mongoUserDefinitionID string, resourceGroupName string, accountName string) (result documentdb.MongoUserDefinitionGetResults, err error)
	ListMongoDBCollections(ctx context.Context, resourceGroupName string, accountName string, databaseName string) (result documentdb.MongoDBCollectionListResult, err error)
	ListMongoDBDatabases(ctx context.Context, resourceGroupName string, accountName string) (result documentdb.MongoDBDatabaseListResult, err error)
	ListMongoRoleDefinitions(ctx context.Context, resourceGroupName string, accountName string) (result documentdb.MongoRoleDefinitionListResult, err error)
	ListMongoUserDefinitions(ctx context.Context, resourceGroupName string, accountName string) (result documentdb.MongoUserDefinitionListResult, err error)
	MigrateMongoDBCollectionToAutoscale(ctx context.Context, resourceGroupName string, accountName string, databaseName string, collectionName string) (result documentdb.MongoDBResourcesMigrateMongoDBCollectionToAutoscaleFuture, err error)
	MigrateMongoDBCollectionToManualThroughput(ctx context.Context, resourceGroupName string, accountName string, databaseName string, collectionName string) (result documentdb.MongoDBResourcesMigrateMongoDBCollectionToManualThroughputFuture, err error)
	MigrateMongoDBDatabaseToAutoscale(ctx context.Context, resourceGroupName string, accountName string, databaseName string) (result documentdb.MongoDBResourcesMigrateMongoDBDatabaseToAutoscaleFuture, err error)
	MigrateMongoDBDatabaseToManualThroughput(ctx context.Context, resourceGroupName string, accountName string, databaseName string) (result documentdb.MongoDBResourcesMigrateMongoDBDatabaseToManualThroughputFuture, err error)
	RetrieveContinuousBackupInformation(ctx context.Context, resourceGroupName string, accountName string, databaseName string, collectionName string, location documentdb.ContinuousBackupRestoreLocation) (result documentdb.MongoDBResourcesRetrieveContinuousBackupInformationFuture, err error)
	UpdateMongoDBCollectionThroughput(ctx context.Context, resourceGroupName string, accountName string, databaseName string, collectionName string, updateThroughputParameters documentdb.ThroughputSettingsUpdateParameters) (result documentdb.MongoDBResourcesUpdateMongoDBCollectionThroughputFuture, err error)
	UpdateMongoDBDatabaseThroughput(ctx context.Context, resourceGroupName string, accountName string, databaseName string, updateThroughputParameters documentdb.ThroughputSettingsUpdateParameters) (result documentdb.MongoDBResourcesUpdateMongoDBDatabaseThroughputFuture, err error)
}

var _ MongoDBResourcesClientAPI = (*documentdb.MongoDBResourcesClient)(nil)

// TableResourcesClientAPI contains the set of methods on the TableResourcesClient type.
type TableResourcesClientAPI interface {
	CreateUpdateTable(ctx context.Context, resourceGroupName string, accountName string, tableName string, createUpdateTableParameters documentdb.TableCreateUpdateParameters) (result documentdb.TableResourcesCreateUpdateTableFuture, err error)
	DeleteTable(ctx context.Context, resourceGroupName string, accountName string, tableName string) (result documentdb.TableResourcesDeleteTableFuture, err error)
	GetTable(ctx context.Context, resourceGroupName string, accountName string, tableName string) (result documentdb.TableGetResults, err error)
	GetTableThroughput(ctx context.Context, resourceGroupName string, accountName string, tableName string) (result documentdb.ThroughputSettingsGetResults, err error)
	ListTables(ctx context.Context, resourceGroupName string, accountName string) (result documentdb.TableListResult, err error)
	MigrateTableToAutoscale(ctx context.Context, resourceGroupName string, accountName string, tableName string) (result documentdb.TableResourcesMigrateTableToAutoscaleFuture, err error)
	MigrateTableToManualThroughput(ctx context.Context, resourceGroupName string, accountName string, tableName string) (result documentdb.TableResourcesMigrateTableToManualThroughputFuture, err error)
	RetrieveContinuousBackupInformation(ctx context.Context, resourceGroupName string, accountName string, tableName string, location documentdb.ContinuousBackupRestoreLocation) (result documentdb.TableResourcesRetrieveContinuousBackupInformationFuture, err error)
	UpdateTableThroughput(ctx context.Context, resourceGroupName string, accountName string, tableName string, updateThroughputParameters documentdb.ThroughputSettingsUpdateParameters) (result documentdb.TableResourcesUpdateTableThroughputFuture, err error)
}

var _ TableResourcesClientAPI = (*documentdb.TableResourcesClient)(nil)

// CassandraResourcesClientAPI contains the set of methods on the CassandraResourcesClient type.
type CassandraResourcesClientAPI interface {
	CreateUpdateCassandraKeyspace(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, createUpdateCassandraKeyspaceParameters documentdb.CassandraKeyspaceCreateUpdateParameters) (result documentdb.CassandraResourcesCreateUpdateCassandraKeyspaceFuture, err error)
	CreateUpdateCassandraTable(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, tableName string, createUpdateCassandraTableParameters documentdb.CassandraTableCreateUpdateParameters) (result documentdb.CassandraResourcesCreateUpdateCassandraTableFuture, err error)
	CreateUpdateCassandraView(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, viewName string, createUpdateCassandraViewParameters documentdb.CassandraViewCreateUpdateParameters) (result documentdb.CassandraResourcesCreateUpdateCassandraViewFuture, err error)
	DeleteCassandraKeyspace(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string) (result documentdb.CassandraResourcesDeleteCassandraKeyspaceFuture, err error)
	DeleteCassandraTable(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, tableName string) (result documentdb.CassandraResourcesDeleteCassandraTableFuture, err error)
	DeleteCassandraView(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, viewName string) (result documentdb.CassandraResourcesDeleteCassandraViewFuture, err error)
	GetCassandraKeyspace(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string) (result documentdb.CassandraKeyspaceGetResults, err error)
	GetCassandraKeyspaceThroughput(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string) (result documentdb.ThroughputSettingsGetResults, err error)
	GetCassandraTable(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, tableName string) (result documentdb.CassandraTableGetResults, err error)
	GetCassandraTableThroughput(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, tableName string) (result documentdb.ThroughputSettingsGetResults, err error)
	GetCassandraView(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, viewName string) (result documentdb.CassandraViewGetResults, err error)
	GetCassandraViewThroughput(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, viewName string) (result documentdb.ThroughputSettingsGetResults, err error)
	ListCassandraKeyspaces(ctx context.Context, resourceGroupName string, accountName string) (result documentdb.CassandraKeyspaceListResult, err error)
	ListCassandraTables(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string) (result documentdb.CassandraTableListResult, err error)
	ListCassandraViews(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string) (result documentdb.CassandraViewListResult, err error)
	MigrateCassandraKeyspaceToAutoscale(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string) (result documentdb.CassandraResourcesMigrateCassandraKeyspaceToAutoscaleFuture, err error)
	MigrateCassandraKeyspaceToManualThroughput(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string) (result documentdb.CassandraResourcesMigrateCassandraKeyspaceToManualThroughputFuture, err error)
	MigrateCassandraTableToAutoscale(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, tableName string) (result documentdb.CassandraResourcesMigrateCassandraTableToAutoscaleFuture, err error)
	MigrateCassandraTableToManualThroughput(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, tableName string) (result documentdb.CassandraResourcesMigrateCassandraTableToManualThroughputFuture, err error)
	MigrateCassandraViewToAutoscale(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, viewName string) (result documentdb.CassandraResourcesMigrateCassandraViewToAutoscaleFuture, err error)
	MigrateCassandraViewToManualThroughput(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, viewName string) (result documentdb.CassandraResourcesMigrateCassandraViewToManualThroughputFuture, err error)
	UpdateCassandraKeyspaceThroughput(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, updateThroughputParameters documentdb.ThroughputSettingsUpdateParameters) (result documentdb.CassandraResourcesUpdateCassandraKeyspaceThroughputFuture, err error)
	UpdateCassandraTableThroughput(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, tableName string, updateThroughputParameters documentdb.ThroughputSettingsUpdateParameters) (result documentdb.CassandraResourcesUpdateCassandraTableThroughputFuture, err error)
	UpdateCassandraViewThroughput(ctx context.Context, resourceGroupName string, accountName string, keyspaceName string, viewName string, updateThroughputParameters documentdb.ThroughputSettingsUpdateParameters) (result documentdb.CassandraResourcesUpdateCassandraViewThroughputFuture, err error)
}

var _ CassandraResourcesClientAPI = (*documentdb.CassandraResourcesClient)(nil)

// GremlinResourcesClientAPI contains the set of methods on the GremlinResourcesClient type.
type GremlinResourcesClientAPI interface {
	CreateUpdateGremlinDatabase(ctx context.Context, resourceGroupName string, accountName string, databaseName string, createUpdateGremlinDatabaseParameters documentdb.GremlinDatabaseCreateUpdateParameters) (result documentdb.GremlinResourcesCreateUpdateGremlinDatabaseFuture, err error)
	CreateUpdateGremlinGraph(ctx context.Context, resourceGroupName string, accountName string, databaseName string, graphName string, createUpdateGremlinGraphParameters documentdb.GremlinGraphCreateUpdateParameters) (result documentdb.GremlinResourcesCreateUpdateGremlinGraphFuture, err error)
	DeleteGremlinDatabase(ctx context.Context, resourceGroupName string, accountName string, databaseName string) (result documentdb.GremlinResourcesDeleteGremlinDatabaseFuture, err error)
	DeleteGremlinGraph(ctx context.Context, resourceGroupName string, accountName string, databaseName string, graphName string) (result documentdb.GremlinResourcesDeleteGremlinGraphFuture, err error)
	GetGremlinDatabase(ctx context.Context, resourceGroupName string, accountName string, databaseName string) (result documentdb.GremlinDatabaseGetResults, err error)
	GetGremlinDatabaseThroughput(ctx context.Context, resourceGroupName string, accountName string, databaseName string) (result documentdb.ThroughputSettingsGetResults, err error)
	GetGremlinGraph(ctx context.Context, resourceGroupName string, accountName string, databaseName string, graphName string) (result documentdb.GremlinGraphGetResults, err error)
	GetGremlinGraphThroughput(ctx context.Context, resourceGroupName string, accountName string, databaseName string, graphName string) (result documentdb.ThroughputSettingsGetResults, err error)
	ListGremlinDatabases(ctx context.Context, resourceGroupName string, accountName string) (result documentdb.GremlinDatabaseListResult, err error)
	ListGremlinGraphs(ctx context.Context, resourceGroupName string, accountName string, databaseName string) (result documentdb.GremlinGraphListResult, err error)
	MigrateGremlinDatabaseToAutoscale(ctx context.Context, resourceGroupName string, accountName string, databaseName string) (result documentdb.GremlinResourcesMigrateGremlinDatabaseToAutoscaleFuture, err error)
	MigrateGremlinDatabaseToManualThroughput(ctx context.Context, resourceGroupName string, accountName string, databaseName string) (result documentdb.GremlinResourcesMigrateGremlinDatabaseToManualThroughputFuture, err error)
	MigrateGremlinGraphToAutoscale(ctx context.Context, resourceGroupName string, accountName string, databaseName string, graphName string) (result documentdb.GremlinResourcesMigrateGremlinGraphToAutoscaleFuture, err error)
	MigrateGremlinGraphToManualThroughput(ctx context.Context, resourceGroupName string, accountName string, databaseName string, graphName string) (result documentdb.GremlinResourcesMigrateGremlinGraphToManualThroughputFuture, err error)
	RetrieveContinuousBackupInformation(ctx context.Context, resourceGroupName string, accountName string, databaseName string, graphName string, location documentdb.ContinuousBackupRestoreLocation) (result documentdb.GremlinResourcesRetrieveContinuousBackupInformationFuture, err error)
	UpdateGremlinDatabaseThroughput(ctx context.Context, resourceGroupName string, accountName string, databaseName string, updateThroughputParameters documentdb.ThroughputSettingsUpdateParameters) (result documentdb.GremlinResourcesUpdateGremlinDatabaseThroughputFuture, err error)
	UpdateGremlinGraphThroughput(ctx context.Context, resourceGroupName string, accountName string, databaseName string, graphName string, updateThroughputParameters documentdb.ThroughputSettingsUpdateParameters) (result documentdb.GremlinResourcesUpdateGremlinGraphThroughputFuture, err error)
}

var _ GremlinResourcesClientAPI = (*documentdb.GremlinResourcesClient)(nil)

// LocationsClientAPI contains the set of methods on the LocationsClient type.
type LocationsClientAPI interface {
	Get(ctx context.Context, location string) (result documentdb.LocationGetResult, err error)
	List(ctx context.Context) (result documentdb.LocationListResult, err error)
}

var _ LocationsClientAPI = (*documentdb.LocationsClient)(nil)

// DataTransferJobsClientAPI contains the set of methods on the DataTransferJobsClient type.
type DataTransferJobsClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, accountName string, jobName string, jobCreateParameters documentdb.CreateJobRequest) (result documentdb.DataTransferJobGetResults, err error)
	Get(ctx context.Context, resourceGroupName string, accountName string, jobName string) (result documentdb.DataTransferJobGetResults, err error)
	ListByDatabaseAccount(ctx context.Context, resourceGroupName string, accountName string) (result documentdb.DataTransferJobFeedResultsPage, err error)
	ListByDatabaseAccountComplete(ctx context.Context, resourceGroupName string, accountName string) (result documentdb.DataTransferJobFeedResultsIterator, err error)
}

var _ DataTransferJobsClientAPI = (*documentdb.DataTransferJobsClient)(nil)

// CassandraClustersClientAPI contains the set of methods on the CassandraClustersClient type.
type CassandraClustersClientAPI interface {
	CreateUpdate(ctx context.Context, resourceGroupName string, clusterName string, body documentdb.ClusterResource) (result documentdb.CassandraClustersCreateUpdateFuture, err error)
	Deallocate(ctx context.Context, resourceGroupName string, clusterName string) (result documentdb.CassandraClustersDeallocateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, clusterName string) (result documentdb.CassandraClustersDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, clusterName string) (result documentdb.ClusterResource, err error)
	GetBackup(ctx context.Context, resourceGroupName string, clusterName string, backupID string) (result documentdb.BackupResource, err error)
	InvokeCommand(ctx context.Context, resourceGroupName string, clusterName string, body documentdb.CommandPostBody) (result documentdb.CassandraClustersInvokeCommandFuture, err error)
	ListBackupsMethod(ctx context.Context, resourceGroupName string, clusterName string) (result documentdb.ListBackups, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result documentdb.ListClusters, err error)
	ListBySubscription(ctx context.Context) (result documentdb.ListClusters, err error)
	Start(ctx context.Context, resourceGroupName string, clusterName string) (result documentdb.CassandraClustersStartFuture, err error)
	Status(ctx context.Context, resourceGroupName string, clusterName string) (result documentdb.CassandraClusterPublicStatus, err error)
	Update(ctx context.Context, resourceGroupName string, clusterName string, body documentdb.ClusterResource) (result documentdb.CassandraClustersUpdateFuture, err error)
}

var _ CassandraClustersClientAPI = (*documentdb.CassandraClustersClient)(nil)

// CassandraDataCentersClientAPI contains the set of methods on the CassandraDataCentersClient type.
type CassandraDataCentersClientAPI interface {
	CreateUpdate(ctx context.Context, resourceGroupName string, clusterName string, dataCenterName string, body documentdb.DataCenterResource) (result documentdb.CassandraDataCentersCreateUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, clusterName string, dataCenterName string) (result documentdb.CassandraDataCentersDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, clusterName string, dataCenterName string) (result documentdb.DataCenterResource, err error)
	List(ctx context.Context, resourceGroupName string, clusterName string) (result documentdb.ListDataCenters, err error)
	Update(ctx context.Context, resourceGroupName string, clusterName string, dataCenterName string, body documentdb.DataCenterResource) (result documentdb.CassandraDataCentersUpdateFuture, err error)
}

var _ CassandraDataCentersClientAPI = (*documentdb.CassandraDataCentersClient)(nil)

// NotebookWorkspacesClientAPI contains the set of methods on the NotebookWorkspacesClient type.
type NotebookWorkspacesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, accountName string, notebookCreateUpdateParameters documentdb.NotebookWorkspaceCreateUpdateParameters) (result documentdb.NotebookWorkspacesCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, accountName string) (result documentdb.NotebookWorkspacesDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, accountName string) (result documentdb.NotebookWorkspace, err error)
	ListByDatabaseAccount(ctx context.Context, resourceGroupName string, accountName string) (result documentdb.NotebookWorkspaceListResult, err error)
	ListConnectionInfo(ctx context.Context, resourceGroupName string, accountName string) (result documentdb.NotebookWorkspaceConnectionInfoResult, err error)
	RegenerateAuthToken(ctx context.Context, resourceGroupName string, accountName string) (result documentdb.NotebookWorkspacesRegenerateAuthTokenFuture, err error)
	Start(ctx context.Context, resourceGroupName string, accountName string) (result documentdb.NotebookWorkspacesStartFuture, err error)
}

var _ NotebookWorkspacesClientAPI = (*documentdb.NotebookWorkspacesClient)(nil)

// PrivateEndpointConnectionsClientAPI contains the set of methods on the PrivateEndpointConnectionsClient type.
type PrivateEndpointConnectionsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, accountName string, privateEndpointConnectionName string, parameters documentdb.PrivateEndpointConnection) (result documentdb.PrivateEndpointConnectionsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, accountName string, privateEndpointConnectionName string) (result documentdb.PrivateEndpointConnectionsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, accountName string, privateEndpointConnectionName string) (result documentdb.PrivateEndpointConnection, err error)
	ListByDatabaseAccount(ctx context.Context, resourceGroupName string, accountName string) (result documentdb.PrivateEndpointConnectionListResult, err error)
}

var _ PrivateEndpointConnectionsClientAPI = (*documentdb.PrivateEndpointConnectionsClient)(nil)

// PrivateLinkResourcesClientAPI contains the set of methods on the PrivateLinkResourcesClient type.
type PrivateLinkResourcesClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, accountName string, groupName string) (result documentdb.PrivateLinkResource, err error)
	ListByDatabaseAccount(ctx context.Context, resourceGroupName string, accountName string) (result documentdb.PrivateLinkResourceListResult, err error)
}

var _ PrivateLinkResourcesClientAPI = (*documentdb.PrivateLinkResourcesClient)(nil)

// RestorableDatabaseAccountsClientAPI contains the set of methods on the RestorableDatabaseAccountsClient type.
type RestorableDatabaseAccountsClientAPI interface {
	GetByLocation(ctx context.Context, location string, instanceID string) (result documentdb.RestorableDatabaseAccountGetResult, err error)
	List(ctx context.Context) (result documentdb.RestorableDatabaseAccountsListResult, err error)
	ListByLocation(ctx context.Context, location string) (result documentdb.RestorableDatabaseAccountsListResult, err error)
}

var _ RestorableDatabaseAccountsClientAPI = (*documentdb.RestorableDatabaseAccountsClient)(nil)

// RestorableSQLDatabasesClientAPI contains the set of methods on the RestorableSQLDatabasesClient type.
type RestorableSQLDatabasesClientAPI interface {
	List(ctx context.Context, location string, instanceID string) (result documentdb.RestorableSQLDatabasesListResult, err error)
}

var _ RestorableSQLDatabasesClientAPI = (*documentdb.RestorableSQLDatabasesClient)(nil)

// RestorableSQLContainersClientAPI contains the set of methods on the RestorableSQLContainersClient type.
type RestorableSQLContainersClientAPI interface {
	List(ctx context.Context, location string, instanceID string, restorableSQLDatabaseRid string, startTime string, endTime string) (result documentdb.RestorableSQLContainersListResult, err error)
}

var _ RestorableSQLContainersClientAPI = (*documentdb.RestorableSQLContainersClient)(nil)

// RestorableSQLResourcesClientAPI contains the set of methods on the RestorableSQLResourcesClient type.
type RestorableSQLResourcesClientAPI interface {
	List(ctx context.Context, location string, instanceID string, restoreLocation string, restoreTimestampInUtc string) (result documentdb.RestorableSQLResourcesListResult, err error)
}

var _ RestorableSQLResourcesClientAPI = (*documentdb.RestorableSQLResourcesClient)(nil)

// RestorableMongodbDatabasesClientAPI contains the set of methods on the RestorableMongodbDatabasesClient type.
type RestorableMongodbDatabasesClientAPI interface {
	List(ctx context.Context, location string, instanceID string) (result documentdb.RestorableMongodbDatabasesListResult, err error)
}

var _ RestorableMongodbDatabasesClientAPI = (*documentdb.RestorableMongodbDatabasesClient)(nil)

// RestorableMongodbCollectionsClientAPI contains the set of methods on the RestorableMongodbCollectionsClient type.
type RestorableMongodbCollectionsClientAPI interface {
	List(ctx context.Context, location string, instanceID string, restorableMongodbDatabaseRid string, startTime string, endTime string) (result documentdb.RestorableMongodbCollectionsListResult, err error)
}

var _ RestorableMongodbCollectionsClientAPI = (*documentdb.RestorableMongodbCollectionsClient)(nil)

// RestorableMongodbResourcesClientAPI contains the set of methods on the RestorableMongodbResourcesClient type.
type RestorableMongodbResourcesClientAPI interface {
	List(ctx context.Context, location string, instanceID string, restoreLocation string, restoreTimestampInUtc string) (result documentdb.RestorableMongodbResourcesListResult, err error)
}

var _ RestorableMongodbResourcesClientAPI = (*documentdb.RestorableMongodbResourcesClient)(nil)

// RestorableGremlinDatabasesClientAPI contains the set of methods on the RestorableGremlinDatabasesClient type.
type RestorableGremlinDatabasesClientAPI interface {
	List(ctx context.Context, location string, instanceID string) (result documentdb.RestorableGremlinDatabasesListResult, err error)
}

var _ RestorableGremlinDatabasesClientAPI = (*documentdb.RestorableGremlinDatabasesClient)(nil)

// RestorableGremlinGraphsClientAPI contains the set of methods on the RestorableGremlinGraphsClient type.
type RestorableGremlinGraphsClientAPI interface {
	List(ctx context.Context, location string, instanceID string, restorableGremlinDatabaseRid string, startTime string, endTime string) (result documentdb.RestorableGremlinGraphsListResult, err error)
}

var _ RestorableGremlinGraphsClientAPI = (*documentdb.RestorableGremlinGraphsClient)(nil)

// RestorableGremlinResourcesClientAPI contains the set of methods on the RestorableGremlinResourcesClient type.
type RestorableGremlinResourcesClientAPI interface {
	List(ctx context.Context, location string, instanceID string, restoreLocation string, restoreTimestampInUtc string) (result documentdb.RestorableGremlinResourcesListResult, err error)
}

var _ RestorableGremlinResourcesClientAPI = (*documentdb.RestorableGremlinResourcesClient)(nil)

// RestorableTablesClientAPI contains the set of methods on the RestorableTablesClient type.
type RestorableTablesClientAPI interface {
	List(ctx context.Context, location string, instanceID string, startTime string, endTime string) (result documentdb.RestorableTablesListResult, err error)
}

var _ RestorableTablesClientAPI = (*documentdb.RestorableTablesClient)(nil)

// RestorableTableResourcesClientAPI contains the set of methods on the RestorableTableResourcesClient type.
type RestorableTableResourcesClientAPI interface {
	List(ctx context.Context, location string, instanceID string, restoreLocation string, restoreTimestampInUtc string) (result documentdb.RestorableTableResourcesListResult, err error)
}

var _ RestorableTableResourcesClientAPI = (*documentdb.RestorableTableResourcesClient)(nil)

// ServiceClientAPI contains the set of methods on the ServiceClient type.
type ServiceClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, accountName string, serviceName string, createUpdateParameters documentdb.ServiceResourceCreateUpdateParameters) (result documentdb.ServiceCreateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, accountName string, serviceName string) (result documentdb.ServiceDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, accountName string, serviceName string) (result documentdb.ServiceResource, err error)
	List(ctx context.Context, resourceGroupName string, accountName string) (result documentdb.ServiceResourceListResult, err error)
}

var _ ServiceClientAPI = (*documentdb.ServiceClient)(nil)
