package hardwaresecuritymodules

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// JSONWebKeyType enumerates the values for json web key type.
type JSONWebKeyType string

const (
	// Allocating A device is currently being allocated for the dedicated HSM resource.
	Allocating JSONWebKeyType = "Allocating"
	// CheckingQuota Validating the subscription has sufficient quota to allocate a dedicated HSM device.
	CheckingQuota JSONWebKeyType = "CheckingQuota"
	// Connecting The dedicated HSM is being connected to the virtual network.
	Connecting JSONWebKeyType = "Connecting"
	// Deleting The dedicated HSM is currently being deleted.
	Deleting JSONWebKeyType = "Deleting"
	// Failed Provisioning of the dedicated HSM has failed.
	Failed JSONWebKeyType = "Failed"
	// Provisioning The dedicated HSM is currently being provisioned.
	Provisioning JSONWebKeyType = "Provisioning"
	// Succeeded The dedicated HSM has been full provisioned.
	Succeeded JSONWebKeyType = "Succeeded"
)

// PossibleJSONWebKeyTypeValues returns an array of possible values for the JSONWebKeyType const type.
func PossibleJSONWebKeyTypeValues() []JSONWebKeyType {
	return []JSONWebKeyType{Allocating, CheckingQuota, Connecting, Deleting, Failed, Provisioning, Succeeded}
}

// Name enumerates the values for name.
type Name string

const (
	// SafeNetLunaNetworkHSMA790 ...
	SafeNetLunaNetworkHSMA790 Name = "SafeNet Luna Network HSM A790"
)

// PossibleNameValues returns an array of possible values for the Name const type.
func PossibleNameValues() []Name {
	return []Name{SafeNetLunaNetworkHSMA790}
}
