package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateVulWhitelist invokes the aegis.CreateVulWhitelist API synchronously
// api document: https://help.aliyun.com/api/aegis/createvulwhitelist.html
func (client *Client) CreateVulWhitelist(request *CreateVulWhitelistRequest) (response *CreateVulWhitelistResponse, err error) {
	response = CreateCreateVulWhitelistResponse()
	err = client.DoAction(request, response)
	return
}

// CreateVulWhitelistWithChan invokes the aegis.CreateVulWhitelist API asynchronously
// api document: https://help.aliyun.com/api/aegis/createvulwhitelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateVulWhitelistWithChan(request *CreateVulWhitelistRequest) (<-chan *CreateVulWhitelistResponse, <-chan error) {
	responseChan := make(chan *CreateVulWhitelistResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateVulWhitelist(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateVulWhitelistWithCallback invokes the aegis.CreateVulWhitelist API asynchronously
// api document: https://help.aliyun.com/api/aegis/createvulwhitelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateVulWhitelistWithCallback(request *CreateVulWhitelistRequest, callback func(response *CreateVulWhitelistResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateVulWhitelistResponse
		var err error
		defer close(result)
		response, err = client.CreateVulWhitelist(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateVulWhitelistRequest is the request struct for api CreateVulWhitelist
type CreateVulWhitelistRequest struct {
	*requests.RpcRequest
	Reason    string `position:"Query" name:"Reason"`
	SourceIp  string `position:"Query" name:"SourceIp"`
	Whitelist string `position:"Query" name:"Whitelist"`
}

// CreateVulWhitelistResponse is the response struct for api CreateVulWhitelist
type CreateVulWhitelistResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateVulWhitelistRequest creates a request to invoke CreateVulWhitelist API
func CreateCreateVulWhitelistRequest() (request *CreateVulWhitelistRequest) {
	request = &CreateVulWhitelistRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "CreateVulWhitelist", "vipaegis", "openAPI")
	return
}

// CreateCreateVulWhitelistResponse creates a response to parse from CreateVulWhitelist response
func CreateCreateVulWhitelistResponse() (response *CreateVulWhitelistResponse) {
	response = &CreateVulWhitelistResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
