package amqp_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListQueueUpStreamBindings invokes the amqp_open.ListQueueUpStreamBindings API synchronously
// api document: https://help.aliyun.com/api/amqp-open/listqueueupstreambindings.html
func (client *Client) ListQueueUpStreamBindings(request *ListQueueUpStreamBindingsRequest) (response *ListQueueUpStreamBindingsResponse, err error) {
	response = CreateListQueueUpStreamBindingsResponse()
	err = client.DoAction(request, response)
	return
}

// ListQueueUpStreamBindingsWithChan invokes the amqp_open.ListQueueUpStreamBindings API asynchronously
// api document: https://help.aliyun.com/api/amqp-open/listqueueupstreambindings.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListQueueUpStreamBindingsWithChan(request *ListQueueUpStreamBindingsRequest) (<-chan *ListQueueUpStreamBindingsResponse, <-chan error) {
	responseChan := make(chan *ListQueueUpStreamBindingsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListQueueUpStreamBindings(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListQueueUpStreamBindingsWithCallback invokes the amqp_open.ListQueueUpStreamBindings API asynchronously
// api document: https://help.aliyun.com/api/amqp-open/listqueueupstreambindings.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListQueueUpStreamBindingsWithCallback(request *ListQueueUpStreamBindingsRequest, callback func(response *ListQueueUpStreamBindingsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListQueueUpStreamBindingsResponse
		var err error
		defer close(result)
		response, err = client.ListQueueUpStreamBindings(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListQueueUpStreamBindingsRequest is the request struct for api ListQueueUpStreamBindings
type ListQueueUpStreamBindingsRequest struct {
	*requests.RpcRequest
	QueueName   string           `position:"Query" name:"QueueName"`
	InstanceId  string           `position:"Query" name:"InstanceId"`
	NextToken   string           `position:"Query" name:"NextToken"`
	MaxResults  requests.Integer `position:"Query" name:"MaxResults"`
	VirtualHost string           `position:"Query" name:"VirtualHost"`
}

// ListQueueUpStreamBindingsResponse is the response struct for api ListQueueUpStreamBindings
type ListQueueUpStreamBindingsResponse struct {
	*responses.BaseResponse
	RequestId string                          `json:"RequestId" xml:"RequestId"`
	Data      DataInListQueueUpStreamBindings `json:"Data" xml:"Data"`
}

// CreateListQueueUpStreamBindingsRequest creates a request to invoke ListQueueUpStreamBindings API
func CreateListQueueUpStreamBindingsRequest() (request *ListQueueUpStreamBindingsRequest) {
	request = &ListQueueUpStreamBindingsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("amqp-open", "2019-12-12", "ListQueueUpStreamBindings", "onsproxy", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListQueueUpStreamBindingsResponse creates a response to parse from ListQueueUpStreamBindings response
func CreateListQueueUpStreamBindingsResponse() (response *ListQueueUpStreamBindingsResponse) {
	response = &ListQueueUpStreamBindingsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
