package clickhouse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRDSVpc invokes the clickhouse.DescribeRDSVpc API synchronously
func (client *Client) DescribeRDSVpc(request *DescribeRDSVpcRequest) (response *DescribeRDSVpcResponse, err error) {
	response = CreateDescribeRDSVpcResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRDSVpcWithChan invokes the clickhouse.DescribeRDSVpc API asynchronously
func (client *Client) DescribeRDSVpcWithChan(request *DescribeRDSVpcRequest) (<-chan *DescribeRDSVpcResponse, <-chan error) {
	responseChan := make(chan *DescribeRDSVpcResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRDSVpc(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRDSVpcWithCallback invokes the clickhouse.DescribeRDSVpc API asynchronously
func (client *Client) DescribeRDSVpcWithCallback(request *DescribeRDSVpcRequest, callback func(response *DescribeRDSVpcResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRDSVpcResponse
		var err error
		defer close(result)
		response, err = client.DescribeRDSVpc(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRDSVpcRequest is the request struct for api DescribeRDSVpc
type DescribeRDSVpcRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DbClusterId          string           `position:"Query" name:"DbClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	RdsId                string           `position:"Query" name:"RdsId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeRDSVpcResponse is the response struct for api DescribeRDSVpc
type DescribeRDSVpcResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	VpcId     string `json:"VpcId" xml:"VpcId"`
}

// CreateDescribeRDSVpcRequest creates a request to invoke DescribeRDSVpc API
func CreateDescribeRDSVpcRequest() (request *DescribeRDSVpcRequest) {
	request = &DescribeRDSVpcRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("clickhouse", "2019-11-11", "DescribeRDSVpc", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeRDSVpcResponse creates a response to parse from DescribeRDSVpc response
func CreateDescribeRDSVpcResponse() (response *DescribeRDSVpcResponse) {
	response = &DescribeRDSVpcResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
