package dm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ApproveSmsTemplate invokes the dm.ApproveSmsTemplate API synchronously
// api document: https://help.aliyun.com/api/dm/approvesmstemplate.html
func (client *Client) ApproveSmsTemplate(request *ApproveSmsTemplateRequest) (response *ApproveSmsTemplateResponse, err error) {
	response = CreateApproveSmsTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// ApproveSmsTemplateWithChan invokes the dm.ApproveSmsTemplate API asynchronously
// api document: https://help.aliyun.com/api/dm/approvesmstemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ApproveSmsTemplateWithChan(request *ApproveSmsTemplateRequest) (<-chan *ApproveSmsTemplateResponse, <-chan error) {
	responseChan := make(chan *ApproveSmsTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ApproveSmsTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ApproveSmsTemplateWithCallback invokes the dm.ApproveSmsTemplate API asynchronously
// api document: https://help.aliyun.com/api/dm/approvesmstemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ApproveSmsTemplateWithCallback(request *ApproveSmsTemplateRequest, callback func(response *ApproveSmsTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ApproveSmsTemplateResponse
		var err error
		defer close(result)
		response, err = client.ApproveSmsTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ApproveSmsTemplateRequest is the request struct for api ApproveSmsTemplate
type ApproveSmsTemplateRequest struct {
	*requests.RpcRequest
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	TemplateId           requests.Integer `position:"Query" name:"TemplateId"`
	FromType             requests.Integer `position:"Query" name:"FromType"`
}

// ApproveSmsTemplateResponse is the response struct for api ApproveSmsTemplate
type ApproveSmsTemplateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateApproveSmsTemplateRequest creates a request to invoke ApproveSmsTemplate API
func CreateApproveSmsTemplateRequest() (request *ApproveSmsTemplateRequest) {
	request = &ApproveSmsTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dm", "2015-11-23", "ApproveSmsTemplate", "", "")
	return
}

// CreateApproveSmsTemplateResponse creates a response to parse from ApproveSmsTemplate response
func CreateApproveSmsTemplateResponse() (response *ApproveSmsTemplateResponse) {
	response = &ApproveSmsTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
