package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeXpackMonitorConfig invokes the elasticsearch.DescribeXpackMonitorConfig API synchronously
func (client *Client) DescribeXpackMonitorConfig(request *DescribeXpackMonitorConfigRequest) (response *DescribeXpackMonitorConfigResponse, err error) {
	response = CreateDescribeXpackMonitorConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeXpackMonitorConfigWithChan invokes the elasticsearch.DescribeXpackMonitorConfig API asynchronously
func (client *Client) DescribeXpackMonitorConfigWithChan(request *DescribeXpackMonitorConfigRequest) (<-chan *DescribeXpackMonitorConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeXpackMonitorConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeXpackMonitorConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeXpackMonitorConfigWithCallback invokes the elasticsearch.DescribeXpackMonitorConfig API asynchronously
func (client *Client) DescribeXpackMonitorConfigWithCallback(request *DescribeXpackMonitorConfigRequest, callback func(response *DescribeXpackMonitorConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeXpackMonitorConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeXpackMonitorConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeXpackMonitorConfigRequest is the request struct for api DescribeXpackMonitorConfig
type DescribeXpackMonitorConfigRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
}

// DescribeXpackMonitorConfigResponse is the response struct for api DescribeXpackMonitorConfig
type DescribeXpackMonitorConfigResponse struct {
	*responses.BaseResponse
	RequestId string                             `json:"RequestId" xml:"RequestId"`
	Result    ResultInDescribeXpackMonitorConfig `json:"Result" xml:"Result"`
}

// CreateDescribeXpackMonitorConfigRequest creates a request to invoke DescribeXpackMonitorConfig API
func CreateDescribeXpackMonitorConfigRequest() (request *DescribeXpackMonitorConfigRequest) {
	request = &DescribeXpackMonitorConfigRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "DescribeXpackMonitorConfig", "/openapi/logstashes/[InstanceId]/xpack-monitor-config", "elasticsearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeXpackMonitorConfigResponse creates a response to parse from DescribeXpackMonitorConfig response
func CreateDescribeXpackMonitorConfigResponse() (response *DescribeXpackMonitorConfigResponse) {
	response = &DescribeXpackMonitorConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
