package idrsservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateLiveDetection invokes the idrsservice.CreateLiveDetection API synchronously
func (client *Client) CreateLiveDetection(request *CreateLiveDetectionRequest) (response *CreateLiveDetectionResponse, err error) {
	response = CreateCreateLiveDetectionResponse()
	err = client.DoAction(request, response)
	return
}

// CreateLiveDetectionWithChan invokes the idrsservice.CreateLiveDetection API asynchronously
func (client *Client) CreateLiveDetectionWithChan(request *CreateLiveDetectionRequest) (<-chan *CreateLiveDetectionResponse, <-chan error) {
	responseChan := make(chan *CreateLiveDetectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateLiveDetection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateLiveDetectionWithCallback invokes the idrsservice.CreateLiveDetection API asynchronously
func (client *Client) CreateLiveDetectionWithCallback(request *CreateLiveDetectionRequest, callback func(response *CreateLiveDetectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateLiveDetectionResponse
		var err error
		defer close(result)
		response, err = client.CreateLiveDetection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateLiveDetectionRequest is the request struct for api CreateLiveDetection
type CreateLiveDetectionRequest struct {
	*requests.RpcRequest
	ClientToken string `position:"Query" name:"ClientToken"`
	LiveId      string `position:"Query" name:"LiveId"`
	UserId      string `position:"Query" name:"UserId"`
	MetaUrl     string `position:"Query" name:"MetaUrl"`
	RuleId      string `position:"Query" name:"RuleId"`
}

// CreateLiveDetectionResponse is the response struct for api CreateLiveDetection
type CreateLiveDetectionResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateLiveDetectionRequest creates a request to invoke CreateLiveDetection API
func CreateCreateLiveDetectionRequest() (request *CreateLiveDetectionRequest) {
	request = &CreateLiveDetectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("idrsservice", "2020-06-30", "CreateLiveDetection", "idrsservice", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateLiveDetectionResponse creates a response to parse from CreateLiveDetection response
func CreateCreateLiveDetectionResponse() (response *CreateLiveDetectionResponse) {
	response = &CreateLiveDetectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
