package imageseg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SegmentHDBody invokes the imageseg.SegmentHDBody API synchronously
func (client *Client) SegmentHDBody(request *SegmentHDBodyRequest) (response *SegmentHDBodyResponse, err error) {
	response = CreateSegmentHDBodyResponse()
	err = client.DoAction(request, response)
	return
}

// SegmentHDBodyWithChan invokes the imageseg.SegmentHDBody API asynchronously
func (client *Client) SegmentHDBodyWithChan(request *SegmentHDBodyRequest) (<-chan *SegmentHDBodyResponse, <-chan error) {
	responseChan := make(chan *SegmentHDBodyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SegmentHDBody(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SegmentHDBodyWithCallback invokes the imageseg.SegmentHDBody API asynchronously
func (client *Client) SegmentHDBodyWithCallback(request *SegmentHDBodyRequest, callback func(response *SegmentHDBodyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SegmentHDBodyResponse
		var err error
		defer close(result)
		response, err = client.SegmentHDBody(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SegmentHDBodyRequest is the request struct for api SegmentHDBody
type SegmentHDBodyRequest struct {
	*requests.RpcRequest
	ImageURL string `position:"Query" name:"ImageURL"`
}

// SegmentHDBodyResponse is the response struct for api SegmentHDBody
type SegmentHDBodyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSegmentHDBodyRequest creates a request to invoke SegmentHDBody API
func CreateSegmentHDBodyRequest() (request *SegmentHDBodyRequest) {
	request = &SegmentHDBodyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageseg", "2019-12-30", "SegmentHDBody", "imageseg", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSegmentHDBodyResponse creates a response to parse from SegmentHDBody response
func CreateSegmentHDBodyResponse() (response *SegmentHDBodyResponse) {
	response = &SegmentHDBodyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
