package jarvis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteAccessWhiteListGroup invokes the jarvis.DeleteAccessWhiteListGroup API synchronously
// api document: https://help.aliyun.com/api/jarvis/deleteaccesswhitelistgroup.html
func (client *Client) DeleteAccessWhiteListGroup(request *DeleteAccessWhiteListGroupRequest) (response *DeleteAccessWhiteListGroupResponse, err error) {
	response = CreateDeleteAccessWhiteListGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteAccessWhiteListGroupWithChan invokes the jarvis.DeleteAccessWhiteListGroup API asynchronously
// api document: https://help.aliyun.com/api/jarvis/deleteaccesswhitelistgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteAccessWhiteListGroupWithChan(request *DeleteAccessWhiteListGroupRequest) (<-chan *DeleteAccessWhiteListGroupResponse, <-chan error) {
	responseChan := make(chan *DeleteAccessWhiteListGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteAccessWhiteListGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteAccessWhiteListGroupWithCallback invokes the jarvis.DeleteAccessWhiteListGroup API asynchronously
// api document: https://help.aliyun.com/api/jarvis/deleteaccesswhitelistgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteAccessWhiteListGroupWithCallback(request *DeleteAccessWhiteListGroupRequest, callback func(response *DeleteAccessWhiteListGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteAccessWhiteListGroupResponse
		var err error
		defer close(result)
		response, err = client.DeleteAccessWhiteListGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteAccessWhiteListGroupRequest is the request struct for api DeleteAccessWhiteListGroup
type DeleteAccessWhiteListGroupRequest struct {
	*requests.RpcRequest
	GroupIdList string `position:"Query" name:"GroupIdList"`
	SourceIp    string `position:"Query" name:"SourceIp"`
	Lang        string `position:"Query" name:"Lang"`
	SourceCode  string `position:"Query" name:"SourceCode"`
}

// DeleteAccessWhiteListGroupResponse is the response struct for api DeleteAccessWhiteListGroup
type DeleteAccessWhiteListGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Module    string `json:"Module" xml:"Module"`
}

// CreateDeleteAccessWhiteListGroupRequest creates a request to invoke DeleteAccessWhiteListGroup API
func CreateDeleteAccessWhiteListGroupRequest() (request *DeleteAccessWhiteListGroupRequest) {
	request = &DeleteAccessWhiteListGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("jarvis", "2018-02-06", "DeleteAccessWhiteListGroup", "jarvis", "openAPI")
	return
}

// CreateDeleteAccessWhiteListGroupResponse creates a response to parse from DeleteAccessWhiteListGroup response
func CreateDeleteAccessWhiteListGroupResponse() (response *DeleteAccessWhiteListGroupResponse) {
	response = &DeleteAccessWhiteListGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
