package nas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateLifecyclePolicy invokes the nas.CreateLifecyclePolicy API synchronously
func (client *Client) CreateLifecyclePolicy(request *CreateLifecyclePolicyRequest) (response *CreateLifecyclePolicyResponse, err error) {
	response = CreateCreateLifecyclePolicyResponse()
	err = client.DoAction(request, response)
	return
}

// CreateLifecyclePolicyWithChan invokes the nas.CreateLifecyclePolicy API asynchronously
func (client *Client) CreateLifecyclePolicyWithChan(request *CreateLifecyclePolicyRequest) (<-chan *CreateLifecyclePolicyResponse, <-chan error) {
	responseChan := make(chan *CreateLifecyclePolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateLifecyclePolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateLifecyclePolicyWithCallback invokes the nas.CreateLifecyclePolicy API asynchronously
func (client *Client) CreateLifecyclePolicyWithCallback(request *CreateLifecyclePolicyRequest, callback func(response *CreateLifecyclePolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateLifecyclePolicyResponse
		var err error
		defer close(result)
		response, err = client.CreateLifecyclePolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateLifecyclePolicyRequest is the request struct for api CreateLifecyclePolicy
type CreateLifecyclePolicyRequest struct {
	*requests.RpcRequest
	StorageType         string    `position:"Query" name:"StorageType"`
	Path                string    `position:"Query" name:"Path"`
	LifecyclePolicyName string    `position:"Query" name:"LifecyclePolicyName"`
	FileSystemId        string    `position:"Query" name:"FileSystemId"`
	LifecycleRuleName   string    `position:"Query" name:"LifecycleRuleName"`
	Paths               *[]string `position:"Query" name:"Paths"  type:"Repeated"`
}

// CreateLifecyclePolicyResponse is the response struct for api CreateLifecyclePolicy
type CreateLifecyclePolicyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateCreateLifecyclePolicyRequest creates a request to invoke CreateLifecyclePolicy API
func CreateCreateLifecyclePolicyRequest() (request *CreateLifecyclePolicyRequest) {
	request = &CreateLifecyclePolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "CreateLifecyclePolicy", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateLifecyclePolicyResponse creates a response to parse from CreateLifecyclePolicy response
func CreateCreateLifecyclePolicyResponse() (response *CreateLifecyclePolicyResponse) {
	response = &CreateLifecyclePolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
