package oam

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListGroupTagByPage invokes the oam.ListGroupTagByPage API synchronously
// api document: https://help.aliyun.com/api/oam/listgrouptagbypage.html
func (client *Client) ListGroupTagByPage(request *ListGroupTagByPageRequest) (response *ListGroupTagByPageResponse, err error) {
	response = CreateListGroupTagByPageResponse()
	err = client.DoAction(request, response)
	return
}

// ListGroupTagByPageWithChan invokes the oam.ListGroupTagByPage API asynchronously
// api document: https://help.aliyun.com/api/oam/listgrouptagbypage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListGroupTagByPageWithChan(request *ListGroupTagByPageRequest) (<-chan *ListGroupTagByPageResponse, <-chan error) {
	responseChan := make(chan *ListGroupTagByPageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListGroupTagByPage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListGroupTagByPageWithCallback invokes the oam.ListGroupTagByPage API asynchronously
// api document: https://help.aliyun.com/api/oam/listgrouptagbypage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListGroupTagByPageWithCallback(request *ListGroupTagByPageRequest, callback func(response *ListGroupTagByPageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListGroupTagByPageResponse
		var err error
		defer close(result)
		response, err = client.ListGroupTagByPage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListGroupTagByPageRequest is the request struct for api ListGroupTagByPage
type ListGroupTagByPageRequest struct {
	*requests.RpcRequest
	Name      string           `position:"Query" name:"Name"`
	PageSize  requests.Integer `position:"Query" name:"PageSize"`
	PageIndex requests.Integer `position:"Query" name:"PageIndex"`
	UserId    string           `position:"Query" name:"UserId"`
}

// ListGroupTagByPageResponse is the response struct for api ListGroupTagByPage
type ListGroupTagByPageResponse struct {
	*responses.BaseResponse
	Code      string                   `json:"Code" xml:"Code"`
	Message   string                   `json:"Message" xml:"Message"`
	RequestId string                   `json:"RequestId" xml:"RequestId"`
	PageInfo  PageInfo                 `json:"PageInfo" xml:"PageInfo"`
	Data      DataInListGroupTagByPage `json:"Data" xml:"Data"`
}

// CreateListGroupTagByPageRequest creates a request to invoke ListGroupTagByPage API
func CreateListGroupTagByPageRequest() (request *ListGroupTagByPageRequest) {
	request = &ListGroupTagByPageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Oam", "2017-01-01", "ListGroupTagByPage", "", "")
	request.Method = requests.POST
	return
}

// CreateListGroupTagByPageResponse creates a response to parse from ListGroupTagByPage response
func CreateListGroupTagByPageResponse() (response *ListGroupTagByPageResponse) {
	response = &ListGroupTagByPageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
