package yundun_ds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAccountDetail invokes the yundun_ds.DescribeAccountDetail API synchronously
// api document: https://help.aliyun.com/api/yundun-ds/describeaccountdetail.html
func (client *Client) DescribeAccountDetail(request *DescribeAccountDetailRequest) (response *DescribeAccountDetailResponse, err error) {
	response = CreateDescribeAccountDetailResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAccountDetailWithChan invokes the yundun_ds.DescribeAccountDetail API asynchronously
// api document: https://help.aliyun.com/api/yundun-ds/describeaccountdetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAccountDetailWithChan(request *DescribeAccountDetailRequest) (<-chan *DescribeAccountDetailResponse, <-chan error) {
	responseChan := make(chan *DescribeAccountDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAccountDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAccountDetailWithCallback invokes the yundun_ds.DescribeAccountDetail API asynchronously
// api document: https://help.aliyun.com/api/yundun-ds/describeaccountdetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAccountDetailWithCallback(request *DescribeAccountDetailRequest, callback func(response *DescribeAccountDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAccountDetailResponse
		var err error
		defer close(result)
		response, err = client.DescribeAccountDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAccountDetailRequest is the request struct for api DescribeAccountDetail
type DescribeAccountDetailRequest struct {
	*requests.RpcRequest
	SourceIp      string           `position:"Query" name:"SourceIp"`
	Lang          string           `position:"Query" name:"Lang"`
	UserId        requests.Integer `position:"Query" name:"UserId"`
	AccountTypeId requests.Integer `position:"Query" name:"AccountTypeId"`
}

// DescribeAccountDetailResponse is the response struct for api DescribeAccountDetail
type DescribeAccountDetailResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Account   Account `json:"Account" xml:"Account"`
}

// CreateDescribeAccountDetailRequest creates a request to invoke DescribeAccountDetail API
func CreateDescribeAccountDetailRequest() (request *DescribeAccountDetailRequest) {
	request = &DescribeAccountDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Yundun-ds", "2019-01-03", "DescribeAccountDetail", "sddp", "openAPI")
	return
}

// CreateDescribeAccountDetailResponse creates a response to parse from DescribeAccountDetail response
func CreateDescribeAccountDetailResponse() (response *DescribeAccountDetailResponse) {
	response = &DescribeAccountDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
