// Code generated by smithy-go-codegen DO NOT EDIT.

package s3

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/s3/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyxml "github.com/aws/smithy-go/encoding/xml"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"net/http"
	"strconv"
	"strings"
)

type awsRestxml_serializeOpAbortMultipartUpload struct {
}

func (*awsRestxml_serializeOpAbortMultipartUpload) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpAbortMultipartUpload) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AbortMultipartUploadInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}/{Key+}?x-id=AbortMultipartUpload")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsAbortMultipartUploadInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsAbortMultipartUploadInput(v *AbortMultipartUploadInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.Key == nil || len(*v.Key) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Key must not be empty")}
	}
	if v.Key != nil {
		if err := encoder.SetURI("Key").String(*v.Key); err != nil {
			return err
		}
	}

	if len(v.RequestPayer) > 0 {
		locationName := "X-Amz-Request-Payer"
		encoder.SetHeader(locationName).String(string(v.RequestPayer))
	}

	if v.UploadId != nil {
		encoder.SetQuery("uploadId").String(*v.UploadId)
	}

	return nil
}

type awsRestxml_serializeOpCompleteMultipartUpload struct {
}

func (*awsRestxml_serializeOpCompleteMultipartUpload) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpCompleteMultipartUpload) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CompleteMultipartUploadInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}/{Key+}?x-id=CompleteMultipartUpload")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsCompleteMultipartUploadInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.MultipartUpload != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CompleteMultipartUpload",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://s3.amazonaws.com/doc/2006-03-01/"))
		if err := awsRestxml_serializeDocumentCompletedMultipartUpload(input.MultipartUpload, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsCompleteMultipartUploadInput(v *CompleteMultipartUploadInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ChecksumCRC32 != nil && len(*v.ChecksumCRC32) > 0 {
		locationName := "X-Amz-Checksum-Crc32"
		encoder.SetHeader(locationName).String(*v.ChecksumCRC32)
	}

	if v.ChecksumCRC32C != nil && len(*v.ChecksumCRC32C) > 0 {
		locationName := "X-Amz-Checksum-Crc32c"
		encoder.SetHeader(locationName).String(*v.ChecksumCRC32C)
	}

	if v.ChecksumSHA1 != nil && len(*v.ChecksumSHA1) > 0 {
		locationName := "X-Amz-Checksum-Sha1"
		encoder.SetHeader(locationName).String(*v.ChecksumSHA1)
	}

	if v.ChecksumSHA256 != nil && len(*v.ChecksumSHA256) > 0 {
		locationName := "X-Amz-Checksum-Sha256"
		encoder.SetHeader(locationName).String(*v.ChecksumSHA256)
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.Key == nil || len(*v.Key) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Key must not be empty")}
	}
	if v.Key != nil {
		if err := encoder.SetURI("Key").String(*v.Key); err != nil {
			return err
		}
	}

	if len(v.RequestPayer) > 0 {
		locationName := "X-Amz-Request-Payer"
		encoder.SetHeader(locationName).String(string(v.RequestPayer))
	}

	if v.SSECustomerAlgorithm != nil && len(*v.SSECustomerAlgorithm) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Algorithm"
		encoder.SetHeader(locationName).String(*v.SSECustomerAlgorithm)
	}

	if v.SSECustomerKey != nil && len(*v.SSECustomerKey) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Key"
		encoder.SetHeader(locationName).String(*v.SSECustomerKey)
	}

	if v.SSECustomerKeyMD5 != nil && len(*v.SSECustomerKeyMD5) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Key-Md5"
		encoder.SetHeader(locationName).String(*v.SSECustomerKeyMD5)
	}

	if v.UploadId != nil {
		encoder.SetQuery("uploadId").String(*v.UploadId)
	}

	return nil
}

type awsRestxml_serializeOpCopyObject struct {
}

func (*awsRestxml_serializeOpCopyObject) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpCopyObject) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CopyObjectInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}/{Key+}?x-id=CopyObject")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsCopyObjectInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsCopyObjectInput(v *CopyObjectInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.ACL) > 0 {
		locationName := "X-Amz-Acl"
		encoder.SetHeader(locationName).String(string(v.ACL))
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.BucketKeyEnabled {
		locationName := "X-Amz-Server-Side-Encryption-Bucket-Key-Enabled"
		encoder.SetHeader(locationName).Boolean(v.BucketKeyEnabled)
	}

	if v.CacheControl != nil && len(*v.CacheControl) > 0 {
		locationName := "Cache-Control"
		encoder.SetHeader(locationName).String(*v.CacheControl)
	}

	if len(v.ChecksumAlgorithm) > 0 {
		locationName := "X-Amz-Checksum-Algorithm"
		encoder.SetHeader(locationName).String(string(v.ChecksumAlgorithm))
	}

	if v.ContentDisposition != nil && len(*v.ContentDisposition) > 0 {
		locationName := "Content-Disposition"
		encoder.SetHeader(locationName).String(*v.ContentDisposition)
	}

	if v.ContentEncoding != nil && len(*v.ContentEncoding) > 0 {
		locationName := "Content-Encoding"
		encoder.SetHeader(locationName).String(*v.ContentEncoding)
	}

	if v.ContentLanguage != nil && len(*v.ContentLanguage) > 0 {
		locationName := "Content-Language"
		encoder.SetHeader(locationName).String(*v.ContentLanguage)
	}

	if v.ContentType != nil && len(*v.ContentType) > 0 {
		locationName := "Content-Type"
		encoder.SetHeader(locationName).String(*v.ContentType)
	}

	if v.CopySource != nil && len(*v.CopySource) > 0 {
		locationName := "X-Amz-Copy-Source"
		encoder.SetHeader(locationName).String(*v.CopySource)
	}

	if v.CopySourceIfMatch != nil && len(*v.CopySourceIfMatch) > 0 {
		locationName := "X-Amz-Copy-Source-If-Match"
		encoder.SetHeader(locationName).String(*v.CopySourceIfMatch)
	}

	if v.CopySourceIfModifiedSince != nil {
		locationName := "X-Amz-Copy-Source-If-Modified-Since"
		encoder.SetHeader(locationName).String(smithytime.FormatHTTPDate(*v.CopySourceIfModifiedSince))
	}

	if v.CopySourceIfNoneMatch != nil && len(*v.CopySourceIfNoneMatch) > 0 {
		locationName := "X-Amz-Copy-Source-If-None-Match"
		encoder.SetHeader(locationName).String(*v.CopySourceIfNoneMatch)
	}

	if v.CopySourceIfUnmodifiedSince != nil {
		locationName := "X-Amz-Copy-Source-If-Unmodified-Since"
		encoder.SetHeader(locationName).String(smithytime.FormatHTTPDate(*v.CopySourceIfUnmodifiedSince))
	}

	if v.CopySourceSSECustomerAlgorithm != nil && len(*v.CopySourceSSECustomerAlgorithm) > 0 {
		locationName := "X-Amz-Copy-Source-Server-Side-Encryption-Customer-Algorithm"
		encoder.SetHeader(locationName).String(*v.CopySourceSSECustomerAlgorithm)
	}

	if v.CopySourceSSECustomerKey != nil && len(*v.CopySourceSSECustomerKey) > 0 {
		locationName := "X-Amz-Copy-Source-Server-Side-Encryption-Customer-Key"
		encoder.SetHeader(locationName).String(*v.CopySourceSSECustomerKey)
	}

	if v.CopySourceSSECustomerKeyMD5 != nil && len(*v.CopySourceSSECustomerKeyMD5) > 0 {
		locationName := "X-Amz-Copy-Source-Server-Side-Encryption-Customer-Key-Md5"
		encoder.SetHeader(locationName).String(*v.CopySourceSSECustomerKeyMD5)
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.ExpectedSourceBucketOwner != nil && len(*v.ExpectedSourceBucketOwner) > 0 {
		locationName := "X-Amz-Source-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedSourceBucketOwner)
	}

	if v.Expires != nil {
		locationName := "Expires"
		encoder.SetHeader(locationName).String(smithytime.FormatHTTPDate(*v.Expires))
	}

	if v.GrantFullControl != nil && len(*v.GrantFullControl) > 0 {
		locationName := "X-Amz-Grant-Full-Control"
		encoder.SetHeader(locationName).String(*v.GrantFullControl)
	}

	if v.GrantRead != nil && len(*v.GrantRead) > 0 {
		locationName := "X-Amz-Grant-Read"
		encoder.SetHeader(locationName).String(*v.GrantRead)
	}

	if v.GrantReadACP != nil && len(*v.GrantReadACP) > 0 {
		locationName := "X-Amz-Grant-Read-Acp"
		encoder.SetHeader(locationName).String(*v.GrantReadACP)
	}

	if v.GrantWriteACP != nil && len(*v.GrantWriteACP) > 0 {
		locationName := "X-Amz-Grant-Write-Acp"
		encoder.SetHeader(locationName).String(*v.GrantWriteACP)
	}

	if v.Key == nil || len(*v.Key) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Key must not be empty")}
	}
	if v.Key != nil {
		if err := encoder.SetURI("Key").String(*v.Key); err != nil {
			return err
		}
	}

	if v.Metadata != nil {
		hv := encoder.Headers("X-Amz-Meta-")
		for mapKey, mapVal := range v.Metadata {
			if len(mapVal) > 0 {
				hv.SetHeader(http.CanonicalHeaderKey(mapKey)).String(mapVal)
			}
		}
	}

	if len(v.MetadataDirective) > 0 {
		locationName := "X-Amz-Metadata-Directive"
		encoder.SetHeader(locationName).String(string(v.MetadataDirective))
	}

	if len(v.ObjectLockLegalHoldStatus) > 0 {
		locationName := "X-Amz-Object-Lock-Legal-Hold"
		encoder.SetHeader(locationName).String(string(v.ObjectLockLegalHoldStatus))
	}

	if len(v.ObjectLockMode) > 0 {
		locationName := "X-Amz-Object-Lock-Mode"
		encoder.SetHeader(locationName).String(string(v.ObjectLockMode))
	}

	if v.ObjectLockRetainUntilDate != nil {
		locationName := "X-Amz-Object-Lock-Retain-Until-Date"
		encoder.SetHeader(locationName).String(smithytime.FormatDateTime(*v.ObjectLockRetainUntilDate))
	}

	if len(v.RequestPayer) > 0 {
		locationName := "X-Amz-Request-Payer"
		encoder.SetHeader(locationName).String(string(v.RequestPayer))
	}

	if len(v.ServerSideEncryption) > 0 {
		locationName := "X-Amz-Server-Side-Encryption"
		encoder.SetHeader(locationName).String(string(v.ServerSideEncryption))
	}

	if v.SSECustomerAlgorithm != nil && len(*v.SSECustomerAlgorithm) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Algorithm"
		encoder.SetHeader(locationName).String(*v.SSECustomerAlgorithm)
	}

	if v.SSECustomerKey != nil && len(*v.SSECustomerKey) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Key"
		encoder.SetHeader(locationName).String(*v.SSECustomerKey)
	}

	if v.SSECustomerKeyMD5 != nil && len(*v.SSECustomerKeyMD5) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Key-Md5"
		encoder.SetHeader(locationName).String(*v.SSECustomerKeyMD5)
	}

	if v.SSEKMSEncryptionContext != nil && len(*v.SSEKMSEncryptionContext) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Context"
		encoder.SetHeader(locationName).String(*v.SSEKMSEncryptionContext)
	}

	if v.SSEKMSKeyId != nil && len(*v.SSEKMSKeyId) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Aws-Kms-Key-Id"
		encoder.SetHeader(locationName).String(*v.SSEKMSKeyId)
	}

	if len(v.StorageClass) > 0 {
		locationName := "X-Amz-Storage-Class"
		encoder.SetHeader(locationName).String(string(v.StorageClass))
	}

	if v.Tagging != nil && len(*v.Tagging) > 0 {
		locationName := "X-Amz-Tagging"
		encoder.SetHeader(locationName).String(*v.Tagging)
	}

	if len(v.TaggingDirective) > 0 {
		locationName := "X-Amz-Tagging-Directive"
		encoder.SetHeader(locationName).String(string(v.TaggingDirective))
	}

	if v.WebsiteRedirectLocation != nil && len(*v.WebsiteRedirectLocation) > 0 {
		locationName := "X-Amz-Website-Redirect-Location"
		encoder.SetHeader(locationName).String(*v.WebsiteRedirectLocation)
	}

	return nil
}

type awsRestxml_serializeOpCreateBucket struct {
}

func (*awsRestxml_serializeOpCreateBucket) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpCreateBucket) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateBucketInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsCreateBucketInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.CreateBucketConfiguration != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CreateBucketConfiguration",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://s3.amazonaws.com/doc/2006-03-01/"))
		if err := awsRestxml_serializeDocumentCreateBucketConfiguration(input.CreateBucketConfiguration, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsCreateBucketInput(v *CreateBucketInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.ACL) > 0 {
		locationName := "X-Amz-Acl"
		encoder.SetHeader(locationName).String(string(v.ACL))
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.GrantFullControl != nil && len(*v.GrantFullControl) > 0 {
		locationName := "X-Amz-Grant-Full-Control"
		encoder.SetHeader(locationName).String(*v.GrantFullControl)
	}

	if v.GrantRead != nil && len(*v.GrantRead) > 0 {
		locationName := "X-Amz-Grant-Read"
		encoder.SetHeader(locationName).String(*v.GrantRead)
	}

	if v.GrantReadACP != nil && len(*v.GrantReadACP) > 0 {
		locationName := "X-Amz-Grant-Read-Acp"
		encoder.SetHeader(locationName).String(*v.GrantReadACP)
	}

	if v.GrantWrite != nil && len(*v.GrantWrite) > 0 {
		locationName := "X-Amz-Grant-Write"
		encoder.SetHeader(locationName).String(*v.GrantWrite)
	}

	if v.GrantWriteACP != nil && len(*v.GrantWriteACP) > 0 {
		locationName := "X-Amz-Grant-Write-Acp"
		encoder.SetHeader(locationName).String(*v.GrantWriteACP)
	}

	if v.ObjectLockEnabledForBucket {
		locationName := "X-Amz-Bucket-Object-Lock-Enabled"
		encoder.SetHeader(locationName).Boolean(v.ObjectLockEnabledForBucket)
	}

	if len(v.ObjectOwnership) > 0 {
		locationName := "X-Amz-Object-Ownership"
		encoder.SetHeader(locationName).String(string(v.ObjectOwnership))
	}

	return nil
}

type awsRestxml_serializeOpCreateMultipartUpload struct {
}

func (*awsRestxml_serializeOpCreateMultipartUpload) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpCreateMultipartUpload) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateMultipartUploadInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}/{Key+}?uploads&x-id=CreateMultipartUpload")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsCreateMultipartUploadInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsCreateMultipartUploadInput(v *CreateMultipartUploadInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.ACL) > 0 {
		locationName := "X-Amz-Acl"
		encoder.SetHeader(locationName).String(string(v.ACL))
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.BucketKeyEnabled {
		locationName := "X-Amz-Server-Side-Encryption-Bucket-Key-Enabled"
		encoder.SetHeader(locationName).Boolean(v.BucketKeyEnabled)
	}

	if v.CacheControl != nil && len(*v.CacheControl) > 0 {
		locationName := "Cache-Control"
		encoder.SetHeader(locationName).String(*v.CacheControl)
	}

	if len(v.ChecksumAlgorithm) > 0 {
		locationName := "X-Amz-Checksum-Algorithm"
		encoder.SetHeader(locationName).String(string(v.ChecksumAlgorithm))
	}

	if v.ContentDisposition != nil && len(*v.ContentDisposition) > 0 {
		locationName := "Content-Disposition"
		encoder.SetHeader(locationName).String(*v.ContentDisposition)
	}

	if v.ContentEncoding != nil && len(*v.ContentEncoding) > 0 {
		locationName := "Content-Encoding"
		encoder.SetHeader(locationName).String(*v.ContentEncoding)
	}

	if v.ContentLanguage != nil && len(*v.ContentLanguage) > 0 {
		locationName := "Content-Language"
		encoder.SetHeader(locationName).String(*v.ContentLanguage)
	}

	if v.ContentType != nil && len(*v.ContentType) > 0 {
		locationName := "Content-Type"
		encoder.SetHeader(locationName).String(*v.ContentType)
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.Expires != nil {
		locationName := "Expires"
		encoder.SetHeader(locationName).String(smithytime.FormatHTTPDate(*v.Expires))
	}

	if v.GrantFullControl != nil && len(*v.GrantFullControl) > 0 {
		locationName := "X-Amz-Grant-Full-Control"
		encoder.SetHeader(locationName).String(*v.GrantFullControl)
	}

	if v.GrantRead != nil && len(*v.GrantRead) > 0 {
		locationName := "X-Amz-Grant-Read"
		encoder.SetHeader(locationName).String(*v.GrantRead)
	}

	if v.GrantReadACP != nil && len(*v.GrantReadACP) > 0 {
		locationName := "X-Amz-Grant-Read-Acp"
		encoder.SetHeader(locationName).String(*v.GrantReadACP)
	}

	if v.GrantWriteACP != nil && len(*v.GrantWriteACP) > 0 {
		locationName := "X-Amz-Grant-Write-Acp"
		encoder.SetHeader(locationName).String(*v.GrantWriteACP)
	}

	if v.Key == nil || len(*v.Key) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Key must not be empty")}
	}
	if v.Key != nil {
		if err := encoder.SetURI("Key").String(*v.Key); err != nil {
			return err
		}
	}

	if v.Metadata != nil {
		hv := encoder.Headers("X-Amz-Meta-")
		for mapKey, mapVal := range v.Metadata {
			if len(mapVal) > 0 {
				hv.SetHeader(http.CanonicalHeaderKey(mapKey)).String(mapVal)
			}
		}
	}

	if len(v.ObjectLockLegalHoldStatus) > 0 {
		locationName := "X-Amz-Object-Lock-Legal-Hold"
		encoder.SetHeader(locationName).String(string(v.ObjectLockLegalHoldStatus))
	}

	if len(v.ObjectLockMode) > 0 {
		locationName := "X-Amz-Object-Lock-Mode"
		encoder.SetHeader(locationName).String(string(v.ObjectLockMode))
	}

	if v.ObjectLockRetainUntilDate != nil {
		locationName := "X-Amz-Object-Lock-Retain-Until-Date"
		encoder.SetHeader(locationName).String(smithytime.FormatDateTime(*v.ObjectLockRetainUntilDate))
	}

	if len(v.RequestPayer) > 0 {
		locationName := "X-Amz-Request-Payer"
		encoder.SetHeader(locationName).String(string(v.RequestPayer))
	}

	if len(v.ServerSideEncryption) > 0 {
		locationName := "X-Amz-Server-Side-Encryption"
		encoder.SetHeader(locationName).String(string(v.ServerSideEncryption))
	}

	if v.SSECustomerAlgorithm != nil && len(*v.SSECustomerAlgorithm) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Algorithm"
		encoder.SetHeader(locationName).String(*v.SSECustomerAlgorithm)
	}

	if v.SSECustomerKey != nil && len(*v.SSECustomerKey) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Key"
		encoder.SetHeader(locationName).String(*v.SSECustomerKey)
	}

	if v.SSECustomerKeyMD5 != nil && len(*v.SSECustomerKeyMD5) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Key-Md5"
		encoder.SetHeader(locationName).String(*v.SSECustomerKeyMD5)
	}

	if v.SSEKMSEncryptionContext != nil && len(*v.SSEKMSEncryptionContext) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Context"
		encoder.SetHeader(locationName).String(*v.SSEKMSEncryptionContext)
	}

	if v.SSEKMSKeyId != nil && len(*v.SSEKMSKeyId) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Aws-Kms-Key-Id"
		encoder.SetHeader(locationName).String(*v.SSEKMSKeyId)
	}

	if len(v.StorageClass) > 0 {
		locationName := "X-Amz-Storage-Class"
		encoder.SetHeader(locationName).String(string(v.StorageClass))
	}

	if v.Tagging != nil && len(*v.Tagging) > 0 {
		locationName := "X-Amz-Tagging"
		encoder.SetHeader(locationName).String(*v.Tagging)
	}

	if v.WebsiteRedirectLocation != nil && len(*v.WebsiteRedirectLocation) > 0 {
		locationName := "X-Amz-Website-Redirect-Location"
		encoder.SetHeader(locationName).String(*v.WebsiteRedirectLocation)
	}

	return nil
}

type awsRestxml_serializeOpDeleteBucket struct {
}

func (*awsRestxml_serializeOpDeleteBucket) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteBucket) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBucketInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteBucketInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteBucketInput(v *DeleteBucketInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpDeleteBucketAnalyticsConfiguration struct {
}

func (*awsRestxml_serializeOpDeleteBucketAnalyticsConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteBucketAnalyticsConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBucketAnalyticsConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?analytics")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteBucketAnalyticsConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteBucketAnalyticsConfigurationInput(v *DeleteBucketAnalyticsConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.Id != nil {
		encoder.SetQuery("id").String(*v.Id)
	}

	return nil
}

type awsRestxml_serializeOpDeleteBucketCors struct {
}

func (*awsRestxml_serializeOpDeleteBucketCors) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteBucketCors) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBucketCorsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?cors")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteBucketCorsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteBucketCorsInput(v *DeleteBucketCorsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpDeleteBucketEncryption struct {
}

func (*awsRestxml_serializeOpDeleteBucketEncryption) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteBucketEncryption) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBucketEncryptionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?encryption")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteBucketEncryptionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteBucketEncryptionInput(v *DeleteBucketEncryptionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpDeleteBucketIntelligentTieringConfiguration struct {
}

func (*awsRestxml_serializeOpDeleteBucketIntelligentTieringConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteBucketIntelligentTieringConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBucketIntelligentTieringConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?intelligent-tiering")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteBucketIntelligentTieringConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteBucketIntelligentTieringConfigurationInput(v *DeleteBucketIntelligentTieringConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.Id != nil {
		encoder.SetQuery("id").String(*v.Id)
	}

	return nil
}

type awsRestxml_serializeOpDeleteBucketInventoryConfiguration struct {
}

func (*awsRestxml_serializeOpDeleteBucketInventoryConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteBucketInventoryConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBucketInventoryConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?inventory")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteBucketInventoryConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteBucketInventoryConfigurationInput(v *DeleteBucketInventoryConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.Id != nil {
		encoder.SetQuery("id").String(*v.Id)
	}

	return nil
}

type awsRestxml_serializeOpDeleteBucketLifecycle struct {
}

func (*awsRestxml_serializeOpDeleteBucketLifecycle) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteBucketLifecycle) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBucketLifecycleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?lifecycle")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteBucketLifecycleInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteBucketLifecycleInput(v *DeleteBucketLifecycleInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpDeleteBucketMetricsConfiguration struct {
}

func (*awsRestxml_serializeOpDeleteBucketMetricsConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteBucketMetricsConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBucketMetricsConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?metrics")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteBucketMetricsConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteBucketMetricsConfigurationInput(v *DeleteBucketMetricsConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.Id != nil {
		encoder.SetQuery("id").String(*v.Id)
	}

	return nil
}

type awsRestxml_serializeOpDeleteBucketOwnershipControls struct {
}

func (*awsRestxml_serializeOpDeleteBucketOwnershipControls) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteBucketOwnershipControls) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBucketOwnershipControlsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?ownershipControls")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteBucketOwnershipControlsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteBucketOwnershipControlsInput(v *DeleteBucketOwnershipControlsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpDeleteBucketPolicy struct {
}

func (*awsRestxml_serializeOpDeleteBucketPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteBucketPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBucketPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteBucketPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteBucketPolicyInput(v *DeleteBucketPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpDeleteBucketReplication struct {
}

func (*awsRestxml_serializeOpDeleteBucketReplication) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteBucketReplication) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBucketReplicationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?replication")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteBucketReplicationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteBucketReplicationInput(v *DeleteBucketReplicationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpDeleteBucketTagging struct {
}

func (*awsRestxml_serializeOpDeleteBucketTagging) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteBucketTagging) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBucketTaggingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?tagging")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteBucketTaggingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteBucketTaggingInput(v *DeleteBucketTaggingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpDeleteBucketWebsite struct {
}

func (*awsRestxml_serializeOpDeleteBucketWebsite) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteBucketWebsite) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBucketWebsiteInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?website")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteBucketWebsiteInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteBucketWebsiteInput(v *DeleteBucketWebsiteInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpDeleteObject struct {
}

func (*awsRestxml_serializeOpDeleteObject) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteObject) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteObjectInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}/{Key+}?x-id=DeleteObject")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteObjectInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteObjectInput(v *DeleteObjectInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.BypassGovernanceRetention {
		locationName := "X-Amz-Bypass-Governance-Retention"
		encoder.SetHeader(locationName).Boolean(v.BypassGovernanceRetention)
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.Key == nil || len(*v.Key) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Key must not be empty")}
	}
	if v.Key != nil {
		if err := encoder.SetURI("Key").String(*v.Key); err != nil {
			return err
		}
	}

	if v.MFA != nil && len(*v.MFA) > 0 {
		locationName := "X-Amz-Mfa"
		encoder.SetHeader(locationName).String(*v.MFA)
	}

	if len(v.RequestPayer) > 0 {
		locationName := "X-Amz-Request-Payer"
		encoder.SetHeader(locationName).String(string(v.RequestPayer))
	}

	if v.VersionId != nil {
		encoder.SetQuery("versionId").String(*v.VersionId)
	}

	return nil
}

type awsRestxml_serializeOpDeleteObjects struct {
}

func (*awsRestxml_serializeOpDeleteObjects) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteObjects) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteObjectsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?delete&x-id=DeleteObjects")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteObjectsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.Delete != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Delete",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://s3.amazonaws.com/doc/2006-03-01/"))
		if err := awsRestxml_serializeDocumentDelete(input.Delete, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteObjectsInput(v *DeleteObjectsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.BypassGovernanceRetention {
		locationName := "X-Amz-Bypass-Governance-Retention"
		encoder.SetHeader(locationName).Boolean(v.BypassGovernanceRetention)
	}

	if len(v.ChecksumAlgorithm) > 0 {
		locationName := "X-Amz-Sdk-Checksum-Algorithm"
		encoder.SetHeader(locationName).String(string(v.ChecksumAlgorithm))
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.MFA != nil && len(*v.MFA) > 0 {
		locationName := "X-Amz-Mfa"
		encoder.SetHeader(locationName).String(*v.MFA)
	}

	if len(v.RequestPayer) > 0 {
		locationName := "X-Amz-Request-Payer"
		encoder.SetHeader(locationName).String(string(v.RequestPayer))
	}

	return nil
}

type awsRestxml_serializeOpDeleteObjectTagging struct {
}

func (*awsRestxml_serializeOpDeleteObjectTagging) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteObjectTagging) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteObjectTaggingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}/{Key+}?tagging")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteObjectTaggingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteObjectTaggingInput(v *DeleteObjectTaggingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.Key == nil || len(*v.Key) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Key must not be empty")}
	}
	if v.Key != nil {
		if err := encoder.SetURI("Key").String(*v.Key); err != nil {
			return err
		}
	}

	if v.VersionId != nil {
		encoder.SetQuery("versionId").String(*v.VersionId)
	}

	return nil
}

type awsRestxml_serializeOpDeletePublicAccessBlock struct {
}

func (*awsRestxml_serializeOpDeletePublicAccessBlock) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeletePublicAccessBlock) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeletePublicAccessBlockInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?publicAccessBlock")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeletePublicAccessBlockInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeletePublicAccessBlockInput(v *DeletePublicAccessBlockInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpGetBucketAccelerateConfiguration struct {
}

func (*awsRestxml_serializeOpGetBucketAccelerateConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetBucketAccelerateConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBucketAccelerateConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?accelerate")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetBucketAccelerateConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetBucketAccelerateConfigurationInput(v *GetBucketAccelerateConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpGetBucketAcl struct {
}

func (*awsRestxml_serializeOpGetBucketAcl) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetBucketAcl) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBucketAclInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?acl")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetBucketAclInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetBucketAclInput(v *GetBucketAclInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpGetBucketAnalyticsConfiguration struct {
}

func (*awsRestxml_serializeOpGetBucketAnalyticsConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetBucketAnalyticsConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBucketAnalyticsConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?analytics&x-id=GetBucketAnalyticsConfiguration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetBucketAnalyticsConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetBucketAnalyticsConfigurationInput(v *GetBucketAnalyticsConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.Id != nil {
		encoder.SetQuery("id").String(*v.Id)
	}

	return nil
}

type awsRestxml_serializeOpGetBucketCors struct {
}

func (*awsRestxml_serializeOpGetBucketCors) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetBucketCors) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBucketCorsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?cors")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetBucketCorsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetBucketCorsInput(v *GetBucketCorsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpGetBucketEncryption struct {
}

func (*awsRestxml_serializeOpGetBucketEncryption) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetBucketEncryption) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBucketEncryptionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?encryption")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetBucketEncryptionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetBucketEncryptionInput(v *GetBucketEncryptionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpGetBucketIntelligentTieringConfiguration struct {
}

func (*awsRestxml_serializeOpGetBucketIntelligentTieringConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetBucketIntelligentTieringConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBucketIntelligentTieringConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?intelligent-tiering&x-id=GetBucketIntelligentTieringConfiguration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetBucketIntelligentTieringConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetBucketIntelligentTieringConfigurationInput(v *GetBucketIntelligentTieringConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.Id != nil {
		encoder.SetQuery("id").String(*v.Id)
	}

	return nil
}

type awsRestxml_serializeOpGetBucketInventoryConfiguration struct {
}

func (*awsRestxml_serializeOpGetBucketInventoryConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetBucketInventoryConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBucketInventoryConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?inventory&x-id=GetBucketInventoryConfiguration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetBucketInventoryConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetBucketInventoryConfigurationInput(v *GetBucketInventoryConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.Id != nil {
		encoder.SetQuery("id").String(*v.Id)
	}

	return nil
}

type awsRestxml_serializeOpGetBucketLifecycleConfiguration struct {
}

func (*awsRestxml_serializeOpGetBucketLifecycleConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetBucketLifecycleConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBucketLifecycleConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?lifecycle")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetBucketLifecycleConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetBucketLifecycleConfigurationInput(v *GetBucketLifecycleConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpGetBucketLocation struct {
}

func (*awsRestxml_serializeOpGetBucketLocation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetBucketLocation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBucketLocationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?location")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetBucketLocationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetBucketLocationInput(v *GetBucketLocationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpGetBucketLogging struct {
}

func (*awsRestxml_serializeOpGetBucketLogging) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetBucketLogging) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBucketLoggingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?logging")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetBucketLoggingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetBucketLoggingInput(v *GetBucketLoggingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpGetBucketMetricsConfiguration struct {
}

func (*awsRestxml_serializeOpGetBucketMetricsConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetBucketMetricsConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBucketMetricsConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?metrics&x-id=GetBucketMetricsConfiguration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetBucketMetricsConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetBucketMetricsConfigurationInput(v *GetBucketMetricsConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.Id != nil {
		encoder.SetQuery("id").String(*v.Id)
	}

	return nil
}

type awsRestxml_serializeOpGetBucketNotificationConfiguration struct {
}

func (*awsRestxml_serializeOpGetBucketNotificationConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetBucketNotificationConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBucketNotificationConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?notification")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetBucketNotificationConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetBucketNotificationConfigurationInput(v *GetBucketNotificationConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpGetBucketOwnershipControls struct {
}

func (*awsRestxml_serializeOpGetBucketOwnershipControls) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetBucketOwnershipControls) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBucketOwnershipControlsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?ownershipControls")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetBucketOwnershipControlsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetBucketOwnershipControlsInput(v *GetBucketOwnershipControlsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpGetBucketPolicy struct {
}

func (*awsRestxml_serializeOpGetBucketPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetBucketPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBucketPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetBucketPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetBucketPolicyInput(v *GetBucketPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpGetBucketPolicyStatus struct {
}

func (*awsRestxml_serializeOpGetBucketPolicyStatus) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetBucketPolicyStatus) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBucketPolicyStatusInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?policyStatus")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetBucketPolicyStatusInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetBucketPolicyStatusInput(v *GetBucketPolicyStatusInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpGetBucketReplication struct {
}

func (*awsRestxml_serializeOpGetBucketReplication) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetBucketReplication) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBucketReplicationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?replication")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetBucketReplicationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetBucketReplicationInput(v *GetBucketReplicationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpGetBucketRequestPayment struct {
}

func (*awsRestxml_serializeOpGetBucketRequestPayment) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetBucketRequestPayment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBucketRequestPaymentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?requestPayment")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetBucketRequestPaymentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetBucketRequestPaymentInput(v *GetBucketRequestPaymentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpGetBucketTagging struct {
}

func (*awsRestxml_serializeOpGetBucketTagging) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetBucketTagging) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBucketTaggingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?tagging")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetBucketTaggingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetBucketTaggingInput(v *GetBucketTaggingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpGetBucketVersioning struct {
}

func (*awsRestxml_serializeOpGetBucketVersioning) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetBucketVersioning) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBucketVersioningInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?versioning")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetBucketVersioningInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetBucketVersioningInput(v *GetBucketVersioningInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpGetBucketWebsite struct {
}

func (*awsRestxml_serializeOpGetBucketWebsite) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetBucketWebsite) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBucketWebsiteInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?website")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetBucketWebsiteInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetBucketWebsiteInput(v *GetBucketWebsiteInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpGetObject struct {
}

func (*awsRestxml_serializeOpGetObject) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetObject) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetObjectInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}/{Key+}?x-id=GetObject")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetObjectInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetObjectInput(v *GetObjectInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if len(v.ChecksumMode) > 0 {
		locationName := "X-Amz-Checksum-Mode"
		encoder.SetHeader(locationName).String(string(v.ChecksumMode))
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.IfMatch != nil && len(*v.IfMatch) > 0 {
		locationName := "If-Match"
		encoder.SetHeader(locationName).String(*v.IfMatch)
	}

	if v.IfModifiedSince != nil {
		locationName := "If-Modified-Since"
		encoder.SetHeader(locationName).String(smithytime.FormatHTTPDate(*v.IfModifiedSince))
	}

	if v.IfNoneMatch != nil && len(*v.IfNoneMatch) > 0 {
		locationName := "If-None-Match"
		encoder.SetHeader(locationName).String(*v.IfNoneMatch)
	}

	if v.IfUnmodifiedSince != nil {
		locationName := "If-Unmodified-Since"
		encoder.SetHeader(locationName).String(smithytime.FormatHTTPDate(*v.IfUnmodifiedSince))
	}

	if v.Key == nil || len(*v.Key) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Key must not be empty")}
	}
	if v.Key != nil {
		if err := encoder.SetURI("Key").String(*v.Key); err != nil {
			return err
		}
	}

	if v.PartNumber != 0 {
		encoder.SetQuery("partNumber").Integer(v.PartNumber)
	}

	if v.Range != nil && len(*v.Range) > 0 {
		locationName := "Range"
		encoder.SetHeader(locationName).String(*v.Range)
	}

	if len(v.RequestPayer) > 0 {
		locationName := "X-Amz-Request-Payer"
		encoder.SetHeader(locationName).String(string(v.RequestPayer))
	}

	if v.ResponseCacheControl != nil {
		encoder.SetQuery("response-cache-control").String(*v.ResponseCacheControl)
	}

	if v.ResponseContentDisposition != nil {
		encoder.SetQuery("response-content-disposition").String(*v.ResponseContentDisposition)
	}

	if v.ResponseContentEncoding != nil {
		encoder.SetQuery("response-content-encoding").String(*v.ResponseContentEncoding)
	}

	if v.ResponseContentLanguage != nil {
		encoder.SetQuery("response-content-language").String(*v.ResponseContentLanguage)
	}

	if v.ResponseContentType != nil {
		encoder.SetQuery("response-content-type").String(*v.ResponseContentType)
	}

	if v.ResponseExpires != nil {
		encoder.SetQuery("response-expires").String(smithytime.FormatHTTPDate(*v.ResponseExpires))
	}

	if v.SSECustomerAlgorithm != nil && len(*v.SSECustomerAlgorithm) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Algorithm"
		encoder.SetHeader(locationName).String(*v.SSECustomerAlgorithm)
	}

	if v.SSECustomerKey != nil && len(*v.SSECustomerKey) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Key"
		encoder.SetHeader(locationName).String(*v.SSECustomerKey)
	}

	if v.SSECustomerKeyMD5 != nil && len(*v.SSECustomerKeyMD5) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Key-Md5"
		encoder.SetHeader(locationName).String(*v.SSECustomerKeyMD5)
	}

	if v.VersionId != nil {
		encoder.SetQuery("versionId").String(*v.VersionId)
	}

	return nil
}

type awsRestxml_serializeOpGetObjectAcl struct {
}

func (*awsRestxml_serializeOpGetObjectAcl) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetObjectAcl) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetObjectAclInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}/{Key+}?acl")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetObjectAclInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetObjectAclInput(v *GetObjectAclInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.Key == nil || len(*v.Key) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Key must not be empty")}
	}
	if v.Key != nil {
		if err := encoder.SetURI("Key").String(*v.Key); err != nil {
			return err
		}
	}

	if len(v.RequestPayer) > 0 {
		locationName := "X-Amz-Request-Payer"
		encoder.SetHeader(locationName).String(string(v.RequestPayer))
	}

	if v.VersionId != nil {
		encoder.SetQuery("versionId").String(*v.VersionId)
	}

	return nil
}

type awsRestxml_serializeOpGetObjectAttributes struct {
}

func (*awsRestxml_serializeOpGetObjectAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetObjectAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetObjectAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}/{Key+}?attributes")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetObjectAttributesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetObjectAttributesInput(v *GetObjectAttributesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.Key == nil || len(*v.Key) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Key must not be empty")}
	}
	if v.Key != nil {
		if err := encoder.SetURI("Key").String(*v.Key); err != nil {
			return err
		}
	}

	if v.MaxParts != 0 {
		locationName := "X-Amz-Max-Parts"
		encoder.SetHeader(locationName).Integer(v.MaxParts)
	}

	if v.ObjectAttributes != nil {
		locationName := "X-Amz-Object-Attributes"
		for i := range v.ObjectAttributes {
			if len(v.ObjectAttributes[i]) > 0 {
				escaped := string(v.ObjectAttributes[i])
				if strings.Index(string(v.ObjectAttributes[i]), `,`) != -1 || strings.Index(string(v.ObjectAttributes[i]), `"`) != -1 {
					escaped = strconv.Quote(string(v.ObjectAttributes[i]))
				}

				encoder.AddHeader(locationName).String(string(escaped))
			}
		}
	}

	if v.PartNumberMarker != nil && len(*v.PartNumberMarker) > 0 {
		locationName := "X-Amz-Part-Number-Marker"
		encoder.SetHeader(locationName).String(*v.PartNumberMarker)
	}

	if len(v.RequestPayer) > 0 {
		locationName := "X-Amz-Request-Payer"
		encoder.SetHeader(locationName).String(string(v.RequestPayer))
	}

	if v.SSECustomerAlgorithm != nil && len(*v.SSECustomerAlgorithm) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Algorithm"
		encoder.SetHeader(locationName).String(*v.SSECustomerAlgorithm)
	}

	if v.SSECustomerKey != nil && len(*v.SSECustomerKey) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Key"
		encoder.SetHeader(locationName).String(*v.SSECustomerKey)
	}

	if v.SSECustomerKeyMD5 != nil && len(*v.SSECustomerKeyMD5) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Key-Md5"
		encoder.SetHeader(locationName).String(*v.SSECustomerKeyMD5)
	}

	if v.VersionId != nil {
		encoder.SetQuery("versionId").String(*v.VersionId)
	}

	return nil
}

type awsRestxml_serializeOpGetObjectLegalHold struct {
}

func (*awsRestxml_serializeOpGetObjectLegalHold) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetObjectLegalHold) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetObjectLegalHoldInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}/{Key+}?legal-hold")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetObjectLegalHoldInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetObjectLegalHoldInput(v *GetObjectLegalHoldInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.Key == nil || len(*v.Key) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Key must not be empty")}
	}
	if v.Key != nil {
		if err := encoder.SetURI("Key").String(*v.Key); err != nil {
			return err
		}
	}

	if len(v.RequestPayer) > 0 {
		locationName := "X-Amz-Request-Payer"
		encoder.SetHeader(locationName).String(string(v.RequestPayer))
	}

	if v.VersionId != nil {
		encoder.SetQuery("versionId").String(*v.VersionId)
	}

	return nil
}

type awsRestxml_serializeOpGetObjectLockConfiguration struct {
}

func (*awsRestxml_serializeOpGetObjectLockConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetObjectLockConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetObjectLockConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?object-lock")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetObjectLockConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetObjectLockConfigurationInput(v *GetObjectLockConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpGetObjectRetention struct {
}

func (*awsRestxml_serializeOpGetObjectRetention) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetObjectRetention) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetObjectRetentionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}/{Key+}?retention")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetObjectRetentionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetObjectRetentionInput(v *GetObjectRetentionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.Key == nil || len(*v.Key) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Key must not be empty")}
	}
	if v.Key != nil {
		if err := encoder.SetURI("Key").String(*v.Key); err != nil {
			return err
		}
	}

	if len(v.RequestPayer) > 0 {
		locationName := "X-Amz-Request-Payer"
		encoder.SetHeader(locationName).String(string(v.RequestPayer))
	}

	if v.VersionId != nil {
		encoder.SetQuery("versionId").String(*v.VersionId)
	}

	return nil
}

type awsRestxml_serializeOpGetObjectTagging struct {
}

func (*awsRestxml_serializeOpGetObjectTagging) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetObjectTagging) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetObjectTaggingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}/{Key+}?tagging")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetObjectTaggingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetObjectTaggingInput(v *GetObjectTaggingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.Key == nil || len(*v.Key) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Key must not be empty")}
	}
	if v.Key != nil {
		if err := encoder.SetURI("Key").String(*v.Key); err != nil {
			return err
		}
	}

	if len(v.RequestPayer) > 0 {
		locationName := "X-Amz-Request-Payer"
		encoder.SetHeader(locationName).String(string(v.RequestPayer))
	}

	if v.VersionId != nil {
		encoder.SetQuery("versionId").String(*v.VersionId)
	}

	return nil
}

type awsRestxml_serializeOpGetObjectTorrent struct {
}

func (*awsRestxml_serializeOpGetObjectTorrent) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetObjectTorrent) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetObjectTorrentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}/{Key+}?torrent")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetObjectTorrentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetObjectTorrentInput(v *GetObjectTorrentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.Key == nil || len(*v.Key) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Key must not be empty")}
	}
	if v.Key != nil {
		if err := encoder.SetURI("Key").String(*v.Key); err != nil {
			return err
		}
	}

	if len(v.RequestPayer) > 0 {
		locationName := "X-Amz-Request-Payer"
		encoder.SetHeader(locationName).String(string(v.RequestPayer))
	}

	return nil
}

type awsRestxml_serializeOpGetPublicAccessBlock struct {
}

func (*awsRestxml_serializeOpGetPublicAccessBlock) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetPublicAccessBlock) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPublicAccessBlockInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?publicAccessBlock")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetPublicAccessBlockInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetPublicAccessBlockInput(v *GetPublicAccessBlockInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpHeadBucket struct {
}

func (*awsRestxml_serializeOpHeadBucket) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpHeadBucket) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*HeadBucketInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "HEAD"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsHeadBucketInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsHeadBucketInput(v *HeadBucketInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpHeadObject struct {
}

func (*awsRestxml_serializeOpHeadObject) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpHeadObject) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*HeadObjectInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}/{Key+}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "HEAD"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsHeadObjectInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsHeadObjectInput(v *HeadObjectInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if len(v.ChecksumMode) > 0 {
		locationName := "X-Amz-Checksum-Mode"
		encoder.SetHeader(locationName).String(string(v.ChecksumMode))
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.IfMatch != nil && len(*v.IfMatch) > 0 {
		locationName := "If-Match"
		encoder.SetHeader(locationName).String(*v.IfMatch)
	}

	if v.IfModifiedSince != nil {
		locationName := "If-Modified-Since"
		encoder.SetHeader(locationName).String(smithytime.FormatHTTPDate(*v.IfModifiedSince))
	}

	if v.IfNoneMatch != nil && len(*v.IfNoneMatch) > 0 {
		locationName := "If-None-Match"
		encoder.SetHeader(locationName).String(*v.IfNoneMatch)
	}

	if v.IfUnmodifiedSince != nil {
		locationName := "If-Unmodified-Since"
		encoder.SetHeader(locationName).String(smithytime.FormatHTTPDate(*v.IfUnmodifiedSince))
	}

	if v.Key == nil || len(*v.Key) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Key must not be empty")}
	}
	if v.Key != nil {
		if err := encoder.SetURI("Key").String(*v.Key); err != nil {
			return err
		}
	}

	if v.PartNumber != 0 {
		encoder.SetQuery("partNumber").Integer(v.PartNumber)
	}

	if v.Range != nil && len(*v.Range) > 0 {
		locationName := "Range"
		encoder.SetHeader(locationName).String(*v.Range)
	}

	if len(v.RequestPayer) > 0 {
		locationName := "X-Amz-Request-Payer"
		encoder.SetHeader(locationName).String(string(v.RequestPayer))
	}

	if v.SSECustomerAlgorithm != nil && len(*v.SSECustomerAlgorithm) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Algorithm"
		encoder.SetHeader(locationName).String(*v.SSECustomerAlgorithm)
	}

	if v.SSECustomerKey != nil && len(*v.SSECustomerKey) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Key"
		encoder.SetHeader(locationName).String(*v.SSECustomerKey)
	}

	if v.SSECustomerKeyMD5 != nil && len(*v.SSECustomerKeyMD5) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Key-Md5"
		encoder.SetHeader(locationName).String(*v.SSECustomerKeyMD5)
	}

	if v.VersionId != nil {
		encoder.SetQuery("versionId").String(*v.VersionId)
	}

	return nil
}

type awsRestxml_serializeOpListBucketAnalyticsConfigurations struct {
}

func (*awsRestxml_serializeOpListBucketAnalyticsConfigurations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpListBucketAnalyticsConfigurations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListBucketAnalyticsConfigurationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?analytics&x-id=ListBucketAnalyticsConfigurations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsListBucketAnalyticsConfigurationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsListBucketAnalyticsConfigurationsInput(v *ListBucketAnalyticsConfigurationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ContinuationToken != nil {
		encoder.SetQuery("continuation-token").String(*v.ContinuationToken)
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpListBucketIntelligentTieringConfigurations struct {
}

func (*awsRestxml_serializeOpListBucketIntelligentTieringConfigurations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpListBucketIntelligentTieringConfigurations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListBucketIntelligentTieringConfigurationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?intelligent-tiering&x-id=ListBucketIntelligentTieringConfigurations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsListBucketIntelligentTieringConfigurationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsListBucketIntelligentTieringConfigurationsInput(v *ListBucketIntelligentTieringConfigurationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ContinuationToken != nil {
		encoder.SetQuery("continuation-token").String(*v.ContinuationToken)
	}

	return nil
}

type awsRestxml_serializeOpListBucketInventoryConfigurations struct {
}

func (*awsRestxml_serializeOpListBucketInventoryConfigurations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpListBucketInventoryConfigurations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListBucketInventoryConfigurationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?inventory&x-id=ListBucketInventoryConfigurations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsListBucketInventoryConfigurationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsListBucketInventoryConfigurationsInput(v *ListBucketInventoryConfigurationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ContinuationToken != nil {
		encoder.SetQuery("continuation-token").String(*v.ContinuationToken)
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpListBucketMetricsConfigurations struct {
}

func (*awsRestxml_serializeOpListBucketMetricsConfigurations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpListBucketMetricsConfigurations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListBucketMetricsConfigurationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?metrics&x-id=ListBucketMetricsConfigurations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsListBucketMetricsConfigurationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsListBucketMetricsConfigurationsInput(v *ListBucketMetricsConfigurationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ContinuationToken != nil {
		encoder.SetQuery("continuation-token").String(*v.ContinuationToken)
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpListBuckets struct {
}

func (*awsRestxml_serializeOpListBuckets) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpListBuckets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListBucketsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsListBucketsInput(v *ListBucketsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestxml_serializeOpListMultipartUploads struct {
}

func (*awsRestxml_serializeOpListMultipartUploads) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpListMultipartUploads) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListMultipartUploadsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?uploads")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsListMultipartUploadsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsListMultipartUploadsInput(v *ListMultipartUploadsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.Delimiter != nil {
		encoder.SetQuery("delimiter").String(*v.Delimiter)
	}

	if len(v.EncodingType) > 0 {
		encoder.SetQuery("encoding-type").String(string(v.EncodingType))
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.KeyMarker != nil {
		encoder.SetQuery("key-marker").String(*v.KeyMarker)
	}

	if v.MaxUploads != 0 {
		encoder.SetQuery("max-uploads").Integer(v.MaxUploads)
	}

	if v.Prefix != nil {
		encoder.SetQuery("prefix").String(*v.Prefix)
	}

	if v.UploadIdMarker != nil {
		encoder.SetQuery("upload-id-marker").String(*v.UploadIdMarker)
	}

	return nil
}

type awsRestxml_serializeOpListObjects struct {
}

func (*awsRestxml_serializeOpListObjects) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpListObjects) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListObjectsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsListObjectsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsListObjectsInput(v *ListObjectsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.Delimiter != nil {
		encoder.SetQuery("delimiter").String(*v.Delimiter)
	}

	if len(v.EncodingType) > 0 {
		encoder.SetQuery("encoding-type").String(string(v.EncodingType))
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.Marker != nil {
		encoder.SetQuery("marker").String(*v.Marker)
	}

	if v.MaxKeys != 0 {
		encoder.SetQuery("max-keys").Integer(v.MaxKeys)
	}

	if v.Prefix != nil {
		encoder.SetQuery("prefix").String(*v.Prefix)
	}

	if len(v.RequestPayer) > 0 {
		locationName := "X-Amz-Request-Payer"
		encoder.SetHeader(locationName).String(string(v.RequestPayer))
	}

	return nil
}

type awsRestxml_serializeOpListObjectsV2 struct {
}

func (*awsRestxml_serializeOpListObjectsV2) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpListObjectsV2) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListObjectsV2Input)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?list-type=2")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsListObjectsV2Input(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsListObjectsV2Input(v *ListObjectsV2Input, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ContinuationToken != nil {
		encoder.SetQuery("continuation-token").String(*v.ContinuationToken)
	}

	if v.Delimiter != nil {
		encoder.SetQuery("delimiter").String(*v.Delimiter)
	}

	if len(v.EncodingType) > 0 {
		encoder.SetQuery("encoding-type").String(string(v.EncodingType))
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.FetchOwner {
		encoder.SetQuery("fetch-owner").Boolean(v.FetchOwner)
	}

	if v.MaxKeys != 0 {
		encoder.SetQuery("max-keys").Integer(v.MaxKeys)
	}

	if v.Prefix != nil {
		encoder.SetQuery("prefix").String(*v.Prefix)
	}

	if len(v.RequestPayer) > 0 {
		locationName := "X-Amz-Request-Payer"
		encoder.SetHeader(locationName).String(string(v.RequestPayer))
	}

	if v.StartAfter != nil {
		encoder.SetQuery("start-after").String(*v.StartAfter)
	}

	return nil
}

type awsRestxml_serializeOpListObjectVersions struct {
}

func (*awsRestxml_serializeOpListObjectVersions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpListObjectVersions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListObjectVersionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?versions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsListObjectVersionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsListObjectVersionsInput(v *ListObjectVersionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.Delimiter != nil {
		encoder.SetQuery("delimiter").String(*v.Delimiter)
	}

	if len(v.EncodingType) > 0 {
		encoder.SetQuery("encoding-type").String(string(v.EncodingType))
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.KeyMarker != nil {
		encoder.SetQuery("key-marker").String(*v.KeyMarker)
	}

	if v.MaxKeys != 0 {
		encoder.SetQuery("max-keys").Integer(v.MaxKeys)
	}

	if v.Prefix != nil {
		encoder.SetQuery("prefix").String(*v.Prefix)
	}

	if v.VersionIdMarker != nil {
		encoder.SetQuery("version-id-marker").String(*v.VersionIdMarker)
	}

	return nil
}

type awsRestxml_serializeOpListParts struct {
}

func (*awsRestxml_serializeOpListParts) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpListParts) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListPartsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}/{Key+}?x-id=ListParts")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsListPartsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsListPartsInput(v *ListPartsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.Key == nil || len(*v.Key) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Key must not be empty")}
	}
	if v.Key != nil {
		if err := encoder.SetURI("Key").String(*v.Key); err != nil {
			return err
		}
	}

	if v.MaxParts != 0 {
		encoder.SetQuery("max-parts").Integer(v.MaxParts)
	}

	if v.PartNumberMarker != nil {
		encoder.SetQuery("part-number-marker").String(*v.PartNumberMarker)
	}

	if len(v.RequestPayer) > 0 {
		locationName := "X-Amz-Request-Payer"
		encoder.SetHeader(locationName).String(string(v.RequestPayer))
	}

	if v.SSECustomerAlgorithm != nil && len(*v.SSECustomerAlgorithm) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Algorithm"
		encoder.SetHeader(locationName).String(*v.SSECustomerAlgorithm)
	}

	if v.SSECustomerKey != nil && len(*v.SSECustomerKey) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Key"
		encoder.SetHeader(locationName).String(*v.SSECustomerKey)
	}

	if v.SSECustomerKeyMD5 != nil && len(*v.SSECustomerKeyMD5) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Key-Md5"
		encoder.SetHeader(locationName).String(*v.SSECustomerKeyMD5)
	}

	if v.UploadId != nil {
		encoder.SetQuery("uploadId").String(*v.UploadId)
	}

	return nil
}

type awsRestxml_serializeOpPutBucketAccelerateConfiguration struct {
}

func (*awsRestxml_serializeOpPutBucketAccelerateConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutBucketAccelerateConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutBucketAccelerateConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?accelerate")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutBucketAccelerateConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.AccelerateConfiguration != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AccelerateConfiguration",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://s3.amazonaws.com/doc/2006-03-01/"))
		if err := awsRestxml_serializeDocumentAccelerateConfiguration(input.AccelerateConfiguration, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutBucketAccelerateConfigurationInput(v *PutBucketAccelerateConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if len(v.ChecksumAlgorithm) > 0 {
		locationName := "X-Amz-Sdk-Checksum-Algorithm"
		encoder.SetHeader(locationName).String(string(v.ChecksumAlgorithm))
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpPutBucketAcl struct {
}

func (*awsRestxml_serializeOpPutBucketAcl) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutBucketAcl) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutBucketAclInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?acl")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutBucketAclInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.AccessControlPolicy != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AccessControlPolicy",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://s3.amazonaws.com/doc/2006-03-01/"))
		if err := awsRestxml_serializeDocumentAccessControlPolicy(input.AccessControlPolicy, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutBucketAclInput(v *PutBucketAclInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.ACL) > 0 {
		locationName := "X-Amz-Acl"
		encoder.SetHeader(locationName).String(string(v.ACL))
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if len(v.ChecksumAlgorithm) > 0 {
		locationName := "X-Amz-Sdk-Checksum-Algorithm"
		encoder.SetHeader(locationName).String(string(v.ChecksumAlgorithm))
	}

	if v.ContentMD5 != nil && len(*v.ContentMD5) > 0 {
		locationName := "Content-Md5"
		encoder.SetHeader(locationName).String(*v.ContentMD5)
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.GrantFullControl != nil && len(*v.GrantFullControl) > 0 {
		locationName := "X-Amz-Grant-Full-Control"
		encoder.SetHeader(locationName).String(*v.GrantFullControl)
	}

	if v.GrantRead != nil && len(*v.GrantRead) > 0 {
		locationName := "X-Amz-Grant-Read"
		encoder.SetHeader(locationName).String(*v.GrantRead)
	}

	if v.GrantReadACP != nil && len(*v.GrantReadACP) > 0 {
		locationName := "X-Amz-Grant-Read-Acp"
		encoder.SetHeader(locationName).String(*v.GrantReadACP)
	}

	if v.GrantWrite != nil && len(*v.GrantWrite) > 0 {
		locationName := "X-Amz-Grant-Write"
		encoder.SetHeader(locationName).String(*v.GrantWrite)
	}

	if v.GrantWriteACP != nil && len(*v.GrantWriteACP) > 0 {
		locationName := "X-Amz-Grant-Write-Acp"
		encoder.SetHeader(locationName).String(*v.GrantWriteACP)
	}

	return nil
}

type awsRestxml_serializeOpPutBucketAnalyticsConfiguration struct {
}

func (*awsRestxml_serializeOpPutBucketAnalyticsConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutBucketAnalyticsConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutBucketAnalyticsConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?analytics")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutBucketAnalyticsConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.AnalyticsConfiguration != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AnalyticsConfiguration",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://s3.amazonaws.com/doc/2006-03-01/"))
		if err := awsRestxml_serializeDocumentAnalyticsConfiguration(input.AnalyticsConfiguration, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutBucketAnalyticsConfigurationInput(v *PutBucketAnalyticsConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.Id != nil {
		encoder.SetQuery("id").String(*v.Id)
	}

	return nil
}

type awsRestxml_serializeOpPutBucketCors struct {
}

func (*awsRestxml_serializeOpPutBucketCors) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutBucketCors) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutBucketCorsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?cors")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutBucketCorsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.CORSConfiguration != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CORSConfiguration",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://s3.amazonaws.com/doc/2006-03-01/"))
		if err := awsRestxml_serializeDocumentCORSConfiguration(input.CORSConfiguration, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutBucketCorsInput(v *PutBucketCorsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if len(v.ChecksumAlgorithm) > 0 {
		locationName := "X-Amz-Sdk-Checksum-Algorithm"
		encoder.SetHeader(locationName).String(string(v.ChecksumAlgorithm))
	}

	if v.ContentMD5 != nil && len(*v.ContentMD5) > 0 {
		locationName := "Content-Md5"
		encoder.SetHeader(locationName).String(*v.ContentMD5)
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpPutBucketEncryption struct {
}

func (*awsRestxml_serializeOpPutBucketEncryption) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutBucketEncryption) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutBucketEncryptionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?encryption")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutBucketEncryptionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.ServerSideEncryptionConfiguration != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ServerSideEncryptionConfiguration",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://s3.amazonaws.com/doc/2006-03-01/"))
		if err := awsRestxml_serializeDocumentServerSideEncryptionConfiguration(input.ServerSideEncryptionConfiguration, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutBucketEncryptionInput(v *PutBucketEncryptionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if len(v.ChecksumAlgorithm) > 0 {
		locationName := "X-Amz-Sdk-Checksum-Algorithm"
		encoder.SetHeader(locationName).String(string(v.ChecksumAlgorithm))
	}

	if v.ContentMD5 != nil && len(*v.ContentMD5) > 0 {
		locationName := "Content-Md5"
		encoder.SetHeader(locationName).String(*v.ContentMD5)
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpPutBucketIntelligentTieringConfiguration struct {
}

func (*awsRestxml_serializeOpPutBucketIntelligentTieringConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutBucketIntelligentTieringConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutBucketIntelligentTieringConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?intelligent-tiering")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutBucketIntelligentTieringConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.IntelligentTieringConfiguration != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "IntelligentTieringConfiguration",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://s3.amazonaws.com/doc/2006-03-01/"))
		if err := awsRestxml_serializeDocumentIntelligentTieringConfiguration(input.IntelligentTieringConfiguration, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutBucketIntelligentTieringConfigurationInput(v *PutBucketIntelligentTieringConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.Id != nil {
		encoder.SetQuery("id").String(*v.Id)
	}

	return nil
}

type awsRestxml_serializeOpPutBucketInventoryConfiguration struct {
}

func (*awsRestxml_serializeOpPutBucketInventoryConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutBucketInventoryConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutBucketInventoryConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?inventory")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutBucketInventoryConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.InventoryConfiguration != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "InventoryConfiguration",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://s3.amazonaws.com/doc/2006-03-01/"))
		if err := awsRestxml_serializeDocumentInventoryConfiguration(input.InventoryConfiguration, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutBucketInventoryConfigurationInput(v *PutBucketInventoryConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.Id != nil {
		encoder.SetQuery("id").String(*v.Id)
	}

	return nil
}

type awsRestxml_serializeOpPutBucketLifecycleConfiguration struct {
}

func (*awsRestxml_serializeOpPutBucketLifecycleConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutBucketLifecycleConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutBucketLifecycleConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?lifecycle")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutBucketLifecycleConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.LifecycleConfiguration != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "LifecycleConfiguration",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://s3.amazonaws.com/doc/2006-03-01/"))
		if err := awsRestxml_serializeDocumentBucketLifecycleConfiguration(input.LifecycleConfiguration, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutBucketLifecycleConfigurationInput(v *PutBucketLifecycleConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if len(v.ChecksumAlgorithm) > 0 {
		locationName := "X-Amz-Sdk-Checksum-Algorithm"
		encoder.SetHeader(locationName).String(string(v.ChecksumAlgorithm))
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpPutBucketLogging struct {
}

func (*awsRestxml_serializeOpPutBucketLogging) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutBucketLogging) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutBucketLoggingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?logging")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutBucketLoggingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.BucketLoggingStatus != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "BucketLoggingStatus",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://s3.amazonaws.com/doc/2006-03-01/"))
		if err := awsRestxml_serializeDocumentBucketLoggingStatus(input.BucketLoggingStatus, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutBucketLoggingInput(v *PutBucketLoggingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if len(v.ChecksumAlgorithm) > 0 {
		locationName := "X-Amz-Sdk-Checksum-Algorithm"
		encoder.SetHeader(locationName).String(string(v.ChecksumAlgorithm))
	}

	if v.ContentMD5 != nil && len(*v.ContentMD5) > 0 {
		locationName := "Content-Md5"
		encoder.SetHeader(locationName).String(*v.ContentMD5)
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpPutBucketMetricsConfiguration struct {
}

func (*awsRestxml_serializeOpPutBucketMetricsConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutBucketMetricsConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutBucketMetricsConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?metrics")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutBucketMetricsConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.MetricsConfiguration != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "MetricsConfiguration",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://s3.amazonaws.com/doc/2006-03-01/"))
		if err := awsRestxml_serializeDocumentMetricsConfiguration(input.MetricsConfiguration, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutBucketMetricsConfigurationInput(v *PutBucketMetricsConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.Id != nil {
		encoder.SetQuery("id").String(*v.Id)
	}

	return nil
}

type awsRestxml_serializeOpPutBucketNotificationConfiguration struct {
}

func (*awsRestxml_serializeOpPutBucketNotificationConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutBucketNotificationConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutBucketNotificationConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?notification")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutBucketNotificationConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.NotificationConfiguration != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "NotificationConfiguration",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://s3.amazonaws.com/doc/2006-03-01/"))
		if err := awsRestxml_serializeDocumentNotificationConfiguration(input.NotificationConfiguration, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutBucketNotificationConfigurationInput(v *PutBucketNotificationConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.SkipDestinationValidation {
		locationName := "X-Amz-Skip-Destination-Validation"
		encoder.SetHeader(locationName).Boolean(v.SkipDestinationValidation)
	}

	return nil
}

type awsRestxml_serializeOpPutBucketOwnershipControls struct {
}

func (*awsRestxml_serializeOpPutBucketOwnershipControls) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutBucketOwnershipControls) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutBucketOwnershipControlsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?ownershipControls")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutBucketOwnershipControlsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.OwnershipControls != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "OwnershipControls",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://s3.amazonaws.com/doc/2006-03-01/"))
		if err := awsRestxml_serializeDocumentOwnershipControls(input.OwnershipControls, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutBucketOwnershipControlsInput(v *PutBucketOwnershipControlsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ContentMD5 != nil && len(*v.ContentMD5) > 0 {
		locationName := "Content-Md5"
		encoder.SetHeader(locationName).String(*v.ContentMD5)
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpPutBucketPolicy struct {
}

func (*awsRestxml_serializeOpPutBucketPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutBucketPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutBucketPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutBucketPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.Policy != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("text/plain")
		}

		payload := strings.NewReader(*input.Policy)
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutBucketPolicyInput(v *PutBucketPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if len(v.ChecksumAlgorithm) > 0 {
		locationName := "X-Amz-Sdk-Checksum-Algorithm"
		encoder.SetHeader(locationName).String(string(v.ChecksumAlgorithm))
	}

	if v.ConfirmRemoveSelfBucketAccess {
		locationName := "X-Amz-Confirm-Remove-Self-Bucket-Access"
		encoder.SetHeader(locationName).Boolean(v.ConfirmRemoveSelfBucketAccess)
	}

	if v.ContentMD5 != nil && len(*v.ContentMD5) > 0 {
		locationName := "Content-Md5"
		encoder.SetHeader(locationName).String(*v.ContentMD5)
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpPutBucketReplication struct {
}

func (*awsRestxml_serializeOpPutBucketReplication) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutBucketReplication) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutBucketReplicationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?replication")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutBucketReplicationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.ReplicationConfiguration != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ReplicationConfiguration",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://s3.amazonaws.com/doc/2006-03-01/"))
		if err := awsRestxml_serializeDocumentReplicationConfiguration(input.ReplicationConfiguration, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutBucketReplicationInput(v *PutBucketReplicationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if len(v.ChecksumAlgorithm) > 0 {
		locationName := "X-Amz-Sdk-Checksum-Algorithm"
		encoder.SetHeader(locationName).String(string(v.ChecksumAlgorithm))
	}

	if v.ContentMD5 != nil && len(*v.ContentMD5) > 0 {
		locationName := "Content-Md5"
		encoder.SetHeader(locationName).String(*v.ContentMD5)
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.Token != nil && len(*v.Token) > 0 {
		locationName := "X-Amz-Bucket-Object-Lock-Token"
		encoder.SetHeader(locationName).String(*v.Token)
	}

	return nil
}

type awsRestxml_serializeOpPutBucketRequestPayment struct {
}

func (*awsRestxml_serializeOpPutBucketRequestPayment) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutBucketRequestPayment) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutBucketRequestPaymentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?requestPayment")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutBucketRequestPaymentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.RequestPaymentConfiguration != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "RequestPaymentConfiguration",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://s3.amazonaws.com/doc/2006-03-01/"))
		if err := awsRestxml_serializeDocumentRequestPaymentConfiguration(input.RequestPaymentConfiguration, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutBucketRequestPaymentInput(v *PutBucketRequestPaymentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if len(v.ChecksumAlgorithm) > 0 {
		locationName := "X-Amz-Sdk-Checksum-Algorithm"
		encoder.SetHeader(locationName).String(string(v.ChecksumAlgorithm))
	}

	if v.ContentMD5 != nil && len(*v.ContentMD5) > 0 {
		locationName := "Content-Md5"
		encoder.SetHeader(locationName).String(*v.ContentMD5)
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpPutBucketTagging struct {
}

func (*awsRestxml_serializeOpPutBucketTagging) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutBucketTagging) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutBucketTaggingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?tagging")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutBucketTaggingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.Tagging != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Tagging",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://s3.amazonaws.com/doc/2006-03-01/"))
		if err := awsRestxml_serializeDocumentTagging(input.Tagging, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutBucketTaggingInput(v *PutBucketTaggingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if len(v.ChecksumAlgorithm) > 0 {
		locationName := "X-Amz-Sdk-Checksum-Algorithm"
		encoder.SetHeader(locationName).String(string(v.ChecksumAlgorithm))
	}

	if v.ContentMD5 != nil && len(*v.ContentMD5) > 0 {
		locationName := "Content-Md5"
		encoder.SetHeader(locationName).String(*v.ContentMD5)
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpPutBucketVersioning struct {
}

func (*awsRestxml_serializeOpPutBucketVersioning) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutBucketVersioning) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutBucketVersioningInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?versioning")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutBucketVersioningInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.VersioningConfiguration != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "VersioningConfiguration",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://s3.amazonaws.com/doc/2006-03-01/"))
		if err := awsRestxml_serializeDocumentVersioningConfiguration(input.VersioningConfiguration, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutBucketVersioningInput(v *PutBucketVersioningInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if len(v.ChecksumAlgorithm) > 0 {
		locationName := "X-Amz-Sdk-Checksum-Algorithm"
		encoder.SetHeader(locationName).String(string(v.ChecksumAlgorithm))
	}

	if v.ContentMD5 != nil && len(*v.ContentMD5) > 0 {
		locationName := "Content-Md5"
		encoder.SetHeader(locationName).String(*v.ContentMD5)
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.MFA != nil && len(*v.MFA) > 0 {
		locationName := "X-Amz-Mfa"
		encoder.SetHeader(locationName).String(*v.MFA)
	}

	return nil
}

type awsRestxml_serializeOpPutBucketWebsite struct {
}

func (*awsRestxml_serializeOpPutBucketWebsite) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutBucketWebsite) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutBucketWebsiteInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?website")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutBucketWebsiteInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.WebsiteConfiguration != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "WebsiteConfiguration",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://s3.amazonaws.com/doc/2006-03-01/"))
		if err := awsRestxml_serializeDocumentWebsiteConfiguration(input.WebsiteConfiguration, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutBucketWebsiteInput(v *PutBucketWebsiteInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if len(v.ChecksumAlgorithm) > 0 {
		locationName := "X-Amz-Sdk-Checksum-Algorithm"
		encoder.SetHeader(locationName).String(string(v.ChecksumAlgorithm))
	}

	if v.ContentMD5 != nil && len(*v.ContentMD5) > 0 {
		locationName := "Content-Md5"
		encoder.SetHeader(locationName).String(*v.ContentMD5)
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpPutObject struct {
}

func (*awsRestxml_serializeOpPutObject) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutObject) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutObjectInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}/{Key+}?x-id=PutObject")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutObjectInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.Body != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/octet-stream")
		}

		payload := input.Body
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutObjectInput(v *PutObjectInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.ACL) > 0 {
		locationName := "X-Amz-Acl"
		encoder.SetHeader(locationName).String(string(v.ACL))
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.BucketKeyEnabled {
		locationName := "X-Amz-Server-Side-Encryption-Bucket-Key-Enabled"
		encoder.SetHeader(locationName).Boolean(v.BucketKeyEnabled)
	}

	if v.CacheControl != nil && len(*v.CacheControl) > 0 {
		locationName := "Cache-Control"
		encoder.SetHeader(locationName).String(*v.CacheControl)
	}

	if len(v.ChecksumAlgorithm) > 0 {
		locationName := "X-Amz-Sdk-Checksum-Algorithm"
		encoder.SetHeader(locationName).String(string(v.ChecksumAlgorithm))
	}

	if v.ChecksumCRC32 != nil && len(*v.ChecksumCRC32) > 0 {
		locationName := "X-Amz-Checksum-Crc32"
		encoder.SetHeader(locationName).String(*v.ChecksumCRC32)
	}

	if v.ChecksumCRC32C != nil && len(*v.ChecksumCRC32C) > 0 {
		locationName := "X-Amz-Checksum-Crc32c"
		encoder.SetHeader(locationName).String(*v.ChecksumCRC32C)
	}

	if v.ChecksumSHA1 != nil && len(*v.ChecksumSHA1) > 0 {
		locationName := "X-Amz-Checksum-Sha1"
		encoder.SetHeader(locationName).String(*v.ChecksumSHA1)
	}

	if v.ChecksumSHA256 != nil && len(*v.ChecksumSHA256) > 0 {
		locationName := "X-Amz-Checksum-Sha256"
		encoder.SetHeader(locationName).String(*v.ChecksumSHA256)
	}

	if v.ContentDisposition != nil && len(*v.ContentDisposition) > 0 {
		locationName := "Content-Disposition"
		encoder.SetHeader(locationName).String(*v.ContentDisposition)
	}

	if v.ContentEncoding != nil && len(*v.ContentEncoding) > 0 {
		locationName := "Content-Encoding"
		encoder.SetHeader(locationName).String(*v.ContentEncoding)
	}

	if v.ContentLanguage != nil && len(*v.ContentLanguage) > 0 {
		locationName := "Content-Language"
		encoder.SetHeader(locationName).String(*v.ContentLanguage)
	}

	if v.ContentLength != 0 {
		locationName := "Content-Length"
		encoder.SetHeader(locationName).Long(v.ContentLength)
	}

	if v.ContentMD5 != nil && len(*v.ContentMD5) > 0 {
		locationName := "Content-Md5"
		encoder.SetHeader(locationName).String(*v.ContentMD5)
	}

	if v.ContentType != nil && len(*v.ContentType) > 0 {
		locationName := "Content-Type"
		encoder.SetHeader(locationName).String(*v.ContentType)
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.Expires != nil {
		locationName := "Expires"
		encoder.SetHeader(locationName).String(smithytime.FormatHTTPDate(*v.Expires))
	}

	if v.GrantFullControl != nil && len(*v.GrantFullControl) > 0 {
		locationName := "X-Amz-Grant-Full-Control"
		encoder.SetHeader(locationName).String(*v.GrantFullControl)
	}

	if v.GrantRead != nil && len(*v.GrantRead) > 0 {
		locationName := "X-Amz-Grant-Read"
		encoder.SetHeader(locationName).String(*v.GrantRead)
	}

	if v.GrantReadACP != nil && len(*v.GrantReadACP) > 0 {
		locationName := "X-Amz-Grant-Read-Acp"
		encoder.SetHeader(locationName).String(*v.GrantReadACP)
	}

	if v.GrantWriteACP != nil && len(*v.GrantWriteACP) > 0 {
		locationName := "X-Amz-Grant-Write-Acp"
		encoder.SetHeader(locationName).String(*v.GrantWriteACP)
	}

	if v.Key == nil || len(*v.Key) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Key must not be empty")}
	}
	if v.Key != nil {
		if err := encoder.SetURI("Key").String(*v.Key); err != nil {
			return err
		}
	}

	if v.Metadata != nil {
		hv := encoder.Headers("X-Amz-Meta-")
		for mapKey, mapVal := range v.Metadata {
			if len(mapVal) > 0 {
				hv.SetHeader(http.CanonicalHeaderKey(mapKey)).String(mapVal)
			}
		}
	}

	if len(v.ObjectLockLegalHoldStatus) > 0 {
		locationName := "X-Amz-Object-Lock-Legal-Hold"
		encoder.SetHeader(locationName).String(string(v.ObjectLockLegalHoldStatus))
	}

	if len(v.ObjectLockMode) > 0 {
		locationName := "X-Amz-Object-Lock-Mode"
		encoder.SetHeader(locationName).String(string(v.ObjectLockMode))
	}

	if v.ObjectLockRetainUntilDate != nil {
		locationName := "X-Amz-Object-Lock-Retain-Until-Date"
		encoder.SetHeader(locationName).String(smithytime.FormatDateTime(*v.ObjectLockRetainUntilDate))
	}

	if len(v.RequestPayer) > 0 {
		locationName := "X-Amz-Request-Payer"
		encoder.SetHeader(locationName).String(string(v.RequestPayer))
	}

	if len(v.ServerSideEncryption) > 0 {
		locationName := "X-Amz-Server-Side-Encryption"
		encoder.SetHeader(locationName).String(string(v.ServerSideEncryption))
	}

	if v.SSECustomerAlgorithm != nil && len(*v.SSECustomerAlgorithm) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Algorithm"
		encoder.SetHeader(locationName).String(*v.SSECustomerAlgorithm)
	}

	if v.SSECustomerKey != nil && len(*v.SSECustomerKey) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Key"
		encoder.SetHeader(locationName).String(*v.SSECustomerKey)
	}

	if v.SSECustomerKeyMD5 != nil && len(*v.SSECustomerKeyMD5) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Key-Md5"
		encoder.SetHeader(locationName).String(*v.SSECustomerKeyMD5)
	}

	if v.SSEKMSEncryptionContext != nil && len(*v.SSEKMSEncryptionContext) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Context"
		encoder.SetHeader(locationName).String(*v.SSEKMSEncryptionContext)
	}

	if v.SSEKMSKeyId != nil && len(*v.SSEKMSKeyId) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Aws-Kms-Key-Id"
		encoder.SetHeader(locationName).String(*v.SSEKMSKeyId)
	}

	if len(v.StorageClass) > 0 {
		locationName := "X-Amz-Storage-Class"
		encoder.SetHeader(locationName).String(string(v.StorageClass))
	}

	if v.Tagging != nil && len(*v.Tagging) > 0 {
		locationName := "X-Amz-Tagging"
		encoder.SetHeader(locationName).String(*v.Tagging)
	}

	if v.WebsiteRedirectLocation != nil && len(*v.WebsiteRedirectLocation) > 0 {
		locationName := "X-Amz-Website-Redirect-Location"
		encoder.SetHeader(locationName).String(*v.WebsiteRedirectLocation)
	}

	return nil
}

type awsRestxml_serializeOpPutObjectAcl struct {
}

func (*awsRestxml_serializeOpPutObjectAcl) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutObjectAcl) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutObjectAclInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}/{Key+}?acl")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutObjectAclInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.AccessControlPolicy != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AccessControlPolicy",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://s3.amazonaws.com/doc/2006-03-01/"))
		if err := awsRestxml_serializeDocumentAccessControlPolicy(input.AccessControlPolicy, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutObjectAclInput(v *PutObjectAclInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.ACL) > 0 {
		locationName := "X-Amz-Acl"
		encoder.SetHeader(locationName).String(string(v.ACL))
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if len(v.ChecksumAlgorithm) > 0 {
		locationName := "X-Amz-Sdk-Checksum-Algorithm"
		encoder.SetHeader(locationName).String(string(v.ChecksumAlgorithm))
	}

	if v.ContentMD5 != nil && len(*v.ContentMD5) > 0 {
		locationName := "Content-Md5"
		encoder.SetHeader(locationName).String(*v.ContentMD5)
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.GrantFullControl != nil && len(*v.GrantFullControl) > 0 {
		locationName := "X-Amz-Grant-Full-Control"
		encoder.SetHeader(locationName).String(*v.GrantFullControl)
	}

	if v.GrantRead != nil && len(*v.GrantRead) > 0 {
		locationName := "X-Amz-Grant-Read"
		encoder.SetHeader(locationName).String(*v.GrantRead)
	}

	if v.GrantReadACP != nil && len(*v.GrantReadACP) > 0 {
		locationName := "X-Amz-Grant-Read-Acp"
		encoder.SetHeader(locationName).String(*v.GrantReadACP)
	}

	if v.GrantWrite != nil && len(*v.GrantWrite) > 0 {
		locationName := "X-Amz-Grant-Write"
		encoder.SetHeader(locationName).String(*v.GrantWrite)
	}

	if v.GrantWriteACP != nil && len(*v.GrantWriteACP) > 0 {
		locationName := "X-Amz-Grant-Write-Acp"
		encoder.SetHeader(locationName).String(*v.GrantWriteACP)
	}

	if v.Key == nil || len(*v.Key) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Key must not be empty")}
	}
	if v.Key != nil {
		if err := encoder.SetURI("Key").String(*v.Key); err != nil {
			return err
		}
	}

	if len(v.RequestPayer) > 0 {
		locationName := "X-Amz-Request-Payer"
		encoder.SetHeader(locationName).String(string(v.RequestPayer))
	}

	if v.VersionId != nil {
		encoder.SetQuery("versionId").String(*v.VersionId)
	}

	return nil
}

type awsRestxml_serializeOpPutObjectLegalHold struct {
}

func (*awsRestxml_serializeOpPutObjectLegalHold) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutObjectLegalHold) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutObjectLegalHoldInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}/{Key+}?legal-hold")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutObjectLegalHoldInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.LegalHold != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "LegalHold",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://s3.amazonaws.com/doc/2006-03-01/"))
		if err := awsRestxml_serializeDocumentObjectLockLegalHold(input.LegalHold, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutObjectLegalHoldInput(v *PutObjectLegalHoldInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if len(v.ChecksumAlgorithm) > 0 {
		locationName := "X-Amz-Sdk-Checksum-Algorithm"
		encoder.SetHeader(locationName).String(string(v.ChecksumAlgorithm))
	}

	if v.ContentMD5 != nil && len(*v.ContentMD5) > 0 {
		locationName := "Content-Md5"
		encoder.SetHeader(locationName).String(*v.ContentMD5)
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.Key == nil || len(*v.Key) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Key must not be empty")}
	}
	if v.Key != nil {
		if err := encoder.SetURI("Key").String(*v.Key); err != nil {
			return err
		}
	}

	if len(v.RequestPayer) > 0 {
		locationName := "X-Amz-Request-Payer"
		encoder.SetHeader(locationName).String(string(v.RequestPayer))
	}

	if v.VersionId != nil {
		encoder.SetQuery("versionId").String(*v.VersionId)
	}

	return nil
}

type awsRestxml_serializeOpPutObjectLockConfiguration struct {
}

func (*awsRestxml_serializeOpPutObjectLockConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutObjectLockConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutObjectLockConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?object-lock")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutObjectLockConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.ObjectLockConfiguration != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ObjectLockConfiguration",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://s3.amazonaws.com/doc/2006-03-01/"))
		if err := awsRestxml_serializeDocumentObjectLockConfiguration(input.ObjectLockConfiguration, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutObjectLockConfigurationInput(v *PutObjectLockConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if len(v.ChecksumAlgorithm) > 0 {
		locationName := "X-Amz-Sdk-Checksum-Algorithm"
		encoder.SetHeader(locationName).String(string(v.ChecksumAlgorithm))
	}

	if v.ContentMD5 != nil && len(*v.ContentMD5) > 0 {
		locationName := "Content-Md5"
		encoder.SetHeader(locationName).String(*v.ContentMD5)
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if len(v.RequestPayer) > 0 {
		locationName := "X-Amz-Request-Payer"
		encoder.SetHeader(locationName).String(string(v.RequestPayer))
	}

	if v.Token != nil && len(*v.Token) > 0 {
		locationName := "X-Amz-Bucket-Object-Lock-Token"
		encoder.SetHeader(locationName).String(*v.Token)
	}

	return nil
}

type awsRestxml_serializeOpPutObjectRetention struct {
}

func (*awsRestxml_serializeOpPutObjectRetention) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutObjectRetention) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutObjectRetentionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}/{Key+}?retention")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutObjectRetentionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.Retention != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Retention",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://s3.amazonaws.com/doc/2006-03-01/"))
		if err := awsRestxml_serializeDocumentObjectLockRetention(input.Retention, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutObjectRetentionInput(v *PutObjectRetentionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.BypassGovernanceRetention {
		locationName := "X-Amz-Bypass-Governance-Retention"
		encoder.SetHeader(locationName).Boolean(v.BypassGovernanceRetention)
	}

	if len(v.ChecksumAlgorithm) > 0 {
		locationName := "X-Amz-Sdk-Checksum-Algorithm"
		encoder.SetHeader(locationName).String(string(v.ChecksumAlgorithm))
	}

	if v.ContentMD5 != nil && len(*v.ContentMD5) > 0 {
		locationName := "Content-Md5"
		encoder.SetHeader(locationName).String(*v.ContentMD5)
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.Key == nil || len(*v.Key) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Key must not be empty")}
	}
	if v.Key != nil {
		if err := encoder.SetURI("Key").String(*v.Key); err != nil {
			return err
		}
	}

	if len(v.RequestPayer) > 0 {
		locationName := "X-Amz-Request-Payer"
		encoder.SetHeader(locationName).String(string(v.RequestPayer))
	}

	if v.VersionId != nil {
		encoder.SetQuery("versionId").String(*v.VersionId)
	}

	return nil
}

type awsRestxml_serializeOpPutObjectTagging struct {
}

func (*awsRestxml_serializeOpPutObjectTagging) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutObjectTagging) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutObjectTaggingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}/{Key+}?tagging")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutObjectTaggingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.Tagging != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Tagging",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://s3.amazonaws.com/doc/2006-03-01/"))
		if err := awsRestxml_serializeDocumentTagging(input.Tagging, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutObjectTaggingInput(v *PutObjectTaggingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if len(v.ChecksumAlgorithm) > 0 {
		locationName := "X-Amz-Sdk-Checksum-Algorithm"
		encoder.SetHeader(locationName).String(string(v.ChecksumAlgorithm))
	}

	if v.ContentMD5 != nil && len(*v.ContentMD5) > 0 {
		locationName := "Content-Md5"
		encoder.SetHeader(locationName).String(*v.ContentMD5)
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.Key == nil || len(*v.Key) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Key must not be empty")}
	}
	if v.Key != nil {
		if err := encoder.SetURI("Key").String(*v.Key); err != nil {
			return err
		}
	}

	if len(v.RequestPayer) > 0 {
		locationName := "X-Amz-Request-Payer"
		encoder.SetHeader(locationName).String(string(v.RequestPayer))
	}

	if v.VersionId != nil {
		encoder.SetQuery("versionId").String(*v.VersionId)
	}

	return nil
}

type awsRestxml_serializeOpPutPublicAccessBlock struct {
}

func (*awsRestxml_serializeOpPutPublicAccessBlock) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutPublicAccessBlock) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutPublicAccessBlockInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}?publicAccessBlock")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutPublicAccessBlockInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.PublicAccessBlockConfiguration != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "PublicAccessBlockConfiguration",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://s3.amazonaws.com/doc/2006-03-01/"))
		if err := awsRestxml_serializeDocumentPublicAccessBlockConfiguration(input.PublicAccessBlockConfiguration, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutPublicAccessBlockInput(v *PutPublicAccessBlockInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if len(v.ChecksumAlgorithm) > 0 {
		locationName := "X-Amz-Sdk-Checksum-Algorithm"
		encoder.SetHeader(locationName).String(string(v.ChecksumAlgorithm))
	}

	if v.ContentMD5 != nil && len(*v.ContentMD5) > 0 {
		locationName := "Content-Md5"
		encoder.SetHeader(locationName).String(*v.ContentMD5)
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	return nil
}

type awsRestxml_serializeOpRestoreObject struct {
}

func (*awsRestxml_serializeOpRestoreObject) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpRestoreObject) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RestoreObjectInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}/{Key+}?restore&x-id=RestoreObject")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsRestoreObjectInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.RestoreRequest != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "RestoreRequest",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://s3.amazonaws.com/doc/2006-03-01/"))
		if err := awsRestxml_serializeDocumentRestoreRequest(input.RestoreRequest, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsRestoreObjectInput(v *RestoreObjectInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if len(v.ChecksumAlgorithm) > 0 {
		locationName := "X-Amz-Sdk-Checksum-Algorithm"
		encoder.SetHeader(locationName).String(string(v.ChecksumAlgorithm))
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.Key == nil || len(*v.Key) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Key must not be empty")}
	}
	if v.Key != nil {
		if err := encoder.SetURI("Key").String(*v.Key); err != nil {
			return err
		}
	}

	if len(v.RequestPayer) > 0 {
		locationName := "X-Amz-Request-Payer"
		encoder.SetHeader(locationName).String(string(v.RequestPayer))
	}

	if v.VersionId != nil {
		encoder.SetQuery("versionId").String(*v.VersionId)
	}

	return nil
}

type awsRestxml_serializeOpSelectObjectContent struct {
}

func (*awsRestxml_serializeOpSelectObjectContent) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpSelectObjectContent) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SelectObjectContentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}/{Key+}?select&select-type=2&x-id=SelectObjectContent")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsSelectObjectContentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "SelectObjectContentRequest",
		},
		Attr: rootAttr,
	}
	root.Attr = append(root.Attr, smithyxml.NewNamespaceAttribute("", "http://s3.amazonaws.com/doc/2006-03-01/"))
	if err := awsRestxml_serializeOpDocumentSelectObjectContentInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsSelectObjectContentInput(v *SelectObjectContentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.Key == nil || len(*v.Key) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Key must not be empty")}
	}
	if v.Key != nil {
		if err := encoder.SetURI("Key").String(*v.Key); err != nil {
			return err
		}
	}

	if v.SSECustomerAlgorithm != nil && len(*v.SSECustomerAlgorithm) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Algorithm"
		encoder.SetHeader(locationName).String(*v.SSECustomerAlgorithm)
	}

	if v.SSECustomerKey != nil && len(*v.SSECustomerKey) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Key"
		encoder.SetHeader(locationName).String(*v.SSECustomerKey)
	}

	if v.SSECustomerKeyMD5 != nil && len(*v.SSECustomerKeyMD5) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Key-Md5"
		encoder.SetHeader(locationName).String(*v.SSECustomerKeyMD5)
	}

	return nil
}

func awsRestxml_serializeOpDocumentSelectObjectContentInput(v *SelectObjectContentInput, value smithyxml.Value) error {
	defer value.Close()
	if v.Expression != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Expression",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Expression)
	}
	if len(v.ExpressionType) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ExpressionType",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.ExpressionType))
	}
	if v.InputSerialization != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "InputSerialization",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentInputSerialization(v.InputSerialization, el); err != nil {
			return err
		}
	}
	if v.OutputSerialization != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "OutputSerialization",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentOutputSerialization(v.OutputSerialization, el); err != nil {
			return err
		}
	}
	if v.RequestProgress != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "RequestProgress",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentRequestProgress(v.RequestProgress, el); err != nil {
			return err
		}
	}
	if v.ScanRange != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ScanRange",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentScanRange(v.ScanRange, el); err != nil {
			return err
		}
	}
	return nil
}

type awsRestxml_serializeOpUploadPart struct {
}

func (*awsRestxml_serializeOpUploadPart) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpUploadPart) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UploadPartInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}/{Key+}?x-id=UploadPart")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsUploadPartInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.Body != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/octet-stream")
		}

		payload := input.Body
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsUploadPartInput(v *UploadPartInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if len(v.ChecksumAlgorithm) > 0 {
		locationName := "X-Amz-Sdk-Checksum-Algorithm"
		encoder.SetHeader(locationName).String(string(v.ChecksumAlgorithm))
	}

	if v.ChecksumCRC32 != nil && len(*v.ChecksumCRC32) > 0 {
		locationName := "X-Amz-Checksum-Crc32"
		encoder.SetHeader(locationName).String(*v.ChecksumCRC32)
	}

	if v.ChecksumCRC32C != nil && len(*v.ChecksumCRC32C) > 0 {
		locationName := "X-Amz-Checksum-Crc32c"
		encoder.SetHeader(locationName).String(*v.ChecksumCRC32C)
	}

	if v.ChecksumSHA1 != nil && len(*v.ChecksumSHA1) > 0 {
		locationName := "X-Amz-Checksum-Sha1"
		encoder.SetHeader(locationName).String(*v.ChecksumSHA1)
	}

	if v.ChecksumSHA256 != nil && len(*v.ChecksumSHA256) > 0 {
		locationName := "X-Amz-Checksum-Sha256"
		encoder.SetHeader(locationName).String(*v.ChecksumSHA256)
	}

	if v.ContentLength != 0 {
		locationName := "Content-Length"
		encoder.SetHeader(locationName).Long(v.ContentLength)
	}

	if v.ContentMD5 != nil && len(*v.ContentMD5) > 0 {
		locationName := "Content-Md5"
		encoder.SetHeader(locationName).String(*v.ContentMD5)
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.Key == nil || len(*v.Key) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Key must not be empty")}
	}
	if v.Key != nil {
		if err := encoder.SetURI("Key").String(*v.Key); err != nil {
			return err
		}
	}

	{
		encoder.SetQuery("partNumber").Integer(v.PartNumber)
	}

	if len(v.RequestPayer) > 0 {
		locationName := "X-Amz-Request-Payer"
		encoder.SetHeader(locationName).String(string(v.RequestPayer))
	}

	if v.SSECustomerAlgorithm != nil && len(*v.SSECustomerAlgorithm) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Algorithm"
		encoder.SetHeader(locationName).String(*v.SSECustomerAlgorithm)
	}

	if v.SSECustomerKey != nil && len(*v.SSECustomerKey) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Key"
		encoder.SetHeader(locationName).String(*v.SSECustomerKey)
	}

	if v.SSECustomerKeyMD5 != nil && len(*v.SSECustomerKeyMD5) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Key-Md5"
		encoder.SetHeader(locationName).String(*v.SSECustomerKeyMD5)
	}

	if v.UploadId != nil {
		encoder.SetQuery("uploadId").String(*v.UploadId)
	}

	return nil
}

type awsRestxml_serializeOpUploadPartCopy struct {
}

func (*awsRestxml_serializeOpUploadPartCopy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpUploadPartCopy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UploadPartCopyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/{Bucket}/{Key+}?x-id=UploadPartCopy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsUploadPartCopyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsUploadPartCopyInput(v *UploadPartCopyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.CopySource != nil && len(*v.CopySource) > 0 {
		locationName := "X-Amz-Copy-Source"
		encoder.SetHeader(locationName).String(*v.CopySource)
	}

	if v.CopySourceIfMatch != nil && len(*v.CopySourceIfMatch) > 0 {
		locationName := "X-Amz-Copy-Source-If-Match"
		encoder.SetHeader(locationName).String(*v.CopySourceIfMatch)
	}

	if v.CopySourceIfModifiedSince != nil {
		locationName := "X-Amz-Copy-Source-If-Modified-Since"
		encoder.SetHeader(locationName).String(smithytime.FormatHTTPDate(*v.CopySourceIfModifiedSince))
	}

	if v.CopySourceIfNoneMatch != nil && len(*v.CopySourceIfNoneMatch) > 0 {
		locationName := "X-Amz-Copy-Source-If-None-Match"
		encoder.SetHeader(locationName).String(*v.CopySourceIfNoneMatch)
	}

	if v.CopySourceIfUnmodifiedSince != nil {
		locationName := "X-Amz-Copy-Source-If-Unmodified-Since"
		encoder.SetHeader(locationName).String(smithytime.FormatHTTPDate(*v.CopySourceIfUnmodifiedSince))
	}

	if v.CopySourceRange != nil && len(*v.CopySourceRange) > 0 {
		locationName := "X-Amz-Copy-Source-Range"
		encoder.SetHeader(locationName).String(*v.CopySourceRange)
	}

	if v.CopySourceSSECustomerAlgorithm != nil && len(*v.CopySourceSSECustomerAlgorithm) > 0 {
		locationName := "X-Amz-Copy-Source-Server-Side-Encryption-Customer-Algorithm"
		encoder.SetHeader(locationName).String(*v.CopySourceSSECustomerAlgorithm)
	}

	if v.CopySourceSSECustomerKey != nil && len(*v.CopySourceSSECustomerKey) > 0 {
		locationName := "X-Amz-Copy-Source-Server-Side-Encryption-Customer-Key"
		encoder.SetHeader(locationName).String(*v.CopySourceSSECustomerKey)
	}

	if v.CopySourceSSECustomerKeyMD5 != nil && len(*v.CopySourceSSECustomerKeyMD5) > 0 {
		locationName := "X-Amz-Copy-Source-Server-Side-Encryption-Customer-Key-Md5"
		encoder.SetHeader(locationName).String(*v.CopySourceSSECustomerKeyMD5)
	}

	if v.ExpectedBucketOwner != nil && len(*v.ExpectedBucketOwner) > 0 {
		locationName := "X-Amz-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedBucketOwner)
	}

	if v.ExpectedSourceBucketOwner != nil && len(*v.ExpectedSourceBucketOwner) > 0 {
		locationName := "X-Amz-Source-Expected-Bucket-Owner"
		encoder.SetHeader(locationName).String(*v.ExpectedSourceBucketOwner)
	}

	if v.Key == nil || len(*v.Key) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Key must not be empty")}
	}
	if v.Key != nil {
		if err := encoder.SetURI("Key").String(*v.Key); err != nil {
			return err
		}
	}

	{
		encoder.SetQuery("partNumber").Integer(v.PartNumber)
	}

	if len(v.RequestPayer) > 0 {
		locationName := "X-Amz-Request-Payer"
		encoder.SetHeader(locationName).String(string(v.RequestPayer))
	}

	if v.SSECustomerAlgorithm != nil && len(*v.SSECustomerAlgorithm) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Algorithm"
		encoder.SetHeader(locationName).String(*v.SSECustomerAlgorithm)
	}

	if v.SSECustomerKey != nil && len(*v.SSECustomerKey) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Key"
		encoder.SetHeader(locationName).String(*v.SSECustomerKey)
	}

	if v.SSECustomerKeyMD5 != nil && len(*v.SSECustomerKeyMD5) > 0 {
		locationName := "X-Amz-Server-Side-Encryption-Customer-Key-Md5"
		encoder.SetHeader(locationName).String(*v.SSECustomerKeyMD5)
	}

	if v.UploadId != nil {
		encoder.SetQuery("uploadId").String(*v.UploadId)
	}

	return nil
}

type awsRestxml_serializeOpWriteGetObjectResponse struct {
}

func (*awsRestxml_serializeOpWriteGetObjectResponse) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpWriteGetObjectResponse) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*WriteGetObjectResponseInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/WriteGetObjectResponse?x-id=WriteGetObjectResponse")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsWriteGetObjectResponseInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.Body != nil {
		if !restEncoder.HasHeader("Content-Type") {
			restEncoder.SetHeader("Content-Type").String("application/octet-stream")
		}

		payload := input.Body
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsWriteGetObjectResponseInput(v *WriteGetObjectResponseInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AcceptRanges != nil && len(*v.AcceptRanges) > 0 {
		locationName := "X-Amz-Fwd-Header-Accept-Ranges"
		encoder.SetHeader(locationName).String(*v.AcceptRanges)
	}

	if v.BucketKeyEnabled {
		locationName := "X-Amz-Fwd-Header-X-Amz-Server-Side-Encryption-Bucket-Key-Enabled"
		encoder.SetHeader(locationName).Boolean(v.BucketKeyEnabled)
	}

	if v.CacheControl != nil && len(*v.CacheControl) > 0 {
		locationName := "X-Amz-Fwd-Header-Cache-Control"
		encoder.SetHeader(locationName).String(*v.CacheControl)
	}

	if v.ChecksumCRC32 != nil && len(*v.ChecksumCRC32) > 0 {
		locationName := "X-Amz-Fwd-Header-X-Amz-Checksum-Crc32"
		encoder.SetHeader(locationName).String(*v.ChecksumCRC32)
	}

	if v.ChecksumCRC32C != nil && len(*v.ChecksumCRC32C) > 0 {
		locationName := "X-Amz-Fwd-Header-X-Amz-Checksum-Crc32c"
		encoder.SetHeader(locationName).String(*v.ChecksumCRC32C)
	}

	if v.ChecksumSHA1 != nil && len(*v.ChecksumSHA1) > 0 {
		locationName := "X-Amz-Fwd-Header-X-Amz-Checksum-Sha1"
		encoder.SetHeader(locationName).String(*v.ChecksumSHA1)
	}

	if v.ChecksumSHA256 != nil && len(*v.ChecksumSHA256) > 0 {
		locationName := "X-Amz-Fwd-Header-X-Amz-Checksum-Sha256"
		encoder.SetHeader(locationName).String(*v.ChecksumSHA256)
	}

	if v.ContentDisposition != nil && len(*v.ContentDisposition) > 0 {
		locationName := "X-Amz-Fwd-Header-Content-Disposition"
		encoder.SetHeader(locationName).String(*v.ContentDisposition)
	}

	if v.ContentEncoding != nil && len(*v.ContentEncoding) > 0 {
		locationName := "X-Amz-Fwd-Header-Content-Encoding"
		encoder.SetHeader(locationName).String(*v.ContentEncoding)
	}

	if v.ContentLanguage != nil && len(*v.ContentLanguage) > 0 {
		locationName := "X-Amz-Fwd-Header-Content-Language"
		encoder.SetHeader(locationName).String(*v.ContentLanguage)
	}

	if v.ContentLength != 0 {
		locationName := "Content-Length"
		encoder.SetHeader(locationName).Long(v.ContentLength)
	}

	if v.ContentRange != nil && len(*v.ContentRange) > 0 {
		locationName := "X-Amz-Fwd-Header-Content-Range"
		encoder.SetHeader(locationName).String(*v.ContentRange)
	}

	if v.ContentType != nil && len(*v.ContentType) > 0 {
		locationName := "X-Amz-Fwd-Header-Content-Type"
		encoder.SetHeader(locationName).String(*v.ContentType)
	}

	if v.DeleteMarker {
		locationName := "X-Amz-Fwd-Header-X-Amz-Delete-Marker"
		encoder.SetHeader(locationName).Boolean(v.DeleteMarker)
	}

	if v.ErrorCode != nil && len(*v.ErrorCode) > 0 {
		locationName := "X-Amz-Fwd-Error-Code"
		encoder.SetHeader(locationName).String(*v.ErrorCode)
	}

	if v.ErrorMessage != nil && len(*v.ErrorMessage) > 0 {
		locationName := "X-Amz-Fwd-Error-Message"
		encoder.SetHeader(locationName).String(*v.ErrorMessage)
	}

	if v.ETag != nil && len(*v.ETag) > 0 {
		locationName := "X-Amz-Fwd-Header-Etag"
		encoder.SetHeader(locationName).String(*v.ETag)
	}

	if v.Expiration != nil && len(*v.Expiration) > 0 {
		locationName := "X-Amz-Fwd-Header-X-Amz-Expiration"
		encoder.SetHeader(locationName).String(*v.Expiration)
	}

	if v.Expires != nil {
		locationName := "X-Amz-Fwd-Header-Expires"
		encoder.SetHeader(locationName).String(smithytime.FormatHTTPDate(*v.Expires))
	}

	if v.LastModified != nil {
		locationName := "X-Amz-Fwd-Header-Last-Modified"
		encoder.SetHeader(locationName).String(smithytime.FormatHTTPDate(*v.LastModified))
	}

	if v.Metadata != nil {
		hv := encoder.Headers("X-Amz-Meta-")
		for mapKey, mapVal := range v.Metadata {
			if len(mapVal) > 0 {
				hv.SetHeader(http.CanonicalHeaderKey(mapKey)).String(mapVal)
			}
		}
	}

	if v.MissingMeta != 0 {
		locationName := "X-Amz-Fwd-Header-X-Amz-Missing-Meta"
		encoder.SetHeader(locationName).Integer(v.MissingMeta)
	}

	if len(v.ObjectLockLegalHoldStatus) > 0 {
		locationName := "X-Amz-Fwd-Header-X-Amz-Object-Lock-Legal-Hold"
		encoder.SetHeader(locationName).String(string(v.ObjectLockLegalHoldStatus))
	}

	if len(v.ObjectLockMode) > 0 {
		locationName := "X-Amz-Fwd-Header-X-Amz-Object-Lock-Mode"
		encoder.SetHeader(locationName).String(string(v.ObjectLockMode))
	}

	if v.ObjectLockRetainUntilDate != nil {
		locationName := "X-Amz-Fwd-Header-X-Amz-Object-Lock-Retain-Until-Date"
		encoder.SetHeader(locationName).String(smithytime.FormatDateTime(*v.ObjectLockRetainUntilDate))
	}

	if v.PartsCount != 0 {
		locationName := "X-Amz-Fwd-Header-X-Amz-Mp-Parts-Count"
		encoder.SetHeader(locationName).Integer(v.PartsCount)
	}

	if len(v.ReplicationStatus) > 0 {
		locationName := "X-Amz-Fwd-Header-X-Amz-Replication-Status"
		encoder.SetHeader(locationName).String(string(v.ReplicationStatus))
	}

	if len(v.RequestCharged) > 0 {
		locationName := "X-Amz-Fwd-Header-X-Amz-Request-Charged"
		encoder.SetHeader(locationName).String(string(v.RequestCharged))
	}

	if v.RequestRoute != nil && len(*v.RequestRoute) > 0 {
		locationName := "X-Amz-Request-Route"
		encoder.SetHeader(locationName).String(*v.RequestRoute)
	}

	if v.RequestToken != nil && len(*v.RequestToken) > 0 {
		locationName := "X-Amz-Request-Token"
		encoder.SetHeader(locationName).String(*v.RequestToken)
	}

	if v.Restore != nil && len(*v.Restore) > 0 {
		locationName := "X-Amz-Fwd-Header-X-Amz-Restore"
		encoder.SetHeader(locationName).String(*v.Restore)
	}

	if len(v.ServerSideEncryption) > 0 {
		locationName := "X-Amz-Fwd-Header-X-Amz-Server-Side-Encryption"
		encoder.SetHeader(locationName).String(string(v.ServerSideEncryption))
	}

	if v.SSECustomerAlgorithm != nil && len(*v.SSECustomerAlgorithm) > 0 {
		locationName := "X-Amz-Fwd-Header-X-Amz-Server-Side-Encryption-Customer-Algorithm"
		encoder.SetHeader(locationName).String(*v.SSECustomerAlgorithm)
	}

	if v.SSECustomerKeyMD5 != nil && len(*v.SSECustomerKeyMD5) > 0 {
		locationName := "X-Amz-Fwd-Header-X-Amz-Server-Side-Encryption-Customer-Key-Md5"
		encoder.SetHeader(locationName).String(*v.SSECustomerKeyMD5)
	}

	if v.SSEKMSKeyId != nil && len(*v.SSEKMSKeyId) > 0 {
		locationName := "X-Amz-Fwd-Header-X-Amz-Server-Side-Encryption-Aws-Kms-Key-Id"
		encoder.SetHeader(locationName).String(*v.SSEKMSKeyId)
	}

	if v.StatusCode != 0 {
		locationName := "X-Amz-Fwd-Status"
		encoder.SetHeader(locationName).Integer(v.StatusCode)
	}

	if len(v.StorageClass) > 0 {
		locationName := "X-Amz-Fwd-Header-X-Amz-Storage-Class"
		encoder.SetHeader(locationName).String(string(v.StorageClass))
	}

	if v.TagCount != 0 {
		locationName := "X-Amz-Fwd-Header-X-Amz-Tagging-Count"
		encoder.SetHeader(locationName).Integer(v.TagCount)
	}

	if v.VersionId != nil && len(*v.VersionId) > 0 {
		locationName := "X-Amz-Fwd-Header-X-Amz-Version-Id"
		encoder.SetHeader(locationName).String(*v.VersionId)
	}

	return nil
}

func awsRestxml_serializeDocumentAbortIncompleteMultipartUpload(v *types.AbortIncompleteMultipartUpload, value smithyxml.Value) error {
	defer value.Close()
	if v.DaysAfterInitiation != 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "DaysAfterInitiation",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(v.DaysAfterInitiation)
	}
	return nil
}

func awsRestxml_serializeDocumentAccelerateConfiguration(v *types.AccelerateConfiguration, value smithyxml.Value) error {
	defer value.Close()
	if len(v.Status) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Status",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Status))
	}
	return nil
}

func awsRestxml_serializeDocumentAccessControlPolicy(v *types.AccessControlPolicy, value smithyxml.Value) error {
	defer value.Close()
	if v.Grants != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AccessControlList",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentGrants(v.Grants, el); err != nil {
			return err
		}
	}
	if v.Owner != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Owner",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentOwner(v.Owner, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentAccessControlTranslation(v *types.AccessControlTranslation, value smithyxml.Value) error {
	defer value.Close()
	if len(v.Owner) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Owner",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Owner))
	}
	return nil
}

func awsRestxml_serializeDocumentAllowedHeaders(v []string, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		am.String(v[i])
	}
	return nil
}

func awsRestxml_serializeDocumentAllowedMethods(v []string, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		am.String(v[i])
	}
	return nil
}

func awsRestxml_serializeDocumentAllowedOrigins(v []string, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		am.String(v[i])
	}
	return nil
}

func awsRestxml_serializeDocumentAnalyticsAndOperator(v *types.AnalyticsAndOperator, value smithyxml.Value) error {
	defer value.Close()
	if v.Prefix != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Prefix",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Prefix)
	}
	if v.Tags != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Tag",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentTagSet(v.Tags, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentAnalyticsConfiguration(v *types.AnalyticsConfiguration, value smithyxml.Value) error {
	defer value.Close()
	if v.Filter != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Filter",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentAnalyticsFilter(v.Filter, el); err != nil {
			return err
		}
	}
	if v.Id != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Id",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Id)
	}
	if v.StorageClassAnalysis != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "StorageClassAnalysis",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentStorageClassAnalysis(v.StorageClassAnalysis, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentAnalyticsExportDestination(v *types.AnalyticsExportDestination, value smithyxml.Value) error {
	defer value.Close()
	if v.S3BucketDestination != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "S3BucketDestination",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentAnalyticsS3BucketDestination(v.S3BucketDestination, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentAnalyticsFilter(v types.AnalyticsFilter, value smithyxml.Value) error {
	defer value.Close()
	switch uv := v.(type) {
	case *types.AnalyticsFilterMemberAnd:
		customMemberNameAttr := []smithyxml.Attr{}
		customMemberName := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "And",
			},
			Attr: customMemberNameAttr,
		}
		av := value.MemberElement(customMemberName)
		if err := awsRestxml_serializeDocumentAnalyticsAndOperator(&uv.Value, av); err != nil {
			return err
		}

	case *types.AnalyticsFilterMemberPrefix:
		customMemberNameAttr := []smithyxml.Attr{}
		customMemberName := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Prefix",
			},
			Attr: customMemberNameAttr,
		}
		av := value.MemberElement(customMemberName)
		av.String(uv.Value)

	case *types.AnalyticsFilterMemberTag:
		customMemberNameAttr := []smithyxml.Attr{}
		customMemberName := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Tag",
			},
			Attr: customMemberNameAttr,
		}
		av := value.MemberElement(customMemberName)
		if err := awsRestxml_serializeDocumentTag(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestxml_serializeDocumentAnalyticsS3BucketDestination(v *types.AnalyticsS3BucketDestination, value smithyxml.Value) error {
	defer value.Close()
	if v.Bucket != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Bucket",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Bucket)
	}
	if v.BucketAccountId != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "BucketAccountId",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.BucketAccountId)
	}
	if len(v.Format) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Format",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Format))
	}
	if v.Prefix != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Prefix",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Prefix)
	}
	return nil
}

func awsRestxml_serializeDocumentBucketLifecycleConfiguration(v *types.BucketLifecycleConfiguration, value smithyxml.Value) error {
	defer value.Close()
	if v.Rules != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Rule",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentLifecycleRules(v.Rules, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentBucketLoggingStatus(v *types.BucketLoggingStatus, value smithyxml.Value) error {
	defer value.Close()
	if v.LoggingEnabled != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "LoggingEnabled",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentLoggingEnabled(v.LoggingEnabled, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentCompletedMultipartUpload(v *types.CompletedMultipartUpload, value smithyxml.Value) error {
	defer value.Close()
	if v.Parts != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Part",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentCompletedPartList(v.Parts, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentCompletedPart(v *types.CompletedPart, value smithyxml.Value) error {
	defer value.Close()
	if v.ChecksumCRC32 != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ChecksumCRC32",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ChecksumCRC32)
	}
	if v.ChecksumCRC32C != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ChecksumCRC32C",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ChecksumCRC32C)
	}
	if v.ChecksumSHA1 != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ChecksumSHA1",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ChecksumSHA1)
	}
	if v.ChecksumSHA256 != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ChecksumSHA256",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ChecksumSHA256)
	}
	if v.ETag != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ETag",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ETag)
	}
	if v.PartNumber != 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "PartNumber",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(v.PartNumber)
	}
	return nil
}

func awsRestxml_serializeDocumentCompletedPartList(v []types.CompletedPart, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentCompletedPart(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentCondition(v *types.Condition, value smithyxml.Value) error {
	defer value.Close()
	if v.HttpErrorCodeReturnedEquals != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "HttpErrorCodeReturnedEquals",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.HttpErrorCodeReturnedEquals)
	}
	if v.KeyPrefixEquals != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "KeyPrefixEquals",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.KeyPrefixEquals)
	}
	return nil
}

func awsRestxml_serializeDocumentCORSConfiguration(v *types.CORSConfiguration, value smithyxml.Value) error {
	defer value.Close()
	if v.CORSRules != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CORSRule",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentCORSRules(v.CORSRules, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentCORSRule(v *types.CORSRule, value smithyxml.Value) error {
	defer value.Close()
	if v.AllowedHeaders != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AllowedHeader",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentAllowedHeaders(v.AllowedHeaders, el); err != nil {
			return err
		}
	}
	if v.AllowedMethods != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AllowedMethod",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentAllowedMethods(v.AllowedMethods, el); err != nil {
			return err
		}
	}
	if v.AllowedOrigins != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AllowedOrigin",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentAllowedOrigins(v.AllowedOrigins, el); err != nil {
			return err
		}
	}
	if v.ExposeHeaders != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ExposeHeader",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentExposeHeaders(v.ExposeHeaders, el); err != nil {
			return err
		}
	}
	if v.ID != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ID",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ID)
	}
	if v.MaxAgeSeconds != 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "MaxAgeSeconds",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(v.MaxAgeSeconds)
	}
	return nil
}

func awsRestxml_serializeDocumentCORSRules(v []types.CORSRule, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentCORSRule(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentCreateBucketConfiguration(v *types.CreateBucketConfiguration, value smithyxml.Value) error {
	defer value.Close()
	if len(v.LocationConstraint) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "LocationConstraint",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.LocationConstraint))
	}
	return nil
}

func awsRestxml_serializeDocumentCSVInput(v *types.CSVInput, value smithyxml.Value) error {
	defer value.Close()
	if v.AllowQuotedRecordDelimiter {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AllowQuotedRecordDelimiter",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(v.AllowQuotedRecordDelimiter)
	}
	if v.Comments != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Comments",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Comments)
	}
	if v.FieldDelimiter != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "FieldDelimiter",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.FieldDelimiter)
	}
	if len(v.FileHeaderInfo) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "FileHeaderInfo",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.FileHeaderInfo))
	}
	if v.QuoteCharacter != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "QuoteCharacter",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.QuoteCharacter)
	}
	if v.QuoteEscapeCharacter != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "QuoteEscapeCharacter",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.QuoteEscapeCharacter)
	}
	if v.RecordDelimiter != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "RecordDelimiter",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.RecordDelimiter)
	}
	return nil
}

func awsRestxml_serializeDocumentCSVOutput(v *types.CSVOutput, value smithyxml.Value) error {
	defer value.Close()
	if v.FieldDelimiter != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "FieldDelimiter",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.FieldDelimiter)
	}
	if v.QuoteCharacter != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "QuoteCharacter",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.QuoteCharacter)
	}
	if v.QuoteEscapeCharacter != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "QuoteEscapeCharacter",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.QuoteEscapeCharacter)
	}
	if len(v.QuoteFields) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "QuoteFields",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.QuoteFields))
	}
	if v.RecordDelimiter != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "RecordDelimiter",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.RecordDelimiter)
	}
	return nil
}

func awsRestxml_serializeDocumentDefaultRetention(v *types.DefaultRetention, value smithyxml.Value) error {
	defer value.Close()
	if v.Days != 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Days",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(v.Days)
	}
	if len(v.Mode) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Mode",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Mode))
	}
	if v.Years != 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Years",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(v.Years)
	}
	return nil
}

func awsRestxml_serializeDocumentDelete(v *types.Delete, value smithyxml.Value) error {
	defer value.Close()
	if v.Objects != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Object",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentObjectIdentifierList(v.Objects, el); err != nil {
			return err
		}
	}
	if v.Quiet {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Quiet",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(v.Quiet)
	}
	return nil
}

func awsRestxml_serializeDocumentDeleteMarkerReplication(v *types.DeleteMarkerReplication, value smithyxml.Value) error {
	defer value.Close()
	if len(v.Status) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Status",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Status))
	}
	return nil
}

func awsRestxml_serializeDocumentDestination(v *types.Destination, value smithyxml.Value) error {
	defer value.Close()
	if v.AccessControlTranslation != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AccessControlTranslation",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentAccessControlTranslation(v.AccessControlTranslation, el); err != nil {
			return err
		}
	}
	if v.Account != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Account",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Account)
	}
	if v.Bucket != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Bucket",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Bucket)
	}
	if v.EncryptionConfiguration != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "EncryptionConfiguration",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentEncryptionConfiguration(v.EncryptionConfiguration, el); err != nil {
			return err
		}
	}
	if v.Metrics != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Metrics",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentMetrics(v.Metrics, el); err != nil {
			return err
		}
	}
	if v.ReplicationTime != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ReplicationTime",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentReplicationTime(v.ReplicationTime, el); err != nil {
			return err
		}
	}
	if len(v.StorageClass) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "StorageClass",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.StorageClass))
	}
	return nil
}

func awsRestxml_serializeDocumentEncryption(v *types.Encryption, value smithyxml.Value) error {
	defer value.Close()
	if len(v.EncryptionType) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "EncryptionType",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.EncryptionType))
	}
	if v.KMSContext != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "KMSContext",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.KMSContext)
	}
	if v.KMSKeyId != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "KMSKeyId",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.KMSKeyId)
	}
	return nil
}

func awsRestxml_serializeDocumentEncryptionConfiguration(v *types.EncryptionConfiguration, value smithyxml.Value) error {
	defer value.Close()
	if v.ReplicaKmsKeyID != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ReplicaKmsKeyID",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ReplicaKmsKeyID)
	}
	return nil
}

func awsRestxml_serializeDocumentErrorDocument(v *types.ErrorDocument, value smithyxml.Value) error {
	defer value.Close()
	if v.Key != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Key",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Key)
	}
	return nil
}

func awsRestxml_serializeDocumentEventBridgeConfiguration(v *types.EventBridgeConfiguration, value smithyxml.Value) error {
	defer value.Close()
	return nil
}

func awsRestxml_serializeDocumentEventList(v []types.Event, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		am.String(string(v[i]))
	}
	return nil
}

func awsRestxml_serializeDocumentExistingObjectReplication(v *types.ExistingObjectReplication, value smithyxml.Value) error {
	defer value.Close()
	if len(v.Status) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Status",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Status))
	}
	return nil
}

func awsRestxml_serializeDocumentExposeHeaders(v []string, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		am.String(v[i])
	}
	return nil
}

func awsRestxml_serializeDocumentFilterRule(v *types.FilterRule, value smithyxml.Value) error {
	defer value.Close()
	if len(v.Name) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Name",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Name))
	}
	if v.Value != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Value",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Value)
	}
	return nil
}

func awsRestxml_serializeDocumentFilterRuleList(v []types.FilterRule, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentFilterRule(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentGlacierJobParameters(v *types.GlacierJobParameters, value smithyxml.Value) error {
	defer value.Close()
	if len(v.Tier) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Tier",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Tier))
	}
	return nil
}

func awsRestxml_serializeDocumentGrant(v *types.Grant, value smithyxml.Value) error {
	defer value.Close()
	if v.Grantee != nil {
		rootAttr := []smithyxml.Attr{}
		rootAttr = append(rootAttr, smithyxml.NewNamespaceAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance"))
		if len(v.Grantee.Type) > 0 {
			var av string
			av = string(v.Grantee.Type)
			rootAttr = append(rootAttr, smithyxml.NewAttribute("xsi:type", av))
		}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Grantee",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentGrantee(v.Grantee, el); err != nil {
			return err
		}
	}
	if len(v.Permission) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Permission",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Permission))
	}
	return nil
}

func awsRestxml_serializeDocumentGrantee(v *types.Grantee, value smithyxml.Value) error {
	defer value.Close()
	if v.DisplayName != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "DisplayName",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.DisplayName)
	}
	if v.EmailAddress != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "EmailAddress",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.EmailAddress)
	}
	if v.ID != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ID",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ID)
	}
	if v.URI != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "URI",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.URI)
	}
	return nil
}

func awsRestxml_serializeDocumentGrants(v []types.Grant, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "Grant",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentGrant(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentIndexDocument(v *types.IndexDocument, value smithyxml.Value) error {
	defer value.Close()
	if v.Suffix != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Suffix",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Suffix)
	}
	return nil
}

func awsRestxml_serializeDocumentInputSerialization(v *types.InputSerialization, value smithyxml.Value) error {
	defer value.Close()
	if len(v.CompressionType) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CompressionType",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.CompressionType))
	}
	if v.CSV != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CSV",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentCSVInput(v.CSV, el); err != nil {
			return err
		}
	}
	if v.JSON != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "JSON",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentJSONInput(v.JSON, el); err != nil {
			return err
		}
	}
	if v.Parquet != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Parquet",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentParquetInput(v.Parquet, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentIntelligentTieringAndOperator(v *types.IntelligentTieringAndOperator, value smithyxml.Value) error {
	defer value.Close()
	if v.Prefix != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Prefix",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Prefix)
	}
	if v.Tags != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Tag",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentTagSet(v.Tags, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentIntelligentTieringConfiguration(v *types.IntelligentTieringConfiguration, value smithyxml.Value) error {
	defer value.Close()
	if v.Filter != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Filter",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentIntelligentTieringFilter(v.Filter, el); err != nil {
			return err
		}
	}
	if v.Id != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Id",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Id)
	}
	if len(v.Status) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Status",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Status))
	}
	if v.Tierings != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Tiering",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentTieringList(v.Tierings, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentIntelligentTieringFilter(v *types.IntelligentTieringFilter, value smithyxml.Value) error {
	defer value.Close()
	if v.And != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "And",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentIntelligentTieringAndOperator(v.And, el); err != nil {
			return err
		}
	}
	if v.Prefix != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Prefix",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Prefix)
	}
	if v.Tag != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Tag",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentTag(v.Tag, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentInventoryConfiguration(v *types.InventoryConfiguration, value smithyxml.Value) error {
	defer value.Close()
	if v.Destination != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Destination",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentInventoryDestination(v.Destination, el); err != nil {
			return err
		}
	}
	if v.Filter != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Filter",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentInventoryFilter(v.Filter, el); err != nil {
			return err
		}
	}
	if v.Id != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Id",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Id)
	}
	if len(v.IncludedObjectVersions) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "IncludedObjectVersions",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.IncludedObjectVersions))
	}
	{
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "IsEnabled",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(v.IsEnabled)
	}
	if v.OptionalFields != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "OptionalFields",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentInventoryOptionalFields(v.OptionalFields, el); err != nil {
			return err
		}
	}
	if v.Schedule != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Schedule",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentInventorySchedule(v.Schedule, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentInventoryDestination(v *types.InventoryDestination, value smithyxml.Value) error {
	defer value.Close()
	if v.S3BucketDestination != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "S3BucketDestination",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentInventoryS3BucketDestination(v.S3BucketDestination, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentInventoryEncryption(v *types.InventoryEncryption, value smithyxml.Value) error {
	defer value.Close()
	if v.SSEKMS != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "SSE-KMS",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentSSEKMS(v.SSEKMS, el); err != nil {
			return err
		}
	}
	if v.SSES3 != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "SSE-S3",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentSSES3(v.SSES3, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentInventoryFilter(v *types.InventoryFilter, value smithyxml.Value) error {
	defer value.Close()
	if v.Prefix != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Prefix",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Prefix)
	}
	return nil
}

func awsRestxml_serializeDocumentInventoryOptionalFields(v []types.InventoryOptionalField, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "Field",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		am.String(string(v[i]))
	}
	return nil
}

func awsRestxml_serializeDocumentInventoryS3BucketDestination(v *types.InventoryS3BucketDestination, value smithyxml.Value) error {
	defer value.Close()
	if v.AccountId != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AccountId",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.AccountId)
	}
	if v.Bucket != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Bucket",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Bucket)
	}
	if v.Encryption != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Encryption",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentInventoryEncryption(v.Encryption, el); err != nil {
			return err
		}
	}
	if len(v.Format) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Format",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Format))
	}
	if v.Prefix != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Prefix",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Prefix)
	}
	return nil
}

func awsRestxml_serializeDocumentInventorySchedule(v *types.InventorySchedule, value smithyxml.Value) error {
	defer value.Close()
	if len(v.Frequency) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Frequency",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Frequency))
	}
	return nil
}

func awsRestxml_serializeDocumentJSONInput(v *types.JSONInput, value smithyxml.Value) error {
	defer value.Close()
	if len(v.Type) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Type",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Type))
	}
	return nil
}

func awsRestxml_serializeDocumentJSONOutput(v *types.JSONOutput, value smithyxml.Value) error {
	defer value.Close()
	if v.RecordDelimiter != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "RecordDelimiter",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.RecordDelimiter)
	}
	return nil
}

func awsRestxml_serializeDocumentLambdaFunctionConfiguration(v *types.LambdaFunctionConfiguration, value smithyxml.Value) error {
	defer value.Close()
	if v.Events != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Event",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentEventList(v.Events, el); err != nil {
			return err
		}
	}
	if v.Filter != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Filter",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentNotificationConfigurationFilter(v.Filter, el); err != nil {
			return err
		}
	}
	if v.Id != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Id",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Id)
	}
	if v.LambdaFunctionArn != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CloudFunction",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.LambdaFunctionArn)
	}
	return nil
}

func awsRestxml_serializeDocumentLambdaFunctionConfigurationList(v []types.LambdaFunctionConfiguration, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentLambdaFunctionConfiguration(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentLifecycleExpiration(v *types.LifecycleExpiration, value smithyxml.Value) error {
	defer value.Close()
	if v.Date != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Date",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(smithytime.FormatDateTime(*v.Date))
	}
	if v.Days != 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Days",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(v.Days)
	}
	if v.ExpiredObjectDeleteMarker {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ExpiredObjectDeleteMarker",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(v.ExpiredObjectDeleteMarker)
	}
	return nil
}

func awsRestxml_serializeDocumentLifecycleRule(v *types.LifecycleRule, value smithyxml.Value) error {
	defer value.Close()
	if v.AbortIncompleteMultipartUpload != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AbortIncompleteMultipartUpload",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentAbortIncompleteMultipartUpload(v.AbortIncompleteMultipartUpload, el); err != nil {
			return err
		}
	}
	if v.Expiration != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Expiration",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentLifecycleExpiration(v.Expiration, el); err != nil {
			return err
		}
	}
	if v.Filter != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Filter",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentLifecycleRuleFilter(v.Filter, el); err != nil {
			return err
		}
	}
	if v.ID != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ID",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ID)
	}
	if v.NoncurrentVersionExpiration != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "NoncurrentVersionExpiration",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentNoncurrentVersionExpiration(v.NoncurrentVersionExpiration, el); err != nil {
			return err
		}
	}
	if v.NoncurrentVersionTransitions != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "NoncurrentVersionTransition",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentNoncurrentVersionTransitionList(v.NoncurrentVersionTransitions, el); err != nil {
			return err
		}
	}
	if v.Prefix != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Prefix",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Prefix)
	}
	if len(v.Status) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Status",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Status))
	}
	if v.Transitions != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Transition",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentTransitionList(v.Transitions, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentLifecycleRuleAndOperator(v *types.LifecycleRuleAndOperator, value smithyxml.Value) error {
	defer value.Close()
	if v.ObjectSizeGreaterThan != 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ObjectSizeGreaterThan",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Long(v.ObjectSizeGreaterThan)
	}
	if v.ObjectSizeLessThan != 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ObjectSizeLessThan",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Long(v.ObjectSizeLessThan)
	}
	if v.Prefix != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Prefix",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Prefix)
	}
	if v.Tags != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Tag",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentTagSet(v.Tags, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentLifecycleRuleFilter(v types.LifecycleRuleFilter, value smithyxml.Value) error {
	defer value.Close()
	switch uv := v.(type) {
	case *types.LifecycleRuleFilterMemberAnd:
		customMemberNameAttr := []smithyxml.Attr{}
		customMemberName := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "And",
			},
			Attr: customMemberNameAttr,
		}
		av := value.MemberElement(customMemberName)
		if err := awsRestxml_serializeDocumentLifecycleRuleAndOperator(&uv.Value, av); err != nil {
			return err
		}

	case *types.LifecycleRuleFilterMemberObjectSizeGreaterThan:
		customMemberNameAttr := []smithyxml.Attr{}
		customMemberName := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ObjectSizeGreaterThan",
			},
			Attr: customMemberNameAttr,
		}
		av := value.MemberElement(customMemberName)
		av.Long(uv.Value)

	case *types.LifecycleRuleFilterMemberObjectSizeLessThan:
		customMemberNameAttr := []smithyxml.Attr{}
		customMemberName := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ObjectSizeLessThan",
			},
			Attr: customMemberNameAttr,
		}
		av := value.MemberElement(customMemberName)
		av.Long(uv.Value)

	case *types.LifecycleRuleFilterMemberPrefix:
		customMemberNameAttr := []smithyxml.Attr{}
		customMemberName := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Prefix",
			},
			Attr: customMemberNameAttr,
		}
		av := value.MemberElement(customMemberName)
		av.String(uv.Value)

	case *types.LifecycleRuleFilterMemberTag:
		customMemberNameAttr := []smithyxml.Attr{}
		customMemberName := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Tag",
			},
			Attr: customMemberNameAttr,
		}
		av := value.MemberElement(customMemberName)
		if err := awsRestxml_serializeDocumentTag(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestxml_serializeDocumentLifecycleRules(v []types.LifecycleRule, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentLifecycleRule(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentLoggingEnabled(v *types.LoggingEnabled, value smithyxml.Value) error {
	defer value.Close()
	if v.TargetBucket != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "TargetBucket",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.TargetBucket)
	}
	if v.TargetGrants != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "TargetGrants",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentTargetGrants(v.TargetGrants, el); err != nil {
			return err
		}
	}
	if v.TargetPrefix != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "TargetPrefix",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.TargetPrefix)
	}
	return nil
}

func awsRestxml_serializeDocumentMetadataEntry(v *types.MetadataEntry, value smithyxml.Value) error {
	defer value.Close()
	if v.Name != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Name",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Name)
	}
	if v.Value != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Value",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Value)
	}
	return nil
}

func awsRestxml_serializeDocumentMetrics(v *types.Metrics, value smithyxml.Value) error {
	defer value.Close()
	if v.EventThreshold != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "EventThreshold",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentReplicationTimeValue(v.EventThreshold, el); err != nil {
			return err
		}
	}
	if len(v.Status) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Status",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Status))
	}
	return nil
}

func awsRestxml_serializeDocumentMetricsAndOperator(v *types.MetricsAndOperator, value smithyxml.Value) error {
	defer value.Close()
	if v.AccessPointArn != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AccessPointArn",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.AccessPointArn)
	}
	if v.Prefix != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Prefix",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Prefix)
	}
	if v.Tags != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Tag",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentTagSet(v.Tags, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentMetricsConfiguration(v *types.MetricsConfiguration, value smithyxml.Value) error {
	defer value.Close()
	if v.Filter != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Filter",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentMetricsFilter(v.Filter, el); err != nil {
			return err
		}
	}
	if v.Id != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Id",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Id)
	}
	return nil
}

func awsRestxml_serializeDocumentMetricsFilter(v types.MetricsFilter, value smithyxml.Value) error {
	defer value.Close()
	switch uv := v.(type) {
	case *types.MetricsFilterMemberAccessPointArn:
		customMemberNameAttr := []smithyxml.Attr{}
		customMemberName := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AccessPointArn",
			},
			Attr: customMemberNameAttr,
		}
		av := value.MemberElement(customMemberName)
		av.String(uv.Value)

	case *types.MetricsFilterMemberAnd:
		customMemberNameAttr := []smithyxml.Attr{}
		customMemberName := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "And",
			},
			Attr: customMemberNameAttr,
		}
		av := value.MemberElement(customMemberName)
		if err := awsRestxml_serializeDocumentMetricsAndOperator(&uv.Value, av); err != nil {
			return err
		}

	case *types.MetricsFilterMemberPrefix:
		customMemberNameAttr := []smithyxml.Attr{}
		customMemberName := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Prefix",
			},
			Attr: customMemberNameAttr,
		}
		av := value.MemberElement(customMemberName)
		av.String(uv.Value)

	case *types.MetricsFilterMemberTag:
		customMemberNameAttr := []smithyxml.Attr{}
		customMemberName := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Tag",
			},
			Attr: customMemberNameAttr,
		}
		av := value.MemberElement(customMemberName)
		if err := awsRestxml_serializeDocumentTag(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestxml_serializeDocumentNoncurrentVersionExpiration(v *types.NoncurrentVersionExpiration, value smithyxml.Value) error {
	defer value.Close()
	if v.NewerNoncurrentVersions != 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "NewerNoncurrentVersions",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(v.NewerNoncurrentVersions)
	}
	if v.NoncurrentDays != 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "NoncurrentDays",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(v.NoncurrentDays)
	}
	return nil
}

func awsRestxml_serializeDocumentNoncurrentVersionTransition(v *types.NoncurrentVersionTransition, value smithyxml.Value) error {
	defer value.Close()
	if v.NewerNoncurrentVersions != 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "NewerNoncurrentVersions",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(v.NewerNoncurrentVersions)
	}
	if v.NoncurrentDays != 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "NoncurrentDays",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(v.NoncurrentDays)
	}
	if len(v.StorageClass) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "StorageClass",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.StorageClass))
	}
	return nil
}

func awsRestxml_serializeDocumentNoncurrentVersionTransitionList(v []types.NoncurrentVersionTransition, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentNoncurrentVersionTransition(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentNotificationConfiguration(v *types.NotificationConfiguration, value smithyxml.Value) error {
	defer value.Close()
	if v.EventBridgeConfiguration != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "EventBridgeConfiguration",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentEventBridgeConfiguration(v.EventBridgeConfiguration, el); err != nil {
			return err
		}
	}
	if v.LambdaFunctionConfigurations != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CloudFunctionConfiguration",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentLambdaFunctionConfigurationList(v.LambdaFunctionConfigurations, el); err != nil {
			return err
		}
	}
	if v.QueueConfigurations != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "QueueConfiguration",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentQueueConfigurationList(v.QueueConfigurations, el); err != nil {
			return err
		}
	}
	if v.TopicConfigurations != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "TopicConfiguration",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentTopicConfigurationList(v.TopicConfigurations, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentNotificationConfigurationFilter(v *types.NotificationConfigurationFilter, value smithyxml.Value) error {
	defer value.Close()
	if v.Key != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "S3Key",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentS3KeyFilter(v.Key, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentObjectIdentifier(v *types.ObjectIdentifier, value smithyxml.Value) error {
	defer value.Close()
	if v.Key != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Key",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Key)
	}
	if v.VersionId != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "VersionId",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.VersionId)
	}
	return nil
}

func awsRestxml_serializeDocumentObjectIdentifierList(v []types.ObjectIdentifier, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentObjectIdentifier(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentObjectLockConfiguration(v *types.ObjectLockConfiguration, value smithyxml.Value) error {
	defer value.Close()
	if len(v.ObjectLockEnabled) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ObjectLockEnabled",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.ObjectLockEnabled))
	}
	if v.Rule != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Rule",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentObjectLockRule(v.Rule, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentObjectLockLegalHold(v *types.ObjectLockLegalHold, value smithyxml.Value) error {
	defer value.Close()
	if len(v.Status) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Status",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Status))
	}
	return nil
}

func awsRestxml_serializeDocumentObjectLockRetention(v *types.ObjectLockRetention, value smithyxml.Value) error {
	defer value.Close()
	if len(v.Mode) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Mode",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Mode))
	}
	if v.RetainUntilDate != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "RetainUntilDate",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(smithytime.FormatDateTime(*v.RetainUntilDate))
	}
	return nil
}

func awsRestxml_serializeDocumentObjectLockRule(v *types.ObjectLockRule, value smithyxml.Value) error {
	defer value.Close()
	if v.DefaultRetention != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "DefaultRetention",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentDefaultRetention(v.DefaultRetention, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentOutputLocation(v *types.OutputLocation, value smithyxml.Value) error {
	defer value.Close()
	if v.S3 != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "S3",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentS3Location(v.S3, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentOutputSerialization(v *types.OutputSerialization, value smithyxml.Value) error {
	defer value.Close()
	if v.CSV != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CSV",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentCSVOutput(v.CSV, el); err != nil {
			return err
		}
	}
	if v.JSON != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "JSON",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentJSONOutput(v.JSON, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentOwner(v *types.Owner, value smithyxml.Value) error {
	defer value.Close()
	if v.DisplayName != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "DisplayName",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.DisplayName)
	}
	if v.ID != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ID",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ID)
	}
	return nil
}

func awsRestxml_serializeDocumentOwnershipControls(v *types.OwnershipControls, value smithyxml.Value) error {
	defer value.Close()
	if v.Rules != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Rule",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentOwnershipControlsRules(v.Rules, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentOwnershipControlsRule(v *types.OwnershipControlsRule, value smithyxml.Value) error {
	defer value.Close()
	if len(v.ObjectOwnership) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ObjectOwnership",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.ObjectOwnership))
	}
	return nil
}

func awsRestxml_serializeDocumentOwnershipControlsRules(v []types.OwnershipControlsRule, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentOwnershipControlsRule(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentParquetInput(v *types.ParquetInput, value smithyxml.Value) error {
	defer value.Close()
	return nil
}

func awsRestxml_serializeDocumentPublicAccessBlockConfiguration(v *types.PublicAccessBlockConfiguration, value smithyxml.Value) error {
	defer value.Close()
	if v.BlockPublicAcls {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "BlockPublicAcls",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(v.BlockPublicAcls)
	}
	if v.BlockPublicPolicy {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "BlockPublicPolicy",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(v.BlockPublicPolicy)
	}
	if v.IgnorePublicAcls {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "IgnorePublicAcls",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(v.IgnorePublicAcls)
	}
	if v.RestrictPublicBuckets {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "RestrictPublicBuckets",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(v.RestrictPublicBuckets)
	}
	return nil
}

func awsRestxml_serializeDocumentQueueConfiguration(v *types.QueueConfiguration, value smithyxml.Value) error {
	defer value.Close()
	if v.Events != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Event",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentEventList(v.Events, el); err != nil {
			return err
		}
	}
	if v.Filter != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Filter",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentNotificationConfigurationFilter(v.Filter, el); err != nil {
			return err
		}
	}
	if v.Id != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Id",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Id)
	}
	if v.QueueArn != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Queue",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.QueueArn)
	}
	return nil
}

func awsRestxml_serializeDocumentQueueConfigurationList(v []types.QueueConfiguration, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentQueueConfiguration(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentRedirect(v *types.Redirect, value smithyxml.Value) error {
	defer value.Close()
	if v.HostName != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "HostName",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.HostName)
	}
	if v.HttpRedirectCode != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "HttpRedirectCode",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.HttpRedirectCode)
	}
	if len(v.Protocol) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Protocol",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Protocol))
	}
	if v.ReplaceKeyPrefixWith != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ReplaceKeyPrefixWith",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ReplaceKeyPrefixWith)
	}
	if v.ReplaceKeyWith != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ReplaceKeyWith",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ReplaceKeyWith)
	}
	return nil
}

func awsRestxml_serializeDocumentRedirectAllRequestsTo(v *types.RedirectAllRequestsTo, value smithyxml.Value) error {
	defer value.Close()
	if v.HostName != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "HostName",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.HostName)
	}
	if len(v.Protocol) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Protocol",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Protocol))
	}
	return nil
}

func awsRestxml_serializeDocumentReplicaModifications(v *types.ReplicaModifications, value smithyxml.Value) error {
	defer value.Close()
	if len(v.Status) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Status",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Status))
	}
	return nil
}

func awsRestxml_serializeDocumentReplicationConfiguration(v *types.ReplicationConfiguration, value smithyxml.Value) error {
	defer value.Close()
	if v.Role != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Role",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Role)
	}
	if v.Rules != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Rule",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentReplicationRules(v.Rules, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentReplicationRule(v *types.ReplicationRule, value smithyxml.Value) error {
	defer value.Close()
	if v.DeleteMarkerReplication != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "DeleteMarkerReplication",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentDeleteMarkerReplication(v.DeleteMarkerReplication, el); err != nil {
			return err
		}
	}
	if v.Destination != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Destination",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentDestination(v.Destination, el); err != nil {
			return err
		}
	}
	if v.ExistingObjectReplication != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ExistingObjectReplication",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentExistingObjectReplication(v.ExistingObjectReplication, el); err != nil {
			return err
		}
	}
	if v.Filter != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Filter",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentReplicationRuleFilter(v.Filter, el); err != nil {
			return err
		}
	}
	if v.ID != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ID",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ID)
	}
	if v.Prefix != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Prefix",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Prefix)
	}
	if v.Priority != 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Priority",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(v.Priority)
	}
	if v.SourceSelectionCriteria != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "SourceSelectionCriteria",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentSourceSelectionCriteria(v.SourceSelectionCriteria, el); err != nil {
			return err
		}
	}
	if len(v.Status) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Status",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Status))
	}
	return nil
}

func awsRestxml_serializeDocumentReplicationRuleAndOperator(v *types.ReplicationRuleAndOperator, value smithyxml.Value) error {
	defer value.Close()
	if v.Prefix != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Prefix",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Prefix)
	}
	if v.Tags != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Tag",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentTagSet(v.Tags, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentReplicationRuleFilter(v types.ReplicationRuleFilter, value smithyxml.Value) error {
	defer value.Close()
	switch uv := v.(type) {
	case *types.ReplicationRuleFilterMemberAnd:
		customMemberNameAttr := []smithyxml.Attr{}
		customMemberName := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "And",
			},
			Attr: customMemberNameAttr,
		}
		av := value.MemberElement(customMemberName)
		if err := awsRestxml_serializeDocumentReplicationRuleAndOperator(&uv.Value, av); err != nil {
			return err
		}

	case *types.ReplicationRuleFilterMemberPrefix:
		customMemberNameAttr := []smithyxml.Attr{}
		customMemberName := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Prefix",
			},
			Attr: customMemberNameAttr,
		}
		av := value.MemberElement(customMemberName)
		av.String(uv.Value)

	case *types.ReplicationRuleFilterMemberTag:
		customMemberNameAttr := []smithyxml.Attr{}
		customMemberName := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Tag",
			},
			Attr: customMemberNameAttr,
		}
		av := value.MemberElement(customMemberName)
		if err := awsRestxml_serializeDocumentTag(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestxml_serializeDocumentReplicationRules(v []types.ReplicationRule, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentReplicationRule(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentReplicationTime(v *types.ReplicationTime, value smithyxml.Value) error {
	defer value.Close()
	if len(v.Status) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Status",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Status))
	}
	if v.Time != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Time",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentReplicationTimeValue(v.Time, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentReplicationTimeValue(v *types.ReplicationTimeValue, value smithyxml.Value) error {
	defer value.Close()
	if v.Minutes != 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Minutes",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(v.Minutes)
	}
	return nil
}

func awsRestxml_serializeDocumentRequestPaymentConfiguration(v *types.RequestPaymentConfiguration, value smithyxml.Value) error {
	defer value.Close()
	if len(v.Payer) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Payer",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Payer))
	}
	return nil
}

func awsRestxml_serializeDocumentRequestProgress(v *types.RequestProgress, value smithyxml.Value) error {
	defer value.Close()
	if v.Enabled {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Enabled",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(v.Enabled)
	}
	return nil
}

func awsRestxml_serializeDocumentRestoreRequest(v *types.RestoreRequest, value smithyxml.Value) error {
	defer value.Close()
	if v.Days != 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Days",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(v.Days)
	}
	if v.Description != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Description",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Description)
	}
	if v.GlacierJobParameters != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "GlacierJobParameters",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentGlacierJobParameters(v.GlacierJobParameters, el); err != nil {
			return err
		}
	}
	if v.OutputLocation != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "OutputLocation",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentOutputLocation(v.OutputLocation, el); err != nil {
			return err
		}
	}
	if v.SelectParameters != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "SelectParameters",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentSelectParameters(v.SelectParameters, el); err != nil {
			return err
		}
	}
	if len(v.Tier) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Tier",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Tier))
	}
	if len(v.Type) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Type",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Type))
	}
	return nil
}

func awsRestxml_serializeDocumentRoutingRule(v *types.RoutingRule, value smithyxml.Value) error {
	defer value.Close()
	if v.Condition != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Condition",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentCondition(v.Condition, el); err != nil {
			return err
		}
	}
	if v.Redirect != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Redirect",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentRedirect(v.Redirect, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentRoutingRules(v []types.RoutingRule, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "RoutingRule",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentRoutingRule(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentS3KeyFilter(v *types.S3KeyFilter, value smithyxml.Value) error {
	defer value.Close()
	if v.FilterRules != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "FilterRule",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentFilterRuleList(v.FilterRules, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentS3Location(v *types.S3Location, value smithyxml.Value) error {
	defer value.Close()
	if v.AccessControlList != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AccessControlList",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentGrants(v.AccessControlList, el); err != nil {
			return err
		}
	}
	if v.BucketName != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "BucketName",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.BucketName)
	}
	if len(v.CannedACL) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CannedACL",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.CannedACL))
	}
	if v.Encryption != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Encryption",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentEncryption(v.Encryption, el); err != nil {
			return err
		}
	}
	if v.Prefix != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Prefix",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Prefix)
	}
	if len(v.StorageClass) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "StorageClass",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.StorageClass))
	}
	if v.Tagging != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Tagging",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentTagging(v.Tagging, el); err != nil {
			return err
		}
	}
	if v.UserMetadata != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "UserMetadata",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentUserMetadata(v.UserMetadata, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentScanRange(v *types.ScanRange, value smithyxml.Value) error {
	defer value.Close()
	if v.End != 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "End",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Long(v.End)
	}
	if v.Start != 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Start",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Long(v.Start)
	}
	return nil
}

func awsRestxml_serializeDocumentSelectParameters(v *types.SelectParameters, value smithyxml.Value) error {
	defer value.Close()
	if v.Expression != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Expression",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Expression)
	}
	if len(v.ExpressionType) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ExpressionType",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.ExpressionType))
	}
	if v.InputSerialization != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "InputSerialization",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentInputSerialization(v.InputSerialization, el); err != nil {
			return err
		}
	}
	if v.OutputSerialization != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "OutputSerialization",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentOutputSerialization(v.OutputSerialization, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentServerSideEncryptionByDefault(v *types.ServerSideEncryptionByDefault, value smithyxml.Value) error {
	defer value.Close()
	if v.KMSMasterKeyID != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "KMSMasterKeyID",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.KMSMasterKeyID)
	}
	if len(v.SSEAlgorithm) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "SSEAlgorithm",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.SSEAlgorithm))
	}
	return nil
}

func awsRestxml_serializeDocumentServerSideEncryptionConfiguration(v *types.ServerSideEncryptionConfiguration, value smithyxml.Value) error {
	defer value.Close()
	if v.Rules != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Rule",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentServerSideEncryptionRules(v.Rules, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentServerSideEncryptionRule(v *types.ServerSideEncryptionRule, value smithyxml.Value) error {
	defer value.Close()
	if v.ApplyServerSideEncryptionByDefault != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ApplyServerSideEncryptionByDefault",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentServerSideEncryptionByDefault(v.ApplyServerSideEncryptionByDefault, el); err != nil {
			return err
		}
	}
	if v.BucketKeyEnabled {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "BucketKeyEnabled",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(v.BucketKeyEnabled)
	}
	return nil
}

func awsRestxml_serializeDocumentServerSideEncryptionRules(v []types.ServerSideEncryptionRule, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentServerSideEncryptionRule(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentSourceSelectionCriteria(v *types.SourceSelectionCriteria, value smithyxml.Value) error {
	defer value.Close()
	if v.ReplicaModifications != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ReplicaModifications",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentReplicaModifications(v.ReplicaModifications, el); err != nil {
			return err
		}
	}
	if v.SseKmsEncryptedObjects != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "SseKmsEncryptedObjects",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentSseKmsEncryptedObjects(v.SseKmsEncryptedObjects, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentSSEKMS(v *types.SSEKMS, value smithyxml.Value) error {
	defer value.Close()
	if v.KeyId != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "KeyId",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.KeyId)
	}
	return nil
}

func awsRestxml_serializeDocumentSseKmsEncryptedObjects(v *types.SseKmsEncryptedObjects, value smithyxml.Value) error {
	defer value.Close()
	if len(v.Status) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Status",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Status))
	}
	return nil
}

func awsRestxml_serializeDocumentSSES3(v *types.SSES3, value smithyxml.Value) error {
	defer value.Close()
	return nil
}

func awsRestxml_serializeDocumentStorageClassAnalysis(v *types.StorageClassAnalysis, value smithyxml.Value) error {
	defer value.Close()
	if v.DataExport != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "DataExport",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentStorageClassAnalysisDataExport(v.DataExport, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentStorageClassAnalysisDataExport(v *types.StorageClassAnalysisDataExport, value smithyxml.Value) error {
	defer value.Close()
	if v.Destination != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Destination",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentAnalyticsExportDestination(v.Destination, el); err != nil {
			return err
		}
	}
	if len(v.OutputSchemaVersion) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "OutputSchemaVersion",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.OutputSchemaVersion))
	}
	return nil
}

func awsRestxml_serializeDocumentTag(v *types.Tag, value smithyxml.Value) error {
	defer value.Close()
	if v.Key != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Key",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Key)
	}
	if v.Value != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Value",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Value)
	}
	return nil
}

func awsRestxml_serializeDocumentTagging(v *types.Tagging, value smithyxml.Value) error {
	defer value.Close()
	if v.TagSet != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "TagSet",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentTagSet(v.TagSet, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentTagSet(v []types.Tag, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "Tag",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentTag(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentTargetGrant(v *types.TargetGrant, value smithyxml.Value) error {
	defer value.Close()
	if v.Grantee != nil {
		rootAttr := []smithyxml.Attr{}
		rootAttr = append(rootAttr, smithyxml.NewNamespaceAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance"))
		if len(v.Grantee.Type) > 0 {
			var av string
			av = string(v.Grantee.Type)
			rootAttr = append(rootAttr, smithyxml.NewAttribute("xsi:type", av))
		}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Grantee",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentGrantee(v.Grantee, el); err != nil {
			return err
		}
	}
	if len(v.Permission) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Permission",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Permission))
	}
	return nil
}

func awsRestxml_serializeDocumentTargetGrants(v []types.TargetGrant, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "Grant",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentTargetGrant(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentTiering(v *types.Tiering, value smithyxml.Value) error {
	defer value.Close()
	if len(v.AccessTier) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AccessTier",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.AccessTier))
	}
	{
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Days",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(v.Days)
	}
	return nil
}

func awsRestxml_serializeDocumentTieringList(v []types.Tiering, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentTiering(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentTopicConfiguration(v *types.TopicConfiguration, value smithyxml.Value) error {
	defer value.Close()
	if v.Events != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Event",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentEventList(v.Events, el); err != nil {
			return err
		}
	}
	if v.Filter != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Filter",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentNotificationConfigurationFilter(v.Filter, el); err != nil {
			return err
		}
	}
	if v.Id != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Id",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Id)
	}
	if v.TopicArn != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Topic",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.TopicArn)
	}
	return nil
}

func awsRestxml_serializeDocumentTopicConfigurationList(v []types.TopicConfiguration, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentTopicConfiguration(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentTransition(v *types.Transition, value smithyxml.Value) error {
	defer value.Close()
	if v.Date != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Date",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(smithytime.FormatDateTime(*v.Date))
	}
	if v.Days != 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Days",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(v.Days)
	}
	if len(v.StorageClass) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "StorageClass",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.StorageClass))
	}
	return nil
}

func awsRestxml_serializeDocumentTransitionList(v []types.Transition, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentTransition(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentUserMetadata(v []types.MetadataEntry, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "MetadataEntry",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentMetadataEntry(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentVersioningConfiguration(v *types.VersioningConfiguration, value smithyxml.Value) error {
	defer value.Close()
	if len(v.MFADelete) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "MfaDelete",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.MFADelete))
	}
	if len(v.Status) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Status",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Status))
	}
	return nil
}

func awsRestxml_serializeDocumentWebsiteConfiguration(v *types.WebsiteConfiguration, value smithyxml.Value) error {
	defer value.Close()
	if v.ErrorDocument != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ErrorDocument",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentErrorDocument(v.ErrorDocument, el); err != nil {
			return err
		}
	}
	if v.IndexDocument != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "IndexDocument",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentIndexDocument(v.IndexDocument, el); err != nil {
			return err
		}
	}
	if v.RedirectAllRequestsTo != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "RedirectAllRequestsTo",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentRedirectAllRequestsTo(v.RedirectAllRequestsTo, el); err != nil {
			return err
		}
	}
	if v.RoutingRules != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "RoutingRules",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentRoutingRules(v.RoutingRules, el); err != nil {
			return err
		}
	}
	return nil
}
