// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package locationservice

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAssociateTrackerConsumer = "AssociateTrackerConsumer"

// AssociateTrackerConsumerRequest generates a "aws/request.Request" representing the
// client's request for the AssociateTrackerConsumer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateTrackerConsumer for more information on using the AssociateTrackerConsumer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateTrackerConsumerRequest method.
//    req, resp := client.AssociateTrackerConsumerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/AssociateTrackerConsumer
func (c *LocationService) AssociateTrackerConsumerRequest(input *AssociateTrackerConsumerInput) (req *request.Request, output *AssociateTrackerConsumerOutput) {
	op := &request.Operation{
		Name:       opAssociateTrackerConsumer,
		HTTPMethod: "POST",
		HTTPPath:   "/tracking/v0/trackers/{TrackerName}/consumers",
	}

	if input == nil {
		input = &AssociateTrackerConsumerInput{}
	}

	output = &AssociateTrackerConsumerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("tracking.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// AssociateTrackerConsumer API operation for Amazon Location Service.
//
// Creates an association between a geofence collection and a tracker resource.
// This allows the tracker resource to communicate location data to the linked
// geofence collection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation AssociateTrackerConsumer for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request has failed to process because of an unknown server error, exception,
//   or failure.
//
//   * ResourceNotFoundException
//   The resource that you've entered was not found in your AWS account.
//
//   * ConflictException
//   The request was unsuccessful due to a conflict.
//
//   * AccessDeniedException
//   The request was denied due to insufficient access or permission. Check with
//   an administrator to verify your permissions.
//
//   * ValidationException
//   The input failed to meet the constraints specified by the AWS service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/AssociateTrackerConsumer
func (c *LocationService) AssociateTrackerConsumer(input *AssociateTrackerConsumerInput) (*AssociateTrackerConsumerOutput, error) {
	req, out := c.AssociateTrackerConsumerRequest(input)
	return out, req.Send()
}

// AssociateTrackerConsumerWithContext is the same as AssociateTrackerConsumer with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateTrackerConsumer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) AssociateTrackerConsumerWithContext(ctx aws.Context, input *AssociateTrackerConsumerInput, opts ...request.Option) (*AssociateTrackerConsumerOutput, error) {
	req, out := c.AssociateTrackerConsumerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDeleteGeofence = "BatchDeleteGeofence"

// BatchDeleteGeofenceRequest generates a "aws/request.Request" representing the
// client's request for the BatchDeleteGeofence operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDeleteGeofence for more information on using the BatchDeleteGeofence
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDeleteGeofenceRequest method.
//    req, resp := client.BatchDeleteGeofenceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchDeleteGeofence
func (c *LocationService) BatchDeleteGeofenceRequest(input *BatchDeleteGeofenceInput) (req *request.Request, output *BatchDeleteGeofenceOutput) {
	op := &request.Operation{
		Name:       opBatchDeleteGeofence,
		HTTPMethod: "POST",
		HTTPPath:   "/geofencing/v0/collections/{CollectionName}/delete-geofences",
	}

	if input == nil {
		input = &BatchDeleteGeofenceInput{}
	}

	output = &BatchDeleteGeofenceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("geofencing.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// BatchDeleteGeofence API operation for Amazon Location Service.
//
// Deletes a batch of geofences from a geofence collection.
//
// This action deletes the resource permanently. You can't undo this action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation BatchDeleteGeofence for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request has failed to process because of an unknown server error, exception,
//   or failure.
//
//   * ResourceNotFoundException
//   The resource that you've entered was not found in your AWS account.
//
//   * AccessDeniedException
//   The request was denied due to insufficient access or permission. Check with
//   an administrator to verify your permissions.
//
//   * ValidationException
//   The input failed to meet the constraints specified by the AWS service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchDeleteGeofence
func (c *LocationService) BatchDeleteGeofence(input *BatchDeleteGeofenceInput) (*BatchDeleteGeofenceOutput, error) {
	req, out := c.BatchDeleteGeofenceRequest(input)
	return out, req.Send()
}

// BatchDeleteGeofenceWithContext is the same as BatchDeleteGeofence with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDeleteGeofence for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) BatchDeleteGeofenceWithContext(ctx aws.Context, input *BatchDeleteGeofenceInput, opts ...request.Option) (*BatchDeleteGeofenceOutput, error) {
	req, out := c.BatchDeleteGeofenceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchEvaluateGeofences = "BatchEvaluateGeofences"

// BatchEvaluateGeofencesRequest generates a "aws/request.Request" representing the
// client's request for the BatchEvaluateGeofences operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchEvaluateGeofences for more information on using the BatchEvaluateGeofences
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchEvaluateGeofencesRequest method.
//    req, resp := client.BatchEvaluateGeofencesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchEvaluateGeofences
func (c *LocationService) BatchEvaluateGeofencesRequest(input *BatchEvaluateGeofencesInput) (req *request.Request, output *BatchEvaluateGeofencesOutput) {
	op := &request.Operation{
		Name:       opBatchEvaluateGeofences,
		HTTPMethod: "POST",
		HTTPPath:   "/geofencing/v0/collections/{CollectionName}/positions",
	}

	if input == nil {
		input = &BatchEvaluateGeofencesInput{}
	}

	output = &BatchEvaluateGeofencesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("geofencing.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// BatchEvaluateGeofences API operation for Amazon Location Service.
//
// Used in geofence monitoring. Evaluates device positions against the position
// of geofences in a given geofence collection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation BatchEvaluateGeofences for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request has failed to process because of an unknown server error, exception,
//   or failure.
//
//   * ResourceNotFoundException
//   The resource that you've entered was not found in your AWS account.
//
//   * AccessDeniedException
//   The request was denied due to insufficient access or permission. Check with
//   an administrator to verify your permissions.
//
//   * ValidationException
//   The input failed to meet the constraints specified by the AWS service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchEvaluateGeofences
func (c *LocationService) BatchEvaluateGeofences(input *BatchEvaluateGeofencesInput) (*BatchEvaluateGeofencesOutput, error) {
	req, out := c.BatchEvaluateGeofencesRequest(input)
	return out, req.Send()
}

// BatchEvaluateGeofencesWithContext is the same as BatchEvaluateGeofences with the addition of
// the ability to pass a context and additional request options.
//
// See BatchEvaluateGeofences for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) BatchEvaluateGeofencesWithContext(ctx aws.Context, input *BatchEvaluateGeofencesInput, opts ...request.Option) (*BatchEvaluateGeofencesOutput, error) {
	req, out := c.BatchEvaluateGeofencesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetDevicePosition = "BatchGetDevicePosition"

// BatchGetDevicePositionRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetDevicePosition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetDevicePosition for more information on using the BatchGetDevicePosition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetDevicePositionRequest method.
//    req, resp := client.BatchGetDevicePositionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchGetDevicePosition
func (c *LocationService) BatchGetDevicePositionRequest(input *BatchGetDevicePositionInput) (req *request.Request, output *BatchGetDevicePositionOutput) {
	op := &request.Operation{
		Name:       opBatchGetDevicePosition,
		HTTPMethod: "POST",
		HTTPPath:   "/tracking/v0/trackers/{TrackerName}/get-positions",
	}

	if input == nil {
		input = &BatchGetDevicePositionInput{}
	}

	output = &BatchGetDevicePositionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("tracking.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// BatchGetDevicePosition API operation for Amazon Location Service.
//
// A batch request to retrieve device positions.
//
// The response will return the device positions from the last 24 hours.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation BatchGetDevicePosition for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request has failed to process because of an unknown server error, exception,
//   or failure.
//
//   * ResourceNotFoundException
//   The resource that you've entered was not found in your AWS account.
//
//   * AccessDeniedException
//   The request was denied due to insufficient access or permission. Check with
//   an administrator to verify your permissions.
//
//   * ValidationException
//   The input failed to meet the constraints specified by the AWS service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchGetDevicePosition
func (c *LocationService) BatchGetDevicePosition(input *BatchGetDevicePositionInput) (*BatchGetDevicePositionOutput, error) {
	req, out := c.BatchGetDevicePositionRequest(input)
	return out, req.Send()
}

// BatchGetDevicePositionWithContext is the same as BatchGetDevicePosition with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetDevicePosition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) BatchGetDevicePositionWithContext(ctx aws.Context, input *BatchGetDevicePositionInput, opts ...request.Option) (*BatchGetDevicePositionOutput, error) {
	req, out := c.BatchGetDevicePositionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchPutGeofence = "BatchPutGeofence"

// BatchPutGeofenceRequest generates a "aws/request.Request" representing the
// client's request for the BatchPutGeofence operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchPutGeofence for more information on using the BatchPutGeofence
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchPutGeofenceRequest method.
//    req, resp := client.BatchPutGeofenceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchPutGeofence
func (c *LocationService) BatchPutGeofenceRequest(input *BatchPutGeofenceInput) (req *request.Request, output *BatchPutGeofenceOutput) {
	op := &request.Operation{
		Name:       opBatchPutGeofence,
		HTTPMethod: "POST",
		HTTPPath:   "/geofencing/v0/collections/{CollectionName}/put-geofences",
	}

	if input == nil {
		input = &BatchPutGeofenceInput{}
	}

	output = &BatchPutGeofenceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("geofencing.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// BatchPutGeofence API operation for Amazon Location Service.
//
// A batch request for storing geofences into a given geofence collection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation BatchPutGeofence for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request has failed to process because of an unknown server error, exception,
//   or failure.
//
//   * ResourceNotFoundException
//   The resource that you've entered was not found in your AWS account.
//
//   * AccessDeniedException
//   The request was denied due to insufficient access or permission. Check with
//   an administrator to verify your permissions.
//
//   * ValidationException
//   The input failed to meet the constraints specified by the AWS service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchPutGeofence
func (c *LocationService) BatchPutGeofence(input *BatchPutGeofenceInput) (*BatchPutGeofenceOutput, error) {
	req, out := c.BatchPutGeofenceRequest(input)
	return out, req.Send()
}

// BatchPutGeofenceWithContext is the same as BatchPutGeofence with the addition of
// the ability to pass a context and additional request options.
//
// See BatchPutGeofence for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) BatchPutGeofenceWithContext(ctx aws.Context, input *BatchPutGeofenceInput, opts ...request.Option) (*BatchPutGeofenceOutput, error) {
	req, out := c.BatchPutGeofenceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchUpdateDevicePosition = "BatchUpdateDevicePosition"

// BatchUpdateDevicePositionRequest generates a "aws/request.Request" representing the
// client's request for the BatchUpdateDevicePosition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchUpdateDevicePosition for more information on using the BatchUpdateDevicePosition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchUpdateDevicePositionRequest method.
//    req, resp := client.BatchUpdateDevicePositionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchUpdateDevicePosition
func (c *LocationService) BatchUpdateDevicePositionRequest(input *BatchUpdateDevicePositionInput) (req *request.Request, output *BatchUpdateDevicePositionOutput) {
	op := &request.Operation{
		Name:       opBatchUpdateDevicePosition,
		HTTPMethod: "POST",
		HTTPPath:   "/tracking/v0/trackers/{TrackerName}/positions",
	}

	if input == nil {
		input = &BatchUpdateDevicePositionInput{}
	}

	output = &BatchUpdateDevicePositionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("tracking.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// BatchUpdateDevicePosition API operation for Amazon Location Service.
//
// Uploads a position update for one or more devices to a tracker resource.
// The data is used for API queries requesting the device position and position
// history.
//
// Limitation — Location data is sampled at a fixed rate of 1 position per
// 30 second interval, and retained for 1 year before it is deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation BatchUpdateDevicePosition for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request has failed to process because of an unknown server error, exception,
//   or failure.
//
//   * ResourceNotFoundException
//   The resource that you've entered was not found in your AWS account.
//
//   * AccessDeniedException
//   The request was denied due to insufficient access or permission. Check with
//   an administrator to verify your permissions.
//
//   * ValidationException
//   The input failed to meet the constraints specified by the AWS service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/BatchUpdateDevicePosition
func (c *LocationService) BatchUpdateDevicePosition(input *BatchUpdateDevicePositionInput) (*BatchUpdateDevicePositionOutput, error) {
	req, out := c.BatchUpdateDevicePositionRequest(input)
	return out, req.Send()
}

// BatchUpdateDevicePositionWithContext is the same as BatchUpdateDevicePosition with the addition of
// the ability to pass a context and additional request options.
//
// See BatchUpdateDevicePosition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) BatchUpdateDevicePositionWithContext(ctx aws.Context, input *BatchUpdateDevicePositionInput, opts ...request.Option) (*BatchUpdateDevicePositionOutput, error) {
	req, out := c.BatchUpdateDevicePositionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGeofenceCollection = "CreateGeofenceCollection"

// CreateGeofenceCollectionRequest generates a "aws/request.Request" representing the
// client's request for the CreateGeofenceCollection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGeofenceCollection for more information on using the CreateGeofenceCollection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateGeofenceCollectionRequest method.
//    req, resp := client.CreateGeofenceCollectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreateGeofenceCollection
func (c *LocationService) CreateGeofenceCollectionRequest(input *CreateGeofenceCollectionInput) (req *request.Request, output *CreateGeofenceCollectionOutput) {
	op := &request.Operation{
		Name:       opCreateGeofenceCollection,
		HTTPMethod: "POST",
		HTTPPath:   "/geofencing/v0/collections",
	}

	if input == nil {
		input = &CreateGeofenceCollectionInput{}
	}

	output = &CreateGeofenceCollectionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("geofencing.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateGeofenceCollection API operation for Amazon Location Service.
//
// Creates a geofence collection, which manages and stores geofences.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation CreateGeofenceCollection for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request has failed to process because of an unknown server error, exception,
//   or failure.
//
//   * ConflictException
//   The request was unsuccessful due to a conflict.
//
//   * AccessDeniedException
//   The request was denied due to insufficient access or permission. Check with
//   an administrator to verify your permissions.
//
//   * ValidationException
//   The input failed to meet the constraints specified by the AWS service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreateGeofenceCollection
func (c *LocationService) CreateGeofenceCollection(input *CreateGeofenceCollectionInput) (*CreateGeofenceCollectionOutput, error) {
	req, out := c.CreateGeofenceCollectionRequest(input)
	return out, req.Send()
}

// CreateGeofenceCollectionWithContext is the same as CreateGeofenceCollection with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGeofenceCollection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) CreateGeofenceCollectionWithContext(ctx aws.Context, input *CreateGeofenceCollectionInput, opts ...request.Option) (*CreateGeofenceCollectionOutput, error) {
	req, out := c.CreateGeofenceCollectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMap = "CreateMap"

// CreateMapRequest generates a "aws/request.Request" representing the
// client's request for the CreateMap operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMap for more information on using the CreateMap
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateMapRequest method.
//    req, resp := client.CreateMapRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreateMap
func (c *LocationService) CreateMapRequest(input *CreateMapInput) (req *request.Request, output *CreateMapOutput) {
	op := &request.Operation{
		Name:       opCreateMap,
		HTTPMethod: "POST",
		HTTPPath:   "/maps/v0/maps",
	}

	if input == nil {
		input = &CreateMapInput{}
	}

	output = &CreateMapOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("maps.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateMap API operation for Amazon Location Service.
//
// Creates a map resource in your AWS account, which provides map tiles of different
// styles sourced from global location data providers.
//
// By using Maps, you agree that AWS may transmit your API queries to your selected
// third party provider for processing, which may be outside the AWS region
// you are currently using. For more information, see the AWS Service Terms
// (https://aws.amazon.com/service-terms/) for Amazon Location Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation CreateMap for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request has failed to process because of an unknown server error, exception,
//   or failure.
//
//   * ConflictException
//   The request was unsuccessful due to a conflict.
//
//   * AccessDeniedException
//   The request was denied due to insufficient access or permission. Check with
//   an administrator to verify your permissions.
//
//   * ValidationException
//   The input failed to meet the constraints specified by the AWS service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreateMap
func (c *LocationService) CreateMap(input *CreateMapInput) (*CreateMapOutput, error) {
	req, out := c.CreateMapRequest(input)
	return out, req.Send()
}

// CreateMapWithContext is the same as CreateMap with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMap for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) CreateMapWithContext(ctx aws.Context, input *CreateMapInput, opts ...request.Option) (*CreateMapOutput, error) {
	req, out := c.CreateMapRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePlaceIndex = "CreatePlaceIndex"

// CreatePlaceIndexRequest generates a "aws/request.Request" representing the
// client's request for the CreatePlaceIndex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePlaceIndex for more information on using the CreatePlaceIndex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePlaceIndexRequest method.
//    req, resp := client.CreatePlaceIndexRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreatePlaceIndex
func (c *LocationService) CreatePlaceIndexRequest(input *CreatePlaceIndexInput) (req *request.Request, output *CreatePlaceIndexOutput) {
	op := &request.Operation{
		Name:       opCreatePlaceIndex,
		HTTPMethod: "POST",
		HTTPPath:   "/places/v0/indexes",
	}

	if input == nil {
		input = &CreatePlaceIndexInput{}
	}

	output = &CreatePlaceIndexOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("places.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreatePlaceIndex API operation for Amazon Location Service.
//
// Creates a Place index resource in your AWS account, which supports Places
// functions with geospatial data sourced from your chosen data provider.
//
// By using Places, you agree that AWS may transmit your API queries to your
// selected third party provider for processing, which may be outside the AWS
// region you are currently using.
//
// Because of licensing limitations, you may not use HERE to store results for
// locations in Japan. For more information, see the AWS Service Terms (https://aws.amazon.com/service-terms/)
// for Amazon Location Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation CreatePlaceIndex for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request has failed to process because of an unknown server error, exception,
//   or failure.
//
//   * ConflictException
//   The request was unsuccessful due to a conflict.
//
//   * AccessDeniedException
//   The request was denied due to insufficient access or permission. Check with
//   an administrator to verify your permissions.
//
//   * ValidationException
//   The input failed to meet the constraints specified by the AWS service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreatePlaceIndex
func (c *LocationService) CreatePlaceIndex(input *CreatePlaceIndexInput) (*CreatePlaceIndexOutput, error) {
	req, out := c.CreatePlaceIndexRequest(input)
	return out, req.Send()
}

// CreatePlaceIndexWithContext is the same as CreatePlaceIndex with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePlaceIndex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) CreatePlaceIndexWithContext(ctx aws.Context, input *CreatePlaceIndexInput, opts ...request.Option) (*CreatePlaceIndexOutput, error) {
	req, out := c.CreatePlaceIndexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTracker = "CreateTracker"

// CreateTrackerRequest generates a "aws/request.Request" representing the
// client's request for the CreateTracker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTracker for more information on using the CreateTracker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTrackerRequest method.
//    req, resp := client.CreateTrackerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreateTracker
func (c *LocationService) CreateTrackerRequest(input *CreateTrackerInput) (req *request.Request, output *CreateTrackerOutput) {
	op := &request.Operation{
		Name:       opCreateTracker,
		HTTPMethod: "POST",
		HTTPPath:   "/tracking/v0/trackers",
	}

	if input == nil {
		input = &CreateTrackerInput{}
	}

	output = &CreateTrackerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("tracking.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateTracker API operation for Amazon Location Service.
//
// Creates a tracker resource in your AWS account, which lets you retrieve current
// and historical location of devices.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation CreateTracker for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request has failed to process because of an unknown server error, exception,
//   or failure.
//
//   * ConflictException
//   The request was unsuccessful due to a conflict.
//
//   * AccessDeniedException
//   The request was denied due to insufficient access or permission. Check with
//   an administrator to verify your permissions.
//
//   * ValidationException
//   The input failed to meet the constraints specified by the AWS service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/CreateTracker
func (c *LocationService) CreateTracker(input *CreateTrackerInput) (*CreateTrackerOutput, error) {
	req, out := c.CreateTrackerRequest(input)
	return out, req.Send()
}

// CreateTrackerWithContext is the same as CreateTracker with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTracker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) CreateTrackerWithContext(ctx aws.Context, input *CreateTrackerInput, opts ...request.Option) (*CreateTrackerOutput, error) {
	req, out := c.CreateTrackerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGeofenceCollection = "DeleteGeofenceCollection"

// DeleteGeofenceCollectionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGeofenceCollection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGeofenceCollection for more information on using the DeleteGeofenceCollection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteGeofenceCollectionRequest method.
//    req, resp := client.DeleteGeofenceCollectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeleteGeofenceCollection
func (c *LocationService) DeleteGeofenceCollectionRequest(input *DeleteGeofenceCollectionInput) (req *request.Request, output *DeleteGeofenceCollectionOutput) {
	op := &request.Operation{
		Name:       opDeleteGeofenceCollection,
		HTTPMethod: "DELETE",
		HTTPPath:   "/geofencing/v0/collections/{CollectionName}",
	}

	if input == nil {
		input = &DeleteGeofenceCollectionInput{}
	}

	output = &DeleteGeofenceCollectionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("geofencing.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteGeofenceCollection API operation for Amazon Location Service.
//
// Deletes a geofence collection from your AWS account.
//
// This action deletes the resource permanently. You can't undo this action.
// If the geofence collection is the target of a tracker resource, the devices
// will no longer be monitored.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation DeleteGeofenceCollection for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request has failed to process because of an unknown server error, exception,
//   or failure.
//
//   * ResourceNotFoundException
//   The resource that you've entered was not found in your AWS account.
//
//   * AccessDeniedException
//   The request was denied due to insufficient access or permission. Check with
//   an administrator to verify your permissions.
//
//   * ValidationException
//   The input failed to meet the constraints specified by the AWS service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeleteGeofenceCollection
func (c *LocationService) DeleteGeofenceCollection(input *DeleteGeofenceCollectionInput) (*DeleteGeofenceCollectionOutput, error) {
	req, out := c.DeleteGeofenceCollectionRequest(input)
	return out, req.Send()
}

// DeleteGeofenceCollectionWithContext is the same as DeleteGeofenceCollection with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGeofenceCollection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) DeleteGeofenceCollectionWithContext(ctx aws.Context, input *DeleteGeofenceCollectionInput, opts ...request.Option) (*DeleteGeofenceCollectionOutput, error) {
	req, out := c.DeleteGeofenceCollectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMap = "DeleteMap"

// DeleteMapRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMap operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMap for more information on using the DeleteMap
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteMapRequest method.
//    req, resp := client.DeleteMapRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeleteMap
func (c *LocationService) DeleteMapRequest(input *DeleteMapInput) (req *request.Request, output *DeleteMapOutput) {
	op := &request.Operation{
		Name:       opDeleteMap,
		HTTPMethod: "DELETE",
		HTTPPath:   "/maps/v0/maps/{MapName}",
	}

	if input == nil {
		input = &DeleteMapInput{}
	}

	output = &DeleteMapOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("maps.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteMap API operation for Amazon Location Service.
//
// Deletes a map resource from your AWS account.
//
// This action deletes the resource permanently. You cannot undo this action.
// If the map is being used in an application, the map may not render.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation DeleteMap for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request has failed to process because of an unknown server error, exception,
//   or failure.
//
//   * ResourceNotFoundException
//   The resource that you've entered was not found in your AWS account.
//
//   * AccessDeniedException
//   The request was denied due to insufficient access or permission. Check with
//   an administrator to verify your permissions.
//
//   * ValidationException
//   The input failed to meet the constraints specified by the AWS service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeleteMap
func (c *LocationService) DeleteMap(input *DeleteMapInput) (*DeleteMapOutput, error) {
	req, out := c.DeleteMapRequest(input)
	return out, req.Send()
}

// DeleteMapWithContext is the same as DeleteMap with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMap for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) DeleteMapWithContext(ctx aws.Context, input *DeleteMapInput, opts ...request.Option) (*DeleteMapOutput, error) {
	req, out := c.DeleteMapRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePlaceIndex = "DeletePlaceIndex"

// DeletePlaceIndexRequest generates a "aws/request.Request" representing the
// client's request for the DeletePlaceIndex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePlaceIndex for more information on using the DeletePlaceIndex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePlaceIndexRequest method.
//    req, resp := client.DeletePlaceIndexRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeletePlaceIndex
func (c *LocationService) DeletePlaceIndexRequest(input *DeletePlaceIndexInput) (req *request.Request, output *DeletePlaceIndexOutput) {
	op := &request.Operation{
		Name:       opDeletePlaceIndex,
		HTTPMethod: "DELETE",
		HTTPPath:   "/places/v0/indexes/{IndexName}",
	}

	if input == nil {
		input = &DeletePlaceIndexInput{}
	}

	output = &DeletePlaceIndexOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("places.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeletePlaceIndex API operation for Amazon Location Service.
//
// Deletes a Place index resource from your AWS account.
//
// This action deletes the resource permanently. You cannot undo this action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation DeletePlaceIndex for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request has failed to process because of an unknown server error, exception,
//   or failure.
//
//   * ResourceNotFoundException
//   The resource that you've entered was not found in your AWS account.
//
//   * AccessDeniedException
//   The request was denied due to insufficient access or permission. Check with
//   an administrator to verify your permissions.
//
//   * ValidationException
//   The input failed to meet the constraints specified by the AWS service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeletePlaceIndex
func (c *LocationService) DeletePlaceIndex(input *DeletePlaceIndexInput) (*DeletePlaceIndexOutput, error) {
	req, out := c.DeletePlaceIndexRequest(input)
	return out, req.Send()
}

// DeletePlaceIndexWithContext is the same as DeletePlaceIndex with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePlaceIndex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) DeletePlaceIndexWithContext(ctx aws.Context, input *DeletePlaceIndexInput, opts ...request.Option) (*DeletePlaceIndexOutput, error) {
	req, out := c.DeletePlaceIndexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTracker = "DeleteTracker"

// DeleteTrackerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTracker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTracker for more information on using the DeleteTracker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTrackerRequest method.
//    req, resp := client.DeleteTrackerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeleteTracker
func (c *LocationService) DeleteTrackerRequest(input *DeleteTrackerInput) (req *request.Request, output *DeleteTrackerOutput) {
	op := &request.Operation{
		Name:       opDeleteTracker,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tracking/v0/trackers/{TrackerName}",
	}

	if input == nil {
		input = &DeleteTrackerInput{}
	}

	output = &DeleteTrackerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("tracking.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteTracker API operation for Amazon Location Service.
//
// Deletes a tracker resource from your AWS account.
//
// This action deletes the resource permanently. You can't undo this action.
// If the tracker resource is in use, you may encounter an error. Make sure
// that the target resource is not a dependency for your applications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation DeleteTracker for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request has failed to process because of an unknown server error, exception,
//   or failure.
//
//   * ResourceNotFoundException
//   The resource that you've entered was not found in your AWS account.
//
//   * AccessDeniedException
//   The request was denied due to insufficient access or permission. Check with
//   an administrator to verify your permissions.
//
//   * ValidationException
//   The input failed to meet the constraints specified by the AWS service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DeleteTracker
func (c *LocationService) DeleteTracker(input *DeleteTrackerInput) (*DeleteTrackerOutput, error) {
	req, out := c.DeleteTrackerRequest(input)
	return out, req.Send()
}

// DeleteTrackerWithContext is the same as DeleteTracker with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTracker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) DeleteTrackerWithContext(ctx aws.Context, input *DeleteTrackerInput, opts ...request.Option) (*DeleteTrackerOutput, error) {
	req, out := c.DeleteTrackerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeGeofenceCollection = "DescribeGeofenceCollection"

// DescribeGeofenceCollectionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGeofenceCollection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGeofenceCollection for more information on using the DescribeGeofenceCollection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeGeofenceCollectionRequest method.
//    req, resp := client.DescribeGeofenceCollectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribeGeofenceCollection
func (c *LocationService) DescribeGeofenceCollectionRequest(input *DescribeGeofenceCollectionInput) (req *request.Request, output *DescribeGeofenceCollectionOutput) {
	op := &request.Operation{
		Name:       opDescribeGeofenceCollection,
		HTTPMethod: "GET",
		HTTPPath:   "/geofencing/v0/collections/{CollectionName}",
	}

	if input == nil {
		input = &DescribeGeofenceCollectionInput{}
	}

	output = &DescribeGeofenceCollectionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("geofencing.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeGeofenceCollection API operation for Amazon Location Service.
//
// Retrieves the geofence collection details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation DescribeGeofenceCollection for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request has failed to process because of an unknown server error, exception,
//   or failure.
//
//   * ResourceNotFoundException
//   The resource that you've entered was not found in your AWS account.
//
//   * AccessDeniedException
//   The request was denied due to insufficient access or permission. Check with
//   an administrator to verify your permissions.
//
//   * ValidationException
//   The input failed to meet the constraints specified by the AWS service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribeGeofenceCollection
func (c *LocationService) DescribeGeofenceCollection(input *DescribeGeofenceCollectionInput) (*DescribeGeofenceCollectionOutput, error) {
	req, out := c.DescribeGeofenceCollectionRequest(input)
	return out, req.Send()
}

// DescribeGeofenceCollectionWithContext is the same as DescribeGeofenceCollection with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGeofenceCollection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) DescribeGeofenceCollectionWithContext(ctx aws.Context, input *DescribeGeofenceCollectionInput, opts ...request.Option) (*DescribeGeofenceCollectionOutput, error) {
	req, out := c.DescribeGeofenceCollectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeMap = "DescribeMap"

// DescribeMapRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMap operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMap for more information on using the DescribeMap
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeMapRequest method.
//    req, resp := client.DescribeMapRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribeMap
func (c *LocationService) DescribeMapRequest(input *DescribeMapInput) (req *request.Request, output *DescribeMapOutput) {
	op := &request.Operation{
		Name:       opDescribeMap,
		HTTPMethod: "GET",
		HTTPPath:   "/maps/v0/maps/{MapName}",
	}

	if input == nil {
		input = &DescribeMapInput{}
	}

	output = &DescribeMapOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("maps.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeMap API operation for Amazon Location Service.
//
// Retrieves the map resource details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation DescribeMap for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request has failed to process because of an unknown server error, exception,
//   or failure.
//
//   * ResourceNotFoundException
//   The resource that you've entered was not found in your AWS account.
//
//   * AccessDeniedException
//   The request was denied due to insufficient access or permission. Check with
//   an administrator to verify your permissions.
//
//   * ValidationException
//   The input failed to meet the constraints specified by the AWS service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribeMap
func (c *LocationService) DescribeMap(input *DescribeMapInput) (*DescribeMapOutput, error) {
	req, out := c.DescribeMapRequest(input)
	return out, req.Send()
}

// DescribeMapWithContext is the same as DescribeMap with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMap for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) DescribeMapWithContext(ctx aws.Context, input *DescribeMapInput, opts ...request.Option) (*DescribeMapOutput, error) {
	req, out := c.DescribeMapRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePlaceIndex = "DescribePlaceIndex"

// DescribePlaceIndexRequest generates a "aws/request.Request" representing the
// client's request for the DescribePlaceIndex operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePlaceIndex for more information on using the DescribePlaceIndex
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePlaceIndexRequest method.
//    req, resp := client.DescribePlaceIndexRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribePlaceIndex
func (c *LocationService) DescribePlaceIndexRequest(input *DescribePlaceIndexInput) (req *request.Request, output *DescribePlaceIndexOutput) {
	op := &request.Operation{
		Name:       opDescribePlaceIndex,
		HTTPMethod: "GET",
		HTTPPath:   "/places/v0/indexes/{IndexName}",
	}

	if input == nil {
		input = &DescribePlaceIndexInput{}
	}

	output = &DescribePlaceIndexOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("places.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribePlaceIndex API operation for Amazon Location Service.
//
// Retrieves the Place index resource details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation DescribePlaceIndex for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request has failed to process because of an unknown server error, exception,
//   or failure.
//
//   * ResourceNotFoundException
//   The resource that you've entered was not found in your AWS account.
//
//   * AccessDeniedException
//   The request was denied due to insufficient access or permission. Check with
//   an administrator to verify your permissions.
//
//   * ValidationException
//   The input failed to meet the constraints specified by the AWS service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribePlaceIndex
func (c *LocationService) DescribePlaceIndex(input *DescribePlaceIndexInput) (*DescribePlaceIndexOutput, error) {
	req, out := c.DescribePlaceIndexRequest(input)
	return out, req.Send()
}

// DescribePlaceIndexWithContext is the same as DescribePlaceIndex with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePlaceIndex for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) DescribePlaceIndexWithContext(ctx aws.Context, input *DescribePlaceIndexInput, opts ...request.Option) (*DescribePlaceIndexOutput, error) {
	req, out := c.DescribePlaceIndexRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTracker = "DescribeTracker"

// DescribeTrackerRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTracker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTracker for more information on using the DescribeTracker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTrackerRequest method.
//    req, resp := client.DescribeTrackerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribeTracker
func (c *LocationService) DescribeTrackerRequest(input *DescribeTrackerInput) (req *request.Request, output *DescribeTrackerOutput) {
	op := &request.Operation{
		Name:       opDescribeTracker,
		HTTPMethod: "GET",
		HTTPPath:   "/tracking/v0/trackers/{TrackerName}",
	}

	if input == nil {
		input = &DescribeTrackerInput{}
	}

	output = &DescribeTrackerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("tracking.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DescribeTracker API operation for Amazon Location Service.
//
// Retrieves the tracker resource details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation DescribeTracker for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request has failed to process because of an unknown server error, exception,
//   or failure.
//
//   * ResourceNotFoundException
//   The resource that you've entered was not found in your AWS account.
//
//   * AccessDeniedException
//   The request was denied due to insufficient access or permission. Check with
//   an administrator to verify your permissions.
//
//   * ValidationException
//   The input failed to meet the constraints specified by the AWS service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DescribeTracker
func (c *LocationService) DescribeTracker(input *DescribeTrackerInput) (*DescribeTrackerOutput, error) {
	req, out := c.DescribeTrackerRequest(input)
	return out, req.Send()
}

// DescribeTrackerWithContext is the same as DescribeTracker with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTracker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) DescribeTrackerWithContext(ctx aws.Context, input *DescribeTrackerInput, opts ...request.Option) (*DescribeTrackerOutput, error) {
	req, out := c.DescribeTrackerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateTrackerConsumer = "DisassociateTrackerConsumer"

// DisassociateTrackerConsumerRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateTrackerConsumer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateTrackerConsumer for more information on using the DisassociateTrackerConsumer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateTrackerConsumerRequest method.
//    req, resp := client.DisassociateTrackerConsumerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DisassociateTrackerConsumer
func (c *LocationService) DisassociateTrackerConsumerRequest(input *DisassociateTrackerConsumerInput) (req *request.Request, output *DisassociateTrackerConsumerOutput) {
	op := &request.Operation{
		Name:       opDisassociateTrackerConsumer,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tracking/v0/trackers/{TrackerName}/consumers/{ConsumerArn}",
	}

	if input == nil {
		input = &DisassociateTrackerConsumerInput{}
	}

	output = &DisassociateTrackerConsumerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("tracking.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DisassociateTrackerConsumer API operation for Amazon Location Service.
//
// Removes the association bewteen a tracker resource and a geofence collection.
//
// Once you unlink a tracker resource from a geofence collection, the tracker
// positions will no longer be automatically evaluated against geofences.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation DisassociateTrackerConsumer for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request has failed to process because of an unknown server error, exception,
//   or failure.
//
//   * ResourceNotFoundException
//   The resource that you've entered was not found in your AWS account.
//
//   * AccessDeniedException
//   The request was denied due to insufficient access or permission. Check with
//   an administrator to verify your permissions.
//
//   * ValidationException
//   The input failed to meet the constraints specified by the AWS service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/DisassociateTrackerConsumer
func (c *LocationService) DisassociateTrackerConsumer(input *DisassociateTrackerConsumerInput) (*DisassociateTrackerConsumerOutput, error) {
	req, out := c.DisassociateTrackerConsumerRequest(input)
	return out, req.Send()
}

// DisassociateTrackerConsumerWithContext is the same as DisassociateTrackerConsumer with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateTrackerConsumer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) DisassociateTrackerConsumerWithContext(ctx aws.Context, input *DisassociateTrackerConsumerInput, opts ...request.Option) (*DisassociateTrackerConsumerOutput, error) {
	req, out := c.DisassociateTrackerConsumerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDevicePosition = "GetDevicePosition"

// GetDevicePositionRequest generates a "aws/request.Request" representing the
// client's request for the GetDevicePosition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDevicePosition for more information on using the GetDevicePosition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDevicePositionRequest method.
//    req, resp := client.GetDevicePositionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetDevicePosition
func (c *LocationService) GetDevicePositionRequest(input *GetDevicePositionInput) (req *request.Request, output *GetDevicePositionOutput) {
	op := &request.Operation{
		Name:       opGetDevicePosition,
		HTTPMethod: "GET",
		HTTPPath:   "/tracking/v0/trackers/{TrackerName}/devices/{DeviceId}/positions/latest",
	}

	if input == nil {
		input = &GetDevicePositionInput{}
	}

	output = &GetDevicePositionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("tracking.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetDevicePosition API operation for Amazon Location Service.
//
// Retrieves the latest device position.
//
// Limitation — Device positions are deleted after one year.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation GetDevicePosition for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request has failed to process because of an unknown server error, exception,
//   or failure.
//
//   * ResourceNotFoundException
//   The resource that you've entered was not found in your AWS account.
//
//   * AccessDeniedException
//   The request was denied due to insufficient access or permission. Check with
//   an administrator to verify your permissions.
//
//   * ValidationException
//   The input failed to meet the constraints specified by the AWS service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetDevicePosition
func (c *LocationService) GetDevicePosition(input *GetDevicePositionInput) (*GetDevicePositionOutput, error) {
	req, out := c.GetDevicePositionRequest(input)
	return out, req.Send()
}

// GetDevicePositionWithContext is the same as GetDevicePosition with the addition of
// the ability to pass a context and additional request options.
//
// See GetDevicePosition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) GetDevicePositionWithContext(ctx aws.Context, input *GetDevicePositionInput, opts ...request.Option) (*GetDevicePositionOutput, error) {
	req, out := c.GetDevicePositionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDevicePositionHistory = "GetDevicePositionHistory"

// GetDevicePositionHistoryRequest generates a "aws/request.Request" representing the
// client's request for the GetDevicePositionHistory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDevicePositionHistory for more information on using the GetDevicePositionHistory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDevicePositionHistoryRequest method.
//    req, resp := client.GetDevicePositionHistoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetDevicePositionHistory
func (c *LocationService) GetDevicePositionHistoryRequest(input *GetDevicePositionHistoryInput) (req *request.Request, output *GetDevicePositionHistoryOutput) {
	op := &request.Operation{
		Name:       opGetDevicePositionHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/tracking/v0/trackers/{TrackerName}/devices/{DeviceId}/list-positions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetDevicePositionHistoryInput{}
	}

	output = &GetDevicePositionHistoryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("tracking.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetDevicePositionHistory API operation for Amazon Location Service.
//
// Retrieves the device position history from a tracker resource within a specified
// range of time.
//
// Limitation — Device positions are deleted after one year.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation GetDevicePositionHistory for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request has failed to process because of an unknown server error, exception,
//   or failure.
//
//   * ResourceNotFoundException
//   The resource that you've entered was not found in your AWS account.
//
//   * AccessDeniedException
//   The request was denied due to insufficient access or permission. Check with
//   an administrator to verify your permissions.
//
//   * ValidationException
//   The input failed to meet the constraints specified by the AWS service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetDevicePositionHistory
func (c *LocationService) GetDevicePositionHistory(input *GetDevicePositionHistoryInput) (*GetDevicePositionHistoryOutput, error) {
	req, out := c.GetDevicePositionHistoryRequest(input)
	return out, req.Send()
}

// GetDevicePositionHistoryWithContext is the same as GetDevicePositionHistory with the addition of
// the ability to pass a context and additional request options.
//
// See GetDevicePositionHistory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) GetDevicePositionHistoryWithContext(ctx aws.Context, input *GetDevicePositionHistoryInput, opts ...request.Option) (*GetDevicePositionHistoryOutput, error) {
	req, out := c.GetDevicePositionHistoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetDevicePositionHistoryPages iterates over the pages of a GetDevicePositionHistory operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetDevicePositionHistory method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetDevicePositionHistory operation.
//    pageNum := 0
//    err := client.GetDevicePositionHistoryPages(params,
//        func(page *locationservice.GetDevicePositionHistoryOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *LocationService) GetDevicePositionHistoryPages(input *GetDevicePositionHistoryInput, fn func(*GetDevicePositionHistoryOutput, bool) bool) error {
	return c.GetDevicePositionHistoryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetDevicePositionHistoryPagesWithContext same as GetDevicePositionHistoryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) GetDevicePositionHistoryPagesWithContext(ctx aws.Context, input *GetDevicePositionHistoryInput, fn func(*GetDevicePositionHistoryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetDevicePositionHistoryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetDevicePositionHistoryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetDevicePositionHistoryOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetGeofence = "GetGeofence"

// GetGeofenceRequest generates a "aws/request.Request" representing the
// client's request for the GetGeofence operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGeofence for more information on using the GetGeofence
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetGeofenceRequest method.
//    req, resp := client.GetGeofenceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetGeofence
func (c *LocationService) GetGeofenceRequest(input *GetGeofenceInput) (req *request.Request, output *GetGeofenceOutput) {
	op := &request.Operation{
		Name:       opGetGeofence,
		HTTPMethod: "GET",
		HTTPPath:   "/geofencing/v0/collections/{CollectionName}/geofences/{GeofenceId}",
	}

	if input == nil {
		input = &GetGeofenceInput{}
	}

	output = &GetGeofenceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("geofencing.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetGeofence API operation for Amazon Location Service.
//
// Retrieves the geofence details from a geofence collection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation GetGeofence for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request has failed to process because of an unknown server error, exception,
//   or failure.
//
//   * ResourceNotFoundException
//   The resource that you've entered was not found in your AWS account.
//
//   * AccessDeniedException
//   The request was denied due to insufficient access or permission. Check with
//   an administrator to verify your permissions.
//
//   * ValidationException
//   The input failed to meet the constraints specified by the AWS service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetGeofence
func (c *LocationService) GetGeofence(input *GetGeofenceInput) (*GetGeofenceOutput, error) {
	req, out := c.GetGeofenceRequest(input)
	return out, req.Send()
}

// GetGeofenceWithContext is the same as GetGeofence with the addition of
// the ability to pass a context and additional request options.
//
// See GetGeofence for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) GetGeofenceWithContext(ctx aws.Context, input *GetGeofenceInput, opts ...request.Option) (*GetGeofenceOutput, error) {
	req, out := c.GetGeofenceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMapGlyphs = "GetMapGlyphs"

// GetMapGlyphsRequest generates a "aws/request.Request" representing the
// client's request for the GetMapGlyphs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMapGlyphs for more information on using the GetMapGlyphs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMapGlyphsRequest method.
//    req, resp := client.GetMapGlyphsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetMapGlyphs
func (c *LocationService) GetMapGlyphsRequest(input *GetMapGlyphsInput) (req *request.Request, output *GetMapGlyphsOutput) {
	op := &request.Operation{
		Name:       opGetMapGlyphs,
		HTTPMethod: "GET",
		HTTPPath:   "/maps/v0/maps/{MapName}/glyphs/{FontStack}/{FontUnicodeRange}",
	}

	if input == nil {
		input = &GetMapGlyphsInput{}
	}

	output = &GetMapGlyphsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("maps.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetMapGlyphs API operation for Amazon Location Service.
//
// Retrieves glyphs used to display labels on a map.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation GetMapGlyphs for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request has failed to process because of an unknown server error, exception,
//   or failure.
//
//   * ResourceNotFoundException
//   The resource that you've entered was not found in your AWS account.
//
//   * AccessDeniedException
//   The request was denied due to insufficient access or permission. Check with
//   an administrator to verify your permissions.
//
//   * ValidationException
//   The input failed to meet the constraints specified by the AWS service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetMapGlyphs
func (c *LocationService) GetMapGlyphs(input *GetMapGlyphsInput) (*GetMapGlyphsOutput, error) {
	req, out := c.GetMapGlyphsRequest(input)
	return out, req.Send()
}

// GetMapGlyphsWithContext is the same as GetMapGlyphs with the addition of
// the ability to pass a context and additional request options.
//
// See GetMapGlyphs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) GetMapGlyphsWithContext(ctx aws.Context, input *GetMapGlyphsInput, opts ...request.Option) (*GetMapGlyphsOutput, error) {
	req, out := c.GetMapGlyphsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMapSprites = "GetMapSprites"

// GetMapSpritesRequest generates a "aws/request.Request" representing the
// client's request for the GetMapSprites operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMapSprites for more information on using the GetMapSprites
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMapSpritesRequest method.
//    req, resp := client.GetMapSpritesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetMapSprites
func (c *LocationService) GetMapSpritesRequest(input *GetMapSpritesInput) (req *request.Request, output *GetMapSpritesOutput) {
	op := &request.Operation{
		Name:       opGetMapSprites,
		HTTPMethod: "GET",
		HTTPPath:   "/maps/v0/maps/{MapName}/sprites/{FileName}",
	}

	if input == nil {
		input = &GetMapSpritesInput{}
	}

	output = &GetMapSpritesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("maps.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetMapSprites API operation for Amazon Location Service.
//
// Retrieves the sprite sheet corresponding to a map resource. The sprite sheet
// is a PNG image paired with a JSON document describing the offsets of individual
// icons that will be displayed on a rendered map.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation GetMapSprites for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request has failed to process because of an unknown server error, exception,
//   or failure.
//
//   * ResourceNotFoundException
//   The resource that you've entered was not found in your AWS account.
//
//   * AccessDeniedException
//   The request was denied due to insufficient access or permission. Check with
//   an administrator to verify your permissions.
//
//   * ValidationException
//   The input failed to meet the constraints specified by the AWS service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetMapSprites
func (c *LocationService) GetMapSprites(input *GetMapSpritesInput) (*GetMapSpritesOutput, error) {
	req, out := c.GetMapSpritesRequest(input)
	return out, req.Send()
}

// GetMapSpritesWithContext is the same as GetMapSprites with the addition of
// the ability to pass a context and additional request options.
//
// See GetMapSprites for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) GetMapSpritesWithContext(ctx aws.Context, input *GetMapSpritesInput, opts ...request.Option) (*GetMapSpritesOutput, error) {
	req, out := c.GetMapSpritesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMapStyleDescriptor = "GetMapStyleDescriptor"

// GetMapStyleDescriptorRequest generates a "aws/request.Request" representing the
// client's request for the GetMapStyleDescriptor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMapStyleDescriptor for more information on using the GetMapStyleDescriptor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMapStyleDescriptorRequest method.
//    req, resp := client.GetMapStyleDescriptorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetMapStyleDescriptor
func (c *LocationService) GetMapStyleDescriptorRequest(input *GetMapStyleDescriptorInput) (req *request.Request, output *GetMapStyleDescriptorOutput) {
	op := &request.Operation{
		Name:       opGetMapStyleDescriptor,
		HTTPMethod: "GET",
		HTTPPath:   "/maps/v0/maps/{MapName}/style-descriptor",
	}

	if input == nil {
		input = &GetMapStyleDescriptorInput{}
	}

	output = &GetMapStyleDescriptorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("maps.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetMapStyleDescriptor API operation for Amazon Location Service.
//
// Retrieves the map style descriptor from a map resource.
//
// The style descriptor contains speciﬁcations on how features render on a
// map. For example, what data to display, what order to display the data in,
// and the style for the data. Style descriptors follow the Mapbox Style Specification.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation GetMapStyleDescriptor for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request has failed to process because of an unknown server error, exception,
//   or failure.
//
//   * ResourceNotFoundException
//   The resource that you've entered was not found in your AWS account.
//
//   * AccessDeniedException
//   The request was denied due to insufficient access or permission. Check with
//   an administrator to verify your permissions.
//
//   * ValidationException
//   The input failed to meet the constraints specified by the AWS service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetMapStyleDescriptor
func (c *LocationService) GetMapStyleDescriptor(input *GetMapStyleDescriptorInput) (*GetMapStyleDescriptorOutput, error) {
	req, out := c.GetMapStyleDescriptorRequest(input)
	return out, req.Send()
}

// GetMapStyleDescriptorWithContext is the same as GetMapStyleDescriptor with the addition of
// the ability to pass a context and additional request options.
//
// See GetMapStyleDescriptor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) GetMapStyleDescriptorWithContext(ctx aws.Context, input *GetMapStyleDescriptorInput, opts ...request.Option) (*GetMapStyleDescriptorOutput, error) {
	req, out := c.GetMapStyleDescriptorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMapTile = "GetMapTile"

// GetMapTileRequest generates a "aws/request.Request" representing the
// client's request for the GetMapTile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMapTile for more information on using the GetMapTile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMapTileRequest method.
//    req, resp := client.GetMapTileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetMapTile
func (c *LocationService) GetMapTileRequest(input *GetMapTileInput) (req *request.Request, output *GetMapTileOutput) {
	op := &request.Operation{
		Name:       opGetMapTile,
		HTTPMethod: "GET",
		HTTPPath:   "/maps/v0/maps/{MapName}/tiles/{Z}/{X}/{Y}",
	}

	if input == nil {
		input = &GetMapTileInput{}
	}

	output = &GetMapTileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("maps.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetMapTile API operation for Amazon Location Service.
//
// Retrieves a vector data tile from the map resource. Map tiles are used by
// clients to render a map. They are addressed using a grid arrangement with
// an X coordinate, Y coordinate, and Z (zoom) level.
//
// The origin (0, 0) is the top left of the map. Increasing the zoom level by
// 1 doubles both the X and Y dimensions, so a tile containing data for the
// entire world at (0/0/0) will be split into 4 tiles at zoom 1 (1/0/0, 1/0/1,
// 1/1/0, 1/1/1).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation GetMapTile for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request has failed to process because of an unknown server error, exception,
//   or failure.
//
//   * ResourceNotFoundException
//   The resource that you've entered was not found in your AWS account.
//
//   * AccessDeniedException
//   The request was denied due to insufficient access or permission. Check with
//   an administrator to verify your permissions.
//
//   * ValidationException
//   The input failed to meet the constraints specified by the AWS service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/GetMapTile
func (c *LocationService) GetMapTile(input *GetMapTileInput) (*GetMapTileOutput, error) {
	req, out := c.GetMapTileRequest(input)
	return out, req.Send()
}

// GetMapTileWithContext is the same as GetMapTile with the addition of
// the ability to pass a context and additional request options.
//
// See GetMapTile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) GetMapTileWithContext(ctx aws.Context, input *GetMapTileInput, opts ...request.Option) (*GetMapTileOutput, error) {
	req, out := c.GetMapTileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListGeofenceCollections = "ListGeofenceCollections"

// ListGeofenceCollectionsRequest generates a "aws/request.Request" representing the
// client's request for the ListGeofenceCollections operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGeofenceCollections for more information on using the ListGeofenceCollections
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListGeofenceCollectionsRequest method.
//    req, resp := client.ListGeofenceCollectionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListGeofenceCollections
func (c *LocationService) ListGeofenceCollectionsRequest(input *ListGeofenceCollectionsInput) (req *request.Request, output *ListGeofenceCollectionsOutput) {
	op := &request.Operation{
		Name:       opListGeofenceCollections,
		HTTPMethod: "POST",
		HTTPPath:   "/geofencing/v0/list-collections",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGeofenceCollectionsInput{}
	}

	output = &ListGeofenceCollectionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("geofencing.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListGeofenceCollections API operation for Amazon Location Service.
//
// Lists geofence collections in your AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation ListGeofenceCollections for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request has failed to process because of an unknown server error, exception,
//   or failure.
//
//   * AccessDeniedException
//   The request was denied due to insufficient access or permission. Check with
//   an administrator to verify your permissions.
//
//   * ValidationException
//   The input failed to meet the constraints specified by the AWS service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListGeofenceCollections
func (c *LocationService) ListGeofenceCollections(input *ListGeofenceCollectionsInput) (*ListGeofenceCollectionsOutput, error) {
	req, out := c.ListGeofenceCollectionsRequest(input)
	return out, req.Send()
}

// ListGeofenceCollectionsWithContext is the same as ListGeofenceCollections with the addition of
// the ability to pass a context and additional request options.
//
// See ListGeofenceCollections for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) ListGeofenceCollectionsWithContext(ctx aws.Context, input *ListGeofenceCollectionsInput, opts ...request.Option) (*ListGeofenceCollectionsOutput, error) {
	req, out := c.ListGeofenceCollectionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListGeofenceCollectionsPages iterates over the pages of a ListGeofenceCollections operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGeofenceCollections method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListGeofenceCollections operation.
//    pageNum := 0
//    err := client.ListGeofenceCollectionsPages(params,
//        func(page *locationservice.ListGeofenceCollectionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *LocationService) ListGeofenceCollectionsPages(input *ListGeofenceCollectionsInput, fn func(*ListGeofenceCollectionsOutput, bool) bool) error {
	return c.ListGeofenceCollectionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListGeofenceCollectionsPagesWithContext same as ListGeofenceCollectionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) ListGeofenceCollectionsPagesWithContext(ctx aws.Context, input *ListGeofenceCollectionsInput, fn func(*ListGeofenceCollectionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListGeofenceCollectionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListGeofenceCollectionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListGeofenceCollectionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListGeofences = "ListGeofences"

// ListGeofencesRequest generates a "aws/request.Request" representing the
// client's request for the ListGeofences operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGeofences for more information on using the ListGeofences
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListGeofencesRequest method.
//    req, resp := client.ListGeofencesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListGeofences
func (c *LocationService) ListGeofencesRequest(input *ListGeofencesInput) (req *request.Request, output *ListGeofencesOutput) {
	op := &request.Operation{
		Name:       opListGeofences,
		HTTPMethod: "POST",
		HTTPPath:   "/geofencing/v0/collections/{CollectionName}/list-geofences",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGeofencesInput{}
	}

	output = &ListGeofencesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("geofencing.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListGeofences API operation for Amazon Location Service.
//
// Lists geofences stored in a given geofence collection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation ListGeofences for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request has failed to process because of an unknown server error, exception,
//   or failure.
//
//   * ResourceNotFoundException
//   The resource that you've entered was not found in your AWS account.
//
//   * AccessDeniedException
//   The request was denied due to insufficient access or permission. Check with
//   an administrator to verify your permissions.
//
//   * ValidationException
//   The input failed to meet the constraints specified by the AWS service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListGeofences
func (c *LocationService) ListGeofences(input *ListGeofencesInput) (*ListGeofencesOutput, error) {
	req, out := c.ListGeofencesRequest(input)
	return out, req.Send()
}

// ListGeofencesWithContext is the same as ListGeofences with the addition of
// the ability to pass a context and additional request options.
//
// See ListGeofences for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) ListGeofencesWithContext(ctx aws.Context, input *ListGeofencesInput, opts ...request.Option) (*ListGeofencesOutput, error) {
	req, out := c.ListGeofencesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListGeofencesPages iterates over the pages of a ListGeofences operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGeofences method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListGeofences operation.
//    pageNum := 0
//    err := client.ListGeofencesPages(params,
//        func(page *locationservice.ListGeofencesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *LocationService) ListGeofencesPages(input *ListGeofencesInput, fn func(*ListGeofencesOutput, bool) bool) error {
	return c.ListGeofencesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListGeofencesPagesWithContext same as ListGeofencesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) ListGeofencesPagesWithContext(ctx aws.Context, input *ListGeofencesInput, fn func(*ListGeofencesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListGeofencesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListGeofencesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListGeofencesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMaps = "ListMaps"

// ListMapsRequest generates a "aws/request.Request" representing the
// client's request for the ListMaps operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMaps for more information on using the ListMaps
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListMapsRequest method.
//    req, resp := client.ListMapsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListMaps
func (c *LocationService) ListMapsRequest(input *ListMapsInput) (req *request.Request, output *ListMapsOutput) {
	op := &request.Operation{
		Name:       opListMaps,
		HTTPMethod: "POST",
		HTTPPath:   "/maps/v0/list-maps",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMapsInput{}
	}

	output = &ListMapsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("maps.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListMaps API operation for Amazon Location Service.
//
// Lists map resources in your AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation ListMaps for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request has failed to process because of an unknown server error, exception,
//   or failure.
//
//   * AccessDeniedException
//   The request was denied due to insufficient access or permission. Check with
//   an administrator to verify your permissions.
//
//   * ValidationException
//   The input failed to meet the constraints specified by the AWS service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListMaps
func (c *LocationService) ListMaps(input *ListMapsInput) (*ListMapsOutput, error) {
	req, out := c.ListMapsRequest(input)
	return out, req.Send()
}

// ListMapsWithContext is the same as ListMaps with the addition of
// the ability to pass a context and additional request options.
//
// See ListMaps for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) ListMapsWithContext(ctx aws.Context, input *ListMapsInput, opts ...request.Option) (*ListMapsOutput, error) {
	req, out := c.ListMapsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMapsPages iterates over the pages of a ListMaps operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMaps method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMaps operation.
//    pageNum := 0
//    err := client.ListMapsPages(params,
//        func(page *locationservice.ListMapsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *LocationService) ListMapsPages(input *ListMapsInput, fn func(*ListMapsOutput, bool) bool) error {
	return c.ListMapsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMapsPagesWithContext same as ListMapsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) ListMapsPagesWithContext(ctx aws.Context, input *ListMapsInput, fn func(*ListMapsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMapsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMapsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMapsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPlaceIndexes = "ListPlaceIndexes"

// ListPlaceIndexesRequest generates a "aws/request.Request" representing the
// client's request for the ListPlaceIndexes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPlaceIndexes for more information on using the ListPlaceIndexes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPlaceIndexesRequest method.
//    req, resp := client.ListPlaceIndexesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListPlaceIndexes
func (c *LocationService) ListPlaceIndexesRequest(input *ListPlaceIndexesInput) (req *request.Request, output *ListPlaceIndexesOutput) {
	op := &request.Operation{
		Name:       opListPlaceIndexes,
		HTTPMethod: "POST",
		HTTPPath:   "/places/v0/list-indexes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPlaceIndexesInput{}
	}

	output = &ListPlaceIndexesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("places.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListPlaceIndexes API operation for Amazon Location Service.
//
// Lists Place index resources in your AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation ListPlaceIndexes for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request has failed to process because of an unknown server error, exception,
//   or failure.
//
//   * AccessDeniedException
//   The request was denied due to insufficient access or permission. Check with
//   an administrator to verify your permissions.
//
//   * ValidationException
//   The input failed to meet the constraints specified by the AWS service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListPlaceIndexes
func (c *LocationService) ListPlaceIndexes(input *ListPlaceIndexesInput) (*ListPlaceIndexesOutput, error) {
	req, out := c.ListPlaceIndexesRequest(input)
	return out, req.Send()
}

// ListPlaceIndexesWithContext is the same as ListPlaceIndexes with the addition of
// the ability to pass a context and additional request options.
//
// See ListPlaceIndexes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) ListPlaceIndexesWithContext(ctx aws.Context, input *ListPlaceIndexesInput, opts ...request.Option) (*ListPlaceIndexesOutput, error) {
	req, out := c.ListPlaceIndexesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPlaceIndexesPages iterates over the pages of a ListPlaceIndexes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPlaceIndexes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPlaceIndexes operation.
//    pageNum := 0
//    err := client.ListPlaceIndexesPages(params,
//        func(page *locationservice.ListPlaceIndexesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *LocationService) ListPlaceIndexesPages(input *ListPlaceIndexesInput, fn func(*ListPlaceIndexesOutput, bool) bool) error {
	return c.ListPlaceIndexesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPlaceIndexesPagesWithContext same as ListPlaceIndexesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) ListPlaceIndexesPagesWithContext(ctx aws.Context, input *ListPlaceIndexesInput, fn func(*ListPlaceIndexesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPlaceIndexesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPlaceIndexesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPlaceIndexesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTrackerConsumers = "ListTrackerConsumers"

// ListTrackerConsumersRequest generates a "aws/request.Request" representing the
// client's request for the ListTrackerConsumers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTrackerConsumers for more information on using the ListTrackerConsumers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTrackerConsumersRequest method.
//    req, resp := client.ListTrackerConsumersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListTrackerConsumers
func (c *LocationService) ListTrackerConsumersRequest(input *ListTrackerConsumersInput) (req *request.Request, output *ListTrackerConsumersOutput) {
	op := &request.Operation{
		Name:       opListTrackerConsumers,
		HTTPMethod: "POST",
		HTTPPath:   "/tracking/v0/trackers/{TrackerName}/list-consumers",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTrackerConsumersInput{}
	}

	output = &ListTrackerConsumersOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("tracking.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListTrackerConsumers API operation for Amazon Location Service.
//
// Lists geofence collections currently associated to the given tracker resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation ListTrackerConsumers for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request has failed to process because of an unknown server error, exception,
//   or failure.
//
//   * ResourceNotFoundException
//   The resource that you've entered was not found in your AWS account.
//
//   * AccessDeniedException
//   The request was denied due to insufficient access or permission. Check with
//   an administrator to verify your permissions.
//
//   * ValidationException
//   The input failed to meet the constraints specified by the AWS service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListTrackerConsumers
func (c *LocationService) ListTrackerConsumers(input *ListTrackerConsumersInput) (*ListTrackerConsumersOutput, error) {
	req, out := c.ListTrackerConsumersRequest(input)
	return out, req.Send()
}

// ListTrackerConsumersWithContext is the same as ListTrackerConsumers with the addition of
// the ability to pass a context and additional request options.
//
// See ListTrackerConsumers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) ListTrackerConsumersWithContext(ctx aws.Context, input *ListTrackerConsumersInput, opts ...request.Option) (*ListTrackerConsumersOutput, error) {
	req, out := c.ListTrackerConsumersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTrackerConsumersPages iterates over the pages of a ListTrackerConsumers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTrackerConsumers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTrackerConsumers operation.
//    pageNum := 0
//    err := client.ListTrackerConsumersPages(params,
//        func(page *locationservice.ListTrackerConsumersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *LocationService) ListTrackerConsumersPages(input *ListTrackerConsumersInput, fn func(*ListTrackerConsumersOutput, bool) bool) error {
	return c.ListTrackerConsumersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTrackerConsumersPagesWithContext same as ListTrackerConsumersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) ListTrackerConsumersPagesWithContext(ctx aws.Context, input *ListTrackerConsumersInput, fn func(*ListTrackerConsumersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTrackerConsumersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTrackerConsumersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTrackerConsumersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTrackers = "ListTrackers"

// ListTrackersRequest generates a "aws/request.Request" representing the
// client's request for the ListTrackers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTrackers for more information on using the ListTrackers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTrackersRequest method.
//    req, resp := client.ListTrackersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListTrackers
func (c *LocationService) ListTrackersRequest(input *ListTrackersInput) (req *request.Request, output *ListTrackersOutput) {
	op := &request.Operation{
		Name:       opListTrackers,
		HTTPMethod: "POST",
		HTTPPath:   "/tracking/v0/list-trackers",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTrackersInput{}
	}

	output = &ListTrackersOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("tracking.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListTrackers API operation for Amazon Location Service.
//
// Lists tracker resources in your AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation ListTrackers for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request has failed to process because of an unknown server error, exception,
//   or failure.
//
//   * AccessDeniedException
//   The request was denied due to insufficient access or permission. Check with
//   an administrator to verify your permissions.
//
//   * ValidationException
//   The input failed to meet the constraints specified by the AWS service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/ListTrackers
func (c *LocationService) ListTrackers(input *ListTrackersInput) (*ListTrackersOutput, error) {
	req, out := c.ListTrackersRequest(input)
	return out, req.Send()
}

// ListTrackersWithContext is the same as ListTrackers with the addition of
// the ability to pass a context and additional request options.
//
// See ListTrackers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) ListTrackersWithContext(ctx aws.Context, input *ListTrackersInput, opts ...request.Option) (*ListTrackersOutput, error) {
	req, out := c.ListTrackersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTrackersPages iterates over the pages of a ListTrackers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTrackers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTrackers operation.
//    pageNum := 0
//    err := client.ListTrackersPages(params,
//        func(page *locationservice.ListTrackersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *LocationService) ListTrackersPages(input *ListTrackersInput, fn func(*ListTrackersOutput, bool) bool) error {
	return c.ListTrackersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTrackersPagesWithContext same as ListTrackersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) ListTrackersPagesWithContext(ctx aws.Context, input *ListTrackersInput, fn func(*ListTrackersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTrackersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTrackersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTrackersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutGeofence = "PutGeofence"

// PutGeofenceRequest generates a "aws/request.Request" representing the
// client's request for the PutGeofence operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutGeofence for more information on using the PutGeofence
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutGeofenceRequest method.
//    req, resp := client.PutGeofenceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/PutGeofence
func (c *LocationService) PutGeofenceRequest(input *PutGeofenceInput) (req *request.Request, output *PutGeofenceOutput) {
	op := &request.Operation{
		Name:       opPutGeofence,
		HTTPMethod: "PUT",
		HTTPPath:   "/geofencing/v0/collections/{CollectionName}/geofences/{GeofenceId}",
	}

	if input == nil {
		input = &PutGeofenceInput{}
	}

	output = &PutGeofenceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("geofencing.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// PutGeofence API operation for Amazon Location Service.
//
// Stores a geofence to a given geofence collection, or updates the geometry
// of an existing geofence if a geofence ID is included in the request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation PutGeofence for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request has failed to process because of an unknown server error, exception,
//   or failure.
//
//   * ResourceNotFoundException
//   The resource that you've entered was not found in your AWS account.
//
//   * ConflictException
//   The request was unsuccessful due to a conflict.
//
//   * AccessDeniedException
//   The request was denied due to insufficient access or permission. Check with
//   an administrator to verify your permissions.
//
//   * ValidationException
//   The input failed to meet the constraints specified by the AWS service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/PutGeofence
func (c *LocationService) PutGeofence(input *PutGeofenceInput) (*PutGeofenceOutput, error) {
	req, out := c.PutGeofenceRequest(input)
	return out, req.Send()
}

// PutGeofenceWithContext is the same as PutGeofence with the addition of
// the ability to pass a context and additional request options.
//
// See PutGeofence for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) PutGeofenceWithContext(ctx aws.Context, input *PutGeofenceInput, opts ...request.Option) (*PutGeofenceOutput, error) {
	req, out := c.PutGeofenceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchPlaceIndexForPosition = "SearchPlaceIndexForPosition"

// SearchPlaceIndexForPositionRequest generates a "aws/request.Request" representing the
// client's request for the SearchPlaceIndexForPosition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchPlaceIndexForPosition for more information on using the SearchPlaceIndexForPosition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchPlaceIndexForPositionRequest method.
//    req, resp := client.SearchPlaceIndexForPositionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/SearchPlaceIndexForPosition
func (c *LocationService) SearchPlaceIndexForPositionRequest(input *SearchPlaceIndexForPositionInput) (req *request.Request, output *SearchPlaceIndexForPositionOutput) {
	op := &request.Operation{
		Name:       opSearchPlaceIndexForPosition,
		HTTPMethod: "POST",
		HTTPPath:   "/places/v0/indexes/{IndexName}/search/position",
	}

	if input == nil {
		input = &SearchPlaceIndexForPositionInput{}
	}

	output = &SearchPlaceIndexForPositionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("places.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// SearchPlaceIndexForPosition API operation for Amazon Location Service.
//
// Reverse geocodes a given coordinate and returns a legible address. Allows
// you to search for Places or points of interest near a given position.
//
// By using Places, you agree that AWS may transmit your API queries to your
// selected third party provider for processing, which may be outside the AWS
// region you are currently using.
//
// Because of licensing limitations, you may not use HERE to store results for
// locations in Japan. For more information, see the AWS Service Terms (https://aws.amazon.com/service-terms/)
// for Amazon Location Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation SearchPlaceIndexForPosition for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request has failed to process because of an unknown server error, exception,
//   or failure.
//
//   * ResourceNotFoundException
//   The resource that you've entered was not found in your AWS account.
//
//   * AccessDeniedException
//   The request was denied due to insufficient access or permission. Check with
//   an administrator to verify your permissions.
//
//   * ValidationException
//   The input failed to meet the constraints specified by the AWS service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/SearchPlaceIndexForPosition
func (c *LocationService) SearchPlaceIndexForPosition(input *SearchPlaceIndexForPositionInput) (*SearchPlaceIndexForPositionOutput, error) {
	req, out := c.SearchPlaceIndexForPositionRequest(input)
	return out, req.Send()
}

// SearchPlaceIndexForPositionWithContext is the same as SearchPlaceIndexForPosition with the addition of
// the ability to pass a context and additional request options.
//
// See SearchPlaceIndexForPosition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) SearchPlaceIndexForPositionWithContext(ctx aws.Context, input *SearchPlaceIndexForPositionInput, opts ...request.Option) (*SearchPlaceIndexForPositionOutput, error) {
	req, out := c.SearchPlaceIndexForPositionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchPlaceIndexForText = "SearchPlaceIndexForText"

// SearchPlaceIndexForTextRequest generates a "aws/request.Request" representing the
// client's request for the SearchPlaceIndexForText operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchPlaceIndexForText for more information on using the SearchPlaceIndexForText
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchPlaceIndexForTextRequest method.
//    req, resp := client.SearchPlaceIndexForTextRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/SearchPlaceIndexForText
func (c *LocationService) SearchPlaceIndexForTextRequest(input *SearchPlaceIndexForTextInput) (req *request.Request, output *SearchPlaceIndexForTextOutput) {
	op := &request.Operation{
		Name:       opSearchPlaceIndexForText,
		HTTPMethod: "POST",
		HTTPPath:   "/places/v0/indexes/{IndexName}/search/text",
	}

	if input == nil {
		input = &SearchPlaceIndexForTextInput{}
	}

	output = &SearchPlaceIndexForTextOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("places.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// SearchPlaceIndexForText API operation for Amazon Location Service.
//
// Geocodes free-form text, such as an address, name, city, or region to allow
// you to search for Places or points of interest.
//
// Includes the option to apply additional parameters to narrow your list of
// results.
//
// You can search for places near a given position using BiasPosition, or filter
// results within a bounding box using FilterBBox. Providing both parameters
// simultaneously returns an error.
//
// By using Places, you agree that AWS may transmit your API queries to your
// selected third party provider for processing, which may be outside the AWS
// region you are currently using.
//
// Also, when using HERE as your data provider, you may not (a) use HERE Places
// for Asset Management, or (b) select the Storage option for the IntendedUse
// parameter when requesting Places in Japan. For more information, see the
// AWS Service Terms (https://aws.amazon.com/service-terms/) for Amazon Location
// Service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Location Service's
// API operation SearchPlaceIndexForText for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   The request has failed to process because of an unknown server error, exception,
//   or failure.
//
//   * ResourceNotFoundException
//   The resource that you've entered was not found in your AWS account.
//
//   * AccessDeniedException
//   The request was denied due to insufficient access or permission. Check with
//   an administrator to verify your permissions.
//
//   * ValidationException
//   The input failed to meet the constraints specified by the AWS service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/location-2020-11-19/SearchPlaceIndexForText
func (c *LocationService) SearchPlaceIndexForText(input *SearchPlaceIndexForTextInput) (*SearchPlaceIndexForTextOutput, error) {
	req, out := c.SearchPlaceIndexForTextRequest(input)
	return out, req.Send()
}

// SearchPlaceIndexForTextWithContext is the same as SearchPlaceIndexForText with the addition of
// the ability to pass a context and additional request options.
//
// See SearchPlaceIndexForText for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *LocationService) SearchPlaceIndexForTextWithContext(ctx aws.Context, input *SearchPlaceIndexForTextInput, opts ...request.Option) (*SearchPlaceIndexForTextOutput, error) {
	req, out := c.SearchPlaceIndexForTextRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The request was denied due to insufficient access or permission. Check with
// an administrator to verify your permissions.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type AssociateTrackerConsumerInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the geofence collection to be associated
	// to tracker resource. Used when you need to specify a resource across all
	// AWS.
	//
	//    * Format example: arn:partition:service:region:account-id:resource-type:resource-id
	//
	// ConsumerArn is a required field
	ConsumerArn *string `type:"string" required:"true"`

	// The name of the tracker resource to be associated with a geofence collection.
	//
	// TrackerName is a required field
	TrackerName *string `location:"uri" locationName:"TrackerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateTrackerConsumerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateTrackerConsumerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateTrackerConsumerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateTrackerConsumerInput"}
	if s.ConsumerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ConsumerArn"))
	}
	if s.TrackerName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrackerName"))
	}
	if s.TrackerName != nil && len(*s.TrackerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrackerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConsumerArn sets the ConsumerArn field's value.
func (s *AssociateTrackerConsumerInput) SetConsumerArn(v string) *AssociateTrackerConsumerInput {
	s.ConsumerArn = &v
	return s
}

// SetTrackerName sets the TrackerName field's value.
func (s *AssociateTrackerConsumerInput) SetTrackerName(v string) *AssociateTrackerConsumerInput {
	s.TrackerName = &v
	return s
}

type AssociateTrackerConsumerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateTrackerConsumerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateTrackerConsumerOutput) GoString() string {
	return s.String()
}

// Contains error details for each geofence that failed to delete from the geofence
// collection.
type BatchDeleteGeofenceError struct {
	_ struct{} `type:"structure"`

	// Contains details associated to the batch error.
	//
	// Error is a required field
	Error *BatchItemError `type:"structure" required:"true"`

	// The geofence associated with the error message.
	//
	// GeofenceId is a required field
	GeofenceId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s BatchDeleteGeofenceError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDeleteGeofenceError) GoString() string {
	return s.String()
}

// SetError sets the Error field's value.
func (s *BatchDeleteGeofenceError) SetError(v *BatchItemError) *BatchDeleteGeofenceError {
	s.Error = v
	return s
}

// SetGeofenceId sets the GeofenceId field's value.
func (s *BatchDeleteGeofenceError) SetGeofenceId(v string) *BatchDeleteGeofenceError {
	s.GeofenceId = &v
	return s
}

type BatchDeleteGeofenceInput struct {
	_ struct{} `type:"structure"`

	// The geofence collection storing the geofences to be deleted.
	//
	// CollectionName is a required field
	CollectionName *string `location:"uri" locationName:"CollectionName" min:"1" type:"string" required:"true"`

	// The batch of geofences to be deleted.
	//
	// GeofenceIds is a required field
	GeofenceIds []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDeleteGeofenceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDeleteGeofenceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDeleteGeofenceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDeleteGeofenceInput"}
	if s.CollectionName == nil {
		invalidParams.Add(request.NewErrParamRequired("CollectionName"))
	}
	if s.CollectionName != nil && len(*s.CollectionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CollectionName", 1))
	}
	if s.GeofenceIds == nil {
		invalidParams.Add(request.NewErrParamRequired("GeofenceIds"))
	}
	if s.GeofenceIds != nil && len(s.GeofenceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GeofenceIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollectionName sets the CollectionName field's value.
func (s *BatchDeleteGeofenceInput) SetCollectionName(v string) *BatchDeleteGeofenceInput {
	s.CollectionName = &v
	return s
}

// SetGeofenceIds sets the GeofenceIds field's value.
func (s *BatchDeleteGeofenceInput) SetGeofenceIds(v []*string) *BatchDeleteGeofenceInput {
	s.GeofenceIds = v
	return s
}

type BatchDeleteGeofenceOutput struct {
	_ struct{} `type:"structure"`

	// Contains error details for each geofence that failed to delete.
	//
	// Errors is a required field
	Errors []*BatchDeleteGeofenceError `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDeleteGeofenceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDeleteGeofenceOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchDeleteGeofenceOutput) SetErrors(v []*BatchDeleteGeofenceError) *BatchDeleteGeofenceOutput {
	s.Errors = v
	return s
}

// Contains error details for each device that failed to evaluate its position
// against the geofences in a given geofence collection.
type BatchEvaluateGeofencesError struct {
	_ struct{} `type:"structure"`

	// The device associated with the position evaluation error.
	//
	// DeviceId is a required field
	DeviceId *string `min:"1" type:"string" required:"true"`

	// Contains details associated to the batch error.
	//
	// Error is a required field
	Error *BatchItemError `type:"structure" required:"true"`

	// Specifies a timestamp for when the error occurred in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ
	//
	// SampleTime is a required field
	SampleTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s BatchEvaluateGeofencesError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchEvaluateGeofencesError) GoString() string {
	return s.String()
}

// SetDeviceId sets the DeviceId field's value.
func (s *BatchEvaluateGeofencesError) SetDeviceId(v string) *BatchEvaluateGeofencesError {
	s.DeviceId = &v
	return s
}

// SetError sets the Error field's value.
func (s *BatchEvaluateGeofencesError) SetError(v *BatchItemError) *BatchEvaluateGeofencesError {
	s.Error = v
	return s
}

// SetSampleTime sets the SampleTime field's value.
func (s *BatchEvaluateGeofencesError) SetSampleTime(v time.Time) *BatchEvaluateGeofencesError {
	s.SampleTime = &v
	return s
}

type BatchEvaluateGeofencesInput struct {
	_ struct{} `type:"structure"`

	// The geofence collection used in evaluating the position of devices against
	// its geofences.
	//
	// CollectionName is a required field
	CollectionName *string `location:"uri" locationName:"CollectionName" min:"1" type:"string" required:"true"`

	// Contains device details for each device to be evaluated against the given
	// geofence collection.
	//
	// DevicePositionUpdates is a required field
	DevicePositionUpdates []*DevicePositionUpdate `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchEvaluateGeofencesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchEvaluateGeofencesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchEvaluateGeofencesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchEvaluateGeofencesInput"}
	if s.CollectionName == nil {
		invalidParams.Add(request.NewErrParamRequired("CollectionName"))
	}
	if s.CollectionName != nil && len(*s.CollectionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CollectionName", 1))
	}
	if s.DevicePositionUpdates == nil {
		invalidParams.Add(request.NewErrParamRequired("DevicePositionUpdates"))
	}
	if s.DevicePositionUpdates != nil && len(s.DevicePositionUpdates) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DevicePositionUpdates", 1))
	}
	if s.DevicePositionUpdates != nil {
		for i, v := range s.DevicePositionUpdates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DevicePositionUpdates", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollectionName sets the CollectionName field's value.
func (s *BatchEvaluateGeofencesInput) SetCollectionName(v string) *BatchEvaluateGeofencesInput {
	s.CollectionName = &v
	return s
}

// SetDevicePositionUpdates sets the DevicePositionUpdates field's value.
func (s *BatchEvaluateGeofencesInput) SetDevicePositionUpdates(v []*DevicePositionUpdate) *BatchEvaluateGeofencesInput {
	s.DevicePositionUpdates = v
	return s
}

type BatchEvaluateGeofencesOutput struct {
	_ struct{} `type:"structure"`

	// Contains error details for each device that failed to evaluate its position
	// against the given geofence collection.
	//
	// Errors is a required field
	Errors []*BatchEvaluateGeofencesError `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchEvaluateGeofencesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchEvaluateGeofencesOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchEvaluateGeofencesOutput) SetErrors(v []*BatchEvaluateGeofencesError) *BatchEvaluateGeofencesOutput {
	s.Errors = v
	return s
}

// Contains error details for each device that didn't return a position.
type BatchGetDevicePositionError struct {
	_ struct{} `type:"structure"`

	// The ID of the device that didn't return a position.
	//
	// DeviceId is a required field
	DeviceId *string `min:"1" type:"string" required:"true"`

	// Contains details related to the error code.
	//
	// Error is a required field
	Error *BatchItemError `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchGetDevicePositionError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetDevicePositionError) GoString() string {
	return s.String()
}

// SetDeviceId sets the DeviceId field's value.
func (s *BatchGetDevicePositionError) SetDeviceId(v string) *BatchGetDevicePositionError {
	s.DeviceId = &v
	return s
}

// SetError sets the Error field's value.
func (s *BatchGetDevicePositionError) SetError(v *BatchItemError) *BatchGetDevicePositionError {
	s.Error = v
	return s
}

type BatchGetDevicePositionInput struct {
	_ struct{} `type:"structure"`

	// Devices whose position you want to retrieve.
	//
	//    * For example, for two devices: device-ids=DeviceId1&device-ids=DeviceId2
	//
	// DeviceIds is a required field
	DeviceIds []*string `min:"1" type:"list" required:"true"`

	// The tracker resource retrieving the device position.
	//
	// TrackerName is a required field
	TrackerName *string `location:"uri" locationName:"TrackerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s BatchGetDevicePositionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetDevicePositionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetDevicePositionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetDevicePositionInput"}
	if s.DeviceIds == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceIds"))
	}
	if s.DeviceIds != nil && len(s.DeviceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceIds", 1))
	}
	if s.TrackerName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrackerName"))
	}
	if s.TrackerName != nil && len(*s.TrackerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrackerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceIds sets the DeviceIds field's value.
func (s *BatchGetDevicePositionInput) SetDeviceIds(v []*string) *BatchGetDevicePositionInput {
	s.DeviceIds = v
	return s
}

// SetTrackerName sets the TrackerName field's value.
func (s *BatchGetDevicePositionInput) SetTrackerName(v string) *BatchGetDevicePositionInput {
	s.TrackerName = &v
	return s
}

type BatchGetDevicePositionOutput struct {
	_ struct{} `type:"structure"`

	// Contains device position details such as the device ID, position, and timestamps
	// for when the position was received and sampled.
	//
	// DevicePositions is a required field
	DevicePositions []*DevicePosition `type:"list" required:"true"`

	// Contains error details for each device that failed to send its position to
	// the tracker resource.
	//
	// Errors is a required field
	Errors []*BatchGetDevicePositionError `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetDevicePositionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetDevicePositionOutput) GoString() string {
	return s.String()
}

// SetDevicePositions sets the DevicePositions field's value.
func (s *BatchGetDevicePositionOutput) SetDevicePositions(v []*DevicePosition) *BatchGetDevicePositionOutput {
	s.DevicePositions = v
	return s
}

// SetErrors sets the Errors field's value.
func (s *BatchGetDevicePositionOutput) SetErrors(v []*BatchGetDevicePositionError) *BatchGetDevicePositionOutput {
	s.Errors = v
	return s
}

// Contains the batch request error details associated with the request.
type BatchItemError struct {
	_ struct{} `type:"structure"`

	// The error code associated with the batch request error.
	Code *string `type:"string" enum:"BatchItemErrorCode"`

	// A message with the reason for the batch request error.
	Message *string `type:"string"`
}

// String returns the string representation
func (s BatchItemError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchItemError) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *BatchItemError) SetCode(v string) *BatchItemError {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *BatchItemError) SetMessage(v string) *BatchItemError {
	s.Message = &v
	return s
}

// Contains error details for each geofence that failed to be stored in a given
// geofence collection.
type BatchPutGeofenceError struct {
	_ struct{} `type:"structure"`

	// Contains details associated to the batch error.
	//
	// Error is a required field
	Error *BatchItemError `type:"structure" required:"true"`

	// The geofence associated with the error message.
	//
	// GeofenceId is a required field
	GeofenceId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s BatchPutGeofenceError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchPutGeofenceError) GoString() string {
	return s.String()
}

// SetError sets the Error field's value.
func (s *BatchPutGeofenceError) SetError(v *BatchItemError) *BatchPutGeofenceError {
	s.Error = v
	return s
}

// SetGeofenceId sets the GeofenceId field's value.
func (s *BatchPutGeofenceError) SetGeofenceId(v string) *BatchPutGeofenceError {
	s.GeofenceId = &v
	return s
}

type BatchPutGeofenceInput struct {
	_ struct{} `type:"structure"`

	// The geofence collection storing the geofences.
	//
	// CollectionName is a required field
	CollectionName *string `location:"uri" locationName:"CollectionName" min:"1" type:"string" required:"true"`

	// The batch of geofences to be stored in a geofence collection.
	//
	// Entries is a required field
	Entries []*BatchPutGeofenceRequestEntry `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchPutGeofenceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchPutGeofenceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchPutGeofenceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchPutGeofenceInput"}
	if s.CollectionName == nil {
		invalidParams.Add(request.NewErrParamRequired("CollectionName"))
	}
	if s.CollectionName != nil && len(*s.CollectionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CollectionName", 1))
	}
	if s.Entries == nil {
		invalidParams.Add(request.NewErrParamRequired("Entries"))
	}
	if s.Entries != nil && len(s.Entries) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Entries", 1))
	}
	if s.Entries != nil {
		for i, v := range s.Entries {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Entries", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollectionName sets the CollectionName field's value.
func (s *BatchPutGeofenceInput) SetCollectionName(v string) *BatchPutGeofenceInput {
	s.CollectionName = &v
	return s
}

// SetEntries sets the Entries field's value.
func (s *BatchPutGeofenceInput) SetEntries(v []*BatchPutGeofenceRequestEntry) *BatchPutGeofenceInput {
	s.Entries = v
	return s
}

type BatchPutGeofenceOutput struct {
	_ struct{} `type:"structure"`

	// Contains additional error details for each geofence that failed to be stored
	// in a geofence collection.
	//
	// Errors is a required field
	Errors []*BatchPutGeofenceError `type:"list" required:"true"`

	// Contains each geofence that was successfully stored in a geofence collection.
	//
	// Successes is a required field
	Successes []*BatchPutGeofenceSuccess `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchPutGeofenceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchPutGeofenceOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchPutGeofenceOutput) SetErrors(v []*BatchPutGeofenceError) *BatchPutGeofenceOutput {
	s.Errors = v
	return s
}

// SetSuccesses sets the Successes field's value.
func (s *BatchPutGeofenceOutput) SetSuccesses(v []*BatchPutGeofenceSuccess) *BatchPutGeofenceOutput {
	s.Successes = v
	return s
}

// Contains geofence details.
type BatchPutGeofenceRequestEntry struct {
	_ struct{} `type:"structure"`

	// The identifier for the geofence to be stored in a given geofence collection.
	//
	// GeofenceId is a required field
	GeofenceId *string `min:"1" type:"string" required:"true"`

	// The geometry details for the geofence.
	//
	// Geometry is a required field
	Geometry *GeofenceGeometry `type:"structure" required:"true"`
}

// String returns the string representation
func (s BatchPutGeofenceRequestEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchPutGeofenceRequestEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchPutGeofenceRequestEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchPutGeofenceRequestEntry"}
	if s.GeofenceId == nil {
		invalidParams.Add(request.NewErrParamRequired("GeofenceId"))
	}
	if s.GeofenceId != nil && len(*s.GeofenceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GeofenceId", 1))
	}
	if s.Geometry == nil {
		invalidParams.Add(request.NewErrParamRequired("Geometry"))
	}
	if s.Geometry != nil {
		if err := s.Geometry.Validate(); err != nil {
			invalidParams.AddNested("Geometry", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGeofenceId sets the GeofenceId field's value.
func (s *BatchPutGeofenceRequestEntry) SetGeofenceId(v string) *BatchPutGeofenceRequestEntry {
	s.GeofenceId = &v
	return s
}

// SetGeometry sets the Geometry field's value.
func (s *BatchPutGeofenceRequestEntry) SetGeometry(v *GeofenceGeometry) *BatchPutGeofenceRequestEntry {
	s.Geometry = v
	return s
}

// Contains a summary of each geofence that was successfully stored in a given
// geofence collection.
type BatchPutGeofenceSuccess struct {
	_ struct{} `type:"structure"`

	// The timestamp for when the geofence was stored in a geofence collection in
	// ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The geofence successfully stored in a geofence collection.
	//
	// GeofenceId is a required field
	GeofenceId *string `min:"1" type:"string" required:"true"`

	// The timestamp for when the geofence was last updated in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s BatchPutGeofenceSuccess) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchPutGeofenceSuccess) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *BatchPutGeofenceSuccess) SetCreateTime(v time.Time) *BatchPutGeofenceSuccess {
	s.CreateTime = &v
	return s
}

// SetGeofenceId sets the GeofenceId field's value.
func (s *BatchPutGeofenceSuccess) SetGeofenceId(v string) *BatchPutGeofenceSuccess {
	s.GeofenceId = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *BatchPutGeofenceSuccess) SetUpdateTime(v time.Time) *BatchPutGeofenceSuccess {
	s.UpdateTime = &v
	return s
}

// Contains error details for each device that failed to update its position.
type BatchUpdateDevicePositionError struct {
	_ struct{} `type:"structure"`

	// The device associated with the failed location update.
	//
	// DeviceId is a required field
	DeviceId *string `min:"1" type:"string" required:"true"`

	// Contains details related to the error code such as the error code and error
	// message.
	//
	// Error is a required field
	Error *BatchItemError `type:"structure" required:"true"`

	// The timestamp for when a position sample was attempted in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// SampleTime is a required field
	SampleTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s BatchUpdateDevicePositionError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchUpdateDevicePositionError) GoString() string {
	return s.String()
}

// SetDeviceId sets the DeviceId field's value.
func (s *BatchUpdateDevicePositionError) SetDeviceId(v string) *BatchUpdateDevicePositionError {
	s.DeviceId = &v
	return s
}

// SetError sets the Error field's value.
func (s *BatchUpdateDevicePositionError) SetError(v *BatchItemError) *BatchUpdateDevicePositionError {
	s.Error = v
	return s
}

// SetSampleTime sets the SampleTime field's value.
func (s *BatchUpdateDevicePositionError) SetSampleTime(v time.Time) *BatchUpdateDevicePositionError {
	s.SampleTime = &v
	return s
}

type BatchUpdateDevicePositionInput struct {
	_ struct{} `type:"structure"`

	// The name of the tracker resource to update.
	//
	// TrackerName is a required field
	TrackerName *string `location:"uri" locationName:"TrackerName" min:"1" type:"string" required:"true"`

	// Contains the position update details for each device.
	//
	// Updates is a required field
	Updates []*DevicePositionUpdate `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchUpdateDevicePositionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchUpdateDevicePositionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchUpdateDevicePositionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchUpdateDevicePositionInput"}
	if s.TrackerName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrackerName"))
	}
	if s.TrackerName != nil && len(*s.TrackerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrackerName", 1))
	}
	if s.Updates == nil {
		invalidParams.Add(request.NewErrParamRequired("Updates"))
	}
	if s.Updates != nil && len(s.Updates) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Updates", 1))
	}
	if s.Updates != nil {
		for i, v := range s.Updates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Updates", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTrackerName sets the TrackerName field's value.
func (s *BatchUpdateDevicePositionInput) SetTrackerName(v string) *BatchUpdateDevicePositionInput {
	s.TrackerName = &v
	return s
}

// SetUpdates sets the Updates field's value.
func (s *BatchUpdateDevicePositionInput) SetUpdates(v []*DevicePositionUpdate) *BatchUpdateDevicePositionInput {
	s.Updates = v
	return s
}

type BatchUpdateDevicePositionOutput struct {
	_ struct{} `type:"structure"`

	// Contains error details for each device that failed to update its position.
	//
	// Errors is a required field
	Errors []*BatchUpdateDevicePositionError `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchUpdateDevicePositionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchUpdateDevicePositionOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchUpdateDevicePositionOutput) SetErrors(v []*BatchUpdateDevicePositionError) *BatchUpdateDevicePositionOutput {
	s.Errors = v
	return s
}

// The request was unsuccessful due to a conflict.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateGeofenceCollectionInput struct {
	_ struct{} `type:"structure"`

	// A custom name for the geofence collection.
	//
	// Requirements:
	//
	//    * Contain only alphanumeric characters (A–Z, a–z, 0-9), hyphens (-),
	//    and underscores (_).
	//
	//    * Must be a unique geofence collection name.
	//
	//    * No spaces allowed. For example, ExampleGeofenceCollection.
	//
	// CollectionName is a required field
	CollectionName *string `min:"1" type:"string" required:"true"`

	// An optional description for the geofence collection.
	Description *string `type:"string"`

	// Specifies the pricing plan for your geofence collection. There's three pricing
	// plan options:
	//
	//    * RequestBasedUsage — Selects the "Request-Based Usage" pricing plan.
	//
	//    * MobileAssetTracking — Selects the "Mobile Asset Tracking" pricing
	//    plan.
	//
	//    * MobileAssetManagement — Selects the "Mobile Asset Management" pricing
	//    plan.
	//
	// For additional details and restrictions on each pricing plan option, see
	// the Amazon Location Service pricing page (https://aws.amazon.com/location/pricing/).
	//
	// PricingPlan is a required field
	PricingPlan *string `type:"string" required:"true" enum:"PricingPlan"`
}

// String returns the string representation
func (s CreateGeofenceCollectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGeofenceCollectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGeofenceCollectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGeofenceCollectionInput"}
	if s.CollectionName == nil {
		invalidParams.Add(request.NewErrParamRequired("CollectionName"))
	}
	if s.CollectionName != nil && len(*s.CollectionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CollectionName", 1))
	}
	if s.PricingPlan == nil {
		invalidParams.Add(request.NewErrParamRequired("PricingPlan"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollectionName sets the CollectionName field's value.
func (s *CreateGeofenceCollectionInput) SetCollectionName(v string) *CreateGeofenceCollectionInput {
	s.CollectionName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateGeofenceCollectionInput) SetDescription(v string) *CreateGeofenceCollectionInput {
	s.Description = &v
	return s
}

// SetPricingPlan sets the PricingPlan field's value.
func (s *CreateGeofenceCollectionInput) SetPricingPlan(v string) *CreateGeofenceCollectionInput {
	s.PricingPlan = &v
	return s
}

type CreateGeofenceCollectionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the geofence collection resource. Used
	// when you need to specify a resource across all AWS.
	//
	// CollectionArn is a required field
	CollectionArn *string `type:"string" required:"true"`

	// The name for the geofence collection.
	//
	// CollectionName is a required field
	CollectionName *string `min:"1" type:"string" required:"true"`

	// The timestamp for when the geofence collection was created in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s CreateGeofenceCollectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGeofenceCollectionOutput) GoString() string {
	return s.String()
}

// SetCollectionArn sets the CollectionArn field's value.
func (s *CreateGeofenceCollectionOutput) SetCollectionArn(v string) *CreateGeofenceCollectionOutput {
	s.CollectionArn = &v
	return s
}

// SetCollectionName sets the CollectionName field's value.
func (s *CreateGeofenceCollectionOutput) SetCollectionName(v string) *CreateGeofenceCollectionOutput {
	s.CollectionName = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *CreateGeofenceCollectionOutput) SetCreateTime(v time.Time) *CreateGeofenceCollectionOutput {
	s.CreateTime = &v
	return s
}

type CreateMapInput struct {
	_ struct{} `type:"structure"`

	// Specifies the map style selected from an available data provider.
	//
	// Configuration is a required field
	Configuration *MapConfiguration `type:"structure" required:"true"`

	// An optional description for the map resource.
	Description *string `type:"string"`

	// The name for the map resource.
	//
	// Requirements:
	//
	//    * Must contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens
	//    (-), and underscores (_).
	//
	//    * Must be a unique map resource name.
	//
	//    * No spaces allowed. For example, ExampleMap.
	//
	// MapName is a required field
	MapName *string `min:"1" type:"string" required:"true"`

	// Specifies the pricing plan for your map resource. There's three pricing plan
	// options:
	//
	//    * RequestBasedUsage — Selects the "Request-Based Usage" pricing plan.
	//
	//    * MobileAssetTracking — Selects the "Mobile Asset Tracking" pricing
	//    plan.
	//
	//    * MobileAssetManagement — Selects the "Mobile Asset Management" pricing
	//    plan.
	//
	// For additional details and restrictions on each pricing plan option, see
	// the Amazon Location Service pricing page (https://aws.amazon.com/location/pricing/).
	//
	// PricingPlan is a required field
	PricingPlan *string `type:"string" required:"true" enum:"PricingPlan"`
}

// String returns the string representation
func (s CreateMapInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMapInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMapInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMapInput"}
	if s.Configuration == nil {
		invalidParams.Add(request.NewErrParamRequired("Configuration"))
	}
	if s.MapName == nil {
		invalidParams.Add(request.NewErrParamRequired("MapName"))
	}
	if s.MapName != nil && len(*s.MapName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MapName", 1))
	}
	if s.PricingPlan == nil {
		invalidParams.Add(request.NewErrParamRequired("PricingPlan"))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguration sets the Configuration field's value.
func (s *CreateMapInput) SetConfiguration(v *MapConfiguration) *CreateMapInput {
	s.Configuration = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateMapInput) SetDescription(v string) *CreateMapInput {
	s.Description = &v
	return s
}

// SetMapName sets the MapName field's value.
func (s *CreateMapInput) SetMapName(v string) *CreateMapInput {
	s.MapName = &v
	return s
}

// SetPricingPlan sets the PricingPlan field's value.
func (s *CreateMapInput) SetPricingPlan(v string) *CreateMapInput {
	s.PricingPlan = &v
	return s
}

type CreateMapOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp for when the map resource was created in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The Amazon Resource Name (ARN) for the map resource. Used when you need to
	// specify a resource across all AWS.
	//
	//    * Format example: arn:partition:service:region:account-id:resource-type:resource-id
	//
	// MapArn is a required field
	MapArn *string `type:"string" required:"true"`

	// The name of the map resource.
	//
	// MapName is a required field
	MapName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateMapOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMapOutput) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *CreateMapOutput) SetCreateTime(v time.Time) *CreateMapOutput {
	s.CreateTime = &v
	return s
}

// SetMapArn sets the MapArn field's value.
func (s *CreateMapOutput) SetMapArn(v string) *CreateMapOutput {
	s.MapArn = &v
	return s
}

// SetMapName sets the MapName field's value.
func (s *CreateMapOutput) SetMapName(v string) *CreateMapOutput {
	s.MapName = &v
	return s
}

type CreatePlaceIndexInput struct {
	_ struct{} `type:"structure"`

	// Specifies the data provider of geospatial data.
	//
	// DataSource is a required field
	DataSource *string `type:"string" required:"true"`

	// Specifies the data storage option for requesting Places.
	DataSourceConfiguration *DataSourceConfiguration `type:"structure"`

	// The optional description for the Place index resource.
	Description *string `type:"string"`

	// The name of the Place index resource.
	//
	// Requirements:
	//
	//    * Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-) and
	//    underscores (_) ).
	//
	//    * Must be a unique Place index resource name.
	//
	//    * No spaces allowed. For example, ExamplePlaceIndex.
	//
	// IndexName is a required field
	IndexName *string `min:"1" type:"string" required:"true"`

	// Specifies the pricing plan for your Place index resource. There's three pricing
	// plan options:
	//
	//    * RequestBasedUsage — Selects the "Request-Based Usage" pricing plan.
	//
	//    * MobileAssetTracking — Selects the "Mobile Asset Tracking" pricing
	//    plan.
	//
	//    * MobileAssetManagement — Selects the "Mobile Asset Management" pricing
	//    plan.
	//
	// For additional details and restrictions on each pricing plan option, see
	// the Amazon Location Service pricing page (https://aws.amazon.com/location/pricing/).
	//
	// PricingPlan is a required field
	PricingPlan *string `type:"string" required:"true" enum:"PricingPlan"`
}

// String returns the string representation
func (s CreatePlaceIndexInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePlaceIndexInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePlaceIndexInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePlaceIndexInput"}
	if s.DataSource == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSource"))
	}
	if s.IndexName == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexName"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 1))
	}
	if s.PricingPlan == nil {
		invalidParams.Add(request.NewErrParamRequired("PricingPlan"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSource sets the DataSource field's value.
func (s *CreatePlaceIndexInput) SetDataSource(v string) *CreatePlaceIndexInput {
	s.DataSource = &v
	return s
}

// SetDataSourceConfiguration sets the DataSourceConfiguration field's value.
func (s *CreatePlaceIndexInput) SetDataSourceConfiguration(v *DataSourceConfiguration) *CreatePlaceIndexInput {
	s.DataSourceConfiguration = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreatePlaceIndexInput) SetDescription(v string) *CreatePlaceIndexInput {
	s.Description = &v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *CreatePlaceIndexInput) SetIndexName(v string) *CreatePlaceIndexInput {
	s.IndexName = &v
	return s
}

// SetPricingPlan sets the PricingPlan field's value.
func (s *CreatePlaceIndexInput) SetPricingPlan(v string) *CreatePlaceIndexInput {
	s.PricingPlan = &v
	return s
}

type CreatePlaceIndexOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp for when the Place index resource was created in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The Amazon Resource Name (ARN) for the Place index resource. Used when you
	// need to specify a resource across all AWS.
	//
	// IndexArn is a required field
	IndexArn *string `type:"string" required:"true"`

	// The name for the Place index resource.
	//
	// IndexName is a required field
	IndexName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreatePlaceIndexOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePlaceIndexOutput) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *CreatePlaceIndexOutput) SetCreateTime(v time.Time) *CreatePlaceIndexOutput {
	s.CreateTime = &v
	return s
}

// SetIndexArn sets the IndexArn field's value.
func (s *CreatePlaceIndexOutput) SetIndexArn(v string) *CreatePlaceIndexOutput {
	s.IndexArn = &v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *CreatePlaceIndexOutput) SetIndexName(v string) *CreatePlaceIndexOutput {
	s.IndexName = &v
	return s
}

type CreateTrackerInput struct {
	_ struct{} `type:"structure"`

	// An optional description for the tracker resource.
	Description *string `type:"string"`

	// Specifies the pricing plan for your tracker resource. There's three pricing
	// plan options:
	//
	//    * RequestBasedUsage — Selects the "Request-Based Usage" pricing plan.
	//
	//    * MobileAssetTracking — Selects the "Mobile Asset Tracking" pricing
	//    plan.
	//
	//    * MobileAssetManagement — Selects the "Mobile Asset Management" pricing
	//    plan.
	//
	// For additional details and restrictions on each pricing plan option, see
	// the Amazon Location Service pricing page (https://aws.amazon.com/location/pricing/).
	//
	// PricingPlan is a required field
	PricingPlan *string `type:"string" required:"true" enum:"PricingPlan"`

	// The name for the tracker resource.
	//
	// Requirements:
	//
	//    * Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-) and
	//    underscores (_).
	//
	//    * Must be a unique tracker resource name.
	//
	//    * No spaces allowed. For example, ExampleTracker.
	//
	// TrackerName is a required field
	TrackerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateTrackerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTrackerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTrackerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTrackerInput"}
	if s.PricingPlan == nil {
		invalidParams.Add(request.NewErrParamRequired("PricingPlan"))
	}
	if s.TrackerName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrackerName"))
	}
	if s.TrackerName != nil && len(*s.TrackerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrackerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateTrackerInput) SetDescription(v string) *CreateTrackerInput {
	s.Description = &v
	return s
}

// SetPricingPlan sets the PricingPlan field's value.
func (s *CreateTrackerInput) SetPricingPlan(v string) *CreateTrackerInput {
	s.PricingPlan = &v
	return s
}

// SetTrackerName sets the TrackerName field's value.
func (s *CreateTrackerInput) SetTrackerName(v string) *CreateTrackerInput {
	s.TrackerName = &v
	return s
}

type CreateTrackerOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp for when the tracker resource was created in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The Amazon Resource Name (ARN) for the tracker resource. Used when you need
	// to specify a resource across all AWS.
	//
	// TrackerArn is a required field
	TrackerArn *string `type:"string" required:"true"`

	// The name of the tracker resource.
	//
	// TrackerName is a required field
	TrackerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateTrackerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTrackerOutput) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *CreateTrackerOutput) SetCreateTime(v time.Time) *CreateTrackerOutput {
	s.CreateTime = &v
	return s
}

// SetTrackerArn sets the TrackerArn field's value.
func (s *CreateTrackerOutput) SetTrackerArn(v string) *CreateTrackerOutput {
	s.TrackerArn = &v
	return s
}

// SetTrackerName sets the TrackerName field's value.
func (s *CreateTrackerOutput) SetTrackerName(v string) *CreateTrackerOutput {
	s.TrackerName = &v
	return s
}

// Specifies the data storage option chosen for requesting Places.
//
// By using Places, you agree that AWS may transmit your API queries to your
// selected third party provider for processing, which may be outside the AWS
// region you are currently using.
//
// Also, when using HERE as your data provider, you may not (a) use HERE Places
// for Asset Management, or (b) select the Storage option for the IntendedUse
// parameter when requesting Places in Japan. For more information, see the
// AWS Service Terms (https://aws.amazon.com/service-terms/) for Amazon Location
// Service.
type DataSourceConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies how the results of an operation will be stored by the caller.
	//
	// Valid values include:
	//
	//    * SingleUse specifies that the results won't be stored.
	//
	//    * Storage specifies that the result can be cached or stored in a database.
	//
	// Default value: SingleUse
	IntendedUse *string `type:"string" enum:"IntendedUse"`
}

// String returns the string representation
func (s DataSourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataSourceConfiguration) GoString() string {
	return s.String()
}

// SetIntendedUse sets the IntendedUse field's value.
func (s *DataSourceConfiguration) SetIntendedUse(v string) *DataSourceConfiguration {
	s.IntendedUse = &v
	return s
}

type DeleteGeofenceCollectionInput struct {
	_ struct{} `type:"structure"`

	// The name of the geofence collection to be deleted.
	//
	// CollectionName is a required field
	CollectionName *string `location:"uri" locationName:"CollectionName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteGeofenceCollectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGeofenceCollectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGeofenceCollectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGeofenceCollectionInput"}
	if s.CollectionName == nil {
		invalidParams.Add(request.NewErrParamRequired("CollectionName"))
	}
	if s.CollectionName != nil && len(*s.CollectionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CollectionName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollectionName sets the CollectionName field's value.
func (s *DeleteGeofenceCollectionInput) SetCollectionName(v string) *DeleteGeofenceCollectionInput {
	s.CollectionName = &v
	return s
}

type DeleteGeofenceCollectionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteGeofenceCollectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGeofenceCollectionOutput) GoString() string {
	return s.String()
}

type DeleteMapInput struct {
	_ struct{} `type:"structure"`

	// The name of the map resource to be deleted.
	//
	// MapName is a required field
	MapName *string `location:"uri" locationName:"MapName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMapInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMapInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMapInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMapInput"}
	if s.MapName == nil {
		invalidParams.Add(request.NewErrParamRequired("MapName"))
	}
	if s.MapName != nil && len(*s.MapName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MapName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMapName sets the MapName field's value.
func (s *DeleteMapInput) SetMapName(v string) *DeleteMapInput {
	s.MapName = &v
	return s
}

type DeleteMapOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteMapOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMapOutput) GoString() string {
	return s.String()
}

type DeletePlaceIndexInput struct {
	_ struct{} `type:"structure"`

	// The name of the Place index resource to be deleted.
	//
	// IndexName is a required field
	IndexName *string `location:"uri" locationName:"IndexName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePlaceIndexInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePlaceIndexInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePlaceIndexInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePlaceIndexInput"}
	if s.IndexName == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexName"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndexName sets the IndexName field's value.
func (s *DeletePlaceIndexInput) SetIndexName(v string) *DeletePlaceIndexInput {
	s.IndexName = &v
	return s
}

type DeletePlaceIndexOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePlaceIndexOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePlaceIndexOutput) GoString() string {
	return s.String()
}

type DeleteTrackerInput struct {
	_ struct{} `type:"structure"`

	// The name of the tracker resource to be deleted.
	//
	// TrackerName is a required field
	TrackerName *string `location:"uri" locationName:"TrackerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTrackerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTrackerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTrackerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTrackerInput"}
	if s.TrackerName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrackerName"))
	}
	if s.TrackerName != nil && len(*s.TrackerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrackerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTrackerName sets the TrackerName field's value.
func (s *DeleteTrackerInput) SetTrackerName(v string) *DeleteTrackerInput {
	s.TrackerName = &v
	return s
}

type DeleteTrackerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTrackerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTrackerOutput) GoString() string {
	return s.String()
}

type DescribeGeofenceCollectionInput struct {
	_ struct{} `type:"structure"`

	// The name of the geofence collection.
	//
	// CollectionName is a required field
	CollectionName *string `location:"uri" locationName:"CollectionName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeGeofenceCollectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGeofenceCollectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeGeofenceCollectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeGeofenceCollectionInput"}
	if s.CollectionName == nil {
		invalidParams.Add(request.NewErrParamRequired("CollectionName"))
	}
	if s.CollectionName != nil && len(*s.CollectionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CollectionName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollectionName sets the CollectionName field's value.
func (s *DescribeGeofenceCollectionInput) SetCollectionName(v string) *DescribeGeofenceCollectionInput {
	s.CollectionName = &v
	return s
}

type DescribeGeofenceCollectionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the geofence collection resource. Used
	// when you need to specify a resource across all AWS.
	//
	// CollectionArn is a required field
	CollectionArn *string `type:"string" required:"true"`

	// The name of the geofence collection.
	//
	// CollectionName is a required field
	CollectionName *string `min:"1" type:"string" required:"true"`

	// The timestamp for when the geofence resource was created in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The optional description for the geofence collection.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The timestamp for when the geofence collection was last updated in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format: YYYY-MM-DDThh:mm:ss.sssZ
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s DescribeGeofenceCollectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGeofenceCollectionOutput) GoString() string {
	return s.String()
}

// SetCollectionArn sets the CollectionArn field's value.
func (s *DescribeGeofenceCollectionOutput) SetCollectionArn(v string) *DescribeGeofenceCollectionOutput {
	s.CollectionArn = &v
	return s
}

// SetCollectionName sets the CollectionName field's value.
func (s *DescribeGeofenceCollectionOutput) SetCollectionName(v string) *DescribeGeofenceCollectionOutput {
	s.CollectionName = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *DescribeGeofenceCollectionOutput) SetCreateTime(v time.Time) *DescribeGeofenceCollectionOutput {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeGeofenceCollectionOutput) SetDescription(v string) *DescribeGeofenceCollectionOutput {
	s.Description = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *DescribeGeofenceCollectionOutput) SetUpdateTime(v time.Time) *DescribeGeofenceCollectionOutput {
	s.UpdateTime = &v
	return s
}

type DescribeMapInput struct {
	_ struct{} `type:"structure"`

	// The name of the map resource.
	//
	// MapName is a required field
	MapName *string `location:"uri" locationName:"MapName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeMapInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMapInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMapInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMapInput"}
	if s.MapName == nil {
		invalidParams.Add(request.NewErrParamRequired("MapName"))
	}
	if s.MapName != nil && len(*s.MapName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MapName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMapName sets the MapName field's value.
func (s *DescribeMapInput) SetMapName(v string) *DescribeMapInput {
	s.MapName = &v
	return s
}

type DescribeMapOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the map tile style selected from a partner data provider.
	//
	// Configuration is a required field
	Configuration *MapConfiguration `type:"structure" required:"true"`

	// The timestamp for when the map resource was created in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Specifies the data provider for the associated map tiles.
	//
	// DataSource is a required field
	DataSource *string `type:"string" required:"true"`

	// The optional description for the map resource.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) for the map resource. Used when you need to
	// specify a resource across all AWS.
	//
	// MapArn is a required field
	MapArn *string `type:"string" required:"true"`

	// The map style selected from an available provider.
	//
	// MapName is a required field
	MapName *string `min:"1" type:"string" required:"true"`

	// The timestamp for when the map resource was last update in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s DescribeMapOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMapOutput) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *DescribeMapOutput) SetConfiguration(v *MapConfiguration) *DescribeMapOutput {
	s.Configuration = v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *DescribeMapOutput) SetCreateTime(v time.Time) *DescribeMapOutput {
	s.CreateTime = &v
	return s
}

// SetDataSource sets the DataSource field's value.
func (s *DescribeMapOutput) SetDataSource(v string) *DescribeMapOutput {
	s.DataSource = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeMapOutput) SetDescription(v string) *DescribeMapOutput {
	s.Description = &v
	return s
}

// SetMapArn sets the MapArn field's value.
func (s *DescribeMapOutput) SetMapArn(v string) *DescribeMapOutput {
	s.MapArn = &v
	return s
}

// SetMapName sets the MapName field's value.
func (s *DescribeMapOutput) SetMapName(v string) *DescribeMapOutput {
	s.MapName = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *DescribeMapOutput) SetUpdateTime(v time.Time) *DescribeMapOutput {
	s.UpdateTime = &v
	return s
}

type DescribePlaceIndexInput struct {
	_ struct{} `type:"structure"`

	// The name of the Place index resource.
	//
	// IndexName is a required field
	IndexName *string `location:"uri" locationName:"IndexName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribePlaceIndexInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePlaceIndexInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePlaceIndexInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePlaceIndexInput"}
	if s.IndexName == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexName"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndexName sets the IndexName field's value.
func (s *DescribePlaceIndexInput) SetIndexName(v string) *DescribePlaceIndexInput {
	s.IndexName = &v
	return s
}

type DescribePlaceIndexOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp for when the Place index resource was created in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The data provider of geospatial data.
	//
	// DataSource is a required field
	DataSource *string `type:"string" required:"true"`

	// The specified data storage option for requesting Places.
	//
	// DataSourceConfiguration is a required field
	DataSourceConfiguration *DataSourceConfiguration `type:"structure" required:"true"`

	// The optional description for the Place index resource.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) for the Place index resource. Used when you
	// need to specify a resource across all AWS.
	//
	// IndexArn is a required field
	IndexArn *string `type:"string" required:"true"`

	// The name of the Place index resource being described.
	//
	// IndexName is a required field
	IndexName *string `min:"1" type:"string" required:"true"`

	// The timestamp for when the Place index resource was last updated in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s DescribePlaceIndexOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePlaceIndexOutput) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *DescribePlaceIndexOutput) SetCreateTime(v time.Time) *DescribePlaceIndexOutput {
	s.CreateTime = &v
	return s
}

// SetDataSource sets the DataSource field's value.
func (s *DescribePlaceIndexOutput) SetDataSource(v string) *DescribePlaceIndexOutput {
	s.DataSource = &v
	return s
}

// SetDataSourceConfiguration sets the DataSourceConfiguration field's value.
func (s *DescribePlaceIndexOutput) SetDataSourceConfiguration(v *DataSourceConfiguration) *DescribePlaceIndexOutput {
	s.DataSourceConfiguration = v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribePlaceIndexOutput) SetDescription(v string) *DescribePlaceIndexOutput {
	s.Description = &v
	return s
}

// SetIndexArn sets the IndexArn field's value.
func (s *DescribePlaceIndexOutput) SetIndexArn(v string) *DescribePlaceIndexOutput {
	s.IndexArn = &v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *DescribePlaceIndexOutput) SetIndexName(v string) *DescribePlaceIndexOutput {
	s.IndexName = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *DescribePlaceIndexOutput) SetUpdateTime(v time.Time) *DescribePlaceIndexOutput {
	s.UpdateTime = &v
	return s
}

type DescribeTrackerInput struct {
	_ struct{} `type:"structure"`

	// The name of the tracker resource.
	//
	// TrackerName is a required field
	TrackerName *string `location:"uri" locationName:"TrackerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeTrackerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrackerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTrackerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTrackerInput"}
	if s.TrackerName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrackerName"))
	}
	if s.TrackerName != nil && len(*s.TrackerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrackerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTrackerName sets the TrackerName field's value.
func (s *DescribeTrackerInput) SetTrackerName(v string) *DescribeTrackerInput {
	s.TrackerName = &v
	return s
}

type DescribeTrackerOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp for when the tracker resource was created in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The optional description for the tracker resource.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) for the tracker resource. Used when you need
	// to specify a resource across all AWS.
	//
	// TrackerArn is a required field
	TrackerArn *string `type:"string" required:"true"`

	// The name of the tracker resource.
	//
	// TrackerName is a required field
	TrackerName *string `min:"1" type:"string" required:"true"`

	// The timestamp for when the tracker resource was last updated in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s DescribeTrackerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrackerOutput) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *DescribeTrackerOutput) SetCreateTime(v time.Time) *DescribeTrackerOutput {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeTrackerOutput) SetDescription(v string) *DescribeTrackerOutput {
	s.Description = &v
	return s
}

// SetTrackerArn sets the TrackerArn field's value.
func (s *DescribeTrackerOutput) SetTrackerArn(v string) *DescribeTrackerOutput {
	s.TrackerArn = &v
	return s
}

// SetTrackerName sets the TrackerName field's value.
func (s *DescribeTrackerOutput) SetTrackerName(v string) *DescribeTrackerOutput {
	s.TrackerName = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *DescribeTrackerOutput) SetUpdateTime(v time.Time) *DescribeTrackerOutput {
	s.UpdateTime = &v
	return s
}

// Contains the device position details.
type DevicePosition struct {
	_ struct{} `type:"structure"`

	// The device whose position you retrieved.
	DeviceId *string `min:"1" type:"string"`

	// The last known device position.
	//
	// Position is a required field
	Position []*float64 `min:"2" type:"list" required:"true" sensitive:"true"`

	// The timestamp for when the tracker resource recieved the position in ISO
	// 8601 (https://www.iso.org/iso-8601-date-and-time-format.html) format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// ReceivedTime is a required field
	ReceivedTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The timestamp for when the position was detected and sampled in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// SampleTime is a required field
	SampleTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s DevicePosition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DevicePosition) GoString() string {
	return s.String()
}

// SetDeviceId sets the DeviceId field's value.
func (s *DevicePosition) SetDeviceId(v string) *DevicePosition {
	s.DeviceId = &v
	return s
}

// SetPosition sets the Position field's value.
func (s *DevicePosition) SetPosition(v []*float64) *DevicePosition {
	s.Position = v
	return s
}

// SetReceivedTime sets the ReceivedTime field's value.
func (s *DevicePosition) SetReceivedTime(v time.Time) *DevicePosition {
	s.ReceivedTime = &v
	return s
}

// SetSampleTime sets the SampleTime field's value.
func (s *DevicePosition) SetSampleTime(v time.Time) *DevicePosition {
	s.SampleTime = &v
	return s
}

// Contains the position update details for a device.
type DevicePositionUpdate struct {
	_ struct{} `type:"structure"`

	// The device associated to the position update.
	//
	// DeviceId is a required field
	DeviceId *string `min:"1" type:"string" required:"true"`

	// The latest device position defined in WGS 84 (https://earth-info.nga.mil/GandG/wgs84/index.html)
	// format: [Xlongitude, Ylatitude].
	//
	// Position is a required field
	Position []*float64 `min:"2" type:"list" required:"true" sensitive:"true"`

	// The timestamp for when the position update was received in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ
	//
	// SampleTime is a required field
	SampleTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s DevicePositionUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DevicePositionUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DevicePositionUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DevicePositionUpdate"}
	if s.DeviceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceId"))
	}
	if s.DeviceId != nil && len(*s.DeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceId", 1))
	}
	if s.Position == nil {
		invalidParams.Add(request.NewErrParamRequired("Position"))
	}
	if s.Position != nil && len(s.Position) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Position", 2))
	}
	if s.SampleTime == nil {
		invalidParams.Add(request.NewErrParamRequired("SampleTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceId sets the DeviceId field's value.
func (s *DevicePositionUpdate) SetDeviceId(v string) *DevicePositionUpdate {
	s.DeviceId = &v
	return s
}

// SetPosition sets the Position field's value.
func (s *DevicePositionUpdate) SetPosition(v []*float64) *DevicePositionUpdate {
	s.Position = v
	return s
}

// SetSampleTime sets the SampleTime field's value.
func (s *DevicePositionUpdate) SetSampleTime(v time.Time) *DevicePositionUpdate {
	s.SampleTime = &v
	return s
}

type DisassociateTrackerConsumerInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the geofence collection to be disassociated
	// from the tracker resource. Used when you need to specify a resource across
	// all AWS.
	//
	//    * Format example: arn:partition:service:region:account-id:resource-type:resource-id
	//
	// ConsumerArn is a required field
	ConsumerArn *string `location:"uri" locationName:"ConsumerArn" type:"string" required:"true"`

	// The name of the tracker resource to be dissociated from the consumer.
	//
	// TrackerName is a required field
	TrackerName *string `location:"uri" locationName:"TrackerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateTrackerConsumerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateTrackerConsumerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateTrackerConsumerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateTrackerConsumerInput"}
	if s.ConsumerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ConsumerArn"))
	}
	if s.ConsumerArn != nil && len(*s.ConsumerArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConsumerArn", 1))
	}
	if s.TrackerName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrackerName"))
	}
	if s.TrackerName != nil && len(*s.TrackerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrackerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConsumerArn sets the ConsumerArn field's value.
func (s *DisassociateTrackerConsumerInput) SetConsumerArn(v string) *DisassociateTrackerConsumerInput {
	s.ConsumerArn = &v
	return s
}

// SetTrackerName sets the TrackerName field's value.
func (s *DisassociateTrackerConsumerInput) SetTrackerName(v string) *DisassociateTrackerConsumerInput {
	s.TrackerName = &v
	return s
}

type DisassociateTrackerConsumerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateTrackerConsumerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateTrackerConsumerOutput) GoString() string {
	return s.String()
}

// Contains the geofence geometry details.
//
// Limitation — Amazon Location does not currently support polygons with holes,
// multipolygons, polygons that are wound clockwise, or that cross the antimeridian.
type GeofenceGeometry struct {
	_ struct{} `type:"structure"`

	// An array of 1 or more linear rings. A linear ring is an array of 4 or more
	// vertices, where the first and last vertex are the same to form a closed boundary.
	// Each vertex is a 2-dimensional point of the form: [longitude, latitude].
	//
	// The first linear ring is an outer ring, describing the polygon's boundary.
	// Subsequent linear rings may be inner or outer rings to describe holes and
	// islands. Outer rings must list their vertices in counter-clockwise order
	// around the ring's center, where the left side is the polygon's exterior.
	// Inner rings must list their vertices in clockwise order, where the left side
	// is the polygon's interior.
	Polygon [][][]*float64 `min:"1" type:"list"`
}

// String returns the string representation
func (s GeofenceGeometry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GeofenceGeometry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GeofenceGeometry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GeofenceGeometry"}
	if s.Polygon != nil && len(s.Polygon) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Polygon", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolygon sets the Polygon field's value.
func (s *GeofenceGeometry) SetPolygon(v [][][]*float64) *GeofenceGeometry {
	s.Polygon = v
	return s
}

type GetDevicePositionHistoryInput struct {
	_ struct{} `type:"structure"`

	// The device whose position history you want to retrieve.
	//
	// DeviceId is a required field
	DeviceId *string `location:"uri" locationName:"DeviceId" min:"1" type:"string" required:"true"`

	// Specify the end time for the position history in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	//    * The given time for EndTimeExclusive must be after the time for StartTimeInclusive.
	EndTimeExclusive *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The pagination token specifying which page of results to return in the response.
	// If no token is provided, the default page is the first page.
	//
	// Default value: null
	NextToken *string `min:"1" type:"string"`

	// Specify the start time for the position history in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	//    * The given time for EndTimeExclusive must be after the time for StartTimeInclusive.
	StartTimeInclusive *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The tracker resource receiving the request for the device position history.
	//
	// TrackerName is a required field
	TrackerName *string `location:"uri" locationName:"TrackerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDevicePositionHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDevicePositionHistoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDevicePositionHistoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDevicePositionHistoryInput"}
	if s.DeviceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceId"))
	}
	if s.DeviceId != nil && len(*s.DeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceId", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.TrackerName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrackerName"))
	}
	if s.TrackerName != nil && len(*s.TrackerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrackerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceId sets the DeviceId field's value.
func (s *GetDevicePositionHistoryInput) SetDeviceId(v string) *GetDevicePositionHistoryInput {
	s.DeviceId = &v
	return s
}

// SetEndTimeExclusive sets the EndTimeExclusive field's value.
func (s *GetDevicePositionHistoryInput) SetEndTimeExclusive(v time.Time) *GetDevicePositionHistoryInput {
	s.EndTimeExclusive = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDevicePositionHistoryInput) SetNextToken(v string) *GetDevicePositionHistoryInput {
	s.NextToken = &v
	return s
}

// SetStartTimeInclusive sets the StartTimeInclusive field's value.
func (s *GetDevicePositionHistoryInput) SetStartTimeInclusive(v time.Time) *GetDevicePositionHistoryInput {
	s.StartTimeInclusive = &v
	return s
}

// SetTrackerName sets the TrackerName field's value.
func (s *GetDevicePositionHistoryInput) SetTrackerName(v string) *GetDevicePositionHistoryInput {
	s.TrackerName = &v
	return s
}

type GetDevicePositionHistoryOutput struct {
	_ struct{} `type:"structure"`

	// Contains the position history details for the requested device.
	//
	// DevicePositions is a required field
	DevicePositions []*DevicePosition `type:"list" required:"true"`

	// A pagination token indicating there are additional pages available. You can
	// use the token in a following request to fetch the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetDevicePositionHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDevicePositionHistoryOutput) GoString() string {
	return s.String()
}

// SetDevicePositions sets the DevicePositions field's value.
func (s *GetDevicePositionHistoryOutput) SetDevicePositions(v []*DevicePosition) *GetDevicePositionHistoryOutput {
	s.DevicePositions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDevicePositionHistoryOutput) SetNextToken(v string) *GetDevicePositionHistoryOutput {
	s.NextToken = &v
	return s
}

type GetDevicePositionInput struct {
	_ struct{} `type:"structure"`

	// The device whose position you want to retreieve.
	//
	// DeviceId is a required field
	DeviceId *string `location:"uri" locationName:"DeviceId" min:"1" type:"string" required:"true"`

	// The tracker resource receiving the position update.
	//
	// TrackerName is a required field
	TrackerName *string `location:"uri" locationName:"TrackerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDevicePositionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDevicePositionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDevicePositionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDevicePositionInput"}
	if s.DeviceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceId"))
	}
	if s.DeviceId != nil && len(*s.DeviceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceId", 1))
	}
	if s.TrackerName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrackerName"))
	}
	if s.TrackerName != nil && len(*s.TrackerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrackerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeviceId sets the DeviceId field's value.
func (s *GetDevicePositionInput) SetDeviceId(v string) *GetDevicePositionInput {
	s.DeviceId = &v
	return s
}

// SetTrackerName sets the TrackerName field's value.
func (s *GetDevicePositionInput) SetTrackerName(v string) *GetDevicePositionInput {
	s.TrackerName = &v
	return s
}

type GetDevicePositionOutput struct {
	_ struct{} `type:"structure"`

	// The device whose position you retrieved.
	DeviceId *string `min:"1" type:"string"`

	// The last known device position.
	//
	// Position is a required field
	Position []*float64 `min:"2" type:"list" required:"true" sensitive:"true"`

	// The timestamp for when the tracker resource recieved the position in ISO
	// 8601 (https://www.iso.org/iso-8601-date-and-time-format.html) format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// ReceivedTime is a required field
	ReceivedTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The timestamp for when the position was detected and sampled in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// SampleTime is a required field
	SampleTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s GetDevicePositionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDevicePositionOutput) GoString() string {
	return s.String()
}

// SetDeviceId sets the DeviceId field's value.
func (s *GetDevicePositionOutput) SetDeviceId(v string) *GetDevicePositionOutput {
	s.DeviceId = &v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetDevicePositionOutput) SetPosition(v []*float64) *GetDevicePositionOutput {
	s.Position = v
	return s
}

// SetReceivedTime sets the ReceivedTime field's value.
func (s *GetDevicePositionOutput) SetReceivedTime(v time.Time) *GetDevicePositionOutput {
	s.ReceivedTime = &v
	return s
}

// SetSampleTime sets the SampleTime field's value.
func (s *GetDevicePositionOutput) SetSampleTime(v time.Time) *GetDevicePositionOutput {
	s.SampleTime = &v
	return s
}

type GetGeofenceInput struct {
	_ struct{} `type:"structure"`

	// The geofence collection storing the target geofence.
	//
	// CollectionName is a required field
	CollectionName *string `location:"uri" locationName:"CollectionName" min:"1" type:"string" required:"true"`

	// The geofence you're retrieving details for.
	//
	// GeofenceId is a required field
	GeofenceId *string `location:"uri" locationName:"GeofenceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetGeofenceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGeofenceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGeofenceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGeofenceInput"}
	if s.CollectionName == nil {
		invalidParams.Add(request.NewErrParamRequired("CollectionName"))
	}
	if s.CollectionName != nil && len(*s.CollectionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CollectionName", 1))
	}
	if s.GeofenceId == nil {
		invalidParams.Add(request.NewErrParamRequired("GeofenceId"))
	}
	if s.GeofenceId != nil && len(*s.GeofenceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GeofenceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollectionName sets the CollectionName field's value.
func (s *GetGeofenceInput) SetCollectionName(v string) *GetGeofenceInput {
	s.CollectionName = &v
	return s
}

// SetGeofenceId sets the GeofenceId field's value.
func (s *GetGeofenceInput) SetGeofenceId(v string) *GetGeofenceInput {
	s.GeofenceId = &v
	return s
}

type GetGeofenceOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp for when the geofence collection was created in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The geofence identifier.
	//
	// GeofenceId is a required field
	GeofenceId *string `min:"1" type:"string" required:"true"`

	// Contains the geofence geometry details describing a polygon.
	//
	// Geometry is a required field
	Geometry *GeofenceGeometry `type:"structure" required:"true"`

	// Identifies the state of the geofence. A geofence will hold one of the following
	// states:
	//
	//    * ACTIVE — The geofence has been indexed by the system.
	//
	//    * PENDING — The geofence is being processed by the system.
	//
	//    * FAILED — The geofence failed to be indexed by the system.
	//
	//    * DELETED — The geofence has been deleted from the system index.
	//
	//    * DELETING — The geofence is being deleted from the system index.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`

	// The timestamp for when the geofence collection was last updated in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format: YYYY-MM-DDThh:mm:ss.sssZ
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s GetGeofenceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGeofenceOutput) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *GetGeofenceOutput) SetCreateTime(v time.Time) *GetGeofenceOutput {
	s.CreateTime = &v
	return s
}

// SetGeofenceId sets the GeofenceId field's value.
func (s *GetGeofenceOutput) SetGeofenceId(v string) *GetGeofenceOutput {
	s.GeofenceId = &v
	return s
}

// SetGeometry sets the Geometry field's value.
func (s *GetGeofenceOutput) SetGeometry(v *GeofenceGeometry) *GetGeofenceOutput {
	s.Geometry = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetGeofenceOutput) SetStatus(v string) *GetGeofenceOutput {
	s.Status = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *GetGeofenceOutput) SetUpdateTime(v time.Time) *GetGeofenceOutput {
	s.UpdateTime = &v
	return s
}

type GetMapGlyphsInput struct {
	_ struct{} `type:"structure"`

	// A comma-separated list of fonts to load glyphs from in order of preference..
	// For example, Noto Sans, Arial Unicode.
	//
	// FontStack is a required field
	FontStack *string `location:"uri" locationName:"FontStack" type:"string" required:"true"`

	// A Unicode range of characters to download glyphs for. Each response will
	// contain 256 characters. For example, 0-255 includes all characters from range
	// U+0000 to 00FF. Must be aligned to multiples of 256.
	//
	// FontUnicodeRange is a required field
	FontUnicodeRange *string `location:"uri" locationName:"FontUnicodeRange" type:"string" required:"true"`

	// The map resource associated with the glyph ﬁle.
	//
	// MapName is a required field
	MapName *string `location:"uri" locationName:"MapName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetMapGlyphsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMapGlyphsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMapGlyphsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMapGlyphsInput"}
	if s.FontStack == nil {
		invalidParams.Add(request.NewErrParamRequired("FontStack"))
	}
	if s.FontStack != nil && len(*s.FontStack) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FontStack", 1))
	}
	if s.FontUnicodeRange == nil {
		invalidParams.Add(request.NewErrParamRequired("FontUnicodeRange"))
	}
	if s.FontUnicodeRange != nil && len(*s.FontUnicodeRange) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FontUnicodeRange", 1))
	}
	if s.MapName == nil {
		invalidParams.Add(request.NewErrParamRequired("MapName"))
	}
	if s.MapName != nil && len(*s.MapName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MapName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFontStack sets the FontStack field's value.
func (s *GetMapGlyphsInput) SetFontStack(v string) *GetMapGlyphsInput {
	s.FontStack = &v
	return s
}

// SetFontUnicodeRange sets the FontUnicodeRange field's value.
func (s *GetMapGlyphsInput) SetFontUnicodeRange(v string) *GetMapGlyphsInput {
	s.FontUnicodeRange = &v
	return s
}

// SetMapName sets the MapName field's value.
func (s *GetMapGlyphsInput) SetMapName(v string) *GetMapGlyphsInput {
	s.MapName = &v
	return s
}

type GetMapGlyphsOutput struct {
	_ struct{} `type:"structure" payload:"Blob"`

	// The blob's content type.
	Blob []byte `type:"blob"`

	// The map glyph content type. For example, application/octet-stream.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`
}

// String returns the string representation
func (s GetMapGlyphsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMapGlyphsOutput) GoString() string {
	return s.String()
}

// SetBlob sets the Blob field's value.
func (s *GetMapGlyphsOutput) SetBlob(v []byte) *GetMapGlyphsOutput {
	s.Blob = v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *GetMapGlyphsOutput) SetContentType(v string) *GetMapGlyphsOutput {
	s.ContentType = &v
	return s
}

type GetMapSpritesInput struct {
	_ struct{} `type:"structure"`

	// The name of the sprite ﬁle. Use the following ﬁle names for the sprite
	// sheet:
	//
	//    * sprites.png
	//
	//    * sprites@2x.png for high pixel density displays
	//
	// For the JSON document contain image offsets. Use the following ﬁle names:
	//
	//    * sprites.json
	//
	//    * sprites@2x.json for high pixel density displays
	//
	// FileName is a required field
	FileName *string `location:"uri" locationName:"FileName" type:"string" required:"true"`

	// The map resource associated with the sprite ﬁle.
	//
	// MapName is a required field
	MapName *string `location:"uri" locationName:"MapName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetMapSpritesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMapSpritesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMapSpritesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMapSpritesInput"}
	if s.FileName == nil {
		invalidParams.Add(request.NewErrParamRequired("FileName"))
	}
	if s.FileName != nil && len(*s.FileName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FileName", 1))
	}
	if s.MapName == nil {
		invalidParams.Add(request.NewErrParamRequired("MapName"))
	}
	if s.MapName != nil && len(*s.MapName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MapName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileName sets the FileName field's value.
func (s *GetMapSpritesInput) SetFileName(v string) *GetMapSpritesInput {
	s.FileName = &v
	return s
}

// SetMapName sets the MapName field's value.
func (s *GetMapSpritesInput) SetMapName(v string) *GetMapSpritesInput {
	s.MapName = &v
	return s
}

type GetMapSpritesOutput struct {
	_ struct{} `type:"structure" payload:"Blob"`

	// Contains the body of the sprite sheet or JSON offset ﬁle.
	Blob []byte `type:"blob"`

	// The content type of the sprite sheet and offsets. For example, the sprite
	// sheet content type is image/png, and the sprite offset JSON document is application/json.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`
}

// String returns the string representation
func (s GetMapSpritesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMapSpritesOutput) GoString() string {
	return s.String()
}

// SetBlob sets the Blob field's value.
func (s *GetMapSpritesOutput) SetBlob(v []byte) *GetMapSpritesOutput {
	s.Blob = v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *GetMapSpritesOutput) SetContentType(v string) *GetMapSpritesOutput {
	s.ContentType = &v
	return s
}

type GetMapStyleDescriptorInput struct {
	_ struct{} `type:"structure"`

	// The map resource to retrieve the style descriptor from.
	//
	// MapName is a required field
	MapName *string `location:"uri" locationName:"MapName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetMapStyleDescriptorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMapStyleDescriptorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMapStyleDescriptorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMapStyleDescriptorInput"}
	if s.MapName == nil {
		invalidParams.Add(request.NewErrParamRequired("MapName"))
	}
	if s.MapName != nil && len(*s.MapName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MapName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMapName sets the MapName field's value.
func (s *GetMapStyleDescriptorInput) SetMapName(v string) *GetMapStyleDescriptorInput {
	s.MapName = &v
	return s
}

type GetMapStyleDescriptorOutput struct {
	_ struct{} `type:"structure" payload:"Blob"`

	// Contains the body of the style descriptor.
	Blob []byte `type:"blob"`

	// The style descriptor's content type. For example, application/json.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`
}

// String returns the string representation
func (s GetMapStyleDescriptorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMapStyleDescriptorOutput) GoString() string {
	return s.String()
}

// SetBlob sets the Blob field's value.
func (s *GetMapStyleDescriptorOutput) SetBlob(v []byte) *GetMapStyleDescriptorOutput {
	s.Blob = v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *GetMapStyleDescriptorOutput) SetContentType(v string) *GetMapStyleDescriptorOutput {
	s.ContentType = &v
	return s
}

type GetMapTileInput struct {
	_ struct{} `type:"structure"`

	// The map resource to retrieve the map tiles from.
	//
	// MapName is a required field
	MapName *string `location:"uri" locationName:"MapName" min:"1" type:"string" required:"true"`

	// The X axis value for the map tile.
	//
	// X is a required field
	X *string `location:"uri" locationName:"X" type:"string" required:"true"`

	// The Y axis value for the map tile.
	//
	// Y is a required field
	Y *string `location:"uri" locationName:"Y" type:"string" required:"true"`

	// The zoom value for the map tile.
	//
	// Z is a required field
	Z *string `location:"uri" locationName:"Z" type:"string" required:"true"`
}

// String returns the string representation
func (s GetMapTileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMapTileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMapTileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMapTileInput"}
	if s.MapName == nil {
		invalidParams.Add(request.NewErrParamRequired("MapName"))
	}
	if s.MapName != nil && len(*s.MapName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MapName", 1))
	}
	if s.X == nil {
		invalidParams.Add(request.NewErrParamRequired("X"))
	}
	if s.X != nil && len(*s.X) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("X", 1))
	}
	if s.Y == nil {
		invalidParams.Add(request.NewErrParamRequired("Y"))
	}
	if s.Y != nil && len(*s.Y) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Y", 1))
	}
	if s.Z == nil {
		invalidParams.Add(request.NewErrParamRequired("Z"))
	}
	if s.Z != nil && len(*s.Z) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Z", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMapName sets the MapName field's value.
func (s *GetMapTileInput) SetMapName(v string) *GetMapTileInput {
	s.MapName = &v
	return s
}

// SetX sets the X field's value.
func (s *GetMapTileInput) SetX(v string) *GetMapTileInput {
	s.X = &v
	return s
}

// SetY sets the Y field's value.
func (s *GetMapTileInput) SetY(v string) *GetMapTileInput {
	s.Y = &v
	return s
}

// SetZ sets the Z field's value.
func (s *GetMapTileInput) SetZ(v string) *GetMapTileInput {
	s.Z = &v
	return s
}

type GetMapTileOutput struct {
	_ struct{} `type:"structure" payload:"Blob"`

	// Contains Mapbox Vector Tile (MVT) data.
	Blob []byte `type:"blob"`

	// The map tile's content type. For example, application/vnd.mapbox-vector-tile.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`
}

// String returns the string representation
func (s GetMapTileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMapTileOutput) GoString() string {
	return s.String()
}

// SetBlob sets the Blob field's value.
func (s *GetMapTileOutput) SetBlob(v []byte) *GetMapTileOutput {
	s.Blob = v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *GetMapTileOutput) SetContentType(v string) *GetMapTileOutput {
	s.ContentType = &v
	return s
}

// The request has failed to process because of an unknown server error, exception,
// or failure.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListGeofenceCollectionsInput struct {
	_ struct{} `type:"structure"`

	// An optional limit for the number of resources returned in a single call.
	//
	// Default value: 100
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token specifying which page of results to return in the response.
	// If no token is provided, the default page is the first page.
	//
	// Default value: null
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGeofenceCollectionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGeofenceCollectionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGeofenceCollectionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGeofenceCollectionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListGeofenceCollectionsInput) SetMaxResults(v int64) *ListGeofenceCollectionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGeofenceCollectionsInput) SetNextToken(v string) *ListGeofenceCollectionsInput {
	s.NextToken = &v
	return s
}

type ListGeofenceCollectionsOutput struct {
	_ struct{} `type:"structure"`

	// Lists the geofence collections that exist in your AWS account.
	//
	// Entries is a required field
	Entries []*ListGeofenceCollectionsResponseEntry `type:"list" required:"true"`

	// A pagination token indicating there are additional pages available. You can
	// use the token in a following request to fetch the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGeofenceCollectionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGeofenceCollectionsOutput) GoString() string {
	return s.String()
}

// SetEntries sets the Entries field's value.
func (s *ListGeofenceCollectionsOutput) SetEntries(v []*ListGeofenceCollectionsResponseEntry) *ListGeofenceCollectionsOutput {
	s.Entries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGeofenceCollectionsOutput) SetNextToken(v string) *ListGeofenceCollectionsOutput {
	s.NextToken = &v
	return s
}

// Contains the geofence collection details.
type ListGeofenceCollectionsResponseEntry struct {
	_ struct{} `type:"structure"`

	// The name of the geofence collection.
	//
	// CollectionName is a required field
	CollectionName *string `min:"1" type:"string" required:"true"`

	// The timestamp for when the geofence collection was created in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description for the geofence collection
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// Specifies a timestamp for when the resource was last updated in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format: YYYY-MM-DDThh:mm:ss.sssZ
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s ListGeofenceCollectionsResponseEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGeofenceCollectionsResponseEntry) GoString() string {
	return s.String()
}

// SetCollectionName sets the CollectionName field's value.
func (s *ListGeofenceCollectionsResponseEntry) SetCollectionName(v string) *ListGeofenceCollectionsResponseEntry {
	s.CollectionName = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *ListGeofenceCollectionsResponseEntry) SetCreateTime(v time.Time) *ListGeofenceCollectionsResponseEntry {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ListGeofenceCollectionsResponseEntry) SetDescription(v string) *ListGeofenceCollectionsResponseEntry {
	s.Description = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *ListGeofenceCollectionsResponseEntry) SetUpdateTime(v time.Time) *ListGeofenceCollectionsResponseEntry {
	s.UpdateTime = &v
	return s
}

// Contains a list of geofences stored in a given geofence collection.
type ListGeofenceResponseEntry struct {
	_ struct{} `type:"structure"`

	// The timestamp for when the geofence was stored in a geofence collection in
	// ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html) format:
	// YYYY-MM-DDThh:mm:ss.sssZ
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The geofence identifier.
	//
	// GeofenceId is a required field
	GeofenceId *string `min:"1" type:"string" required:"true"`

	// Contains the geofence geometry details describing a polygon.
	//
	// Geometry is a required field
	Geometry *GeofenceGeometry `type:"structure" required:"true"`

	// Identifies the state of the geofence. A geofence will hold one of the following
	// states:
	//
	//    * ACTIVE — The geofence has been indexed by the system.
	//
	//    * PENDING — The geofence is being processed by the system.
	//
	//    * FAILED — The geofence failed to be indexed by the system.
	//
	//    * DELETED — The geofence has been deleted from the system index.
	//
	//    * DELETING — The geofence is being deleted from the system index.
	//
	// Status is a required field
	Status *string `type:"string" required:"true"`

	// The timestamp for when the geofence was last updated in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s ListGeofenceResponseEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGeofenceResponseEntry) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *ListGeofenceResponseEntry) SetCreateTime(v time.Time) *ListGeofenceResponseEntry {
	s.CreateTime = &v
	return s
}

// SetGeofenceId sets the GeofenceId field's value.
func (s *ListGeofenceResponseEntry) SetGeofenceId(v string) *ListGeofenceResponseEntry {
	s.GeofenceId = &v
	return s
}

// SetGeometry sets the Geometry field's value.
func (s *ListGeofenceResponseEntry) SetGeometry(v *GeofenceGeometry) *ListGeofenceResponseEntry {
	s.Geometry = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListGeofenceResponseEntry) SetStatus(v string) *ListGeofenceResponseEntry {
	s.Status = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *ListGeofenceResponseEntry) SetUpdateTime(v time.Time) *ListGeofenceResponseEntry {
	s.UpdateTime = &v
	return s
}

type ListGeofencesInput struct {
	_ struct{} `type:"structure"`

	// The name of the geofence collection storing the list of geofences.
	//
	// CollectionName is a required field
	CollectionName *string `location:"uri" locationName:"CollectionName" min:"1" type:"string" required:"true"`

	// The pagination token specifying which page of results to return in the response.
	// If no token is provided, the default page is the first page.
	//
	// Default value: null
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGeofencesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGeofencesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGeofencesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGeofencesInput"}
	if s.CollectionName == nil {
		invalidParams.Add(request.NewErrParamRequired("CollectionName"))
	}
	if s.CollectionName != nil && len(*s.CollectionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CollectionName", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollectionName sets the CollectionName field's value.
func (s *ListGeofencesInput) SetCollectionName(v string) *ListGeofencesInput {
	s.CollectionName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGeofencesInput) SetNextToken(v string) *ListGeofencesInput {
	s.NextToken = &v
	return s
}

type ListGeofencesOutput struct {
	_ struct{} `type:"structure"`

	// Contains a list of geofences stored in the geofence collection.
	//
	// Entries is a required field
	Entries []*ListGeofenceResponseEntry `type:"list" required:"true"`

	// A pagination token indicating there are additional pages available. You can
	// use the token in a following request to fetch the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGeofencesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGeofencesOutput) GoString() string {
	return s.String()
}

// SetEntries sets the Entries field's value.
func (s *ListGeofencesOutput) SetEntries(v []*ListGeofenceResponseEntry) *ListGeofencesOutput {
	s.Entries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGeofencesOutput) SetNextToken(v string) *ListGeofencesOutput {
	s.NextToken = &v
	return s
}

type ListMapsInput struct {
	_ struct{} `type:"structure"`

	// An optional limit for the number of resources returned in a single call.
	//
	// Default value: 100
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token specifying which page of results to return in the response.
	// If no token is provided, the default page is the first page.
	//
	// Default value: null
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListMapsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMapsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMapsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMapsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMapsInput) SetMaxResults(v int64) *ListMapsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMapsInput) SetNextToken(v string) *ListMapsInput {
	s.NextToken = &v
	return s
}

type ListMapsOutput struct {
	_ struct{} `type:"structure"`

	// Contains a list of maps in your AWS account
	//
	// Entries is a required field
	Entries []*ListMapsResponseEntry `type:"list" required:"true"`

	// A pagination token indicating there are additional pages available. You can
	// use the token in a following request to fetch the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListMapsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMapsOutput) GoString() string {
	return s.String()
}

// SetEntries sets the Entries field's value.
func (s *ListMapsOutput) SetEntries(v []*ListMapsResponseEntry) *ListMapsOutput {
	s.Entries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMapsOutput) SetNextToken(v string) *ListMapsOutput {
	s.NextToken = &v
	return s
}

// Contains details of an existing map resource in your AWS account.
type ListMapsResponseEntry struct {
	_ struct{} `type:"structure"`

	// The timestamp for when the map resource was created in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Specifies the data provider for the associated map tiles.
	//
	// DataSource is a required field
	DataSource *string `type:"string" required:"true"`

	// The description for the map resource.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The name of the associated map resource.
	//
	// MapName is a required field
	MapName *string `min:"1" type:"string" required:"true"`

	// The timestamp for when the map resource was last updated in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s ListMapsResponseEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMapsResponseEntry) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *ListMapsResponseEntry) SetCreateTime(v time.Time) *ListMapsResponseEntry {
	s.CreateTime = &v
	return s
}

// SetDataSource sets the DataSource field's value.
func (s *ListMapsResponseEntry) SetDataSource(v string) *ListMapsResponseEntry {
	s.DataSource = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ListMapsResponseEntry) SetDescription(v string) *ListMapsResponseEntry {
	s.Description = &v
	return s
}

// SetMapName sets the MapName field's value.
func (s *ListMapsResponseEntry) SetMapName(v string) *ListMapsResponseEntry {
	s.MapName = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *ListMapsResponseEntry) SetUpdateTime(v time.Time) *ListMapsResponseEntry {
	s.UpdateTime = &v
	return s
}

type ListPlaceIndexesInput struct {
	_ struct{} `type:"structure"`

	// An optional limit for the maximum number of results returned in a single
	// call.
	//
	// Default value: 100
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token specifying which page of results to return in the response.
	// If no token is provided, the default page is the first page.
	//
	// Default value: null
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListPlaceIndexesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPlaceIndexesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPlaceIndexesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPlaceIndexesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPlaceIndexesInput) SetMaxResults(v int64) *ListPlaceIndexesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPlaceIndexesInput) SetNextToken(v string) *ListPlaceIndexesInput {
	s.NextToken = &v
	return s
}

type ListPlaceIndexesOutput struct {
	_ struct{} `type:"structure"`

	// Lists the Place index resources that exist in your AWS account
	//
	// Entries is a required field
	Entries []*ListPlaceIndexesResponseEntry `type:"list" required:"true"`

	// A pagination token indicating there are additional pages available. You can
	// use the token in a following request to fetch the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListPlaceIndexesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPlaceIndexesOutput) GoString() string {
	return s.String()
}

// SetEntries sets the Entries field's value.
func (s *ListPlaceIndexesOutput) SetEntries(v []*ListPlaceIndexesResponseEntry) *ListPlaceIndexesOutput {
	s.Entries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPlaceIndexesOutput) SetNextToken(v string) *ListPlaceIndexesOutput {
	s.NextToken = &v
	return s
}

// A Place index resource listed in your AWS account.
type ListPlaceIndexesResponseEntry struct {
	_ struct{} `type:"structure"`

	// The timestamp for when the Place index resource was created in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The data provider of geospatial data.
	//
	// DataSource is a required field
	DataSource *string `type:"string" required:"true"`

	// The optional description for the Place index resource.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The name of the Place index resource.
	//
	// IndexName is a required field
	IndexName *string `min:"1" type:"string" required:"true"`

	// The timestamp for when the Place index resource was last updated in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s ListPlaceIndexesResponseEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPlaceIndexesResponseEntry) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *ListPlaceIndexesResponseEntry) SetCreateTime(v time.Time) *ListPlaceIndexesResponseEntry {
	s.CreateTime = &v
	return s
}

// SetDataSource sets the DataSource field's value.
func (s *ListPlaceIndexesResponseEntry) SetDataSource(v string) *ListPlaceIndexesResponseEntry {
	s.DataSource = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ListPlaceIndexesResponseEntry) SetDescription(v string) *ListPlaceIndexesResponseEntry {
	s.Description = &v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *ListPlaceIndexesResponseEntry) SetIndexName(v string) *ListPlaceIndexesResponseEntry {
	s.IndexName = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *ListPlaceIndexesResponseEntry) SetUpdateTime(v time.Time) *ListPlaceIndexesResponseEntry {
	s.UpdateTime = &v
	return s
}

type ListTrackerConsumersInput struct {
	_ struct{} `type:"structure"`

	// An optional limit for the number of resources returned in a single call.
	//
	// Default value: 100
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token specifying which page of results to return in the response.
	// If no token is provided, the default page is the first page.
	//
	// Default value: null
	NextToken *string `min:"1" type:"string"`

	// The tracker resource whose associated geofence collections you want to list.
	//
	// TrackerName is a required field
	TrackerName *string `location:"uri" locationName:"TrackerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTrackerConsumersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTrackerConsumersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTrackerConsumersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTrackerConsumersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.TrackerName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrackerName"))
	}
	if s.TrackerName != nil && len(*s.TrackerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrackerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTrackerConsumersInput) SetMaxResults(v int64) *ListTrackerConsumersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTrackerConsumersInput) SetNextToken(v string) *ListTrackerConsumersInput {
	s.NextToken = &v
	return s
}

// SetTrackerName sets the TrackerName field's value.
func (s *ListTrackerConsumersInput) SetTrackerName(v string) *ListTrackerConsumersInput {
	s.TrackerName = &v
	return s
}

type ListTrackerConsumersOutput struct {
	_ struct{} `type:"structure"`

	// Contains the list of geofence collection ARNs associated to the tracker resource.
	//
	// ConsumerArns is a required field
	ConsumerArns []*string `type:"list" required:"true"`

	// A pagination token indicating there are additional pages available. You can
	// use the token in a following request to fetch the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListTrackerConsumersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTrackerConsumersOutput) GoString() string {
	return s.String()
}

// SetConsumerArns sets the ConsumerArns field's value.
func (s *ListTrackerConsumersOutput) SetConsumerArns(v []*string) *ListTrackerConsumersOutput {
	s.ConsumerArns = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTrackerConsumersOutput) SetNextToken(v string) *ListTrackerConsumersOutput {
	s.NextToken = &v
	return s
}

type ListTrackersInput struct {
	_ struct{} `type:"structure"`

	// An optional limit for the number of resources returned in a single call.
	//
	// Default value: 100
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token specifying which page of results to return in the response.
	// If no token is provided, the default page is the first page.
	//
	// Default value: null
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListTrackersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTrackersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTrackersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTrackersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTrackersInput) SetMaxResults(v int64) *ListTrackersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTrackersInput) SetNextToken(v string) *ListTrackersInput {
	s.NextToken = &v
	return s
}

type ListTrackersOutput struct {
	_ struct{} `type:"structure"`

	// Contains tracker resources in your AWS account. Details include tracker name,
	// description and timestamps for when the tracker was created and last updated.
	//
	// Entries is a required field
	Entries []*ListTrackersResponseEntry `type:"list" required:"true"`

	// A pagination token indicating there are additional pages available. You can
	// use the token in a following request to fetch the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListTrackersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTrackersOutput) GoString() string {
	return s.String()
}

// SetEntries sets the Entries field's value.
func (s *ListTrackersOutput) SetEntries(v []*ListTrackersResponseEntry) *ListTrackersOutput {
	s.Entries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTrackersOutput) SetNextToken(v string) *ListTrackersOutput {
	s.NextToken = &v
	return s
}

// Contains the tracker resource details.
type ListTrackersResponseEntry struct {
	_ struct{} `type:"structure"`

	// The timestamp for when the tracker resource was created in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description for the tracker resource.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The name of the tracker resource.
	//
	// TrackerName is a required field
	TrackerName *string `min:"1" type:"string" required:"true"`

	// The timestamp for when the position was detected and sampled in ISO 8601
	// (https://www.iso.org/iso-8601-date-and-time-format.html) format: YYYY-MM-DDThh:mm:ss.sssZ.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s ListTrackersResponseEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTrackersResponseEntry) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *ListTrackersResponseEntry) SetCreateTime(v time.Time) *ListTrackersResponseEntry {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ListTrackersResponseEntry) SetDescription(v string) *ListTrackersResponseEntry {
	s.Description = &v
	return s
}

// SetTrackerName sets the TrackerName field's value.
func (s *ListTrackersResponseEntry) SetTrackerName(v string) *ListTrackersResponseEntry {
	s.TrackerName = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *ListTrackersResponseEntry) SetUpdateTime(v time.Time) *ListTrackersResponseEntry {
	s.UpdateTime = &v
	return s
}

// Specifies the map tile style selected from an available provider.
type MapConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies the map style selected from an available data provider.
	//
	// Valid styles: VectorEsriStreets, VectorEsriTopographic, VectorEsriNavigation,
	// VectorEsriDarkGrayCanvas, VectorEsriLightGrayCanvas, VectorHereBerlin.
	//
	// When using HERE as your data provider, and selecting the Style VectorHereBerlin,
	// you may not use HERE Maps for Asset Management. See the AWS Service Terms
	// (https://aws.amazon.com/service-terms/) for Amazon Location Service.
	//
	// Style is a required field
	Style *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s MapConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MapConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MapConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MapConfiguration"}
	if s.Style == nil {
		invalidParams.Add(request.NewErrParamRequired("Style"))
	}
	if s.Style != nil && len(*s.Style) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Style", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStyle sets the Style field's value.
func (s *MapConfiguration) SetStyle(v string) *MapConfiguration {
	s.Style = &v
	return s
}

// Contains details about addresses or points of interest that match the search
// criteria.
type Place struct {
	_ struct{} `type:"structure"`

	// The numerical portion of an address, such as a building number.
	AddressNumber *string `type:"string"`

	// A country/region specified using ISO 3166 (https://www.iso.org/iso-3166-country-codes.html)
	// 3-digit country/region code. For example, CAN.
	Country *string `type:"string"`

	// Places uses a point geometry to specify a location or a Place.
	//
	// Geometry is a required field
	Geometry *PlaceGeometry `type:"structure" required:"true"`

	// The full name and address of the point of interest such as a city, region,
	// or country. For example, 123 Any Street, Any Town, USA.
	Label *string `type:"string"`

	// A name for a local area, such as a city or town name. For example, Toronto.
	Municipality *string `type:"string"`

	// The name of a community district. For example, Downtown.
	Neighborhood *string `type:"string"`

	// A group of numbers and letters in a country-specific format, which accompanies
	// the address for the purpose of identifying a location.
	PostalCode *string `type:"string"`

	// A name for an area or geographical division, such as a province or state
	// name. For example, British Columbia.
	Region *string `type:"string"`

	// The name for a street or a road to identify a location. For example, Main
	// Street.
	Street *string `type:"string"`

	// A country, or an area that's part of a larger region . For example, Metro
	// Vancouver.
	SubRegion *string `type:"string"`
}

// String returns the string representation
func (s Place) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Place) GoString() string {
	return s.String()
}

// SetAddressNumber sets the AddressNumber field's value.
func (s *Place) SetAddressNumber(v string) *Place {
	s.AddressNumber = &v
	return s
}

// SetCountry sets the Country field's value.
func (s *Place) SetCountry(v string) *Place {
	s.Country = &v
	return s
}

// SetGeometry sets the Geometry field's value.
func (s *Place) SetGeometry(v *PlaceGeometry) *Place {
	s.Geometry = v
	return s
}

// SetLabel sets the Label field's value.
func (s *Place) SetLabel(v string) *Place {
	s.Label = &v
	return s
}

// SetMunicipality sets the Municipality field's value.
func (s *Place) SetMunicipality(v string) *Place {
	s.Municipality = &v
	return s
}

// SetNeighborhood sets the Neighborhood field's value.
func (s *Place) SetNeighborhood(v string) *Place {
	s.Neighborhood = &v
	return s
}

// SetPostalCode sets the PostalCode field's value.
func (s *Place) SetPostalCode(v string) *Place {
	s.PostalCode = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *Place) SetRegion(v string) *Place {
	s.Region = &v
	return s
}

// SetStreet sets the Street field's value.
func (s *Place) SetStreet(v string) *Place {
	s.Street = &v
	return s
}

// SetSubRegion sets the SubRegion field's value.
func (s *Place) SetSubRegion(v string) *Place {
	s.SubRegion = &v
	return s
}

// Places uses a point geometry to specify a location or a Place.
type PlaceGeometry struct {
	_ struct{} `type:"structure"`

	// A single point geometry specifies a location for a Place using WGS 84 (https://gisgeography.com/wgs84-world-geodetic-system/)
	// coordinates:
	//
	//    * x — Specifies the x coordinate or longitude.
	//
	//    * y — Specifies the y coordinate or latitude.
	Point []*float64 `min:"2" type:"list" sensitive:"true"`
}

// String returns the string representation
func (s PlaceGeometry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PlaceGeometry) GoString() string {
	return s.String()
}

// SetPoint sets the Point field's value.
func (s *PlaceGeometry) SetPoint(v []*float64) *PlaceGeometry {
	s.Point = v
	return s
}

type PutGeofenceInput struct {
	_ struct{} `type:"structure"`

	// The geofence collection to store the geofence in.
	//
	// CollectionName is a required field
	CollectionName *string `location:"uri" locationName:"CollectionName" min:"1" type:"string" required:"true"`

	// An identifier for the geofence. For example, ExampleGeofence-1.
	//
	// GeofenceId is a required field
	GeofenceId *string `location:"uri" locationName:"GeofenceId" min:"1" type:"string" required:"true"`

	// Contains the polygon details to specify the position of the geofence.
	//
	// Geometry is a required field
	Geometry *GeofenceGeometry `type:"structure" required:"true"`
}

// String returns the string representation
func (s PutGeofenceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutGeofenceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutGeofenceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutGeofenceInput"}
	if s.CollectionName == nil {
		invalidParams.Add(request.NewErrParamRequired("CollectionName"))
	}
	if s.CollectionName != nil && len(*s.CollectionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CollectionName", 1))
	}
	if s.GeofenceId == nil {
		invalidParams.Add(request.NewErrParamRequired("GeofenceId"))
	}
	if s.GeofenceId != nil && len(*s.GeofenceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GeofenceId", 1))
	}
	if s.Geometry == nil {
		invalidParams.Add(request.NewErrParamRequired("Geometry"))
	}
	if s.Geometry != nil {
		if err := s.Geometry.Validate(); err != nil {
			invalidParams.AddNested("Geometry", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollectionName sets the CollectionName field's value.
func (s *PutGeofenceInput) SetCollectionName(v string) *PutGeofenceInput {
	s.CollectionName = &v
	return s
}

// SetGeofenceId sets the GeofenceId field's value.
func (s *PutGeofenceInput) SetGeofenceId(v string) *PutGeofenceInput {
	s.GeofenceId = &v
	return s
}

// SetGeometry sets the Geometry field's value.
func (s *PutGeofenceInput) SetGeometry(v *GeofenceGeometry) *PutGeofenceInput {
	s.Geometry = v
	return s
}

type PutGeofenceOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp for when the geofence was created in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ
	//
	// CreateTime is a required field
	CreateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The geofence identifier entered in the request.
	//
	// GeofenceId is a required field
	GeofenceId *string `min:"1" type:"string" required:"true"`

	// The timestamp for when the geofence was last updated in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format: YYYY-MM-DDThh:mm:ss.sssZ
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation
func (s PutGeofenceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutGeofenceOutput) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *PutGeofenceOutput) SetCreateTime(v time.Time) *PutGeofenceOutput {
	s.CreateTime = &v
	return s
}

// SetGeofenceId sets the GeofenceId field's value.
func (s *PutGeofenceOutput) SetGeofenceId(v string) *PutGeofenceOutput {
	s.GeofenceId = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *PutGeofenceOutput) SetUpdateTime(v time.Time) *PutGeofenceOutput {
	s.UpdateTime = &v
	return s
}

// The resource that you've entered was not found in your AWS account.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Specifies a single point of interest, or Place as a result of a search query
// obtained from a dataset configured in the Place index Resource.
type SearchForPositionResult struct {
	_ struct{} `type:"structure"`

	// Contains details about the relevant point of interest.
	//
	// Place is a required field
	Place *Place `type:"structure" required:"true"`
}

// String returns the string representation
func (s SearchForPositionResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchForPositionResult) GoString() string {
	return s.String()
}

// SetPlace sets the Place field's value.
func (s *SearchForPositionResult) SetPlace(v *Place) *SearchForPositionResult {
	s.Place = v
	return s
}

// Contains relevant Places returned by calling SearchPlaceIndexForText.
type SearchForTextResult struct {
	_ struct{} `type:"structure"`

	// Contains details about the relevant point of interest.
	//
	// Place is a required field
	Place *Place `type:"structure" required:"true"`
}

// String returns the string representation
func (s SearchForTextResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchForTextResult) GoString() string {
	return s.String()
}

// SetPlace sets the Place field's value.
func (s *SearchForTextResult) SetPlace(v *Place) *SearchForTextResult {
	s.Place = v
	return s
}

type SearchPlaceIndexForPositionInput struct {
	_ struct{} `type:"structure"`

	// The name of the Place index resource you want to use for the search.
	//
	// IndexName is a required field
	IndexName *string `location:"uri" locationName:"IndexName" min:"1" type:"string" required:"true"`

	// An optional paramer. The maximum number of results returned per request.
	//
	// Default value: 50
	MaxResults *int64 `min:"1" type:"integer"`

	// Specifies a coordinate for the query defined by a longitude, and latitude.
	//
	//    * The first position is the X coordinate, or longitude.
	//
	//    * The second position is the Y coordinate, or latitude.
	//
	// For example, position=xLongitude&position=yLatitude .
	//
	// Position is a required field
	Position []*float64 `min:"2" type:"list" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s SearchPlaceIndexForPositionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchPlaceIndexForPositionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchPlaceIndexForPositionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchPlaceIndexForPositionInput"}
	if s.IndexName == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexName"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Position == nil {
		invalidParams.Add(request.NewErrParamRequired("Position"))
	}
	if s.Position != nil && len(s.Position) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Position", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndexName sets the IndexName field's value.
func (s *SearchPlaceIndexForPositionInput) SetIndexName(v string) *SearchPlaceIndexForPositionInput {
	s.IndexName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchPlaceIndexForPositionInput) SetMaxResults(v int64) *SearchPlaceIndexForPositionInput {
	s.MaxResults = &v
	return s
}

// SetPosition sets the Position field's value.
func (s *SearchPlaceIndexForPositionInput) SetPosition(v []*float64) *SearchPlaceIndexForPositionInput {
	s.Position = v
	return s
}

type SearchPlaceIndexForPositionOutput struct {
	_ struct{} `type:"structure"`

	// Returns a list of Places closest to the specified position. Each result contains
	// additional information about the Places returned.
	//
	// Results is a required field
	Results []*SearchForPositionResult `type:"list" required:"true"`

	// Contains a summary of the request.
	//
	// Summary is a required field
	Summary *SearchPlaceIndexForPositionSummary `type:"structure" required:"true"`
}

// String returns the string representation
func (s SearchPlaceIndexForPositionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchPlaceIndexForPositionOutput) GoString() string {
	return s.String()
}

// SetResults sets the Results field's value.
func (s *SearchPlaceIndexForPositionOutput) SetResults(v []*SearchForPositionResult) *SearchPlaceIndexForPositionOutput {
	s.Results = v
	return s
}

// SetSummary sets the Summary field's value.
func (s *SearchPlaceIndexForPositionOutput) SetSummary(v *SearchPlaceIndexForPositionSummary) *SearchPlaceIndexForPositionOutput {
	s.Summary = v
	return s
}

// A summary of the reverse geocoding request sent using SearchPlaceIndexForPosition.
type SearchPlaceIndexForPositionSummary struct {
	_ struct{} `type:"structure"`

	// The data provider of geospatial data for the Place index resource.
	//
	// DataSource is a required field
	DataSource *string `type:"string" required:"true"`

	// An optional parameter. The maximum number of results returned per request.
	//
	// Default value: 50
	MaxResults *int64 `min:"1" type:"integer"`

	// The position given in the reverse geocoding request.
	//
	// Position is a required field
	Position []*float64 `min:"2" type:"list" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s SearchPlaceIndexForPositionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchPlaceIndexForPositionSummary) GoString() string {
	return s.String()
}

// SetDataSource sets the DataSource field's value.
func (s *SearchPlaceIndexForPositionSummary) SetDataSource(v string) *SearchPlaceIndexForPositionSummary {
	s.DataSource = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchPlaceIndexForPositionSummary) SetMaxResults(v int64) *SearchPlaceIndexForPositionSummary {
	s.MaxResults = &v
	return s
}

// SetPosition sets the Position field's value.
func (s *SearchPlaceIndexForPositionSummary) SetPosition(v []*float64) *SearchPlaceIndexForPositionSummary {
	s.Position = v
	return s
}

type SearchPlaceIndexForTextInput struct {
	_ struct{} `type:"structure"`

	// Searches for results closest to the given position. An optional parameter
	// defined by longitude, and latitude.
	//
	//    * The first bias position is the X coordinate, or longitude.
	//
	//    * The second bias position is the Y coordinate, or latitude.
	//
	// For example, bias=xLongitude&bias=yLatitude.
	BiasPosition []*float64 `min:"2" type:"list" sensitive:"true"`

	// Filters the results by returning only Places within the provided bounding
	// box. An optional parameter.
	//
	// The first 2 bbox parameters describe the lower southwest corner:
	//
	//    * The first bbox position is the X coordinate or longitude of the lower
	//    southwest corner.
	//
	//    * The second bbox position is the Y coordinate or latitude of the lower
	//    southwest corner.
	//
	// For example, bbox=xLongitudeSW&bbox=yLatitudeSW.
	//
	// The next bbox parameters describe the upper northeast corner:
	//
	//    * The third bbox position is the X coordinate, or longitude of the upper
	//    northeast corner.
	//
	//    * The fourth bbox position is the Y coordinate, or longitude of the upper
	//    northeast corner.
	//
	// For example, bbox=xLongitudeNE&bbox=yLatitudeNE
	FilterBBox []*float64 `min:"4" type:"list" sensitive:"true"`

	// Limits the search to the given a list of countries/regions. An optional parameter.
	//
	//    * Use the ISO 3166 (https://www.iso.org/iso-3166-country-codes.html) 3-digit
	//    country code. For example, Australia uses three upper-case characters:
	//    AUS.
	FilterCountries []*string `min:"1" type:"list"`

	// The name of the Place index resource you want to use for the search.
	//
	// IndexName is a required field
	IndexName *string `location:"uri" locationName:"IndexName" min:"1" type:"string" required:"true"`

	// An optional parameter. The maximum number of results returned per request.
	//
	// The default: 50
	MaxResults *int64 `min:"1" type:"integer"`

	// The address, name, city, or region to be used in the search. In free-form
	// text format. For example, 123 Any Street.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s SearchPlaceIndexForTextInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchPlaceIndexForTextInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchPlaceIndexForTextInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchPlaceIndexForTextInput"}
	if s.BiasPosition != nil && len(s.BiasPosition) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("BiasPosition", 2))
	}
	if s.FilterBBox != nil && len(s.FilterBBox) < 4 {
		invalidParams.Add(request.NewErrParamMinLen("FilterBBox", 4))
	}
	if s.FilterCountries != nil && len(s.FilterCountries) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FilterCountries", 1))
	}
	if s.IndexName == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexName"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBiasPosition sets the BiasPosition field's value.
func (s *SearchPlaceIndexForTextInput) SetBiasPosition(v []*float64) *SearchPlaceIndexForTextInput {
	s.BiasPosition = v
	return s
}

// SetFilterBBox sets the FilterBBox field's value.
func (s *SearchPlaceIndexForTextInput) SetFilterBBox(v []*float64) *SearchPlaceIndexForTextInput {
	s.FilterBBox = v
	return s
}

// SetFilterCountries sets the FilterCountries field's value.
func (s *SearchPlaceIndexForTextInput) SetFilterCountries(v []*string) *SearchPlaceIndexForTextInput {
	s.FilterCountries = v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *SearchPlaceIndexForTextInput) SetIndexName(v string) *SearchPlaceIndexForTextInput {
	s.IndexName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchPlaceIndexForTextInput) SetMaxResults(v int64) *SearchPlaceIndexForTextInput {
	s.MaxResults = &v
	return s
}

// SetText sets the Text field's value.
func (s *SearchPlaceIndexForTextInput) SetText(v string) *SearchPlaceIndexForTextInput {
	s.Text = &v
	return s
}

type SearchPlaceIndexForTextOutput struct {
	_ struct{} `type:"structure"`

	// A list of Places closest to the specified position. Each result contains
	// additional information about the specific point of interest.
	//
	// Results is a required field
	Results []*SearchForTextResult `type:"list" required:"true"`

	// Contains a summary of the request. Contains the BiasPosition, DataSource,
	// FilterBBox, FilterCountries, MaxResults, ResultBBox, and Text.
	//
	// Summary is a required field
	Summary *SearchPlaceIndexForTextSummary `type:"structure" required:"true"`
}

// String returns the string representation
func (s SearchPlaceIndexForTextOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchPlaceIndexForTextOutput) GoString() string {
	return s.String()
}

// SetResults sets the Results field's value.
func (s *SearchPlaceIndexForTextOutput) SetResults(v []*SearchForTextResult) *SearchPlaceIndexForTextOutput {
	s.Results = v
	return s
}

// SetSummary sets the Summary field's value.
func (s *SearchPlaceIndexForTextOutput) SetSummary(v *SearchPlaceIndexForTextSummary) *SearchPlaceIndexForTextOutput {
	s.Summary = v
	return s
}

// A summary of the geocoding request sent using SearchPlaceIndexForText.
type SearchPlaceIndexForTextSummary struct {
	_ struct{} `type:"structure"`

	// Contains the coordinates for the bias position entered in the geocoding request.
	BiasPosition []*float64 `min:"2" type:"list" sensitive:"true"`

	// The data provider of geospatial data for the Place index resource.
	//
	// DataSource is a required field
	DataSource *string `type:"string" required:"true"`

	// Contains the coordinates for the optional bounding box coordinated entered
	// in the geocoding request.
	FilterBBox []*float64 `min:"4" type:"list" sensitive:"true"`

	// Contains the country filter entered in the geocoding request.
	FilterCountries []*string `min:"1" type:"list"`

	// Contains the maximum number of results indicated for the request.
	MaxResults *int64 `min:"1" type:"integer"`

	// A bounding box that contains the search results within the specified area
	// indicated by FilterBBox. A subset of bounding box specified using FilterBBox.
	ResultBBox []*float64 `min:"4" type:"list" sensitive:"true"`

	// The address, name, city or region to be used in the geocoding request. In
	// free-form text format. For example, Vancouver.
	//
	// Text is a required field
	Text *string `type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s SearchPlaceIndexForTextSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchPlaceIndexForTextSummary) GoString() string {
	return s.String()
}

// SetBiasPosition sets the BiasPosition field's value.
func (s *SearchPlaceIndexForTextSummary) SetBiasPosition(v []*float64) *SearchPlaceIndexForTextSummary {
	s.BiasPosition = v
	return s
}

// SetDataSource sets the DataSource field's value.
func (s *SearchPlaceIndexForTextSummary) SetDataSource(v string) *SearchPlaceIndexForTextSummary {
	s.DataSource = &v
	return s
}

// SetFilterBBox sets the FilterBBox field's value.
func (s *SearchPlaceIndexForTextSummary) SetFilterBBox(v []*float64) *SearchPlaceIndexForTextSummary {
	s.FilterBBox = v
	return s
}

// SetFilterCountries sets the FilterCountries field's value.
func (s *SearchPlaceIndexForTextSummary) SetFilterCountries(v []*string) *SearchPlaceIndexForTextSummary {
	s.FilterCountries = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchPlaceIndexForTextSummary) SetMaxResults(v int64) *SearchPlaceIndexForTextSummary {
	s.MaxResults = &v
	return s
}

// SetResultBBox sets the ResultBBox field's value.
func (s *SearchPlaceIndexForTextSummary) SetResultBBox(v []*float64) *SearchPlaceIndexForTextSummary {
	s.ResultBBox = v
	return s
}

// SetText sets the Text field's value.
func (s *SearchPlaceIndexForTextSummary) SetText(v string) *SearchPlaceIndexForTextSummary {
	s.Text = &v
	return s
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The input failed to meet the constraints specified by the AWS service.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The field where the invalid entry was detected.
	//
	// FieldList is a required field
	FieldList []*ValidationExceptionField `locationName:"fieldList" type:"list" required:"true"`

	Message_ *string `locationName:"message" type:"string"`

	// A message with the reason for the validation exception error.
	//
	// Reason is a required field
	Reason *string `locationName:"reason" type:"string" required:"true" enum:"ValidationExceptionReason"`
}

// String returns the string representation
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The input failed to meet the constraints specified by the AWS service in
// a specified field.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// A message with the reason for the validation exception error.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// The field name where the invalid entry was detected.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

const (
	// BatchItemErrorCodeAccessDeniedError is a BatchItemErrorCode enum value
	BatchItemErrorCodeAccessDeniedError = "AccessDeniedError"

	// BatchItemErrorCodeConflictError is a BatchItemErrorCode enum value
	BatchItemErrorCodeConflictError = "ConflictError"

	// BatchItemErrorCodeInternalServerError is a BatchItemErrorCode enum value
	BatchItemErrorCodeInternalServerError = "InternalServerError"

	// BatchItemErrorCodeResourceNotFoundError is a BatchItemErrorCode enum value
	BatchItemErrorCodeResourceNotFoundError = "ResourceNotFoundError"

	// BatchItemErrorCodeThrottlingError is a BatchItemErrorCode enum value
	BatchItemErrorCodeThrottlingError = "ThrottlingError"

	// BatchItemErrorCodeValidationError is a BatchItemErrorCode enum value
	BatchItemErrorCodeValidationError = "ValidationError"
)

// BatchItemErrorCode_Values returns all elements of the BatchItemErrorCode enum
func BatchItemErrorCode_Values() []string {
	return []string{
		BatchItemErrorCodeAccessDeniedError,
		BatchItemErrorCodeConflictError,
		BatchItemErrorCodeInternalServerError,
		BatchItemErrorCodeResourceNotFoundError,
		BatchItemErrorCodeThrottlingError,
		BatchItemErrorCodeValidationError,
	}
}

const (
	// IntendedUseSingleUse is a IntendedUse enum value
	IntendedUseSingleUse = "SingleUse"

	// IntendedUseStorage is a IntendedUse enum value
	IntendedUseStorage = "Storage"
)

// IntendedUse_Values returns all elements of the IntendedUse enum
func IntendedUse_Values() []string {
	return []string{
		IntendedUseSingleUse,
		IntendedUseStorage,
	}
}

const (
	// PricingPlanRequestBasedUsage is a PricingPlan enum value
	PricingPlanRequestBasedUsage = "RequestBasedUsage"

	// PricingPlanMobileAssetTracking is a PricingPlan enum value
	PricingPlanMobileAssetTracking = "MobileAssetTracking"

	// PricingPlanMobileAssetManagement is a PricingPlan enum value
	PricingPlanMobileAssetManagement = "MobileAssetManagement"
)

// PricingPlan_Values returns all elements of the PricingPlan enum
func PricingPlan_Values() []string {
	return []string{
		PricingPlanRequestBasedUsage,
		PricingPlanMobileAssetTracking,
		PricingPlanMobileAssetManagement,
	}
}

const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "UnknownOperation"

	// ValidationExceptionReasonMissing is a ValidationExceptionReason enum value
	ValidationExceptionReasonMissing = "Missing"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "CannotParse"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "FieldValidationFailed"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "Other"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonMissing,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
	}
}
