// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package networkmonitor

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateMonitor = "CreateMonitor"

// CreateMonitorRequest generates a "aws/request.Request" representing the
// client's request for the CreateMonitor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMonitor for more information on using the CreateMonitor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateMonitorRequest method.
//	req, resp := client.CreateMonitorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/networkmonitor-2023-08-01/CreateMonitor
func (c *NetworkMonitor) CreateMonitorRequest(input *CreateMonitorInput) (req *request.Request, output *CreateMonitorOutput) {
	op := &request.Operation{
		Name:       opCreateMonitor,
		HTTPMethod: "POST",
		HTTPPath:   "/monitors",
	}

	if input == nil {
		input = &CreateMonitorInput{}
	}

	output = &CreateMonitorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMonitor API operation for Amazon CloudWatch Network Monitor.
//
// Creates a monitor between a source subnet and destination IP address. Within
// a monitor you'll create one or more probes that monitor network traffic between
// your source Amazon Web Services VPC subnets and your destination IP addresses.
// Each probe then aggregates and sends metrics to Amazon CloudWatch.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Network Monitor's
// API operation CreateMonitor for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling
//
//   - ValidationException
//     One of the parameters for the request is not valid.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ConflictException
//     This operation attempted to create a resource that already exists.
//
//   - ServiceQuotaExceededException
//     This request exceeds a service quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/networkmonitor-2023-08-01/CreateMonitor
func (c *NetworkMonitor) CreateMonitor(input *CreateMonitorInput) (*CreateMonitorOutput, error) {
	req, out := c.CreateMonitorRequest(input)
	return out, req.Send()
}

// CreateMonitorWithContext is the same as CreateMonitor with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMonitor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkMonitor) CreateMonitorWithContext(ctx aws.Context, input *CreateMonitorInput, opts ...request.Option) (*CreateMonitorOutput, error) {
	req, out := c.CreateMonitorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProbe = "CreateProbe"

// CreateProbeRequest generates a "aws/request.Request" representing the
// client's request for the CreateProbe operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProbe for more information on using the CreateProbe
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateProbeRequest method.
//	req, resp := client.CreateProbeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/networkmonitor-2023-08-01/CreateProbe
func (c *NetworkMonitor) CreateProbeRequest(input *CreateProbeInput) (req *request.Request, output *CreateProbeOutput) {
	op := &request.Operation{
		Name:       opCreateProbe,
		HTTPMethod: "POST",
		HTTPPath:   "/monitors/{monitorName}/probes",
	}

	if input == nil {
		input = &CreateProbeInput{}
	}

	output = &CreateProbeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProbe API operation for Amazon CloudWatch Network Monitor.
//
// Create a probe within a monitor. Once you create a probe, and it begins monitoring
// your network traffic, you'll incur billing charges for that probe.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Network Monitor's
// API operation CreateProbe for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The specified resource does not exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling
//
//   - ValidationException
//     One of the parameters for the request is not valid.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ServiceQuotaExceededException
//     This request exceeds a service quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/networkmonitor-2023-08-01/CreateProbe
func (c *NetworkMonitor) CreateProbe(input *CreateProbeInput) (*CreateProbeOutput, error) {
	req, out := c.CreateProbeRequest(input)
	return out, req.Send()
}

// CreateProbeWithContext is the same as CreateProbe with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProbe for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkMonitor) CreateProbeWithContext(ctx aws.Context, input *CreateProbeInput, opts ...request.Option) (*CreateProbeOutput, error) {
	req, out := c.CreateProbeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMonitor = "DeleteMonitor"

// DeleteMonitorRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMonitor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMonitor for more information on using the DeleteMonitor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteMonitorRequest method.
//	req, resp := client.DeleteMonitorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/networkmonitor-2023-08-01/DeleteMonitor
func (c *NetworkMonitor) DeleteMonitorRequest(input *DeleteMonitorInput) (req *request.Request, output *DeleteMonitorOutput) {
	op := &request.Operation{
		Name:       opDeleteMonitor,
		HTTPMethod: "DELETE",
		HTTPPath:   "/monitors/{monitorName}",
	}

	if input == nil {
		input = &DeleteMonitorInput{}
	}

	output = &DeleteMonitorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteMonitor API operation for Amazon CloudWatch Network Monitor.
//
// Deletes a specified monitor.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Network Monitor's
// API operation DeleteMonitor for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The specified resource does not exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling
//
//   - ValidationException
//     One of the parameters for the request is not valid.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/networkmonitor-2023-08-01/DeleteMonitor
func (c *NetworkMonitor) DeleteMonitor(input *DeleteMonitorInput) (*DeleteMonitorOutput, error) {
	req, out := c.DeleteMonitorRequest(input)
	return out, req.Send()
}

// DeleteMonitorWithContext is the same as DeleteMonitor with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMonitor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkMonitor) DeleteMonitorWithContext(ctx aws.Context, input *DeleteMonitorInput, opts ...request.Option) (*DeleteMonitorOutput, error) {
	req, out := c.DeleteMonitorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProbe = "DeleteProbe"

// DeleteProbeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProbe operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProbe for more information on using the DeleteProbe
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteProbeRequest method.
//	req, resp := client.DeleteProbeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/networkmonitor-2023-08-01/DeleteProbe
func (c *NetworkMonitor) DeleteProbeRequest(input *DeleteProbeInput) (req *request.Request, output *DeleteProbeOutput) {
	op := &request.Operation{
		Name:       opDeleteProbe,
		HTTPMethod: "DELETE",
		HTTPPath:   "/monitors/{monitorName}/probes/{probeId}",
	}

	if input == nil {
		input = &DeleteProbeInput{}
	}

	output = &DeleteProbeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteProbe API operation for Amazon CloudWatch Network Monitor.
//
// Deletes the specified monitor. Once a probe is deleted you'll no longer incur
// any billing fees for that probe.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Network Monitor's
// API operation DeleteProbe for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The specified resource does not exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling
//
//   - ValidationException
//     One of the parameters for the request is not valid.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ServiceQuotaExceededException
//     This request exceeds a service quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/networkmonitor-2023-08-01/DeleteProbe
func (c *NetworkMonitor) DeleteProbe(input *DeleteProbeInput) (*DeleteProbeOutput, error) {
	req, out := c.DeleteProbeRequest(input)
	return out, req.Send()
}

// DeleteProbeWithContext is the same as DeleteProbe with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProbe for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkMonitor) DeleteProbeWithContext(ctx aws.Context, input *DeleteProbeInput, opts ...request.Option) (*DeleteProbeOutput, error) {
	req, out := c.DeleteProbeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMonitor = "GetMonitor"

// GetMonitorRequest generates a "aws/request.Request" representing the
// client's request for the GetMonitor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMonitor for more information on using the GetMonitor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMonitorRequest method.
//	req, resp := client.GetMonitorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/networkmonitor-2023-08-01/GetMonitor
func (c *NetworkMonitor) GetMonitorRequest(input *GetMonitorInput) (req *request.Request, output *GetMonitorOutput) {
	op := &request.Operation{
		Name:       opGetMonitor,
		HTTPMethod: "GET",
		HTTPPath:   "/monitors/{monitorName}",
	}

	if input == nil {
		input = &GetMonitorInput{}
	}

	output = &GetMonitorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMonitor API operation for Amazon CloudWatch Network Monitor.
//
// Returns details about a specific monitor.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Network Monitor's
// API operation GetMonitor for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The specified resource does not exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling
//
//   - ValidationException
//     One of the parameters for the request is not valid.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/networkmonitor-2023-08-01/GetMonitor
func (c *NetworkMonitor) GetMonitor(input *GetMonitorInput) (*GetMonitorOutput, error) {
	req, out := c.GetMonitorRequest(input)
	return out, req.Send()
}

// GetMonitorWithContext is the same as GetMonitor with the addition of
// the ability to pass a context and additional request options.
//
// See GetMonitor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkMonitor) GetMonitorWithContext(ctx aws.Context, input *GetMonitorInput, opts ...request.Option) (*GetMonitorOutput, error) {
	req, out := c.GetMonitorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetProbe = "GetProbe"

// GetProbeRequest generates a "aws/request.Request" representing the
// client's request for the GetProbe operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetProbe for more information on using the GetProbe
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetProbeRequest method.
//	req, resp := client.GetProbeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/networkmonitor-2023-08-01/GetProbe
func (c *NetworkMonitor) GetProbeRequest(input *GetProbeInput) (req *request.Request, output *GetProbeOutput) {
	op := &request.Operation{
		Name:       opGetProbe,
		HTTPMethod: "GET",
		HTTPPath:   "/monitors/{monitorName}/probes/{probeId}",
	}

	if input == nil {
		input = &GetProbeInput{}
	}

	output = &GetProbeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetProbe API operation for Amazon CloudWatch Network Monitor.
//
// Returns the details about a probe. You'll need both the monitorName and probeId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Network Monitor's
// API operation GetProbe for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The specified resource does not exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling
//
//   - ValidationException
//     One of the parameters for the request is not valid.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/networkmonitor-2023-08-01/GetProbe
func (c *NetworkMonitor) GetProbe(input *GetProbeInput) (*GetProbeOutput, error) {
	req, out := c.GetProbeRequest(input)
	return out, req.Send()
}

// GetProbeWithContext is the same as GetProbe with the addition of
// the ability to pass a context and additional request options.
//
// See GetProbe for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkMonitor) GetProbeWithContext(ctx aws.Context, input *GetProbeInput, opts ...request.Option) (*GetProbeOutput, error) {
	req, out := c.GetProbeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListMonitors = "ListMonitors"

// ListMonitorsRequest generates a "aws/request.Request" representing the
// client's request for the ListMonitors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMonitors for more information on using the ListMonitors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMonitorsRequest method.
//	req, resp := client.ListMonitorsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/networkmonitor-2023-08-01/ListMonitors
func (c *NetworkMonitor) ListMonitorsRequest(input *ListMonitorsInput) (req *request.Request, output *ListMonitorsOutput) {
	op := &request.Operation{
		Name:       opListMonitors,
		HTTPMethod: "GET",
		HTTPPath:   "/monitors",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMonitorsInput{}
	}

	output = &ListMonitorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMonitors API operation for Amazon CloudWatch Network Monitor.
//
// Returns a list of all of your monitors.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Network Monitor's
// API operation ListMonitors for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling
//
//   - ValidationException
//     One of the parameters for the request is not valid.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/networkmonitor-2023-08-01/ListMonitors
func (c *NetworkMonitor) ListMonitors(input *ListMonitorsInput) (*ListMonitorsOutput, error) {
	req, out := c.ListMonitorsRequest(input)
	return out, req.Send()
}

// ListMonitorsWithContext is the same as ListMonitors with the addition of
// the ability to pass a context and additional request options.
//
// See ListMonitors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkMonitor) ListMonitorsWithContext(ctx aws.Context, input *ListMonitorsInput, opts ...request.Option) (*ListMonitorsOutput, error) {
	req, out := c.ListMonitorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMonitorsPages iterates over the pages of a ListMonitors operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMonitors method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListMonitors operation.
//	pageNum := 0
//	err := client.ListMonitorsPages(params,
//	    func(page *networkmonitor.ListMonitorsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *NetworkMonitor) ListMonitorsPages(input *ListMonitorsInput, fn func(*ListMonitorsOutput, bool) bool) error {
	return c.ListMonitorsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMonitorsPagesWithContext same as ListMonitorsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkMonitor) ListMonitorsPagesWithContext(ctx aws.Context, input *ListMonitorsInput, fn func(*ListMonitorsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMonitorsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMonitorsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMonitorsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/networkmonitor-2023-08-01/ListTagsForResource
func (c *NetworkMonitor) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon CloudWatch Network Monitor.
//
// Lists the tags assigned to this resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Network Monitor's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The specified resource does not exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling
//
//   - ValidationException
//     One of the parameters for the request is not valid.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ConflictException
//     This operation attempted to create a resource that already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/networkmonitor-2023-08-01/ListTagsForResource
func (c *NetworkMonitor) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkMonitor) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/networkmonitor-2023-08-01/TagResource
func (c *NetworkMonitor) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon CloudWatch Network Monitor.
//
// Adds key-value pairs to a monitor or probe.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Network Monitor's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The specified resource does not exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling
//
//   - ValidationException
//     One of the parameters for the request is not valid.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ConflictException
//     This operation attempted to create a resource that already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/networkmonitor-2023-08-01/TagResource
func (c *NetworkMonitor) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkMonitor) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/networkmonitor-2023-08-01/UntagResource
func (c *NetworkMonitor) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon CloudWatch Network Monitor.
//
// Removes a key-value pair from a monitor or probe.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Network Monitor's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The specified resource does not exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling
//
//   - ValidationException
//     One of the parameters for the request is not valid.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ConflictException
//     This operation attempted to create a resource that already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/networkmonitor-2023-08-01/UntagResource
func (c *NetworkMonitor) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkMonitor) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMonitor = "UpdateMonitor"

// UpdateMonitorRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMonitor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMonitor for more information on using the UpdateMonitor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateMonitorRequest method.
//	req, resp := client.UpdateMonitorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/networkmonitor-2023-08-01/UpdateMonitor
func (c *NetworkMonitor) UpdateMonitorRequest(input *UpdateMonitorInput) (req *request.Request, output *UpdateMonitorOutput) {
	op := &request.Operation{
		Name:       opUpdateMonitor,
		HTTPMethod: "PATCH",
		HTTPPath:   "/monitors/{monitorName}",
	}

	if input == nil {
		input = &UpdateMonitorInput{}
	}

	output = &UpdateMonitorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateMonitor API operation for Amazon CloudWatch Network Monitor.
//
// Updates the aggregationPeriod for a monitor. Monitors support an aggregationPeriod
// of either 30 or 60 seconds.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Network Monitor's
// API operation UpdateMonitor for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The specified resource does not exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling
//
//   - ValidationException
//     One of the parameters for the request is not valid.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ServiceQuotaExceededException
//     This request exceeds a service quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/networkmonitor-2023-08-01/UpdateMonitor
func (c *NetworkMonitor) UpdateMonitor(input *UpdateMonitorInput) (*UpdateMonitorOutput, error) {
	req, out := c.UpdateMonitorRequest(input)
	return out, req.Send()
}

// UpdateMonitorWithContext is the same as UpdateMonitor with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMonitor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkMonitor) UpdateMonitorWithContext(ctx aws.Context, input *UpdateMonitorInput, opts ...request.Option) (*UpdateMonitorOutput, error) {
	req, out := c.UpdateMonitorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateProbe = "UpdateProbe"

// UpdateProbeRequest generates a "aws/request.Request" representing the
// client's request for the UpdateProbe operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateProbe for more information on using the UpdateProbe
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateProbeRequest method.
//	req, resp := client.UpdateProbeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/networkmonitor-2023-08-01/UpdateProbe
func (c *NetworkMonitor) UpdateProbeRequest(input *UpdateProbeInput) (req *request.Request, output *UpdateProbeOutput) {
	op := &request.Operation{
		Name:       opUpdateProbe,
		HTTPMethod: "PATCH",
		HTTPPath:   "/monitors/{monitorName}/probes/{probeId}",
	}

	if input == nil {
		input = &UpdateProbeInput{}
	}

	output = &UpdateProbeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateProbe API operation for Amazon CloudWatch Network Monitor.
//
// Updates a monitor probe. This action requires both the monitorName and probeId
// parameters. Run ListMonitors to get a list of monitor names. Run GetMonitor
// to get a list of probes and probe IDs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon CloudWatch Network Monitor's
// API operation UpdateProbe for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The specified resource does not exist.
//
//   - ThrottlingException
//     The request was denied due to request throttling
//
//   - ValidationException
//     One of the parameters for the request is not valid.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ServiceQuotaExceededException
//     This request exceeds a service quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/networkmonitor-2023-08-01/UpdateProbe
func (c *NetworkMonitor) UpdateProbe(input *UpdateProbeInput) (*UpdateProbeOutput, error) {
	req, out := c.UpdateProbeRequest(input)
	return out, req.Send()
}

// UpdateProbeWithContext is the same as UpdateProbe with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateProbe for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *NetworkMonitor) UpdateProbeWithContext(ctx aws.Context, input *UpdateProbeInput, opts ...request.Option) (*UpdateProbeOutput, error) {
	req, out := c.UpdateProbeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This operation attempted to create a resource that already exists.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateMonitorInput struct {
	_ struct{} `type:"structure"`

	// The time, in seconds, that metrics are aggregated and sent to Amazon CloudWatch.
	// Valid values are either 30 or 60.
	AggregationPeriod *int64 `locationName:"aggregationPeriod" min:"30" type:"long"`

	// Unique, case-sensitive identifier to ensure the idempotency of the request.
	// Only returned if a client token was provided in the request.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name identifying the monitor. It can contain only letters, underscores
	// (_), or dashes (-), and can be up to 255 characters.
	//
	// MonitorName is a required field
	MonitorName *string `locationName:"monitorName" min:"1" type:"string" required:"true"`

	// Displays a list of all of the probes created for a monitor.
	Probes []*CreateMonitorProbeInput_ `locationName:"probes" type:"list"`

	// The list of key-value pairs created and assigned to the monitor.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMonitorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMonitorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMonitorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMonitorInput"}
	if s.AggregationPeriod != nil && *s.AggregationPeriod < 30 {
		invalidParams.Add(request.NewErrParamMinValue("AggregationPeriod", 30))
	}
	if s.MonitorName == nil {
		invalidParams.Add(request.NewErrParamRequired("MonitorName"))
	}
	if s.MonitorName != nil && len(*s.MonitorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MonitorName", 1))
	}
	if s.Probes != nil {
		for i, v := range s.Probes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Probes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAggregationPeriod sets the AggregationPeriod field's value.
func (s *CreateMonitorInput) SetAggregationPeriod(v int64) *CreateMonitorInput {
	s.AggregationPeriod = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateMonitorInput) SetClientToken(v string) *CreateMonitorInput {
	s.ClientToken = &v
	return s
}

// SetMonitorName sets the MonitorName field's value.
func (s *CreateMonitorInput) SetMonitorName(v string) *CreateMonitorInput {
	s.MonitorName = &v
	return s
}

// SetProbes sets the Probes field's value.
func (s *CreateMonitorInput) SetProbes(v []*CreateMonitorProbeInput_) *CreateMonitorInput {
	s.Probes = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateMonitorInput) SetTags(v map[string]*string) *CreateMonitorInput {
	s.Tags = v
	return s
}

type CreateMonitorOutput struct {
	_ struct{} `type:"structure"`

	// The number of seconds that metrics are aggregated by and sent to Amazon CloudWatch.
	// This will be either 30 or 60.
	AggregationPeriod *int64 `locationName:"aggregationPeriod" min:"30" type:"long"`

	// The ARN of the monitor.
	//
	// MonitorArn is a required field
	MonitorArn *string `locationName:"monitorArn" min:"20" type:"string" required:"true"`

	// The name of the monitor.
	//
	// MonitorName is a required field
	MonitorName *string `locationName:"monitorName" min:"1" type:"string" required:"true"`

	// The state of the monitor.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"MonitorState"`

	// The list of key-value pairs assigned to the monitor.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMonitorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMonitorOutput) GoString() string {
	return s.String()
}

// SetAggregationPeriod sets the AggregationPeriod field's value.
func (s *CreateMonitorOutput) SetAggregationPeriod(v int64) *CreateMonitorOutput {
	s.AggregationPeriod = &v
	return s
}

// SetMonitorArn sets the MonitorArn field's value.
func (s *CreateMonitorOutput) SetMonitorArn(v string) *CreateMonitorOutput {
	s.MonitorArn = &v
	return s
}

// SetMonitorName sets the MonitorName field's value.
func (s *CreateMonitorOutput) SetMonitorName(v string) *CreateMonitorOutput {
	s.MonitorName = &v
	return s
}

// SetState sets the State field's value.
func (s *CreateMonitorOutput) SetState(v string) *CreateMonitorOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateMonitorOutput) SetTags(v map[string]*string) *CreateMonitorOutput {
	s.Tags = v
	return s
}

// Creates a monitor probe.
type CreateMonitorProbeInput_ struct {
	_ struct{} `type:"structure"`

	// The destination IP address. This will be either IPV4 or IPV6.
	//
	// Destination is a required field
	Destination *string `locationName:"destination" min:"1" type:"string" required:"true"`

	// The port associated with the destination. This is required only if the protocol
	// is TCP and must be a number between 1 and 65536.
	DestinationPort *int64 `locationName:"destinationPort" type:"integer"`

	// The size of the packets sent between the source and destination. This will
	// be a number between 56 and 8500.
	PacketSize *int64 `locationName:"packetSize" min:"56" type:"integer"`

	// The list of key-value pairs created and assigned to the monitor.
	ProbeTags map[string]*string `locationName:"probeTags" type:"map"`

	// The protocol used for the network traffic between the source and destination.
	// This will be either TCP or ICMP.
	//
	// Protocol is a required field
	Protocol *string `locationName:"protocol" type:"string" required:"true" enum:"Protocol"`

	// The ARN of the subnet.
	//
	// SourceArn is a required field
	SourceArn *string `locationName:"sourceArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMonitorProbeInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMonitorProbeInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMonitorProbeInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMonitorProbeInput_"}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.Destination != nil && len(*s.Destination) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Destination", 1))
	}
	if s.PacketSize != nil && *s.PacketSize < 56 {
		invalidParams.Add(request.NewErrParamMinValue("PacketSize", 56))
	}
	if s.Protocol == nil {
		invalidParams.Add(request.NewErrParamRequired("Protocol"))
	}
	if s.SourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceArn"))
	}
	if s.SourceArn != nil && len(*s.SourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("SourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestination sets the Destination field's value.
func (s *CreateMonitorProbeInput_) SetDestination(v string) *CreateMonitorProbeInput_ {
	s.Destination = &v
	return s
}

// SetDestinationPort sets the DestinationPort field's value.
func (s *CreateMonitorProbeInput_) SetDestinationPort(v int64) *CreateMonitorProbeInput_ {
	s.DestinationPort = &v
	return s
}

// SetPacketSize sets the PacketSize field's value.
func (s *CreateMonitorProbeInput_) SetPacketSize(v int64) *CreateMonitorProbeInput_ {
	s.PacketSize = &v
	return s
}

// SetProbeTags sets the ProbeTags field's value.
func (s *CreateMonitorProbeInput_) SetProbeTags(v map[string]*string) *CreateMonitorProbeInput_ {
	s.ProbeTags = v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *CreateMonitorProbeInput_) SetProtocol(v string) *CreateMonitorProbeInput_ {
	s.Protocol = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *CreateMonitorProbeInput_) SetSourceArn(v string) *CreateMonitorProbeInput_ {
	s.SourceArn = &v
	return s
}

type CreateProbeInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier to ensure the idempotency of the request.
	// Only returned if a client token was provided in the request.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name of the monitor to associated with the probe. To get a list of available
	// monitors, use ListMonitors.
	//
	// MonitorName is a required field
	MonitorName *string `location:"uri" locationName:"monitorName" min:"1" type:"string" required:"true"`

	// Describes the details of an individual probe for a monitor.
	//
	// Probe is a required field
	Probe *ProbeInput_ `locationName:"probe" type:"structure" required:"true"`

	// The list of key-value pairs created and assigned to the probe.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProbeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProbeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProbeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProbeInput"}
	if s.MonitorName == nil {
		invalidParams.Add(request.NewErrParamRequired("MonitorName"))
	}
	if s.MonitorName != nil && len(*s.MonitorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MonitorName", 1))
	}
	if s.Probe == nil {
		invalidParams.Add(request.NewErrParamRequired("Probe"))
	}
	if s.Probe != nil {
		if err := s.Probe.Validate(); err != nil {
			invalidParams.AddNested("Probe", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateProbeInput) SetClientToken(v string) *CreateProbeInput {
	s.ClientToken = &v
	return s
}

// SetMonitorName sets the MonitorName field's value.
func (s *CreateProbeInput) SetMonitorName(v string) *CreateProbeInput {
	s.MonitorName = &v
	return s
}

// SetProbe sets the Probe field's value.
func (s *CreateProbeInput) SetProbe(v *ProbeInput_) *CreateProbeInput {
	s.Probe = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateProbeInput) SetTags(v map[string]*string) *CreateProbeInput {
	s.Tags = v
	return s
}

type CreateProbeOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether the IP address is IPV4 or IPV6.
	AddressFamily *string `locationName:"addressFamily" type:"string" enum:"AddressFamily"`

	// The time and date that the probe was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The destination IP address for the monitor. This will be either an IPv4 or
	// IPv6 address.
	//
	// Destination is a required field
	Destination *string `locationName:"destination" min:"1" type:"string" required:"true"`

	// The port associated with the destination. This is required only if the protocol
	// is TCP and must be a number between 1 and 65536.
	DestinationPort *int64 `locationName:"destinationPort" type:"integer"`

	// The time and date when the probe was last modified.
	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp"`

	// The size of the packets sent between the source and destination. This will
	// be a number between 56 and 8500.
	PacketSize *int64 `locationName:"packetSize" min:"56" type:"integer"`

	// The ARN of the probe.
	ProbeArn *string `locationName:"probeArn" min:"20" type:"string"`

	// The ID of the probe for which details are returned.
	ProbeId *string `locationName:"probeId" type:"string"`

	// The protocol used for the network traffic between the source and destination.
	// This will be either TCP or ICMP.
	//
	// Protocol is a required field
	Protocol *string `locationName:"protocol" type:"string" required:"true" enum:"Protocol"`

	// The ARN of the probe.
	//
	// SourceArn is a required field
	SourceArn *string `locationName:"sourceArn" min:"20" type:"string" required:"true"`

	// The state of the probe.
	State *string `locationName:"state" type:"string" enum:"ProbeState"`

	// The list of key-value pairs assigned to the probe.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The ID of the source VPC or subnet.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProbeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProbeOutput) GoString() string {
	return s.String()
}

// SetAddressFamily sets the AddressFamily field's value.
func (s *CreateProbeOutput) SetAddressFamily(v string) *CreateProbeOutput {
	s.AddressFamily = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateProbeOutput) SetCreatedAt(v time.Time) *CreateProbeOutput {
	s.CreatedAt = &v
	return s
}

// SetDestination sets the Destination field's value.
func (s *CreateProbeOutput) SetDestination(v string) *CreateProbeOutput {
	s.Destination = &v
	return s
}

// SetDestinationPort sets the DestinationPort field's value.
func (s *CreateProbeOutput) SetDestinationPort(v int64) *CreateProbeOutput {
	s.DestinationPort = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *CreateProbeOutput) SetModifiedAt(v time.Time) *CreateProbeOutput {
	s.ModifiedAt = &v
	return s
}

// SetPacketSize sets the PacketSize field's value.
func (s *CreateProbeOutput) SetPacketSize(v int64) *CreateProbeOutput {
	s.PacketSize = &v
	return s
}

// SetProbeArn sets the ProbeArn field's value.
func (s *CreateProbeOutput) SetProbeArn(v string) *CreateProbeOutput {
	s.ProbeArn = &v
	return s
}

// SetProbeId sets the ProbeId field's value.
func (s *CreateProbeOutput) SetProbeId(v string) *CreateProbeOutput {
	s.ProbeId = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *CreateProbeOutput) SetProtocol(v string) *CreateProbeOutput {
	s.Protocol = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *CreateProbeOutput) SetSourceArn(v string) *CreateProbeOutput {
	s.SourceArn = &v
	return s
}

// SetState sets the State field's value.
func (s *CreateProbeOutput) SetState(v string) *CreateProbeOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateProbeOutput) SetTags(v map[string]*string) *CreateProbeOutput {
	s.Tags = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *CreateProbeOutput) SetVpcId(v string) *CreateProbeOutput {
	s.VpcId = &v
	return s
}

type DeleteMonitorInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the monitor to delete. Use the ListMonitors action to get a list
	// of your current monitors.
	//
	// MonitorName is a required field
	MonitorName *string `location:"uri" locationName:"monitorName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMonitorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMonitorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMonitorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMonitorInput"}
	if s.MonitorName == nil {
		invalidParams.Add(request.NewErrParamRequired("MonitorName"))
	}
	if s.MonitorName != nil && len(*s.MonitorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MonitorName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMonitorName sets the MonitorName field's value.
func (s *DeleteMonitorInput) SetMonitorName(v string) *DeleteMonitorInput {
	s.MonitorName = &v
	return s
}

type DeleteMonitorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMonitorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMonitorOutput) GoString() string {
	return s.String()
}

type DeleteProbeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the monitor to delete. For a list of the available monitors,
	// use the ListMonitors action.
	//
	// MonitorName is a required field
	MonitorName *string `location:"uri" locationName:"monitorName" min:"1" type:"string" required:"true"`

	// The ID of the probe to delete. Run GetMonitor to get a lst of all probes
	// and probe IDs associated with the monitor.
	//
	// ProbeId is a required field
	ProbeId *string `location:"uri" locationName:"probeId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProbeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProbeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProbeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProbeInput"}
	if s.MonitorName == nil {
		invalidParams.Add(request.NewErrParamRequired("MonitorName"))
	}
	if s.MonitorName != nil && len(*s.MonitorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MonitorName", 1))
	}
	if s.ProbeId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProbeId"))
	}
	if s.ProbeId != nil && len(*s.ProbeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProbeId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMonitorName sets the MonitorName field's value.
func (s *DeleteProbeInput) SetMonitorName(v string) *DeleteProbeInput {
	s.MonitorName = &v
	return s
}

// SetProbeId sets the ProbeId field's value.
func (s *DeleteProbeInput) SetProbeId(v string) *DeleteProbeInput {
	s.ProbeId = &v
	return s
}

type DeleteProbeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProbeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProbeOutput) GoString() string {
	return s.String()
}

type GetMonitorInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the monitor that details are returned for.
	//
	// MonitorName is a required field
	MonitorName *string `location:"uri" locationName:"monitorName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMonitorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMonitorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMonitorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMonitorInput"}
	if s.MonitorName == nil {
		invalidParams.Add(request.NewErrParamRequired("MonitorName"))
	}
	if s.MonitorName != nil && len(*s.MonitorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MonitorName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMonitorName sets the MonitorName field's value.
func (s *GetMonitorInput) SetMonitorName(v string) *GetMonitorInput {
	s.MonitorName = &v
	return s
}

type GetMonitorOutput struct {
	_ struct{} `type:"structure"`

	// The aggregation period for the specified monitor.
	//
	// AggregationPeriod is a required field
	AggregationPeriod *int64 `locationName:"aggregationPeriod" min:"30" type:"long" required:"true"`

	// The time and date when the monitor was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The time and date when the monitor was last modified.
	//
	// ModifiedAt is a required field
	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp" required:"true"`

	// The ARN of the selected monitor.
	//
	// MonitorArn is a required field
	MonitorArn *string `locationName:"monitorArn" min:"20" type:"string" required:"true"`

	// The name of the monitor. To get a list of the current monitors and their
	// names, use the ListMonitors action.
	//
	// MonitorName is a required field
	MonitorName *string `locationName:"monitorName" min:"1" type:"string" required:"true"`

	// The details about each probe associated with that monitor.
	Probes []*Probe `locationName:"probes" type:"list"`

	// Returns a list of the state of each monitor.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"MonitorState"`

	// The list of key-value pairs assigned to the monitor.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMonitorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMonitorOutput) GoString() string {
	return s.String()
}

// SetAggregationPeriod sets the AggregationPeriod field's value.
func (s *GetMonitorOutput) SetAggregationPeriod(v int64) *GetMonitorOutput {
	s.AggregationPeriod = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetMonitorOutput) SetCreatedAt(v time.Time) *GetMonitorOutput {
	s.CreatedAt = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *GetMonitorOutput) SetModifiedAt(v time.Time) *GetMonitorOutput {
	s.ModifiedAt = &v
	return s
}

// SetMonitorArn sets the MonitorArn field's value.
func (s *GetMonitorOutput) SetMonitorArn(v string) *GetMonitorOutput {
	s.MonitorArn = &v
	return s
}

// SetMonitorName sets the MonitorName field's value.
func (s *GetMonitorOutput) SetMonitorName(v string) *GetMonitorOutput {
	s.MonitorName = &v
	return s
}

// SetProbes sets the Probes field's value.
func (s *GetMonitorOutput) SetProbes(v []*Probe) *GetMonitorOutput {
	s.Probes = v
	return s
}

// SetState sets the State field's value.
func (s *GetMonitorOutput) SetState(v string) *GetMonitorOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetMonitorOutput) SetTags(v map[string]*string) *GetMonitorOutput {
	s.Tags = v
	return s
}

type GetProbeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the monitor associated with the probe. Run ListMonitors to get
	// a list of monitor names.
	//
	// MonitorName is a required field
	MonitorName *string `location:"uri" locationName:"monitorName" min:"1" type:"string" required:"true"`

	// The ID of the probe to get information about. Run GetMonitor action to get
	// a list of probes and probe IDs for the monitor.
	//
	// ProbeId is a required field
	ProbeId *string `location:"uri" locationName:"probeId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProbeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProbeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetProbeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetProbeInput"}
	if s.MonitorName == nil {
		invalidParams.Add(request.NewErrParamRequired("MonitorName"))
	}
	if s.MonitorName != nil && len(*s.MonitorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MonitorName", 1))
	}
	if s.ProbeId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProbeId"))
	}
	if s.ProbeId != nil && len(*s.ProbeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProbeId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMonitorName sets the MonitorName field's value.
func (s *GetProbeInput) SetMonitorName(v string) *GetProbeInput {
	s.MonitorName = &v
	return s
}

// SetProbeId sets the ProbeId field's value.
func (s *GetProbeInput) SetProbeId(v string) *GetProbeInput {
	s.ProbeId = &v
	return s
}

type GetProbeOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether the IP address is IPV4 or IPV6.
	AddressFamily *string `locationName:"addressFamily" type:"string" enum:"AddressFamily"`

	// The time and date that the probe was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The destination IP address for the monitor. This will be either an IPv4 or
	// IPv6 address.
	//
	// Destination is a required field
	Destination *string `locationName:"destination" min:"1" type:"string" required:"true"`

	// The port associated with the destination. This is required only if the protocol
	// is TCP and must be a number between 1 and 65536.
	DestinationPort *int64 `locationName:"destinationPort" type:"integer"`

	// The time and date that the probe was last modified.
	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp"`

	// The size of the packets sent between the source and destination. This will
	// be a number between 56 and 8500.
	PacketSize *int64 `locationName:"packetSize" min:"56" type:"integer"`

	// The ARN of the probe.
	ProbeArn *string `locationName:"probeArn" min:"20" type:"string"`

	// The ID of the probe for which details are returned.
	ProbeId *string `locationName:"probeId" type:"string"`

	// The protocol used for the network traffic between the source and destination.
	// This will be either TCP or ICMP.
	//
	// Protocol is a required field
	Protocol *string `locationName:"protocol" type:"string" required:"true" enum:"Protocol"`

	// The ARN of the probe.
	//
	// SourceArn is a required field
	SourceArn *string `locationName:"sourceArn" min:"20" type:"string" required:"true"`

	// The state of the probe.
	State *string `locationName:"state" type:"string" enum:"ProbeState"`

	// The list of key-value pairs assigned to the probe.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The ID of the source VPC or subnet.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProbeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProbeOutput) GoString() string {
	return s.String()
}

// SetAddressFamily sets the AddressFamily field's value.
func (s *GetProbeOutput) SetAddressFamily(v string) *GetProbeOutput {
	s.AddressFamily = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetProbeOutput) SetCreatedAt(v time.Time) *GetProbeOutput {
	s.CreatedAt = &v
	return s
}

// SetDestination sets the Destination field's value.
func (s *GetProbeOutput) SetDestination(v string) *GetProbeOutput {
	s.Destination = &v
	return s
}

// SetDestinationPort sets the DestinationPort field's value.
func (s *GetProbeOutput) SetDestinationPort(v int64) *GetProbeOutput {
	s.DestinationPort = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *GetProbeOutput) SetModifiedAt(v time.Time) *GetProbeOutput {
	s.ModifiedAt = &v
	return s
}

// SetPacketSize sets the PacketSize field's value.
func (s *GetProbeOutput) SetPacketSize(v int64) *GetProbeOutput {
	s.PacketSize = &v
	return s
}

// SetProbeArn sets the ProbeArn field's value.
func (s *GetProbeOutput) SetProbeArn(v string) *GetProbeOutput {
	s.ProbeArn = &v
	return s
}

// SetProbeId sets the ProbeId field's value.
func (s *GetProbeOutput) SetProbeId(v string) *GetProbeOutput {
	s.ProbeId = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *GetProbeOutput) SetProtocol(v string) *GetProbeOutput {
	s.Protocol = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *GetProbeOutput) SetSourceArn(v string) *GetProbeOutput {
	s.SourceArn = &v
	return s
}

// SetState sets the State field's value.
func (s *GetProbeOutput) SetState(v string) *GetProbeOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetProbeOutput) SetTags(v map[string]*string) *GetProbeOutput {
	s.Tags = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *GetProbeOutput) SetVpcId(v string) *GetProbeOutput {
	s.VpcId = &v
	return s
}

// The request processing has failed because of an unknown error, exception
// or failure.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListMonitorsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	//
	// If MaxResults is given a value larger than 100, only 100 results are returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The list of all monitors and their states.
	State *string `location:"querystring" locationName:"state" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMonitorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMonitorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMonitorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMonitorsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMonitorsInput) SetMaxResults(v int64) *ListMonitorsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMonitorsInput) SetNextToken(v string) *ListMonitorsInput {
	s.NextToken = &v
	return s
}

// SetState sets the State field's value.
func (s *ListMonitorsInput) SetState(v string) *ListMonitorsInput {
	s.State = &v
	return s
}

type ListMonitorsOutput struct {
	_ struct{} `type:"structure"`

	// Lists individual details about each of your monitors.
	//
	// Monitors is a required field
	Monitors []*MonitorSummary `locationName:"monitors" type:"list" required:"true"`

	// The token for the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMonitorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMonitorsOutput) GoString() string {
	return s.String()
}

// SetMonitors sets the Monitors field's value.
func (s *ListMonitorsOutput) SetMonitors(v []*MonitorSummary) *ListMonitorsOutput {
	s.Monitors = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMonitorsOutput) SetNextToken(v string) *ListMonitorsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// Lists the tags assigned to the resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Displays summary information about a monitor.
type MonitorSummary struct {
	_ struct{} `type:"structure"`

	// The time, in seconds, that metrics are collected and sent to Amazon CloudWatch.
	// Valid values are either 30 or 60.
	AggregationPeriod *int64 `locationName:"aggregationPeriod" min:"30" type:"long"`

	// The ARN of the monitor.
	//
	// MonitorArn is a required field
	MonitorArn *string `locationName:"monitorArn" min:"20" type:"string" required:"true"`

	// The name of the monitor.
	//
	// MonitorName is a required field
	MonitorName *string `locationName:"monitorName" min:"1" type:"string" required:"true"`

	// The state of the monitor.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"MonitorState"`

	// The list of key-value pairs assigned to the monitor.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MonitorSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MonitorSummary) GoString() string {
	return s.String()
}

// SetAggregationPeriod sets the AggregationPeriod field's value.
func (s *MonitorSummary) SetAggregationPeriod(v int64) *MonitorSummary {
	s.AggregationPeriod = &v
	return s
}

// SetMonitorArn sets the MonitorArn field's value.
func (s *MonitorSummary) SetMonitorArn(v string) *MonitorSummary {
	s.MonitorArn = &v
	return s
}

// SetMonitorName sets the MonitorName field's value.
func (s *MonitorSummary) SetMonitorName(v string) *MonitorSummary {
	s.MonitorName = &v
	return s
}

// SetState sets the State field's value.
func (s *MonitorSummary) SetState(v string) *MonitorSummary {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *MonitorSummary) SetTags(v map[string]*string) *MonitorSummary {
	s.Tags = v
	return s
}

// Describes information about a monitor probe.
type Probe struct {
	_ struct{} `type:"structure"`

	// The IPv4 or IPv6 address for the probe.
	AddressFamily *string `locationName:"addressFamily" type:"string" enum:"AddressFamily"`

	// The time and date the probe was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The destination for the probe. This should be either an IPV4 or IPV6.
	//
	// Destination is a required field
	Destination *string `locationName:"destination" min:"1" type:"string" required:"true"`

	// The destination port for the probe. This is required only if the protocol
	// is TCP and must be a number between 1 and 65536.
	DestinationPort *int64 `locationName:"destinationPort" type:"integer"`

	// The time and date that the probe was last modified.
	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp"`

	// The size of the packets traveling between the source and destination. This
	// must be a number between 56 and
	PacketSize *int64 `locationName:"packetSize" min:"56" type:"integer"`

	// The ARN of the probe.
	ProbeArn *string `locationName:"probeArn" min:"20" type:"string"`

	// The ID of the probe.
	ProbeId *string `locationName:"probeId" type:"string"`

	// The network protocol for the destination. This can be either TCP or ICMP.
	// If the protocol is TCP, then port is also required.
	//
	// Protocol is a required field
	Protocol *string `locationName:"protocol" type:"string" required:"true" enum:"Protocol"`

	// The ARN of the probe source subnet.
	//
	// SourceArn is a required field
	SourceArn *string `locationName:"sourceArn" min:"20" type:"string" required:"true"`

	// The state of the probe.
	State *string `locationName:"state" type:"string" enum:"ProbeState"`

	// The list of key-value pairs created and assigned to the probe.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The ID of the source VPC subnet.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Probe) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Probe) GoString() string {
	return s.String()
}

// SetAddressFamily sets the AddressFamily field's value.
func (s *Probe) SetAddressFamily(v string) *Probe {
	s.AddressFamily = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Probe) SetCreatedAt(v time.Time) *Probe {
	s.CreatedAt = &v
	return s
}

// SetDestination sets the Destination field's value.
func (s *Probe) SetDestination(v string) *Probe {
	s.Destination = &v
	return s
}

// SetDestinationPort sets the DestinationPort field's value.
func (s *Probe) SetDestinationPort(v int64) *Probe {
	s.DestinationPort = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *Probe) SetModifiedAt(v time.Time) *Probe {
	s.ModifiedAt = &v
	return s
}

// SetPacketSize sets the PacketSize field's value.
func (s *Probe) SetPacketSize(v int64) *Probe {
	s.PacketSize = &v
	return s
}

// SetProbeArn sets the ProbeArn field's value.
func (s *Probe) SetProbeArn(v string) *Probe {
	s.ProbeArn = &v
	return s
}

// SetProbeId sets the ProbeId field's value.
func (s *Probe) SetProbeId(v string) *Probe {
	s.ProbeId = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *Probe) SetProtocol(v string) *Probe {
	s.Protocol = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *Probe) SetSourceArn(v string) *Probe {
	s.SourceArn = &v
	return s
}

// SetState sets the State field's value.
func (s *Probe) SetState(v string) *Probe {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Probe) SetTags(v map[string]*string) *Probe {
	s.Tags = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *Probe) SetVpcId(v string) *Probe {
	s.VpcId = &v
	return s
}

// Defines a probe when creating a probe or monitor.
type ProbeInput_ struct {
	_ struct{} `type:"structure"`

	// The destination IP address. This will be either IPV4 or IPV6.
	//
	// Destination is a required field
	Destination *string `locationName:"destination" min:"1" type:"string" required:"true"`

	// The port associated with the destination. This is required only if the protocol
	// is TCP and must be a number between 1 and 65536.
	DestinationPort *int64 `locationName:"destinationPort" type:"integer"`

	// The size of the packets sent between the source and destination. This will
	// be a number between 56 and 8500.
	PacketSize *int64 `locationName:"packetSize" min:"56" type:"integer"`

	// The protocol used for the network traffic between the source and destination.
	// This will be either TCP or ICMP.
	//
	// Protocol is a required field
	Protocol *string `locationName:"protocol" type:"string" required:"true" enum:"Protocol"`

	// The ARN of the subnet.
	//
	// SourceArn is a required field
	SourceArn *string `locationName:"sourceArn" min:"20" type:"string" required:"true"`

	// The list of key-value pairs created and assigned to the monitor.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProbeInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProbeInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProbeInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProbeInput_"}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.Destination != nil && len(*s.Destination) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Destination", 1))
	}
	if s.PacketSize != nil && *s.PacketSize < 56 {
		invalidParams.Add(request.NewErrParamMinValue("PacketSize", 56))
	}
	if s.Protocol == nil {
		invalidParams.Add(request.NewErrParamRequired("Protocol"))
	}
	if s.SourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceArn"))
	}
	if s.SourceArn != nil && len(*s.SourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("SourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestination sets the Destination field's value.
func (s *ProbeInput_) SetDestination(v string) *ProbeInput_ {
	s.Destination = &v
	return s
}

// SetDestinationPort sets the DestinationPort field's value.
func (s *ProbeInput_) SetDestinationPort(v int64) *ProbeInput_ {
	s.DestinationPort = &v
	return s
}

// SetPacketSize sets the PacketSize field's value.
func (s *ProbeInput_) SetPacketSize(v int64) *ProbeInput_ {
	s.PacketSize = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *ProbeInput_) SetProtocol(v string) *ProbeInput_ {
	s.Protocol = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *ProbeInput_) SetSourceArn(v string) *ProbeInput_ {
	s.SourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ProbeInput_) SetTags(v map[string]*string) *ProbeInput_ {
	s.Tags = v
	return s
}

// The specified resource does not exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This request exceeds a service quota.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the monitor or probe to tag.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`

	// The list of key-value pairs assigned to the monitor or probe.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The request was denied due to request throttling
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the monitor or probe that the tag should be removed from.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`

	// The key-value pa
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateMonitorInput struct {
	_ struct{} `type:"structure"`

	// The aggregation time, in seconds, to change to. This must be either 30 or
	// 60.
	//
	// AggregationPeriod is a required field
	AggregationPeriod *int64 `locationName:"aggregationPeriod" min:"30" type:"long" required:"true"`

	// The name of the monitor to update. Run ListMonitors to get a list of monitor
	// names.
	//
	// MonitorName is a required field
	MonitorName *string `location:"uri" locationName:"monitorName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMonitorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMonitorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateMonitorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateMonitorInput"}
	if s.AggregationPeriod == nil {
		invalidParams.Add(request.NewErrParamRequired("AggregationPeriod"))
	}
	if s.AggregationPeriod != nil && *s.AggregationPeriod < 30 {
		invalidParams.Add(request.NewErrParamMinValue("AggregationPeriod", 30))
	}
	if s.MonitorName == nil {
		invalidParams.Add(request.NewErrParamRequired("MonitorName"))
	}
	if s.MonitorName != nil && len(*s.MonitorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MonitorName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAggregationPeriod sets the AggregationPeriod field's value.
func (s *UpdateMonitorInput) SetAggregationPeriod(v int64) *UpdateMonitorInput {
	s.AggregationPeriod = &v
	return s
}

// SetMonitorName sets the MonitorName field's value.
func (s *UpdateMonitorInput) SetMonitorName(v string) *UpdateMonitorInput {
	s.MonitorName = &v
	return s
}

type UpdateMonitorOutput struct {
	_ struct{} `type:"structure"`

	// The changed aggregation period.
	AggregationPeriod *int64 `locationName:"aggregationPeriod" min:"30" type:"long"`

	// The ARN of the monitor that was updated.
	//
	// MonitorArn is a required field
	MonitorArn *string `locationName:"monitorArn" min:"20" type:"string" required:"true"`

	// The name of the monitor that was updated.
	//
	// MonitorName is a required field
	MonitorName *string `locationName:"monitorName" min:"1" type:"string" required:"true"`

	// The state of the updated monitor.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true" enum:"MonitorState"`

	// The list of key-value pairs associated with the monitor.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMonitorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMonitorOutput) GoString() string {
	return s.String()
}

// SetAggregationPeriod sets the AggregationPeriod field's value.
func (s *UpdateMonitorOutput) SetAggregationPeriod(v int64) *UpdateMonitorOutput {
	s.AggregationPeriod = &v
	return s
}

// SetMonitorArn sets the MonitorArn field's value.
func (s *UpdateMonitorOutput) SetMonitorArn(v string) *UpdateMonitorOutput {
	s.MonitorArn = &v
	return s
}

// SetMonitorName sets the MonitorName field's value.
func (s *UpdateMonitorOutput) SetMonitorName(v string) *UpdateMonitorOutput {
	s.MonitorName = &v
	return s
}

// SetState sets the State field's value.
func (s *UpdateMonitorOutput) SetState(v string) *UpdateMonitorOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateMonitorOutput) SetTags(v map[string]*string) *UpdateMonitorOutput {
	s.Tags = v
	return s
}

type UpdateProbeInput struct {
	_ struct{} `type:"structure"`

	// The updated IP address for the probe destination. This must be either an
	// IPv4 or IPv6 address.
	Destination *string `locationName:"destination" min:"1" type:"string"`

	// The updated port for the probe destination. This is required only if the
	// protocol is TCP and must be a number between 1 and 65536.
	DestinationPort *int64 `locationName:"destinationPort" type:"integer"`

	// The name of the monitor that the probe was updated for.
	//
	// MonitorName is a required field
	MonitorName *string `location:"uri" locationName:"monitorName" min:"1" type:"string" required:"true"`

	// he updated packets size for network traffic between the source and destination.
	// This must be a number between 56 and 8500.
	PacketSize *int64 `locationName:"packetSize" min:"56" type:"integer"`

	// Run GetMonitor to get a list of probes and probe IDs.
	//
	// ProbeId is a required field
	ProbeId *string `location:"uri" locationName:"probeId" type:"string" required:"true"`

	// The updated network protocol for the destination. This can be either TCP
	// or ICMP. If the protocol is TCP, then port is also required.
	Protocol *string `locationName:"protocol" type:"string" enum:"Protocol"`

	// The state of the probe update.
	State *string `locationName:"state" type:"string" enum:"ProbeState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProbeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProbeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProbeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateProbeInput"}
	if s.Destination != nil && len(*s.Destination) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Destination", 1))
	}
	if s.MonitorName == nil {
		invalidParams.Add(request.NewErrParamRequired("MonitorName"))
	}
	if s.MonitorName != nil && len(*s.MonitorName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MonitorName", 1))
	}
	if s.PacketSize != nil && *s.PacketSize < 56 {
		invalidParams.Add(request.NewErrParamMinValue("PacketSize", 56))
	}
	if s.ProbeId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProbeId"))
	}
	if s.ProbeId != nil && len(*s.ProbeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProbeId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestination sets the Destination field's value.
func (s *UpdateProbeInput) SetDestination(v string) *UpdateProbeInput {
	s.Destination = &v
	return s
}

// SetDestinationPort sets the DestinationPort field's value.
func (s *UpdateProbeInput) SetDestinationPort(v int64) *UpdateProbeInput {
	s.DestinationPort = &v
	return s
}

// SetMonitorName sets the MonitorName field's value.
func (s *UpdateProbeInput) SetMonitorName(v string) *UpdateProbeInput {
	s.MonitorName = &v
	return s
}

// SetPacketSize sets the PacketSize field's value.
func (s *UpdateProbeInput) SetPacketSize(v int64) *UpdateProbeInput {
	s.PacketSize = &v
	return s
}

// SetProbeId sets the ProbeId field's value.
func (s *UpdateProbeInput) SetProbeId(v string) *UpdateProbeInput {
	s.ProbeId = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *UpdateProbeInput) SetProtocol(v string) *UpdateProbeInput {
	s.Protocol = &v
	return s
}

// SetState sets the State field's value.
func (s *UpdateProbeInput) SetState(v string) *UpdateProbeInput {
	s.State = &v
	return s
}

type UpdateProbeOutput struct {
	_ struct{} `type:"structure"`

	// The updated IP address family. This will be either IPV4 or IPV6.
	AddressFamily *string `locationName:"addressFamily" type:"string" enum:"AddressFamily"`

	// The time and date that the probe was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The updated destination IP address for the probe.
	//
	// Destination is a required field
	Destination *string `locationName:"destination" min:"1" type:"string" required:"true"`

	// The updated destination port. This will be a number between 1 and 65536.
	DestinationPort *int64 `locationName:"destinationPort" type:"integer"`

	// The time and date that the probe was last updated.
	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp"`

	// The updated packet size for the probe.
	PacketSize *int64 `locationName:"packetSize" min:"56" type:"integer"`

	// The updated ARN of the probe.
	ProbeArn *string `locationName:"probeArn" min:"20" type:"string"`

	// The updated ID of the probe.
	ProbeId *string `locationName:"probeId" type:"string"`

	// The updated protocol for the probe.
	//
	// Protocol is a required field
	Protocol *string `locationName:"protocol" type:"string" required:"true" enum:"Protocol"`

	// The updated ARN of the source subnet.
	//
	// SourceArn is a required field
	SourceArn *string `locationName:"sourceArn" min:"20" type:"string" required:"true"`

	// The state of the updated probe.
	State *string `locationName:"state" type:"string" enum:"ProbeState"`

	// Update tags for a probe.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The updated ID of the source VPC subnet ID.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProbeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProbeOutput) GoString() string {
	return s.String()
}

// SetAddressFamily sets the AddressFamily field's value.
func (s *UpdateProbeOutput) SetAddressFamily(v string) *UpdateProbeOutput {
	s.AddressFamily = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *UpdateProbeOutput) SetCreatedAt(v time.Time) *UpdateProbeOutput {
	s.CreatedAt = &v
	return s
}

// SetDestination sets the Destination field's value.
func (s *UpdateProbeOutput) SetDestination(v string) *UpdateProbeOutput {
	s.Destination = &v
	return s
}

// SetDestinationPort sets the DestinationPort field's value.
func (s *UpdateProbeOutput) SetDestinationPort(v int64) *UpdateProbeOutput {
	s.DestinationPort = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *UpdateProbeOutput) SetModifiedAt(v time.Time) *UpdateProbeOutput {
	s.ModifiedAt = &v
	return s
}

// SetPacketSize sets the PacketSize field's value.
func (s *UpdateProbeOutput) SetPacketSize(v int64) *UpdateProbeOutput {
	s.PacketSize = &v
	return s
}

// SetProbeArn sets the ProbeArn field's value.
func (s *UpdateProbeOutput) SetProbeArn(v string) *UpdateProbeOutput {
	s.ProbeArn = &v
	return s
}

// SetProbeId sets the ProbeId field's value.
func (s *UpdateProbeOutput) SetProbeId(v string) *UpdateProbeOutput {
	s.ProbeId = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *UpdateProbeOutput) SetProtocol(v string) *UpdateProbeOutput {
	s.Protocol = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *UpdateProbeOutput) SetSourceArn(v string) *UpdateProbeOutput {
	s.SourceArn = &v
	return s
}

// SetState sets the State field's value.
func (s *UpdateProbeOutput) SetState(v string) *UpdateProbeOutput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateProbeOutput) SetTags(v map[string]*string) *UpdateProbeOutput {
	s.Tags = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *UpdateProbeOutput) SetVpcId(v string) *UpdateProbeOutput {
	s.VpcId = &v
	return s
}

// One of the parameters for the request is not valid.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// AddressFamilyIpv4 is a AddressFamily enum value
	AddressFamilyIpv4 = "IPV4"

	// AddressFamilyIpv6 is a AddressFamily enum value
	AddressFamilyIpv6 = "IPV6"
)

// AddressFamily_Values returns all elements of the AddressFamily enum
func AddressFamily_Values() []string {
	return []string{
		AddressFamilyIpv4,
		AddressFamilyIpv6,
	}
}

const (
	// MonitorStatePending is a MonitorState enum value
	MonitorStatePending = "PENDING"

	// MonitorStateActive is a MonitorState enum value
	MonitorStateActive = "ACTIVE"

	// MonitorStateInactive is a MonitorState enum value
	MonitorStateInactive = "INACTIVE"

	// MonitorStateError is a MonitorState enum value
	MonitorStateError = "ERROR"

	// MonitorStateDeleting is a MonitorState enum value
	MonitorStateDeleting = "DELETING"
)

// MonitorState_Values returns all elements of the MonitorState enum
func MonitorState_Values() []string {
	return []string{
		MonitorStatePending,
		MonitorStateActive,
		MonitorStateInactive,
		MonitorStateError,
		MonitorStateDeleting,
	}
}

const (
	// ProbeStatePending is a ProbeState enum value
	ProbeStatePending = "PENDING"

	// ProbeStateActive is a ProbeState enum value
	ProbeStateActive = "ACTIVE"

	// ProbeStateInactive is a ProbeState enum value
	ProbeStateInactive = "INACTIVE"

	// ProbeStateError is a ProbeState enum value
	ProbeStateError = "ERROR"

	// ProbeStateDeleting is a ProbeState enum value
	ProbeStateDeleting = "DELETING"

	// ProbeStateDeleted is a ProbeState enum value
	ProbeStateDeleted = "DELETED"
)

// ProbeState_Values returns all elements of the ProbeState enum
func ProbeState_Values() []string {
	return []string{
		ProbeStatePending,
		ProbeStateActive,
		ProbeStateInactive,
		ProbeStateError,
		ProbeStateDeleting,
		ProbeStateDeleted,
	}
}

const (
	// ProtocolTcp is a Protocol enum value
	ProtocolTcp = "TCP"

	// ProtocolIcmp is a Protocol enum value
	ProtocolIcmp = "ICMP"
)

// Protocol_Values returns all elements of the Protocol enum
func Protocol_Values() []string {
	return []string{
		ProtocolTcp,
		ProtocolIcmp,
	}
}
