// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package components

import (
	"encoding/json"
	"fmt"
)

// Reason - An enumerated value indicating the issuer-supplied reason for the revocation.
type Reason string

const (
	ReasonUnknown              Reason = ""
	ReasonUnspecified          Reason = "unspecified"
	ReasonKeyCompromise        Reason = "key_compromise"
	ReasonCaCompromise         Reason = "ca_compromise"
	ReasonAffiliationChanged   Reason = "affiliation_changed"
	ReasonSuperseded           Reason = "superseded"
	ReasonCessationOfOperation Reason = "cessation_of_operation"
	ReasonCertificateHold      Reason = "certificate_hold"
	ReasonRemoveFromCrl        Reason = "remove_from_crl"
	ReasonPrivilegeWithdrawn   Reason = "privilege_withdrawn"
	ReasonAaCompromise         Reason = "aa_compromise"
)

func (e Reason) ToPointer() *Reason {
	return &e
}
func (e *Reason) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "":
		fallthrough
	case "unspecified":
		fallthrough
	case "key_compromise":
		fallthrough
	case "ca_compromise":
		fallthrough
	case "affiliation_changed":
		fallthrough
	case "superseded":
		fallthrough
	case "cessation_of_operation":
		fallthrough
	case "certificate_hold":
		fallthrough
	case "remove_from_crl":
		fallthrough
	case "privilege_withdrawn":
		fallthrough
	case "aa_compromise":
		*e = Reason(v)
		return nil
	default:
		return fmt.Errorf("invalid value for Reason: %v", v)
	}
}

type CertificateRevocationRevocationInfo struct {
	NextUpdate *string `json:"next_update,omitempty"`
	// An enumerated value indicating the issuer-supplied reason for the revocation.
	Reason *Reason `json:"reason,omitempty"`
	// The issuer-supplied timestamp indicating when the certificate was revoked.
	RevocationTime *string `json:"revocation_time,omitempty"`
	// Whether the certificate has been revoked before its expiry date by the issuer.
	Revoked *bool `json:"revoked,omitempty"`
}

func (o *CertificateRevocationRevocationInfo) GetNextUpdate() *string {
	if o == nil {
		return nil
	}
	return o.NextUpdate
}

func (o *CertificateRevocationRevocationInfo) GetReason() *Reason {
	if o == nil {
		return nil
	}
	return o.Reason
}

func (o *CertificateRevocationRevocationInfo) GetRevocationTime() *string {
	if o == nil {
		return nil
	}
	return o.RevocationTime
}

func (o *CertificateRevocationRevocationInfo) GetRevoked() *bool {
	if o == nil {
		return nil
	}
	return o.Revoked
}
