// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package components

import (
	"encoding/json"
	"fmt"
	"github.com/censys/censys-sdk-go/internal/utils"
	"time"
)

type ChangeType string

const (
	ChangeTypeAdded   ChangeType = "added"
	ChangeTypeRemoved ChangeType = "removed"
)

func (e ChangeType) ToPointer() *ChangeType {
	return &e
}
func (e *ChangeType) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "added":
		fallthrough
	case "removed":
		*e = ChangeType(v)
		return nil
	default:
		return fmt.Errorf("invalid value for ChangeType: %v", v)
	}
}

type EventAssetChange struct {
	ChangeType ChangeType `json:"change_type"`
	EventTime  time.Time  `json:"event_time"`
	Reason     string     `json:"reason"`
}

func (e EventAssetChange) MarshalJSON() ([]byte, error) {
	return utils.MarshalJSON(e, "", false)
}

func (e *EventAssetChange) UnmarshalJSON(data []byte) error {
	if err := utils.UnmarshalJSON(data, &e, "", false, false); err != nil {
		return err
	}
	return nil
}

func (o *EventAssetChange) GetChangeType() ChangeType {
	if o == nil {
		return ChangeType("")
	}
	return o.ChangeType
}

func (o *EventAssetChange) GetEventTime() time.Time {
	if o == nil {
		return time.Time{}
	}
	return o.EventTime
}

func (o *EventAssetChange) GetReason() string {
	if o == nil {
		return ""
	}
	return o.Reason
}
