// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        (unknown)
// source: coinbase/cloud/blockchain/v1/blockchain.proto

package v1

import (
	_ "github.com/grpc-ecosystem/grpc-gateway/v2/protoc-gen-openapiv2/options"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The type of Network.
type Network_Type int32

const (
	// The default unused value.
	Network_TYPE_UNSPECIFIED Network_Type = 0
	// A mainnet Network, storing real funds.
	Network_MAINNET Network_Type = 1
	// A testnet Network, used for testing.
	Network_TESTNET Network_Type = 2
)

// Enum value maps for Network_Type.
var (
	Network_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "MAINNET",
		2: "TESTNET",
	}
	Network_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"MAINNET":          1,
		"TESTNET":          2,
	}
)

func (x Network_Type) Enum() *Network_Type {
	p := new(Network_Type)
	*p = x
	return p
}

func (x Network_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Network_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_coinbase_cloud_blockchain_v1_blockchain_proto_enumTypes[0].Descriptor()
}

func (Network_Type) Type() protoreflect.EnumType {
	return &file_coinbase_cloud_blockchain_v1_blockchain_proto_enumTypes[0]
}

func (x Network_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Network_Type.Descriptor instead.
func (Network_Type) EnumDescriptor() ([]byte, []int) {
	return file_coinbase_cloud_blockchain_v1_blockchain_proto_rawDescGZIP(), []int{0, 0}
}

// The Network resource, which represents a blockchain network.
type Network struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the Network.
	// Format: networks/{network_id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A user-readable name for the Network.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The native Asset for this Network.
	// Format: networks/{network_id}/assets/{asset_id}
	NativeAsset string `protobuf:"bytes,3,opt,name=native_asset,json=nativeAsset,proto3" json:"native_asset,omitempty"`
	// The protocol family this Network is a part of.
	// Today, the only supported value is "protocolFamilies/evm".
	ProtocolFamily string `protobuf:"bytes,4,opt,name=protocol_family,json=protocolFamily,proto3" json:"protocol_family,omitempty"`
	// The type of Network.
	Type Network_Type `protobuf:"varint,5,opt,name=type,proto3,enum=coinbase.cloud.blockchain.v1.Network_Type" json:"type,omitempty"`
}

func (x *Network) Reset() {
	*x = Network{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_blockchain_v1_blockchain_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Network) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Network) ProtoMessage() {}

func (x *Network) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_blockchain_v1_blockchain_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Network.ProtoReflect.Descriptor instead.
func (*Network) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_blockchain_v1_blockchain_proto_rawDescGZIP(), []int{0}
}

func (x *Network) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Network) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Network) GetNativeAsset() string {
	if x != nil {
		return x.NativeAsset
	}
	return ""
}

func (x *Network) GetProtocolFamily() string {
	if x != nil {
		return x.ProtocolFamily
	}
	return ""
}

func (x *Network) GetType() Network_Type {
	if x != nil {
		return x.Type
	}
	return Network_TYPE_UNSPECIFIED
}

// The Asset resource, which represents an on-chain asset.
type Asset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the Asset.
	// Format: networks/{network_id}/assets/{asset_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The symbol representation of this asset (e.g. ETH) as advertised by the Network.
	//
	// For a native Asset this may be implicit, e.g., the on-chain data may not include
	// any symbol reference.
	//
	// For some protocols there can be Assets with arbitrary symbols that are not globally
	// unique, and it should not be trusted to represent a canonical symbol/ticker.
	AdvertisedSymbol string `protobuf:"bytes,2,opt,name=advertised_symbol,json=advertisedSymbol,proto3" json:"advertised_symbol,omitempty"`
	// The number of decimals the Asset uses. Note: in some instances this
	// value can change over time.
	Decimals int32 `protobuf:"varint,3,opt,name=decimals,proto3" json:"decimals,omitempty"`
	// The Asset's definition.
	Definition *Asset_Definition `protobuf:"bytes,4,opt,name=definition,proto3" json:"definition,omitempty"`
}

func (x *Asset) Reset() {
	*x = Asset{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_blockchain_v1_blockchain_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Asset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Asset) ProtoMessage() {}

func (x *Asset) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_blockchain_v1_blockchain_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Asset.ProtoReflect.Descriptor instead.
func (*Asset) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_blockchain_v1_blockchain_proto_rawDescGZIP(), []int{1}
}

func (x *Asset) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Asset) GetAdvertisedSymbol() string {
	if x != nil {
		return x.AdvertisedSymbol
	}
	return ""
}

func (x *Asset) GetDecimals() int32 {
	if x != nil {
		return x.Decimals
	}
	return 0
}

func (x *Asset) GetDefinition() *Asset_Definition {
	if x != nil {
		return x.Definition
	}
	return nil
}

// The request message for GetNetwork.
type GetNetworkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the Network.
	// Format: networks/{network_id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetNetworkRequest) Reset() {
	*x = GetNetworkRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_blockchain_v1_blockchain_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetNetworkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetNetworkRequest) ProtoMessage() {}

func (x *GetNetworkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_blockchain_v1_blockchain_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetNetworkRequest.ProtoReflect.Descriptor instead.
func (*GetNetworkRequest) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_blockchain_v1_blockchain_proto_rawDescGZIP(), []int{2}
}

func (x *GetNetworkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for ListNetworks.
type ListNetworksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The maximum number of Networks to return. The default is 50.
	PageSize int32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous ListNetworks call.
	// Provide this to retrieve the subsequent page.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListNetworksRequest) Reset() {
	*x = ListNetworksRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_blockchain_v1_blockchain_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNetworksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNetworksRequest) ProtoMessage() {}

func (x *ListNetworksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_blockchain_v1_blockchain_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNetworksRequest.ProtoReflect.Descriptor instead.
func (*ListNetworksRequest) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_blockchain_v1_blockchain_proto_rawDescGZIP(), []int{3}
}

func (x *ListNetworksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListNetworksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for ListNetworks.
type ListNetworksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Networks.
	Networks []*Network `protobuf:"bytes,1,rep,name=networks,proto3" json:"networks,omitempty"`
	// A token, which can be sent as page_token to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListNetworksResponse) Reset() {
	*x = ListNetworksResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_blockchain_v1_blockchain_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListNetworksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListNetworksResponse) ProtoMessage() {}

func (x *ListNetworksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_blockchain_v1_blockchain_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListNetworksResponse.ProtoReflect.Descriptor instead.
func (*ListNetworksResponse) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_blockchain_v1_blockchain_proto_rawDescGZIP(), []int{4}
}

func (x *ListNetworksResponse) GetNetworks() []*Network {
	if x != nil {
		return x.Networks
	}
	return nil
}

func (x *ListNetworksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for GetAsset.
type GetAssetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the Asset.
	// Format: networks/{network_id}/assets/{asset_id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAssetRequest) Reset() {
	*x = GetAssetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_blockchain_v1_blockchain_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAssetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAssetRequest) ProtoMessage() {}

func (x *GetAssetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_blockchain_v1_blockchain_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAssetRequest.ProtoReflect.Descriptor instead.
func (*GetAssetRequest) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_blockchain_v1_blockchain_proto_rawDescGZIP(), []int{5}
}

func (x *GetAssetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for ListAssets.
type ListAssetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the parent Network.
	// Format: networks/{network_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of Assets to return. The default is 50.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous ListAssets call.
	// Provide this to retrieve the subsequent page.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter string which conforms to https://google.aip.dev/160.
	// Supported queries include any conjunction of the following:
	// 1. definition.asset_type (= | !=) "{asset_type}"
	// 2. definition.asset_group_id (= | !=) "{asset_group_id}"
	// 3. definition.sub_group_id (= | !=) "{sub_group_id}"
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListAssetsRequest) Reset() {
	*x = ListAssetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_blockchain_v1_blockchain_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAssetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAssetsRequest) ProtoMessage() {}

func (x *ListAssetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_blockchain_v1_blockchain_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAssetsRequest.ProtoReflect.Descriptor instead.
func (*ListAssetsRequest) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_blockchain_v1_blockchain_proto_rawDescGZIP(), []int{6}
}

func (x *ListAssetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAssetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAssetsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListAssetsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// The response message for ListAssets.
type ListAssetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Assets.
	Assets []*Asset `protobuf:"bytes,1,rep,name=assets,proto3" json:"assets,omitempty"`
	// A token, which can be sent as page_token to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAssetsResponse) Reset() {
	*x = ListAssetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_blockchain_v1_blockchain_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAssetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAssetsResponse) ProtoMessage() {}

func (x *ListAssetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_blockchain_v1_blockchain_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAssetsResponse.ProtoReflect.Descriptor instead.
func (*ListAssetsResponse) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_blockchain_v1_blockchain_proto_rawDescGZIP(), []int{7}
}

func (x *ListAssetsResponse) GetAssets() []*Asset {
	if x != nil {
		return x.Assets
	}
	return nil
}

func (x *ListAssetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for BatchGetAssets.
type BatchGetAssetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the parent Network.
	// Format: networks/{network_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The resource names of the Assets to retrieve.
	// Each name has format: networks/{network_id}/assets/{asset_id}
	// A maximum of 1000 Assets can be retrieved in a batch.
	Names []string `protobuf:"bytes,2,rep,name=names,proto3" json:"names,omitempty"`
}

func (x *BatchGetAssetsRequest) Reset() {
	*x = BatchGetAssetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_blockchain_v1_blockchain_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchGetAssetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetAssetsRequest) ProtoMessage() {}

func (x *BatchGetAssetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_blockchain_v1_blockchain_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetAssetsRequest.ProtoReflect.Descriptor instead.
func (*BatchGetAssetsRequest) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_blockchain_v1_blockchain_proto_rawDescGZIP(), []int{8}
}

func (x *BatchGetAssetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchGetAssetsRequest) GetNames() []string {
	if x != nil {
		return x.Names
	}
	return nil
}

// The response message for BatchGetAssets.
type BatchGetAssetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Assets.
	// Note: The returned Assets may not be in the same order as in the request.
	Assets []*Asset `protobuf:"bytes,1,rep,name=assets,proto3" json:"assets,omitempty"`
	// The resource names of the Assets that were not found.
	// Each name has format: networks/{network_id}/assets/{asset_id}.
	NotFound []string `protobuf:"bytes,2,rep,name=not_found,json=notFound,proto3" json:"not_found,omitempty"`
}

func (x *BatchGetAssetsResponse) Reset() {
	*x = BatchGetAssetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_blockchain_v1_blockchain_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchGetAssetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetAssetsResponse) ProtoMessage() {}

func (x *BatchGetAssetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_blockchain_v1_blockchain_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetAssetsResponse.ProtoReflect.Descriptor instead.
func (*BatchGetAssetsResponse) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_blockchain_v1_blockchain_proto_rawDescGZIP(), []int{9}
}

func (x *BatchGetAssetsResponse) GetAssets() []*Asset {
	if x != nil {
		return x.Assets
	}
	return nil
}

func (x *BatchGetAssetsResponse) GetNotFound() []string {
	if x != nil {
		return x.NotFound
	}
	return nil
}

// The defining characteristics that combine to uniquely identify an Asset on-chain.
// Fungible tokens, such as ERC-20s, require an asset_group_id (the contract address).
// Non-fungible tokens and multi-token assets such as ERC-721s and ERC-1155s
// require a both an asset_group_id and a sub_group_id (the token ID).
type Asset_Definition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of Asset the definition describes.
	// Possible values: "native", "erc20", "erc721", "erc1155"
	AssetType string `protobuf:"bytes,1,opt,name=asset_type,json=assetType,proto3" json:"asset_type,omitempty"`
	// The identifier that distinguishes this Asset group. Generally a
	// contract address for the Asset. For a native Asset this is not set.
	AssetGroupId string `protobuf:"bytes,2,opt,name=asset_group_id,json=assetGroupId,proto3" json:"asset_group_id,omitempty"`
	// The identifier that distinguishes the specific Asset within the
	// asset group. Generally a token ID. For a native Asset or ERC-20
	// this is not set.
	SubGroupId string `protobuf:"bytes,3,opt,name=sub_group_id,json=subGroupId,proto3" json:"sub_group_id,omitempty"`
}

func (x *Asset_Definition) Reset() {
	*x = Asset_Definition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_blockchain_v1_blockchain_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Asset_Definition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Asset_Definition) ProtoMessage() {}

func (x *Asset_Definition) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_blockchain_v1_blockchain_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Asset_Definition.ProtoReflect.Descriptor instead.
func (*Asset_Definition) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_blockchain_v1_blockchain_proto_rawDescGZIP(), []int{1, 0}
}

func (x *Asset_Definition) GetAssetType() string {
	if x != nil {
		return x.AssetType
	}
	return ""
}

func (x *Asset_Definition) GetAssetGroupId() string {
	if x != nil {
		return x.AssetGroupId
	}
	return ""
}

func (x *Asset_Definition) GetSubGroupId() string {
	if x != nil {
		return x.SubGroupId
	}
	return ""
}

var File_coinbase_cloud_blockchain_v1_blockchain_proto protoreflect.FileDescriptor

var file_coinbase_cloud_blockchain_v1_blockchain_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x2f, 0x76, 0x31, 0x2f, 0x62,
	0x6c, 0x6f, 0x63, 0x6b, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1c, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x2d, 0x67, 0x65, 0x6e, 0x2d, 0x6f, 0x70, 0x65,
	0x6e, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0xea, 0x07, 0x0a, 0x07, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x7a, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x66, 0x92, 0x41, 0x63, 0x2a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x32, 0x3f, 0x54, 0x68, 0x65, 0x20, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x0a, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x3a,
	0x20, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x7b, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x5f, 0x69, 0x64, 0x7d, 0x4a, 0x1a, 0x22, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x2f, 0x65, 0x74, 0x68, 0x65, 0x72, 0x65, 0x75, 0x6d, 0x2d, 0x67, 0x6f, 0x65, 0x72, 0x6c,
	0x69, 0x22, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x75, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x52,
	0x92, 0x41, 0x4f, 0x2a, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x32, 0x25, 0x41, 0x20, 0x75, 0x73, 0x65, 0x72, 0x2d, 0x72, 0x65, 0x61, 0x64, 0x61, 0x62, 0x6c,
	0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x4a, 0x19, 0x22, 0x47, 0x6f, 0x65, 0x72, 0x6c, 0x69,
	0x20, 0x45, 0x74, 0x68, 0x65, 0x72, 0x65, 0x75, 0x6d, 0x20, 0x54, 0x65, 0x73, 0x74, 0x6e, 0x65,
	0x74, 0x22, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0xf6, 0x01, 0x0a, 0x0c, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0xd2, 0x01, 0x92, 0x41, 0xa9, 0x01, 0x2a, 0x0b, 0x6e,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x41, 0x73, 0x73, 0x65, 0x74, 0x32, 0x52, 0x54, 0x68, 0x65, 0x20,
	0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x20, 0x41, 0x73, 0x73, 0x65, 0x74, 0x20, 0x66, 0x6f, 0x72,
	0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x0a, 0x46,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x3a, 0x20, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f,
	0x7b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x4a, 0x46,
	0x22, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x65, 0x74, 0x68, 0x65, 0x72, 0x65,
	0x75, 0x6d, 0x2d, 0x67, 0x6f, 0x65, 0x72, 0x6c, 0x69, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73,
	0x2f, 0x30, 0x63, 0x33, 0x35, 0x36, 0x39, 0x64, 0x33, 0x2d, 0x62, 0x32, 0x35, 0x33, 0x2d, 0x35,
	0x31, 0x32, 0x38, 0x2d, 0x61, 0x32, 0x32, 0x39, 0x2d, 0x35, 0x34, 0x33, 0x65, 0x31, 0x65, 0x38,
	0x31, 0x39, 0x34, 0x33, 0x30, 0x22, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x61, 0x70, 0x69, 0x2e, 0x64,
	0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73,
	0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x0b, 0x6e, 0x61, 0x74,
	0x69, 0x76, 0x65, 0x41, 0x73, 0x73, 0x65, 0x74, 0x12, 0xc1, 0x01, 0x0a, 0x0f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x5f, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x97, 0x01, 0x92, 0x41, 0x93, 0x01, 0x2a, 0x0e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x32, 0x69, 0x54, 0x68, 0x65, 0x20, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x20, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x20, 0x74,
	0x68, 0x69, 0x73, 0x20, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x20, 0x69, 0x73, 0x20, 0x61,
	0x20, 0x70, 0x61, 0x72, 0x74, 0x20, 0x6f, 0x66, 0x2e, 0x0a, 0x54, 0x6f, 0x64, 0x61, 0x79, 0x2c,
	0x20, 0x74, 0x68, 0x65, 0x20, 0x6f, 0x6e, 0x6c, 0x79, 0x20, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72,
	0x74, 0x65, 0x64, 0x20, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x69, 0x73, 0x20, 0x27, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x69, 0x65, 0x73, 0x2f, 0x65,
	0x76, 0x6d, 0x27, 0x2e, 0x4a, 0x16, 0x22, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x46,
	0x61, 0x6d, 0x69, 0x6c, 0x69, 0x65, 0x73, 0x2f, 0x65, 0x76, 0x6d, 0x22, 0x52, 0x0e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x12, 0x6a, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x63, 0x6f, 0x69,
	0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x6c, 0x6f, 0x63,
	0x6b, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x2a, 0x92, 0x41, 0x27, 0x2a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x32, 0x14, 0x54, 0x68, 0x65, 0x20, 0x74, 0x79, 0x70, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x4a, 0x09, 0x22, 0x54, 0x45, 0x53, 0x54, 0x4e, 0x45,
	0x54, 0x22, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x36, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x4d, 0x41, 0x49, 0x4e, 0x4e, 0x45,
	0x54, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x54, 0x45, 0x53, 0x54, 0x4e, 0x45, 0x54, 0x10, 0x02,
	0x3a, 0x8a, 0x01, 0x92, 0x41, 0x49, 0x0a, 0x47, 0x2a, 0x07, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x32, 0x3c, 0x54, 0x68, 0x65, 0x20, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x20, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2c, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x72,
	0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x73, 0x20, 0x61, 0x20, 0x62, 0x6c, 0x6f, 0x63,
	0x6b, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x20, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0xea,
	0x41, 0x3b, 0x0a, 0x22, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65,
	0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x15, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x2f, 0x7b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x64, 0x7d, 0x22, 0xd3, 0x0f,
	0x0a, 0x05, 0x41, 0x73, 0x73, 0x65, 0x74, 0x12, 0xb8, 0x01, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0xa3, 0x01, 0x92, 0x41, 0x9f, 0x01, 0x2a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x32, 0x4f, 0x54, 0x68, 0x65, 0x20, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x2e, 0x0a, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x3a, 0x20, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x7b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69,
	0x64, 0x7d, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x5f, 0x69, 0x64, 0x7d, 0x4a, 0x46, 0x22, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f,
	0x65, 0x74, 0x68, 0x65, 0x72, 0x65, 0x75, 0x6d, 0x2d, 0x67, 0x6f, 0x65, 0x72, 0x6c, 0x69, 0x2f,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x30, 0x63, 0x33, 0x35, 0x36, 0x39, 0x64, 0x33, 0x2d,
	0x62, 0x32, 0x35, 0x33, 0x2d, 0x35, 0x31, 0x32, 0x38, 0x2d, 0x61, 0x32, 0x32, 0x39, 0x2d, 0x35,
	0x34, 0x33, 0x65, 0x31, 0x65, 0x38, 0x31, 0x39, 0x34, 0x33, 0x30, 0x22, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0xa6, 0x03, 0x0a, 0x11, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65,
	0x64, 0x5f, 0x73, 0x79, 0x6d, 0x62, 0x6f, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0xf8,
	0x02, 0x92, 0x41, 0xf4, 0x02, 0x2a, 0x10, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65,
	0x64, 0x53, 0x79, 0x6d, 0x62, 0x6f, 0x6c, 0x32, 0xd8, 0x02, 0x54, 0x68, 0x65, 0x20, 0x73, 0x79,
	0x6d, 0x62, 0x6f, 0x6c, 0x20, 0x72, 0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x20, 0x28, 0x65, 0x2e, 0x67, 0x2e, 0x20, 0x45, 0x54, 0x48, 0x29, 0x20, 0x61, 0x73, 0x20,
	0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x64, 0x20, 0x62, 0x79, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x0a, 0x46, 0x6f, 0x72, 0x20, 0x61,
	0x20, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x20, 0x41, 0x73, 0x73, 0x65, 0x74, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x6d, 0x61, 0x79, 0x20, 0x62, 0x65, 0x20, 0x69, 0x6d, 0x70, 0x6c, 0x69, 0x63,
	0x69, 0x74, 0x2c, 0x20, 0x65, 0x2e, 0x67, 0x2e, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6f, 0x6e,
	0x2d, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x20, 0x64, 0x61, 0x74, 0x61, 0x20, 0x6d, 0x61, 0x79, 0x20,
	0x6e, 0x6f, 0x74, 0x20, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x20, 0x61, 0x6e, 0x79, 0x20,
	0x73, 0x79, 0x6d, 0x62, 0x6f, 0x6c, 0x20, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x2e, 0x0a, 0x46, 0x6f, 0x72, 0x20, 0x73, 0x6f, 0x6d, 0x65, 0x20, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x63, 0x6f, 0x6c, 0x73, 0x20, 0x74, 0x68, 0x65, 0x72, 0x65, 0x20, 0x63, 0x61, 0x6e, 0x20, 0x62,
	0x65, 0x20, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x61, 0x72,
	0x62, 0x69, 0x74, 0x72, 0x61, 0x72, 0x79, 0x20, 0x73, 0x79, 0x6d, 0x62, 0x6f, 0x6c, 0x73, 0x20,
	0x74, 0x68, 0x61, 0x74, 0x20, 0x61, 0x72, 0x65, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x67, 0x6c, 0x6f,
	0x62, 0x61, 0x6c, 0x6c, 0x79, 0x20, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x2c, 0x20, 0x61, 0x6e,
	0x64, 0x20, 0x69, 0x74, 0x20, 0x73, 0x68, 0x6f, 0x75, 0x6c, 0x64, 0x20, 0x6e, 0x6f, 0x74, 0x20,
	0x62, 0x65, 0x20, 0x74, 0x72, 0x75, 0x73, 0x74, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x72, 0x65,
	0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x20, 0x61, 0x20, 0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69,
	0x63, 0x61, 0x6c, 0x20, 0x73, 0x79, 0x6d, 0x62, 0x6f, 0x6c, 0x2f, 0x74, 0x69, 0x63, 0x6b, 0x65,
	0x72, 0x2e, 0x4a, 0x05, 0x22, 0x45, 0x54, 0x48, 0x22, 0x52, 0x10, 0x61, 0x64, 0x76, 0x65, 0x72,
	0x74, 0x69, 0x73, 0x65, 0x64, 0x53, 0x79, 0x6d, 0x62, 0x6f, 0x6c, 0x12, 0x90, 0x01, 0x0a, 0x08,
	0x64, 0x65, 0x63, 0x69, 0x6d, 0x61, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x74,
	0x92, 0x41, 0x71, 0x2a, 0x08, 0x64, 0x65, 0x63, 0x69, 0x6d, 0x61, 0x6c, 0x73, 0x32, 0x5f, 0x54,
	0x68, 0x65, 0x20, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x20, 0x6f, 0x66, 0x20, 0x64, 0x65, 0x63,
	0x69, 0x6d, 0x61, 0x6c, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x41, 0x73, 0x73, 0x65, 0x74, 0x20,
	0x75, 0x73, 0x65, 0x73, 0x2e, 0x0a, 0x4e, 0x6f, 0x74, 0x65, 0x3a, 0x20, 0x69, 0x6e, 0x20, 0x73,
	0x6f, 0x6d, 0x65, 0x20, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x63, 0x61, 0x6e, 0x20, 0x63, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x20, 0x6f, 0x76, 0x65, 0x72, 0x20, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x4a, 0x04,
	0x22, 0x31, 0x38, 0x22, 0x52, 0x08, 0x64, 0x65, 0x63, 0x69, 0x6d, 0x61, 0x6c, 0x73, 0x12, 0x78,
	0x0a, 0x0a, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x28, 0x92, 0x41, 0x25, 0x2a, 0x0a, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x32, 0x17, 0x54, 0x68, 0x65, 0x20, 0x41, 0x73, 0x73, 0x65, 0x74, 0x27, 0x73,
	0x20, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x52, 0x0a, 0x64, 0x65,
	0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xc2, 0x07, 0x0a, 0x0a, 0x44, 0x65, 0x66,
	0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x9c, 0x01, 0x0a, 0x0a, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x7d, 0x92, 0x41,
	0x7a, 0x2a, 0x09, 0x61, 0x73, 0x73, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x32, 0x63, 0x54, 0x68,
	0x65, 0x20, 0x74, 0x79, 0x70, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x41, 0x73, 0x73, 0x65, 0x74, 0x20,
	0x74, 0x68, 0x65, 0x20, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x73, 0x2e, 0x0a, 0x50, 0x6f, 0x73, 0x73, 0x69, 0x62,
	0x6c, 0x65, 0x20, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x3a, 0x20, 0x27, 0x6e, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x27, 0x2c, 0x20, 0x27, 0x65, 0x72, 0x63, 0x32, 0x30, 0x27, 0x2c, 0x20, 0x27, 0x65,
	0x72, 0x63, 0x37, 0x32, 0x31, 0x27, 0x2c, 0x20, 0x27, 0x65, 0x72, 0x63, 0x31, 0x31, 0x35, 0x35,
	0x27, 0x4a, 0x08, 0x22, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x22, 0x52, 0x09, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0xf9, 0x01, 0x0a, 0x0e, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0xd2, 0x01, 0x92, 0x41, 0xce, 0x01, 0x2a, 0x0c, 0x61, 0x73, 0x73, 0x65, 0x74, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x49, 0x64, 0x32, 0x8f, 0x01, 0x54, 0x68, 0x65, 0x20, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x66, 0x69, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x64, 0x69, 0x73, 0x74, 0x69,
	0x6e, 0x67, 0x75, 0x69, 0x73, 0x68, 0x65, 0x73, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x20, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x0a, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x6c, 0x6c, 0x79, 0x20, 0x61, 0x20, 0x30, 0x78, 0x2d, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x65, 0x64, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x61, 0x63, 0x74, 0x20, 0x61, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x41, 0x73, 0x73, 0x65,
	0x74, 0x2e, 0x20, 0x46, 0x6f, 0x72, 0x20, 0x61, 0x20, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x20,
	0x41, 0x73, 0x73, 0x65, 0x74, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x69, 0x73, 0x20, 0x6e, 0x6f,
	0x74, 0x20, 0x73, 0x65, 0x74, 0x2e, 0x4a, 0x2c, 0x22, 0x30, 0x78, 0x38, 0x38, 0x37, 0x43, 0x46,
	0x65, 0x33, 0x31, 0x43, 0x38, 0x38, 0x38, 0x45, 0x45, 0x30, 0x37, 0x38, 0x30, 0x37, 0x39, 0x35,
	0x62, 0x37, 0x66, 0x65, 0x46, 0x46, 0x34, 0x36, 0x43, 0x45, 0x37, 0x66, 0x39, 0x41, 0x42, 0x35,
	0x35, 0x36, 0x43, 0x22, 0x52, 0x0c, 0x61, 0x73, 0x73, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x49, 0x64, 0x12, 0xc6, 0x01, 0x0a, 0x0c, 0x73, 0x75, 0x62, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0xa3, 0x01, 0x92, 0x41, 0x9f, 0x01,
	0x2a, 0x0a, 0x73, 0x75, 0x62, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x32, 0x90, 0x01, 0x54,
	0x68, 0x65, 0x20, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x20, 0x74, 0x68,
	0x61, 0x74, 0x20, 0x64, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x75, 0x69, 0x73, 0x68, 0x65, 0x73,
	0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x20, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x20, 0x77, 0x69, 0x74, 0x68, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x20, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x0a, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x6c, 0x6c, 0x79, 0x20, 0x61, 0x20, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x20, 0x49, 0x44,
	0x2e, 0x20, 0x46, 0x6f, 0x72, 0x20, 0x61, 0x20, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x20, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x20, 0x6f, 0x72, 0x20, 0x45, 0x52, 0x43, 0x2d, 0x32, 0x30, 0x20, 0x74,
	0x68, 0x69, 0x73, 0x20, 0x69, 0x73, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x73, 0x65, 0x74, 0x2e, 0x52,
	0x0a, 0x73, 0x75, 0x62, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x3a, 0xcf, 0x02, 0x92, 0x41,
	0xcb, 0x02, 0x0a, 0xc8, 0x02, 0x2a, 0x10, 0x41, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x44, 0x65, 0x66,
	0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x32, 0xb3, 0x02, 0x54, 0x68, 0x65, 0x20, 0x64, 0x65,
	0x66, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x20, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72,
	0x69, 0x73, 0x74, 0x69, 0x63, 0x73, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x63, 0x6f, 0x6d, 0x62,
	0x69, 0x6e, 0x65, 0x20, 0x74, 0x6f, 0x20, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x6c, 0x79, 0x20,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x20, 0x61, 0x6e, 0x20, 0x41, 0x73, 0x73, 0x65,
	0x74, 0x20, 0x6f, 0x6e, 0x2d, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x2e, 0x0a, 0x46, 0x75, 0x6e, 0x67,
	0x69, 0x62, 0x6c, 0x65, 0x20, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x2c, 0x20, 0x73, 0x75, 0x63,
	0x68, 0x20, 0x61, 0x73, 0x20, 0x45, 0x52, 0x43, 0x2d, 0x32, 0x30, 0x73, 0x2c, 0x20, 0x72, 0x65,
	0x71, 0x75, 0x69, 0x72, 0x65, 0x20, 0x61, 0x6e, 0x20, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x20, 0x28, 0x74, 0x68, 0x65, 0x20, 0x63, 0x6f, 0x6e,
	0x74, 0x72, 0x61, 0x63, 0x74, 0x20, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x29, 0x2e, 0x0a,
	0x4e, 0x6f, 0x6e, 0x2d, 0x66, 0x75, 0x6e, 0x67, 0x69, 0x62, 0x6c, 0x65, 0x20, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x2d, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x20, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x20, 0x73, 0x75, 0x63, 0x68, 0x20,
	0x61, 0x73, 0x20, 0x45, 0x52, 0x43, 0x2d, 0x37, 0x32, 0x31, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20,
	0x45, 0x52, 0x43, 0x2d, 0x31, 0x31, 0x35, 0x35, 0x73, 0x20, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72,
	0x65, 0x20, 0x61, 0x20, 0x62, 0x6f, 0x74, 0x68, 0x20, 0x61, 0x6e, 0x20, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x61,
	0x20, 0x73, 0x75, 0x62, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x20, 0x28, 0x74,
	0x68, 0x65, 0x20, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x20, 0x49, 0x44, 0x29, 0x2e, 0x3a, 0x93, 0x01,
	0x92, 0x41, 0x42, 0x0a, 0x40, 0x2a, 0x05, 0x41, 0x73, 0x73, 0x65, 0x74, 0x32, 0x37, 0x54, 0x68,
	0x65, 0x20, 0x41, 0x73, 0x73, 0x65, 0x74, 0x20, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2c, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x72, 0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e,
	0x74, 0x73, 0x20, 0x61, 0x6e, 0x20, 0x6f, 0x6e, 0x2d, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x20, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x2e, 0xea, 0x41, 0x4b, 0x0a, 0x20, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65,
	0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x12, 0x27, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x7b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x64,
	0x7d, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f,
	0x69, 0x64, 0x7d, 0x22, 0x68, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x53, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3f, 0x92, 0x41, 0x11, 0xca, 0x3e, 0x0e, 0xfa, 0x02,
	0x0b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x4e, 0x61, 0x6d, 0x65, 0xe2, 0x41, 0x01, 0x02,
	0xfa, 0x41, 0x24, 0x0a, 0x22, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70,
	0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x51, 0x0a,
	0x13, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0xc6, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x41, 0x0a, 0x08, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x63, 0x6f,
	0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x6c, 0x6f,
	0x63, 0x6b, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x52, 0x08, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x3a, 0x43, 0x92, 0x41, 0x40, 0x0a, 0x3e, 0x2a, 0x14, 0x4c, 0x69, 0x73,
	0x74, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x32, 0x26, 0x54, 0x68, 0x65, 0x20, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x20,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x4c, 0x69, 0x73, 0x74,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2e, 0x22, 0x62, 0x0a, 0x0f, 0x47, 0x65, 0x74,
	0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3b, 0x92, 0x41, 0x0f, 0xca,
	0x3e, 0x0c, 0xfa, 0x02, 0x09, 0x61, 0x73, 0x73, 0x65, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0xe2, 0x41,
	0x01, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c,
	0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xbe, 0x01,
	0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x55, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x3d, 0x92, 0x41, 0x11, 0xca, 0x3e, 0x0e, 0xfa, 0x02, 0x0b, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x4e, 0x61, 0x6d, 0x65, 0xe2, 0x41, 0x01, 0x02, 0xfa, 0x41, 0x22,
	0x12, 0x20, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e,
	0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xba,
	0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3b, 0x0a, 0x06, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x63, 0x68, 0x61, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x06, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x3a, 0x3f, 0x92, 0x41, 0x3c, 0x0a,
	0x3a, 0x2a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x32, 0x24, 0x54, 0x68, 0x65, 0x20, 0x72, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x20, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x20, 0x66, 0x6f, 0x72, 0x20,
	0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2e, 0x22, 0xaf, 0x01, 0x0a, 0x15,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x55, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3d, 0x92, 0x41, 0x11, 0xca, 0x3e, 0x0e, 0xfa, 0x02, 0x0b,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x4e, 0x61, 0x6d, 0x65, 0xe2, 0x41, 0x01, 0x02, 0xfa,
	0x41, 0x22, 0x12, 0x20, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65,
	0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x3f, 0x0a, 0x05,
	0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x29, 0xe2, 0x41, 0x01,
	0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f,
	0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x05, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x22, 0xbb, 0x01,
	0x0a, 0x16, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3b, 0x0a, 0x06, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62,
	0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x63,
	0x68, 0x61, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x06, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x6e, 0x6f, 0x74, 0x5f, 0x66, 0x6f, 0x75,
	0x6e, 0x64, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x6e, 0x6f, 0x74, 0x46, 0x6f, 0x75,
	0x6e, 0x64, 0x3a, 0x47, 0x92, 0x41, 0x44, 0x0a, 0x42, 0x2a, 0x16, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x47, 0x65, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x32, 0x28, 0x54, 0x68, 0x65, 0x20, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x20,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x47, 0x65, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x2e, 0x32, 0xfa, 0x0a, 0x0a, 0x11,
	0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x12, 0xc0, 0x01, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x12, 0x2f, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x25, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x22, 0x5a, 0x92, 0x41, 0x33, 0x12, 0x0a, 0x47,
	0x65, 0x74, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x1a, 0x25, 0x52, 0x65, 0x74, 0x72, 0x69,
	0x65, 0x76, 0x65, 0x73, 0x20, 0x61, 0x20, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x20, 0x62,
	0x79, 0x20, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x2e,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x17, 0x12, 0x15, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xcd, 0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x73, 0x12, 0x31, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x63, 0x68, 0x61, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62,
	0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x63,
	0x68, 0x61, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x56, 0x92, 0x41,
	0x3f, 0x12, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x1a,
	0x2f, 0x52, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6c, 0x69, 0x73,
	0x74, 0x20, 0x6f, 0x66, 0x20, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x20, 0x61, 0x76,
	0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x75, 0x73, 0x65, 0x2e,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x0e, 0x12, 0x0c, 0x2f, 0x76, 0x31, 0x2f, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x12, 0xc0, 0x01, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x41, 0x73, 0x73, 0x65,
	0x74, 0x12, 0x2d, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x23, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x73, 0x73, 0x65, 0x74, 0x22, 0x60, 0x92, 0x41, 0x30, 0x12, 0x08, 0x47, 0x65, 0x74, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x1a, 0x24, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x73, 0x20,
	0x61, 0x6e, 0x20, 0x41, 0x73, 0x73, 0x65, 0x74, 0x20, 0x62, 0x79, 0x20, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x2e, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x20, 0x12, 0x1e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x73,
	0x73, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe7, 0x01, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74,
	0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x12, 0x2f, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x63, 0x68, 0x61,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61,
	0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x63, 0x68,
	0x61, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x76, 0x92, 0x41, 0x44, 0x12, 0x0a,
	0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x1a, 0x36, 0x52, 0x65, 0x74, 0x75,
	0x72, 0x6e, 0x73, 0x20, 0x61, 0x20, 0x6c, 0x69, 0x73, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x73, 0x20, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x20, 0x6f,
	0x6e, 0x20, 0x61, 0x20, 0x67, 0x69, 0x76, 0x65, 0x6e, 0x20, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x2e, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x20, 0x12, 0x1e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x73, 0x12, 0x8b, 0x02, 0x0a, 0x0e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x73, 0x12, 0x33, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x63, 0x68, 0x61, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x41, 0x73, 0x73, 0x65,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x63, 0x6f, 0x69, 0x6e,
	0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x6c, 0x6f, 0x63, 0x6b,
	0x63, 0x68, 0x61, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65,
	0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x8d, 0x01, 0x92, 0x41, 0x4c, 0x12, 0x0e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x73, 0x1a, 0x3a, 0x52, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x73, 0x20, 0x74,
	0x68, 0x65, 0x20, 0x6c, 0x69, 0x73, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x41, 0x73, 0x73, 0x65, 0x74,
	0x73, 0x20, 0x69, 0x6e, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x20, 0x62, 0x79, 0x20, 0x74,
	0x68, 0x65, 0x20, 0x67, 0x69, 0x76, 0x65, 0x6e, 0x20, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x2e, 0xda, 0x41, 0x0c, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6e, 0x61, 0x6d, 0x65, 0x73,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x29, 0x12, 0x27, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x1a,
	0x96, 0x02, 0x92, 0x41, 0xe5, 0x01, 0x12, 0xe2, 0x01, 0x41, 0x20, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x20, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x61, 0x20, 0x73,
	0x65, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x72, 0x65, 0x61, 0x64, 0x2d, 0x6f, 0x6e, 0x6c, 0x79, 0x20,
	0x41, 0x50, 0x49, 0x73, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x69, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x20, 0x61, 0x62, 0x6f, 0x75, 0x74, 0x20, 0x74, 0x68, 0x65, 0x20, 0x62,
	0x6c, 0x6f, 0x63, 0x6b, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x20, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x57, 0x61, 0x61, 0x53, 0x20, 0x73, 0x75, 0x70,
	0x70, 0x6f, 0x72, 0x74, 0x73, 0x2e, 0x20, 0x55, 0x73, 0x65, 0x72, 0x73, 0x20, 0x63, 0x61, 0x6e,
	0x20, 0x71, 0x75, 0x65, 0x72, 0x79, 0x20, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x63, 0x68, 0x61, 0x69,
	0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x20, 0x74, 0x6f, 0x20, 0x66, 0x69, 0x67, 0x75,
	0x72, 0x65, 0x20, 0x6f, 0x75, 0x74, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x20, 0x74,
	0x68, 0x61, 0x74, 0x20, 0x63, 0x61, 0x6e, 0x20, 0x62, 0x65, 0x20, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x61, 0x63, 0x74, 0x65, 0x64, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x75, 0x73, 0x69, 0x6e, 0x67,
	0x20, 0x57, 0x61, 0x61, 0x53, 0x20, 0x41, 0x50, 0x49, 0x73, 0x2e, 0xca, 0x41, 0x2a, 0x61, 0x70,
	0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e,
	0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x77, 0x61, 0x61, 0x73, 0x2f, 0x62, 0x6c,
	0x6f, 0x63, 0x6b, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x42, 0xbd, 0x01, 0x5a, 0x4e, 0x67, 0x69, 0x74,
	0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65,
	0x2f, 0x77, 0x61, 0x61, 0x73, 0x2d, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2d, 0x6c, 0x69, 0x62,
	0x72, 0x61, 0x72, 0x79, 0x2d, 0x67, 0x6f, 0x2f, 0x67, 0x65, 0x6e, 0x2f, 0x67, 0x6f, 0x2f, 0x63,
	0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62, 0x6c,
	0x6f, 0x63, 0x6b, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x2f, 0x76, 0x31, 0x92, 0x41, 0x6a, 0x12, 0x15,
	0x0a, 0x0e, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x20, 0x41, 0x50, 0x49,
	0x32, 0x03, 0x31, 0x2e, 0x30, 0x1a, 0x2a, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c,
	0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x77, 0x61, 0x61, 0x73, 0x2f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x63, 0x68, 0x61, 0x69,
	0x6e, 0x2a, 0x01, 0x02, 0x32, 0x10, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2f, 0x6a, 0x73, 0x6f, 0x6e, 0x3a, 0x10, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2f, 0x6a, 0x73, 0x6f, 0x6e, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_coinbase_cloud_blockchain_v1_blockchain_proto_rawDescOnce sync.Once
	file_coinbase_cloud_blockchain_v1_blockchain_proto_rawDescData = file_coinbase_cloud_blockchain_v1_blockchain_proto_rawDesc
)

func file_coinbase_cloud_blockchain_v1_blockchain_proto_rawDescGZIP() []byte {
	file_coinbase_cloud_blockchain_v1_blockchain_proto_rawDescOnce.Do(func() {
		file_coinbase_cloud_blockchain_v1_blockchain_proto_rawDescData = protoimpl.X.CompressGZIP(file_coinbase_cloud_blockchain_v1_blockchain_proto_rawDescData)
	})
	return file_coinbase_cloud_blockchain_v1_blockchain_proto_rawDescData
}

var file_coinbase_cloud_blockchain_v1_blockchain_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_coinbase_cloud_blockchain_v1_blockchain_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_coinbase_cloud_blockchain_v1_blockchain_proto_goTypes = []interface{}{
	(Network_Type)(0),              // 0: coinbase.cloud.blockchain.v1.Network.Type
	(*Network)(nil),                // 1: coinbase.cloud.blockchain.v1.Network
	(*Asset)(nil),                  // 2: coinbase.cloud.blockchain.v1.Asset
	(*GetNetworkRequest)(nil),      // 3: coinbase.cloud.blockchain.v1.GetNetworkRequest
	(*ListNetworksRequest)(nil),    // 4: coinbase.cloud.blockchain.v1.ListNetworksRequest
	(*ListNetworksResponse)(nil),   // 5: coinbase.cloud.blockchain.v1.ListNetworksResponse
	(*GetAssetRequest)(nil),        // 6: coinbase.cloud.blockchain.v1.GetAssetRequest
	(*ListAssetsRequest)(nil),      // 7: coinbase.cloud.blockchain.v1.ListAssetsRequest
	(*ListAssetsResponse)(nil),     // 8: coinbase.cloud.blockchain.v1.ListAssetsResponse
	(*BatchGetAssetsRequest)(nil),  // 9: coinbase.cloud.blockchain.v1.BatchGetAssetsRequest
	(*BatchGetAssetsResponse)(nil), // 10: coinbase.cloud.blockchain.v1.BatchGetAssetsResponse
	(*Asset_Definition)(nil),       // 11: coinbase.cloud.blockchain.v1.Asset.Definition
}
var file_coinbase_cloud_blockchain_v1_blockchain_proto_depIdxs = []int32{
	0,  // 0: coinbase.cloud.blockchain.v1.Network.type:type_name -> coinbase.cloud.blockchain.v1.Network.Type
	11, // 1: coinbase.cloud.blockchain.v1.Asset.definition:type_name -> coinbase.cloud.blockchain.v1.Asset.Definition
	1,  // 2: coinbase.cloud.blockchain.v1.ListNetworksResponse.networks:type_name -> coinbase.cloud.blockchain.v1.Network
	2,  // 3: coinbase.cloud.blockchain.v1.ListAssetsResponse.assets:type_name -> coinbase.cloud.blockchain.v1.Asset
	2,  // 4: coinbase.cloud.blockchain.v1.BatchGetAssetsResponse.assets:type_name -> coinbase.cloud.blockchain.v1.Asset
	3,  // 5: coinbase.cloud.blockchain.v1.BlockchainService.GetNetwork:input_type -> coinbase.cloud.blockchain.v1.GetNetworkRequest
	4,  // 6: coinbase.cloud.blockchain.v1.BlockchainService.ListNetworks:input_type -> coinbase.cloud.blockchain.v1.ListNetworksRequest
	6,  // 7: coinbase.cloud.blockchain.v1.BlockchainService.GetAsset:input_type -> coinbase.cloud.blockchain.v1.GetAssetRequest
	7,  // 8: coinbase.cloud.blockchain.v1.BlockchainService.ListAssets:input_type -> coinbase.cloud.blockchain.v1.ListAssetsRequest
	9,  // 9: coinbase.cloud.blockchain.v1.BlockchainService.BatchGetAssets:input_type -> coinbase.cloud.blockchain.v1.BatchGetAssetsRequest
	1,  // 10: coinbase.cloud.blockchain.v1.BlockchainService.GetNetwork:output_type -> coinbase.cloud.blockchain.v1.Network
	5,  // 11: coinbase.cloud.blockchain.v1.BlockchainService.ListNetworks:output_type -> coinbase.cloud.blockchain.v1.ListNetworksResponse
	2,  // 12: coinbase.cloud.blockchain.v1.BlockchainService.GetAsset:output_type -> coinbase.cloud.blockchain.v1.Asset
	8,  // 13: coinbase.cloud.blockchain.v1.BlockchainService.ListAssets:output_type -> coinbase.cloud.blockchain.v1.ListAssetsResponse
	10, // 14: coinbase.cloud.blockchain.v1.BlockchainService.BatchGetAssets:output_type -> coinbase.cloud.blockchain.v1.BatchGetAssetsResponse
	10, // [10:15] is the sub-list for method output_type
	5,  // [5:10] is the sub-list for method input_type
	5,  // [5:5] is the sub-list for extension type_name
	5,  // [5:5] is the sub-list for extension extendee
	0,  // [0:5] is the sub-list for field type_name
}

func init() { file_coinbase_cloud_blockchain_v1_blockchain_proto_init() }
func file_coinbase_cloud_blockchain_v1_blockchain_proto_init() {
	if File_coinbase_cloud_blockchain_v1_blockchain_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_coinbase_cloud_blockchain_v1_blockchain_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Network); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_blockchain_v1_blockchain_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Asset); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_blockchain_v1_blockchain_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetNetworkRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_blockchain_v1_blockchain_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListNetworksRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_blockchain_v1_blockchain_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListNetworksResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_blockchain_v1_blockchain_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAssetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_blockchain_v1_blockchain_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAssetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_blockchain_v1_blockchain_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAssetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_blockchain_v1_blockchain_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchGetAssetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_blockchain_v1_blockchain_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchGetAssetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_blockchain_v1_blockchain_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Asset_Definition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_coinbase_cloud_blockchain_v1_blockchain_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_coinbase_cloud_blockchain_v1_blockchain_proto_goTypes,
		DependencyIndexes: file_coinbase_cloud_blockchain_v1_blockchain_proto_depIdxs,
		EnumInfos:         file_coinbase_cloud_blockchain_v1_blockchain_proto_enumTypes,
		MessageInfos:      file_coinbase_cloud_blockchain_v1_blockchain_proto_msgTypes,
	}.Build()
	File_coinbase_cloud_blockchain_v1_blockchain_proto = out.File
	file_coinbase_cloud_blockchain_v1_blockchain_proto_rawDesc = nil
	file_coinbase_cloud_blockchain_v1_blockchain_proto_goTypes = nil
	file_coinbase_cloud_blockchain_v1_blockchain_proto_depIdxs = nil
}
