// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/api/v2/listener/listener_components.proto

package listener

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on Filter with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Filter) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Filter with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in FilterMultiError, or nil if none found.
func (m *Filter) ValidateAll() error {
	return m.validate(true)
}

func (m *Filter) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetName()) < 1 {
		err := FilterValidationError{
			field:  "Name",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	switch v := m.ConfigType.(type) {
	case *Filter_Config:
		if v == nil {
			err := FilterValidationError{
				field:  "ConfigType",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetConfig()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, FilterValidationError{
						field:  "Config",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, FilterValidationError{
						field:  "Config",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetConfig()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return FilterValidationError{
					field:  "Config",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *Filter_TypedConfig:
		if v == nil {
			err := FilterValidationError{
				field:  "ConfigType",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetTypedConfig()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, FilterValidationError{
						field:  "TypedConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, FilterValidationError{
						field:  "TypedConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetTypedConfig()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return FilterValidationError{
					field:  "TypedConfig",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return FilterMultiError(errors)
	}

	return nil
}

// FilterMultiError is an error wrapping multiple validation errors returned by
// Filter.ValidateAll() if the designated constraints aren't met.
type FilterMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m FilterMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m FilterMultiError) AllErrors() []error { return m }

// FilterValidationError is the validation error returned by Filter.Validate if
// the designated constraints aren't met.
type FilterValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e FilterValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e FilterValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e FilterValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e FilterValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e FilterValidationError) ErrorName() string { return "FilterValidationError" }

// Error satisfies the builtin error interface
func (e FilterValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sFilter.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = FilterValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = FilterValidationError{}

// Validate checks the field values on FilterChainMatch with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *FilterChainMatch) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on FilterChainMatch with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// FilterChainMatchMultiError, or nil if none found.
func (m *FilterChainMatch) ValidateAll() error {
	return m.validate(true)
}

func (m *FilterChainMatch) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if wrapper := m.GetDestinationPort(); wrapper != nil {

		if val := wrapper.GetValue(); val < 1 || val > 65535 {
			err := FilterChainMatchValidationError{
				field:  "DestinationPort",
				reason: "value must be inside range [1, 65535]",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	for idx, item := range m.GetPrefixRanges() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, FilterChainMatchValidationError{
						field:  fmt.Sprintf("PrefixRanges[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, FilterChainMatchValidationError{
						field:  fmt.Sprintf("PrefixRanges[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return FilterChainMatchValidationError{
					field:  fmt.Sprintf("PrefixRanges[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	// no validation rules for AddressSuffix

	if all {
		switch v := interface{}(m.GetSuffixLen()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, FilterChainMatchValidationError{
					field:  "SuffixLen",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, FilterChainMatchValidationError{
					field:  "SuffixLen",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetSuffixLen()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return FilterChainMatchValidationError{
				field:  "SuffixLen",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if _, ok := FilterChainMatch_ConnectionSourceType_name[int32(m.GetSourceType())]; !ok {
		err := FilterChainMatchValidationError{
			field:  "SourceType",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetSourcePrefixRanges() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, FilterChainMatchValidationError{
						field:  fmt.Sprintf("SourcePrefixRanges[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, FilterChainMatchValidationError{
						field:  fmt.Sprintf("SourcePrefixRanges[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return FilterChainMatchValidationError{
					field:  fmt.Sprintf("SourcePrefixRanges[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetSourcePorts() {
		_, _ = idx, item

		if val := item; val < 1 || val > 65535 {
			err := FilterChainMatchValidationError{
				field:  fmt.Sprintf("SourcePorts[%v]", idx),
				reason: "value must be inside range [1, 65535]",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	// no validation rules for TransportProtocol

	if len(errors) > 0 {
		return FilterChainMatchMultiError(errors)
	}

	return nil
}

// FilterChainMatchMultiError is an error wrapping multiple validation errors
// returned by FilterChainMatch.ValidateAll() if the designated constraints
// aren't met.
type FilterChainMatchMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m FilterChainMatchMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m FilterChainMatchMultiError) AllErrors() []error { return m }

// FilterChainMatchValidationError is the validation error returned by
// FilterChainMatch.Validate if the designated constraints aren't met.
type FilterChainMatchValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e FilterChainMatchValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e FilterChainMatchValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e FilterChainMatchValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e FilterChainMatchValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e FilterChainMatchValidationError) ErrorName() string { return "FilterChainMatchValidationError" }

// Error satisfies the builtin error interface
func (e FilterChainMatchValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sFilterChainMatch.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = FilterChainMatchValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = FilterChainMatchValidationError{}

// Validate checks the field values on FilterChain with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *FilterChain) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on FilterChain with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in FilterChainMultiError, or
// nil if none found.
func (m *FilterChain) ValidateAll() error {
	return m.validate(true)
}

func (m *FilterChain) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetFilterChainMatch()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, FilterChainValidationError{
					field:  "FilterChainMatch",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, FilterChainValidationError{
					field:  "FilterChainMatch",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetFilterChainMatch()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return FilterChainValidationError{
				field:  "FilterChainMatch",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetTlsContext()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, FilterChainValidationError{
					field:  "TlsContext",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, FilterChainValidationError{
					field:  "TlsContext",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTlsContext()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return FilterChainValidationError{
				field:  "TlsContext",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetFilters() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, FilterChainValidationError{
						field:  fmt.Sprintf("Filters[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, FilterChainValidationError{
						field:  fmt.Sprintf("Filters[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return FilterChainValidationError{
					field:  fmt.Sprintf("Filters[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if all {
		switch v := interface{}(m.GetUseProxyProto()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, FilterChainValidationError{
					field:  "UseProxyProto",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, FilterChainValidationError{
					field:  "UseProxyProto",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetUseProxyProto()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return FilterChainValidationError{
				field:  "UseProxyProto",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetMetadata()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, FilterChainValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, FilterChainValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMetadata()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return FilterChainValidationError{
				field:  "Metadata",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetTransportSocket()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, FilterChainValidationError{
					field:  "TransportSocket",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, FilterChainValidationError{
					field:  "TransportSocket",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTransportSocket()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return FilterChainValidationError{
				field:  "TransportSocket",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for Name

	if len(errors) > 0 {
		return FilterChainMultiError(errors)
	}

	return nil
}

// FilterChainMultiError is an error wrapping multiple validation errors
// returned by FilterChain.ValidateAll() if the designated constraints aren't met.
type FilterChainMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m FilterChainMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m FilterChainMultiError) AllErrors() []error { return m }

// FilterChainValidationError is the validation error returned by
// FilterChain.Validate if the designated constraints aren't met.
type FilterChainValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e FilterChainValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e FilterChainValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e FilterChainValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e FilterChainValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e FilterChainValidationError) ErrorName() string { return "FilterChainValidationError" }

// Error satisfies the builtin error interface
func (e FilterChainValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sFilterChain.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = FilterChainValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = FilterChainValidationError{}

// Validate checks the field values on ListenerFilterChainMatchPredicate with
// the rules defined in the proto definition for this message. If any rules
// are violated, the first error encountered is returned, or nil if there are
// no violations.
func (m *ListenerFilterChainMatchPredicate) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ListenerFilterChainMatchPredicate
// with the rules defined in the proto definition for this message. If any
// rules are violated, the result is a list of violation errors wrapped in
// ListenerFilterChainMatchPredicateMultiError, or nil if none found.
func (m *ListenerFilterChainMatchPredicate) ValidateAll() error {
	return m.validate(true)
}

func (m *ListenerFilterChainMatchPredicate) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	oneofRulePresent := false
	switch v := m.Rule.(type) {
	case *ListenerFilterChainMatchPredicate_OrMatch:
		if v == nil {
			err := ListenerFilterChainMatchPredicateValidationError{
				field:  "Rule",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofRulePresent = true

		if all {
			switch v := interface{}(m.GetOrMatch()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ListenerFilterChainMatchPredicateValidationError{
						field:  "OrMatch",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ListenerFilterChainMatchPredicateValidationError{
						field:  "OrMatch",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetOrMatch()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ListenerFilterChainMatchPredicateValidationError{
					field:  "OrMatch",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *ListenerFilterChainMatchPredicate_AndMatch:
		if v == nil {
			err := ListenerFilterChainMatchPredicateValidationError{
				field:  "Rule",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofRulePresent = true

		if all {
			switch v := interface{}(m.GetAndMatch()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ListenerFilterChainMatchPredicateValidationError{
						field:  "AndMatch",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ListenerFilterChainMatchPredicateValidationError{
						field:  "AndMatch",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetAndMatch()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ListenerFilterChainMatchPredicateValidationError{
					field:  "AndMatch",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *ListenerFilterChainMatchPredicate_NotMatch:
		if v == nil {
			err := ListenerFilterChainMatchPredicateValidationError{
				field:  "Rule",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofRulePresent = true

		if all {
			switch v := interface{}(m.GetNotMatch()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ListenerFilterChainMatchPredicateValidationError{
						field:  "NotMatch",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ListenerFilterChainMatchPredicateValidationError{
						field:  "NotMatch",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetNotMatch()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ListenerFilterChainMatchPredicateValidationError{
					field:  "NotMatch",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *ListenerFilterChainMatchPredicate_AnyMatch:
		if v == nil {
			err := ListenerFilterChainMatchPredicateValidationError{
				field:  "Rule",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofRulePresent = true

		if m.GetAnyMatch() != true {
			err := ListenerFilterChainMatchPredicateValidationError{
				field:  "AnyMatch",
				reason: "value must equal true",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	case *ListenerFilterChainMatchPredicate_DestinationPortRange:
		if v == nil {
			err := ListenerFilterChainMatchPredicateValidationError{
				field:  "Rule",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofRulePresent = true

		if all {
			switch v := interface{}(m.GetDestinationPortRange()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ListenerFilterChainMatchPredicateValidationError{
						field:  "DestinationPortRange",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ListenerFilterChainMatchPredicateValidationError{
						field:  "DestinationPortRange",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetDestinationPortRange()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ListenerFilterChainMatchPredicateValidationError{
					field:  "DestinationPortRange",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofRulePresent {
		err := ListenerFilterChainMatchPredicateValidationError{
			field:  "Rule",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return ListenerFilterChainMatchPredicateMultiError(errors)
	}

	return nil
}

// ListenerFilterChainMatchPredicateMultiError is an error wrapping multiple
// validation errors returned by
// ListenerFilterChainMatchPredicate.ValidateAll() if the designated
// constraints aren't met.
type ListenerFilterChainMatchPredicateMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ListenerFilterChainMatchPredicateMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ListenerFilterChainMatchPredicateMultiError) AllErrors() []error { return m }

// ListenerFilterChainMatchPredicateValidationError is the validation error
// returned by ListenerFilterChainMatchPredicate.Validate if the designated
// constraints aren't met.
type ListenerFilterChainMatchPredicateValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListenerFilterChainMatchPredicateValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListenerFilterChainMatchPredicateValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListenerFilterChainMatchPredicateValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListenerFilterChainMatchPredicateValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListenerFilterChainMatchPredicateValidationError) ErrorName() string {
	return "ListenerFilterChainMatchPredicateValidationError"
}

// Error satisfies the builtin error interface
func (e ListenerFilterChainMatchPredicateValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListenerFilterChainMatchPredicate.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListenerFilterChainMatchPredicateValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListenerFilterChainMatchPredicateValidationError{}

// Validate checks the field values on ListenerFilter with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *ListenerFilter) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ListenerFilter with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in ListenerFilterMultiError,
// or nil if none found.
func (m *ListenerFilter) ValidateAll() error {
	return m.validate(true)
}

func (m *ListenerFilter) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetName()) < 1 {
		err := ListenerFilterValidationError{
			field:  "Name",
			reason: "value length must be at least 1 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetFilterDisabled()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ListenerFilterValidationError{
					field:  "FilterDisabled",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ListenerFilterValidationError{
					field:  "FilterDisabled",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetFilterDisabled()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ListenerFilterValidationError{
				field:  "FilterDisabled",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	switch v := m.ConfigType.(type) {
	case *ListenerFilter_Config:
		if v == nil {
			err := ListenerFilterValidationError{
				field:  "ConfigType",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetConfig()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ListenerFilterValidationError{
						field:  "Config",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ListenerFilterValidationError{
						field:  "Config",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetConfig()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ListenerFilterValidationError{
					field:  "Config",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *ListenerFilter_TypedConfig:
		if v == nil {
			err := ListenerFilterValidationError{
				field:  "ConfigType",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetTypedConfig()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ListenerFilterValidationError{
						field:  "TypedConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ListenerFilterValidationError{
						field:  "TypedConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetTypedConfig()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ListenerFilterValidationError{
					field:  "TypedConfig",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return ListenerFilterMultiError(errors)
	}

	return nil
}

// ListenerFilterMultiError is an error wrapping multiple validation errors
// returned by ListenerFilter.ValidateAll() if the designated constraints
// aren't met.
type ListenerFilterMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ListenerFilterMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ListenerFilterMultiError) AllErrors() []error { return m }

// ListenerFilterValidationError is the validation error returned by
// ListenerFilter.Validate if the designated constraints aren't met.
type ListenerFilterValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListenerFilterValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListenerFilterValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListenerFilterValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListenerFilterValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListenerFilterValidationError) ErrorName() string { return "ListenerFilterValidationError" }

// Error satisfies the builtin error interface
func (e ListenerFilterValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListenerFilter.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListenerFilterValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListenerFilterValidationError{}

// Validate checks the field values on
// ListenerFilterChainMatchPredicate_MatchSet with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *ListenerFilterChainMatchPredicate_MatchSet) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// ListenerFilterChainMatchPredicate_MatchSet with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in
// ListenerFilterChainMatchPredicate_MatchSetMultiError, or nil if none found.
func (m *ListenerFilterChainMatchPredicate_MatchSet) ValidateAll() error {
	return m.validate(true)
}

func (m *ListenerFilterChainMatchPredicate_MatchSet) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetRules()) < 2 {
		err := ListenerFilterChainMatchPredicate_MatchSetValidationError{
			field:  "Rules",
			reason: "value must contain at least 2 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetRules() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ListenerFilterChainMatchPredicate_MatchSetValidationError{
						field:  fmt.Sprintf("Rules[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ListenerFilterChainMatchPredicate_MatchSetValidationError{
						field:  fmt.Sprintf("Rules[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ListenerFilterChainMatchPredicate_MatchSetValidationError{
					field:  fmt.Sprintf("Rules[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return ListenerFilterChainMatchPredicate_MatchSetMultiError(errors)
	}

	return nil
}

// ListenerFilterChainMatchPredicate_MatchSetMultiError is an error wrapping
// multiple validation errors returned by
// ListenerFilterChainMatchPredicate_MatchSet.ValidateAll() if the designated
// constraints aren't met.
type ListenerFilterChainMatchPredicate_MatchSetMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ListenerFilterChainMatchPredicate_MatchSetMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ListenerFilterChainMatchPredicate_MatchSetMultiError) AllErrors() []error { return m }

// ListenerFilterChainMatchPredicate_MatchSetValidationError is the validation
// error returned by ListenerFilterChainMatchPredicate_MatchSet.Validate if
// the designated constraints aren't met.
type ListenerFilterChainMatchPredicate_MatchSetValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListenerFilterChainMatchPredicate_MatchSetValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListenerFilterChainMatchPredicate_MatchSetValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListenerFilterChainMatchPredicate_MatchSetValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListenerFilterChainMatchPredicate_MatchSetValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListenerFilterChainMatchPredicate_MatchSetValidationError) ErrorName() string {
	return "ListenerFilterChainMatchPredicate_MatchSetValidationError"
}

// Error satisfies the builtin error interface
func (e ListenerFilterChainMatchPredicate_MatchSetValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListenerFilterChainMatchPredicate_MatchSet.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListenerFilterChainMatchPredicate_MatchSetValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListenerFilterChainMatchPredicate_MatchSetValidationError{}
