// Code generated by go-swagger; DO NOT EDIT.

package restapi

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
)

var (
	// SwaggerJSON embedded version of the swagger document used at generation time
	SwaggerJSON json.RawMessage
	// FlatSwaggerJSON embedded flattened version of the swagger document used at generation time
	FlatSwaggerJSON json.RawMessage
)

func init() {
	SwaggerJSON = json.RawMessage([]byte(`{
  "swagger": "2.0",
  "info": {
    "description": "This sample specification exercises external types, with both x-go-type in definitions and inlined.\n\nIt demonstrates how to use the x-go-type extension to plug external type definitions in the generated code,\nfor models (e.g. for properties, arrays or maps) or operations.\n\nNotice that x-go-type works for schemas and is not supported for simple swagger types,\nused for response headers and query \u0026 path parameters.\n",
    "title": "external types imports: external anonymous types",
    "version": "1.0"
  },
  "paths": {
    "/stream": {
      "get": {
        "responses": {
          "default": {
            "description": "Uses an external definition for an interface (e.g. io.Reader)\n\nNo validation is expected on binary format.\n",
            "schema": {
              "$ref": "#/definitions/MyReader"
            }
          }
        }
      }
    },
    "/test": {
      "get": {
        "responses": {
          "default": {
            "description": "A reference to a type already defined in the models package\n(defaults to \u003c\u003ctarget\u003e/models, defined by CLI flag --model-package).\nThe response payload is defined as: *models.Zzz\n",
            "schema": {
              "$ref": "#/definitions/Zzz"
            }
          }
        }
      },
      "put": {
        "parameters": [
          {
            "description": "A reference to a type defined in the \"fred\" package, aliased\nas \"alternate\".\n\nMyAlternate alternate.MyAlternateType\n",
            "name": "myAlternate",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/MyCustom"
            }
          }
        ],
        "responses": {
          "default": {
            "description": "A map of an aliased external package. Now the alias is \"custom\".\nThis response is defined as: map[string]custom.MyAlternateString\n",
            "schema": {
              "type": "object",
              "additionalProperties": {
                "description": "This uses the external type from an inline definition, without $ref\n",
                "type": "object",
                "x-go-type": {
                  "import": {
                    "alias": "custom",
                    "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
                  },
                  "type": "MyAlternateString"
                }
              }
            }
          }
        }
      },
      "post": {
        "parameters": [
          {
            "description": "Defines a parameter as an array of external types.\nThe body parameter is defined as []custom.MyAlternateString\n\nNo definition is generated in models.\n",
            "name": "customizedStrings",
            "in": "body",
            "schema": {
              "type": "array",
              "items": {
                "type": "string",
                "x-go-type": {
                  "import": {
                    "alias": "custom",
                    "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
                  },
                  "type": "MyAlternateString"
                }
              }
            }
          }
        ],
        "responses": {
          "default": {
            "description": "An inlined reference to an aliased external package.\nThe response is defined as map[string][]map[string]custom.MyAlternateString\n\nNo definition is generated in models.\n",
            "schema": {
              "type": "object",
              "additionalProperties": {
                "type": "array",
                "items": {
                  "type": "object",
                  "additionalProperties": {
                    "x-go-type": {
                      "import": {
                        "alias": "custom",
                        "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
                      },
                      "type": "MyAlternateString"
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  },
  "definitions": {
    "ArrayWithNoValidate": {
      "description": "A slice of NoValidateExternal external types.\n\nIf the \"noValidation\" hint is omitted in the definition above, this code won't build because ` + "`" + `http.Request` + "`" + ` has no ` + "`" + `Validate` + "`" + ` method.\n",
      "type": "array",
      "maxItems": 12,
      "uniqueItems": true,
      "items": {
        "$ref": "#/definitions/NoValidateExternal"
      }
    },
    "EmbeddedTime": {
      "description": "\nThis type demonstrates how we can embed an external type and wraps the validation.\n\nThis is especially useful if you want to reuse some types from the standard library,\nsuch as ` + "`" + `time.Time` + "`" + ` or ` + "`" + `json.RawMessage` + "`" + `.\n",
      "x-go-type": {
        "embedded": true,
        "import": {
          "package": "time"
        },
        "type": "Time"
      }
    },
    "MapOfPrimitives": {
      "description": "A map of NoValidatePrimitive external types.\n\nIf the \"noValidation\" hint is omitted in the definition above, this code won't build because ` + "`" + `time.Duration` + "`" + ` has no ` + "`" + `Validate` + "`" + ` method.\n",
      "type": "object",
      "additionalProperties": {
        "$ref": "#/definitions/NoValidatePrimitive"
      }
    },
    "MapWithNoValidate": {
      "description": "A map of NoValidateExternal external types.\n\nIf the \"noValidation\" hint is omitted in the definition above, this code won't build because ` + "`" + `http.Request` + "`" + ` has no ` + "`" + `Validate` + "`" + ` method.\n",
      "type": "object",
      "additionalProperties": {
        "$ref": "#/definitions/NoValidateExternal"
      }
    },
    "MyCustom": {
      "description": "The generated code expects this type to be already defined in the \"fred\" package.\nAn alias is used by the generated code. Aliases are convenient to avoid\nconflicts with other imports or variables in the generated code.\n",
      "type": "object",
      "x-go-type": {
        "import": {
          "alias": "alternate",
          "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
        },
        "type": "MyAlternateType"
      }
    },
    "MyCustomArray": {
      "description": "This generate an array type in models, based on the external type.\n\n[]alternate.MyAlternateType\n\nThe validation method of the external type is called by the generated array.\n",
      "type": "array",
      "items": {
        "type": "object",
        "x-go-type": {
          "import": {
            "alias": "alternate",
            "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
          },
          "type": "MyAlternateType"
        }
      }
    },
    "MyCustomArrayNullable": {
      "description": "This generate an array type in models, based on the external type.\nNotice the impact of the nullable hint (equivalent to x-nullable at the type level), to produce a slice of pointers.\n\n[]*alternate.MyAlternateType\n",
      "type": "array",
      "items": {
        "type": "object",
        "x-go-type": {
          "hints": {
            "nullable": true
          },
          "import": {
            "alias": "alternate",
            "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
          },
          "type": "MyAlternateType"
        }
      }
    },
    "MyCustomMap": {
      "description": "This generate a map type in models, based on the external type.\n\nMyCustomMap map[string]map[string]alternate.MyAlternateType\n\nThe validation method of the external type is called by the generated map.\n",
      "type": "object",
      "additionalProperties": {
        "type": "object",
        "additionalProperties": {
          "type": "object",
          "x-go-type": {
            "import": {
              "alias": "alternate",
              "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
            },
            "type": "MyAlternateType"
          }
        }
      }
    },
    "MyCustomMapNullable": {
      "description": "This generate a map type in models, based on the external type.\nNotice the impact of the x-nullable directive, to produce a map of pointers.\n\nMapNullable map[string]map[string]*alternate.MyAlternateType\n",
      "type": "object",
      "additionalProperties": {
        "type": "object",
        "additionalProperties": {
          "type": "object",
          "x-go-type": {
            "import": {
              "alias": "alternate",
              "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
            },
            "type": "MyAlternateType"
          },
          "x-nullable": true
        }
      }
    },
    "MyExtCollection": {
      "description": "This type demonstrates the import generation with name mangling\n",
      "type": "array",
      "items": {
        "$ref": "#/definitions/MyExtStruct"
      }
    },
    "MyExtStruct": {
      "description": "This type is located in a package which requires name mangling.\n",
      "x-go-type": {
        "import": {
          "package": "github.com/go-swagger/go-swagger/examples/external-types/go-ext"
        },
        "type": "MyExtType"
      }
    },
    "MyInterface": {
      "description": "This is an external type replacing the interface{} type normally generated.\n\nNo validation is called on such a type.\n\nThis demonstrates how to use hints in x-go-type: by default, the generator\nassumes a struct with some Validate method.\n\nBy providing the \"interface\" hint, validation is disabled. Notice that we don't\ngenerate pointers on interfaces.\n\nIf no hint is provided, the generate code won't compile is the MyAlternateInterface\ndoes not provide a Validate method.\n",
      "x-go-type": {
        "hints": {
          "kind": "interface"
        },
        "import": {
          "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
        },
        "type": "MyAlternateInterface"
      }
    },
    "MyInterfaceObject": {
      "description": "This object demonstrates several ways to refer to an external interface.\n\nThe generated code behaves as it is an interface{}: no pointers are generated, and no valication\nis required.\n",
      "type": "object",
      "required": [
        "iface2",
        "iface3"
      ],
      "properties": {
        "iface1": {
          "$ref": "#/definitions/MyInterface"
        },
        "iface2": {
          "description": "Demonstrates the impact of the \"interface\" hint: no validation is called on iface2,\nand no pointer is generated in spite of the \"required\" directive.\n\nThe generated object validation checks for the \"required\" directive.\n\nWithout the hint, the generator assumes a Validatable object, with pointer, which may\nnot build, depending on how the external type is defined.\n",
          "x-go-type": {
            "hints": {
              "kind": "interface"
            },
            "import": {
              "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
            },
            "type": "MyAlternateInterface"
          }
        },
        "iface3": {
          "description": "Demonstrates the impact of the \"noValidation\" hint.\n\nNotice how we avoid the generation of a pointer on the required json.RawMessage (which is a []byte)\nwith the \"nullable\" hint.\n\nNotice that the \"json\" package is automatically deconflicted from other standard imports with a distinct alias.\n",
          "x-go-type": {
            "hints": {
              "noValidation": true,
              "nullable": false
            },
            "import": {
              "package": "encoding/json"
            },
            "type": "RawMessage"
          }
        }
      }
    },
    "MyReader": {
      "description": "This is an external type replacing the io.Reader type normally generated.\n\nNo validation is called on such a type.\n",
      "type": "string",
      "format": "binary",
      "x-go-type": {
        "type": "MyStreamer"
      }
    },
    "MyReaderObject": {
      "description": "This object demonstrates several ways to refer to an external interface (here assumed akin to io.Reader).\nMarshalBinary() methods are generated. No validation is expected on binary format.",
      "type": "object",
      "properties": {
        "reader1": {
          "$ref": "#/definitions/MyReader"
        },
        "reader2": {
          "description": "In line definition of the external type.\n\nNotice that we have provided some information in the spec, so the generator\ncan infer we want it to be understood as an io.Reader, with no validation.\n",
          "type": "string",
          "format": "binary",
          "x-go-type": {
            "import": {
              "alias": "alternate",
              "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
            },
            "type": "MyAlternateStreamer"
          }
        },
        "reader3": {
          "description": "In line definition of the external type.\n\nNotice that we have provided some information in the spec, as a hint in the extension\nrather than in the type definition.\n\nSo this will be documented as an object, but the generated code knows this is a stream.\n",
          "x-go-type": {
            "hints": {
              "kind": "stream"
            },
            "import": {
              "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
            },
            "type": "MyAlternateStreamer"
          }
        }
      }
    },
    "MyTuple": {
      "description": "Demonstrates references to some external type in the context of a tuple.\n\nNotice that \"additionalItems\" is not a construct that pass swagger validation,\nbut is supported by go-swagger.\n",
      "type": "array",
      "items": [
        {
          "$ref": "#/definitions/MyType"
        },
        {
          "description": "Second element of the tuple, defined as follows.\n\nP1 *fred.MyAlternateType ` + "`" + `json:\"-\"` + "`" + ` // custom serializer\n",
          "type": "object",
          "x-go-type": {
            "import": {
              "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
            },
            "type": "MyAlternateType"
          }
        }
      ],
      "additionalItems": {
        "description": "Additional items to a tuple, from an external type.\nThis defines the following field in the tuple\n\nMyTupleItems []map[string]fred.MyAlternateType\n",
        "type": "object",
        "additionalProperties": {
          "x-go-type": {
            "import": {
              "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
            },
            "type": "MyAlternateType"
          }
        }
      }
    },
    "MyType": {
      "description": "The generated code expects this type to be already defined in the models package\n(default location when no package is specified).\n",
      "type": "object",
      "x-go-type": {
        "type": "MyType"
      }
    },
    "NoValidateExternal": {
      "description": "\nThis type demonstrates how we can disable validation for an external type.\n\nThis is useful if you want to reuse some types from the standard library and don't\nwant to resort to an embedded type.\n",
      "type": "object",
      "x-go-type": {
        "hints": {
          "noValidation": true
        },
        "import": {
          "package": "net/http"
        },
        "type": "Request"
      }
    },
    "NoValidatePrimitive": {
      "description": "\nThis type demonstrates how we can disable validation for an external primitive type.\n",
      "type": "integer",
      "x-go-type": {
        "hints": {
          "noValidation": true
        },
        "import": {
          "package": "time"
        },
        "type": "Duration"
      }
    },
    "ObjectWithNoValidate": {
      "description": "A reference to the NoValidateExternal external type.\n\nIf the \"noValidation\" hint is omitted in the definition above, this code won't build because ` + "`" + `http.Request` + "`" + ` has no ` + "`" + `Validate` + "`" + ` method.\n",
      "type": "object",
      "required": [
        "myMandatoryRequest"
      ],
      "properties": {
        "myMandatoryRequest": {
          "$ref": "#/definitions/NoValidateExternal"
        },
        "myRequest": {
          "$ref": "#/definitions/NoValidateExternal"
        }
      }
    },
    "TupleWithNoValidate": {
      "description": "A tuple of NoValidateExternal external types.\n\nIf the \"noValidation\" hint is omitted in the definition above, this code won't build because ` + "`" + `http.Request` + "`" + ` has no ` + "`" + `Validate` + "`" + ` method.\n\nNotice that \"additionalItems\" is not a construct that pass swagger validation,\nbut is supported by go-swagger.\n",
      "type": "array",
      "items": [
        {
          "$ref": "#/definitions/NoValidateExternal"
        },
        {
          "$ref": "#/definitions/NoValidateExternal"
        }
      ],
      "additionalItems": {
        "$ref": "#/definitions/NoValidateExternal"
      }
    },
    "Zzz": {
      "description": "This demonstrates variations in generated code, depending on how properties are declared.\n\nSome properties are directly based on some external type and some other define collections (slices, maps)\nof these external types.\n\nNotice the use of pointers for required properties, but not for slices or maps.\n\nIn addition, it demonstrates how pointer generation may be controlled with the nullable hint or the x-nullable extension.\n\ntype Zzz struct {\n\tBeta []MyOtherType ` + "`" + `json:\"beta\"` + "`" + `\n\tDelta MyInteger ` + "`" + `json:\"delta,omitempty\"` + "`" + `\n\tEpsilon []custom.MyAlternateType ` + "`" + `json:\"epsilon\"` + "`" + `\n\tGamma fred.MyAlternateInteger ` + "`" + `json:\"gamma,omitempty\"` + "`" + `\n\tMeta MyType ` + "`" + `json:\"meta,omitempty\"` + "`" + `\n\n\tNullableBeta []*MyOtherType ` + "`" + `json:\"nullableBeta\"` + "`" + `\n\tNullableDelta *MyInteger ` + "`" + `json:\"nullableDelta,omitempty\"` + "`" + `\n\tNullableEpsilon []*custom.MyAlternateType ` + "`" + `json:\"nullableEpsilon\"` + "`" + `\n\tNullableGamma *fred.MyAlternateInteger ` + "`" + `json:\"nullableGamma,omitempty\"` + "`" + `\n\tNullableMeta MyType ` + "`" + `json:\"nullableMeta,omitempty\"` + "`" + `\n\n\tReqBeta []MyOtherType ` + "`" + `json:\"reqBeta\"` + "`" + `\n\tReqDelta *MyInteger ` + "`" + `json:\"reqDelta\"` + "`" + `\n\tReqEpsilon []custom.MyAlternateType ` + "`" + `json:\"reqEpsilon\"` + "`" + `\n\tReqGamma *fred.MyAlternateInteger ` + "`" + `json:\"reqGamma\"` + "`" + `\n\tReqMeta *MyType ` + "`" + `json:\"reqMeta\"` + "`" + `\n}\n",
      "type": "object",
      "required": [
        "reqBeta",
        "reqDelta",
        "reqGamma",
        "reqEpsilon",
        "reqMeta"
      ],
      "properties": {
        "beta": {
          "description": "This property defines an array of external types (in the same package).\n\n[]MyOtherType\n\nThe maxItems validation is generated and the external validation is called for every item.\n",
          "type": "array",
          "maxItems": 15,
          "items": {
            "type": "object",
            "x-go-type": {
              "type": "MyOtherType"
            }
          }
        },
        "delta": {
          "description": "A type is provided (integer), and the implementation is an external type in the same package.\n\nThe maximum validation remains documentary and is ignored by the generated code.\n",
          "type": "integer",
          "maximum": 15,
          "x-go-type": {
            "type": "MyInteger"
          }
        },
        "epsilon": {
          "type": "array",
          "items": {
            "type": "object",
            "x-go-type": {
              "import": {
                "alias": "custom",
                "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
              },
              "type": "MyAlternateType"
            }
          }
        },
        "gamma": {
          "description": "Property defined as an external type from package \"fred\"\n",
          "x-go-type": {
            "import": {
              "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
            },
            "type": "MyAlternateInteger"
          }
        },
        "meta": {
          "$ref": "#/definitions/MyType"
        },
        "nullableBeta": {
          "description": "This property defines an array of external types (in the same package).\n\n[]MyOtherType\n\nThe maxItems validation is generated and the external validation is called for every item.\n",
          "type": "array",
          "maxItems": 15,
          "items": {
            "type": "object",
            "x-go-type": {
              "hints": {
                "nullable": true
              },
              "type": "MyOtherType"
            }
          }
        },
        "nullableDelta": {
          "description": "A type is provided (integer), and the implementation is an external type in the same package.\n\nThe maximum validation remains documentary and is ignored by the generated code.\n\nNullableDelta *MyInteger\n",
          "type": "integer",
          "maximum": 15,
          "x-go-type": {
            "type": "MyInteger"
          },
          "x-nullable": true
        },
        "nullableEpsilon": {
          "description": "In this example, items are made nullable.\n\nNullableEpsilon []*custom.MyAlternateType ` + "`" + `json:\"nullableEpsilon\"` + "`" + `\n",
          "type": "array",
          "items": {
            "type": "object",
            "x-go-type": {
              "import": {
                "alias": "custom",
                "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
              },
              "type": "MyAlternateType"
            },
            "x-nullable": true
          }
        },
        "nullableGamma": {
          "description": "Property defined as an external type from package \"fred\", with a nullable hint for the\nexternal type.\n\nNullableGamma *fred.MyAlternateInteger ` + "`" + `json:\"nullableGamma,omitempty\"` + "`" + `\n",
          "x-go-type": {
            "hints": {
              "nullable": true
            },
            "import": {
              "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
            },
            "type": "MyAlternateInteger"
          }
        },
        "nullableMeta": {
          "x-nullable": true,
          "$ref": "#/definitions/MyType"
        },
        "reqBeta": {
          "type": "array",
          "items": {
            "type": "object",
            "x-go-type": {
              "type": "MyOtherType"
            }
          }
        },
        "reqDelta": {
          "type": "integer",
          "x-go-type": {
            "type": "MyInteger"
          }
        },
        "reqEpsilon": {
          "type": "array",
          "items": {
            "type": "object",
            "x-go-type": {
              "import": {
                "alias": "custom",
                "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
              },
              "type": "MyAlternateType"
            }
          }
        },
        "reqGamma": {
          "x-go-type": {
            "import": {
              "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
            },
            "type": "MyAlternateInteger"
          }
        },
        "reqMeta": {
          "$ref": "#/definitions/MyType"
        }
      }
    }
  }
}`))
	FlatSwaggerJSON = json.RawMessage([]byte(`{
  "swagger": "2.0",
  "info": {
    "description": "This sample specification exercises external types, with both x-go-type in definitions and inlined.\n\nIt demonstrates how to use the x-go-type extension to plug external type definitions in the generated code,\nfor models (e.g. for properties, arrays or maps) or operations.\n\nNotice that x-go-type works for schemas and is not supported for simple swagger types,\nused for response headers and query \u0026 path parameters.\n",
    "title": "external types imports: external anonymous types",
    "version": "1.0"
  },
  "paths": {
    "/stream": {
      "get": {
        "responses": {
          "default": {
            "description": "Uses an external definition for an interface (e.g. io.Reader)\n\nNo validation is expected on binary format.\n",
            "schema": {
              "$ref": "#/definitions/MyReader"
            }
          }
        }
      }
    },
    "/test": {
      "get": {
        "responses": {
          "default": {
            "description": "A reference to a type already defined in the models package\n(defaults to \u003c\u003ctarget\u003e/models, defined by CLI flag --model-package).\nThe response payload is defined as: *models.Zzz\n",
            "schema": {
              "$ref": "#/definitions/Zzz"
            }
          }
        }
      },
      "put": {
        "parameters": [
          {
            "description": "A reference to a type defined in the \"fred\" package, aliased\nas \"alternate\".\n\nMyAlternate alternate.MyAlternateType\n",
            "name": "myAlternate",
            "in": "body",
            "required": true,
            "schema": {
              "$ref": "#/definitions/MyCustom"
            }
          }
        ],
        "responses": {
          "default": {
            "description": "A map of an aliased external package. Now the alias is \"custom\".\nThis response is defined as: map[string]custom.MyAlternateString\n",
            "schema": {
              "type": "object",
              "additionalProperties": {
                "description": "This uses the external type from an inline definition, without $ref\n",
                "type": "object",
                "x-go-type": {
                  "import": {
                    "alias": "custom",
                    "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
                  },
                  "type": "MyAlternateString"
                }
              }
            }
          }
        }
      },
      "post": {
        "parameters": [
          {
            "description": "Defines a parameter as an array of external types.\nThe body parameter is defined as []custom.MyAlternateString\n\nNo definition is generated in models.\n",
            "name": "customizedStrings",
            "in": "body",
            "schema": {
              "type": "array",
              "items": {
                "type": "string",
                "x-go-type": {
                  "import": {
                    "alias": "custom",
                    "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
                  },
                  "type": "MyAlternateString"
                }
              }
            }
          }
        ],
        "responses": {
          "default": {
            "description": "An inlined reference to an aliased external package.\nThe response is defined as map[string][]map[string]custom.MyAlternateString\n\nNo definition is generated in models.\n",
            "schema": {
              "type": "object",
              "additionalProperties": {
                "type": "array",
                "items": {
                  "type": "object",
                  "additionalProperties": {
                    "x-go-type": {
                      "import": {
                        "alias": "custom",
                        "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
                      },
                      "type": "MyAlternateString"
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  },
  "definitions": {
    "ArrayWithNoValidate": {
      "description": "A slice of NoValidateExternal external types.\n\nIf the \"noValidation\" hint is omitted in the definition above, this code won't build because ` + "`" + `http.Request` + "`" + ` has no ` + "`" + `Validate` + "`" + ` method.\n",
      "type": "array",
      "maxItems": 12,
      "uniqueItems": true,
      "items": {
        "$ref": "#/definitions/NoValidateExternal"
      }
    },
    "EmbeddedTime": {
      "description": "\nThis type demonstrates how we can embed an external type and wraps the validation.\n\nThis is especially useful if you want to reuse some types from the standard library,\nsuch as ` + "`" + `time.Time` + "`" + ` or ` + "`" + `json.RawMessage` + "`" + `.\n",
      "x-go-type": {
        "embedded": true,
        "import": {
          "package": "time"
        },
        "type": "Time"
      }
    },
    "MapOfPrimitives": {
      "description": "A map of NoValidatePrimitive external types.\n\nIf the \"noValidation\" hint is omitted in the definition above, this code won't build because ` + "`" + `time.Duration` + "`" + ` has no ` + "`" + `Validate` + "`" + ` method.\n",
      "type": "object",
      "additionalProperties": {
        "$ref": "#/definitions/NoValidatePrimitive"
      }
    },
    "MapWithNoValidate": {
      "description": "A map of NoValidateExternal external types.\n\nIf the \"noValidation\" hint is omitted in the definition above, this code won't build because ` + "`" + `http.Request` + "`" + ` has no ` + "`" + `Validate` + "`" + ` method.\n",
      "type": "object",
      "additionalProperties": {
        "$ref": "#/definitions/NoValidateExternal"
      }
    },
    "MyCustom": {
      "description": "The generated code expects this type to be already defined in the \"fred\" package.\nAn alias is used by the generated code. Aliases are convenient to avoid\nconflicts with other imports or variables in the generated code.\n",
      "type": "object",
      "x-go-type": {
        "import": {
          "alias": "alternate",
          "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
        },
        "type": "MyAlternateType"
      }
    },
    "MyCustomArray": {
      "description": "This generate an array type in models, based on the external type.\n\n[]alternate.MyAlternateType\n\nThe validation method of the external type is called by the generated array.\n",
      "type": "array",
      "items": {
        "type": "object",
        "x-go-type": {
          "import": {
            "alias": "alternate",
            "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
          },
          "type": "MyAlternateType"
        }
      }
    },
    "MyCustomArrayNullable": {
      "description": "This generate an array type in models, based on the external type.\nNotice the impact of the nullable hint (equivalent to x-nullable at the type level), to produce a slice of pointers.\n\n[]*alternate.MyAlternateType\n",
      "type": "array",
      "items": {
        "type": "object",
        "x-go-type": {
          "hints": {
            "nullable": true
          },
          "import": {
            "alias": "alternate",
            "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
          },
          "type": "MyAlternateType"
        }
      }
    },
    "MyCustomMap": {
      "description": "This generate a map type in models, based on the external type.\n\nMyCustomMap map[string]map[string]alternate.MyAlternateType\n\nThe validation method of the external type is called by the generated map.\n",
      "type": "object",
      "additionalProperties": {
        "type": "object",
        "additionalProperties": {
          "type": "object",
          "x-go-type": {
            "import": {
              "alias": "alternate",
              "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
            },
            "type": "MyAlternateType"
          }
        }
      }
    },
    "MyCustomMapNullable": {
      "description": "This generate a map type in models, based on the external type.\nNotice the impact of the x-nullable directive, to produce a map of pointers.\n\nMapNullable map[string]map[string]*alternate.MyAlternateType\n",
      "type": "object",
      "additionalProperties": {
        "type": "object",
        "additionalProperties": {
          "type": "object",
          "x-go-type": {
            "import": {
              "alias": "alternate",
              "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
            },
            "type": "MyAlternateType"
          },
          "x-nullable": true
        }
      }
    },
    "MyExtCollection": {
      "description": "This type demonstrates the import generation with name mangling\n",
      "type": "array",
      "items": {
        "$ref": "#/definitions/MyExtStruct"
      }
    },
    "MyExtStruct": {
      "description": "This type is located in a package which requires name mangling.\n",
      "x-go-type": {
        "import": {
          "package": "github.com/go-swagger/go-swagger/examples/external-types/go-ext"
        },
        "type": "MyExtType"
      }
    },
    "MyInterface": {
      "description": "This is an external type replacing the interface{} type normally generated.\n\nNo validation is called on such a type.\n\nThis demonstrates how to use hints in x-go-type: by default, the generator\nassumes a struct with some Validate method.\n\nBy providing the \"interface\" hint, validation is disabled. Notice that we don't\ngenerate pointers on interfaces.\n\nIf no hint is provided, the generate code won't compile is the MyAlternateInterface\ndoes not provide a Validate method.\n",
      "x-go-type": {
        "hints": {
          "kind": "interface"
        },
        "import": {
          "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
        },
        "type": "MyAlternateInterface"
      }
    },
    "MyInterfaceObject": {
      "description": "This object demonstrates several ways to refer to an external interface.\n\nThe generated code behaves as it is an interface{}: no pointers are generated, and no valication\nis required.\n",
      "type": "object",
      "required": [
        "iface2",
        "iface3"
      ],
      "properties": {
        "iface1": {
          "$ref": "#/definitions/MyInterface"
        },
        "iface2": {
          "description": "Demonstrates the impact of the \"interface\" hint: no validation is called on iface2,\nand no pointer is generated in spite of the \"required\" directive.\n\nThe generated object validation checks for the \"required\" directive.\n\nWithout the hint, the generator assumes a Validatable object, with pointer, which may\nnot build, depending on how the external type is defined.\n",
          "x-go-type": {
            "hints": {
              "kind": "interface"
            },
            "import": {
              "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
            },
            "type": "MyAlternateInterface"
          }
        },
        "iface3": {
          "description": "Demonstrates the impact of the \"noValidation\" hint.\n\nNotice how we avoid the generation of a pointer on the required json.RawMessage (which is a []byte)\nwith the \"nullable\" hint.\n\nNotice that the \"json\" package is automatically deconflicted from other standard imports with a distinct alias.\n",
          "x-go-type": {
            "hints": {
              "noValidation": true,
              "nullable": false
            },
            "import": {
              "package": "encoding/json"
            },
            "type": "RawMessage"
          }
        }
      }
    },
    "MyReader": {
      "description": "This is an external type replacing the io.Reader type normally generated.\n\nNo validation is called on such a type.\n",
      "type": "string",
      "format": "binary",
      "x-go-type": {
        "type": "MyStreamer"
      }
    },
    "MyReaderObject": {
      "description": "This object demonstrates several ways to refer to an external interface (here assumed akin to io.Reader).\nMarshalBinary() methods are generated. No validation is expected on binary format.",
      "type": "object",
      "properties": {
        "reader1": {
          "$ref": "#/definitions/MyReader"
        },
        "reader2": {
          "description": "In line definition of the external type.\n\nNotice that we have provided some information in the spec, so the generator\ncan infer we want it to be understood as an io.Reader, with no validation.\n",
          "type": "string",
          "format": "binary",
          "x-go-type": {
            "import": {
              "alias": "alternate",
              "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
            },
            "type": "MyAlternateStreamer"
          }
        },
        "reader3": {
          "description": "In line definition of the external type.\n\nNotice that we have provided some information in the spec, as a hint in the extension\nrather than in the type definition.\n\nSo this will be documented as an object, but the generated code knows this is a stream.\n",
          "x-go-type": {
            "hints": {
              "kind": "stream"
            },
            "import": {
              "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
            },
            "type": "MyAlternateStreamer"
          }
        }
      }
    },
    "MyTuple": {
      "description": "Demonstrates references to some external type in the context of a tuple.\n\nNotice that \"additionalItems\" is not a construct that pass swagger validation,\nbut is supported by go-swagger.\n",
      "type": "array",
      "items": [
        {
          "$ref": "#/definitions/MyType"
        },
        {
          "description": "Second element of the tuple, defined as follows.\n\nP1 *fred.MyAlternateType ` + "`" + `json:\"-\"` + "`" + ` // custom serializer\n",
          "type": "object",
          "x-go-type": {
            "import": {
              "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
            },
            "type": "MyAlternateType"
          }
        }
      ],
      "additionalItems": {
        "description": "Additional items to a tuple, from an external type.\nThis defines the following field in the tuple\n\nMyTupleItems []map[string]fred.MyAlternateType\n",
        "type": "object",
        "additionalProperties": {
          "x-go-type": {
            "import": {
              "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
            },
            "type": "MyAlternateType"
          }
        }
      }
    },
    "MyType": {
      "description": "The generated code expects this type to be already defined in the models package\n(default location when no package is specified).\n",
      "type": "object",
      "x-go-type": {
        "type": "MyType"
      }
    },
    "NoValidateExternal": {
      "description": "\nThis type demonstrates how we can disable validation for an external type.\n\nThis is useful if you want to reuse some types from the standard library and don't\nwant to resort to an embedded type.\n",
      "type": "object",
      "x-go-type": {
        "hints": {
          "noValidation": true
        },
        "import": {
          "package": "net/http"
        },
        "type": "Request"
      }
    },
    "NoValidatePrimitive": {
      "description": "\nThis type demonstrates how we can disable validation for an external primitive type.\n",
      "type": "integer",
      "x-go-type": {
        "hints": {
          "noValidation": true
        },
        "import": {
          "package": "time"
        },
        "type": "Duration"
      }
    },
    "ObjectWithNoValidate": {
      "description": "A reference to the NoValidateExternal external type.\n\nIf the \"noValidation\" hint is omitted in the definition above, this code won't build because ` + "`" + `http.Request` + "`" + ` has no ` + "`" + `Validate` + "`" + ` method.\n",
      "type": "object",
      "required": [
        "myMandatoryRequest"
      ],
      "properties": {
        "myMandatoryRequest": {
          "$ref": "#/definitions/NoValidateExternal"
        },
        "myRequest": {
          "$ref": "#/definitions/NoValidateExternal"
        }
      }
    },
    "TupleWithNoValidate": {
      "description": "A tuple of NoValidateExternal external types.\n\nIf the \"noValidation\" hint is omitted in the definition above, this code won't build because ` + "`" + `http.Request` + "`" + ` has no ` + "`" + `Validate` + "`" + ` method.\n\nNotice that \"additionalItems\" is not a construct that pass swagger validation,\nbut is supported by go-swagger.\n",
      "type": "array",
      "items": [
        {
          "$ref": "#/definitions/NoValidateExternal"
        },
        {
          "$ref": "#/definitions/NoValidateExternal"
        }
      ],
      "additionalItems": {
        "$ref": "#/definitions/NoValidateExternal"
      }
    },
    "Zzz": {
      "description": "This demonstrates variations in generated code, depending on how properties are declared.\n\nSome properties are directly based on some external type and some other define collections (slices, maps)\nof these external types.\n\nNotice the use of pointers for required properties, but not for slices or maps.\n\nIn addition, it demonstrates how pointer generation may be controlled with the nullable hint or the x-nullable extension.\n\ntype Zzz struct {\n\tBeta []MyOtherType ` + "`" + `json:\"beta\"` + "`" + `\n\tDelta MyInteger ` + "`" + `json:\"delta,omitempty\"` + "`" + `\n\tEpsilon []custom.MyAlternateType ` + "`" + `json:\"epsilon\"` + "`" + `\n\tGamma fred.MyAlternateInteger ` + "`" + `json:\"gamma,omitempty\"` + "`" + `\n\tMeta MyType ` + "`" + `json:\"meta,omitempty\"` + "`" + `\n\n\tNullableBeta []*MyOtherType ` + "`" + `json:\"nullableBeta\"` + "`" + `\n\tNullableDelta *MyInteger ` + "`" + `json:\"nullableDelta,omitempty\"` + "`" + `\n\tNullableEpsilon []*custom.MyAlternateType ` + "`" + `json:\"nullableEpsilon\"` + "`" + `\n\tNullableGamma *fred.MyAlternateInteger ` + "`" + `json:\"nullableGamma,omitempty\"` + "`" + `\n\tNullableMeta MyType ` + "`" + `json:\"nullableMeta,omitempty\"` + "`" + `\n\n\tReqBeta []MyOtherType ` + "`" + `json:\"reqBeta\"` + "`" + `\n\tReqDelta *MyInteger ` + "`" + `json:\"reqDelta\"` + "`" + `\n\tReqEpsilon []custom.MyAlternateType ` + "`" + `json:\"reqEpsilon\"` + "`" + `\n\tReqGamma *fred.MyAlternateInteger ` + "`" + `json:\"reqGamma\"` + "`" + `\n\tReqMeta *MyType ` + "`" + `json:\"reqMeta\"` + "`" + `\n}\n",
      "type": "object",
      "required": [
        "reqBeta",
        "reqDelta",
        "reqGamma",
        "reqEpsilon",
        "reqMeta"
      ],
      "properties": {
        "beta": {
          "description": "This property defines an array of external types (in the same package).\n\n[]MyOtherType\n\nThe maxItems validation is generated and the external validation is called for every item.\n",
          "type": "array",
          "maxItems": 15,
          "items": {
            "type": "object",
            "x-go-type": {
              "type": "MyOtherType"
            }
          }
        },
        "delta": {
          "description": "A type is provided (integer), and the implementation is an external type in the same package.\n\nThe maximum validation remains documentary and is ignored by the generated code.\n",
          "type": "integer",
          "maximum": 15,
          "x-go-type": {
            "type": "MyInteger"
          }
        },
        "epsilon": {
          "type": "array",
          "items": {
            "type": "object",
            "x-go-type": {
              "import": {
                "alias": "custom",
                "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
              },
              "type": "MyAlternateType"
            }
          }
        },
        "gamma": {
          "description": "Property defined as an external type from package \"fred\"\n",
          "x-go-type": {
            "import": {
              "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
            },
            "type": "MyAlternateInteger"
          }
        },
        "meta": {
          "$ref": "#/definitions/MyType"
        },
        "nullableBeta": {
          "description": "This property defines an array of external types (in the same package).\n\n[]MyOtherType\n\nThe maxItems validation is generated and the external validation is called for every item.\n",
          "type": "array",
          "maxItems": 15,
          "items": {
            "type": "object",
            "x-go-type": {
              "hints": {
                "nullable": true
              },
              "type": "MyOtherType"
            }
          }
        },
        "nullableDelta": {
          "description": "A type is provided (integer), and the implementation is an external type in the same package.\n\nThe maximum validation remains documentary and is ignored by the generated code.\n\nNullableDelta *MyInteger\n",
          "type": "integer",
          "maximum": 15,
          "x-go-type": {
            "type": "MyInteger"
          },
          "x-nullable": true
        },
        "nullableEpsilon": {
          "description": "In this example, items are made nullable.\n\nNullableEpsilon []*custom.MyAlternateType ` + "`" + `json:\"nullableEpsilon\"` + "`" + `\n",
          "type": "array",
          "items": {
            "type": "object",
            "x-go-type": {
              "import": {
                "alias": "custom",
                "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
              },
              "type": "MyAlternateType"
            },
            "x-nullable": true
          }
        },
        "nullableGamma": {
          "description": "Property defined as an external type from package \"fred\", with a nullable hint for the\nexternal type.\n\nNullableGamma *fred.MyAlternateInteger ` + "`" + `json:\"nullableGamma,omitempty\"` + "`" + `\n",
          "x-go-type": {
            "hints": {
              "nullable": true
            },
            "import": {
              "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
            },
            "type": "MyAlternateInteger"
          }
        },
        "nullableMeta": {
          "x-nullable": true,
          "$ref": "#/definitions/MyType"
        },
        "reqBeta": {
          "type": "array",
          "items": {
            "type": "object",
            "x-go-type": {
              "type": "MyOtherType"
            }
          }
        },
        "reqDelta": {
          "type": "integer",
          "x-go-type": {
            "type": "MyInteger"
          }
        },
        "reqEpsilon": {
          "type": "array",
          "items": {
            "type": "object",
            "x-go-type": {
              "import": {
                "alias": "custom",
                "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
              },
              "type": "MyAlternateType"
            }
          }
        },
        "reqGamma": {
          "x-go-type": {
            "import": {
              "package": "github.com/go-swagger/go-swagger/examples/external-types/fred"
            },
            "type": "MyAlternateInteger"
          }
        },
        "reqMeta": {
          "$ref": "#/definitions/MyType"
        }
      }
    }
  }
}`))
}
