# Changelog

## [v0.31.0](https://github.com/go-swagger/go-swagger/tree/v0.31.0) (2024-05-12)

[Full Changelog](https://github.com/go-swagger/go-swagger/compare/v0.30.5...v0.31.0)

**Implemented enhancements:**

- doc: refurbish doc site [\#3086](https://github.com/go-swagger/go-swagger/issues/3086)
- Diff should detect extension value changes [\#2984](https://github.com/go-swagger/go-swagger/issues/2984)
- Diff does not report on request param extensions  [\#2983](https://github.com/go-swagger/go-swagger/issues/2983)
- add support for ULID to swagger:strfmt [\#2467](https://github.com/go-swagger/go-swagger/issues/2467)
- Flatten changes case on definitions [\#2334](https://github.com/go-swagger/go-swagger/issues/2334)
- External $refs and polymorphism: models for subtypes not generated [\#1885](https://github.com/go-swagger/go-swagger/issues/1885)
- Add validation for a 'readOnly' property [\#936](https://github.com/go-swagger/go-swagger/issues/936)
- API Gateway vendor extensions? [\#659](https://github.com/go-swagger/go-swagger/issues/659)
- edit but don't overwrite configure\_xxx.go [\#397](https://github.com/go-swagger/go-swagger/issues/397)

**Fixed bugs:**

- Adding or removing a schema from response is not being recorded in the diff [\#3074](https://github.com/go-swagger/go-swagger/issues/3074)
- generating a command line : undefined: cli [\#2969](https://github.com/go-swagger/go-swagger/issues/2969)
- Adding an optional field to request body shouldn't be a breaking change [\#2962](https://github.com/go-swagger/go-swagger/issues/2962)
- Go-swagger diff runtime error when comparing schema with different response codes [\#2952](https://github.com/go-swagger/go-swagger/issues/2952)
- v0.30.4 panics during flatten [\#2919](https://github.com/go-swagger/go-swagger/issues/2919)
- Swagger Generate Server Generates `go` Code With Cycles [\#2866](https://github.com/go-swagger/go-swagger/issues/2866)
- JSON Schema in swagger API response [\#2821](https://github.com/go-swagger/go-swagger/issues/2821)
- "swagger diff" does not work with spec that has a recursive definition [\#2774](https://github.com/go-swagger/go-swagger/issues/2774)
- request Content-Type isn't multipart/form-data [\#2773](https://github.com/go-swagger/go-swagger/issues/2773)
- fields named like "+1" cause swagger to fail gnerating a cli [\#2764](https://github.com/go-swagger/go-swagger/issues/2764)
- Flatten stopped processing nested directories in v0.26.0 [\#2743](https://github.com/go-swagger/go-swagger/issues/2743)
- Wrong import path generated for an operation called "client" [\#2730](https://github.com/go-swagger/go-swagger/issues/2730)
- New lines in description create incorrect markdown [\#2700](https://github.com/go-swagger/go-swagger/issues/2700)
- `remove-unused` does not remove all unused definitions [\#2657](https://github.com/go-swagger/go-swagger/issues/2657)
- "swagger generate cli" generates code that does not compile  [\#2650](https://github.com/go-swagger/go-swagger/issues/2650)
- Generated code fails to call the Validate function on embedded structs resulting in incorrect validation [\#2604](https://github.com/go-swagger/go-swagger/issues/2604)
- Validation code for `maxProperties` is generated incorrectly [\#2587](https://github.com/go-swagger/go-swagger/issues/2587)
- Invalid code generated for parameters of array types with empty array as default value [\#2533](https://github.com/go-swagger/go-swagger/issues/2533)
- panic: assignment to entry in nil map [\#2527](https://github.com/go-swagger/go-swagger/issues/2527)
- Incompatible API with Helm Transitive Dependency [\#2525](https://github.com/go-swagger/go-swagger/issues/2525)
- Generate models failed after separate swagger files, maybe caused by a self-ref property of a definition in the separated swagger file [\#2346](https://github.com/go-swagger/go-swagger/issues/2346)
- "Invalid ref" error when generating server with cross-file reference when "--keep-spec-order" specified [\#2216](https://github.com/go-swagger/go-swagger/issues/2216)
- swagger generate client command fails with invalid token reference [\#1898](https://github.com/go-swagger/go-swagger/issues/1898)
- escaped parameters fail to generate the correct url path when a base path is present. [\#1083](https://github.com/go-swagger/go-swagger/issues/1083)

**Closed issues:**

- How to disable try it out option for the swagger-ui go-openapi/runtime/middleware [\#3102](https://github.com/go-swagger/go-swagger/issues/3102)
- Broken swagger:response Generation with Go 1.22.0 + 1.21.5 darwin/arm64 [\#3071](https://github.com/go-swagger/go-swagger/issues/3071)
- Install swagger server failed! [\#3067](https://github.com/go-swagger/go-swagger/issues/3067)
- Enum fields are not properly scanned \(and documented\) [\#3002](https://github.com/go-swagger/go-swagger/issues/3002)
- feat: provide SwaggerUI middleware to serve spec file [\#2988](https://github.com/go-swagger/go-swagger/issues/2988)
- Swagger generates broken code in $GOPATH [\#2982](https://github.com/go-swagger/go-swagger/issues/2982)
- wrong generated swagger.yml file when using flatten [\#2978](https://github.com/go-swagger/go-swagger/issues/2978)
- API client generation without requiring go-openapi modules [\#2976](https://github.com/go-swagger/go-swagger/issues/2976)
- API Client Generation - Strange naming of folder inside of client folder [\#2974](https://github.com/go-swagger/go-swagger/issues/2974)
- CVE-2022-4742 | CVSS Score: 9.8 | Category: CWE-1321 | A vulnerability, which was classified as critical, has been found in json-pointer. Affected by this issue is the function set of the file index.js. The manipulation leads to improperly controlled modification of object prototype attributes \('prototype pollution'\). The attack may be launched remotely. The name of the patch is 859c9984b6c407fc2d5a0a7e47c7274daa681941. It is recommended to apply a patch to fix this issue. VDB-216794 is the identifier assigned to this vulnerability. [\#2971](https://github.com/go-swagger/go-swagger/issues/2971)
- Generated server.go has default write timeout value of 60s [\#2967](https://github.com/go-swagger/go-swagger/issues/2967)
- pprof is a tool for visualization and analysis of profiling data [\#2966](https://github.com/go-swagger/go-swagger/issues/2966)
- diff result has no URL, when there is an object type array field in the schema [\#2964](https://github.com/go-swagger/go-swagger/issues/2964)
- bug: incorrect logic and missing imports [\#2939](https://github.com/go-swagger/go-swagger/issues/2939)
- swagger generate markdown doesn't respect both '--output' and '--target' [\#2938](https://github.com/go-swagger/go-swagger/issues/2938)
- Add diff support for extensions [\#2935](https://github.com/go-swagger/go-swagger/issues/2935)
- is support for generic structures？ [\#2920](https://github.com/go-swagger/go-swagger/issues/2920)
- When the response refers to a structure with the same name under a different package, only the structure of the latest structure will be generated [\#2918](https://github.com/go-swagger/go-swagger/issues/2918)
- \[Bug\] The parameters section can't be generate under go1.20 [\#2913](https://github.com/go-swagger/go-swagger/issues/2913)
- ContextValidate panics if the field is `nil` for discriminator types [\#2911](https://github.com/go-swagger/go-swagger/issues/2911)
- \[Bug?\] Swagger Flatten, Not Recognizing Nested Operations [\#2908](https://github.com/go-swagger/go-swagger/issues/2908)
- Object has no field "components", but it has \(flattening error\) [\#2903](https://github.com/go-swagger/go-swagger/issues/2903)
- Swagger docs validate failed when enums\_as\_ints=true [\#2890](https://github.com/go-swagger/go-swagger/issues/2890)
- Generation error against something that used to work ok \(2 years ago :-\) \) [\#2887](https://github.com/go-swagger/go-swagger/issues/2887)
- Docs not updated for 0.30.4 [\#2883](https://github.com/go-swagger/go-swagger/issues/2883)
- UUID regex more liberal than spec [\#2878](https://github.com/go-swagger/go-swagger/issues/2878)
- swagger flatten randomizes order in yaml output [\#2850](https://github.com/go-swagger/go-swagger/issues/2850)
- Custom server tutorials raise an error while swagger generates files [\#2833](https://github.com/go-swagger/go-swagger/issues/2833)
- Upload of large files permanently leaves files in TEMPDIR [\#2789](https://github.com/go-swagger/go-swagger/issues/2789)
- How to modify CSS / Color  using Swagger V2? [\#2788](https://github.com/go-swagger/go-swagger/issues/2788)
- the context passed to ContextValidate is not the request context [\#2748](https://github.com/go-swagger/go-swagger/issues/2748)
- minimum misspelled [\#2740](https://github.com/go-swagger/go-swagger/issues/2740)
- Documentation missing for parameters section in swagger:route [\#2719](https://github.com/go-swagger/go-swagger/issues/2719)
- Substags not provided [\#2686](https://github.com/go-swagger/go-swagger/issues/2686)
- Installation instructions are not up-to-date [\#2664](https://github.com/go-swagger/go-swagger/issues/2664)
- Problem with generate server [\#2634](https://github.com/go-swagger/go-swagger/issues/2634)
- Using minItems not generating correct validation code [\#2597](https://github.com/go-swagger/go-swagger/issues/2597)
- Generated client code prints a pointer in Error\(\) func [\#2590](https://github.com/go-swagger/go-swagger/issues/2590)
- Support for a "description" struct tag [\#2541](https://github.com/go-swagger/go-swagger/issues/2541)
- Get an error "invalid character '-' in numeric literal\n\nrequest body: " when using formData. [\#2491](https://github.com/go-swagger/go-swagger/issues/2491)
- Single Model has rogue type with no explanation [\#2254](https://github.com/go-swagger/go-swagger/issues/2254)
- Update README with a new section about OpenAPI 3.0 to avoid more questions  [\#2192](https://github.com/go-swagger/go-swagger/issues/2192)
- \[Go\] Client Generated Code: Type is incorrect [\#1850](https://github.com/go-swagger/go-swagger/issues/1850)

**Merged pull requests:**

- ci: added retries on codecov coverage report upload [\#3108](https://github.com/go-swagger/go-swagger/pull/3108) ([fredbi](https://github.com/fredbi))
- chore: Add missing favicon [\#3106](https://github.com/go-swagger/go-swagger/pull/3106) ([truescotian](https://github.com/truescotian))
- chore: use errors.New to replace fmt.Errorf with no parameters [\#3105](https://github.com/go-swagger/go-swagger/pull/3105) ([ChengenH](https://github.com/ChengenH))
- chore\(deps\): bump golang.org/x/net from 0.22.0 to 0.23.0 [\#3103](https://github.com/go-swagger/go-swagger/pull/3103) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore: fix some comments [\#3101](https://github.com/go-swagger/go-swagger/pull/3101) ([careworry](https://github.com/careworry))
- Adding support for s390x [\#3099](https://github.com/go-swagger/go-swagger/pull/3099) ([dilipgb](https://github.com/dilipgb))
- ci: try again to fix scorecard stuff [\#3097](https://github.com/go-swagger/go-swagger/pull/3097) ([fredbi](https://github.com/fredbi))
- ci: fixed scorecard analysis issue \(upgraded\) [\#3096](https://github.com/go-swagger/go-swagger/pull/3096) ([fredbi](https://github.com/fredbi))
- doc\(readme\): tidy up a shorter README [\#3095](https://github.com/go-swagger/go-swagger/pull/3095) ([fredbi](https://github.com/fredbi))
- doc: removed doc deployment on PRs [\#3092](https://github.com/go-swagger/go-swagger/pull/3092) ([fredbi](https://github.com/fredbi))
- Feat/docgen with hugo \(\#1\) [\#3088](https://github.com/go-swagger/go-swagger/pull/3088) ([fredbi](https://github.com/fredbi))
- doc\(serve\): fixed a few inacurracies in swagger serve documentation [\#3083](https://github.com/go-swagger/go-swagger/pull/3083) ([fredbi](https://github.com/fredbi))
- fix\(deps\): fixed undue go.mod replace [\#3082](https://github.com/go-swagger/go-swagger/pull/3082) ([fredbi](https://github.com/fredbi))
- chore\(go\): go-swagger and go-openapi require go.1.20 across the board [\#3081](https://github.com/go-swagger/go-swagger/pull/3081) ([fredbi](https://github.com/fredbi))
- doc: sync'ed doc source with website [\#3079](https://github.com/go-swagger/go-swagger/pull/3079) ([fredbi](https://github.com/fredbi))
- ci: reenacted codecov secret token [\#3078](https://github.com/go-swagger/go-swagger/pull/3078) ([fredbi](https://github.com/fredbi))
- ci: fixed test coverage computation [\#3077](https://github.com/go-swagger/go-swagger/pull/3077) ([fredbi](https://github.com/fredbi))
- chore\(lint\): relinted test [\#3076](https://github.com/go-swagger/go-swagger/pull/3076) ([fredbi](https://github.com/fredbi))
- record adding and removing schema from response in swagger diff \#3074 [\#3075](https://github.com/go-swagger/go-swagger/pull/3075) ([zmay2030](https://github.com/zmay2030))
- fix: fix memory pools & race issues in go-openapi/validate [\#3073](https://github.com/go-swagger/go-swagger/pull/3073) ([fredbi](https://github.com/fredbi))
- golangci-lint: enable testifylint linter [\#3068](https://github.com/go-swagger/go-swagger/pull/3068) ([mmorel-35](https://github.com/mmorel-35))
- ci: fixed up codecov project threshold config [\#3066](https://github.com/go-swagger/go-swagger/pull/3066) ([fredbi](https://github.com/fredbi))
- ci: added tolerance threshold on codecov reports [\#3065](https://github.com/go-swagger/go-swagger/pull/3065) ([fredbi](https://github.com/fredbi))
- perf\(validate\): upgrade go-openapi validate [\#3064](https://github.com/go-swagger/go-swagger/pull/3064) ([fredbi](https://github.com/fredbi))
- perf\(codegen\): reduced allocated memory [\#3063](https://github.com/go-swagger/go-swagger/pull/3063) ([fredbi](https://github.com/fredbi))
- fix\(flatten\): onboard fix for relative $ref in params&responses [\#3059](https://github.com/go-swagger/go-swagger/pull/3059) ([fredbi](https://github.com/fredbi))
- Update docs: choosing a principal [\#3058](https://github.com/go-swagger/go-swagger/pull/3058) ([ghost](https://github.com/ghost))
- chore: updated dependencies for examples [\#3057](https://github.com/go-swagger/go-swagger/pull/3057) ([fredbi](https://github.com/fredbi))
- Revert "ci: setup ossf scorecard and codql workflows" [\#3056](https://github.com/go-swagger/go-swagger/pull/3056) ([casualjim](https://github.com/casualjim))
- chore\(deps\): bump docker/metadata-action from 4.6.0 to 5.5.0 [\#3051](https://github.com/go-swagger/go-swagger/pull/3051) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): bump actions/checkout from 3.1.0 to 4.1.1 [\#3050](https://github.com/go-swagger/go-swagger/pull/3050) ([dependabot[bot]](https://github.com/apps/dependabot))
- ci: setup ossf scorecard and codql workflows [\#3049](https://github.com/go-swagger/go-swagger/pull/3049) ([mmorel-35](https://github.com/mmorel-35))
- chore\(ci\): refactored ci workflows [\#3048](https://github.com/go-swagger/go-swagger/pull/3048) ([fredbi](https://github.com/fredbi))
- fix\(cli codegen\): fixed missing imports  [\#3046](https://github.com/go-swagger/go-swagger/pull/3046) ([fredbi](https://github.com/fredbi))
- fix\(cli\): deconflicted names for variables and funcs [\#3045](https://github.com/go-swagger/go-swagger/pull/3045) ([fredbi](https://github.com/fredbi))
- fix\(markdown\): handled multi-lines blocks in descriptions [\#3044](https://github.com/go-swagger/go-swagger/pull/3044) ([fredbi](https://github.com/fredbi))
- fix\(codegen\): fixed operation package mangling when tag is v1 [\#3043](https://github.com/go-swagger/go-swagger/pull/3043) ([fredbi](https://github.com/fredbi))
- feat\(gen client\): added support to work with multiple mimes [\#3042](https://github.com/go-swagger/go-swagger/pull/3042) ([fredbi](https://github.com/fredbi))
- fix\(codegen\): fixed import conflict when tag is "client" [\#3040](https://github.com/go-swagger/go-swagger/pull/3040) ([fredbi](https://github.com/fredbi))
- chore\(go build\): removed code that requires go \< 1.19 to build [\#3038](https://github.com/go-swagger/go-swagger/pull/3038) ([fredbi](https://github.com/fredbi))
- chore\(test\): reduced the verbosity of tests [\#3037](https://github.com/go-swagger/go-swagger/pull/3037) ([fredbi](https://github.com/fredbi))
- doc: sync'ed markdown source with addition to HTML site [\#3036](https://github.com/go-swagger/go-swagger/pull/3036) ([fredbi](https://github.com/fredbi))
- fix\(validations\): fixed missing validation in embedded structs [\#3034](https://github.com/go-swagger/go-swagger/pull/3034) ([fredbi](https://github.com/fredbi))
- fix\(validations\): fixed MinProperties/MaxProperties [\#3033](https://github.com/go-swagger/go-swagger/pull/3033) ([fredbi](https://github.com/fredbi))
- fix\(strfmt\): stricter UUID validation [\#3032](https://github.com/go-swagger/go-swagger/pull/3032) ([fredbi](https://github.com/fredbi))
- feat\(validation\): added --rooted-error-path to generate models [\#3031](https://github.com/go-swagger/go-swagger/pull/3031) ([fredbi](https://github.com/fredbi))
- fixed client generation test re sensitiveness to GOPATH [\#3030](https://github.com/go-swagger/go-swagger/pull/3030) ([fredbi](https://github.com/fredbi))
- test\(client\): added dynamic test to assert path params [\#3029](https://github.com/go-swagger/go-swagger/pull/3029) ([fredbi](https://github.com/fredbi))
- chore: checkpoint - regenerating examples [\#3028](https://github.com/go-swagger/go-swagger/pull/3028) ([fredbi](https://github.com/fredbi))
- doc\(example\): fixed doc for custom-server example [\#3027](https://github.com/go-swagger/go-swagger/pull/3027) ([fredbi](https://github.com/fredbi))
- fix: follow-up on \#3019 - fixed templates [\#3026](https://github.com/go-swagger/go-swagger/pull/3026) ([fredbi](https://github.com/fredbi))
- fix\(flatten\): flatten should remove unused models recursively [\#3025](https://github.com/go-swagger/go-swagger/pull/3025) ([fredbi](https://github.com/fredbi))
- fix\(mangling\): fixes name mangling in the presence of a special character [\#3024](https://github.com/go-swagger/go-swagger/pull/3024) ([fredbi](https://github.com/fredbi))
- feat\(formats\): added built-in support for ULID format [\#3023](https://github.com/go-swagger/go-swagger/pull/3023) ([fredbi](https://github.com/fredbi))
- fix\(faq\): updating doc to get swagger UI [\#3022](https://github.com/go-swagger/go-swagger/pull/3022) ([souradeepmajumdar05](https://github.com/souradeepmajumdar05))
- fix\(codegen\): fixed panic on invalid parameters in spec [\#3021](https://github.com/go-swagger/go-swagger/pull/3021) ([fredbi](https://github.com/fredbi))
- fix\(flatten\): fixed code generation with circular $ref AND expand option [\#3020](https://github.com/go-swagger/go-swagger/pull/3020) ([fredbi](https://github.com/fredbi))
- fix\(client\): alleviates issues with pointers in error reporting [\#3019](https://github.com/go-swagger/go-swagger/pull/3019) ([fredbi](https://github.com/fredbi))
- chore\(ci\): linter & ci configuration [\#3018](https://github.com/go-swagger/go-swagger/pull/3018) ([fredbi](https://github.com/fredbi))
- Use mockery V2 argument style [\#3017](https://github.com/go-swagger/go-swagger/pull/3017) ([fredbi](https://github.com/fredbi))
- fix\(codegen\): invalid token reference when referencing an extension [\#3016](https://github.com/go-swagger/go-swagger/pull/3016) ([fredbi](https://github.com/fredbi))
- fix\(flatten\): fixed panic in marshal YAML [\#3015](https://github.com/go-swagger/go-swagger/pull/3015) ([fredbi](https://github.com/fredbi))
- fix\(flatten\): added option to flatten without transforming names [\#3014](https://github.com/go-swagger/go-swagger/pull/3014) ([fredbi](https://github.com/fredbi))
- fix\(diff\): fixed diff status on added required property [\#3011](https://github.com/go-swagger/go-swagger/pull/3011) ([fredbi](https://github.com/fredbi))
- Bump golang.org/x/crypto from 0.14.0 to 0.17.0 [\#3010](https://github.com/go-swagger/go-swagger/pull/3010) ([dependabot[bot]](https://github.com/apps/dependabot))
- fix\(markdown\): added support for --target flag [\#3009](https://github.com/go-swagger/go-swagger/pull/3009) ([fredbi](https://github.com/fredbi))
- Bump golang.org/x/net from 0.10.0 to 0.17.0 [\#3008](https://github.com/go-swagger/go-swagger/pull/3008) ([dependabot[bot]](https://github.com/apps/dependabot))
- fix\(yaml\): fixed panic when MarshalYAML returns an error [\#3006](https://github.com/go-swagger/go-swagger/pull/3006) ([fredbi](https://github.com/fredbi))
- 3002 enum parse [\#3004](https://github.com/go-swagger/go-swagger/pull/3004) ([dimovnike](https://github.com/dimovnike))
- Add missing line from custom server example code [\#3001](https://github.com/go-swagger/go-swagger/pull/3001) ([kevinbarbour](https://github.com/kevinbarbour))
- enable misspell linter and fix linters [\#2992](https://github.com/go-swagger/go-swagger/pull/2992) ([mmorel-35](https://github.com/mmorel-35))
- use Go standard errors [\#2990](https://github.com/go-swagger/go-swagger/pull/2990) ([mmorel-35](https://github.com/mmorel-35))
- fix: 1\) adds supports for Diff to report on changed extension values … [\#2986](https://github.com/go-swagger/go-swagger/pull/2986) ([zmay2030](https://github.com/zmay2030))
- fix typo in zsh completion [\#2981](https://github.com/go-swagger/go-swagger/pull/2981) ([mehmetumit](https://github.com/mehmetumit))
- Feat: new client constructors wo go-openapi [\#2979](https://github.com/go-swagger/go-swagger/pull/2979) ([LukasDeco](https://github.com/LukasDeco))
- Updated to handle cases where 'body' is not present in the YAML file … [\#2973](https://github.com/go-swagger/go-swagger/pull/2973) ([Shimizu1111](https://github.com/Shimizu1111))
- Fix default write timeout value from 60s to 30s in Server struct [\#2968](https://github.com/go-swagger/go-swagger/pull/2968) ([aiwasaki126](https://github.com/aiwasaki126))
- fix: diff result has no URL, when there is an object type array field… [\#2965](https://github.com/go-swagger/go-swagger/pull/2965) ([EarthSoar](https://github.com/EarthSoar))
- Add support for x-go-custom-tag in generated parameter [\#2957](https://github.com/go-swagger/go-swagger/pull/2957) ([MAAF72](https://github.com/MAAF72))
- Support type alias when generating spec [\#2953](https://github.com/go-swagger/go-swagger/pull/2953) ([invzhi](https://github.com/invzhi))
- Fix typo in codescan/spec.go [\#2950](https://github.com/go-swagger/go-swagger/pull/2950) ([ryomak](https://github.com/ryomak))
- Update README.md with projects using go-swagger [\#2940](https://github.com/go-swagger/go-swagger/pull/2940) ([tejash-jl](https://github.com/tejash-jl))
- Fixes \#2740 - Minimum misspelled [\#2787](https://github.com/go-swagger/go-swagger/pull/2787) ([afagundes](https://github.com/afagundes))
- Add details on how to install using go install [\#2772](https://github.com/go-swagger/go-swagger/pull/2772) ([vidhill](https://github.com/vidhill))
- Fix \#2764 Allow number as field in cli generation [\#2766](https://github.com/go-swagger/go-swagger/pull/2766) ([youyuanwu](https://github.com/youyuanwu))



\* *This Changelog was automatically generated by [github_changelog_generator](https://github.com/github-changelog-generator/github-changelog-generator)*
